#    Copyright (C) 2009 Jeremy S. Sanders
#    Email: Jeremy Sanders <jeremy@jeremysanders.net>
#
#    This program is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License along
#    with this program; if not, write to the Free Software Foundation, Inc.,
#    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
##############################################################################

"""Ask user whether to import symbols."""

import veusz.qtall as qt4
import veusz.setting as setting

class SafetyImportDialog(qt4.QMessageBox):

    def __init__(self, parent, module, names):
        """Initialise dialog.

        parent is parent widget
        module is module to import symbols from
        names is a list of names to import."""

        qt4.QMessageBox.__init__(self, parent)

        self.names = names
        self.module = module

        self.setIcon(qt4.QMessageBox.Warning)
        self.setWindowTitle("Allow Python import?")
        self.setText("The document has requested that the symbol(s):\n"
                     " %s\nbe loaded from Python module '%s'.\n\n"
                     "This could be unsafe if the document comes from "
                     "an untrusted source." % (
                ', '.join(names), module))
        self.allow = self.addButton("Allow", qt4.QMessageBox.YesRole)
        self.allow.setToolTip("Allow use of symbol in module during session")
        self.allowalways = self.addButton("Allow always",
                                          qt4.QMessageBox.YesRole)
        self.allowalways.setToolTip("Always allow use of symbol in module")
        self.notallow = self.addButton("Do not allow",
                                       qt4.QMessageBox.NoRole)
        self.notallow.setToolTip("Do allow use of symbol in module in session")

    def exec_(self):
        """Execute dialog."""

        # when loading the document the busy cursor is on, this gets
        # rid of it for a while
        qt4.qApp.setOverrideCursor(qt4.QCursor(qt4.Qt.ArrowCursor))
        retn = qt4.QMessageBox.exec_(self)
        qt4.qApp.restoreOverrideCursor()

        b = self.clickedButton()

        # update lists of variables in settings depending on chosen button
        if b is self.allow:
            a = setting.transient_settings['import_allowed'][self.module]
            a |= set(self.names)
        elif b is self.allowalways:
            a = setting.settingdb['import_allowed'][self.module]
            a.update( [(x, True) for x in self.names] )
        elif b is self.notallow:
            a = setting.transient_settings['import_notallowed'][self.module]
            a |= set(self.names)
