/*
 *
 *  * Copyright (C) 2023, KylinSoft Co., Ltd.
 *  *
 *  * This program is free software: you can redistribute it and/or modify
 *  * it under the terms of the GNU General Public License as published by
 *  * the Free Software Foundation, either version 3 of the License, or
 *  * (at your option) any later version.
 *  *
 *  * This program is distributed in the hope that it will be useful,
 *  * but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  * GNU General Public License for more details.
 *  *
 *  * You should have received a copy of the GNU General Public License
 *  * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 *  *
 *  * Authors: Nicole <buxiaoqing@kylinos.cn>
 *
 */

#ifndef ALWAYSDISPLAYONPANEL_H
#define ALWAYSDISPLAYONPANEL_H

#include <QObject>
#include <QFrame>
#include <QWidget>
#include <QVBoxLayout>

#include <ukcc/interface/interface.h>
#include <ukcc/widgets/titlelabel.h>
#include <ukcc/widgets/comboxframe.h>
#include <ukcc/widgets/fixlabel.h>
#include "kswitchbutton.h"
using namespace kdk;

#define UKUI_PANEL_SETTINGS                 "org.ukui.panel.settings"
#define SHOW_TASKVIEW                       "showtaskview"
#define SHOW_NIGHTMODE                      "shownightmode"

class AlwaysDisplayonPanel : public QFrame
{
    Q_OBJECT
public:
    explicit AlwaysDisplayonPanel(QWidget *parent = nullptr);

signals:

private:
    void setFrame_Noframe(QFrame *frame);
    void displayTaskview();
    void panelBtnDisplayChanged();


    QVBoxLayout *m_alwaysDisplayonPanelLayout;

    QFrame *m_taskviewDisplayFrame;
    QHBoxLayout *m_taskviewDisplayLayout;
    QLabel *m_taskviewDisplayLabel;
    KSwitchButton *m_taskviewDisplayBtn;

    QGSettings *m_panelSettings;

private slots:

};

#endif // ALWAYSDISPLAYONPANEL_H
