/*
	SuperCollider real time audio synthesis system
 Copyright (c) 2002 James McCartney. All rights reserved.
	http://www.audiosynth.com

 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 */

//This MFCC UGen combines work by Dan Stowell (influenced also by Jamie Bullock's work on libxtract) and independent work by Nick Collins

//Mel scale based frequency warping of spectrum, powers combined discrete cosine transform (DCT-II) via brute force calculation
//see academic refs, wikipedia and http://www.fftw.org/fftw3_doc/Real-even_002fodd-DFTs-_0028cosine_002fsine-transforms_0029.html#Real-even_002fodd-DFTs-_0028cosine_002fsine-transforms_0029

#include "ML.h"
#include "FFT_UGens.h"

//The plugin could be generalised to pass alternative scale data (corresponding to Barks, ERBs and different FFT sizes etc) via a buffer
//For the moment, the data below is used and only 1024 FFT supported. For the associated Mel scale spacing generation code see the bottom of the MFCC help file

int g_startbin44100[42]= { 0, 2, 4, 5, 7, 9, 11, 13, 15, 17, 20, 23, 26, 29, 33, 36, 41, 45, 50, 55, 60, 66, 73, 80, 87, 96, 104, 114, 124, 135, 147, 159, 173, 188, 204, 221, 240, 260, 282, 305, 330, 357 };
//int g_endbin44100[42]= { 2, 3, 5, 7, 9, 11, 13, 15, 18, 21, 24, 27, 31, 34, 39, 43, 48, 53, 58, 64, 71, 78, 85, 94, 102, 112, 122, 133, 145, 157, 171, 186, 202, 219, 238, 258, 280, 303, 328, 355, 385, 416 };
//efficiency trick; one above actual endbin, allows for loop to test only < and not <=
int g_endbin44100[42]= {3, 4, 6, 8, 10, 12, 14, 16, 19, 22, 25, 28, 32, 35, 40, 44, 49, 54, 59, 65, 72, 79, 86, 95, 103, 113, 123, 134, 146, 158, 172, 187, 203, 220, 239, 259, 281, 304, 329, 356, 386, 417 };

int g_cumulindex44100[43]= { 0, 3, 5, 7, 10, 13, 16, 19, 22, 26, 31, 36, 41, 47, 53, 60, 68, 76, 85, 94, 104, 116, 129, 142, 157, 173, 190, 209, 229, 251, 274, 299, 327, 357, 389, 424, 462, 503, 547, 594, 645, 701, 760 };
float g_melbandweights44100[761]= { 0.5, 1, 0.5, 0.5, 1, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.75, 0.5, 0.25, 0.25, 0.5, 0.75, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.8, 0.6, 0.4, 0.2, 0.2, 0.4, 0.6, 0.8, 1, 0.75, 0.5, 0.25, 0.25, 0.5, 0.75, 1, 0.8, 0.6, 0.4, 0.2, 0.2, 0.4, 0.6, 0.8, 1, 0.8, 0.6, 0.4, 0.2, 0.2, 0.4, 0.6, 0.8, 1, 0.8, 0.6, 0.4, 0.2, 0.2, 0.4, 0.6, 0.8, 1, 0.83333333333333, 0.66666666666667, 0.5, 0.33333333333333, 0.16666666666667, 0.16666666666667, 0.33333333333333, 0.5, 0.66666666666667, 0.83333333333333, 1, 0.85714285714286, 0.71428571428571, 0.57142857142857, 0.42857142857143, 0.28571428571429, 0.14285714285714, 0.14285714285714, 0.28571428571429, 0.42857142857143, 0.57142857142857, 0.71428571428571, 0.85714285714286, 1, 0.85714285714286, 0.71428571428571, 0.57142857142857, 0.42857142857143, 0.28571428571429, 0.14285714285714, 0.14285714285714, 0.28571428571429, 0.42857142857143, 0.57142857142857, 0.71428571428571, 0.85714285714286, 1, 0.85714285714286, 0.71428571428571, 0.57142857142857, 0.42857142857143, 0.28571428571429, 0.14285714285714, 0.14285714285714, 0.28571428571429, 0.42857142857143, 0.57142857142857, 0.71428571428571, 0.85714285714286, 1, 0.88888888888889, 0.77777777777778, 0.66666666666667, 0.55555555555556, 0.44444444444444, 0.33333333333333, 0.22222222222222, 0.11111111111111, 0.11111111111111, 0.22222222222222, 0.33333333333333, 0.44444444444444, 0.55555555555556, 0.66666666666667, 0.77777777777778, 0.88888888888889, 1, 0.875, 0.75, 0.625, 0.5, 0.375, 0.25, 0.125, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 0.90909090909091, 0.81818181818182, 0.72727272727273, 0.63636363636364, 0.54545454545455, 0.45454545454545, 0.36363636363636, 0.27272727272727, 0.18181818181818, 0.090909090909091, 0.090909090909091, 0.18181818181818, 0.27272727272727, 0.36363636363636, 0.45454545454545, 0.54545454545455, 0.63636363636364, 0.72727272727273, 0.81818181818182, 0.90909090909091, 1, 0.91666666666667, 0.83333333333333, 0.75, 0.66666666666667, 0.58333333333333, 0.5, 0.41666666666667, 0.33333333333333, 0.25, 0.16666666666667, 0.083333333333333, 0.083333333333333, 0.16666666666667, 0.25, 0.33333333333333, 0.41666666666667, 0.5, 0.58333333333333, 0.66666666666667, 0.75, 0.83333333333333, 0.91666666666667, 1, 0.91666666666667, 0.83333333333333, 0.75, 0.66666666666667, 0.58333333333333, 0.5, 0.41666666666667, 0.33333333333333, 0.25, 0.16666666666667, 0.083333333333333, 0.083333333333333, 0.16666666666667, 0.25, 0.33333333333333, 0.41666666666667, 0.5, 0.58333333333333, 0.66666666666667, 0.75, 0.83333333333333, 0.91666666666667, 1, 0.92857142857143, 0.85714285714286, 0.78571428571429, 0.71428571428571, 0.64285714285714, 0.57142857142857, 0.5, 0.42857142857143, 0.35714285714286, 0.28571428571429, 0.21428571428571, 0.14285714285714, 0.071428571428572, 0.071428571428571, 0.14285714285714, 0.21428571428571, 0.28571428571429, 0.35714285714286, 0.42857142857143, 0.5, 0.57142857142857, 0.64285714285714, 0.71428571428571, 0.78571428571429, 0.85714285714286, 0.92857142857143, 1, 0.93333333333333, 0.86666666666667, 0.8, 0.73333333333333, 0.66666666666667, 0.6, 0.53333333333333, 0.46666666666667, 0.4, 0.33333333333333, 0.26666666666667, 0.2, 0.13333333333333, 0.066666666666667, 0.066666666666667, 0.13333333333333, 0.2, 0.26666666666667, 0.33333333333333, 0.4, 0.46666666666667, 0.53333333333333, 0.6, 0.66666666666667, 0.73333333333333, 0.8, 0.86666666666667, 0.93333333333333, 1, 0.9375, 0.875, 0.8125, 0.75, 0.6875, 0.625, 0.5625, 0.5, 0.4375, 0.375, 0.3125, 0.25, 0.1875, 0.125, 0.0625, 0.0625, 0.125, 0.1875, 0.25, 0.3125, 0.375, 0.4375, 0.5, 0.5625, 0.625, 0.6875, 0.75, 0.8125, 0.875, 0.9375, 1, 0.94117647058824, 0.88235294117647, 0.82352941176471, 0.76470588235294, 0.70588235294118, 0.64705882352941, 0.58823529411765, 0.52941176470588, 0.47058823529412, 0.41176470588235, 0.35294117647059, 0.29411764705882, 0.23529411764706, 0.17647058823529, 0.11764705882353, 0.058823529411765, 0.058823529411765, 0.11764705882353, 0.17647058823529, 0.23529411764706, 0.29411764705882, 0.35294117647059, 0.41176470588235, 0.47058823529412, 0.52941176470588, 0.58823529411765, 0.64705882352941, 0.70588235294118, 0.76470588235294, 0.82352941176471, 0.88235294117647, 0.94117647058824, 1, 0.94736842105263, 0.89473684210526, 0.84210526315789, 0.78947368421053, 0.73684210526316, 0.68421052631579, 0.63157894736842, 0.57894736842105, 0.52631578947368, 0.47368421052632, 0.42105263157895, 0.36842105263158, 0.31578947368421, 0.26315789473684, 0.21052631578947, 0.15789473684211, 0.10526315789474, 0.052631578947369, 0.052631578947368, 0.10526315789474, 0.15789473684211, 0.21052631578947, 0.26315789473684, 0.31578947368421, 0.36842105263158, 0.42105263157895, 0.47368421052632, 0.52631578947368, 0.57894736842105, 0.63157894736842, 0.68421052631579, 0.73684210526316, 0.78947368421053, 0.84210526315789, 0.89473684210526, 0.94736842105263, 1, 0.95, 0.9, 0.85, 0.8, 0.75, 0.7, 0.65, 0.6, 0.55, 0.5, 0.45, 0.4, 0.35, 0.3, 0.25, 0.2, 0.15, 0.1, 0.05, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1, 0.95454545454545, 0.90909090909091, 0.86363636363636, 0.81818181818182, 0.77272727272727, 0.72727272727273, 0.68181818181818, 0.63636363636364, 0.59090909090909, 0.54545454545455, 0.5, 0.45454545454545, 0.40909090909091, 0.36363636363636, 0.31818181818182, 0.27272727272727, 0.22727272727273, 0.18181818181818, 0.13636363636364, 0.090909090909091, 0.045454545454545, 0.045454545454545, 0.090909090909091, 0.13636363636364, 0.18181818181818, 0.22727272727273, 0.27272727272727, 0.31818181818182, 0.36363636363636, 0.40909090909091, 0.45454545454545, 0.5, 0.54545454545455, 0.59090909090909, 0.63636363636364, 0.68181818181818, 0.72727272727273, 0.77272727272727, 0.81818181818182, 0.86363636363636, 0.90909090909091, 0.95454545454545, 1, 0.95652173913043, 0.91304347826087, 0.8695652173913, 0.82608695652174, 0.78260869565217, 0.73913043478261, 0.69565217391304, 0.65217391304348, 0.60869565217391, 0.56521739130435, 0.52173913043478, 0.47826086956522, 0.43478260869565, 0.39130434782609, 0.34782608695652, 0.30434782608696, 0.26086956521739, 0.21739130434783, 0.17391304347826, 0.1304347826087, 0.08695652173913, 0.043478260869565, 0.043478260869565, 0.08695652173913, 0.1304347826087, 0.17391304347826, 0.21739130434783, 0.26086956521739, 0.30434782608696, 0.34782608695652, 0.39130434782609, 0.43478260869565, 0.47826086956522, 0.52173913043478, 0.56521739130435, 0.60869565217391, 0.65217391304348, 0.69565217391304, 0.73913043478261, 0.78260869565217, 0.82608695652174, 0.8695652173913, 0.91304347826087, 0.95652173913043, 1, 0.96, 0.92, 0.88, 0.84, 0.8, 0.76, 0.72, 0.68, 0.64, 0.6, 0.56, 0.52, 0.48, 0.44, 0.4, 0.36, 0.32, 0.28, 0.24, 0.2, 0.16, 0.12, 0.08, 0.04, 0.04, 0.08, 0.12, 0.16, 0.2, 0.24, 0.28, 0.32, 0.36, 0.4, 0.44, 0.48, 0.52, 0.56, 0.6, 0.64, 0.68, 0.72, 0.76, 0.8, 0.84, 0.88, 0.92, 0.96, 1, 0.96296296296296, 0.92592592592593, 0.88888888888889, 0.85185185185185, 0.81481481481481, 0.77777777777778, 0.74074074074074, 0.7037037037037, 0.66666666666667, 0.62962962962963, 0.59259259259259, 0.55555555555556, 0.51851851851852, 0.48148148148148, 0.44444444444444, 0.40740740740741, 0.37037037037037, 0.33333333333333, 0.2962962962963, 0.25925925925926, 0.22222222222222, 0.18518518518519, 0.14814814814815, 0.11111111111111, 0.074074074074074, 0.037037037037037, 0.037037037037037, 0.074074074074074, 0.11111111111111, 0.14814814814815, 0.18518518518519, 0.22222222222222, 0.25925925925926, 0.2962962962963, 0.33333333333333, 0.37037037037037, 0.40740740740741, 0.44444444444444, 0.48148148148148, 0.51851851851852, 0.55555555555556, 0.59259259259259, 0.62962962962963, 0.66666666666667, 0.7037037037037, 0.74074074074074, 0.77777777777778, 0.81481481481481, 0.85185185185185, 0.88888888888889, 0.92592592592593, 0.96296296296296, 1, 0.96666666666667, 0.93333333333333, 0.9, 0.86666666666667, 0.83333333333333, 0.8, 0.76666666666667, 0.73333333333333, 0.7, 0.66666666666667, 0.63333333333333, 0.6, 0.56666666666667, 0.53333333333333, 0.5, 0.46666666666667, 0.43333333333333, 0.4, 0.36666666666667, 0.33333333333333, 0.3, 0.26666666666667, 0.23333333333333, 0.2, 0.16666666666667, 0.13333333333333, 0.1, 0.066666666666667, 0.033333333333333, 0.033333333333333, 0.066666666666667, 0.1, 0.13333333333333, 0.16666666666667, 0.2, 0.23333333333333, 0.26666666666667, 0.3, 0.33333333333333, 0.36666666666667, 0.4, 0.43333333333333, 0.46666666666667, 0.5, 0.53333333333333, 0.56666666666667, 0.6, 0.63333333333333, 0.66666666666667, 0.7, 0.73333333333333, 0.76666666666667, 0.8, 0.83333333333333, 0.86666666666667, 0.9, 0.93333333333333, 0.96666666666667, 1, 0.96774193548387, 0.93548387096774, 0.90322580645161, 0.87096774193548, 0.83870967741935, 0.80645161290323, 0.7741935483871, 0.74193548387097, 0.70967741935484, 0.67741935483871, 0.64516129032258, 0.61290322580645, 0.58064516129032, 0.54838709677419, 0.51612903225806, 0.48387096774194, 0.45161290322581, 0.41935483870968, 0.38709677419355, 0.35483870967742, 0.32258064516129, 0.29032258064516, 0.25806451612903, 0.2258064516129, 0.19354838709677, 0.16129032258065, 0.12903225806452, 0.096774193548387, 0.064516129032258, 0.032258064516129 };

int g_startbin48000[42]= { 0, 2, 4, 5, 6, 8, 10, 12, 14, 16, 18, 21, 24, 27, 30, 34, 37, 41, 46, 51, 56, 61, 67, 73, 80, 88, 96, 104, 114, 124, 135, 147, 159, 173, 188, 203, 220, 239, 259, 280, 304, 328 };
//int g_endbin48000[42]= { 2, 3, 4, 6, 8, 10, 12, 14, 16, 19, 22, 25, 28, 32, 35, 39, 44, 49, 54, 59, 65, 71, 78, 86, 94, 102, 112, 122, 133, 145, 157, 171, 186, 201, 218, 237, 257, 278, 302, 326, 353, 383 };
//with efficiency trick
int g_endbin48000[42]= { 3, 4, 5, 7, 9, 11, 13, 15, 17, 20, 23, 26, 29, 33, 36, 40, 45, 50, 55, 60, 66, 72, 79, 87, 95, 103, 113, 123, 134, 146, 158, 172, 187, 202, 219, 238, 258, 279, 303, 327, 354, 384 };

int g_cumulindex48000[43]= { 0, 3, 5, 6, 8, 11, 14, 17, 20, 23, 27, 32, 37, 42, 48, 54, 60, 68, 77, 86, 95, 105, 116, 128, 142, 157, 172, 189, 208, 228, 250, 273, 298, 326, 355, 386, 421, 459, 499, 543, 590, 640, 695 };
float g_melbandweights48000[761]= { 0.5, 1, 0.5, 0.5, 1, 1, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.5, 0.5, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.75, 0.5, 0.25, 0.25, 0.5, 0.75, 1, 0.66666666666667, 0.33333333333333, 0.33333333333333, 0.66666666666667, 1, 0.75, 0.5, 0.25, 0.25, 0.5, 0.75, 1, 0.8, 0.6, 0.4, 0.2, 0.2, 0.4, 0.6, 0.8, 1, 0.8, 0.6, 0.4, 0.2, 0.2, 0.4, 0.6, 0.8, 1, 0.8, 0.6, 0.4, 0.2, 0.2, 0.4, 0.6, 0.8, 1, 0.8, 0.6, 0.4, 0.2, 0.2, 0.4, 0.6, 0.8, 1, 0.83333333333333, 0.66666666666667, 0.5, 0.33333333333333, 0.16666666666667, 0.16666666666667, 0.33333333333333, 0.5, 0.66666666666667, 0.83333333333333, 1, 0.83333333333333, 0.66666666666667, 0.5, 0.33333333333333, 0.16666666666667, 0.16666666666667, 0.33333333333333, 0.5, 0.66666666666667, 0.83333333333333, 1, 0.85714285714286, 0.71428571428571, 0.57142857142857, 0.42857142857143, 0.28571428571429, 0.14285714285714, 0.14285714285714, 0.28571428571429, 0.42857142857143, 0.57142857142857, 0.71428571428571, 0.85714285714286, 1, 0.875, 0.75, 0.625, 0.5, 0.375, 0.25, 0.125, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1, 0.875, 0.75, 0.625, 0.5, 0.375, 0.25, 0.125, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1, 0.875, 0.75, 0.625, 0.5, 0.375, 0.25, 0.125, 0.125, 0.25, 0.375, 0.5, 0.625, 0.75, 0.875, 1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1, 0.90909090909091, 0.81818181818182, 0.72727272727273, 0.63636363636364, 0.54545454545455, 0.45454545454545, 0.36363636363636, 0.27272727272727, 0.18181818181818, 0.090909090909091, 0.090909090909091, 0.18181818181818, 0.27272727272727, 0.36363636363636, 0.45454545454545, 0.54545454545455, 0.63636363636364, 0.72727272727273, 0.81818181818182, 0.90909090909091, 1, 0.91666666666667, 0.83333333333333, 0.75, 0.66666666666667, 0.58333333333333, 0.5, 0.41666666666667, 0.33333333333333, 0.25, 0.16666666666667, 0.083333333333333, 0.083333333333333, 0.16666666666667, 0.25, 0.33333333333333, 0.41666666666667, 0.5, 0.58333333333333, 0.66666666666667, 0.75, 0.83333333333333, 0.91666666666667, 1, 0.91666666666667, 0.83333333333333, 0.75, 0.66666666666667, 0.58333333333333, 0.5, 0.41666666666667, 0.33333333333333, 0.25, 0.16666666666667, 0.083333333333333, 0.083333333333333, 0.16666666666667, 0.25, 0.33333333333333, 0.41666666666667, 0.5, 0.58333333333333, 0.66666666666667, 0.75, 0.83333333333333, 0.91666666666667, 1, 0.92857142857143, 0.85714285714286, 0.78571428571429, 0.71428571428571, 0.64285714285714, 0.57142857142857, 0.5, 0.42857142857143, 0.35714285714286, 0.28571428571429, 0.21428571428571, 0.14285714285714, 0.071428571428572, 0.071428571428571, 0.14285714285714, 0.21428571428571, 0.28571428571429, 0.35714285714286, 0.42857142857143, 0.5, 0.57142857142857, 0.64285714285714, 0.71428571428571, 0.78571428571429, 0.85714285714286, 0.92857142857143, 1, 0.93333333333333, 0.86666666666667, 0.8, 0.73333333333333, 0.66666666666667, 0.6, 0.53333333333333, 0.46666666666667, 0.4, 0.33333333333333, 0.26666666666667, 0.2, 0.13333333333333, 0.066666666666667, 0.066666666666667, 0.13333333333333, 0.2, 0.26666666666667, 0.33333333333333, 0.4, 0.46666666666667, 0.53333333333333, 0.6, 0.66666666666667, 0.73333333333333, 0.8, 0.86666666666667, 0.93333333333333, 1, 0.93333333333333, 0.86666666666667, 0.8, 0.73333333333333, 0.66666666666667, 0.6, 0.53333333333333, 0.46666666666667, 0.4, 0.33333333333333, 0.26666666666667, 0.2, 0.13333333333333, 0.066666666666667, 0.066666666666667, 0.13333333333333, 0.2, 0.26666666666667, 0.33333333333333, 0.4, 0.46666666666667, 0.53333333333333, 0.6, 0.66666666666667, 0.73333333333333, 0.8, 0.86666666666667, 0.93333333333333, 1, 0.94117647058824, 0.88235294117647, 0.82352941176471, 0.76470588235294, 0.70588235294118, 0.64705882352941, 0.58823529411765, 0.52941176470588, 0.47058823529412, 0.41176470588235, 0.35294117647059, 0.29411764705882, 0.23529411764706, 0.17647058823529, 0.11764705882353, 0.058823529411765, 0.058823529411765, 0.11764705882353, 0.17647058823529, 0.23529411764706, 0.29411764705882, 0.35294117647059, 0.41176470588235, 0.47058823529412, 0.52941176470588, 0.58823529411765, 0.64705882352941, 0.70588235294118, 0.76470588235294, 0.82352941176471, 0.88235294117647, 0.94117647058824, 1, 0.94736842105263, 0.89473684210526, 0.84210526315789, 0.78947368421053, 0.73684210526316, 0.68421052631579, 0.63157894736842, 0.57894736842105, 0.52631578947368, 0.47368421052632, 0.42105263157895, 0.36842105263158, 0.31578947368421, 0.26315789473684, 0.21052631578947, 0.15789473684211, 0.10526315789474, 0.052631578947369, 0.052631578947368, 0.10526315789474, 0.15789473684211, 0.21052631578947, 0.26315789473684, 0.31578947368421, 0.36842105263158, 0.42105263157895, 0.47368421052632, 0.52631578947368, 0.57894736842105, 0.63157894736842, 0.68421052631579, 0.73684210526316, 0.78947368421053, 0.84210526315789, 0.89473684210526, 0.94736842105263, 1, 0.95, 0.9, 0.85, 0.8, 0.75, 0.7, 0.65, 0.6, 0.55, 0.5, 0.45, 0.4, 0.35, 0.3, 0.25, 0.2, 0.15, 0.1, 0.05, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1, 0.95238095238095, 0.9047619047619, 0.85714285714286, 0.80952380952381, 0.76190476190476, 0.71428571428571, 0.66666666666667, 0.61904761904762, 0.57142857142857, 0.52380952380952, 0.47619047619048, 0.42857142857143, 0.38095238095238, 0.33333333333333, 0.28571428571429, 0.23809523809524, 0.19047619047619, 0.14285714285714, 0.095238095238095, 0.047619047619048, 0.047619047619048, 0.095238095238095, 0.14285714285714, 0.19047619047619, 0.23809523809524, 0.28571428571429, 0.33333333333333, 0.38095238095238, 0.42857142857143, 0.47619047619048, 0.52380952380952, 0.57142857142857, 0.61904761904762, 0.66666666666667, 0.71428571428571, 0.76190476190476, 0.80952380952381, 0.85714285714286, 0.9047619047619, 0.95238095238095, 1, 0.95833333333333, 0.91666666666667, 0.875, 0.83333333333333, 0.79166666666667, 0.75, 0.70833333333333, 0.66666666666667, 0.625, 0.58333333333333, 0.54166666666667, 0.5, 0.45833333333333, 0.41666666666667, 0.375, 0.33333333333333, 0.29166666666667, 0.25, 0.20833333333333, 0.16666666666667, 0.125, 0.083333333333333, 0.041666666666667, 0.041666666666667, 0.083333333333333, 0.125, 0.16666666666667, 0.20833333333333, 0.25, 0.29166666666667, 0.33333333333333, 0.375, 0.41666666666667, 0.45833333333333, 0.5, 0.54166666666667, 0.58333333333333, 0.625, 0.66666666666667, 0.70833333333333, 0.75, 0.79166666666667, 0.83333333333333, 0.875, 0.91666666666667, 0.95833333333333, 1, 0.95833333333333, 0.91666666666667, 0.875, 0.83333333333333, 0.79166666666667, 0.75, 0.70833333333333, 0.66666666666667, 0.625, 0.58333333333333, 0.54166666666667, 0.5, 0.45833333333333, 0.41666666666667, 0.375, 0.33333333333333, 0.29166666666667, 0.25, 0.20833333333333, 0.16666666666667, 0.125, 0.083333333333333, 0.041666666666667, 0.041666666666667, 0.083333333333333, 0.125, 0.16666666666667, 0.20833333333333, 0.25, 0.29166666666667, 0.33333333333333, 0.375, 0.41666666666667, 0.45833333333333, 0.5, 0.54166666666667, 0.58333333333333, 0.625, 0.66666666666667, 0.70833333333333, 0.75, 0.79166666666667, 0.83333333333333, 0.875, 0.91666666666667, 0.95833333333333, 1, 0.96296296296296, 0.92592592592593, 0.88888888888889, 0.85185185185185, 0.81481481481481, 0.77777777777778, 0.74074074074074, 0.7037037037037, 0.66666666666667, 0.62962962962963, 0.59259259259259, 0.55555555555556, 0.51851851851852, 0.48148148148148, 0.44444444444444, 0.40740740740741, 0.37037037037037, 0.33333333333333, 0.2962962962963, 0.25925925925926, 0.22222222222222, 0.18518518518519, 0.14814814814815, 0.11111111111111, 0.074074074074074, 0.037037037037037, 0.037037037037037, 0.074074074074074, 0.11111111111111, 0.14814814814815, 0.18518518518519, 0.22222222222222, 0.25925925925926, 0.2962962962963, 0.33333333333333, 0.37037037037037, 0.40740740740741, 0.44444444444444, 0.48148148148148, 0.51851851851852, 0.55555555555556, 0.59259259259259, 0.62962962962963, 0.66666666666667, 0.7037037037037, 0.74074074074074, 0.77777777777778, 0.81481481481481, 0.85185185185185, 0.88888888888889, 0.92592592592593, 0.96296296296296, 1, 0.96666666666667, 0.93333333333333, 0.9, 0.86666666666667, 0.83333333333333, 0.8, 0.76666666666667, 0.73333333333333, 0.7, 0.66666666666667, 0.63333333333333, 0.6, 0.56666666666667, 0.53333333333333, 0.5, 0.46666666666667, 0.43333333333333, 0.4, 0.36666666666667, 0.33333333333333, 0.3, 0.26666666666667, 0.23333333333333, 0.2, 0.16666666666667, 0.13333333333333, 0.1, 0.066666666666667, 0.033333333333333 };


//generated in SC using:
//a= Array.fill(42, {|i| cos(pi/42.0*((0..41)+0.5)*(i+1))});
//Post << a.flatten << nl;

 //up to 42 coefficients, each with 42 multipliers for each of 42 bands
float dct[1764]=  {0.9993007047884, 0.99371220989324, 0.98256647323329, 0.96592582628907, 0.94388333030837, 0.91656225586998, 0.88411539350461, 0.84672419922828, 0.80459777976667, 0.75797172314545, 0.70710678118655, 0.65228741127812, 0.5938201855735, 0.53203207651534, 0.46726862827306, 0.39989202431974, 0.33027906195517, 0.25881904510252, 0.18591160716291, 0.11196447610331, 0.037391194276326, -0.037391194276326, -0.11196447610331, -0.18591160716291, -0.25881904510252, -0.33027906195517, -0.39989202431974, -0.46726862827306, -0.53203207651534, -0.5938201855735, -0.65228741127812, -0.70710678118655, -0.75797172314545, -0.80459777976667, -0.84672419922828, -0.88411539350461, -0.91656225586998, -0.94388333030837, -0.96592582628907, -0.98256647323329, -0.99371220989324, -0.9993007047884, 0.99720379718118, 0.97492791218182, 0.9308737486442, 0.86602540378444, 0.78183148246803, 0.68017273777092, 0.56332005806362, 0.43388373911756, 0.2947551744109, 0.14904226617617, 6.1232339957368e-17, -0.14904226617617, -0.2947551744109, -0.43388373911756, -0.56332005806362, -0.68017273777092, -0.78183148246803, -0.86602540378444, -0.9308737486442, -0.97492791218182, -0.99720379718118, -0.99720379718118, -0.97492791218182, -0.9308737486442, -0.86602540378444, -0.78183148246803, -0.68017273777092, -0.56332005806362, -0.43388373911756, -0.2947551744109, -0.14904226617617, -1.836970198721e-16, 0.14904226617617, 0.2947551744109, 0.43388373911756, 0.56332005806362, 0.68017273777092, 0.78183148246803, 0.86602540378444, 0.9308737486442, 0.97492791218182, 0.99720379718118, 0.99371220989324, 0.94388333030837, 0.84672419922828, 0.70710678118655, 0.53203207651534, 0.33027906195517, 0.11196447610331, -0.11196447610331, -0.33027906195517, -0.53203207651534, -0.70710678118655, -0.84672419922828, -0.94388333030837, -0.99371220989324, -0.99371220989324, -0.94388333030837, -0.84672419922828, -0.70710678118655, -0.53203207651534, -0.33027906195517, -0.11196447610331, 0.11196447610331, 0.33027906195517, 0.53203207651534, 0.70710678118655, 0.84672419922828, 0.94388333030837, 0.99371220989324, 0.99371220989324, 0.94388333030837, 0.84672419922828, 0.70710678118655, 0.53203207651534, 0.33027906195517, 0.11196447610331, -0.11196447610331, -0.33027906195517, -0.53203207651534, -0.70710678118655, -0.84672419922828, -0.94388333030837, -0.99371220989324, 0.98883082622513, 0.90096886790242, 0.73305187182983, 0.5, 0.22252093395631, -0.074730093586424, -0.3653410243664, -0.62348980185873, -0.82623877431599, -0.95557280578614, -1, -0.95557280578614, -0.82623877431599, -0.62348980185873, -0.36534102436639, -0.074730093586424, 0.22252093395631, 0.5, 0.73305187182983, 0.90096886790242, 0.98883082622513, 0.98883082622513, 0.90096886790242, 0.73305187182983, 0.5, 0.22252093395631, -0.074730093586424, -0.3653410243664, -0.62348980185873, -0.826238774316, -0.95557280578614, -1, -0.95557280578614, -0.82623877431599, -0.62348980185873, -0.36534102436639, -0.074730093586424, 0.22252093395631, 0.5, 0.73305187182983, 0.90096886790242, 0.98883082622513, 0.98256647323329, 0.84672419922828, 0.5938201855735, 0.25881904510252, -0.11196447610331, -0.46726862827306, -0.75797172314545, -0.94388333030837, -0.9993007047884, -0.91656225586998, -0.70710678118655, -0.39989202431974, -0.037391194276326, 0.33027906195517, 0.65228741127812, 0.88411539350461, 0.99371220989324, 0.96592582628907, 0.80459777976667, 0.53203207651534, 0.18591160716291, -0.18591160716291, -0.53203207651534, -0.80459777976667, -0.96592582628907, -0.99371220989324, -0.88411539350461, -0.65228741127812, -0.33027906195517, 0.037391194276327, 0.39989202431974, 0.70710678118655, 0.91656225586998, 0.9993007047884, 0.94388333030837, 0.75797172314545, 0.46726862827306, 0.11196447610331, -0.25881904510252, -0.5938201855735, -0.84672419922828, -0.98256647323329, 0.97492791218182, 0.78183148246803, 0.43388373911756, -1.6081226496766e-16, -0.43388373911756, -0.78183148246803, -0.97492791218182, -0.97492791218182, -0.78183148246803, -0.43388373911756, -1.836970198721e-16, 0.43388373911756, 0.78183148246803, 0.97492791218182, 0.97492791218182, 0.78183148246803, 0.43388373911756, 3.0616169978684e-16, -0.43388373911756, -0.78183148246803, -0.97492791218182, -0.97492791218182, -0.78183148246803, -0.43388373911756, 1.3477304596987e-15, 0.43388373911756, 0.78183148246803, 0.97492791218182, 0.97492791218182, 0.78183148246803, 0.43388373911756, 5.5109105961631e-16, -0.43388373911756, -0.78183148246803, -0.97492791218182, -0.97492791218182, -0.78183148246803, -0.43388373911756, 1.1028010998692e-15, 0.43388373911756, 0.78183148246803, 0.97492791218182, 0.96592582628907, 0.70710678118655, 0.25881904510252, -0.25881904510252, -0.70710678118655, -0.96592582628907, -0.96592582628907, -0.70710678118655, -0.25881904510252, 0.25881904510252, 0.70710678118655, 0.96592582628907, 0.96592582628907, 0.70710678118655, 0.25881904510252, -0.25881904510252, -0.70710678118655, -0.96592582628907, -0.96592582628907, -0.70710678118655, -0.25881904510252, 0.25881904510252, 0.70710678118655, 0.96592582628907, 0.96592582628907, 0.70710678118655, 0.25881904510252, -0.25881904510252, -0.70710678118655, -0.96592582628907, -0.96592582628907, -0.70710678118655, -0.25881904510252, 0.25881904510252, 0.70710678118655, 0.96592582628907, 0.96592582628907, 0.70710678118655, 0.25881904510252, -0.25881904510252, -0.70710678118655, -0.96592582628907, 0.95557280578614, 0.62348980185873, 0.074730093586424, -0.5, -0.90096886790242, -0.98883082622513, -0.73305187182983, -0.22252093395631, 0.3653410243664, 0.82623877431599, 1, 0.82623877431599, 0.3653410243664, -0.22252093395631, -0.73305187182983, -0.98883082622513, -0.90096886790242, -0.5, 0.074730093586425, 0.62348980185873, 0.95557280578614, 0.95557280578614, 0.62348980185873, 0.074730093586424, -0.5, -0.90096886790242, -0.98883082622513, -0.73305187182983, -0.22252093395632, 0.3653410243664, 0.826238774316, 1, 0.82623877431599, 0.36534102436639, -0.22252093395631, -0.73305187182983, -0.98883082622513, -0.90096886790242, -0.5, 0.074730093586425, 0.62348980185873, 0.95557280578614, 0.94388333030837, 0.53203207651534, -0.11196447610331, -0.70710678118655, -0.99371220989324, -0.84672419922828, -0.33027906195517, 0.33027906195517, 0.84672419922828, 0.99371220989324, 0.70710678118655, 0.11196447610331, -0.53203207651534, -0.94388333030837, -0.94388333030837, -0.53203207651534, 0.11196447610331, 0.70710678118655, 0.99371220989324, 0.84672419922828, 0.33027906195517, -0.33027906195517, -0.84672419922828, -0.99371220989324, -0.70710678118655, -0.11196447610331, 0.53203207651534, 0.94388333030837, 0.94388333030837, 0.53203207651534, -0.11196447610331, -0.70710678118655, -0.99371220989324, -0.84672419922828, -0.33027906195517, 0.33027906195517, 0.84672419922828, 0.99371220989324, 0.70710678118655, 0.11196447610331, -0.53203207651534, -0.94388333030837, 0.9308737486442, 0.43388373911756, -0.2947551744109, -0.86602540378444, -0.97492791218182, -0.56332005806362, 0.14904226617617, 0.78183148246803, 0.99720379718118, 0.68017273777092, 3.0616169978684e-16, -0.68017273777092, -0.99720379718118, -0.78183148246803, -0.14904226617617, 0.56332005806362, 0.97492791218182, 0.86602540378444, 0.2947551744109, -0.43388373911756, -0.9308737486442, -0.9308737486442, -0.43388373911756, 0.2947551744109, 0.86602540378444, 0.97492791218182, 0.56332005806362, -0.14904226617617, -0.78183148246803, -0.99720379718118, -0.68017273777092, -2.6948419387608e-15, 0.68017273777092, 0.99720379718118, 0.78183148246803, 0.14904226617617, -0.56332005806362, -0.97492791218182, -0.86602540378444, -0.2947551744109, 0.43388373911756, 0.9308737486442, 0.91656225586998, 0.33027906195517, -0.46726862827306, -0.96592582628907, -0.84672419922828, -0.18591160716291, 0.5938201855735, 0.99371220989324, 0.75797172314545, 0.037391194276326, -0.70710678118655, -0.9993007047884, -0.65228741127812, 0.11196447610331, 0.80459777976667, 0.98256647323329, 0.53203207651534, -0.25881904510252, -0.88411539350461, -0.94388333030837, -0.39989202431974, 0.39989202431974, 0.94388333030837, 0.88411539350461, 0.25881904510252, -0.53203207651534, -0.98256647323329, -0.80459777976667, -0.11196447610331, 0.65228741127812, 0.9993007047884, 0.70710678118655, -0.03739119427633, -0.75797172314545, -0.99371220989324, -0.5938201855735, 0.18591160716291, 0.84672419922828, 0.96592582628907, 0.46726862827306, -0.33027906195517, -0.91656225586998, 0.90096886790242, 0.22252093395631, -0.62348980185873, -1, -0.62348980185873, 0.22252093395631, 0.90096886790242, 0.90096886790242, 0.22252093395631, -0.62348980185873, -1, -0.62348980185873, 0.22252093395631, 0.90096886790242, 0.90096886790242, 0.22252093395631, -0.62348980185873, -1, -0.62348980185873, 0.22252093395631, 0.90096886790242, 0.90096886790242, 0.22252093395632, -0.62348980185873, -1, -0.62348980185873, 0.22252093395631, 0.90096886790242, 0.90096886790242, 0.22252093395631, -0.62348980185874, -1, -0.62348980185873, 0.22252093395632, 0.90096886790242, 0.90096886790242, 0.22252093395631, -0.62348980185874, -1, -0.62348980185873, 0.22252093395631, 0.90096886790242, 0.88411539350461, 0.11196447610331, -0.75797172314545, -0.96592582628907, -0.33027906195517, 0.5938201855735, 0.9993007047884, 0.53203207651534, -0.39989202431974, -0.98256647323329, -0.70710678118655, 0.18591160716291, 0.91656225586998, 0.84672419922828, 0.037391194276326, -0.80459777976667, -0.94388333030837, -0.25881904510252, 0.65228741127812, 0.99371220989324, 0.46726862827306, -0.46726862827306, -0.99371220989324, -0.65228741127812, 0.25881904510252, 0.94388333030837, 0.80459777976667, -0.037391194276326, -0.84672419922828, -0.91656225586998, -0.18591160716291, 0.70710678118655, 0.98256647323329, 0.39989202431974, -0.53203207651534, -0.9993007047884, -0.5938201855735, 0.33027906195516, 0.96592582628907, 0.75797172314545, -0.1119644761033, -0.88411539350461, 0.86602540378444, 6.1232339957368e-17, -0.86602540378444, -0.86602540378444, -1.836970198721e-16, 0.86602540378444, 0.86602540378444, 3.0616169978684e-16, -0.86602540378444, -0.86602540378444, -4.2862637970157e-16, 0.86602540378444, 0.86602540378444, 5.5109105961631e-16, -0.86602540378444, -0.86602540378444, -2.4499125789313e-15, 0.86602540378444, 0.86602540378444, -9.8033641995447e-16, -0.86602540378444, -0.86602540378444, -2.6948419387608e-15, 0.86602540378444, 0.86602540378444, -7.35407060125e-16, -0.86602540378444, -0.86602540378444, -2.9397712985902e-15, 0.86602540378444, 0.86602540378444, -4.9047770029553e-16, -0.86602540378444, -0.86602540378444, -3.1847006584197e-15, 0.86602540378444, 0.86602540378444, -2.4554834046606e-16, -0.86602540378444, -0.86602540378444, -3.4296300182492e-15, 0.86602540378444, 0.84672419922828, -0.11196447610331, -0.94388333030837, -0.70710678118655, 0.33027906195517, 0.99371220989324, 0.53203207651534, -0.53203207651534, -0.99371220989324, -0.33027906195517, 0.70710678118655, 0.94388333030837, 0.11196447610331, -0.84672419922828, -0.84672419922828, 0.11196447610331, 0.94388333030837, 0.70710678118655, -0.33027906195517, -0.99371220989324, -0.53203207651534, 0.53203207651534, 0.99371220989324, 0.33027906195517, -0.70710678118655, -0.94388333030837, -0.11196447610331, 0.84672419922828, 0.84672419922829, -0.11196447610331, -0.94388333030837, -0.70710678118655, 0.33027906195517, 0.99371220989324, 0.53203207651534, -0.53203207651534, -0.99371220989324, -0.33027906195517, 0.70710678118655, 0.94388333030837, 0.11196447610331, -0.84672419922829, 0.82623877431599, -0.22252093395631, -0.98883082622513, -0.5, 0.62348980185873, 0.95557280578614, 0.074730093586424, -0.90096886790242, -0.73305187182983, 0.3653410243664, 1, 0.36534102436639, -0.73305187182983, -0.90096886790242, 0.074730093586425, 0.95557280578614, 0.62348980185873, -0.5, -0.98883082622513, -0.22252093395632, 0.826238774316, 0.82623877431599, -0.22252093395631, -0.98883082622513, -0.5, 0.62348980185874, 0.95557280578614, 0.074730093586423, -0.90096886790242, -0.73305187182982, 0.3653410243664, 1, 0.36534102436639, -0.73305187182983, -0.90096886790242, 0.074730093586427, 0.95557280578614, 0.62348980185873, -0.5, -0.98883082622513, -0.22252093395632, 0.826238774316, 0.80459777976667, -0.33027906195517, -0.9993007047884, -0.25881904510252, 0.84672419922828, 0.75797172314545, -0.39989202431974, -0.99371220989324, -0.18591160716291, 0.88411539350461, 0.70710678118655, -0.46726862827306, -0.98256647323329, -0.11196447610331, 0.91656225586998, 0.65228741127812, -0.53203207651534, -0.96592582628907, -0.037391194276324, 0.94388333030837, 0.5938201855735, -0.5938201855735, -0.94388333030837, 0.037391194276326, 0.96592582628907, 0.53203207651534, -0.65228741127812, -0.91656225586998, 0.11196447610331, 0.98256647323329, 0.46726862827306, -0.70710678118655, -0.88411539350461, 0.18591160716291, 0.99371220989324, 0.39989202431973, -0.75797172314546, -0.84672419922828, 0.25881904510253, 0.9993007047884, 0.33027906195517, -0.80459777976667, 0.78183148246803, -0.43388373911756, -0.97492791218182, 7.0448139982802e-16, 0.97492791218182, 0.43388373911756, -0.78183148246803, -0.78183148246803, 0.43388373911756, 0.97492791218182, 5.5109105961631e-16, -0.97492791218182, -0.43388373911756, 0.78183148246803, 0.78183148246803, -0.43388373911756, -0.97492791218182, 8.5787174003974e-16, 0.97492791218182, 0.43388373911756, -0.78183148246803, -0.78183148246803, 0.43388373911756, 0.97492791218182, -4.9047770029553e-16, -0.97492791218182, -0.43388373911756, 0.78183148246803, 0.78183148246803, -0.43388373911756, -0.97492791218182, -3.4296300182492e-15, 0.97492791218182, 0.43388373911755, -0.78183148246803, -0.78183148246803, 0.43388373911756, 0.97492791218182, -6.8611169784081e-15, -0.97492791218182, -0.43388373911756, 0.78183148246803, 0.75797172314545, -0.53203207651534, -0.91656225586998, 0.25881904510252, 0.99371220989324, 0.037391194276326, -0.98256647323329, -0.33027906195517, 0.88411539350461, 0.5938201855735, -0.70710678118655, -0.80459777976667, 0.46726862827306, 0.94388333030837, -0.18591160716291, -0.9993007047884, -0.11196447610331, 0.96592582628907, 0.39989202431974, -0.84672419922828, -0.65228741127812, 0.65228741127812, 0.84672419922829, -0.39989202431974, -0.96592582628907, 0.11196447610331, 0.9993007047884, 0.18591160716292, -0.94388333030837, -0.46726862827306, 0.80459777976667, 0.70710678118655, -0.59382018557351, -0.88411539350461, 0.33027906195516, 0.98256647323329, -0.037391194276329, -0.99371220989324, -0.25881904510252, 0.91656225586998, 0.53203207651534, -0.75797172314546, 0.73305187182983, -0.62348980185873, -0.82623877431599, 0.5, 0.90096886790242, -0.3653410243664, -0.95557280578614, 0.22252093395631, 0.98883082622513, -0.074730093586425, -1, -0.074730093586423, 0.98883082622513, 0.22252093395632, -0.95557280578614, -0.36534102436639, 0.90096886790242, 0.5, -0.82623877431599, -0.62348980185873, 0.73305187182983, 0.73305187182983, -0.62348980185874, -0.826238774316, 0.5, 0.90096886790242, -0.36534102436639, -0.95557280578614, 0.22252093395632, 0.98883082622513, -0.074730093586424, -1, -0.07473009358642, 0.98883082622513, 0.22252093395631, -0.95557280578614, -0.3653410243664, 0.90096886790242, 0.5, -0.82623877431599, -0.62348980185873, 0.73305187182983, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118655, 0.70710678118655, 0.70710678118655, -0.70710678118655, -0.70710678118654, 0.70710678118655, 0.70710678118655, -0.70710678118655, 0.68017273777092, -0.78183148246803, -0.56332005806362, 0.86602540378444, 0.43388373911756, -0.9308737486442, -0.2947551744109, 0.97492791218182, 0.14904226617617, -0.99720379718118, -2.4499125789313e-15, 0.99720379718118, -0.14904226617617, -0.97492791218182, 0.29475517441091, 0.9308737486442, -0.43388373911756, -0.86602540378444, 0.56332005806362, 0.78183148246803, -0.68017273777092, -0.68017273777092, 0.78183148246803, 0.56332005806362, -0.86602540378444, -0.43388373911756, 0.9308737486442, 0.2947551744109, -0.97492791218182, -0.14904226617617, 0.99720379718118, 2.4431037919288e-16, -0.99720379718118, 0.14904226617618, 0.97492791218182, -0.29475517441091, -0.9308737486442, 0.43388373911756, 0.86602540378444, -0.56332005806362, -0.78183148246803, 0.68017273777092, 0.65228741127812, -0.84672419922828, -0.39989202431974, 0.96592582628907, 0.11196447610331, -0.9993007047884, 0.18591160716291, 0.94388333030837, -0.46726862827306, -0.80459777976667, 0.70710678118655, 0.5938201855735, -0.88411539350461, -0.33027906195517, 0.98256647323329, 0.037391194276325, -0.99371220989324, 0.25881904510252, 0.91656225586998, -0.53203207651534, -0.75797172314545, 0.75797172314545, 0.53203207651534, -0.91656225586998, -0.25881904510252, 0.99371220989324, -0.037391194276329, -0.98256647323329, 0.33027906195516, 0.88411539350461, -0.5938201855735, -0.70710678118655, 0.80459777976667, 0.46726862827306, -0.94388333030837, -0.18591160716291, 0.9993007047884, -0.11196447610331, -0.96592582628907, 0.39989202431974, 0.84672419922829, -0.65228741127812, 0.62348980185873, -0.90096886790242, -0.22252093395631, 1, -0.22252093395631, -0.90096886790242, 0.62348980185873, 0.62348980185873, -0.90096886790242, -0.22252093395632, 1, -0.22252093395631, -0.90096886790242, 0.62348980185873, 0.62348980185873, -0.90096886790242, -0.22252093395632, 1, -0.22252093395632, -0.90096886790242, 0.62348980185873, 0.62348980185873, -0.90096886790242, -0.22252093395632, 1, -0.22252093395632, -0.90096886790242, 0.62348980185874, 0.62348980185874, -0.90096886790242, -0.22252093395631, 1, -0.22252093395632, -0.90096886790242, 0.62348980185873, 0.62348980185873, -0.90096886790242, -0.22252093395631, 1, -0.22252093395632, -0.90096886790242, 0.62348980185874, 0.5938201855735, -0.94388333030837, -0.037391194276326, 0.96592582628907, -0.53203207651534, -0.65228741127812, 0.91656225586998, 0.11196447610331, -0.98256647323329, 0.46726862827306, 0.70710678118655, -0.88411539350461, -0.18591160716292, 0.99371220989324, -0.39989202431974, -0.75797172314545, 0.84672419922828, 0.25881904510252, -0.9993007047884, 0.33027906195516, 0.80459777976667, -0.80459777976667, -0.33027906195517, 0.9993007047884, -0.25881904510252, -0.84672419922828, 0.75797172314545, 0.39989202431974, -0.99371220989324, 0.18591160716292, 0.88411539350461, -0.70710678118655, -0.46726862827306, 0.98256647323329, -0.11196447610331, -0.91656225586997, 0.65228741127812, 0.53203207651534, -0.96592582628907, 0.037391194276331, 0.94388333030837, -0.59382018557351, 0.56332005806362, -0.97492791218182, 0.14904226617617, 0.86602540378444, -0.78183148246803, -0.2947551744109, 0.99720379718118, -0.43388373911756, -0.68017273777092, 0.9308737486442, -9.8033641995447e-16, -0.9308737486442, 0.68017273777092, 0.43388373911756, -0.99720379718118, 0.29475517441091, 0.78183148246803, -0.86602540378444, -0.14904226617617, 0.97492791218182, -0.56332005806362, -0.56332005806362, 0.97492791218182, -0.14904226617617, -0.86602540378444, 0.78183148246803, 0.2947551744109, -0.99720379718118, 0.43388373911756, 0.68017273777092, -0.93087374864421, -4.1644180977376e-15, 0.9308737486442, -0.68017273777092, -0.43388373911756, 0.99720379718118, -0.2947551744109, -0.78183148246803, 0.86602540378444, 0.14904226617617, -0.97492791218183, 0.56332005806363, 0.53203207651534, -0.99371220989324, 0.33027906195517, 0.70710678118655, -0.94388333030837, 0.11196447610331, 0.84672419922828, -0.84672419922828, -0.11196447610331, 0.94388333030837, -0.70710678118655, -0.33027906195517, 0.99371220989324, -0.53203207651534, -0.53203207651534, 0.99371220989324, -0.33027906195517, -0.70710678118655, 0.94388333030837, -0.1119644761033, -0.84672419922828, 0.84672419922828, 0.11196447610331, -0.94388333030837, 0.70710678118655, 0.33027906195516, -0.99371220989324, 0.53203207651534, 0.53203207651534, -0.99371220989324, 0.33027906195517, 0.70710678118655, -0.94388333030837, 0.11196447610331, 0.84672419922829, -0.84672419922829, -0.1119644761033, 0.94388333030837, -0.70710678118655, -0.33027906195517, 0.99371220989324, -0.53203207651534, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.50000000000001, 0.5, -1, 0.50000000000001, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.5, -1, 0.5, 0.46726862827306, -0.99371220989324, 0.65228741127812, 0.25881904510252, -0.94388333030837, 0.80459777976667, 0.037391194276326, -0.84672419922829, 0.91656225586998, -0.18591160716291, -0.70710678118655, 0.98256647323329, -0.39989202431974, -0.53203207651534, 0.9993007047884, -0.59382018557351, -0.33027906195517, 0.96592582628907, -0.75797172314546, -0.11196447610331, 0.88411539350461, -0.88411539350461, 0.11196447610331, 0.75797172314545, -0.96592582628907, 0.33027906195517, 0.5938201855735, -0.9993007047884, 0.53203207651533, 0.39989202431974, -0.98256647323329, 0.70710678118654, 0.1859116071629, -0.91656225586998, 0.84672419922828, -0.037391194276335, -0.80459777976667, 0.94388333030837, -0.25881904510253, -0.65228741127812, 0.99371220989324, -0.46726862827307, 0.43388373911756, -0.97492791218182, 0.78183148246803, -5.8201671991329e-16, -0.78183148246803, 0.97492791218182, -0.43388373911756, -0.43388373911756, 0.97492791218182, -0.78183148246803, -2.6948419387608e-15, 0.78183148246803, -0.97492791218182, 0.43388373911756, 0.43388373911755, -0.97492791218182, 0.78183148246803, -2.4554834046606e-16, -0.78183148246803, 0.97492791218182, -0.43388373911756, -0.43388373911756, 0.97492791218182, -0.78183148246803, 3.1859386196929e-15, 0.78183148246803, -0.97492791218182, 0.43388373911756, 0.43388373911756, -0.97492791218182, 0.78183148246803, 9.7909845868129e-16, -0.78183148246802, 0.97492791218182, -0.43388373911756, -0.43388373911756, 0.97492791218182, -0.78183148246802, 1.9612918205455e-15, 0.78183148246803, -0.97492791218182, 0.43388373911756, 0.39989202431974, -0.94388333030837, 0.88411539350461, -0.25881904510252, -0.53203207651534, 0.98256647323329, -0.80459777976667, 0.11196447610331, 0.65228741127812, -0.9993007047884, 0.70710678118655, 0.037391194276325, -0.75797172314545, 0.99371220989324, -0.5938201855735, -0.18591160716291, 0.84672419922829, -0.96592582628907, 0.46726862827306, 0.33027906195517, -0.91656225586998, 0.91656225586998, -0.33027906195517, -0.46726862827306, 0.96592582628907, -0.84672419922829, 0.18591160716291, 0.5938201855735, -0.99371220989324, 0.75797172314545, -0.037391194276328, -0.70710678118655, 0.9993007047884, -0.65228741127812, -0.11196447610331, 0.80459777976667, -0.98256647323329, 0.53203207651533, 0.25881904510251, -0.88411539350461, 0.94388333030837, -0.39989202431975, 0.36534102436639, -0.90096886790242, 0.95557280578614, -0.5, -0.22252093395631, 0.82623877431599, -0.98883082622513, 0.62348980185873, 0.074730093586423, -0.73305187182983, 1, -0.73305187182983, 0.074730093586424, 0.62348980185873, -0.98883082622513, 0.826238774316, -0.22252093395631, -0.5, 0.95557280578614, -0.90096886790242, 0.3653410243664, 0.36534102436639, -0.90096886790242, 0.95557280578614, -0.5, -0.22252093395631, 0.82623877431599, -0.98883082622513, 0.62348980185873, 0.074730093586418, -0.73305187182983, 1, -0.73305187182983, 0.074730093586426, 0.62348980185874, -0.98883082622513, 0.826238774316, -0.22252093395631, -0.49999999999999, 0.95557280578614, -0.90096886790242, 0.3653410243664, 0.33027906195517, -0.84672419922828, 0.99371220989324, -0.70710678118655, 0.11196447610331, 0.53203207651534, -0.94388333030837, 0.94388333030837, -0.53203207651534, -0.11196447610331, 0.70710678118655, -0.99371220989324, 0.84672419922828, -0.33027906195517, -0.33027906195516, 0.84672419922828, -0.99371220989324, 0.70710678118655, -0.11196447610331, -0.53203207651534, 0.94388333030837, -0.94388333030837, 0.53203207651533, 0.11196447610331, -0.70710678118654, 0.99371220989324, -0.84672419922828, 0.33027906195516, 0.33027906195517, -0.84672419922828, 0.99371220989324, -0.70710678118655, 0.11196447610331, 0.53203207651533, -0.94388333030837, 0.94388333030837, -0.53203207651533, -0.11196447610331, 0.70710678118655, -0.99371220989324, 0.84672419922828, -0.33027906195517, 0.2947551744109, -0.78183148246803, 0.99720379718118, -0.86602540378444, 0.43388373911756, 0.14904226617617, -0.68017273777092, 0.97492791218182, -0.93087374864421, 0.56332005806362, -7.35407060125e-16, -0.56332005806362, 0.9308737486442, -0.97492791218182, 0.68017273777092, -0.14904226617618, -0.43388373911756, 0.86602540378444, -0.99720379718118, 0.78183148246803, -0.2947551744109, -0.2947551744109, 0.78183148246803, -0.99720379718118, 0.86602540378444, -0.43388373911756, -0.14904226617618, 0.68017273777092, -0.97492791218182, 0.93087374864421, -0.56332005806362, -4.899206177226e-15, 0.56332005806362, -0.93087374864421, 0.97492791218182, -0.68017273777093, 0.14904226617618, 0.43388373911756, -0.86602540378443, 0.99720379718118, -0.78183148246803, 0.29475517441091, 0.25881904510252, -0.70710678118655, 0.96592582628907, -0.96592582628907, 0.70710678118655, -0.25881904510252, -0.25881904510252, 0.70710678118655, -0.96592582628907, 0.96592582628907, -0.70710678118655, 0.25881904510252, 0.25881904510252, -0.70710678118655, 0.96592582628907, -0.96592582628907, 0.70710678118655, -0.25881904510252, -0.25881904510252, 0.70710678118655, -0.96592582628907, 0.96592582628907, -0.70710678118655, 0.25881904510252, 0.25881904510252, -0.70710678118655, 0.96592582628907, -0.96592582628907, 0.70710678118655, -0.25881904510252, -0.25881904510252, 0.70710678118655, -0.96592582628907, 0.96592582628907, -0.70710678118655, 0.25881904510252, 0.25881904510252, -0.70710678118655, 0.96592582628907, -0.96592582628907, 0.70710678118654, -0.25881904510253, 0.22252093395631, -0.62348980185873, 0.90096886790242, -1, 0.90096886790242, -0.62348980185873, 0.22252093395631, 0.22252093395632, -0.62348980185873, 0.90096886790242, -1, 0.90096886790242, -0.62348980185874, 0.22252093395631, 0.22252093395631, -0.62348980185873, 0.90096886790242, -1, 0.90096886790242, -0.62348980185873, 0.22252093395632, 0.22252093395631, -0.62348980185873, 0.90096886790242, -1, 0.90096886790242, -0.62348980185873, 0.22252093395632, 0.22252093395631, -0.62348980185873, 0.90096886790242, -1, 0.90096886790242, -0.62348980185874, 0.22252093395631, 0.22252093395631, -0.62348980185873, 0.90096886790242, -1, 0.90096886790242, -0.62348980185873, 0.22252093395632, 0.18591160716291, -0.53203207651534, 0.80459777976667, -0.96592582628907, 0.99371220989324, -0.88411539350461, 0.65228741127812, -0.33027906195517, -0.037391194276324, 0.39989202431974, -0.70710678118655, 0.91656225586998, -0.9993007047884, 0.94388333030837, -0.75797172314546, 0.46726862827306, -0.1119644761033, -0.25881904510252, 0.5938201855735, -0.84672419922828, 0.98256647323329, -0.98256647323329, 0.84672419922828, -0.59382018557351, 0.25881904510252, 0.1119644761033, -0.46726862827306, 0.75797172314545, -0.94388333030837, 0.9993007047884, -0.91656225586998, 0.70710678118655, -0.39989202431975, 0.037391194276323, 0.33027906195517, -0.65228741127811, 0.88411539350461, -0.99371220989324, 0.96592582628907, -0.80459777976667, 0.53203207651533, -0.18591160716292, 0.14904226617617, -0.43388373911756, 0.68017273777092, -0.86602540378444, 0.97492791218182, -0.99720379718118, 0.93087374864421, -0.78183148246803, 0.56332005806362, -0.29475517441091, -2.9397712985902e-15, 0.2947551744109, -0.56332005806362, 0.78183148246803, -0.9308737486442, 0.99720379718118, -0.97492791218182, 0.86602540378444, -0.68017273777092, 0.43388373911756, -0.14904226617617, -0.14904226617617, 0.43388373911756, -0.68017273777092, 0.86602540378443, -0.97492791218182, 0.99720379718118, -0.9308737486442, 0.78183148246803, -0.56332005806363, 0.2947551744109, 8.8193138957707e-15, -0.29475517441089, 0.56332005806362, -0.78183148246803, 0.9308737486442, -0.99720379718118, 0.97492791218182, -0.86602540378444, 0.68017273777092, -0.43388373911756, 0.14904226617618, 0.11196447610331, -0.33027906195517, 0.53203207651534, -0.70710678118655, 0.84672419922828, -0.94388333030837, 0.99371220989324, -0.99371220989324, 0.94388333030837, -0.84672419922828, 0.70710678118655, -0.53203207651534, 0.33027906195516, -0.1119644761033, -0.11196447610331, 0.33027906195516, -0.53203207651534, 0.70710678118655, -0.84672419922828, 0.94388333030837, -0.99371220989324, 0.99371220989324, -0.94388333030837, 0.84672419922828, -0.70710678118654, 0.53203207651534, -0.33027906195517, 0.11196447610331, 0.1119644761033, -0.33027906195517, 0.53203207651534, -0.70710678118655, 0.84672419922828, -0.94388333030837, 0.99371220989324, -0.99371220989324, 0.94388333030837, -0.84672419922828, 0.70710678118656, -0.53203207651533, 0.33027906195516, -0.11196447610331, 0.074730093586424, -0.22252093395631, 0.36534102436639, -0.5, 0.62348980185873, -0.73305187182983, 0.82623877431599, -0.90096886790242, 0.95557280578614, -0.98883082622513, 1, -0.98883082622513, 0.95557280578614, -0.90096886790242, 0.826238774316, -0.73305187182983, 0.62348980185873, -0.5, 0.3653410243664, -0.22252093395631, 0.074730093586427, 0.074730093586424, -0.22252093395631, 0.3653410243664, -0.5, 0.62348980185873, -0.73305187182983, 0.826238774316, -0.90096886790242, 0.95557280578614, -0.98883082622513, 1, -0.98883082622513, 0.95557280578614, -0.90096886790242, 0.826238774316, -0.73305187182983, 0.62348980185872, -0.50000000000001, 0.36534102436639, -0.22252093395632, 0.074730093586431, 0.037391194276326, -0.11196447610331, 0.18591160716291, -0.25881904510252, 0.33027906195517, -0.39989202431974, 0.46726862827306, -0.53203207651534, 0.5938201855735, -0.65228741127812, 0.70710678118655, -0.75797172314545, 0.80459777976667, -0.84672419922828, 0.88411539350461, -0.91656225586998, 0.94388333030837, -0.96592582628907, 0.98256647323329, -0.99371220989324, 0.9993007047884, -0.9993007047884, 0.99371220989324, -0.98256647323329, 0.96592582628907, -0.94388333030837, 0.91656225586997, -0.88411539350461, 0.84672419922828, -0.80459777976668, 0.75797172314545, -0.70710678118654, 0.65228741127813, -0.5938201855735, 0.53203207651534, -0.46726862827307, 0.39989202431975, -0.33027906195516, 0.25881904510252, -0.18591160716291, 0.1119644761033, -0.037391194276333, 6.1232339957368e-17, -1.836970198721e-16, -5.8201671991329e-16, 1.3477304596987e-15, 5.5109105961631e-16, 1.1028010998692e-15, -9.8033641995447e-16, -2.6948419387608e-15, -7.35407060125e-16, 6.1294238021026e-16, -4.9047770029553e-16, 3.9207266991813e-15, -2.4554834046606e-16, -3.4296300182492e-15, -6.1898063658838e-19, 3.4308679795224e-15, 2.4431037919288e-16, 3.1859386196929e-15, -6.6161876185786e-15, -4.1644180977376e-15, -6.3712582587492e-15, 9.8015072576349e-15, 9.7909845868129e-16, 2.4511505402045e-15, -5.8813995390902e-15, 9.311648537976e-15, 1.4689571783402e-15, 1.9612918205455e-15, 8.8193138957707e-15, 8.8217898183171e-15, 1.9588158979992e-15, 1.4714331008866e-15, -4.9016820997724e-15, 8.3319310986581e-15, 2.4486746176581e-15, 1.519242909643e-14, -4.4118233801134e-15, -6.3687823362028e-15, -1.1272321377885e-14, 4.9171566156871e-16, 1.0288890054748e-14, 7.3522136593402e-15 };


//other functions
static void MFCC_dofft(MFCC *, uint32);

static float MFCC_prepareMel(MFCC *, float *);
//float MFCC_prepareERB(MFCC *, float *);


void MFCC_Ctor(MFCC* unit)
{
	//may want to check sampling rate here!

	unit->m_srate = unit->mWorld->mFullRate.mSampleRate;

	//if sample rate is 88200 or 96000, assume taking double size FFT to start with
	if(unit->m_srate > (44100.0*1.5)) unit->m_srate = unit->m_srate*0.5;

	if(((int)(unit->m_srate+0.01))==44100)
	{
		unit->m_startbin= g_startbin44100;
		unit->m_endbin= g_endbin44100;
		unit->m_cumulindex= g_cumulindex44100;
		unit->m_bandweights= g_melbandweights44100;
	}
	else  //else 48000; potentially dangerous if it isn't! Fortunately, shouldn't write any data to unknown memory
	{
		unit->m_startbin= g_startbin48000;
		unit->m_endbin= g_endbin48000;
		unit->m_cumulindex= g_cumulindex48000;
		unit->m_bandweights= g_melbandweights48000;
	}

	//fixed for now
	unit->m_numbands= 42;

	unit->m_bands = (float*)RTAlloc(unit->mWorld, unit->m_numbands * sizeof(float));

	Clear(unit->m_numbands, unit->m_bands);

	unit->m_numcoefficients= (int)ZIN0(1);

	//range checks
	if(unit->m_numcoefficients<1){unit->m_numcoefficients=1;}
	if(unit->m_numcoefficients>42){unit->m_numcoefficients=42;}

	unit->m_mfcc = (float*)RTAlloc(unit->mWorld, unit->m_numcoefficients * sizeof(float));

	Clear(unit->m_numcoefficients, unit->m_mfcc);
	for (int j=0; j<unit->m_numcoefficients; ++j)
		ZOUT0(j) = 0.f;

	unit->mCalcFunc = (UnitCalcFunc)&MFCC_next;
}


void MFCC_Dtor(MFCC *unit)
{
	if(unit->m_mfcc)
		RTFree(unit->mWorld, unit->m_mfcc);
	if(unit->m_bands)
		RTFree(unit->mWorld, unit->m_bands);
}


void MFCC_next(MFCC *unit, int wrongNumSamples)
{
	float fbufnum = ZIN0(0);

	//next FFT bufffer ready, update
	//assuming at this point that buffer precalculated for any resampling
	if (fbufnum> -0.01f)
		MFCC_dofft(unit, (uint32)fbufnum);

	//always output sones
	//float outval= unit->m_sones;

	//printf("sones %f phontotal %f \n",outval, unit->m_phontotal);

	//number of outputs depends on numcoefficients
	//control rate output
	//ZOUT0(0)=unit->m_sones;

	for (int k=0; k<unit->m_numcoefficients; ++k)
		ZOUT0(k)= unit->m_mfcc[k];
}


//calculation function once FFT data ready
void MFCC_dofft(MFCC *unit, uint32 ibufnum)
{
	World *world = unit->mWorld;

	SndBuf *buf;
	if (ibufnum >= world->mNumSndBufs) {
		int localBufNum = ibufnum - world->mNumSndBufs;
		Graph *parent = unit->mParent;
		if(localBufNum <= parent->localBufNum) {
			buf = parent->mLocalSndBufs + localBufNum;
		} else {
			buf = world->mSndBufs;
		}
	} else {
		buf = world->mSndBufs + ibufnum;
	}
	LOCK_SNDBUF(buf);

	//int numbins = buf->samples - 2 >> 1;

	//assumed in this representation
	ToComplexApx(buf);

	float * data= buf->data;

	float mult= MFCC_prepareMel(unit, data);
	//MFCC_prepareERB

	float * pbands= unit->m_bands;

	//now use cosine basis for transform; approximates principal components, compresses information into a smaller number of bands
	//FFT is actually more expensive here, easiest just to calculate the basis decomposition straight off

	//hard coded 42 = max num bands because this is how the indexing in the dct source is set up
	for (int k=0; k<unit->m_numcoefficients; ++k){
		float sum=0.0;

		int base= k*42;

		for (int j=0; j<unit->m_numbands; ++j) {
			int index= base+j;
			//sum+= (0.5*dct[index]+0.5)*pbands[j];
			sum+= (dct[index])*pbands[j];
		}

		//could also divide by numcoefficients, but left off for compatibility between MFCCs extracted in different ways
		unit->m_mfcc[k]= 0.25f*((sum*mult)+1.0f); //0.5*(0.5*(sum*mult)+0.5);
	}
}


float MFCC_prepareMel(MFCC * unit, float * data)
{
	float * pbands= unit->m_bands;

	int * startbin= unit->m_startbin;
	int * endbin= unit->m_endbin;
	int * cumulindex= unit->m_cumulindex;
	float * weights= unit->m_bandweights;

	for (int k=0; k<unit->m_numbands; ++k){
		int bandstart = startbin[k];
		int bandend = endbin[k]; //p1 = endbin[k]+1;

		float bsum=0.f;
		float real, imag, power;
		int index, index2;
		//float lastpower=0.0;

		index2= cumulindex[k] - bandstart;

		for (int j=bandstart; j < bandend; ++j) {
			index = j+j;
			real= data[index];
			imag= data[index+1];

			if(j==0)
				power= real*real; //sc_abs(real); //dc
			else
				power = real*real + imag*imag; //sqrt((real*real) + (imag*imag));

			float multiplier = weights[index2 + j]; //[cumulindex[k] + (j-bandstart)]

			bsum += (power*multiplier);

		}

		//either keep as double to preserve the small value
		//pbands[k] = 10.f * (sc_log10((bsum< 1e-42? 1e-42: bsum)) + 5.f);
		//or make sure value works as a float: 
		//pbands[k] = 10.f * (sc_log10((bsum< 1e-20f? 1e-20f: bsum)) + 5.f);
		//want to avoid negative values, dynamic range roughly around 11 powers of ten (110dB)
		//pbands[k] = 10.f * (std::log10((bsum< 1e-5f? 1e-5f: bsum)) + 5.f);
		pbands[k] = 10.f * (std::log10(sc_max(1e-5f, bsum)) +5.f); 
	}

	//float mult= 0.01; //(1.0/((float)unit->m_numcoefficients)); //0.01*(1.0/((float)unit->m_numcoefficients));
	return 0.01f;
}



//Original draft for EFCC

//temporal masking over ERB bands: peaks take a while to decay
//spectral masking over which bins summed as contributors for ERB bands; spreading activation function actually implies that the overall power is greater from spread?
//masking not triangular but slanted towards masking higher frequency content (ie, lower freq bins mask upper)
//
//for true MP3 style compression would have to see if each FFT bin was noise like or sine like (transient measure on instantaneous frequency for example), and use the appropriate masking curve
//efficiency is preferred here
//
//thus can calculate squared powers as you go? cheapest if only have effect of spectral masking above, covering a fixed number of bins? but then, frequency biased loudness based on ERB band centre frequency!

//float MFCC_prepareERB(MFCC * unit, float * data) {
//
//int j,k;
//
//	float * pbands= unit->m_bands;
//
//	for (k=0; k<unit->m_numbands; ++k){
//
//		int bandstart=eqlbandbins[k];
//		//int bandend=eqlbandbins[k+1];
//		int bandsize= eqlbandsizes[k];
//		int bandend= bandstart+bandsize;
//
//		float bsum=0.0;
//		float real, imag, power;
//		int index;
//		//float lastpower=0.0;
//
//		for (j=bandstart; j<bandend;++j) {
//			index = 2*j;
//			real= data[index];
//			imag= data[index+1];
//
//			power = (real*real) + (imag*imag);
//
//			//power of three combination
//			bsum= bsum+(power*power*power);
//
//		}
//
//		float db= 10*((0.33334*log10(bsum)) + 4.8810017610244); //correct multipler until you get loudness output of 1!
//
//		//convert via contour
//		if(db<contours[k][0]) db=0;
//        else if (db>contours[k][10]) db=phons[10];
//        else {
//
//            float prop=0.0;
//
//            for (j=1; j<11; ++j) {
//                if(db<contours[k][j]) {
//                    prop= (db-contours[k][j-1])/(contours[k][j]-contours[k][j-1]);
//                    break;
//				}
//
//				if(j==10)
//					prop=1.0;
//            }
//
//            db= (1.0-prop)*phons[j-1]+ prop*phons[j];
//			//printf("prop %f db %f j %d\n",prop,db,j);
//
//		}
//
//		//spectralmasking, 6dB drop per frame?
//		//try also with just take db
//		pbands[k] = db; //sc_max(db, (unit->m_bands[k]) - tmask);
//
//	}
//
//
//	//now use cosine basis for transform; approximates principal components, compresses information into a smaller number of bands
//	//FFT is actually more expensive here, easiest just to calculate the basis decomposition straight off
//	float mult= 0.01*(1.0/((float)unit->m_numcoefficients));
//
//	return mult;
//}
//
