/* ====================================================================
 * Copyright (c) 2003-2006, The Subcommander Crew
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MUTEX_H
#define _SC_MUTEX_H

// sc
#include "apr.h"

// apr
struct apr_thread_mutex_t;


namespace sc
{

/**
 * Non-recursive mutex class based on apr.
 */
class Mutex
{
friend class Condition;

public:
  Mutex();
  ~Mutex();

  void lock();
  void unlock();

private:
  apr::Pool           _pool;
  apr_thread_mutex_t* _mutex;
};

} // namespace

#endif // _SC_MUTEX_H
