/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "RevisionFactory.h"
#include "svn.h"

// svn
#include <svn_opt.h>


namespace svn
{

Revision* RevisionFactory::toRevision( const svn_opt_revision_t* svnrev )
{
  assert(svnrev);

  switch( svnrev->kind )
  {
  case svn_opt_revision_number:
    {
      return new RevisionNumber(svnrev->value.number);
    }
  case svn_opt_revision_date:
    {
      return new RevisionDate(svnrev->value.date);
    }
  default:
    {
      return new Revision((RevisionKind)svnrev->kind);
    }
  }
}

void RevisionFactory::toSvnRevision( const Revision* rev, svn_opt_revision_t* svnrev )
{
  assert(svnrev);

  svnrev->kind = (svn_opt_revision_kind)rev->getKind();

  switch( rev->getKind() )
  {
  case Revision_Number:
    {
      const RevisionNumber* daterev = static_cast<const RevisionNumber*>(rev);
      svnrev->value.number = daterev->getNumber();
      break;
    }
  case Revision_Date:
    {
      const RevisionDate* daterev = static_cast<const RevisionDate*>(rev);
      svnrev->value.date = daterev->getDate();
      break;
    }
  default:
    {
      break;
    }
  }
}


} // namespace
