#!/usr/bin/env python
"""Execute the tests for the variant_comp program.

The golden test outputs are generated by the script generate_outputs.sh.

You have to give the root paths to the source and the binaries as arguments to
the program.  These are the paths to the directory that contains the 'projects'
directory.

Usage:  run_tests.py SOURCE_ROOT_PATH BINARY_ROOT_PATH
"""
import logging
import os.path
import sys

# Automagically add util/py_lib to PYTHONPATH environment variable.
path = os.path.abspath(os.path.join(os.path.dirname(__file__), '..', '..',
                                    '..', '..', 'util', 'py_lib'))
sys.path.insert(0, path)

import seqan.app_tests as app_tests

def main(source_base, binary_base):
    """Main entry point of the script."""

    print 'Executing test for variant_comp'
    print '==============================='
    print
    
    ph = app_tests.TestPathHelper(
        source_base, binary_base,
        'extras/apps/variant_comp/tests')  # tests dir

    # ============================================================
    # Auto-detect the binary path.
    # ============================================================

    path_to_program = app_tests.autolocateBinary(
      binary_base, 'core/apps/variant_comp', 'variant_comp')

    # ============================================================
    # Built TestConf list.
    # ============================================================

    # Build list with TestConf objects, analoguely to how the output
    # was generated in generate_outputs.sh.
    conf_list = []

    # ============================================================
    # Adeno Tests
    # ============================================================

    # We run the following for all read lengths we have reads for.
    for f in ['predicted_full', 'predicted_wrong', 'gold_standard']:
        for pt, st in [(10, 10), (1, 10), (10, 1), (1, 1)]:
            # Run with default options.
            conf = app_tests.TestConf(
                program=path_to_program,
                redir_stdout=ph.outFile('%s_pt%d_st%d.stdout' % (f, pt, st)),
                redir_stderr=ph.outFile('%s_pt%d_st%d.stderr' % (f, pt, st)),
                args=[ph.inFile('adeno.fa'),
                      '-ir', ph.inFile('gold_standard.gff'),
                      '-ip', ph.inFile('%s.gff' % f),
                      '-pt', str(pt),
                      '-st', str(st),
                      '-v',
                      '-o', ph.outFile('%s_pt%d_st%d_out.txt' % (f, pt, st)),
                      '-on', ph.outFile('%s_pt%d_st%d_outFN.txt' % (f, pt, st)),
#                      '-os', ph.outFile('%s_pt%d_st%d_outSNP.txt' % (f, pt, st)),
#                      '-osn', ph.outFile('%s_pt%d_st%d_outSNPN.txt' % (f, pt, st)),
                      ],
                to_diff=[(ph.inFile('%s_pt%d_st%d_out.txt' % (f, pt, st)),
                          ph.outFile('%s_pt%d_st%d_out.txt' % (f, pt, st))),
                         (ph.inFile('%s_pt%d_st%d_outFN.txt' % (f, pt, st)),
                          ph.outFile('%s_pt%d_st%d_outFN.txt' % (f, pt, st))),
#                         (ph.inFile('%s_pt%d_st%d_outSNP.txt' % (f, pt, st)),
#                          ph.outFile('%s_pt%d_st%d_outSNP.txt' % (f, pt, st))),
#                         (ph.inFile('%s_pt%d_st%d_outSNPN.txt' % (f, pt, st)),
#                          ph.outFile('%s_pt%d_st%d_outSNPN.txt' % (f, pt, st))),
                         ])
            conf_list.append(conf)
            
    # Execute the tests.
    failures = 0
    for conf in conf_list:
        res = app_tests.runTest(conf)
        # Output to the user.
        print ' '.join(['variant_comp'] + conf.args),
        if res:
             print 'OK'
        else:
            failures += 1
            print 'FAILED'

    # Cleanup.
    ph.deleteTempDir()

    print '=============================='
    print '     total tests: %d' % len(conf_list)
    print '    failed tests: %d' % failures
    print 'successful tests: %d' % (len(conf_list) - failures)
    print '=============================='
    # Compute and return return code.
    return failures != 0


if __name__ == '__main__':
    sys.exit(app_tests.main(main))
