#ifndef _RHEO_EXTENDED_ARITHMETIC_SUPPORT_H
#define _RHEO_EXTENDED_ARITHMETIC_SUPPORT_H
///
/// This file is part of Rheolef.
///
/// Copyright (C) 2000-2009 Pierre Saramito <Pierre.Saramito@imag.fr>
///
/// Rheolef is free software; you can redistribute it and/or modify
/// it under the terms of the GNU General Public License as published by
/// the Free Software Foundation; either version 2 of the License, or
/// (at your option) any later version.
///
/// Rheolef is distributed in the hope that it will be useful,
/// but WITHOUT ANY WARRANTY; without even the implied warranty of
/// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
/// GNU General Public License for more details.
///
/// You should have received a copy of the GNU General Public License
/// along with Rheolef; if not, write to the Free Software
/// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
/// 
/// =========================================================================
//
// additional goodies in order make easier the support
// of the QD extended arithmetic package
//
// author: Pierre.Saramito@imag.fr
//
// date: 11 septembre 2014
//
#include "rheolef/config.h"

namespace rheolef {
namespace details {

template<class T>
inline int convert_to_int (const T& x) { return int(x); }
#ifdef _RHEOLEF_HAVE_QD
// no standard convrsion to int for q d_real:
template<>
inline int convert_to_int (const qd_real& x) { return to_int(x); }
template<>
inline int convert_to_int (const dd_real& x) { return to_int(x); }
#endif // _RHEOLEF_HAVE_QD

} // namespace details
} // namespace rheolef
#endif // _RHEO_EXTENDED_ARITHMETIC_SUPPORT_H
