﻿
# game/tutorial_quickstart.rpy:28
translate spanish tutorial_create_27048c11:

    # e "When you're ready to use Ren'Py to create your visual novel, the first step is to create a new project."
    e "Cuando estés listo para usar Ren'Py para crear tu novela visual, el primer paso es crear un nuevo proyecto."

# game/tutorial_quickstart.rpy:30
translate spanish tutorial_create_bae6289c:

    # e "You can create a new project by clicking 'Create New Project' on the front screen of the launcher."
    e "Puede crear un nuevo proyecto haciendo clic en 'Crear Un Nuevo Proyecto' en la pantalla principal del launcher."

# game/tutorial_quickstart.rpy:32
translate spanish tutorial_create_45915fcb:

    # e "If this is your first time using Ren'Py, it'll ask you for the place you want to keep your projects. The best place is always somewhere that's frequently backed up."
    e "Si es la primera vez que usas Ren'Py, te pedirá el lugar donde deseas guardar tus proyectos. El mejor lugar es siempre un lugar que se respalda con frecuencia."

# game/tutorial_quickstart.rpy:36
translate spanish tutorial_create_55e30cb5:

    # e "After that, Ren'Py will ask for a name for your project. You'll have to stick to English letters and numbers, as zip files can't handle anything more than that."
    e "Después de eso, Ren'Py te pedirá un nombre para su proyecto. Tendrás que atenerte a las letras y números en inglés, ya que los archivos zip no pueden manejar nada más que eso."

# game/tutorial_quickstart.rpy:40
translate spanish tutorial_create_dea3e5c2:

    # e "The next thing Ren'Py will ask for is the resolution the visual novel will run at. This controls how large or small you'll have to make your game's artwork."
    e "Lo siguiente que Ren'Py pedirá es la resolución a la que se ejecutará la novela visual. Esto controla qué tan grande o pequeño tendrás que hacer las ilustraciones de tu juego."

# game/tutorial_quickstart.rpy:44
translate spanish tutorial_create_3289ea75:

    # e "Finally, Ren'Py will ask you to select a color scheme. You can change this after the game has been created, so just pick a color that's pleasing."
    e "Finalmente, Ren'Py te pedirá que seleccione una combinación de colores. Puedes cambiar esto después de que el juego haya sido creado, así que solo elige un color que sea agradable."

# game/tutorial_quickstart.rpy:48
translate spanish tutorial_create_6b9e3b96:

    # e "Once that's done, Ren'Py will work for a bit and return you to the main menu with the new project selected. Now, when you click Launch, Ren'Py will start your new game."
    e "Una vez hecho esto, Ren'Py trabajará un poco y volverá al menú principal con el nuevo proyecto seleccionado. Ahora, cuando haces clic en Ejecutar, Ren'Py comenzará tu nuevo juego."

# game/tutorial_quickstart.rpy:50
translate spanish tutorial_create_bdf94f9b:

    # e "To get back here, you can choose 'Tutorial' to switch to this tutorial game."
    e "Para volver aquí, puedes elegir 'Tutorial' para cambiar a este juego tutorial."

# game/tutorial_quickstart.rpy:52
translate spanish tutorial_create_22f516df:

    # e "You'll also need to edit the games script to make changes. To do that, click 'script.rpy' on the front page of the launcher."
    e "También necesitarás editar el script de juegos para hacer cambios. Para hacer eso, haga clic en 'script.rpy' en la página principal del lanzador."

# game/tutorial_quickstart.rpy:54
translate spanish tutorial_create_9151025b:

    # e "If it's your first time doing so, Ren'Py will ask you to select a text editor. Atom might be a safe choice, but read the descriptions to be sure."
    e "Si es la primera vez que lo haces, Ren'Py te pedirá que selecciones un editor de texto. Atom puede ser una opción segura, pero lee las descripciones para estar seguro."

# game/tutorial_quickstart.rpy:56
translate spanish tutorial_create_bfbd6220:

    # e "After the text editor is downloaded, the script will open up and you can start to change what characters are saying."
    e "Después de descargar el editor de texto, el script se abrirá y podrá comenzar a cambiar lo que dicen los personajes."

# game/tutorial_quickstart.rpy:69
translate spanish tutorial_dialogue_112ff505:

    # e "Probably the most common thing a creator does with Ren'Py is to write dialogue for the player to read."
    e "Probablemente lo más común que un creador hace con Ren'Py es escribir un diálogo para que el jugador lo lea."

# game/tutorial_quickstart.rpy:71
translate spanish tutorial_dialogue_be2be31a:

    # e "But before I can show you how to write dialogue, let me show you how we present script examples."
    e "Pero antes de que pueda mostrarte cómo escribir diálogos, permítame mostrarte cómo presentamos ejemplos de scripts."

# game/tutorial_quickstart.rpy:74
translate spanish tutorial_dialogue_7b6be28e:

    # "Eileen" "Examples will show up in a window like the one above. You'll need to click outside of the example window in order to advance the tutorial."
    "Eileen" "Los ejemplos se mostrarán en una ventana como la de arriba. Deberás hacer clic fuera de la ventana de ejemplo para avanzar en el tutorial."

# game/tutorial_quickstart.rpy:76
translate spanish tutorial_dialogue_5269d005:

    # "Eileen" "When an example is bigger than the screen, you can scroll around in it using the mouse wheel or by simply dragging the mouse."
    "Eileen" "Cuando un ejemplo es más grande que la pantalla, puede desplazarse utilizando la rueda del ratón o simplemente arrastrando el ratón."

# game/tutorial_quickstart.rpy:78
translate spanish tutorial_dialogue_241c0c74:

    # "Eileen" "Script might seem scary at first, but if you look you'll see it's easy to match it up to what I'm saying."
    "Eileen" "La secuencia de comandos puede parecer atemorizante al principio, pero si miras, verás que es fácil hacerlo coincidir con lo que digo."

# game/tutorial_quickstart.rpy:82
translate spanish tutorial_dialogue_f0d66410:

    # e "Let's see the simplest possible Ren'Py game."
    e "Veamos el juego de Ren'Py más simple posible."

# game/tutorial_quickstart.rpy:89
translate spanish tutorial_dialogue_3e6b0068:

    # "Wow, It's really really dark in here."
    "Guau, realmente está muy oscuro aquí."

# game/tutorial_quickstart.rpy:91
translate spanish tutorial_dialogue_5072a404:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Lucy" "Mejor ten cuidado. No quieres ser comido por un Grue."

# game/tutorial_quickstart.rpy:99
translate spanish tutorial_dialogue_d39d1b2b:

    # e "I'll show you the script of that example."
    e "Te mostraré el script de ese ejemplo."

# game/tutorial_quickstart.rpy:101
translate spanish tutorial_dialogue_f51ecf1f:

    # e "This script demonstrates two kinds of Ren'Py statements, labels and say statements."
    e "Este script muestra dos tipos de sentencia de Ren'Py, 'label' y 'say'."

# game/tutorial_quickstart.rpy:103
translate spanish tutorial_dialogue_bc7ec147:

    # e "The first line is a label statement. The label statement is used to give a name to a place in the program."
    e "La primera línea es una sentencia 'label'. La sentencia 'label' se utiliza para dar un nombre a un lugar en el programa."

# game/tutorial_quickstart.rpy:105
translate spanish tutorial_dialogue_b20db833:

    # e "In this case, we're naming a place \"start\". The start label is special, as it marks the place a game begins running."
    e "En este caso, estamos nombrando un lugar \"start\". La label start es especial, ya que marca el lugar donde un juego comienza a ejecutarse."

# game/tutorial_quickstart.rpy:107
translate spanish tutorial_dialogue_b0afbe96:

    # e "The next line is a simple say statement. It consists of a string beginning with a double-quote, and ending at the next double-quote."
    e "La siguiente línea es una simple sentencia 'say'. Consiste en una cadena que comienza con una comilla doble y termina en la siguiente comilla doble."

# game/tutorial_quickstart.rpy:109
translate spanish tutorial_dialogue_628c9e4c:

    # e "Special characters in strings can be escaped with a backslash. To include \" in a string, we have to write \\\"."
    e "Los caracteres especiales en cadenas se pueden escapar con una barra invertida. Para incluir \" en una cadena, tenemos que escribir \\\"."

# game/tutorial_quickstart.rpy:116
translate spanish tutorial_dialogue_3e6b0068_1:

    # "Wow, It's really really dark in here."
    "Guau, realmente está muy oscuro aquí."

# game/tutorial_quickstart.rpy:125
translate spanish tutorial_dialogue_d7f0b5b7:

    # e "When Ren'Py sees a single string on a line by itself, it uses the narrator to say that string. So a single string can be used to express a character's thoughts."
    e "Cuando Ren'Py ve una sola cadena en una línea, usa el narrador para decir esa cadena. Por lo tanto, se puede usar una sola cadena para expresar los pensamientos de un personaje."

# game/tutorial_quickstart.rpy:131
translate spanish tutorial_dialogue_5072a404_1:

    # "Lucy" "Better watch out. You don't want to be eaten by a Grue."
    "Lucy" "Mejor ten cuidado. No quieres ser comido por un Grue."

# game/tutorial_quickstart.rpy:139
translate spanish tutorial_dialogue_9dd2d543:

    # e "When we have two strings separated by a space, the first is used as the character's name, and the second is what the character is saying."
    e "Cuando tenemos dos cadenas separadas por un espacio, la primera se usa como el nombre del personaje, y la segunda es lo que el personaje está diciendo."

# game/tutorial_quickstart.rpy:141
translate spanish tutorial_dialogue_64ffe685:

    # e "This two-argument form of the say statement is used for dialogue, where a character is speaking out loud."
    e "Esta forma la sentencia 'say' de dos argumentos se usa para diálogo, donde un personaje habla en voz alta."

# game/tutorial_quickstart.rpy:143
translate spanish tutorial_dialogue_97a33275:

    # e "If you'd like, you can run this game yourself by erasing everything in your project's script.rpy file, and replacing it with the code in the box above."
    e "Si lo deseas, puede ejecutar este juego borrando todo el archivo script.rpy de tu proyecto y reemplazándolo con el código en el cuadro de arriba."

# game/tutorial_quickstart.rpy:145
translate spanish tutorial_dialogue_c5e70d7e:

    # e "Be sure to preserve the spacing before lines. That's known as indentation, and it's used to help Ren'Py group lines of script into blocks."
    e "Asegúrese de preservar el espacio antes de las líneas. Eso se conoce como sangría y se usa para ayudar a Ren'Py a agrupar líneas de script en bloques."

# game/tutorial_quickstart.rpy:149
translate spanish tutorial_dialogue_90719f73:

    # e "Using a string for a character's name is inconvenient, for two reasons."
    e "Usar una cadena para el nombre de un personaje es inconveniente, por dos razones."

# game/tutorial_quickstart.rpy:151
translate spanish tutorial_dialogue_910f286a:

    # e "The first is that's it's a bit verbose. While typing \"Lucy\" isn't so bad, imagine if you had to type \"Eileen Richardson\" thousands of times."
    e "La primera es que es un poco verbosa. Mientras que escribir \"Lucy\" no es tan malo, imagínate si tuvieras que escribir \"Eileen Richardson\" miles de veces."

# game/tutorial_quickstart.rpy:153
translate spanish tutorial_dialogue_9c9d59c2:

    # e "The second is that it doesn't leave any place to put styling, which can change the look of a character."
    e "La segunda es que no deja ningún lugar para poner estilo, lo que puede cambiar el aspecto de un personaje."

# game/tutorial_quickstart.rpy:155
translate spanish tutorial_dialogue_2a2d1e51:

    # e "To solve these problems, Ren'Py lets you define Characters."
    e "Para resolver estos problemas, Ren'Py te permite definir 'Characters' (Personajes)."

# game/tutorial_quickstart.rpy:159
translate spanish tutorial_dialogue_16e8c5fd:

    # e "Here's an example Character definition. It begins with the word \"define\". That tells Ren'Py that we are defining something."
    e "Aquí hay un ejemplo de definición de 'Character'. Comienza con la palabra \"define\". Eso le dice a Ren'Py que estamos definiendo algo."

# game/tutorial_quickstart.rpy:161
translate spanish tutorial_dialogue_34fe5aa0:

    # e "Define is followed by a short name for the character, like \"l\". We'll be able to use that short name when writing dialogue."
    e "Define va seguido de un nombre corto para el personaje, como \"l\". Podremos usar ese nombre corto al escribir diálogos."

# game/tutorial_quickstart.rpy:163
translate spanish tutorial_dialogue_67f90201:

    # e "This is followed by an equals sign, and the thing that we're defining. In this case, it's a Character."
    e "A esto le sigue un signo igual y lo que estamos definiendo. En este caso, es un Character."

# game/tutorial_quickstart.rpy:165
translate spanish tutorial_dialogue_4e454a89:

    # e "On the first line, the character's name is given to be \"Lucy\", and her name will be drawn a reddish color."
    e "En la primera línea, el nombre del personaje aparece como \"Lucy\", y su nombre aparecerá en un color rojizo."

# game/tutorial_quickstart.rpy:167
translate spanish tutorial_dialogue_db11f026:

    # e "These short names are case-sensitive. Capital L is a different name from lower-case l, so you'll need to be careful about that."
    e "Estos nombres cortos distinguen entre mayúsculas y minúsculas. L mayuscula es un nombre diferente a l minúscula, por lo que deberás tener cuidado con eso."

# game/tutorial_quickstart.rpy:171
translate spanish tutorial_dialogue_1d161320:

    # e "Now that we have a character defined, we can use it to say dialogue."
    e "Ahora que tenemos un personaje definido, podemos usar esto para mostrar diálogos."

# game/tutorial_quickstart.rpy:178
translate spanish tutorial_dialogue_3710169c:

    # l "Why are you trying to put words into my mouth? And who are you calling \"it\"?"
    l "¿Por qué intentas poner palabras en mi boca? ¿Y a quién llamas \"esto\"?"

# game/tutorial_quickstart.rpy:180
translate spanish tutorial_dialogue_6d463776:

    # l "What's more, what are you going to do about the Grue problem? Are you just going to leave me here?"
    l "Además, ¿qué vas a hacer con el problema del Grue? ¿Me vas a dejar aquí?"

# game/tutorial_quickstart.rpy:188
translate spanish tutorial_dialogue_023bcd31:

    # e "Here's the full game, including the two new lines of dialogue, both of which use the Character we defined to say dialogue."
    e "Aquí está el juego completo, incluidas las dos nuevas líneas de diálogo, las cuales utilizan al Character que definimos para mostrar diálogos."

# game/tutorial_quickstart.rpy:190
translate spanish tutorial_dialogue_48bb9547:

    # e "The one-argument form of the say statement is unchanged, but in the two-argument form, instead of the first string we can use a short name."
    e "La forma de un argumento de la sentencia say no se modifica, pero en la forma de dos argumentos, en lugar de la primera cadena podemos usar un nombre corto."

# game/tutorial_quickstart.rpy:192
translate spanish tutorial_dialogue_56a9936f:

    # e "When this say statement is run, Ren'Py will look up the short name, which is really a Python variable. It will then use the associated Character to show the dialogue."
    e "Cuando se ejecuta esta sentencia, Ren'Py buscará el nombre corto, que es realmente una variable de Python. A continuación, utilizará el Character asociado para mostrar el diálogo."

# game/tutorial_quickstart.rpy:194
translate spanish tutorial_dialogue_d5984a21:

    # e "The Character object controls who is speaking, the color of their name, and many other properties of the dialogue."
    e "El objeto 'Character' controla quién está hablando, el color de su nombre y muchas otras propiedades del diálogo."

# game/tutorial_quickstart.rpy:198
translate spanish tutorial_dialogue_a5bcac8b:

    # e "Since the bulk of a visual novel is dialogue, we've tried to make it as easy to write as possible."
    e "Dado que la mayor parte de una novela visual es el diálogo, hemos intentado que sea lo más fácil de escribir posible."

# game/tutorial_quickstart.rpy:200
translate spanish tutorial_dialogue_6b9a42d0:

    # e "Hopefully, by allowing the use of short names for characters, we've succeeded."
    e "Afortunadamente, al permitir el uso de nombres cortos para los personajes, hemos tenido éxito."

# game/tutorial_quickstart.rpy:206
translate spanish tutorial_images_e09ac970:

    # e "A visual novel isn't much without images. So let's add some images to our little game."
    e "Una novela visual no es mucho sin imágenes. Así que vamos a añadir algunas imágenes a nuestro pequeño juego."

# game/tutorial_quickstart.rpy:208
translate spanish tutorial_images_40140793:

    # e "Before we can show images, we must first choose image names, then place the image files into the images directory."
    e "Antes de que podamos mostrar imágenes, primero debemos elegir los nombres de las imágenes, luego colocar los archivos de imágenes en el carpeta images."

# game/tutorial_quickstart.rpy:210
translate spanish tutorial_images_d73388f8:

    # e "An image name is something like 'bg cave' or 'lucy happy', with one or more parts separated by spaces."
    e "Un nombre de imagen es algo así como 'bg cave' o 'lucy happy', con una o más partes separadas por espacios."

# game/tutorial_quickstart.rpy:212
translate spanish tutorial_images_2d5596d4:

    # e "Each part should start with a lower-case letter, and then contain lower-case letters, numbers, and underscores."
    e "Cada parte debe comenzar con una letra minúscula, y luego contener letras minúsculas, números y guiones bajos."

# game/tutorial_quickstart.rpy:214
translate spanish tutorial_images_e02c0c82:

    # e "The first part of an image is called the tag. For 'bg cave' the tag is 'bg', while for 'lucy happy' the tag is 'lucy'."
    e "La primera parte de una imagen se llama etiqueta. Para 'bg cave' la etiqueta es 'bg', mientras que para 'lucy happy' la etiqueta es 'lucy'."

# game/tutorial_quickstart.rpy:216
translate spanish tutorial_images_d5eafcf2:

    # e "You can open the images directory by clicking the appropriate button in the Ren'Py launcher."
    e "Puede abrir la capeta images haciendo clic en el botón correspondiente en el launcher de Ren'Py."

# game/tutorial_quickstart.rpy:218
translate spanish tutorial_images_e4b12fb6:

    # e "The files in the images directory should have the same name as the image, followed by an extension like .jpg, .png, or .webp."
    e "Los archivos en el directorio de imágenes deben tener el mismo nombre que la imagen, seguido de una extensión como .jpg, .png o .webp."

# game/tutorial_quickstart.rpy:220
translate spanish tutorial_images_a3bd89b2:

    # e "Our example uses 'bg cave.jpg', 'lucy happy.png', and 'lucy mad.png'."
    e "Nuestro ejemplo utiliza 'bg cave.jpg', 'lucy happy.png' y 'lucy mad.png'."

# game/tutorial_quickstart.rpy:224
translate spanish tutorial_images_76b954de:

    # e "Let's see what those look like in the game."
    e "Vamos a ver cómo se ven esos en el juego."

# game/tutorial_quickstart.rpy:230
translate spanish tutorial_images_f04e72ea:

    # l "Now that the lights are on, we don't have to worry about Grues anymore."
    l "Ahora que las luces están encendidas, ya no tenemos que preocuparnos por los Grues."

# game/tutorial_quickstart.rpy:234
translate spanish tutorial_images_d77ffa1c:

    # l "But what's the deal with me being in a cave? Eileen gets to be out in the sun, and I'm stuck here!"
    l "Pero, ¿por qué estoy en una cueva? ¡Eileen sale a la luz del sol y yo estoy atrapada aquí!"

# game/tutorial_quickstart.rpy:242
translate spanish tutorial_images_6c0c938b:

    # e "Here's the script for that scene. Notice how it includes two new statements, the scene and show statement."
    e "Aquí está el script para esa escena. Observa cómo incluye dos sentencis nuevas, scene y show."

# game/tutorial_quickstart.rpy:244
translate spanish tutorial_images_1a4660b9:

    # e "The scene statement clears the screen, and then adds a background image."
    e "La sentencia 'scene' borra la pantalla y luego agrega una imagen de fondo."

# game/tutorial_quickstart.rpy:246
translate spanish tutorial_images_672c8cb8:

    # e "The show statement adds a background image on top of all the other images on the screen."
    e "La sentencia 'show' agrega una imagen de fondo sobre todas las demás imágenes en la pantalla."

# game/tutorial_quickstart.rpy:248
translate spanish tutorial_images_2fc7baee:

    # e "If there was already an image with the same tag, the new image is used to replace the old one."
    e "Si ya existía una imagen con la misma etiqueta, la nueva imagen se usa para reemplazar la antigua."

# game/tutorial_quickstart.rpy:250
translate spanish tutorial_images_802825f2:

    # e "Changes to the list of shown images take place instantly, so in the example, the user won't see the background by itself."
    e "Los cambios en la lista de imágenes mostradas tienen lugar al instante, por lo que en el ejemplo, el usuario no verá solo el fondo."

# game/tutorial_quickstart.rpy:252
translate spanish tutorial_images_b246dfdd:

    # e "The second show statement has an at clause, which gives a location on the screen. Common locations are left, right, and center, but you can define many more."
    e "La segunda sentencia 'show' tiene una cláusula at, que da una ubicación en la pantalla. Las ubicaciones comunes son 'left', 'right' y 'center', pero puedes definir muchas más."

# game/tutorial_quickstart.rpy:257
translate spanish tutorial_images_82fceeb8:

    # e "In this example, we show an image named logo base, and we show it at a creator-defined position, rightish."
    e "En este ejemplo, mostramos una imagen llamada logo base, y la mostramos en una posición definida por el creador, 'rightish'."

# game/tutorial_quickstart.rpy:259
translate spanish tutorial_images_9defda43:

    # e "We also specify that it should be shown behind another image, in this case eileen. That's me."
    e "También especificamos que debe mostrarse 'behind' (detrás) de otra imagen, en este caso eileen. Esa soy yo."

# game/tutorial_quickstart.rpy:264
translate spanish tutorial_images_73d331f7:

    # e "Finally, there's the hide statement, which hides the image with the given tag."
    e "Finalmente, está la sentencia 'hide', que oculta la imagen con la etiqueta dada"

# game/tutorial_quickstart.rpy:266
translate spanish tutorial_images_f34f62d5:

    # e "Since the show statement replaces an image, and the scene statement clears the scene, it's pretty rare to hide an image."
    e "Dado que la sentencia 'show' reemplaza una imagen, y la sentencia 'scene' borra la escena, es bastante raro ocultar una imagen."

# game/tutorial_quickstart.rpy:268
translate spanish tutorial_images_e06fa53a:

    # e "The main use is for when a character or prop leaves before the scene is over."
    e "El uso principal es para cuando un personaje o accesorio se va antes de que termine la escena."

# game/tutorial_quickstart.rpy:282
translate spanish tutorial_simple_positions_b492e793:

    # e "When the standard positions that come with Ren'Py aren't enough for you, you can create your own. Here, I'll show you the easy way to do it."
    e "Cuando las posiciones estándar que vienen con Ren'Py no son suficientes para ti, puedes crear las tuyas. Aquí, te mostraré la manera fácil de hacerlo."

# game/tutorial_quickstart.rpy:291
translate spanish tutorial_simple_positions_04e3bc44:

    # e "The first way to do it is to show an image followed by a colon. Then indented on the next couple of lines are the xalign and yalign transform properties."
    e "La primera forma de hacerlo es mostrar una imagen seguida de dos puntos. Luego, en el siguiente par de líneas, están sangradas las propiedades de transformación 'xalign' y 'yalign'."

# game/tutorial_quickstart.rpy:293
translate spanish tutorial_simple_positions_3ecad5f8:

    # e "Each of the transform properties is a name followed by a value. For xalign and yalign, the values are numbers."
    e "Cada una de las propiedades de transformación es un nombre seguido de un valor. Para 'xalign' y 'yalign', los valores son números."

# game/tutorial_quickstart.rpy:295
translate spanish tutorial_simple_positions_61c1b124:

    # e "The xalign transform property is the important one, as it controls where the image is placed horizontally on the screen."
    e "La propiedad de transformación 'xalign' es la importante, ya que controla dónde se coloca la imagen horizontalmente en la pantalla."

# game/tutorial_quickstart.rpy:305
translate spanish tutorial_simple_positions_67ebea97:

    # e "An xalign of 0.0 is the left side."
    e "Un valor 0.0 en 'xalign' es el lado izquierdo"

# game/tutorial_quickstart.rpy:315
translate spanish tutorial_simple_positions_bd4f56d8:

    # e "0.5 is the center."
    e "0.5 es el centro."

# game/tutorial_quickstart.rpy:324
translate spanish tutorial_simple_positions_fb2c48f2:

    # e "And 1.0 is the right. The decimal place is important and has to be there. Just 1 by itself won't work the same."
    e "Y 1.0 es el lado derecho. La posición decimal es importante y tiene que estar ahí. Solo 1 no funcionará igual."

# game/tutorial_quickstart.rpy:333
translate spanish tutorial_simple_positions_8eebc9a7:

    # e "Of course, you can pick any position in between."
    e "Por supuesto, puedes elegir cualquier posición intermedia."

# game/tutorial_quickstart.rpy:335
translate spanish tutorial_simple_positions_4cd917f6:

    # e "The yalign property is the same way, with 0.0 being the top of the screen and 1.0 being the bottom. Since most sprites stick to the bottom, it's almost always 1.0."
    e "La propiedad 'yalign' es de la misma manera, siendo 0.0 la parte superior de la pantalla y 1.0 la parte inferior. Como la mayoría de los sprites se adhieren al fondo, casi siempre es 1.0."

# game/tutorial_quickstart.rpy:341
translate spanish tutorial_simple_positions_fbd1a3eb:

    # e "While being able to write positions like this is useful, having to repeatedly do so isn't. So Ren'Py lets you define a transform once, and reuse it."
    e "Si bien poder escribir posiciones como esta es útil, tener que hacerlo repetidamente no lo es. Entonces, Ren'Py te permite definir una transformación una vez y reutilizarla."

# game/tutorial_quickstart.rpy:345
translate spanish tutorial_simple_positions_2377e3b3:

    # e "Usually transforms are defined at the top of a file, right after the characters. But it doesn't matter to Ren'Py where you define them."
    e "Por lo general, las transformaciones se definen en la parte superior de un archivo, justo después de los personajes. Pero a Ren'Py no le importa dónde las definas."

# game/tutorial_quickstart.rpy:347
translate spanish tutorial_simple_positions_3ce7e367:

    # e "The transform is given a name, slightleft, and then the xalign and yalign properties."
    e "'Transform' recibe un nombre, 'slightleft' y luego las propiedades 'xalign' e 'yalign'."

# game/tutorial_quickstart.rpy:355
translate spanish tutorial_simple_positions_82d640d9:

    # e "Once a transform has been defined, you can use it in the at clause of the show statement."
    e "Una vez que se ha definido una transformación, puede usarla en la cláusula at de la sentencia show."

# game/tutorial_quickstart.rpy:360
translate spanish tutorial_simple_positions_16b66785:

    # e "Transforms are sticky. If you replace an image without using a transform, Ren'Py will keep the same transforms it had been using."
    e "Las transformaciones son aderibles. Si reemplazas una imagen sin usar una transformación, Ren'Py mantendrá las mismas transformaciones que había estado usando."

# game/tutorial_quickstart.rpy:364
translate spanish tutorial_simple_positions_5d5e0cfd:

    # e "Of course, there's a lot more to transforms than this. If you want to learn more, you can read the sections on Position Properties, Transforms and Animation, and Transform Properties."
    e "Por supuesto, hay mucho más para transformar que esto. Si deseas obtener más información, puedes leer las secciones sobre Propiedades de Posición, Transformaciones y Animaciones, y Propiedades de Transformación."

# game/tutorial_quickstart.rpy:366
translate spanish tutorial_simple_positions_e65da9bf:

    # e "But for many visual novels, xalign and yalign are the only properties that matter."
    e "Pero para muchas novelas visuales, 'xalign' y 'yalign' son las únicas propiedades que importan."

# game/tutorial_quickstart.rpy:381
translate spanish tutorial_transitions_9b8c714c:

    # e "It can be somewhat jarring for the game to jump from place to place."
    e "Puede ser un tanto chocante para el juego saltar de un lugar a otro."

# game/tutorial_quickstart.rpy:388
translate spanish tutorial_transitions_3e290ea8:

    # e "To help take some of edge off a change in scene, Ren'Py supports the use of transitions. Let's try that scene change again, but this time we'll use transitions."
    e "Para ayudar a sacar algo de ventaja a un cambio en la escena, Ren'Py admite el uso de transiciones. Probemos el cambio de escena nuevamente, pero esta vez usaremos transiciones."

# game/tutorial_quickstart.rpy:402
translate spanish tutorial_transitions_9c0a86c4:

    # e "That's much smoother. Here's some example code showing how we include transitions in our game."
    e "Eso es mucho más suave. Aquí hay un código de ejemplo que muestra cómo incluimos las transiciones en nuestro juego."

# game/tutorial_quickstart.rpy:404
translate spanish tutorial_transitions_3e490d40:

    # e "It uses the with statement. The with statement causes the scene to transition from the last things shown to the things currently being shown."
    e "Utiliza la sentencia 'with'. La sentencia 'with' hace que la escena pase de las últimas cosas mostradas a las que se muestran actualmente."

# game/tutorial_quickstart.rpy:406
translate spanish tutorial_transitions_a43847df:

    # e "It takes a transition as an argument. In this case, we're using the Dissolve transition. This transition takes as an argument the amount of time the dissolve should take."
    e "Toma una transición como argumento. En este caso, estamos utilizando la transición Dissolve. Esta transición toma como argumento la cantidad de tiempo que la disolución debería tomar."

# game/tutorial_quickstart.rpy:408
translate spanish tutorial_transitions_6fcee414:

    # e "In this case, each transition takes half a second."
    e "En este caso, cada transición dura medio segundo."

# game/tutorial_quickstart.rpy:412
translate spanish tutorial_transitions_033042cc:

    # e "We can define a short name for a transition, using the define statement. Here, we're defining slowdissolve to be a dissolve that takes a whole second."
    e "Podemos definir un nombre corto para una transición, utilizando la sentencia define. Aquí, estamos definiendo 'slowdissolve' como una disolución que toma un segundo."

# game/tutorial_quickstart.rpy:427
translate spanish tutorial_transitions_0ba82f00:

    # e "Once a transition has been given a short name, we can use it in our game."
    e "Una vez que se le ha dado un nombre corto a una transición, podemos usarla en nuestro juego."

# game/tutorial_quickstart.rpy:431
translate spanish tutorial_transitions_51ff9600:

    # e "Ren'Py defines some transitions for you, like dissolve, fade, and move. For more complex or customized transitions, you'll have to define your own."
    e "Ren'Py define algunas transiciones por ti, como 'dissolve', 'fade' y 'move'. Para transiciones más complejas o personalizadas, tendrás que definir las tuyas propias."

# game/tutorial_quickstart.rpy:433
translate spanish tutorial_transitions_1528f73f:

    # e "If you're interested, check out the Transitions Gallery section of this tutorial."
    e "Si estás interesado, consulta la sección Galería de Transiciones de este tutorial."

# game/tutorial_quickstart.rpy:439
translate spanish tutorial_music_8b92efb7:

    # e "Another important part of a visual novel or simulation game is the soundtrack."
    e "Otra parte importante de una novela visual o juego de simulación es la banda sonora."

# game/tutorial_quickstart.rpy:441
translate spanish tutorial_music_53910317:

    # e "Ren'Py breaks sound up into channels. The channel a sound is played on determines if the sound loops, and if it is saved and restored with the game."
    e "Ren'Py separa el sonido en canales. El canal en el que se reproduce un sonido determina si el sonido se repite, y si se guarda y se restaura con el juego."

# game/tutorial_quickstart.rpy:443
translate spanish tutorial_music_a1e37712:

    # e "When a sound is played on the music channel, it is looped, and it is saved when the game is saved."
    e "Cuando se reproduce un sonido en el canal 'music', se reproduce en bucle y se guarda cuando se guarda el juego."

# game/tutorial_quickstart.rpy:445
translate spanish tutorial_music_d9086d22:

    # e "When the channel named sound is used, the sound is played once and then stopped. It isn't saved."
    e "Cuando se utiliza el canal denominado 'sound', el sonido se reproduce una vez y luego se detiene. No se guarda."

# game/tutorial_quickstart.rpy:447
translate spanish tutorial_music_3555b640:

    # e "The sounds themselves are stored in audio files. Ren'Py supports the Opus, Ogg Vorbis, and mp3 formats."
    e "Los sonidos mismos se almacenan en archivos de audio. Ren'Py soporta los formatos Opus, Ogg Vorbis y mp3."

# game/tutorial_quickstart.rpy:454
translate spanish tutorial_music_8b606a55:

    # e "The play music command replaces the currently playing music, and replaces it with the named filename."
    e "El comando 'play music' reemplaza la música que se está reproduciendo actualmente y la reemplaza con el archivo nombrado."

# game/tutorial_quickstart.rpy:456
translate spanish tutorial_music_18650fe7:

    # e "If you specify the currently-playing song, it will restart it."
    e "Si especificas la canción que se está reproduciendo actualmente, se reiniciará."

# game/tutorial_quickstart.rpy:458
translate spanish tutorial_music_413d91fc:

    # e "If the optional fadeout clause is given, it will fade out the currently playing music before starting the new music."
    e "Si la cláusula opcional 'fadeout' se escribe, se desvanecerá la música que se está reproduciendo en ese momento antes de iniciar la nueva música."

# game/tutorial_quickstart.rpy:463
translate spanish tutorial_music_a282a0e3:

    # e "The queue statement also adds music to the named channel, but it waits until the currently-playing song is finished before playing the new music."
    e "La sentencia 'queue' también agrega música al canal nombrado, pero espera hasta que la canción que se está reproduciendo se termine antes de reproducir la nueva música."

# game/tutorial_quickstart.rpy:468
translate spanish tutorial_music_01ca6bad:

    # e "The third statement is the stop statement. It stops the music playing on a channel. It too takes the fadeout clause."
    e "La tercera sentencia es 'stop'. Detiene la reproducción de música en un canal. También toma la cláusula 'fadeout'."

# game/tutorial_quickstart.rpy:473
translate spanish tutorial_music_384937da:

    # e "Unlike the music channel, playing a sound on the sound channel causes it to play only once."
    e "A diferencia del canal 'music', la reproducción de un sonido en el canal 'sound' hace que se reproduzca solo una vez."

# game/tutorial_quickstart.rpy:480
translate spanish tutorial_music_1d3e9fd2:

    # e "You can queue up multiple sounds on the sound channel, but the sounds will only play one at a time."
    e "Puedes poner en cola varios sonidos en el canal de sonido, pero los sonidos solo se reproducirán uno a la vez."

# game/tutorial_quickstart.rpy:486
translate spanish tutorial_music_aa01c19d:

    # e "Ren'Py has separate mixers for sound, music, and voices, so the player can adjust them as they like."
    e "Ren'Py tiene mezcladores separados para sonido, música y voces, por lo que el jugador puede ajustarlos a tu gusto."

# game/tutorial_quickstart.rpy:492
translate spanish tutorial_menus_0426904b:

    # e "Many visual novels require the player to make choices from in-game menus. These choices can add some challenge to the game, or adjust it to the player's preferences."
    e "Muchas novelas visuales requieren que el jugador haga elecciones en los menús del juego. Estas opciones pueden agregar algún desafío al juego, o ajustarlo a las preferencias del jugador."

# game/tutorial_quickstart.rpy:494
translate spanish tutorial_menus_431eeff0:

    # e "Do you like to play visual novels with choices in them?"
    e "¿Te gusta jugar novelas visuales con opciones?"

# game/tutorial_quickstart.rpy:509
translate spanish choice1_yes_f6d95df8:

    # e "While creating a multi-path visual novel can be a bit more work, it can yield a unique experience."
    e "Si bien la creación de una novela visual de múltiples rutas puede ser un poco más de trabajo, puede brindar una experiencia única."

# game/tutorial_quickstart.rpy:517
translate spanish choice1_no_72958b50:

    # e "Games without menus are called kinetic novels, and there are dozens of them available to play."
    e "Los juegos sin menús se llaman novelas cinéticas, y hay docenas de ellas disponibles para jugar."

# game/tutorial_quickstart.rpy:528
translate spanish choice1_done_acba9504:

    # e "Here, you can see the code for that menu. If you scroll down, you can see the code we run after the menu."
    e "Aquí puedes ver el código de ese menú. Si se desplaza hacia abajo, puede ver el código que corremos después de menu."

# game/tutorial_quickstart.rpy:530
translate spanish choice1_done_f9fa6889:

    # e "Menus are introduced by the menu statement. The menu statement takes an indented block, in which there can be one line of dialogue and multiple choices."
    e "Los menús son introducidos por la sentencia 'menu'. La sentencia 'menu' toma un bloque con sangría, en el que puede haber una línea de diálogo y múltiples opciones."

# game/tutorial_quickstart.rpy:532
translate spanish choice1_done_ebb2db38:

    # e "Each choice must end with a colon, as each choice has its own block of Ren'Py code, that is run when that choice is selected."
    e "Cada opción debe terminar con dos puntos, ya que cada opción tiene su propio bloque de código Ren'Py, que se ejecuta cuando se selecciona esa opción."

# game/tutorial_quickstart.rpy:534
translate spanish choice1_done_59cac95d:

    # e "Here, each block jumps to a label. While you could put small amounts of Ren'Py code inside a menu label, it's probably good practice to usually jump to a bigger block of code."
    e "Aquí, cada bloque 'jump' (salta) a una 'label'. Si bien puede colocar pequeñas cantidades de código Ren'Py dentro de una label de menú, probablemente sea una buena práctica saltar a un bloque de código más grande."

# game/tutorial_quickstart.rpy:536
translate spanish choice1_done_2851a313:

    # e "Scrolling down past the menu, you can see the labels that the menu jumps to. There are three labels here, named choice1_yes, choice1_no, and choice1_done."
    e "Desplazándote hacia abajo más allá del menú, puede ver las 'label' a las que salta el menú. Aquí hay tres 'label', denominadas 'choice1_yes', 'choice1_no' y 'choice1_done'."

# game/tutorial_quickstart.rpy:538
translate spanish choice1_done_ff761b03:

    # e "When the first menu choice is picked, we jump to the choice1_yes, which runs two lines of script before jumping to choice1_done."
    e "Cuando se selecciona la primera opción de menú, saltamos a 'choice1_yes', que ejecuta dos líneas de script antes de saltar a la 'choice1_done'."

# game/tutorial_quickstart.rpy:540
translate spanish choice1_done_664fe702:

    # e "Similarly, picking the second choice jumps us to choice1_no, which also runs two lines of script."
    e "De manera similar, elegir la segunda opción nos lleva a 'choice1_no', que también ejecuta dos líneas de script."

# game/tutorial_quickstart.rpy:542
translate spanish choice1_done_31d12b1e:

    # e "The lines beginning with the dollar sign are lines of python code, which are used to set a flag based on the user's choice."
    e "Las líneas que comienzan con el signo de dólar son líneas de código Python, que se utilizan para establecer una 'flag' (bandera) en función de la elección del usuario."

# game/tutorial_quickstart.rpy:544
translate spanish choice1_done_88398d3e:

    # e "The flag is named menu_flag, and it's set to True or False based on the user's choice. The if statement can be used to test a flag, so the game can remember the user's choices."
    e "La bandera' se llama 'menu_flag' y se establece en 'True' o 'False' según la elección del usuario. La sentencia 'if' se puede usar para probar una bandera, para que el juego pueda recordar las elecciones del usuario."

# game/tutorial_quickstart.rpy:549
translate spanish choice1_done_2828dbfc:

    # e "For example, I remember that you plan to use menus in your game."
    e "Por ejemplo, recuerdo que planeas usar menús en tu juego."

# game/tutorial_quickstart.rpy:553
translate spanish choice1_done_503786e4:

    # e "For example, I remember that you're planning to make a kinetic novel, without menus."
    e "Por ejemplo, recuerdo que planeas hacer una novela cinética, sin menús."

# game/tutorial_quickstart.rpy:555
translate spanish choice1_done_819e234a:

    # e "Here's an example that shows how we can test a flag, and do different things if it is true or not."
    e "Aquí hay un ejemplo que muestra cómo podemos probar una bandera y hacer cosas diferentes si es verdad o no."

# game/tutorial_quickstart.rpy:559
translate spanish choice1_done_461e6a59:

    # e "Finally, this shows how you can show dialogue and menus at the same time. Understand?" nointeract
    e "Finalmente, esto muestra cómo puedes mostrar diálogos y menús al mismo tiempo. ¿Entendido?" nointeract

# game/tutorial_quickstart.rpy:564
translate spanish choice1_done_a32e30fd:

    # e "Great."
    e "Genial."

# game/tutorial_quickstart.rpy:568
translate spanish choice1_done_fbd1dbc1:

    # e "If you look at the example, before the first choice, there's an indented say statement."
    e "Si nos fijamos en el ejemplo, antes de la primera opción, hay una sentencia 'say' con sangría."

# game/tutorial_quickstart.rpy:574
translate spanish menu3_done_47fa2268:

    # e "Although we won't demonstrate it here, Ren'Py supports making decisions based on a combinations of points, flags, and other factors."
    e "Aunque no lo demostraremos aquí, Ren'Py admite la toma de decisiones basadas en una combinación de puntos, banderas y otros factores."

# game/tutorial_quickstart.rpy:576
translate spanish menu3_done_826a600b:

    # e "One of Ren'Py's big advantages is the flexibility using a scripting language like Python provides us. It lets us easily scale from kinetic novels to complex simulation games."
    e "Una de las grandes ventajas de Ren'Py es la flexibilidad que ofrece el uso de un lenguajes de scripting como Python. Nos permite escalar fácilmente de novelas cinéticas a juegos de simulación complejos."

# game/tutorial_quickstart.rpy:585
translate spanish tutorial_input_066611c5:

    # e "Some games might prompt the player for input."
    e "Algunos juegos pueden pedirle al jugador una entrada."

# game/tutorial_quickstart.rpy:599
translate spanish tutorial_input_dc3b4560:

    # e "That's done with Python, and especially the renpy.input function. The first line of this example prompts the player for some texts, and sticks it in the name variable."
    e "Eso se hace con Python, y especialmente con la función 'renpy.input'. La primera línea de este ejemplo solicita al jugador algunos textos y lo pega en la variable 'name'."

# game/tutorial_quickstart.rpy:601
translate spanish tutorial_input_c88b3f4e:

    # e "Often times, you'll want to clean the name up before you use it. The last line does that, by calling the strip method to remove whitespace, and replacing the name with a default if it's missing."
    e "Muchas veces, querrás limpiar 'name' antes de usarla. La última línea hace eso, llamando al método 'strip' para eliminar los espacios en blanco, y reemplazando el nombre con un valor predeterminado si falta."

# game/tutorial_quickstart.rpy:605
translate spanish tutorial_input_1236e9da:

    # e "To interpolate a variable, write it in square brackets. Isn't that right, [name]?"
    e "Para interpolar una variable, escríbala entre corchetes. ¿Correcto, [name]?"

# game/tutorial_quickstart.rpy:609
translate spanish tutorial_input_c1f7a808:

    # e "Variable names can also be shown in character names. To do that, just include the variable in square brackets in the character's name. Got it?"
    e "Los nombres de variables también se pueden mostrar en nombres de personajes. Para hacer eso, simplemente incluya la variable entre corchetes en el nombre del personaje. ¿Entendido?"

# game/tutorial_quickstart.rpy:612
translate spanish tutorial_input_f7757a8e:

    # g "I think I do."
    g "Eso creo."

# game/tutorial_quickstart.rpy:619
translate spanish tutorial_input_0548d3e2:

    # e "Variable interpolation also works with other variables. Here, the answer is [answer] and the flag is [flag]."
    e "La interpolación de variables también funciona con otras variables. Aquí, la respuesta es [answer] y la bandera es [flag]."

translate spanish strings:

    # tutorial_quickstart.rpy:2
    old "Lucy"
    new "Lucy"

    # tutorial_quickstart.rpy:497
    old "Yes, I do."
    new "Sí."

    # tutorial_quickstart.rpy:497
    old "No, I don't."
    new "No."

    # tutorial_quickstart.rpy:589
    old "What's your name?"
    new "¿Cómo te llamas?"

    # tutorial_quickstart.rpy:591
    old "Guy Shy"
    new "Chico Timido"

# game/tutorial_quickstart.rpy:449
translate spanish tutorial_music_a2ffbe9b:

    # e "Let's check out some of the commands that can affect the music channel."
    e "Revisemos algunos de los comandos que pueden afectar el canal music."

# game/tutorial_quickstart.rpy:246
translate spanish tutorial_images_a5e7eb24:

    # e "The show statement adds a new image on top of all the other images on the screen."
    e "La declaración 'show' agrega una nueva imagen sobre todas las demás imágenes en la pantalla."

# game/tutorial_quickstart.rpy:248
translate spanish tutorial_images_86e11de2:

    # e "If there is already an image with the same tag, the new image is used to replace the old one."
    e "Si ya existe una imagen con la misma etiqueta, la nueva imagen se usa para reemplazar la anterior."

