% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RequestPattern.R
\name{UriPattern}
\alias{UriPattern}
\title{UriPattern}
\description{
uri matcher
}
\examples{
# trailing slash
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://foobar.com") # TRUE
z$matches("http://foobar.com/") # TRUE

# without scheme
## matches http by default: does not match https by default
(z <- UriPattern$new(pattern = "foobar.com"))
z$matches("http://foobar.com") # TRUE
z$matches("http://foobar.com/") # TRUE
z$matches("https://foobar.com") # FALSE
z$matches("https://foobar.com/") # FALSE
## to match https, you'll have to give the complete url
(z <- UriPattern$new(pattern = "https://foobar.com"))
z$matches("https://foobar.com/") # TRUE
z$matches("http://foobar.com/") # FALSE

# default ports
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://foobar.com:80") # TRUE
z$matches("http://foobar.com:80/") # TRUE
z$matches("http://foobar.com:443") # TRUE
z$matches("http://foobar.com:443/") # TRUE

# user info - FIXME, not sure we support this yet
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$matches("http://user:pass@foobar.com")

# regex
(z <- UriPattern$new(regex_pattern = ".+ample\\\\.."))
z$matches("http://sample.org") # TRUE
z$matches("http://example.com") # TRUE
z$matches("http://tramples.net") # FALSE

# add query parameters
(z <- UriPattern$new(pattern = "http://foobar.com"))
z$add_query_params(list(pizza = "cheese", cheese = "cheddar"))
z
z$pattern
z$matches("http://foobar.com?pizza=cheese&cheese=cheddar") # TRUE
z$matches("http://foobar.com?pizza=cheese&cheese=swiss") # FALSE

# query parameters in the uri
(z <- UriPattern$new(pattern = "https://httpbin.org/get?stuff=things"))
z$add_query_params() # have to run this method to gather query params
z$matches("https://httpbin.org/get?stuff=things") # TRUE
z$matches("https://httpbin.org/get?stuff2=things") # FALSE

# regex add query parameters
(z <- UriPattern$new(regex_pattern = "https://foobar.com/.+/order"))
z$add_query_params(list(pizza = "cheese"))
z
z$pattern
z$matches("https://foobar.com/pizzas/order?pizza=cheese") # TRUE
z$matches("https://foobar.com/pizzas?pizza=cheese") # FALSE

# query parameters in the regex uri
(z <- UriPattern$new(regex_pattern = "https://x.com/.+/order\\\\?fruit=apple"))
z$add_query_params() # have to run this method to gather query params
z$matches("https://x.com/a/order?fruit=apple") # TRUE
z$matches("https://x.com/a?fruit=apple") # FALSE

# any pattern
(z <- UriPattern$new(regex_pattern = "stuff\\\\.com.+"))
z$regex
z$pattern
z$matches("http://stuff.com") # FALSE
z$matches("https://stuff.com/stff") # TRUE
z$matches("https://stuff.com/apple?bears=brown&bats=grey") # TRUE

# partial matching
## including
z <- UriPattern$new(pattern = "http://foobar.com")
z$add_query_params(including(list(hello = "world")))
z$matches(uri = "http://foobar.com?hello=world&bye=mars") # TRUE
z$matches("http://foobar.com?bye=mars") # FALSE

## excluding
z <- UriPattern$new(pattern = "http://foobar.com")
z$add_query_params(excluding(list(hello = "world")))
z$matches(uri = "http://foobar.com?hello=world&bye=mars") # FALSE
z$matches("http://foobar.com?bye=mars") # TRUE

## match on list keys (aka: names) only, ignore values 0
z <- UriPattern$new(pattern = "http://foobar.com")
z$add_query_params(including(list(hello = NULL)))
z$matches(uri = "http://foobar.com?hello=world&bye=mars") # TRUE
z$matches("http://foobar.com?hello=stuff") # TRUE
z$matches("http://foobar.com?bye=stuff") # FALSE
}
\keyword{internal}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pattern}}{(character) pattern holder}

\item{\code{regex}}{a logical}

\item{\code{query_params}}{a list, or \code{NULL} if empty}

\item{\code{partial}}{bool, default: \code{FALSE}}

\item{\code{partial_type}}{a string, default: NULL}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-UriPattern-new}{\code{UriPattern$new()}}
\item \href{#method-UriPattern-matches}{\code{UriPattern$matches()}}
\item \href{#method-UriPattern-pattern_matches}{\code{UriPattern$pattern_matches()}}
\item \href{#method-UriPattern-query_params_matches}{\code{UriPattern$query_params_matches()}}
\item \href{#method-UriPattern-extract_query}{\code{UriPattern$extract_query()}}
\item \href{#method-UriPattern-add_query_params}{\code{UriPattern$add_query_params()}}
\item \href{#method-UriPattern-to_s}{\code{UriPattern$to_s()}}
\item \href{#method-UriPattern-clone}{\code{UriPattern$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UriPattern-new"></a>}}
\if{latex}{\out{\hypertarget{method-UriPattern-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{UriPattern} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$new(pattern = NULL, regex_pattern = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pattern}}{(character) a uri, as a character string. if scheme
is missing, it is added (we assume http)}

\item{\code{regex_pattern}}{(character) a uri as a regex character string,
see \link[base:regex]{base::regex}. if scheme is missing, it is added (we assume
http)}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{UriPattern} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UriPattern-matches"></a>}}
\if{latex}{\out{\hypertarget{method-UriPattern-matches}{}}}
\subsection{Method \code{matches()}}{
Match a uri against a pattern
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$matches(uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uri}}{(character) a uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a boolean
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UriPattern-pattern_matches"></a>}}
\if{latex}{\out{\hypertarget{method-UriPattern-pattern_matches}{}}}
\subsection{Method \code{pattern_matches()}}{
Match a URI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$pattern_matches(uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uri}}{(character) a uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a boolean
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UriPattern-query_params_matches"></a>}}
\if{latex}{\out{\hypertarget{method-UriPattern-query_params_matches}{}}}
\subsection{Method \code{query_params_matches()}}{
Match query parameters of a URI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$query_params_matches(uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uri}}{(character) a uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a boolean
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UriPattern-extract_query"></a>}}
\if{latex}{\out{\hypertarget{method-UriPattern-extract_query}{}}}
\subsection{Method \code{extract_query()}}{
Extract query parameters as a named list
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$extract_query(uri)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{uri}}{(character) a uri}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
named list, or \code{NULL} if no query parameters
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UriPattern-add_query_params"></a>}}
\if{latex}{\out{\hypertarget{method-UriPattern-add_query_params}{}}}
\subsection{Method \code{add_query_params()}}{
Add query parameters to the URI
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$add_query_params(query_params)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{query_params}}{(list|character) list or character}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
nothing returned, updates uri pattern
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UriPattern-to_s"></a>}}
\if{latex}{\out{\hypertarget{method-UriPattern-to_s}{}}}
\subsection{Method \code{to_s()}}{
Print pattern for easy human consumption
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$to_s()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
a string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-UriPattern-clone"></a>}}
\if{latex}{\out{\hypertarget{method-UriPattern-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{UriPattern$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
