% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{SingleCorPlot}
\alias{SingleCorPlot}
\title{A single correlation plot}
\usage{
SingleCorPlot(
  data,
  col.by = NULL,
  cols = NULL,
  pt.size = NULL,
  smooth = FALSE,
  rows.highlight = NULL,
  legend.title = NULL,
  na.value = "grey50",
  span = NULL,
  raster = NULL,
  raster.dpi = NULL,
  plot.cor = TRUE,
  jitter = TRUE
)
}
\arguments{
\item{data}{A data frame with two columns to be plotted}

\item{col.by}{A vector or factor of values to color the plot by}

\item{cols}{An optional vector of colors to use}

\item{pt.size}{Point size for the plot}

\item{smooth}{Make a smoothed scatter plot}

\item{legend.title}{Optional legend title}

\item{raster}{Convert points to raster format, default is \code{NULL}
which will automatically use raster if the number of points plotted is
greater than 100,000}

\item{raster.dpi}{the pixel resolution for rastered plots, passed to geom_scattermore().
Default is c(512, 512)}

\item{plot.cor}{...}

\item{jitter}{Jitter for easier visualization of crowded points}

\item{rows.highight}{A vector of rows to highlight (like cells.highlight in
\code{\link{SingleDimPlot}})}
}
\value{
A ggplot2 object
}
\description{
A single correlation plot
}
\keyword{internal}
