% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-iso.R
\name{plot_iso}
\alias{plot_iso}
\title{Visualize a single isoband}
\usage{
plot_iso(
  m,
  vlo,
  vhi,
  fill_lo = "gray95",
  fill_mid = "gray50",
  fill_hi = "black",
  fill_band = "cornsilk",
  col_lo = "black",
  col_hi = "black",
  newpage = TRUE
)
}
\arguments{
\item{m}{input matrix}

\item{vlo}{lower cutoff for isobanding}

\item{vhi}{higher cutoff for isobanding}

\item{fill_lo}{fill color for points below the lower cutoff}

\item{fill_mid}{fill color for points between the two cutoffs}

\item{fill_hi}{fill color for points above the higher cutoff}

\item{fill_band}{fill color for the isoband}

\item{col_lo}{line color for lower cutoff}

\item{col_hi}{line color for higher cutoff}

\item{newpage}{boolean, indicating whether \code{grid.newpage()} should
be called or not}
}
\description{
This function visualizes a single isoband calculated from a matrix. It is mainly useful
for debugging and visualizing the isobanding algorithm. See \code{\link[=isobands]{isobands()}} for more
examples.
}
\examples{
m <- matrix(c(0, 0, 0, 0, 0, 0,
              0, 2, 2, 2, 2, 0,
              0, 2, 0, 0, 2, 0,
              0, 2, 0, 0, 2, 0,
              0, 2, 2, 2, 2, 0,
              0, 0, 0, 0, 0, 0), 6, 6, byrow = TRUE)

plot_iso(m, 0.5, 1.5)
}
