% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmGrid-methods.R, R/summary.R
\name{update.emmGrid}
\alias{update.emmGrid}
\alias{levels<-.emmGrid}
\alias{update.summary_emm}
\title{Update an \code{emmGrid} object}
\usage{
\method{update}{emmGrid}(object, ..., silent = FALSE)

\method{levels}{emmGrid}(x) <- value

\method{update}{summary_emm}(object, by.vars, mesg, ...)
}
\arguments{
\item{object}{An \code{emmGrid} object}

\item{...}{Options to be set. These must match a list of known options (see
Details)}

\item{silent}{Logical value. If \code{FALSE} (the default), a message is
displayed if any options are not matched. If \code{TRUE}, no messages are
shown.}

\item{x}{an \code{emmGrid} object}

\item{value}{\code{list} or replacement levels. See the documentation for
\code{update.emmGrid} with the \code{levels} argument, 
as well as the section below on \dQuote{Replaciong levels}}

\item{by.vars, mesg}{Attributes that can be altered in \code{update.summary_emm}}
}
\value{
an updated \code{emmGrid} object.

\code{levels<-} replaces the levels of the object in-place.
  See the section on replacing levels for details.
}
\description{
Objects of class \code{emmGrid} contain several settings that affect such things as
what arguments to pass to \code{\link{summary.emmGrid}}. 
The \code{update} method allows safer management of these settings than
by direct modification of its slots.
}
\note{
When it makes sense, an option set by \code{update} will persist into 
future results based on that object. But some options are disabled as well.
For example, a \code{calc} option will be nulled-out if \code{contrast}
is called, because it probably will not make sense to do the same 
calculations on the contrast results, and in fact the variable(s) needed
may not even still exist.
\code{factor(percent)}.
}
\section{Details}{

The names in \code{\dots} are partially matched against those that are valid, and if a match is found, it adds or replaces the current setting. The valid names are

\describe{
\item{\code{tran}, \code{tran2}}{(\code{list} or \code{character}) specifies
the transformation which, when inverted, determines the results displayed by
\code{\link{summary.emmGrid}}, \code{\link{predict.emmGrid}}, or \code{\link{emmip}} when
\code{type="response"}. The value may be the name of a standard
transformation from \code{\link{make.link}} or additional ones supported by
name, such as \code{"log2"}; or, for a custom transformation, a \code{list}
containing at least the functions \code{linkinv} (the inverse of the
transformation) and \code{mu.eta} (the derivative thereof). The
\code{\link{make.tran}} function returns such lists for a number of popular
transformations. See the help page of \code{\link{make.tran}} for details as
well as information on the additional named transformations that are
supported. \code{tran2} is just like \code{tran} except it is a second
transformation (i.e., a response transformation in a generalized linear
model).}

\item{\code{tran.mult}}{Multiple for \code{tran}. For example, for the
response transformation \samp{2*sqrt(y)} (or \samp{sqrt(y) + sqrt(y + 1)},
for that matter), we should have \code{tran = "sqrt"} and \code{tran.mult =
2}. If absent, a multiple of 1 is assumed.}

\item{\code{tran.offset}}{Additive constant before a transformation is applied.
For example, a response transformation of \code{log(y + pi)} has
\code{tran.offset  = pi}. If no value is present, an offset of 0 is assumed.}

\item{\code{estName}}{(\code{character}) is the column label used for
displaying predictions or EMMs.}

\item{\code{inv.lbl}}{(\code{character)}) is the column label to use for
predictions or EMMs when \code{type="response"}.}

\item{\code{by.vars}}{(\code{character)} vector or \code{NULL}) the variables
used for grouping in the summary, and also for defining subfamilies in a call
to \code{\link{contrast}}.}

\item{\code{pri.vars}}{(\code{character} vector) are the names of the grid
variables that are not in \code{by.vars}. Thus, the combinations of their
levels are used as columns in each table produced by \code{\link{summary.emmGrid}}.}

\item{\code{alpha}}{(numeric) is the default significance level for tests, in
\code{\link{summary.emmGrid}} as well as \code{\link{plot.emmGrid}}
when \samp{CIs = TRUE}. Be cautious that methods that depend on
specifying \code{alpha} are prone to abuse. See the
discussion in \href{../doc/basics.html#pvalues}{\code{vignette("basics", "emmeans")}}.}

\item{\code{adjust}}{(\code{character)}) is the default for the \code{adjust}
argument in \code{\link{summary.emmGrid}}.}

\item{\code{cross.adjust}}{(\code{character)}) is the default for the \code{cross.adjust}
argument in \code{\link{summary.emmGrid}} (used for adjusting between groups).}

\item{\code{famSize}}{(integer) is the number of means involved in a family of
inferences; used in Tukey adjustment}

\item{\code{infer}}{(\code{logical} vector of length 2) is the default value
of \code{infer} in \code{\link{summary.emmGrid}}.}

\item{\code{level}}{(numeric) is the default confidence level, \code{level},
in \code{\link{summary.emmGrid}}. \emph{Note:} You must specify all five letters 
of \sQuote{level} to distinguish it from the slot name \sQuote{levels}.}

\item{\code{df}}{(numeric) overrides the default degrees of freedom with a
specified single value.}

\item{\code{calc}}{(list) additional calculated columns. See \code{\link{summary.emmGrid}}.}

\item{\code{null}}{(numeric) null hypothesis for \code{summary} or
\code{test} (taken to be zero if missing).}

\item{\code{side}}{(numeric or character) \code{side} specification for for
\code{summary} or \code{test} (taken to be zero if missing).}

\item{\code{sigma}}{(numeric) Error SD to use in predictions and for bias-adjusted
back-transformations}

\item{\code{delta}}{(numeric) \code{delta} specification for \code{summary}
or \code{test} (taken to be zero if missing).}

\item{\code{predict.type} or \code{type}}{(character) sets the default method
of displaying predictions in \code{\link{summary.emmGrid}},
\code{\link{predict.emmGrid}}, and \code{\link{emmip}}. Valid values are
\code{"link"} (with synonyms \code{"lp"} and \code{"linear"}), or
\code{"response"}.}

\item{\code{bias.adjust}, \code{frequentist}}{(logical) These
are used by \code{summary} if the value of these arguments are not specified.}

\item{\code{estType}}{(\code{character}) is used internally to determine 
what \code{adjust} methods are appropriate. It should match one of 
\samp{c("prediction", "contrast", "pairs")}. As an example of why this is needed,
the Tukey adjustment should only be used for pairwise comparisons 
(\code{estType = "pairs"}); if \code{estType} is some other string, Tukey
adjustments are not allowed.}

\item{\code{avgd.over}}{(\code{character)} vector) are the names of the 
variables whose levels are averaged over in obtaining marginal averages of 
predictions, i.e., estimated marginal means. Changing this might produce a 
misleading printout, but setting it to \code{character(0)} will suppress the 
\dQuote{averaged over} message in the summary.}

\item{\code{initMesg}}{(\code{character}) is a string that is added to the
beginning of any annotations that appear below the \code{\link{summary.emmGrid}}
display.}

\item{\code{methDesc}}{(\code{character}) is a string that may be used for
creating names for a list of \code{emmGrid} objects. }

\item{\code{nesting}}{(Character or named \code{list}) specifies the nesting
structure. See \dQuote{Recovering or overriding model information} in the
documentation for \code{\link{ref_grid}}. The current nesting structure is
displayed by \code{\link{str.emmGrid}}.}

\item{\code{levels}}{named \code{list} of new levels for the elements of the
current \code{emmGrid}. The list name(s) are used as new variable names, and
if needed, the list is expanded using \code{expand.grid}. These results replace
current variable names and levels. This specification changes the \code{levels},
\code{grid}, \code{roles}, and \code{misc} slots in the updated \code{emmGrid},
and resets \code{pri.vars}, \code{by.vars}, \code{adjust}, \code{famSize},
and \code{avgd.over}. In addition, if there is nesting of factors, that may be 
altered; a warning is issued if it involves something other than mere name changes.
\emph{Note:} All six letters of \code{levels} is needed in order to distinguish
it from \code{level}.}

\item{\code{submodel}}{\code{formula} or \code{character} value specifying a 
submodel (requires this feature being supported by underlying methods 
for the model class). When specified, the \code{linfct} slot is replaced by 
its aliases for the specified sub-model. Any factors in the sub-model that 
do not appear in the model matrix are ignored, as are any interactions that 
are not in the main model, and any factors associate with multivariate responses. 
The estimates displayed are then computed as if 
the sub-model had been fitted. (However, the standard errors will be based on the
error variance(s) of the full model.) 
\emph{Note:} The formula should refer only to predictor names, \emph{excluding} any
function calls (such as \code{factor} or \code{poly}) that appear in the 
original model formula. See the example.

The character values allowed should partially 
match \code{"minimal"} or \code{"type2"}. With \code{"minimal"}, the sub-model
is taken to be the one only involving the surviving factors in \code{object}
(the ones averaged over being omitted). Specifying \code{"type2"} is the same as
\code{"minimal"} except only the highest-order term in the submodel is retained,
and all effects not containing it are orthogonalized-out. Thus, in a purely linear
situation such as an \code{lm} model, the joint test
of the modified object is in essence a type-2 test as in \code{car::Anova}.

Please note that it is possible (or even likely) that there will be disparity
between the \code{grid} and \code{linfct} slots when a submodel is used. This is
because \code{grid} contains the \emph{claimed} values of the predictors and
\code{linfct} contains \emph{aliases} of them computed from the submodel.

For some objects such as generalized linear models, specifying \code{submodel}
will typically not produce the same estimates or type-2 tests as would be
obtained by actually fitting a separate model with those specifications.
The reason is that those models are fitted by iterative-reweighting methods,
whereas the \code{submodel} calculations preserve the final weights used in
fitting the full model.}

\item{(any other slot name)}{If the name matches an element of
\code{slotNames(object)} other than \code{levels}, that slot is replaced by 
the supplied value, if it is of the required class (otherwise an error occurs). 

The user must be very careful in
replacing slots because they are interrelated; for example, the lengths
and dimensions of \code{grid}, \code{linfct}, \code{bhat}, and \code{V} must
conform.}
} %%%%%%% end \describe
}

\section{Replacing levels}{

The \code{levels<-} method uses \code{update.emmGrid} to replace the
levels of one or more factors. This method allows selectively replacing
the levels of just one factor (via subsetting operators), whereas 
\code{update(x, levels = list(...))} requires a list of \emph{all} factors
and their levels. If any factors are to be renamed, we must replace all
levels and include the new names in the replacements. See the examples.
}

\section{Method for \code{summary_emm} objects}{

This method exists so that we can change the way a summary is displayed,
by changing the by variables or the annotations.
}

\examples{
# Using an already-transformed response:
pigs.lm <- lm(log(conc) ~ source * factor(percent), data = pigs)

# Reference grid that knows about the transformation
# and asks to include the sample size in any summaries:
pigs.rg <- update(ref_grid(pigs.lm), tran = "log", 
                    predict.type = "response",
                    calc = c(n = ~.wgt.))
emmeans(pigs.rg, "source")

# Obtain estimates for the additive model
# [Note that the submodel refers to 'percent', not 'factor(percent)']
emmeans(pigs.rg, "source", submodel = ~ source + percent)

# Type II ANOVA
joint_tests(pigs.rg, submodel = "type2")

## Changing levels of one factor
newrg <- pigs.rg
levels(newrg)$source <- 1:3
newrg

## Unraveling a previously standardized covariate
zd = scale(fiber$diameter)
fibz.lm <- lm(strength ~ machine * zd, data = fiber)
(fibz.rg <- ref_grid(fibz.lm, at = list(zd = -2:2)))   ### 2*SD range
lev <- levels(fibz.rg)
levels(fibz.rg) <- list (
    machine = lev$machine,
    diameter = with(attributes(zd), 
                    `scaled:center` + `scaled:scale` * lev$zd) )
fibz.rg

### Compactify results with a by variable
update(joint_tests(pigs.rg, by = "source"), by = NULL)
}
\seealso{
\code{\link{emm_options}}
}
