% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/moons.R
\docType{data}
\name{moons}
\alias{moons}
\title{Moons Data}
\format{
A data frame with 100 observations on the following 2 variables.
\describe{
\item{X}{a numeric vector}
\item{Y}{a numeric vector} }
}
\source{
See the HDBSCAN notebook from github documentation:
\url{http://hdbscan.readthedocs.io/en/latest/how_hdbscan_works.html}
}
\description{
Contains 100 2-d points, half of which are contained in two moons or
"blobs"" (25 points each blob), and the other half in asymmetric facing
crescent shapes. The three shapes are all linearly separable.
}
\details{
This data was generated with the following Python commands using the
SciKit-Learn library:

\verb{> import sklearn.datasets as data}

\verb{> moons = data.make_moons(n_samples=50, noise=0.05)}

\verb{> blobs = data.make_blobs(n_samples=50, centers=[(-0.75,2.25), (1.0, 2.0)], cluster_std=0.25)}

\verb{> test_data = np.vstack([moons, blobs])}
}
\examples{
data(moons)
plot(moons, pch=20)
}
\references{
Pedregosa, Fabian, Gael Varoquaux, Alexandre Gramfort,
Vincent Michel, Bertrand Thirion, Olivier Grisel, Mathieu Blondel et al.
Scikit-learn: Machine learning in Python. \emph{Journal of Machine Learning
Research} 12, no. Oct (2011): 2825-2830.
}
\keyword{datasets}
