% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prior_draws.R
\name{prior_draws.brmsfit}
\alias{prior_draws.brmsfit}
\alias{prior_samples}
\alias{prior_draws}
\title{Extract Prior Draws}
\usage{
\method{prior_draws}{brmsfit}(x, variable = NULL, pars = NULL, ...)

prior_draws(x, ...)

prior_samples(x, ...)
}
\arguments{
\item{x}{An \code{R} object typically of class \code{brmsfit}.}

\item{variable}{A character vector providing the variables to extract.
By default, all variables are extracted.}

\item{pars}{Deprecated alias of \code{variable}. For reasons of backwards
compatibility, \code{pars} is interpreted as a vector of regular
expressions by default unless \code{fixed = TRUE} is specified.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A \code{data.frame} containing the prior draws.
}
\description{
Extract prior draws of specified parameters
}
\details{
To make use of this function, the model must contain draws of
  prior distributions. This can be ensured by setting \code{sample_prior =
  TRUE} in function \code{brm}. Priors of certain parameters cannot be saved
  for technical reasons. For instance, this is the case for the
  population-level intercept, which is only computed after fitting the model
  by default. If you want to treat the intercept as part of all the other
  regression coefficients, so that sampling from its prior becomes possible,
  use \code{... ~ 0 + Intercept + ...} in the formulas.
}
\examples{
\dontrun{
fit <- brm(rating ~ treat + period + carry + (1|subject), 
           data = inhaler, family = "cumulative", 
           prior = set_prior("normal(0,2)", class = "b"), 
           sample_prior = TRUE)

# extract all prior draws
draws1 <- prior_draws(fit)
head(draws1)

# extract prior draws for the coefficient of 'treat'
draws2 <- prior_draws(fit, "b_treat")
head(draws2)
}

}
