% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unfactor.R
\name{unfactor}
\alias{unfactor}
\title{Purge factors}
\usage{
unfactor(var)
}
\arguments{
\item{var}{The variable from which you want the factors removed.}
}
\value{
The variable with all factors converted to characters or numbers
(see \code{details}).
}
\description{
Removes all factors from a variable in a sensible way.
}
\details{
As factors are their own type, to remove factors we must convert each level
into another type.  This is currently done using "typeless" behaviour: a
factor is converted to a numeric vector if this can be done without inducing
NAs, otherwise it is coerced using as.character. Currently supported types
are: \code{factor}, \code{data.frame} and \code{list}.
}
\examples{
# A named factor
x <- factor(sample(1:6, 100, replace=TRUE))
names(x) <- paste("Roll.No", 1:100, sep='.')
x
unfactor(x)

# A data.frame
x <- data.frame(player <- c("Alice", "Bob", "Mary", "Fred"), 
                score <- factor(c(9, 7, 8, 9)), stringsAsFactors=TRUE)
x$player
x$score
y <- unfactor(x)
y$player
y$score

}
\author{
Matthew D. Young \email{myoung@wehi.edu.au}
}
