% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-methods.R
\name{plotErrors}
\alias{plotErrors}
\title{Plot observed and estimated error rates.}
\usage{
plotErrors(dq, nti = c("A", "C", "G", "T"), ntj = c("A", "C", "G",
  "T"), obs = TRUE, err_out = TRUE, err_in = FALSE,
  nominalQ = FALSE)
}
\arguments{
\item{dq}{(Required). An object from which error rates can be extracted. Valid inputs are
coercible by \code{\link{getErrors}}. This includes the output of the \code{\link{dada}}
and \code{\link{learnErrors}} functions.}

\item{nti}{(Optional). Default c("A","C","G","T"). 
Some combination of the 4 DNA nucleotides.}

\item{ntj}{(Optional). Default c("A","C","G","T"). 
Some combination of the 4 DNA nucleotides.

The error rates from nti->ntj will be plotted. If multiple nti or ntj are chosen,
 error rates from each-to-each will be plotted in a grid.}

\item{obs}{(Optional). Default TRUE.
If TRUE, the observed error rates are plotted as points.}

\item{err_out}{(Optional). Default TRUE.
If TRUE, plot the output error rates (solid line).}

\item{err_in}{(Optional). Default FALSE.
If TRUE, plot the input error rates (dashed line).}

\item{nominalQ}{(Optional). Default FALSE.
If TRUE, plot the expected error rates (red line) if quality scores
exactly matched their nominal definition: Q = -10 log10(p_err).}
}
\value{
A \code{\link{ggplot}2} object.
 Will be rendered to default device if \code{\link{print}ed},
 or can be stored and further modified.
 See \code{\link{ggsave}} for additional options.
}
\description{
This function plots the observed frequency of each transition
(eg. A->C) as a function of the associated quality score. It also plots the final
estimated error rates (if they exist). The initial input rates and the expected error
rates under the nominal definition of quality scores can also be shown.
}
\examples{
derep1 = derepFastq(system.file("extdata", "sam1F.fastq.gz", package="dada2"), verbose = TRUE)
dada1 <- dada(derep1, err = inflateErr(tperr1, 2), errorEstimationFunction = loessErrfun) 
plotErrors(dada1)
plotErrors(dada1, "A", "C")
plotErrors(dada1, nti="A", ntj=c("A","C","G","T"), err_in=TRUE, nominalQ=TRUE)

}
\seealso{
\code{\link{learnErrors}}, \code{\link{getErrors}}
}
