# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .execution_activity import ExecutionActivity


class DeleteActivity(ExecutionActivity):
    """Delete activity.

    All required parameters must be populated in order to send to Azure.

    :param additional_properties: Unmatched properties from the message are
     deserialized this collection
    :type additional_properties: dict[str, object]
    :param name: Required. Activity name.
    :type name: str
    :param description: Activity description.
    :type description: str
    :param depends_on: Activity depends on condition.
    :type depends_on: list[~azure.mgmt.datafactory.models.ActivityDependency]
    :param user_properties: Activity user properties.
    :type user_properties: list[~azure.mgmt.datafactory.models.UserProperty]
    :param type: Required. Constant filled by server.
    :type type: str
    :param linked_service_name: Linked service reference.
    :type linked_service_name:
     ~azure.mgmt.datafactory.models.LinkedServiceReference
    :param policy: Activity policy.
    :type policy: ~azure.mgmt.datafactory.models.ActivityPolicy
    :param recursive: If true, files or sub-folders under current folder path
     will be deleted recursively. Default is false. Type: boolean (or
     Expression with resultType boolean).
    :type recursive: object
    :param max_concurrent_connections: The max concurrent connections to
     connect data source at the same time.
    :type max_concurrent_connections: int
    :param enable_logging: Whether to record detailed logs of delete-activity
     execution. Default value is false. Type: boolean (or Expression with
     resultType boolean).
    :type enable_logging: object
    :param log_storage_settings: Log storage settings customer need to provide
     when enableLogging is true.
    :type log_storage_settings:
     ~azure.mgmt.datafactory.models.LogStorageSettings
    :param dataset: Required. Delete activity dataset reference.
    :type dataset: ~azure.mgmt.datafactory.models.DatasetReference
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
        'max_concurrent_connections': {'minimum': 1},
        'dataset': {'required': True},
    }

    _attribute_map = {
        'additional_properties': {'key': '', 'type': '{object}'},
        'name': {'key': 'name', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'depends_on': {'key': 'dependsOn', 'type': '[ActivityDependency]'},
        'user_properties': {'key': 'userProperties', 'type': '[UserProperty]'},
        'type': {'key': 'type', 'type': 'str'},
        'linked_service_name': {'key': 'linkedServiceName', 'type': 'LinkedServiceReference'},
        'policy': {'key': 'policy', 'type': 'ActivityPolicy'},
        'recursive': {'key': 'typeProperties.recursive', 'type': 'object'},
        'max_concurrent_connections': {'key': 'typeProperties.maxConcurrentConnections', 'type': 'int'},
        'enable_logging': {'key': 'typeProperties.enableLogging', 'type': 'object'},
        'log_storage_settings': {'key': 'typeProperties.logStorageSettings', 'type': 'LogStorageSettings'},
        'dataset': {'key': 'typeProperties.dataset', 'type': 'DatasetReference'},
    }

    def __init__(self, **kwargs):
        super(DeleteActivity, self).__init__(**kwargs)
        self.recursive = kwargs.get('recursive', None)
        self.max_concurrent_connections = kwargs.get('max_concurrent_connections', None)
        self.enable_logging = kwargs.get('enable_logging', None)
        self.log_storage_settings = kwargs.get('log_storage_settings', None)
        self.dataset = kwargs.get('dataset', None)
        self.type = 'Delete'
