/*!
[config]
name: Int arithmetic
clc_version_min: 10

dimensions: 1
global_size: 1 0 0

## Addition ##

[test]
name: pos+pos
kernel_name: add
arg_in:  1 int 1
arg_in:  2 int 2
arg_out: 0 buffer int[1] 3

[test]
name: pos+neg
kernel_name: add
arg_in:  1 int 3
arg_in:  2 int -4
arg_out: 0 buffer int[1] -1

[test]
name: neg+pos
kernel_name: add
arg_in:  1 int -2
arg_in:  2 int 5
arg_out: 0 buffer int[1] 3

[test]
name: neg+neg
kernel_name: add
arg_in:  1 int -2
arg_in:  2 int -3
arg_out: 0 buffer int[1] -5

## Subtraction ##

[test]
name: pos-pos
kernel_name: sub
arg_in:  1 int 1
arg_in:  2 int 2
arg_out: 0 buffer int[1] -1

[test]
name: pos-neg
kernel_name: sub
arg_in:  1 int 3
arg_in:  2 int -4
arg_out: 0 buffer int[1] 7

[test]
name: neg-pos
kernel_name: sub
arg_in:  1 int -2
arg_in:  2 int 5
arg_out: 0 buffer int[1] -7

[test]
name: neg-neg
kernel_name: sub
arg_in:  1 int -2
arg_in:  2 int -3
arg_out: 0 buffer int[1] 1

## Multiplication ##

[test]
name: pos*pos
kernel_name: mul
arg_in:  1 int 3
arg_in:  2 int 4
arg_out: 0 buffer int[1] 12

[test]
name: pos*neg
kernel_name: mul
arg_in:  1 int 3
arg_in:  2 int -3
arg_out: 0 buffer int[1] -9

[test]
name: neg*pos
kernel_name: mul
arg_in:  1 int -2
arg_in:  2 int 5
arg_out: 0 buffer int[1] -10

[test]
name: neg*neg
kernel_name: mul
arg_in:  1 int -2
arg_in:  2 int -3
arg_out: 0 buffer int[1] 6

[test]
name: 0*num
kernel_name: mul
arg_in:  1 int 0
arg_in:  2 int -3
arg_out: 0 buffer int[1] 0

## Division ##

[test]
name: pos div pos
kernel_name: div
arg_in:  1 int 8
arg_in:  2 int 4
arg_out: 0 buffer int[1] 2

[test]
name: pos div pos (remainder)
kernel_name: div
arg_in:  1 int 7
arg_in:  2 int 4
arg_out: 0 buffer int[1] 1

[test]
name: pos div neg
kernel_name: div
arg_in:  1 int 8
arg_in:  2 int -4
arg_out: 0 buffer int[1] -2

[test]
name: pos div neg (remainder)
kernel_name: div
arg_in:  1 int 8
arg_in:  2 int -3
arg_out: 0 buffer int[1] -2

[test]
name: neg div pos
kernel_name: div
arg_in:  1 int -20
arg_in:  2 int 5
arg_out: 0 buffer int[1] -4

[test]
name: neg div pos (remainder)
kernel_name: div
arg_in:  1 int -2
arg_in:  2 int 5
arg_out: 0 buffer int[1] 0

[test]
name: neg div neg
kernel_name: div
arg_in:  1 int -9
arg_in:  2 int -3
arg_out: 0 buffer int[1] 3

[test]
name: neg div neg (remainder)
kernel_name: div
arg_in:  1 int -8
arg_in:  2 int -3
arg_out: 0 buffer int[1] 2

[test]
name: 0 div num
kernel_name: div
arg_in:  1 int 0
arg_in:  2 int -3
arg_out: 0 buffer int[1] 0

[test]
name: 0 sdiv24 num
kernel_name: sdiv24
global_size: 355 0 0

arg_out: 0 buffer int[355] \
  4194304   4194303   4194302   4194301   4194300 \
  2097152   2097151   2097151   2097150   2097150 \
  1398101   1398101   1398100   1398100   1398100 \
  1048576   1048575   1048575   1048575   1048575 \
  1048576   1048575   1048575   1048574   1048574 \
        1         1         1         1         1 \
        1         2         2         2         2 \
        1         1         1         1         1 \
        1         1         1         1         1 \
        3         3         3         3         3 \
  4194303   2097151   1048575    524287    262143 \
      128        64        32        16         8 \
       73        73        73        73        73 \
        0         0         0         0         0 \
        1         0         0         0         0 \
        0         1         2         0         0 \
        5         1         1         1         0 \
        8        12         0         0        25 \
       14         0         1         1         0 \
        0         2         1         1         0 \
        1         1         2         0         1 \
        1         2         2         1         3 \
        0         1         0         0         1 \
       11         0         1         0         0 \
        1         0        71         0         5 \
        0         0         1         0         0 \
        1         0         4         0         0 \
        0         1         0        13         0 \
        1         1         0         1         3 \
        3         0         0         2         4 \
        1         1         3         0         0 \
        1         0         1         0         1 \
        2         1         0         1         1 \
        0         3         0         7         0 \
        0         1         2         1         5 \
        0         2         2         0         0 \
        3         0         0         0         1 \
        0         0         0         3         0 \
        1         0         2         0         0 \
        0         0         1         0         1 \
        0         0         0         1         0 \
        3         1         2         4         0 \
        1         3         0         1         0 \
        0         2         0         2         0 \
        1         2         1         1         3 \
        6         2        16         2         1 \
        1         1         0         1         1 \
        1         1         0         1         0 \
        1         1         0         0         0 \
        1         0         0         1         0 \
        0         0         1         1         0 \
        2     16102         3         2       460 \
      189     14700        16      1973         3 \
     3407       243        16         7         7 \
       30       916         4         4         4 \
        7         2         3       111         2 \
      354        28         2         4        20 \
        2        25         8       102        52 \
        4     12707       457       446        16 \
      390         2         2       484         4 \
      452         2      6129       121        15 \
    14102        32        24         7         2 \
     3445        91      7801       203      3415 \
     3526      3216      3435        14         2 \
    15272       106      3995       231         4 \
      119        93        54         2         7 \
     4039      6376       403       114      1007 \
        2     13826        31        49         3 \
        2        99         8         2        20 \
      981         2         8       403       418 \
    15544        14       793         2       461

arg_in: 1 buffer int[355] \
  4194304   4194303   4194302   4194301   4194300 \
  4194304   4194303   4194302   4194301   4194300 \
  4194304   4194303   4194302   4194301   4194300 \
  4194304   4194303   4194302   4194301   4194300 \
  2097152   2097151   2097150   2097149   2097148 \
  4194304   4194303   4194302   4194301   4194300 \
  8388607   8388606   8388605   8388604   8388603 \
  8388607   8388606   8388605   8388604   8388603 \
  8388607   8388606   8388605   8388604   8388603 \
  8388607   8388606   8388605   8388604   8388603 \
  8388607   8388607   8388607   8388607   8388607 \
      256       256       256       256       256 \
      512       512       512       512       512 \
        0         0         0         0         0 \
        1         1         1         1         1 \
  2979154   6753052   6380637    745879   2044138 \
  1362651   5623691   7556755   1817112    653128 \
  4540757   6916694   2152628    336974   6440813 \
  7753274   4493549   7589573   7127753   6896606 \
   457922   5379573   5538264   8383319   1250739 \
  8128290   6590324   3890066   2273701   2004798 \
  4596665   6439101   2707547   4693889   6783292 \
   822586   3935947   3672533   3170889   3522056 \
  6845951   1610280   4474418   4894485   2165083 \
  5149169   5400655   7206151   3939084   5740982 \
  1873514    973662   6453724   2490622   1311857 \
  6444329   1500740   4797061   2969651   3545490 \
   475536   2787289   3607791   5234886   3861387 \
  8307298   6284845   2884844   3471932   8208841 \
  4298852   1820043    295683   7241817   7933251 \
  7603438   7801724   5760280   6857926   3663698 \
  5183095   2484306   4525410   2365300   5253814 \
  2543246   4360869   1525129   5779334   6449051 \
  2115084   8383882   4897039   4524730   2814575 \
  1364704   5309564   4215537   3231697   6235321 \
   561491   7000308   7759914   2602630   3663613 \
  5831268   1066556   2169937   2221054   6441632 \
   785124   2745640   4461936   6873947   6343820 \
  5005296   1441023   6721520   2482992   3742156 \
  5431578   6814824   2276261   1421383   7610845 \
  1481232   5283796    782357   5180762   4522289 \
  4767192   8360999   8170473   8221163   1681881 \
  3733111   6870659   1728881   7986519   4273626 \
  5427260   4774740   1166826   4015262   4409405 \
  4430916   2748008   6647674   6275274   5869091 \
  7083444   6317193   8156798   5819738   3952297 \
  6833047   4092818   2699422   7392134   7712778 \
  4770844   7770143   5259762   6489532   7987430 \
  6754825   6372640   5270110   5028778   6100259 \
  6830159   6426636   4321329   6873879   5530169 \
  6005210   8244672   6984479   8252174   4704495 \
  5727646   5168742   6170802   6765788   4463380 \
  5850495   7114800   6908672   7335614   5753424 \
  5696504   7363386   7160224   5776022   6323030 \
  4390230   6886488   7588836   5168592   6458420 \
  7338646   6901286   5450364   4413360   7520468 \
  5079192   5361328   7965390   6169528   4370420 \
  5954010   5984825   5858784   6275652   5785572 \
  8156996   5768978   5666343   4425212   6996016 \
  5543460   7184304   7003108   6475436   7209180 \
  7371216   8032192   5840937   7703586   7329525 \
  6909980   5931840   5317296   6689711   8214800 \
  6169995   5620251   7886811   5715059   6331410 \
  6082350   5515440   6176130   6224456   6199332 \
  7483280   4713608   6967280   6176016   5600372 \
  6027231   5902431   6247476   7466360   6776609 \
  6409893   5445104   5500547   7023312   7225225 \
  7877084   6277004   7398801   5411854   5517063 \
  5271250   4405005   8342184   7798224   4521460 \
  7415379   7621450   8093824   6582602   5220820 \
  5098432   6298670   5343234   7562242   5522319



arg_in: 2 buffer int[355] \
        1         1         1         1         1 \
        2         2         2         2         2 \
        3         3         3         3         3 \
        4         4         4         4         4 \
        2         2         2         2         2 \
  4194304   4194303   4194302   4194301   4194300 \
  4194304   4194303   4194302   4194301   4194300 \
  8388607   8388606   8388605   8388604   8388603 \
  4194304   4194304   4194304   4194304   4194304 \
  2097152   2097152   2097152   2097152   2097152 \
        2         4         8        16        32 \
        2         4         8        16        32 \
        7         7         7         7         7 \
  8388607   8388606   8388605   8388604   8388603 \
        1         2         4         8        16 \
  3453909   4624245   2997164    759258   4666130 \
   270958   5214987   6596089   1102959    862520 \
   514039    547793   6655827   7287184    254718 \
   552729   5626272   6368718   3720911   7366273 \
  2959224   2040530   5468045   5608568   7479827 \
  7266398   3584004   1647394   5541497   1105262 \
  3895038   2208000   1230576   4299520   1858435 \
  5747563   3194390   4242354   5208158   1945525 \
   610624   2486803   4113710   6881272   3658035 \
  4111441   5686340    101112   5165548    965599 \
  4864673   6117962   5364449   7488617   2042436 \
  5277537   6075126   1021545   3753741   7608654 \
  7819368   1825029   4122996    381945   6570070 \
  7589583   4868867   8372086   3089699   2246267 \
  1404379   3061063   2109514   2500926   1964108 \
  6152122   3918794   1810758   8359664   5981339 \
  3918856   5434703   4101354   3147359   2770028 \
  1233964   3748389   6733875   5095757   5445410 \
  8131748   2698389   6090508    640718   3319302 \
  2300071   3905106   1671845   3044422   1133156 \
  2336272   3256196   2638892   3164061   7958395 \
  1535860   1743852   5848041   5880074   6056105 \
  5354783   4011408   5622068   1803432   6626313 \
  4376076   1560226   2346988   5722744   3886637 \
  6288477   7044863   1740203   4017687   6977149 \
  8079739   7591054   5842335   5148997   7681353 \
  1525157   4414078   3857386   2002153   1710827 \
  2357350   2006540   7232538   4911098   4274577 \
  6869354   2059694   4804759   1505201   4977855 \
  2580540   1036732   6092334   3974508   1919050 \
  1100946   2997483    484462   2509936   3460810 \
  5450808   3162628   6771179   6989778   6308185 \
  4533478   6173877   8258100   4272041   8118853 \
  6077321   5226685   7635682   6422056   7430592 \
  6005499   8007875   5792520   5326839   6311662 \
  7090869   8300881   6950325   7893465   7776995 \
  2863823       321   2056934   3382894      9703 \
    30955       484    431792      3718   1917808 \
     1672     30302    447514    825146    903290 \
   146341      7518   1897209   1292148   1614605 \
  1048378   3450643   1816788     39760   3760234 \
    14348    191476   3982695   1542382    218521 \
  2977005    239393    732348     61526    111261 \
  2039249       454     12399      9922    437251 \
    14214   3592152   3501554     13379   1802295 \
    16308   4016096       953     63666    488635 \
      490    185370    221554    955673   4107400 \
     1791     61761      1011     28153      1854 \
     1725      1715      1798    444604   3099666 \
      490     44468      1744     26736   1400093 \
    50649     63467    115694   3733180    968087 \
     1587       854     13649     61608      7175 \
  3938542       454    238671    110446   1839021 \
  2635625     44495   1042773   3899112    226073 \
     7559   3810725   1011728     16334     12490 \
      328    449905      6738   3781121     11979

[test]
name: 0 sdiv25 num
kernel_name: sdiv25
global_size: 700 0 0

arg_out: 0 buffer int[700] \
         7         98       8761         14      72372 \
      5410      14019        554        184        196 \
        45         32        301        376      33184 \
      1999         64        142       2445          0 \
      2460      18792      52812      39831       9404 \
       278        142      83041       5148      20713 \
      4125       1246        184          8        307 \
      1639         71         33         13       2699 \
     38376        620       8839      45584      50875 \
         0         20         37        156      11007 \
       600          3       2543         15      17994 \
       536       2335         77         29          0 \
       142          6        353      89737         81 \
       301      25466       6176       2565       1217 \
         1       8625      20534      19029       2789 \
        30       4505          4       2407        803 \
      2446          0       8209       3008          0 \
       143      42803        141      66603          3 \
      2321       7182      18040         18        353 \
        17         21          9        564        797 \
        48         76         81        129      23856 \
        49         16        337        156        148 \
        59       4267       3741      19951          2 \
       563         31       9448        361       4276 \
     47144        429      34433       5210        158 \
       147      37331      48580      45559          1 \
      2094       2068        140       7877         58 \
       611         64         41         36       3206 \
     22206          1       4982          9       8836 \
         0        104         41          0      25391 \
     47590        186         10        134       6505 \
      8477      58939      12342       1124       4291 \
      9434          2       4625         32          0 \
       133       8421         72       6644      36901 \
         2       1676      59615         14       4067 \
      1360      21926          0         33        456 \
        19      18557      14331      16970        206 \
     10282       1070         17          9       1610 \
       672         14          7      68530          0 \
         1       1055         64      67575      91904 \
         6        369        601        449        560 \
      1774          2          0        276        705 \
     11908        541       4449          0         30 \
        71          1        469          0      32534 \
       608        586          1      18108          7 \
      1097          2        408         32      18591 \
        18      10693         81       4319      44259 \
     61284      48128          8         41          1 \
     11877      34549         27        318         31 \
     48455       4733         75       1120        337 \
      1806      42977       2350      11540          9 \
     19463      34204       1765      64304        140 \
        32        258        146         74        307 \
         0          9          9        468       1822 \
       197      18614       8641      32011          5 \
      4908       1142      44681      71124      37612 \
         4         67      19881      76192         32 \
      1271        288        299          9      86711 \
     37685       8460         77       2079          3 \
       267         19         79         17         21 \
       263       1096          1          1        121 \
     32743        257      51801         21      37618 \
      3508       4118      19995       1361       1455 \
     20390        569         69        271      39001 \
      1628       2072        340       2195          1 \
     40798         35         34       1518         12 \
         4        644      66154      13959          0 \
        33         14          2        689         65 \
         7        153       4904        563        128 \
        35         22         36         16          0 \
        33        316       8226       1049          0 \
     72356         16          4          1       8710 \
        16      76440          4        443       1197 \
     69173          1       2592       4256        702 \
      2293       4672         10        566        532 \
       632          1        632      48079       3935 \
     17801        153         52       3136        490 \
         2          8          1         64         46 \
      5033      43565         98        366      79795 \
     69779         15          4          0      76836 \
      9607      39745         49          4          2 \
         0       2979       1415         30        829 \
        32       1107       7715          8         70 \
      7571      30278         15       1123        620 \
       170         24        521        124         20 \
     36614          0          0          0          7 \
     37108       7655       4347      36211         42 \
       168       1165        642        290          4 \
        58          0          7      20043      17112 \
     43705         15       4121         36       4227 \
       859          4       4356        150        168 \
       585      54349        234      10176      89520 \
        16        569         50        332         36 \
       542        129         38          8      29280 \
       315      13474       2504      33161        137 \
     31254         33         12          4      67985 \
       177       8799          2         83      20475 \
         1       3409       8192      11143      22310 \
         9         24      29282       1185         44 \
        22      72118       2163        155      30147 \
      8942       2315          0          7       1220 \
      9108         18         48          4        153 \
      5601      18044      18920          0      65769 \
         0      75751         68         32         51 \
        57         32       1115      69014       1246 \
       174         47       4313       9044       8659 \
      8997      17154         35      12809       1703 \
     31203       3019          0       1081        601 \
     13938          5        350       3148       3001 \
        50       4050         72      87777        133 \
      3079        518        154          0         61 \
     75618         45      10794         99        346 \
       159       2057          9       1411      41066 \
         0      44974         74      34672         19 \
     68657         33      69020       1097        626 \
         0          0      18204      70148       1101 \
       419      16864       5060        142       1615 \
        71         66        709       4228      11818 \
        26          4        564         79       6927 \
      2156         30       1066        182        301 \
      41127       9381      28010      34246      18646 \
        22        837        301          2          4 \
        19       1274          0      23203          4 \
       291        683       4480      73471         52 \
       172        368          2        523          4 \
       114        324        162        202          5 \
     17226         62      81551         67       5950 \
      1134         65         26      57268          9 \
      2203          0          1          7      27166 \
        35       1111      36418      24361          0 \
     37893         75        673          0      32045 \
     87433         17          5          1       1166 \
     34573         25       2246        262         22 \
      7124          1      19861       4157      72343 \
        20          0       8683      35464        527 \
       446      10842         10          1      22214 \
        38        447          0          9          1 \
      5631      34908       1279       8473          5 \
         0      78793       8743       8788      69563 \
         0         19      37187       4577        537

arg_in: 1 buffer int[700] \
  16062639   12942170   15710265   16726589   15343075 \
  16243821   13725579   14098109   16104249   15901839 \
  15411609   15531548   13860893   16623437   14767324 \
  16139999   16177979   13776047   14871679   14977586 \
  12875951   14075956   12675119   16291287   15706349 \
  13820543   12619463   16193189   15663257   14458371 \
  15992375   15021361   14762074   12431726   15937151 \
  13405359   12370895   14846065   16044713   15427799 \
  14352997   15357950   14992639   10940399   12820751 \
  15330121   15557660   15483935   12995988   14717695 \
  14951677   15694163   15022319   16207039   12758454 \
  15141788    9565919   16663763   14465399   14598558 \
  14316587   14186542   14864813   16332315   14916701 \
  13436583   15738605   15065702   10346111   15713417 \
  16484295   12093651   15011084   16765429   16335449 \
  15917662   15694397   16543669   14452815   12969323 \
  16375323   16586667   10976769   16684904   15045376 \
  15729839   15751871   12259711   16650999   16583407 \
  13277195   13367562   16110612   16465513   16659593 \
  15336791   11166473   14960349   16559584   15983141 \
  11751277   15289658   15262085   14452099   14743625 \
  16693449   15365568   13058291   15260085   16489680 \
  13518419   15159935   15222455   14425295   16507718 \
  15850091   14752479   16715280   13696631   15512678 \
  16453604   13158429   14462279   10364678   15340637 \
  16753155    9519659   15011528   14078039   14426643 \
  16653154   11209841   14585603   14156765   13660918 \
  12946859   15675009   16558289   14030917   16153658 \
  16077867   16514821   16463831   15270639   13485261 \
  15820590   12952589   15831395   15726078   12238943 \
  15562256   15092956   16653009   13429799   15653435 \
  15692777   14852879   12120825   13579874   13901787 \
  15416789   16554653   14854085   11613293   16369653 \
  13800659   15277507   13659467   13216904   16605899 \
  15122906   13535066   13294367   15525989   16040123 \
  15959085   16664519   15380114   14503345   14103019 \
  16262539   15811415   12626491   12303974   12242807 \
  14972047   15745841   16714403   15197579   12483638 \
  15382760   14884739   15696295   15350943   16377568 \
  16169071   11268575   13417559   12501559   16542899 \
  14281357   16677009   14745387   14255549   11709191 \
  16434724   15750638   16406963   15569061   16165281 \
  13802530   14309341   16229149   14464852   16159369 \
  15414119   16039531   13595689   14975264   14575679 \
  13440020   14264686   15486009   13708512   16247575 \
  16272359   16438637   16217667   15956720   12977215 \
  15133841   16436677   13242343   15184799   15933599 \
  15505104   12128507   16336853   15290393   15482721 \
  16451029   15305649   14501703   15095398   16554015 \
  16135847   12947489   14913023   15708572   14577601 \
  13451307   15128255   16393522   15153332   12670599 \
  16174583   15768504   12414979   14211404   14445872 \
  14051828   14081829   15952145   14489699   13475923 \
  15596967   15153079   15754709   14473339   14168355 \
  16116209   13477259   12064231   16294107   16386389 \
  13259208   15691103   16487657   13869374   15082812 \
  16402444   16278519   10020527   14476669   13827197 \
  14042879   15145622   12705299   15972599   16215143 \
  14697539   15585161    9788453   11294399   16013479 \
  13267875   15486339   14447599   16313183   15224087 \
  13389551   13425085   16772295   14105917   14924991 \
  16568463   11386571   12121667   14996321   12978554 \
  14085125   15763412   14477103   16132889   15133663 \
  15599114   14786369   14713019   15228463   16224831 \
  15408710   15580667   15162223   12732407   16309251 \
  15911609   13844699   15395344   11463892   14806492 \
  14498494   16461044   16538749   13443479   13669973 \
  13730287   14942984   15985499   14976449   10856999 \
  16419591   13592039   15063254   16093739   15419627 \
  15337727   15647037   15091189   13865726   15118736 \
  16666493   16393020   12455677   12505499   16624817 \
  15990896   16538908   15341884   15654313   12160555 \
  15461108   14523789   15172854   15875663   16301185 \
  16670933   13913585   10452382   15001667   14186539 \
  15798777   13846098   15534859   14767514   12904995 \
  15389495   16739001   16721960   14568239   15862079 \
  14223797   15169461   16568806   16776675   14927381 \
  12055244   14697665   15939107   12446654   14179664 \
  15021455   16119419   11646161   15907247   15320831 \
  14793359   16346079   14395749   15534105   13830659 \
  15555351   12281513   12273399    9979914   16732292 \
  16134058   15043039   16182047   15380184   15956749 \
  14549006   16366267   14691263   16115399   16653049 \
  14227787   14866988   15867759   16623959   15194627 \
  15556724   15583449   16381403   16057374   15368891 \
  16659824   13966497   15423320   15222603   14332239 \
  13433457   14577023   16683275   16005703   16001804 \
  16296162   15650051   15666051   13013810   15354124 \
  15083172   15985650   14714071   16676607   16411366 \
  15734159   14466623   15259643   16370612   11855311 \
  13080599   16426939   11650617   16629025   15948529 \
  12390969   12717899   14235594   15499570   16113779 \
  12960952   14868449   12853325   16159490   12188909 \
  15792611   12263029   16003922   14770628   13322854 \
  14099919   16210424   15160259   14690765   11471249 \
  16721424   15651797   12954135   16345234   15092891 \
  16476391   16288799   12263345   14190371   14845099 \
  14849799   12947769   15918998   15802191   16465517 \
  16213089   12921149   14905046   16080973   15594749 \
  14893488   15938298   16600043   13317407   15254887 \
   9121859   15396767   16112336   16281879   16142840 \
  13481319   16337567   15839102   16372794   15164225 \
  16100147   16168319   14323196   16521327   14732479 \
  14249398   15453407   15517616   16013381   15298451 \
  13330429   14921906   12688919   14493149   14089852 \
  15557849   15588671   14400131   16416674   13492279 \
  16754275   16057079   15473771   16191839   13681415 \
  13916983   11500159   15188288   16517811   12416851 \
  13437195   11546669   14538770   11956752   15706463 \
  12075014   14927934   16324989   15887817   16290379 \
  16006759   16488629   14236904   15077907   14518787 \
  15955608   11847805   15609569   16726399   16322185 \
  14380799   13597205   14921449   15094279   14660918 \
  14653312   14976674   16143149   15429484   13317799 \
  16340603   15320093   14563430   13616297   15492542 \
  16692195   15295807   15456044   16414865   13919361 \
  13387499   16409644   13902566   12046748   12026271 \
  16132823   11508522   11614889   14116401   16522961 \
  16398638   14737929   15955034   16673679   15948255 \
  14454056   15613552   14796088   16460483   16534801 \
  14477055   15827433   13445279   15171420   15421068 \
  14747783   12030327   15294789   15195542   15553959 \
  15456499   15662099   14416043   15917943   15512049 \
  16220015   14120495   11749181   14327039   13806287 \
  15167428   14852249   15926468   13317459   16226244 \
  13533544   15823924   16535208   13262395   15646703 \
  14677403   16307675   13619183   15598315   15930826 \
  14084214   16762019   13302251   14489056   13389029 \
  15434611   14898517   15362013   15725479   12360984 \
  15995195   12246455   12163945   12059189   15461451 \
  16635465   13106883   14112211   14486456   14164331 \
  16087855   12609395   16640597   15625871   15414902 \
  12896101   13208831   15254882   14521018   15179999 \
  14321249   15699585   16564907   16411625   14758175 \
  16307213   15247460   11888395   16597619   13415951 \
  12358208   16047639   15727656   16744143   13728869 \
  16486937   13628159   16420522   13616369   14251343 \
  10610687   15325050   14085119   13727879   15455027 \
  14298100   16546739   16281327   14466693   14469311 \
  16013018   12653299   15209891   16618139   15473955

arg_in: 2 buffer int[700] \
   2007830     130729       1793    1115106        212 \
      3002        979      25402      87050      80720 \
    335035     470653      45897      44094        445 \
      8070     248892      96336       6080   14977587 \
      5232        749        240        409       1670 \
     49536      88248        195       3042        698 \
      3876      12046      79795    1381303      51744 \
      8174     171818     436649    1146051       5714 \
       374      24731       1696        240        252 \
  15330122     740841     407472      82777       1337 \
     24878    3923541       5905    1012940        709 \
     28197       4095     213638     482180   14598559 \
    100116    2026649      41991        182     181911 \
     44492        618       2439       4032      12901 \
   8242148       1402        731        881       5855 \
    513473       3483    3308734       6002      16131 \
      6692   16586668       1337       5545   15045377 \
    109235        368      86336        250    4145852 \
      5718       1861        893     866606      47061 \
    852044     507567    1496035      29309      20029 \
    239822     198567     186123     111170        618 \
    333869     903857      38634      97198     110669 \
    225307       3552       4068        723    5502573 \
     28103     461015       1769      37836       3627 \
       349      30601        420       1989      96482 \
    113197        255        309        309    7213322 \
      7949       5418     103444       1797     231541 \
     21155     241154     394245     379214       5037 \
       724    8257411       3304    1527064       1526 \
  15820591     123358     376938   15726079        482 \
       327      80711    1513910      99480       2406 \
      1851        252        982      12071       3239 \
      1634    5518218       3211     351918   16369654 \
    102990       1814     187116       1989        450 \
   5040969       8071        223    1035066       3943 \
     11726        760   15380115     426569      30860 \
    813127        852        881        725      59144 \
      1456      14702     928578    1519758       7749 \
     22857     992316    1962037        224   16377569 \
   8084536      10671     206424        185        180 \
   2040194      45073      24494      31679      20872 \
      9259    5250213   16406964      56206      22897 \
      1159      26401       3647   14464853     521270 \
    214085    8019766      28927   14975265        448 \
     22069      24301    7743005        757    2030947 \
     14820    5479546      39652     483537        698 \
    796518       1537     161492       3515        360 \
       253        252    1815206     364057    7741361 \
      1385        443     517918      47321     517313 \
       333       2735     196224      14013      43129 \
      7444        352       6973       1313    1267060 \
       831        461       7030        221     102453 \
    425813      54370     108518     193196      43753 \
  15596968    1515308    1575471      30860       7772 \
     81395        724       1396        509    2731065 \
      2701      13728        369        195        401 \
   3280489     239390        504        190     419006 \
     11040      52407      42351    1597260        187 \
       390       1842     125493       5430    4003370 \
     49507     774317     180595     906288     692004 \
     50718      12238    8386148    7052959     122336 \
       506      44134        234     681651        345 \
      4014       3827        724      11845      10394 \
       765      25941     210186      55987        416 \
      9459       7516      44464       5798    8154626 \
       390     384575     439867       7547    1138961 \
   2899699      25521        250        963   13669974 \
    403832     996199    5328500      21705     164500 \
   2052449      88260       3071      28535     119532 \
    426048     680306     407870     815631   15118737 \
    490191      51713       1514      11910   16624818 \
       221     972877    3068377    7827157       1396 \
    909477        190    3034571      35756      13607 \
       241    6956793       4031       3524      20180 \
      6887       2963    1412260      26045      24212 \
     24312    8369501      26417        303       4030 \
       799      98503     312619       5348      30402 \
   4018415    1633074    7969554     191487     301695 \
      2984        370     117638      43344        192 \
       212    1021630    2879150   15534106        180 \
      1619        309     245468    1995983    5577431 \
  16134059       5048      11428     496135      19225 \
    440879      14771       1904    1790600     234550 \
      1879        491     991735      14790      24468 \
     90975     623338      31382     128459     731852 \
       455   13966498   15423321   15222604    1791530 \
       362       1904       3837        442     372135 \
     96427      13422      24364      44721    3070825 \
    255647   15985651    1839259        832        959 \
       360     904164       3702     442449       2804 \
     15210    3285388       2674     110126      94370 \
     21145        234      60577       1523        180 \
    762409      26085     252026      48527     329430 \
     29084      94331     410357    1641181        455 \
     44620       1203       6052        443      83125 \
       535     460347     996472    3269047        222 \
     92564       1851    4087782     168933        725 \
   7424900       3797       1943       1418        738 \
   1621309     516846        509      13559     346550 \
    647543        221       7671      85368        506 \
    1020       6648   16112337    2035235      13221   \
      1480     859872     323247    3274559      98469 \
      2874        896        757   16521328        224 \
  14249399        204     224893     485254     294201 \
    229835     452179      11370        210      11299 \
     88902     324764       3338       1815       1558 \
      1862        936     429827       1264       8029 \
       446       3808   15188289      15266      20626 \
       964    1924445      41421       3797       5232 \
    236765       3685     223630        181     121570 \
      5197      31770      91851   15077908     234174 \
       211     257561       1446     167264      47038 \
     89880       6607    1492145      10690        357 \
  14653313        333     215242        445     665890 \
       238     450591        211      12401      24709 \
  16692196   15295808        849        234      12631 \
     31875        973       2747      84243       7442 \
    224067     171769      16359       3338       1398 \
    607357    2947586      28239     208421       2302 \
      6701     503663      13867      89948      54751 \
       352       1687        480        443        827 \
    641208      14356      50645    5065181    3110792 \
    772825      12284   14416044        686    3102410 \
     55548      20644       2622        195     260496 \
     87673      40250    5308823      25415    3245249 \
    117683      48689     101443      65332    2607784 \
       852     258852        167     229387       2677 \
     12409     253970     492676        253    1338903 \
      7003   14898518    7681007    1965685        455 \
    444311      11013        334        495   15461452 \
       439     172459      20938   14486457        442 \
       184     700522    2773433    7812936      13209 \
       373     508032       6789      55213     660000 \
      2010    7849793        834       3947        204 \
    776534   15247461       1369        468      25409 \
     27647       1480    1429787    8372072        618 \
    422742      30420   16420523    1361637    7125672 \
      1884        439      11004       1620    2575838 \
  14298101        210       1862       1646        208 \
  16013019     632665        409       3630      28762

[test]
name: 0 sdiv25_1
kernel_name: sdiv25_1
global_size: 400 0 0

arg_out: 0 buffer int[400] \
      -4313       20974           3         151        -309 \
        -32        5682      -10153         -37       -2403 \
       2923        -277          -2         131         594 \
         73        -280        1427         -11          -4 \
         11       -2726       17260       39754      -49254 \
       5372       -1136        -177       38715         185 \
     -85671        -236          44           6       40276 \
         20      -42890       37789        -148       -1391 \
        -49        2919        1266           4        -630 \
       1137          -1      -34954          28      -70401 \
          8          -9      -21849       10341        8778 \
      -3824        2241         982        9515         386 \
       -152         -36      -17538      -39012      -39861 \
         33       -7055        1346           4         -41 \
     -33202           8         309      -17334      -14042 \
      64423       -2095         152        -195         336 \
        -64         641       19212       36031           4 \
       -514        2364        -356        2735          -6 \
        287          45        1132         865          37 \
          3      -77088       33704           2          19 \
         -4       92008           2       34539         211 \
         63         261         591        4890        3744 \
      -4442        3049      -10013        2748       16763 \
        -79         -18        -310          -5         532 \
       9999       -1453       -3436          -1        9513 \
        -32        -534          -2          -3           5 \
       -642       -8321       72552         -37          34 \
      -4025      -68763      -48872       72704        2437 \
        -79        1038        1762       -8285        -169 \
       -559      -18475       -8416       -2139          12 \
          2        -165         -33        -111          90 \
       -340         659      -22523          32          -4 \
      -2126        8957       -6325         259           9 \
      -1429         -64      -27965      -14163           7 \
        -23           8          -6         621         -16 \
      -3065        -645          45      -17252      -37905 \
       -526          37         608         -36       16433 \
          6          17          -5        -516          -9 \
         -4       -1033           8          -9        4737 \
      -3885           4       67846         343          -5 \
        -10          16      -69830         -67         444 \
     -68415      -45915           8           9        6617 \
      -9303       17166         133        -617       -3470 \
         64          -2       -1453        -205       -4901 \
      18924        1345        1700          -2        -263 \
         -2        2515         775       -8620        -165 \
       -134          19         343       15484      -70975 \
     -69181        -259        1235         310      -75784 \
        131      -13470       -1033       68196        1052 \
      -9975           6       10608        1458       -1079 \
      31283         312          10          -1         110 \
      35188      -88729      -45666       88168        -536 \
      -1270        8890          65        9797        -199 \
     -40019          -6      -61621         -69        1529 \
     -10917         -10         -23           8        2559 \
        130           7          16       37205         -32 \
          1       -1117         241         -14        1035 \
         -2           8         -17          35      -61728 \
        -74      -17748           9        1439         -12 \
        577          -2        9401        1374          11 \
      13093          -7       -1185        -644         -88 \
         24         384         -19        -462           9 \
      -7516          63        9156       -9402       21459 \
      26857       36005        2238       -4872         478 \
        -52          15       65988        -192         -66 \
       9861      -71355       19031       -2086         -16 \
        -20       35676         413          -1      -91673 \
     -44575        -212        -519      -36527      -14565 \
         -2          68          22        -659         412 \
       8790       74312       34643       -2051         113 \
      -5311         420         -37         -64       60967 \
         29       16830           2          62      -17388 \
      -1084       44133           2           2         -10 \
         -4      -16077      -34862         119      -49064 \
         -4      -42588      -19451         -24         156 \
       6181           6        -669         581       23895 \
        175          25         -69        8710         -25 \
       3620         297       10033      -16428          -2 \
      18785          72         -44       73556          -2 \
      -6899        -147         -75       -4236       -4626

arg_in: 1 buffer int[400] \
  -1747135304  2094143875  2023770054  2055740310 -1871665729 \
  -1614594222  1750182043 -1829994315 -1780340496 -2089979776 \
   2100414438 -1821331260 -1551943501  1939018639  1741931439 \
   1742165906 -1920511151  1413834181 -1594570615 -2100187385 \
   1957780986 -1874081487  1807295682  2132140080 -1607683007 \
   2094868173 -1611228916 -1359179385  1248823221  1948875172 \
  -2017746705 -1803202043  1960945801  1840999532  1922985002 \
   1893991635 -2025827533  2138006999 -2010455632 -2098200383 \
  -1566854211  1989150599  2102936125  1945587162 -1633936394 \
   1828811446 -1941991006 -1140931046  1867347544 -1757233774 \
   1984581454 -1909880109 -1968946997  1986987720  2109207332 \
  -1973087825  1898059189  2058983910  1667507672  1601053046 \
  -1816278670 -1804425303 -2126007186 -1632927967 -1959296876 \
   1486673659 -2072770327  1410017992  1842111320 -1710159204 \
  -2086741991  2116397866  1903370154 -2019180605 -1829858836 \
   2061567950 -1716506401  1822721941 -2120813825  2140667073 \
  -2139654231  1787903174  2112507691  1964752850  2092943940 \
  -2123019386  1864452475 -1906848253  2016497627 -1709408354 \
   2129375204  2054352550  2115029965  2119413670  1863374052 \
   1964758486 -1736660773  1919836785  1844695996  2113039257 \
  -1994577708  2131664477  1499569884  1874554806  1750923166 \
   2014560143  1971078322  1719281631  1761698963  1846494681 \
  -2076338123  2103475112 -2076502831  1739655152  1843235223 \
  -1854371611 -1920302122 -1946252756 -2038523696  1957073575 \
   2114559968 -2042392849 -1561772578 -1944615942  1797460964 \
  -2092839692 -1935929385 -1492977580 -2046040866  1464071319 \
  -2114801081 -2127236158  1550892804 -1923478306  2090018553 \
  -1961853449 -1549115209 -2145720047  2056678954  1974740875 \
  -1792122670  1999933605  1688869369 -1983336828 -1887984441 \
  -1758740289 -1728762134 -1572968778 -1805132671  2048853198 \
   1859772274 -2098473526 -1651048495 -1796529934  1509720528 \
  -1332136776  2144102292 -1885528932  2009462284 -1726607124 \
  -1557576407  1155796965 -1997598800  1886343611  2047091177 \
  -2072561716 -1973944761 -1789823827 -1780357993  1782442962 \
  -1578918670  1562258211 -1711775536  1764290547 -1991923252 \
  -1865697540 -1904469878  1932518034 -2122256833 -1814635832 \
  -2138085201  2032368893  1970860364 -1939552792  1924750077 \
   1813009305  1853319063 -1912561666 -1697414203 -1948445281 \
  -2122299284 -1984353349  2142596625 -1689707357  1769055452 \
  -1964264045  1718746878  2092944241  1414043571 -2110476911 \
  -2110752257  1711959293 -1885995398 -2052698979  1676845329 \
  -1839021871 -2127563639  1473554239  1931288222  1645922983 \
  -1781604183  1588702742  1645888703 -1818679861 -1791813268 \
   1953694005 -2005594601 -2140101679 -1930743863 -1965819472 \
   1235423937  2023005628  1571342896 -1907653786 -2117879670 \
  -2012169347  1650817973  2138134478 -1986278207 -1815173983 \
  -1724094524  1819768254  1920939998  2015775331 -1853325171 \
  -2134126159 -1821813531  1900710906  2106201469 -1746086151 \
   1825156588 -2134668372 -1799854660  1579988081  1797883667 \
  -1791529844  1973318970  2100751671  1470298463 -1942824763 \
   1757910508  1939377983  2038892355 -2039362325  2121851031 \
   1729609722 -2044338965 -1473034520  2110413168 -2132740421 \
  -1672920540  1894849835  2024191363  2027950838 -1497753406 \
  -1910714705 -1988119924 -1766825852 -1978529140  1918448540 \
  -2140975955 -1380427002 -1964181250  1463806061  1714749426 \
   1987695386  2064790440  1870282835  1909709483 -1502028806 \
   1743204805 -2029643902  1768264836 -1775546701  1916052988 \
  -1958959624  1738105321 -2100833084  1700439427 -2014834317 \
  -1900847763 -1758428677  1768519649  1777213435 -1525290415 \
   2141244842 -2102702778  2116879038  2112703918  2135325646 \
   1697820348 -1846414183 -1946026566 -2063587068 -1487430491 \
   2083897521  1516099136 -1834828545 -1710832944  1596326289 \
  -1715559559  1862991744  1976153763 -2093032375  1988741061 \
   1650155444  2050901753  1810974783 -1518816447  1915386792 \
  -2009535991  2044385274  1790677425 -2007743274 -1854088167 \
   1960407783 -2045919079  1242408929 -1951962558 -2007492529 \
  -1360342873  1730762547  2000341956 -1992902663 -2123903042 \
  -1728835448 -1672891584 -1995202375 -1729965884 -1888685591 \
  -2134794463  1960191664  2137709034 -1920230157  1620863087 \
   1867911637  1997533345  1716125074 -2028492106  2126287784 \
  -2061565774  2072478549 -1869838157 -1995102469  1974387627 \
   1900581023  1992790384  2145662085  2068069159 -1624827922 \
  -1815439232  1361445606  1930586483  1579944477 -1902275422 \
  -2013620965 -1878939224 -2003646207  1817717651 -1902936760 \
  -2053569086 -1782605008 -1854942494 -2102415799  2046455949 \
   2013848230  1809470997 -1361525573  1845340337  2134964220 \
   2060974012  2138000289 -1875793749  2003669277 -1575821115 \
   1591154198  1888661920  2143583446 -2098705929 -1859784800 \
   1211922387  1814202906 -1781826994  1704168481 -2096918926 \
  -1748735840 -2056143742 -1900335407 -1996880978 -1816448960

arg_in: 2 buffer int[400] \
       3164         780     3952676      105661       47169 \
     382243        2406        1408      366024        6792 \
       5612       51184     4041520      114762       22872 \
     183928       53395        7735     1038132     3281543 \
    1274597        5369         818         419         255 \
       3046       11071       59655         252       81858 \
        184       59441      340442     2054687         373 \
     704610         369         442      105414       11776 \
     244821        5322       12967     3039980       20230 \
      12555     7585903         255      503057         195 \
    1722727     1492094         704        1501        1877 \
       4030        6614       16364        1369       32321 \
      92743      381002         947         327         384 \
     341607        2295        8178     2878299      318110 \
        491     1837151       47968         910        1018 \
        250        6398       93072       84535       49626 \
     257170       21757         859         426     3270225 \
      32206        6159       41729        5758     1907822 \
      57763      348905       14584       19120      383095 \
    3837419         176         445     4803896      825406 \
    3116528         181     3905130         424       64524 \
     245918       58775       22689        2814        3852 \
       3651        5388        1620        4944         859 \
     181091      789598       48891     2654328       28686 \
       1652       10974        3550     7596157        1476 \
     495464       28270     3887963     3996174     1906343 \
      25695        1997         167      395452      466522 \
       3807         176         343         221        6328 \
     175012       15038        7484        1870       86764 \
      24536         731        1460        6590     1231282 \
    4843157       98761      379377      125316      129612 \
      30520       25380         654      475725     2697824 \
       5721        1008        2467       56681     1599290 \
      11323      237253         500         982     1740667 \
     513971     1356127     1910464       22160      915406 \
       4754       23032      328213         961         374 \
      31696      417839       25283      409534         915 \
    2023448      804392     2490315       25650     1522223 \
    3316093       14993     1859893     1320084        2917 \
       3949     2685542         241       32114     2748017 \
    1499114      786746         211      235834       29439 \
        210         362     1279127     1508819        1943 \
       1496         723       95959       22991        4033 \
     234819     5222903       11499       73223        3133 \
        510       11742        7217     4967849       62674 \
    5240025        5126       21526        1800       85428 \
      99774      710847       43626        1017         204 \
        241       54742       12014       52909         180 \
     108023        1238       13599         181       13339 \
       1403     2202365        1547        7873       14054 \
        439       48407     1448077     7966260      149342 \
        384         180         252         187       31028 \
      10283        1665      239606        1617       58506 \
        373     2218884         224      220818        9796 \
       1532      980417      639382     1270665        5233 \
     118541     2016397      859505         401      355594 \
    6809394       14183       57085      924764       14449 \
    5101458     1508772      911820      369019         255 \
     198005         774     1381656        9642      916641 \
      28942     5475789        1759       12004     1390186 \
       1013     1803139       12819       24995      130568 \
     651218       30765      716730       28868     1247130 \
       1783      227416        1686        1739         724 \
        480         445        6319        2435       31240 \
     296217      998235         212       81272      216195 \
       1553         224         510        7307      922561 \
     506080         379       37748     7784777         181 \
        303       61359       29976         370        1013 \
    5559361      221942      726124       22730       30661 \
       1660         210         387        7723      145716 \
       3032       38459      384424      239796         253 \
     494943         925     5587662      256457         730 \
      13072         241     5027569     4114439     1351048 \
    3146283         913         449      118341         303 \
    3208702         327         745      657005      101834 \
       2545     2019499       15876       24771         698 \
      91485      642428      209352        1797      473504 \
       3433       49514        1669         998     4843190 \
        504      194157      309345         181     5460727 \
       1980      108538      195347        3682        3067

[test]
name: 0 sdiv26 num
kernel_name: sdiv26
global_size: 400 0 0

arg_out: 0 buffer int[400] \
   5803579        632          7          0        229 \
    181751          0          2    1115835         31 \
   5198524     424531       1253      34681         10 \
         1     122111       6985         44      30743 \
   2771525          6        243          5        820 \
     44119          9    8348256       7936         91 \
         0         76       2279         32   16700069 \
    852741         11          2        637    1424140 \
         7    2468631        103    4733486   27985449 \
      5278     218645          1      97516        283 \
   1797798    2867851      12107     181565          0 \
       215      72875         52     111835          8 \
   5212940        143        214   28482791    1124320 \
        46          4   20503777    2811682         61 \
   2026668      89658         15      12001       8581 \
      1317    4963335          7          1       2435 \
     22480        232    2365413        136      17421 \
   2208068    4858914        845        320   14089551 \
   5652110     167903      33938        136        680 \
    351096          1         67         12     208164 \
    327340      14509       1111     180384          4 \
     85306       7219       3388      13856    2082996 \
        47          4     123655    1173326          9 \
       164      17852          7          0      16086 \
   2303953   10727530   32787103       1128        495 \
      3362      44967     654843       8298       6076 \
        59          3    9626030         82    9967065 \
     68140   29554035       1328    4699371          9 \
      1979   27347757    2212949          6        308 \
     26417          0          1         73      22761 \
    947653        513         25        696   10942996 \
       614     101892          0          0      47552 \
    526809    2868841      89360    5758610       3632 \
         5    2580489       4378         33     152318 \
        75    2811633        369          3   14837725 \
      2923    1854838       2107       7400    3393283 \
      2727         27    3573950       7437          8 \
         0          1        525      10921      24166 \
    226391      28329         27      40244          0 \
   1679786    3584782      99565    1627695       4014 \
      5684    7166650    1885938       1182          6 \
     30717         58    8608808     318310    1069552 \
         1     201657     118400     245439        189 \
    427847     329430     610049     168510          0 \
        63         13       6690        185      24276 \
       225          2    1162869    3733903          3 \
         0         33         95      60201          2 \
   4831383    4642128     466313        122       3087 \
    245812     390039         17        479         10 \
       504       1219       2038       2269    2991391 \
    499173        739       5158         28      18710 \
       982      12803       2427          0   20419099 \
    374052     952014          0          1    5292310 \
       722       6119        116   23560321         80 \
    165065      15761         11   10607811     357129 \
   2822113         11        143          4       1301 \
     47178         82          1     687567       1482 \
    195092    3833928     632051    2036751       2948 \
   1345594          1    5520387      19648          2 \
       639    2343691       4172         16    3277466 \
      8697      39808      10833    2150602     784604 \
       790        993          6      39378       5711 \
     12152     162003          1    5550800      13813 \
        35        525          0     401691          4 \
     15213    3695884        460      13653      54921 \
         0       4144     107330          6         11 \
        64    5061991    3960358         25    2530019 \
      4027    2215575    3305868    8397189        171 \
       303        912       2229    3530391      18303 \
        51        130   23280599         12      22189 \
    315604     369537    4695073         11        295 \
       750      12155        275       7238      37947 \
     15379        261          1          0         98 \
     52611         10      18483         63     100637 \
     41960     536242        283      10112     574455 \
   7472654        720         69       9895       3461 \
     67853         17    1877586        303         60 \
   3411455    4093889         94         14       8025 \
     21043     214888          5          0   26803957 \
    944623      47971         11        159         28

arg_in: 1 buffer int[400] \
  29017899   31948775   19195599   25451835   25316637 \
  17811695   25750695   33453471   23432555   27887679 \
  25992624   19103939   13121855   32705124   29833847 \
  27851315   23323391   32254359   26985599   30959207 \
  27715259   29505979   14936947   31020971   31262858 \
  19324559   25420499   33393027   33359210   24700221 \
  19572028   30315591   27950519   29825860   33400139 \
  22171291   22612823   21015755   28360375   15665550 \
  31715341   29623582   32390925   33134408   27985449 \
  29002824   18366263   23884315   32570677   25536711 \
  21573587   31546370   28926011   28687427   23325539 \
  25335287   29077523   23950275   18452939   16165808 \
  26064704   22414175   31130279   28482791   19113456 \
  29419084   24175534   20503777   22493463   28022759 \
  14186682   24387247   29086575   33326777   23343039 \
  16680607   14890007   16827999   32361323   27616931 \
  28775679   20427808   23654139   30423589   17665907 \
  30912964   29153489   28220465   32908598   28179103 \
  16956332   31062238   19990070   19073139   20665623 \
  33354214   17317819   23971087   21378551   25812459 \
  24550574   31457679   22985039   23810819   26640583 \
  27298239   26468519   28725163   27700142   27078960 \
  30292511   31520869   17806463   30506500   18120299 \
  26656739   29796656   30806967   27759055   27428334 \
  13823723   32182592   32787103   27643563   29597311 \
  32301614   30173527   31432511   31776870   33435653 \
  26633999   22812487   28878092   19877835   29901197 \
  18806915   29554035   32757191   28196231   18221079 \
  27219059   27347757   28768348   27386050   31603283 \
  28214423   33259012   32310271   29854336   17936455 \
  26534311   29470703   31339619   30998376   32828990 \
  18639419   25677035   22714199   22901087   23538734 \
  28447739   31557259   22518971   17275832   24864251 \
  20223983   25804899   30928874   20765771   17669003 \
  22108779   30927973   32456399   32987915   29675451 \
  23299233   31532262   30199207   20870819   20359703 \
  20113543   31630647   25017655   33206205   11816630 \
  30592099   23596419   31578225   18838725   29411238 \
  18337751   17054659   26922727   24267734   27831183 \
  20157443   25093479   16826485   19532351   27743649 \
  27327794   21499952   13201572   17910619   16901527 \
  29581432   25918168   25826426   29284611   32086589 \
  25212027   25207248   14800124   13744639   33151545 \
  12835439   32613668   27452248   32017089   31655126 \
  28070911   25560163   23438572   31160951   17867871 \
  19419275   20181631   25583139   26137327   23226647 \
  25877663   27167427   24426719   22515547   33235363 \
  19325535   27852773   28445093   24442559   21742607 \
  19665039   24962559   19738619   22048799   26186016 \
  26607672   17280079   22184319   31668768   23931135 \
  27953742   15977339   20568931   27685777   17419939 \
  28730139   30883247   30721483   29415735   20419099 \
  29924239   25704404   20932104   33361347   31753863 \
  22303103   31628159   27471950   23560321   24190891 \
  31362539   30089657   20974139   21215623   22499188 \
  16932683   30280775   27136655   22563079   22284829 \
  23966931   27268238   28430099   25440015   27672779 \
  30824692   26837502   16433351   32588031   23329538 \
  29603088   31200353   16561163   19590051   21520871 \
  27529598   25780610   18795191   32368237   29497202 \
  24290721   23447500   31426533   27957838   28245779 \
  22945327   28364783   23816743   32723948   20460383 \
  26299091   20898515   32826155   33304805   17252437 \
  30255443   28745371   29071944   20084599   26705883 \
  32390605   25871194   33099799   23321031   25868259 \
  21973892   12414274   32628623   20683143   17415849 \
  26477163   15185975   27722512   30353075   32890259 \
  27769031   22155759   29752820   25191569   20726515 \
  21808655   31166167   30423621   17651959   32398078 \
  18309719   32025307   23280599   26333630   20947359 \
  27773239   25867659   32865517   25892063   21850423 \
  25924519   20106023   31078025   20001355   30092763 \
  22870059   29233959   24172439   26874719   32809587 \
  16835839   32960179   23456195   30957129   33411815 \
  20225200   32174579   12826859   30601937   14935855 \
  22417963   29870307   19918499   24146239   21685967 \
  26259496   17868743   26286217   29142351   26987680 \
  23880191   28657229   28508074   21451079   31526126 \
  29293247   32018459   22151219   25403451   26803957 \
  33061839   20819847   23440930   21233599   19213978

arg_in: 2 buffer int[400] \
         5      50472    2399450   25451836     110553 \
        98   25750696   11151158         21     871490 \
         5         45      10464        943    2712168 \
  13925658        191       4617     599680       1007 \
        10    4215140      61217    5170162      38079 \
       438    2542050          4       4203     271431 \
  19572029     393709      12259     903814          2 \
        26    1884402    7005252      44452         11 \
   4530763         12     314475          7          1 \
      5494         84   11942158        334      89918 \
        12         11       2389        158   23325540 \
    117293        399     451892        165    1796201 \
         5     155654     144792          1         17 \
    625938    4835107          1          8     451980 \
         7        272    1817911       2777       2720 \
     12656          3    2103500   16180662      11337 \
      1280      87673         10     222070       1014 \
        14          6      33397     102519          2 \
         3        185        589     139220      30346 \
        95    8658910     352516    1644504        124 \
        75       2168      20670        132    5328117 \
       320       3666       8476       1999         13 \
    631094    6304174        144         26    1812030 \
    161556       1669    3850871   27759056       1705 \
         6          3          1      24485      59672 \
      9605        671         48       3829       5502 \
    443900    5703122          3     239492          3 \
       276          1      24648          6    1822108 \
     13747          1         13    3912293     102276 \
      1068   33259014   16155137     403437        788 \
        28      57336    1205370      44474          3 \
     30308        252   22714201   22901088        495 \
        54         11        252          3       6844 \
   3370664         10       7063     610758        116 \
    290905         11      87720    8246979          2 \
      7971         17      14326       2820          6 \
      7373    1129666          7       4465    1312959 \
  30592100   11798210      60149       1725       1217 \
        81        602     961526        603   27831184 \
        12          7        169         12       6910 \
      4807          3          7      15140    2414504 \
       963     439291          3         92         30 \
  12606014        125        125         56     175405 \
        30         99         45        190   31655129 \
    438608    1825726       3503     167532        736 \
     85926    6727211         22          7    5806662 \
  25877664     799042     254445        374   11078455 \
         4          6         61     198720       7041 \
        80         64    1096590      45935    2380547 \
     52793      14164      10880      13951          8 \
        56      21591       3987     954682        931 \
     29227       2412      12653   29415738          1 \
        80         27   20932105   16680674          6 \
     30848       5168     234803          1     298653 \
       190       1909    1747845          2         63 \
         6    2523398     188449    4512616      17129 \
       508     328533   14215050         37      18660 \
       158          7         26         16       7911 \
        22   15600177          3        997    7173624 \
     43015         11       4504    1904014          9 \
      2793        589       2901         13         36 \
     29008      28536    3402392        831       3582 \
      2164        129   16413078          6       1249 \
    840429      54649   29071945         50    5341177 \
      2129          7      71800       1708        471 \
  21973893       2995        304    2954735    1583259 \
    407341          3          7    1167426         13 \
      6894         10          9          3     120503 \
     71739      34136      13649          5       1770 \
    352110     244468          1    2025664        944 \
        88         70          7    2157672      73819 \
     34520       1654     113011       2763        793 \
      1487     111580   12086220   26874721     331410 \
       320    2996380       1269     491383        332 \
       482         60      45165       3026         26 \
         3      41429     284550       2440       6264 \
       387     992708         14      95863     442421 \
         7          7     300085    1430072       3928 \
      1392        149    3691870   25403452          1 \
        35        434    1953411     132710     662551

## Modulo ##

[test]
name: pos mod pos=0
kernel_name: mod
arg_in:  1 int 8
arg_in:  2 int 4
arg_out: 0 buffer int[1] 0

[test]
name: pos mod pos=pos
kernel_name: mod
arg_in:  1 int 8
arg_in:  2 int 5
arg_out: 0 buffer int[1] 3

[test]
name: neg mod pos=0
kernel_name: mod
arg_in:  1 int -30
arg_in:  2 int 15
arg_out: 0 buffer int[1] 0

[test]
name: neg mod pos=neg
kernel_name: mod
arg_in:  1 int -18
arg_in:  2 int 5
arg_out: 0 buffer int[1] -3

[test]
name: pos mod neg=0
kernel_name: mod
arg_in:  1 int 12
arg_in:  2 int -4
arg_out: 0 buffer int[1] 0

[test]
name: pos mod neg=pos
kernel_name: mod
arg_in:  1 int 16
arg_in:  2 int -3
arg_out: 0 buffer int[1] 1

[test]
name: small_pos mod big_pos
kernel_name: mod
arg_in:  1 int 5
arg_in:  2 int 345234
arg_out: 0 buffer int[1] 5

[test]
name: max_int mod num
kernel_name: mod
arg_in:  1 int 2147483647
arg_in:  2 int 12345
arg_out: 0 buffer int[1] 9172

[test]
name: min_int mod num
kernel_name: mod
arg_in:  1 int -2147483648
arg_in:  2 int 476
arg_out: 0 buffer int[1] -128

[test]
name: 0 srem25 num
kernel_name: srem25
global_size: 500 0 0

arg_out: 0 buffer int[500] \
         972        95956        14325       731780        23021 \
       12930          421      4898910        61886          729 \
        1932        41580        53666          237        12100 \
    16017007         7866      1318678         8070       255739 \
    16528409      7305751       982191      8320547          509 \
     1045252          420        12210      7980388     15847863 \
     1586475          222       833376          386       495927 \
        6910          440      2648169        85241      3998585 \
    15403025         3776         3665       745675        78478 \
     1364462     16595525      1654406      1471337        81030 \
        1979      8208935       383299         1011      7353729 \
     2757040         5105          252         3017          708 \
        2700          727       126641         3959      4146948 \
      950476         7277         7096        31334          189 \
     7579665        14785        95015     14843384       162880 \
        4844        25408       317072       256273       516984 \
      191665         6164        45288        28406        25878 \
      102144        51989        14099      1278163       174348 \
       31543         1915         1417       372146          191 \
     1605537      1750306       202456       329325        20947 \
         877      8111343       164741        11215          211 \
      501982        20197         6094       409946          221 \
     3501723        63572         1637      1800766         8103 \
    16402980          421         1734       102964         6596 \
        1782        48110          729       450838        14789 \
         456          447          179          351       250644 \
       32016          444         6160        30407       182783 \
       21325      3908636        63069       190771          999 \
         181       521807        31179         5557          359 \
         179       291833     14695212        63186        26478 \
     1316962       177433       329795      1271558     16540210 \
        5917          191        42946      1018703     16110903 \
    15797882        92356         7738          906      2624007 \
       11126      7492872          959       579748        15243 \
      348370         1194      1260160       749591          773 \
       11535         4760        26572        20417       125335 \
         221         3430        24205      3315916        94397 \
         400        24147       125264         1806         1439 \
      486266          308          233          368        86948 \
        3516       757152          689       778350         3469 \
      157143      1148826       418290      7157245       169957 \
      819104      1738103         5475       675578       332504 \
       47151          222        56212         3307       216996 \
      516774       668311         6659      1426663          351 \
      219707      1687728        15238         3836       521452 \
     7178762         8028       345914          237       127473 \
       12385         1659         3571          210     15001698 \
    16644234        13181       120909         2039       215142 \
       43230         8001        25125     14790328         5660 \
        2743      7889140      5364018      3549150      7390505 \
     2704674      1605405       515095      3198989         5549 \
         237      1639562        45727         2946       141363 \
        1441      1658294       174897      5324385          220 \
         194       858400         3195      4159974      3867412 \
       89656          181     15086690       446966         2611 \
     1499008         2139          237          326        28160 \
       12225          404     15765382        60181       116588 \
      939631        29538        13593      3761223          412 \
    14940688        29279         4092       612989         2308 \
       29740          363       409520         1745        12831 \
       35549        60353         4092        13676          386 \
         951         2202       122441        91770          254 \
         333      1967683          333     16039586        25354 \
       13225        32736          211        13550       399136 \
         414          636       235456     14916920         5226 \
         605         6077          302          820         4008 \
     1001151       891944          212     14834444      8286406 \
        4651     16680125        14999       676437     15125801 \
     5434639          252        44990      2015981       342431 \
      242154          373          806        58213         4092 \
       22132       242287        25057        32016       204279 \
       78378          665       121529          969        12295 \
        2902          203          263     15212990          744 \
       94080         3634          288        86908          239 \
       25553          233        44144      3679715       207312 \
         981        98739         1927          817       182771 \
      387695       164012        11467       230380        60910 \
       75444        60828         6840        15379        10503 \
         249         2622          891        32639      1333962 \
        3865       158354          191         1398      2699277 \
       31993          747      5578703      3329531          806 \
     1764539      7072837         1335          210        32732 \
    16732189        12084     14570496          302      7934303 \
         714       485336        15681        32636         2982 \
        5469         1514       203936        15745         1263 \
         408      4051983        14020         5620        59215 \
      741384       720082         3844        59227          438 \
     2583793         1500      1237832         5805     13625828 \
      127718        28478       472235          240          179 \
      110844          368         8111      7595241      4817379 \
     3004805     14975546         1019        12308         6186 \
        3613         6165      7725434       106216         1925 \
       48520          809        16360          546       407329 \
      187498     15015969         1429        91224      1193637 \
       29294         6023      7728396       398917       119610 \
        5989          361      1843996      1284220          386 \
         356         2009        19333         2671      1408010 \
        4039      4995349        93305       495748         2288 \
       12054      2361392       184122        21852         5520 \
       40106      2395889      8374540          605          989


arg_in: 1 buffer int[500] \
    15154474     14681420     13122615     16099181     15217541 \
    16525817     16765637     14696732     15347975     13180149 \
    16600603     14095958     16046432     15094673     14121866 \
    16017007     14066195     14505468     15827230     16623099 \
    16528409     14611503     16697263     16641095     16469939 \
    13588288     15155999     14323502     15960777     15847863 \
    14278283     16279445     14167408     13468760     12894127 \
    13663046     15091901     15889019     14832107     11995757 \
    15403025     15527246     15034265     13422167     12399681 \
    12280166     16595525     16544069     14713379     13045990 \
    11695859     16417871     14948699     14999863     14707459 \
    16542245     14940155     16512803     12923075     14711040 \
    14642120     13900431     15576965     15368759     16587795 \
    14257154     12343487     15726951     15103469     15786339 \
    15159331     16028023     13777319     14843384     15310813 \
    12887699     15042127     16487795     16145261     15509549 \
    14374949     13371884     13269676     13891022     13612353 \
    16547489     13725359     13592399     16616131     16737503 \
    14447151     16425867     12411753     12652997     15008447 \
    14449841     15752762     13159704     14819669     13846627 \
    15360609     16222687     11202455     11866527     15236015 \
    16063455     14199193     15389874     15577985     15332207 \
    14006895     13477475     15253055     16206902     11280767 \
    16402980     15431273     16718459     16062539     16347365 \
    14918360     16020962     16084819     13074330     15322439 \
    15009250     15076543     16689239     15678079     16542569 \
    15112023     15452179     14613891     11342183     14988287 \
    12049189     15634547     14316889     16024847     15594999 \
    12020917     15132431     15153479     13311409     13640399 \
    13019399     16634537     14695212     11563220     14881197 \
    14486592     14372153     10883267     15258707     16540210 \
    14694393     15095999     13743039     14261855     16110903 \
    15797882     16716616     12157968     15520583     13120039 \
    16479086     14985745     13786559     16232971     15457415 \
    15328323     13931309     15121931     14991839     13044221 \
    13427903     16306424     15624923     15844367     16293679 \
    16218653     15604187     15588663     16579584     12649331 \
    16108169     15358127     16534979     12909207     13890239 \
    11184140     15618095     15652961     15024572     15998615 \
    15334119     13628753     14485169     13231966     16655999 \
    16185831     16083577     16313348     14314491     11387185 \
    15562994     15642935     16340383     12836000     15627734 \
    15654463     14874991     16582834     16364675     14755795 \
    14469699     16039487     15677639     12839975     14331327 \
    16258391     15189560     16686704     12658262     10950512 \
    14357525     14773359     13490684     11719833     13512243 \
    13092001     16080419     14741643     14593603     15001698 \
    16644234     13854281     16081029     10628399     14414580 \
    12709913     12491121     14171063     14790328     15567749 \
    11670231     15778281     16092056     14196603     14781011 \
    16228049     14448653     12362303     15994949     13336649 \
    13835415     14756066     16279167     15297876     16398223 \
    13618247     16582949     16265513     15973157     16390464 \
    16382924     16309618     13304947     12479924     15469651 \
    13538206     13392105     15086690     14749910     13749567 \
    14990089     15825299     12522131     13064303     16023608 \
    15196917     13392944     15765382     15647319     14573624 \
    13154847     16157832     15877791     15044895     13995743 \
    14940688     15694079     14182244     15324749     15546496 \
    13383449     15880955     15152276     12941351     13820063 \
    16424099     15209207     14116756     15824288     15873191 \
    14512287     16432176     16774553     12756168     16760639 \
    11046047      9838419     13728401     16039586     16455394 \
    15223125     12374585     14740995     14160794     13171520 \
    15962559     16377906     16481989     14916920     14656507 \
    15112427     15194999     13603184     14020216     12700511 \
    14016127     16055009     15852098     14834444     16572813 \
    13779223     16680125     15749999     13528759     15125801 \
    16303919     15764176     14577083     14111873     14724575 \
    11865594     15449191     15512153     14669927     10252964 \
    13324065     15506431     13681667     13927394     16546679 \
    14186598     16251731     11545349     14897259     14939639 \
    15801028     14206355     16536959     15212990     13722154 \
    14394392     15746819     14313591     13992348     11689679 \
    14054699     11656943     14391269     14718863     13475344 \
    15379101     14810999     13405383     13568165     15170075 \
    13181663     14433143     14873995     15435526     16080503 \
    14409994     16363000     14626057     15949059     12751855 \
    16059999     16653426     14128387     13121279     16007555 \
    12529705     16152209     15614399     12995310     13496389 \
    10302067     14694459     16736111     16647659     15421769 \
    14116319     14145675     12840295     14433454     12176675 \
    16732189     15746754     14570496     13867097     15868607 \
    15733574     13589435     11322403     15796307     12257146 \
    11771439     15609044     14071652     10297883     15870783 \
    15357131     12155951     15675477     16244689     15455375 \
    12603544     15841825     16456599     16702295     15775025 \
    15502763     14649759     16091828     13678935     13625828 \
    15581717     14951474     16056023     10810536     13848659 \
    14631539     14041187     16767503     15190483     14452139 \
    15024029     14975546     13497659     12899831     16673964 \
    16017247     14033815     15450869     15295247     14242769 \
    13974047     14337809     12254388     16355299     15478539 \
    16499911     15015969     15413969     12132924     14323655 \
    15965774     14650367     15456793     13164293     15429818 \
    15909439     14848515     12907978     16694872     15413822 \
    15693005     14463959     13263123     15510959     15488120 \
    16462999     14986049     14835653     14872469     15269918 \
    14851759     16529750     14177470     15471923     14812842 \
    11791457     16771229     16749081     14435525     15206399


arg_in: 2 buffer int[500] \
         973        95957        14326       731781        23022 \
       12931          422      4898911        61887          730 \
        1933        41581        53667          238        12101 \
    16017008         7867      1318679         8071       255740 \
    16528410      7305752       982192      8320548          510 \
     1045253          421        12211      7980389     15847864 \
     1586476          223       833377          387       495928 \
        6911          441      2648170        85242      3998586 \
    15403026         3777         3666       745676        78479 \
     1364463     16595526      1654407      1471338        81031 \
        1980      8208936       383300         1012      7353730 \
     2757041         5106          253         3018          709 \
        2701          728       126642         3960      4146949 \
      950477         7278         7097        31335          190 \
     7579666        14786        95016     14843385       162881 \
        4845        25409       317073       256274       516985 \
      191666         6165        45289        28407        25879 \
      102145        51990        14100      1278164       174349 \
       31544         1916         1418       372147          192 \
     1605538      1750307       202457       329326        20948 \
         878      8111344       164742        11216          212 \
      501983        20198         6095       409947          222 \
     3501724        63573         1638      1800767         8104 \
    16402981          422         1735       102965         6597 \
        1783        48111          730       450839        14790 \
         457          448          180          352       250645 \
       32017          445         6161        30408       182784 \
       21326      3908637        63070       190772         1000 \
         182       521808        31180         5558          360 \
         180       291834     14695213        63187        26479 \
     1316963       177434       329796      1271559     16540211 \
        5918          192        42947      1018704     16110904 \
    15797883        92357         7739          907      2624008 \
       11127      7492873          960       579749        15244 \
      348371         1195      1260161       749592          774 \
       11536         4761        26573        20418       125336 \
         222         3431        24206      3315917        94398 \
         401        24148       125265         1807         1440 \
      486267          309          234          369        86949 \
        3517       757153          690       778351         3470 \
      157144      1148827       418291      7157246       169958 \
      819105      1738104         5476       675579       332505 \
       47152          223        56213         3308       216997 \
      516775       668312         6660      1426664          352 \
      219708      1687729        15239         3837       521453 \
     7178763         8029       345915          238       127474 \
       12386         1660         3572          211     15001699 \
    16644235        13182       120910         2040       215143 \
       43231         8002        25126     14790329         5661 \
        2744      7889141      5364019      3549151      7390506 \
     2704675      1605406       515096      3198990         5550 \
         238      1639563        45728         2947       141364 \
        1442      1658295       174898      5324386          221 \
         195       858401         3196      4159975      3867413 \
       89657          182     15086691       446967         2612 \
     1499009         2140          238          327        28161 \
       12226          405     15765383        60182       116589 \
      939632        29539        13594      3761224          413 \
    14940689        29280         4093       612990         2309 \
       29741          364       409521         1746        12832 \
       35550        60354         4093        13677          387 \
         952         2203       122442        91771          255 \
         334      1967684          334     16039587        25355 \
       13226        32737          212        13551       399137 \
         415          637       235457     14916921         5227 \
         606         6078          303          821         4009 \
     1001152       891945          213     14834445      8286407 \
        4652     16680126        15000       676438     15125802 \
     5434640          253        44991      2015982       342432 \
      242155          374          807        58214         4093 \
       22133       242288        25058        32017       204280 \
       78379          666       121530          970        12296 \
        2903          204          264     15212991          745 \
       94081         3635          289        86909          240 \
       25554          234        44145      3679716       207313 \
         982        98740         1928          818       182772 \
      387696       164013        11468       230381        60911 \
       75445        60829         6841        15380        10504 \
         250         2623          892        32640      1333963 \
        3866       158355          192         1399      2699278 \
       31994          748      5578704      3329532          807 \
     1764540      7072838         1336          211        32733 \
    16732190        12085     14570497          303      7934304 \
         715       485337        15682        32637         2983 \
        5470         1515       203937        15746         1264 \
         409      4051984        14021         5621        59216 \
      741385       720083         3845        59228          439 \
     2583794         1501      1237833         5806     13625829 \
      127719        28479       472236          241          180 \
      110845          369         8112      7595242      4817380 \
     3004806     14975547         1020        12309         6187 \
        3614         6166      7725435       106217         1926 \
       48521          810        16361          547       407330 \
      187499     15015970         1430        91225      1193638 \
       29295         6024      7728397       398918       119611 \
        5990          362      1843997      1284221          387 \
         357         2010        19334         2672      1408011 \
        4040      4995350        93306       495749         2289 \
       12055      2361393       184123        21853         5521 \
       40107      2395890      8374541          606          990

[test]
name: 0 srem25_1 num
kernel_name: srem25_1
global_size: 100 0 0

arg_out: 0 buffer int[100] \
           5          252            2            5            2 \
          50          105           14           13           10 \
          89          239            6            2          801 \
         222           10            2           56           10 \
         118            5           13           14           12 \
         415            6           10           23           13 \
          59            2           23           90          503 \
          12           12           95           12            2 \
          52            2          118            2           44 \
          50            6           13            6            2 \
          52           29            6           50          105 \
         116           43          166           10            2 \
          25           13          333           14            2 \
          21           12            6          118           13 \
           2            6           95            6           13 \
          10           23           21           11            2 \
         105           12           47          104          490 \
           2          125          104          858           59 \
         475           23           62           89            2 \
          22            5            2            2           50


arg_in: 1 buffer int[100] \
    12657941     13613929     15903101     15494981     13657955 \
    16747430     16622601     15686189     13191121     16543977 \
    13345199     11155679     14036812     15542438     15708773 \
    16076515     13947691     16003649     15138743     16633242 \
    10447723     13696925     14841903     13144349     14450526 \
    15313375     14845151     15405246     15196151     15604357 \
    11728139     16008521     15258431     12955669     14607935 \
    16739423     13727089     13590815     16737941     14989058 \
    16056243     14022212     12640774     12763727     13504724 \
    16572245     12900299     15896285     16549434     13765361 \
    15553379     10246799     14605009     13808759     15764319 \
    12995423     14560919     11788362     11591931     16621691 \
    16308135     13155029     14412099     13189679     15966437 \
    12194049     15717922     13098007     16040009     12725789 \
    15056279     14575483     12606719     14002722     14972663 \
    16311558     13409063     13860879     15710183     14496944 \
    16648359     15417479     12632879     16048304     15049149 \
    16762259     12246443     16751069     14735285     12998999 \
    14415183     14019695      8874368     13725629     12603599 \
    15620564     12944927     15112733     14371688     13913054


arg_in: 2 buffer int[100] \
         796        32505          391          814          408 \
        6610        13673         1975         1906         1443 \
       11556        30762         1001          467       102658 \
       28655         1491          495         7314         1468 \
       15264          850         1836         2010         1703 \
       53355         1008         1439         3154         1910 \
        7743          453         3162        11727        64556 \
        1753         1779        12343         1766          391 \
        6879          406        15262          477         5830 \
        6596          984         1882          986          438 \
        6854         3859         1009         6581        13622 \
       15062         5646        21500         1513          497 \
        3442         1836        42790         1951          391 \
        2935         1700          905        15279         1854 \
         456          984        12311         1001         1837 \
        1417         3180         2894         1631          388 \
       13615         1722         6260        13522        62933 \
         436        16191        13529       110009         7717 \
       60987         3093         8083        11602          497 \
        3028          821          454          472         6620

[test]
name: 0 srem25_2 num
kernel_name: srem25_2
global_size: 100 0 0

arg_out: 0 buffer int[100] \
   -14692475        -1007         -816     -3987863       -23419 \
      -51136      -222767      -118460       -15230         -180 \
        -490       -15664        -4844      -953650        -1429 \
       -1505      -117386      -194015      -624487        -3153 \
     -393297    -15374608        -3237      -992240         -221 \
   -14010572       -60078         -209     -8349341    -16395321 \
       -5350        -1436        -2995         -131      -513881 \
        -481       -52536       -14488        -1019       -97539 \
    -1420076        -1447       -10935       -15765       -16363 \
       -1559    -16198363      -223517      -595547       -13161 \
      -22515      -155601      -415376     -7747564      -128682 \
      -10089     -3053541     -6870644     -4119799        -4913 \
     -203413       -20865         -227       -23047    -16564562 \
     -164821         -189      -819339      -384095         -251 \
        -968        -6852         -212       -10792     -2725594 \
   -15936452        -2015       -49821       -15210       -52806 \
      -82459       -49652    -16538101         -237      -163592 \
      -46980      -336452       -99471       -24093        -4051 \
     -116358         -364      -174720    -14836269     -1821452 \
     -217194      -876869    -16426584       -65286       -24352

arg_in: 1 buffer int[100] \
    14692475     15301439     13783606     11963591     12529699 \
    15545647     16484831     15281468     16068704     11953601 \
    16001689     14505789     13386734     16212066     11870429 \
    16406363     13734278     13193087     13114247     14524169 \
    16518515     15374608     15668681     13891373     15753119 \
    14010572     15740697     15592079     16698683     16395321 \
    14656388     14426042     16058559     16421723     13874813 \
    11562215     16444080     16068300     10542719     15996559 \
    15620846     12077767     16447743     16333575      9016563 \
    14111759     16198363     15422741     16079795     14162311 \
    12541411     16338209     16615079     15495129     10552005 \
    16749399     15267709     13741289     16479199     13857479 \
    14849221     16671933     15598163     13045167     16564562 \
    14339513     15026149     14748119     13443359     12626459 \
    12691961     14048649     14041172     16761528     16353569 \
    15936452      9783647     14448379     15971549     15947713 \
    15584939     13356656     16538101     12924827     15704927 \
    15315805     13121666     14224495     16383919     10336651 \
    12566771     13169929     15026005     14836269     16393076 \
    16724014     14029919     16426584     15799453     16535686

arg_in: 2 buffer int[100] \
    14692476         1008          817      3987864        23420 \
       51137       222768       118461        15231          181 \
         491        15665         4845       953651         1430 \
        1506       117387       194016       624488         3154 \
      393298     15374609         3238       992241          222 \
    14010573        60079          210      8349342     16395322 \
        5351         1437         2996          132       513882 \
         482        52537        14489         1020        97540 \
     1420077         1448        10936        15766        16364 \
        1560     16198364       223518       595548        13162 \
       22516       155602       415377      7747565       128683 \
       10090      3053542      6870645      4119800         4914 \
      203414        20866          228        23048     16564563 \
      164822          190       819340       384096          252 \
         969         6853          213        10793      2725595 \
    15936453         2016        49822        15211        52807 \
       82460        49653     16538102          238       163593 \
       46981       336453        99472        24094         4052 \
      116359          365       174721     14836270      1821453 \
      217195       876870     16426585        65287        24353


## Unary plus ##

[test]
name: +pos
kernel_name: plus
arg_in:  1 int 345
arg_out: 0 buffer int[1] 345

[test]
name: +neg
kernel_name: plus
arg_in:  1 int -455
arg_out: 0 buffer int[1] -455

## Unary minus ##

[test]
name: -pos
kernel_name: minus
arg_in:  1 int 345
arg_out: 0 buffer int[1] -345

[test]
name: -neg
kernel_name: minus
arg_in:  1 int -455
arg_out: 0 buffer int[1] 455

## Increment ##

[test]
name: num++
kernel_name: postinc
arg_in:  1 int 34
arg_out: 0 buffer int[1] 34

[test]
name: ++num
kernel_name: preinc
arg_in:  1 int -22
arg_out: 0 buffer int[1] -21

## Decrement ##

[test]
name: num--
kernel_name: postdec
arg_in:  1 int -34
arg_out: 0 buffer int[1] -34

[test]
name: --num
kernel_name: predec
arg_in:  1 int 22
arg_out: 0 buffer int[1] 21

!*/

kernel void add(global int* out, int a, int b) {
	out[0] = a + b;
}

kernel void sub(global int* out, int a, int b) {
	out[0] = a - b;
}

kernel void mul(global int* out, int a, int b) {
	out[0] = a * b;
}

kernel void div(global int* out, int a, int b) {
	out[0] = a / b;
}

kernel void sdiv24(global int* out, global int* a, global int* b) {
	int id = get_global_id(0);
	out[id] = ((a[id] << 8) >> 8) / ((b[id] << 8) >> 8);
}

kernel void srem24(global int* out, global int* a, global int* b) {
	int id = get_global_id(0);
	out[id] = ((a[id] << 8) >> 8) % ((b[id] << 8) >> 8);
}

kernel void sdiv25(global int* out, global int* a, global int* b) {
	int id = get_global_id(0);
	out[id] = ((a[id] << 7) >> 7) / ((b[id] << 7) >> 7);
}

kernel void srem25(global int* out, global int* a, global int* b) {
	int id = get_global_id(0);
	out[id] = ((a[id] << 7) >> 7) % ((b[id] << 7) >> 7);
}

kernel void sdiv25_1(global int* out, global int* a, global int* b) {
	int id = get_global_id(0);
	out[id] = (a[id] >> 7) / ((b[id] << 7) >> 7);
}

kernel void sdiv26(global int* out, global int* a, global int* b) {
	int id = get_global_id(0);
	out[id] = ((a[id] << 6) >> 6) / ((b[id] << 6) >> 6);
}

kernel void srem25_1(global int* out, global int* a, global int* b) {
	int id = get_global_id(0);
	out[id] = ((a[id] << 7) >> 7) % (b[id] >> 7);
}

kernel void srem25_2(global int* out, global int* a, global int* b) {
	int id = get_global_id(0);
	out[id] = (-((a[id] << 7) >> 7)) % ((b[id] << 7) >> 7);
}

kernel void mod(global int* out, int a, int b) {
	out[0] = a % b;
}

kernel void plus(global int* out, int in) {
	out[0] = +in;
}

kernel void minus(global int* out, int in) {
	out[0] = -in;
}

kernel void postinc(global int* out, int in) {
	out[0] = in++;
}

kernel void preinc(global int* out, int in) {
	out[0] = ++in;
}

kernel void postdec(global int* out, int in) {
	out[0] = in--;
}

kernel void predec(global int* out, int in) {
	out[0] = --in;
}
