--TEST--
Backed enums round-tripped through parent document
--SKIPIF--
<?php require __DIR__ . "/../utils/basic-skipif.inc"; ?>
<?php skip_if_php_version('<', '8.1.0'); ?>
--FILE--
<?php

require_once __DIR__ . '/../utils/basic.inc';

enum Role: int
{
    case USER = 1;
    case ADMIN = 2;
}

class User implements MongoDB\BSON\Persistable
{
    public function __construct(
        private string $username,
        private Role $role,
        private MongoDB\BSON\ObjectId $_id = new MongoDB\BSON\ObjectId(),
    ) {}

    public function bsonSerialize(): array
    {
        return [
            '_id' => $this->_id,
            'username' => $this->username,
            'role' => $this->role,
        ];
    }

    public function bsonUnserialize(array $data): void
    {
        $this->_id = $data['_id'];
        $this->username = $data['username'];
        $this->role = Role::from($data['role']);
    }
}

$document = new User('foo', Role::ADMIN);

var_dump(toPHP(fromPHP($document)));

?>
===DONE===
<?php exit(0); ?>
--EXPECTF--
object(MyDocument)#%d (%d) {
  ["x":"MyDocument":private]=>
  enum(MyIntBackedEnum::A)
  ["y":"MyDocument":private]=>
  enum(MyStringBackedEnum::A)
}
===DONE===
