/*****************************************************************************
*
* Copyright (c) 2000 - 2010, Lawrence Livermore National Security, LLC
* Produced at the Lawrence Livermore National Laboratory
* LLNL-CODE-400124
* All rights reserved.
*
* This file is  part of VisIt. For  details, see https://visit.llnl.gov/.  The
* full copyright notice is contained in the file COPYRIGHT located at the root
* of the VisIt distribution or at http://www.llnl.gov/visit/copyright.html.
*
* Redistribution  and  use  in  source  and  binary  forms,  with  or  without
* modification, are permitted provided that the following conditions are met:
*
*  - Redistributions of  source code must  retain the above  copyright notice,
*    this list of conditions and the disclaimer below.
*  - Redistributions in binary form must reproduce the above copyright notice,
*    this  list of  conditions  and  the  disclaimer (as noted below)  in  the
*    documentation and/or other materials provided with the distribution.
*  - Neither the name of  the LLNS/LLNL nor the names of  its contributors may
*    be used to endorse or promote products derived from this software without
*    specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT  HOLDERS AND CONTRIBUTORS "AS IS"
* AND ANY EXPRESS OR  IMPLIED WARRANTIES, INCLUDING,  BUT NOT  LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND  FITNESS FOR A PARTICULAR  PURPOSE
* ARE  DISCLAIMED. IN  NO EVENT  SHALL LAWRENCE  LIVERMORE NATIONAL  SECURITY,
* LLC, THE  U.S.  DEPARTMENT OF  ENERGY  OR  CONTRIBUTORS BE  LIABLE  FOR  ANY
* DIRECT,  INDIRECT,   INCIDENTAL,   SPECIAL,   EXEMPLARY,  OR   CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT  LIMITED TO, PROCUREMENT OF  SUBSTITUTE GOODS OR
* SERVICES; LOSS OF  USE, DATA, OR PROFITS; OR  BUSINESS INTERRUPTION) HOWEVER
* CAUSED  AND  ON  ANY  THEORY  OF  LIABILITY,  WHETHER  IN  CONTRACT,  STRICT
* LIABILITY, OR TORT  (INCLUDING NEGLIGENCE OR OTHERWISE)  ARISING IN ANY  WAY
* OUT OF THE  USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
* DAMAGE.
*
*****************************************************************************/

#include <avtDefaultPlotMetaData.h>
#include <DataNode.h>

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose: 
//   Init utility for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtDefaultPlotMetaData::Init()
{
    plotVar = "var";

    avtDefaultPlotMetaData::SelectAll();
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose: 
//   Copy utility for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void avtDefaultPlotMetaData::Copy(const avtDefaultPlotMetaData &obj)
{
    pluginID = obj.pluginID;
    plotVar = obj.plotVar;
    plotAttributes = obj.plotAttributes;

    avtDefaultPlotMetaData::SelectAll();
}

// Type map format string
const char *avtDefaultPlotMetaData::TypeMapFormatString = AVTDEFAULTPLOTMETADATA_TMFS;
const AttributeGroup::private_tmfs_t avtDefaultPlotMetaData::TmfsStruct = {AVTDEFAULTPLOTMETADATA_TMFS};


// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose: 
//   Default constructor for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData() : 
    AttributeSubject(avtDefaultPlotMetaData::TypeMapFormatString)
{
    avtDefaultPlotMetaData::Init();
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose: 
//   Constructor for the derived classes of avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData(private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    avtDefaultPlotMetaData::Init();
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose: 
//   Copy constructor for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData(const avtDefaultPlotMetaData &obj) : 
    AttributeSubject(avtDefaultPlotMetaData::TypeMapFormatString)
{
    avtDefaultPlotMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::avtDefaultPlotMetaData
//
// Purpose: 
//   Copy constructor for derived classes of the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData(const avtDefaultPlotMetaData &obj, private_tmfs_t tmfs) : 
    AttributeSubject(tmfs.tmfs)
{
    avtDefaultPlotMetaData::Copy(obj);
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::~avtDefaultPlotMetaData
//
// Purpose: 
//   Destructor for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtDefaultPlotMetaData::~avtDefaultPlotMetaData()
{
    // nothing here
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::operator = 
//
// Purpose: 
//   Assignment operator for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

avtDefaultPlotMetaData& 
avtDefaultPlotMetaData::operator = (const avtDefaultPlotMetaData &obj)
{
    if (this == &obj) return *this;

    avtDefaultPlotMetaData::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::operator == 
//
// Purpose: 
//   Comparison operator == for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtDefaultPlotMetaData::operator == (const avtDefaultPlotMetaData &obj) const
{
    // Create the return value
    return ((pluginID == obj.pluginID) &&
            (plotVar == obj.plotVar) &&
            (plotAttributes == obj.plotAttributes));
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::operator != 
//
// Purpose: 
//   Comparison operator != for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtDefaultPlotMetaData::operator != (const avtDefaultPlotMetaData &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::TypeName
//
// Purpose: 
//   Type name method for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

const std::string
avtDefaultPlotMetaData::TypeName() const
{
    return "avtDefaultPlotMetaData";
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::CopyAttributes
//
// Purpose: 
//   CopyAttributes method for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

bool
avtDefaultPlotMetaData::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const avtDefaultPlotMetaData *tmp = (const avtDefaultPlotMetaData *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::CreateCompatible
//
// Purpose: 
//   CreateCompatible method for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtDefaultPlotMetaData::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new avtDefaultPlotMetaData(*this);
    // Other cases could go here too. 

    return retval;
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::NewInstance
//
// Purpose: 
//   NewInstance method for the avtDefaultPlotMetaData class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

AttributeSubject *
avtDefaultPlotMetaData::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new avtDefaultPlotMetaData(*this);
    else
        retval = new avtDefaultPlotMetaData;

    return retval;
}

// ****************************************************************************
// Method: avtDefaultPlotMetaData::SelectAll
//
// Purpose: 
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
avtDefaultPlotMetaData::SelectAll()
{
    Select(ID_pluginID,       (void *)&pluginID);
    Select(ID_plotVar,        (void *)&plotVar);
    Select(ID_plotAttributes, (void *)&plotAttributes);
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
//  Method: avtDefaultPlotMetaData constructor
//
//  Arguments:
//      p        The name of the plugin.
//      v        The name of the variable the plot is applied on.
//
//  Programmer:  Walter Herrera Jimenez
//  Creation:    September 04, 2003
//
//  Modifications:
//
// ****************************************************************************

avtDefaultPlotMetaData::avtDefaultPlotMetaData(const std::string &p, 
    const std::string &v) : AttributeSubject(avtDefaultPlotMetaData::TypeMapFormatString)
{
    // Initialize all
    *this = avtDefaultPlotMetaData();

    // Override members
    pluginID      = p;
    plotVar       = v;
}

// ****************************************************************************
//  Method: avtDefaultPlotMetaData::AddAttribute
//
//  Arguments:
//      attr  : the attribute to be added
//
//  Programmer: Walter Herrera Jimenez
//  Creation:   September 04, 2003
//
//  Modifications:
//
// ****************************************************************************

void
avtDefaultPlotMetaData::AddAttribute(const std::string& attr)
{
    plotAttributes.push_back(attr);
}

// ****************************************************************************
//  Method: avtDefaultPlotMetaData::Print
//
//  Purpose:
//      Print statement for debugging.
//
//  Arguments:
//      out      The stream to output to.
//      indent   The number of tabs to indent each line with.
//
//  Programmer:  Walter Herrera Jimenez
//  Creation:    September 04, 2003
//
//  Modifications:
//
// ****************************************************************************
inline void
Indent(ostream &out, int indent)
{
    for (int i = 0 ; i < indent ; i++)
    {
        out << "\t";
    }
}
void
avtDefaultPlotMetaData::Print(ostream &out, int indent) const
{
    Indent(out, indent);
    out << "PluginID = " << pluginID.c_str() << endl;

    Indent(out, indent);
    out << "Plot Variable = " << plotVar.c_str() << endl;

    out << "Plot Attributes:" << endl;
    for(size_t i = 0; i < plotAttributes.size(); ++i)
      out << "\t" << plotAttributes[i].c_str() << endl;
    out << endl;
}

