###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-054.nasl 5261 2009-10-14 10:11:42Z oct $
#
# Microsoft Internet Explorer Multiple Code Execution Vulnerabilities (974455)
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Updated to KB976749
#  - By Sharath S <sharaths@secpod.com> On 2009-11-04
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(901041);
  script_version("$Revision: 1.1 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-1547", "CVE-2009-2529", "CVE-2009-2530", "CVE-2009-2531");
  script_bugtraq_id(36622, 36621, 36620, 36616);
  script_name("Microsoft Internet Explorer Multiple Code Execution Vulnerabilities (974455)");
  desc = "
  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-054.

  Vulnerability Insight:
  These issues are caused by memory corruption errors when processing a specially
  crafted data stream header, when handling certain arguments, or when accessing
  certain objects.

  Impact:
  Successful exploitation will let the attacker execute arbitrary codes via
  specially crafted HTML page in the context of the affected system and cause
  memory corruption.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Internet Explorer version 5.x/6.x/7.x/8.x

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/Bulletin/MS09-054.mspx

  References:
  http://support.microsoft.com/kb/974455
  http://support.microsoft.com/kb/976749
  http://www.vupen.com/english/advisories/2009/2889
  http://www.microsoft.com/technet/security/Bulletin/MS09-054.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the vulnerable mshtml.dll file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

ieVer = get_kb_item("MS/IE/Version");
if(!ieVer){
  exit(0);
}

# MS09-054 Hotfix (974455)
if(hotfix_missing(name:"974455") == 0)
{
  # MS09-054 Hotfix (976749)
  if(hotfix_missing(name:"976749") == 0){
    exit(0);
  }
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
dllPath += "\mshtml.dll";
share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

if(hotfix_check_sp(win2k:5) > 0)
{
  # Check for mshtml.dll version < 5.0.3881.1900 or 6.0 < 6.0.2800.1640
  if(version_in_range(version:vers, test_version:"5.0", test_version2:"5.0.3881.1899") ||
     version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2800.1639")){
    security_hole(0);
  }
}
else if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.2900.3636 7.0.6000.10000 < 7.0.6000.16939,
    # 7.0.6000.20000 < 7.0.6000.21142, 8.0.6001.10000 < 8.0.6001.18852 and 8.0.6001.20000 < 8.0.6001.22942
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2900.3635")||
       version_in_range(version:vers, test_version:"7.0", test_version2:"7.0.6000.16938")||
       version_in_range(version:vers, test_version:"7.0.6000.20000", test_version2:"7.0.6000.21141")||
       version_in_range(version:vers, test_version:"8.0", test_version2:"8.0.6001.18851")||
       version_in_range(version:vers, test_version:"8.0.6001.20000", test_version2:"8.0.6001.22941")){
      security_hole(0);
    }
    exit(0);
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.2900.5890, 7.0.6000.10000 < 7.0.6000.16939,
    # 7.0.6000.20000 < 7.0.6000.21142, 8.0.6001.10000 < 8.0.6001.18852 and 8.0.6001.20000 < 8.0.6001.22942
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.2900.5889")||
       version_in_range(version:vers, test_version:"7.0", test_version2:"7.0.6000.16938") ||
       version_in_range(version:vers, test_version:"7.0.6000.20000", test_version2:"7.0.6000.21141") ||
       version_in_range(version:vers, test_version:"8.0", test_version2:"8.0.6001.18851")||
       version_in_range(version:vers, test_version:"8.0.6001.20000", test_version2:"8.0.6001.22941")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
else if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for mshtml.dll version 6.0 < 6.0.3790.4605 , 7.0 < 	7.0.6000.16939,
    # 7.0.6000.20000 < 7.0.6000.21142, 8.0.6001.10000 < 8.0.6001.18852 and 8.0.6001.20000 < 8.0.6001.22942
    if(version_in_range(version:vers, test_version:"6.0", test_version2:"6.0.3790.4604") ||
       version_in_range(version:vers, test_version:"7.0", test_version2:"7.0.6000.16938") ||
       version_in_range(version:vers, test_version:"7.0.6000.20000", test_version2:"7.0.6000.21141")||
       version_in_range(version:vers, test_version:"8.0", test_version2:"8.0.6001.18851")||
       version_in_range(version:vers, test_version:"8.0.6001.20000", test_version2:"8.0.6001.22941")){
      security_hole(0);
    }
    exit(0);
  }
  security_hole(0);
}
