###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms09-027.nasl 2771 2009-06-10 15:31:09Z june $
#
# Microsoft Office Word Remote Code Execution Vulnerabilities (969514)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900365);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-0563", "CVE-2009-0565");
  script_bugtraq_id(35188, 35190);
  script_name("Microsoft Office Word Remote Code Execution Vulnerabilities (969514)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS09-027.

  Vulnerability Insight:
  The flaws are due to boundary errors when parsing certain records that can be
  exploited to cause a buffer overflow.

  Impact:
  Successful exploitation could execute arbitrary code on the remote system
  via a specially crafted Word document.

  Impact Level: System/Application

  Affected Software/OS:
  Microsoft Word Viewer 2003
  Microsoft Office 2K/XP/2003/2007

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link.
  http://www.microsoft.com/technet/security/bulletin/ms09-027.mspx

  References:
  http://secunia.com/advisories/35377
  http://support.microsoft.com/kb/969514
  http://www.microsoft.com/technet/security/bulletin/ms09-027.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.3
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable DLL file version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_office_products_version_900032.nasl",
                      "secpod_ms_office_detection_900025.nasl");
  script_require_keys("SMB/WindowsVersion", "SMB/Office/Word/Version");
  script_require_ports(139, 445);
  exit(0);
}


include("version_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

# Check for Office Word 2000, XP, 2003 and 2007
if(egrep(pattern:"^(9|10|11|12)\..*", string:get_kb_item("MS/Office/Ver")))
{
  # Grep for Office Word Version from KB
  wordVer = get_kb_item("SMB/Office/Word/Version");
  if(!wordVer){
    exit(0);
  }

  # Check for Office Word 9.0 < 9.0.0.8979
  if(version_in_range(version:wordVer, test_version:"9.0",
                      test_version2:"9.0.0.8978")){
    security_hole(0);
  }
  # Check for Office Word 10.0 < 10.0.6854.0
  else if(version_in_range(version:wordVer, test_version:"10.0",
                           test_version2:"10.0.6853.0")){
    security_hole(0);
  }
  # Check for Office Word 11.0 < 11.0.8307.0
  else if(version_in_range(version:wordVer, test_version:"11.0",
                           test_version2:"11.0.8306.0")){
    security_hole(0);
  }
  # Check for Office Word 12.0 < 12.0.6504.5000
  else if(version_in_range(version:wordVer, test_version:"12.0",
                           test_version2:"12.0.6504.4999")){
    security_hole(0);
  }
}

# Check for Office Word Version 2007 with compatiability pack
if(get_kb_item("SMB/Office/Word/Version") =~ "^(12)\..*" )
{
  wordcnvVer = get_kb_item("SMB/Office/WordCnv/Version");
  if(!wordcnvVer){
    exit(0);
  }

  # Check for Word Converter 2007 version 12.0 < 12.0.6500.5000
  if(version_in_range(version:wordcnvVer, test_version:"12.0",
                      test_version2:"12.0.6500.4999")){
    security_hole(0);
  }
}

# Check for Word Viewer 11.0 < 11.0.8307.0
wordviewVer = get_kb_item("SMB/Office/WordView/Version");
if(wordviewVer != NULL)
{
  if(version_in_range(version:wordviewVer, test_version:"11.0",
                      test_version2:"11.0.8306.0")){
    security_hole(0);
  }
}
