###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for gdm FEDORA-2007-1362
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861390);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"1.5");
  script_tag(name:"risk_factor", value:"Low");
  script_xref(name: "FEDORA", value: "2007-1362");
  script_cve_id("CVE-2007-3381");
  script_name( "Fedora Update for gdm FEDORA-2007-1362");
  desc = "

  Vulnerability Insight:
  Gdm (the GNOME Display Manager) is a highly configurable
  reimplementation of xdm, the X Display Manager. Gdm allows you to log
  into your system with the X Window System running and supports running
  several different X sessions on your local machine at the same time.


  Affected Software/OS:
  gdm on Fedora 7

  Fix: Please Install the Updated Packages.

  References:
  https://www.redhat.com/archives/fedora-package-announce/2007-July/msg00564.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gdm");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC7")
{

  if(isrpmvuln(pkg:"gdm", rpm:"gdm~2.18.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gdm-extra-faces", rpm:"gdm-extra-faces~2.18.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gdm-debuginfo", rpm:"gdm-debuginfo~2.18.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gdm", rpm:"gdm~2.18.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gdm-debuginfo", rpm:"gdm-debuginfo~2.18.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gdm", rpm:"gdm~2.18.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"gdm-extra-faces", rpm:"gdm-extra-faces~2.18.4~1.fc7", rls:"FC7"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}