# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory FEDORA-2009-8622 (gnutls)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(64971);
 script_cve_id("CVE-2009-2730", "CVE-2008-4989");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Fedora Core 10 FEDORA-2009-8622 (gnutls)");

 desc = "The remote host is missing an update to gnutls
announced via advisory FEDORA-2009-8622.

Update Information:

This update fixes handling of NUL characters in certificate  Common Name or
subjectAltName fields especially in regards to comparsion to hostnames.

ChangeLog:

* Wed Sep 23 2009 Tomas Mraz  2.4.2-5
- fix handling of hostname in openpgp certificates
* Fri Aug 14 2009 Tomas Mraz  2.4.2-4
- fix CVE-2009-2730 - handling of NUL chars in certificate CNs and SANs

References:

[ 1 ] Bug #516231 - CVE-2009-2730 gnutls: incorrect verification of SSL certificate with NUL in name (GNUTLS-SA-2009-4)
https://bugzilla.redhat.com/show_bug.cgi?id=516231

Solution: Apply the appropriate updates.

This update can be installed with the yum update program.  Use 
su -c 'yum update gnutls' at the command line.
For more information, refer to Managing Software with yum,
available at http://docs.fedoraproject.org/yum/.

https://secure1.securityspace.com/smysecure/catid.html?in=FEDORA-2009-8622

Risk factor : High";

 script_description(desc);

 script_summary("Fedora Core 10 FEDORA-2009-8622 (gnutls)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Fedora Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"gnutls", rpm:"gnutls~2.4.2~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls-devel", rpm:"gnutls-devel~2.4.2~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls-guile", rpm:"gnutls-guile~2.4.2~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls-utils", rpm:"gnutls-utils~2.4.2~5.fc10", rls:"FC10")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnutls-debuginfo", rpm:"gnutls-debuginfo~2.4.2~5.fc10", rls:"FC10")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
