# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1991-1 (squid/squid3)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66808);
 script_cve_id("CVE-2009-2855", "CVE-2010-0308");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 1991-1 (squid/squid3)");

 desc = "The remote host is missing an update to squid/squid3
announced via advisory DSA 1991-1.

Two denial of service vulnerabilities have been discovered in
squid and squid3, a web proxy. The Common Vulnerabilities and Exposures
project identifies the following problems:

CVE-2009-2855

Bastian Blank discovered that it is possible to cause a denial of
service via a crafted auth header with certain comma delimiters.

CVE-2010-0308

Tomas Hoger discovered that it is possible to cause a denial of service
via invalid DNS header-only packets.


For the stable distribution (lenny), these problems have been fixed in
version 2.7.STABLE3-4.1lenny1 of the squid package and version
3.0.STABLE8-3+lenny3 of the squid3 package.

For the oldstable distribution (etch), these problems have been fixed in
version 2.6.5-6etch5 of the squid package and version 3.0.PRE5-5+etch2
of the squid3 package.

For the testing distribution (squeeze) and the unstable distribution
(sid), these problems will be fixed soon.


We recommend that you upgrade your squid/squid3 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201991-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1991-1 (squid/squid3)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"squid3-common", ver:"3.0.PRE5-5+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-common", ver:"2.6.5-6etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid3-cgi", ver:"3.0.PRE5-5+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid3-client", ver:"3.0.PRE5-5+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid3", ver:"3.0.PRE5-5+etch2", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.6.5-6etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid", ver:"2.6.5-6etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"2.6.5-6etch5", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-common", ver:"2.7.STABLE3-4.1lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid3-common", ver:"3.0.STABLE8-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid", ver:"2.7.STABLE3-4.1lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squidclient", ver:"3.0.STABLE8-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid3", ver:"3.0.STABLE8-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid-cgi", ver:"2.7.STABLE3-4.1lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"squid3-cgi", ver:"3.0.STABLE8-3+lenny3", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
