\name{computeTestRegression}
\alias{computeTestRegression}
\title{Compute the Regression Test on 2 data sets.}
\description{
This ROT function, called from a Test C++ object, is given 2 samples,
and optionnaly a test level. It then computes the result of a regression
test against the null hypothesis that the linear regression coefficients
are significant. It returns the test result for each X variable, the
statistics and the p-values. 
}
\usage{
computeTestRegression(outSample, inSample, testLevel = 0.95)
}
\arguments{
  \item{outSample}{The 'out' sample (n vector).}
  \item{inSample}{The 'in' sample. (m-by-n matrix)}
  \item{testLevel}{the test level. (scalar in [0:1])}
}
\value{
 A list is returned, containing :
  \item{testResult}{The result. 1 means H0 is not rejected. (scalar)}
  \item{threshold}{The threshold applied to the p-value when deciding the outcome of the test.}
  \item{pvalues}{The test pvalues. (vector)}
}
\author{Pierre-Matthieu Pair, Softia for EDF.}
\examples{
outSample=iris[1:50,1]
inSample=as.matrix(iris[1:50,2:4])
computeTestRegression(outSample, inSample)
}
\keyword{multivariate}