/*
 *     [begin_description]
 *     Boost bind pull the placeholders, _1, _2, ... into global
 *     namespace. This can conflict with the C++03 TR1 and C++11 
 *     std::placeholders. This header provides a workaround for 
 *     this problem.
 *     [end_description]
 *        
 *     Copyright 2012 Christoph Koke
 *           
 *     Distributed under the Boost Software License, Version 1.0.
 *     (See accompanying file LICENSE_1_0.txt or
 *     copy at http://www.boost.org/LICENSE_1_0.txt)
 * */

#ifndef OMPLEXT_BOOST_NUMERIC_ODEINT_UTIL_BIND_HPP_INCLUDED
#define OMPLEXT_BOOST_NUMERIC_ODEINT_UTIL_BIND_HPP_INCLUDED


#include <omplext_odeint/boost/numeric/odeint/config.hpp>


#if BOOST_NUMERIC_ODEINT_CXX11 
#include <type_traits>
#else
#include <boost/bind.hpp>
#endif

namespace boost {
namespace numeric {
namespace omplext_odeint {
namespace detail {

#if BOOST_NUMERIC_ODEINT_CXX11 

using ::std::bind;
using namespace ::std::placeholders;


#else

using ::boost::bind;
using ::_1;
using ::_2;

#endif

}
}
}
}

#endif // BOOST_NUMERIC_ODEINT_UTIL_BIND_HPP_INCLUDED
