/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.search;

import com.sourceforge.knecs.dsm.dsi.DSI;
import com.sourceforge.knecs.dsm.dsi.DSIPool;
import com.sourceforge.knecs.dsm.dsi.DSIProperty;
import com.sourceforge.knecs.dsm.dsi.StatusException;
import com.sourceforge.knecs.dsm.search.QueryPredicate;
import com.sourceforge.knecs.dsm.util.DAVResource;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import com.sourceforge.knecs.util.NSProperty;
import com.sourceforge.knecs.util.UrlUtils;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;

public class Search {
    public Vector run(String targetURL, String userID, Object authToken, Set returnProps, Hashtable query, int depth) throws StatusException {
        DSI dsiContext = DSIPool.getDSIPool().getConnection(targetURL, userID, authToken.toString());
        Logger log = LoggerUtils.getLogger(this);
        log.info("In Search::run - " + targetURL + " as " + userID + " just created dsi");
        Vector returnValue = this.runInDsiContext(targetURL, dsiContext, returnProps, query, depth);
        DSIPool.getDSIPool().release(dsiContext);
        return returnValue;
    }

    public Vector runInDsiContext(String targetURL, DSI dsiContext, Set returnProps, Hashtable query, int depth) throws StatusException {
        Logger log = LoggerUtils.getLogger(this);
        log.info("In Search::runInDSIContext - " + targetURL);
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        NSProperty allprop = CMCSProperties.getPropertyAsNSProperty("allprop");
        boolean requestAll = false;
        boolean returnAll = false;
        Set queryProps = query.keySet();
        if (queryProps.contains(allprop)) {
            requestAll = true;
        }
        if (returnProps.contains(allprop)) {
            requestAll = true;
            returnAll = true;
        }
        Vector requestProps = null;
        if (requestAll) {
            log.info("Using a null metadata request vector");
        } else {
            log.info("combining properties to create the metadata request vector");
            HashSet combinedProps = new HashSet(queryProps);
            combinedProps.addAll(returnProps);
            Vector additionalProps = new Vector();
            Iterator combinedPropsIter = combinedProps.iterator();
            while (combinedPropsIter.hasNext()) {
                Vector relatedProps = this.getRelatedProperties((NSProperty)combinedPropsIter.next());
                additionalProps.addAll(relatedProps);
            }
            combinedProps.addAll(additionalProps);
            requestProps = new Vector(combinedProps);
        }
        long start = System.currentTimeMillis();
        Hashtable resourceMetadata = dsiContext.getMetaData(requestProps, depth);
        long end = System.currentTimeMillis();
        log.info("Back from getMetaData with " + resourceMetadata.size() + " entries to compare, duration in dsi = " + (end - start) + " ms\n");
        log.info("Starting query comparison\n");
        start = System.currentTimeMillis();
        for (NSProperty queryPropId : queryProps) {
            QueryPredicate qp = (QueryPredicate)query.get(queryPropId);
            resourceMetadata = this.doCompare(resourceMetadata, qp, true);
        }
        end = System.currentTimeMillis();
        log.info("Finished query comparison, search found " + resourceMetadata.size() + " matches in " + (end - start) + " ms\n");
        log.info("Starting result formatting\n");
        start = System.currentTimeMillis();
        Vector returnValue = this.formatResults(resourceMetadata, returnProps, returnAll, targetURL);
        end = System.currentTimeMillis();
        log.info("Finished result formatting, formatting " + resourceMetadata.size() + " matches took " + (end - start) + " ms\n");
        return returnValue;
    }

    private Vector formatResults(Hashtable resourceMetadata, Set returnProps, boolean returnAll, String targetURL) {
        Logger log = LoggerUtils.getLogger(this);
        log.info("In Search::formatResults - " + targetURL);
        Vector<DAVResource> returnValue = new Vector<DAVResource>(resourceMetadata.size());
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        NSProperty resourceURLID = CMCSProperties.getPropertyAsNSProperty("resourceurl");
        DAVResource resource = null;
        String server = UrlUtils.getServer(targetURL);
        if (returnAll) {
            Enumeration resources = resourceMetadata.keys();
            while (resources.hasMoreElements()) {
                resource = new DAVResource();
                String resourceURL = (String)resources.nextElement();
                Hashtable resourceProps = (Hashtable)resourceMetadata.get(resourceURL);
                for (NSProperty propName : resourceProps.keySet()) {
                    DSIProperty prop = (DSIProperty)resourceProps.get(propName);
                    try {
                        resource.putProperty(prop);
                    }
                    catch (Exception e) {
                        log.info("error parsing property: " + propName + e.toString());
                    }
                }
                resource.setServer(server);
                resource.put(resourceURLID, (Object)resourceURL);
                log.finer("returning resource value: " + resource.toString());
                returnValue.add(resource);
            }
        } else {
            Enumeration resources = resourceMetadata.keys();
            while (resources.hasMoreElements()) {
                resource = new DAVResource();
                String resourceURL = (String)resources.nextElement();
                Hashtable resourceProps = (Hashtable)resourceMetadata.get(resourceURL);
                for (NSProperty propName : returnProps) {
                    DSIProperty prop = (DSIProperty)resourceProps.get(propName);
                    if (prop == null) continue;
                    try {
                        resource.putProperty(prop);
                    }
                    catch (Exception e) {
                        log.info("error parsing property: " + propName + e.toString());
                    }
                }
                if (returnProps.contains(resourceURLID)) {
                    resource.setServer(server);
                    resource.put(resourceURLID, (Object)resourceURL);
                }
                log.finer("returning resource value: " + resource.toString());
                returnValue.add(resource);
            }
        }
        return returnValue;
    }

    private Hashtable doCompare(Hashtable resourceMetadata, QueryPredicate qp, boolean propertyRequired) {
        Logger log = LoggerUtils.getLogger(this);
        log.info("In Search::doCompare");
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        NSProperty allprop = CMCSProperties.getPropertyAsNSProperty("allprop");
        String davNamespace = props.getProperty("davns");
        NSProperty queryPropName = qp.getNSProperty();
        log.fine("Querying on property " + queryPropName.toString());
        if (!propertyRequired) {
            log.fine("Property existence is not required to match");
        }
        String[] queryValue = qp.getValue();
        if (queryPropName.equals(allprop)) {
            Enumeration resources = resourceMetadata.keys();
            while (resources.hasMoreElements()) {
                String resourceURL = (String)resources.nextElement();
                log.fine("Resource URL being compared: " + resourceURL);
                Hashtable resourceProps = (Hashtable)resourceMetadata.get(resourceURL);
                log.fine("Number of properties for resource: " + resourceProps.size());
                boolean aMatch = false;
                Iterator resourcePropsIter = resourceProps.keySet().iterator();
                while (resourcePropsIter.hasNext() && !aMatch) {
                    NSProperty propName = (NSProperty)resourcePropsIter.next();
                    if (propName.getNamespaceURI().equals(davNamespace) && !propName.getLocalName().equals("displayname") && !propName.getLocalName().equals("owner")) continue;
                    log.fine("Comparing against property " + propName.toString());
                    DSIProperty prop = (DSIProperty)resourceProps.get(propName);
                    String propValue = prop.getPropertyAsXMLString(true).toLowerCase();
                    for (int j = 0; j < queryValue.length && !aMatch; ++j) {
                        log.finer("Query compare " + j + ":!" + propValue + "!,!" + queryValue[j].toLowerCase() + "!");
                        if (propValue.indexOf(queryValue[j].toLowerCase()) < 0) continue;
                        aMatch = true;
                        log.fine("Yes we did match!!!!");
                    }
                }
                if (aMatch) continue;
                resourceMetadata.remove(resourceURL);
            }
        } else {
            Vector queryProperties = this.getRelatedProperties(queryPropName);
            Enumeration resources = resourceMetadata.keys();
            while (resources.hasMoreElements()) {
                String resourceURL = (String)resources.nextElement();
                log.fine("Resource URL being compared: " + resourceURL);
                Hashtable resourceProps = (Hashtable)resourceMetadata.get(resourceURL);
                log.fine("Number of properties for resource: " + resourceProps.size());
                boolean aMatch = false;
                boolean comparedValue = false;
                Iterator queryPropertiesIterator = queryProperties.iterator();
                while (queryPropertiesIterator.hasNext() && !aMatch) {
                    DSIProperty prop = (DSIProperty)resourceProps.get(queryPropertiesIterator.next());
                    if (prop == null) continue;
                    comparedValue = true;
                    String propValue = prop.getPropertyAsXMLString(true).toLowerCase();
                    for (int j = 0; j < queryValue.length && !aMatch; ++j) {
                        log.finer("Query compare " + j + ":!" + propValue + "!,!" + queryValue[j].toLowerCase() + "!");
                        if (propValue.indexOf(queryValue[j].toLowerCase()) < 0) continue;
                        aMatch = true;
                        log.fine("Yes we did match!!!!");
                    }
                }
                if ((aMatch || !comparedValue) && (!propertyRequired || comparedValue)) continue;
                resourceMetadata.remove(resourceURL);
            }
        }
        return resourceMetadata;
    }

    private Vector getRelatedProperties(NSProperty propName) {
        Vector<NSProperty> retval = new Vector<NSProperty>();
        retval.add(propName);
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        NSProperty speciesProp = CMCSProperties.getPropertyAsNSProperty("hasspecies");
        NSProperty creatorProp = CMCSProperties.getPropertyAsNSProperty("creator");
        if (propName.equals(speciesProp)) {
            speciesProp = CMCSProperties.getPropertyAsNSProperty("speciescas");
            retval.add(speciesProp);
            speciesProp = CMCSProperties.getPropertyAsNSProperty("speciesname");
            retval.add(speciesProp);
            speciesProp = CMCSProperties.getPropertyAsNSProperty("speciesformula");
            retval.add(speciesProp);
        } else if (propName.equals(creatorProp)) {
            creatorProp = CMCSProperties.getPropertyAsNSProperty("davowner");
            retval.add(creatorProp);
        }
        return retval;
    }
}

