/* NVTV error header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id: error.h,v 1.4 2004/03/01 21:08:10 dthierbach Exp $
 *
 * Contents:
 *
 * Error handling.
 *
 */

#ifndef _ERROR_H
#define _ERROR_H

#include <stdio.h>
#include "debug.h"

/* -------- Error handling layer -------- */

/* Error handling must deal with these situations:
 *
 * (a) standalone ("nvtv") -- print message to stderr, abort if necessary
 * (b) server ("nvtvd") -- report message to syslog, handle aborts somehow
 * (c) library ("libnvtvsimple") -- make message available to caller
 * (d) as part of X -- use X DEBUG and ErrorF routines.
 *
 * So as a unified interface, there is a macro RAISE and message classes.
 * Cases (a) and (b) are handled here by mapping RAISE to a routine
 * in nvtv.c or nvtvd.c, and mapping the message classes to numers.
 *
 */

#define MSG_ABORT	1  /* critical message; abort after message */
#define MSG_ERROR	2  /* non-critical error */
#define MSG_WARNING	3  /* non-critical warning */
#define MSG_INFO	4  /* information for syslog */
#define MSG_DEBUG	5  /* debug message */
#define MSG_DEBUG_NL	6  /* debug message */

#define RAISE raise_msg

void raise_msg (int class, char *format, ...);

/* Fake output, FIXME no \n */
#define FPRINTF(X, Y...) /* */

#define xf86Msg(type,format,args...) /* */
#define xf86DrvMsg(scrnIndex,type,format, args...) /* */

#define DEBUG(x) /*x*/

#endif /* _ERROR_H */

