# use OpenCV's HighGUI for cross-platform windowing

import cv2
import gobject
import numm.async
import numpy

framerate = 30

class RunCV(numm.async.Run):
    def set_video_out(self, callback):
        self.video_out = callback
        if hasattr(self, '_window') or callback is None:
            # XXX: Remove window if callback is None
            return

        self._window = "numm"
        cv2.namedWindow(self._window)

        cv2.setMouseCallback(self._window, self._mouse_event)

        gobject.timeout_add(
            # since waitKey blocks, we split the delay evenly
            int(500/framerate),
            lambda: self._need_video_data(self._window))

    def _mouse_event(self, ev, x, y, button, flags):
        if self.mouse_in is not None:
            type = 'mouse-move'
            if ev == cv2.EVENT_LBUTTONDOWN or ev == cv2.EVENT_MBUTTONDOWN or ev == cv2.EVENT_RBUTTONDOWN:
                type = 'mouse-button-press'
                if ev == cv2.EVENT_LBUTTONDOWN:
                    button = 1
                elif ev == cv2.EVENT_MBUTTONDOWN:
                    button = 3
                else:
                    button = 2
                
            elif ev == cv2.EVENT_LBUTTONUP or ev == cv2.EVENT_MBUTTONUP or ev == cv2.EVENT_RBUTTONUP:
                type = 'mouse-button-release'
                if ev == cv2.EVENT_LBUTTONUP:
                    button = 1
                elif ev == cv2.EVENT_MBUTTONUP:
                    button = 3
                else:
                    button = 2
            self.mouse_in(type, x/320.0, y/240.0, button)

        
    def _need_video_data(self, wid):
        a = numpy.zeros((240,320,3), dtype=numpy.uint8)
        if self.video_out:
            self.video_out(a)
            # convert RGB to BGR
            a[:,:,[0, 2]] = a[:,:,[2, 0]]
        cv2.imshow(wid, a)

        ch = cv2.waitKey(int(500/framerate))
        if ch == 27:
            # XXX: properly quit
            cv2.destroyAllWindows()
            return False
        elif ch > -1 and ch < 256:
            # XXX: capital letters and special characters are ignored.
            # also there's a 50% chance we miss the event.
            # also there's no key-release.
            # also it's nontrivial to do any better with opencv's windowing.
            # also i think i'm ok with that.
            if self.keyboard_in is not None:
                self.keyboard_in('key-press', chr(ch))
        
        return True

def runcv(**kw):
    run = RunCV(**kw)
    run.run()
