CREATE TABLE IF NOT EXISTS VOs (
  VOId    INTEGER PRIMARY KEY AUTOINCREMENT,
  VOName  TEXT NOT NULL UNIQUE
);
CREATE TABLE IF NOT EXISTS Owners (
  OwnerId  INTEGER PRIMARY KEY AUTOINCREMENT,
  OwnerDN  TEXT NOT NULL UNIQUE
);
CREATE TABLE IF NOT EXISTS UsageRecords (
  RecordId    TEXT PRIMARY KEY,
  RecordType  INTEGER NOT NULL,
  StartTime   TIMESTAMP NOT NULL,
  EndTime     TIMESTAMP NOT NULL,
  WallTime    INTEGER NOT NULL,
  CpuTime     INTEGER NOT NULL,
  Procs       INTEGER NOT NULL,
  JobName     TEXT NOT NULL,
  JobId       TEXT NOT NULL,
  OwnerId     INTEGER NOT NULL,
  VOId        INTEGER NOT NULL,
  FOREIGN KEY(OwnerId) REFERENCES Owners(OwnerId),
  FOREIGN KEY(VOId) REFERENCES VOs(VOId)
);
CREATE INDEX IF NOT EXISTS UsageRecords_StartTime_idx ON UsageRecords(StartTime);
CREATE INDEX IF NOT EXISTS UsageRecords_EndTime_idx ON UsageRecords(EndTime);
CREATE INDEX IF NOT EXISTS UsageRecords_RecordType_idx ON UsageRecords(RecordType);
CREATE TABLE IF NOT EXISTS Vars (VarName TEXT PRIMARY KEY, VarValue TEXT NOT NULL);
INSERT INTO Vars VALUES ('VERSION', '1.0');