/*
 * Generated with the genpubsuffix tool.
 *  From file public_suffix_list.dat
 *  Converted on Sat Nov 19 10:08:43 2016
 */

/**
 * Public suffix list graph node
 */
union pnode {
    struct {
        unsigned int idx:24; /**< index of domain element in string table */
        unsigned int len:6; /**< length of domain element in string table */
        unsigned int children:1; /**< has children */
    } label;
    struct {
        uint16_t index; /**< index of first child node */
        uint16_t count; /**< number of children of this node */
    } child;
};

enum stab_entities {
    STAB_WILDCARD = 0,
    STAB_EXCEPTION = 12
};

/**
 * Huffman coding node
 */
struct hnode {
    uint8_t term:1; /**< non zero if the node terminates a code */
    uint8_t value:7; /**< value in node */
};

/**
 * Huffman decoding table
 *
 * nodes are in pairs even nodes are for 0bit odd for 1
 */
static const struct hnode htable[76] = {
    { 0, 2 },
    { 0, 40 },
    { 0, 4 },
    { 0, 30 },
    { 0, 6 },
    { 0, 10 },
    { 0, 8 },
    { 1, 't' }, /* 't': 0001 */
    { 1, 'b' }, /* 'b': 00000 */
    { 1, 'c' }, /* 'c': 00001 */
    { 0, 12 },
    { 0, 26 },
    { 0, 14 },
    { 1, 'g' }, /* 'g': 00101 */
    { 0, 16 },
    { 1, 'v' }, /* 'v': 001001 */
    { 0, 18 },
    { 0, 22 },
    { 1, '1' }, /* '1': 00100000 */
    { 0, 20 },
    { 1, '9' }, /* '9': 001000010 */
    { 1, '7' }, /* '7': 001000011 */
    { 1, 'q' }, /* 'q': 00100010 */
    { 0, 24 },
    { 1, '5' }, /* '5': 001000110 */
    { 1, '3' }, /* '3': 001000111 */
    { 1, 'd' }, /* 'd': 00110 */
    { 0, 28 },
    { 1, 'f' }, /* 'f': 001110 */
    { 1, 'x' }, /* 'x': 001111 */
    { 0, 32 },
    { 1, 'a' }, /* 'a': 011 */
    { 1, 'r' }, /* 'r': 0100 */
    { 0, 34 },
    { 1, 'h' }, /* 'h': 01010 */
    { 0, 36 },
    { 1, 'p' }, /* 'p': 010110 */
    { 0, 38 },
    { 1, 'j' }, /* 'j': 0101110 */
    { 1, 'z' }, /* 'z': 0101111 */
    { 0, 42 },
    { 0, 50 },
    { 0, 44 },
    { 0, 46 },
    { 1, 's' }, /* 's': 1000 */
    { 1, 'e' }, /* 'e': 1001 */
    { 1, 'o' }, /* 'o': 1010 */
    { 0, 48 },
    { 1, 'k' }, /* 'k': 10110 */
    { 1, 'm' }, /* 'm': 10111 */
    { 0, 52 },
    { 0, 56 },
    { 1, 'n' }, /* 'n': 1100 */
    { 0, 54 },
    { 1, 'l' }, /* 'l': 11010 */
    { 1, 'u' }, /* 'u': 11011 */
    { 1, 'i' }, /* 'i': 1110 */
    { 0, 58 },
    { 0, 60 },
    { 1, '-' }, /* '-': 11111 */
    { 1, 'y' }, /* 'y': 111100 */
    { 0, 62 },
    { 0, 64 },
    { 1, 'w' }, /* 'w': 1111011 */
    { 0, 66 },
    { 0, 68 },
    { 1, '4' }, /* '4': 111101000 */
    { 1, '2' }, /* '2': 111101001 */
    { 1, '0' }, /* '0': 111101010 */
    { 0, 70 },
    { 1, '8' }, /* '8': 1111010110 */
    { 0, 72 },
    { 0, 74 },
    { 1, '6' }, /* '6': 11110101111 */
    { 1, '*' }, /* '*': 111101011100 */
    { 1, '!' }, /* '!': 111101011101 */
};

/**
 * Domain label string table huffman encoded.
 * 5903 labels(337056 bits) reduced to 4147 labels(158944 bits)
 */
static const uint32_t stab[4967] = {
    0xFCBAF3AF, 0x244B0FFC, 0xC7E7E2AF, 0xEFAB095C, 0x4F8CE839, 0xC8497C15,
    0xA16C9D50, 0xE59F1397, 0xFC6605E0, 0x0789CF9C, 0xF18156A6, 0xAE63EC3D,
    0x9EFBD584, 0x89ABC683, 0xA6A4F21C, 0xAC17A0E7, 0x78D21489, 0x4FFCFC35,
    0x139A74A6, 0x87B8C520, 0x340DED7E, 0xFA78D239, 0xEA85E954, 0x6078B626,
    0x993FF3F2, 0x804E69D2, 0x87CA6314, 0xB1E10C08, 0x6437FC1C, 0x5E351E06,
    0x07FF3F0D, 0x857984EA, 0x1F9C8AF2, 0xFF9F8044, 0xFA2FE4BB, 0xAF307AA5,
    0xF804444F, 0xA82E1FF9, 0x2BF4ABE0, 0x34BE92F0, 0x3D190A21, 0x55C01B54,
    0x8148ED9B, 0x9A839835, 0xCA687223, 0x33C14477, 0xB7270D5E, 0x27327DD7,
    0x6F4FE7F5, 0xC987B3AF, 0x4ACB03F9, 0xCF147F44, 0x3F9C9879, 0xB03EE78A,
    0xB03444AC, 0x47F444AC, 0x30F7DCF1, 0xBD1AF739, 0x6B967E7F, 0x8F3903F9,
    0xFB9E28DE, 0x0FE7261E, 0x8D112B2C, 0x2C0FB9E2, 0x3DFD112B, 0xFCFCCE4C,
    0x8AD12DEF, 0xEC3CB57E, 0xF3F006EB, 0x5D0CF4FF, 0xE5FB3B92, 0xC41C0847,
    0xFC5A773F, 0xF9169F1D, 0x09F819DF, 0x773FBE2E, 0x65E781E3, 0x70945E46,
    0x27DD7B72, 0xA67F5273, 0x9399D7B7, 0x9CC8EBDB, 0xBD3F9FD4, 0x56B0CEBD,
    0x6FBD79CD, 0xB00F73AD, 0x3FF3F285, 0xA0E7BEAC, 0x7AF93E33, 0x6E31ACBF,
    0x581752F1, 0xB91DF4F2, 0x3FFF3F3B, 0xD63F9281, 0x75BFC931, 0x3BFF9F80,
    0x3A293FA2, 0xC237F19D, 0xFFF9F8E6, 0x235E42FD, 0x4E35EB96, 0xC46C626D,
    0xD6B922C0, 0xA9B7EE2F, 0xF3464AF7, 0x296BFBE2, 0xE285E351, 0x7843149B,
    0x26BF072C, 0xD5E0E649, 0x98A3E4F8, 0x587E0EE3, 0x938B5283, 0x9CC8EBDB,
    0xEDE99FD4, 0xC1C94675, 0x585EFA9B, 0xA268ECDF, 0xFD4DE0E4, 0x9E3EC9D8,
    0x3930F2D4, 0x444ACB03, 0xC3CE78A3, 0x39E28CE4, 0x68895960, 0x9879CF14,
    0x2565819C, 0x073C51A2, 0xED112B2C, 0xC9EE7261, 0x2EA37F4E, 0xAA02E4B0,
    0x2DEE318C, 0x809CC4EF, 0xC3969ACA, 0x61E1FFCF, 0x9CBA1193, 0xF3F0145F,
    0x9A10503F, 0xDFE385DC, 0xFF9F9B08, 0xD7793529, 0xFC7B5FFC, 0xE7E2B082,
    0x70BBD57F, 0x78FF40E9, 0xFFCFC861, 0x86AED6AD, 0x131F84FE, 0xF9F8AC23,
    0x54AE89BF, 0x836F57F3, 0xFC748417, 0x49F21FFC, 0x7CA6878B, 0xFF3F014A,
    0x6BB1982B, 0x98FC27D5, 0xCFC03138, 0x14829DFF, 0xB18985ED, 0x308D7E17,
    0x4EFFE7E5, 0x087AD101, 0x3D7E57C3, 0x60400E61, 0xB8BF5C91, 0x2BDEA6DF,
    0xB5E4CD19, 0xAB0F8C14, 0x32B0686B, 0xA6F07250, 0xD99617BE, 0xC1C944D1,
    0xD9B1FA9B, 0x285A93C7, 0x3F537839, 0xA93C3276, 0x37839285, 0xCDF585E5,
    0x0E4A268E, 0x64EC54DE, 0xF56A4F1F, 0xE593BD1A, 0x1E72065A, 0xCC8595BD,
    0x812B9840, 0xE026AF18, 0xB0F4C0E5, 0xE503B61B, 0x30397809, 0x725B8C63,
    0xFE7E0CAD, 0xC4F33207, 0x6BFBF61E, 0x0FFCFC86, 0xAA45E2D2, 0x6179FF76,
    0x0A07FE7E, 0xE385DC9A, 0xCFCC2F1F, 0x4B5AA2FF, 0xBFFB7521, 0xCFC73022,
    0x4D4D2BFF, 0x627F35DE, 0xFF3F012F, 0x772465F7, 0xBC7EFD69, 0x33FF3F30,
    0x4E8E6493, 0xC2F3FFA8, 0x281FFCFC, 0xE730B1F9, 0xE7E021EB, 0xF92618FF,
    0x57FD8797, 0x7FF3F010, 0xC847C0A7, 0xABF492C4, 0x504A6057, 0x653033BD,
    0x85EDC6FA, 0x4A573262, 0x0F16C4DC, 0xAD8B504C, 0x9D0DD687, 0xBC94AB7A,
    0x8370FEF8, 0x2C7F2B83, 0x6699A993, 0x17AC9968, 0x94FA75B8, 0xD6132148,
    0x94094C1E, 0x8392896B, 0x3363F537, 0x9285A93C, 0x85E53783, 0x51347665,
    0x62A6F072, 0xB5278FB3, 0xA6F07250, 0x93C32762, 0x6A02D05A, 0xCAE8FFCE,
    0x95D1C738, 0x2D0F8E71, 0x8EACE6A0, 0x6375D43A, 0xADD750EC, 0xA0E4B02E,
    0xC4BC1457, 0xD45B8C67, 0x405C9605, 0x72F01195, 0xBA987A60, 0x730792C0,
    0xF7DEAB65, 0x0D5E335C, 0x9927FF3F, 0x9115FF73, 0xF350115F, 0x09A2BFF3,
    0x53ECD02A, 0xFFE7E6E2, 0x8A542C26, 0x99AFEFD9, 0xC949FF9F, 0x7E52D79F,
    0xFCFCCD7B, 0xDD0495AF, 0x5F2FD03F, 0x7FF3F1CF, 0xE616F7C8, 0xE66BD7F5,
    0x03327FE7, 0xE3FCFA49, 0xB67AFAFD, 0x70FD4D5E, 0xD1375E53, 0x6F9FF9F8,
    0xC45B25F0, 0x95F32C4D, 0x4EFFE7E2, 0xF5908F81, 0xBD7B4894, 0x3BFF9F8E,
    0x0BDA2905, 0x2C2F6313, 0xBC4FFCFC, 0x235E0888, 0x10DA6BD7, 0xF9F9BD7F,
    0xE26C589F, 0x8884742F, 0xA0D01EBF, 0x600FFCFC, 0x4C840023, 0x80BE498C,
    0xFB5BFC41, 0x1D2A8253, 0xF88209F8, 0x04A7F6B7, 0xBFF03A55, 0xDADFE20C,
    0xD2A8DA8F, 0x88209F81, 0x6A3F6B7F, 0xFE074AA3, 0x1DEA4097, 0xF12E6129,
    0xF17696E9, 0xA44D61FD, 0xF323C690, 0xAA6BFBE2, 0x5358A8B0, 0xF3DF1729,
    0x7D053073, 0xD50F4293, 0x60523B06, 0x4AA0E60D, 0x5A1F542F, 0xE92B9252,
    0x23C431FD, 0xC4249D93, 0x534BC792, 0x1A21FDFE, 0x66D5706B, 0x85B1F93E,
    0x03CB5BCC, 0xB88BED53, 0x81DBAF94, 0xDB939307, 0x9F993EEB, 0x94675EDE,
    0xEFA9BC1C, 0x5134766F, 0x7EA6F072, 0x85A93C7C, 0x15378392, 0x2D49E19B,
    0xE7350168, 0x1CE32BA3, 0x39C65747, 0x9CD405A0, 0xBA8751D5, 0x7E6E2750,
    0xA8751D5B, 0xEA152753, 0x8751D5BA, 0x9EFDD8BA, 0xA8EA750A, 0xC6375D43,
    0x9EEDDC7E, 0xC1E3D072, 0x4019DA23, 0xDF79EC3C, 0xF2B5E924, 0xF2581751,
    0x72F01714, 0xB91DF660, 0x7392993B, 0xF18E86F4, 0x93B8BC6A, 0xE318F4B4,
    0x94A978D5, 0xD4D4D343, 0x9A5CB32D, 0x3BD25B3A, 0xE312C258, 0xE0C16991,
    0x689D7FE7, 0x13EC3CB9, 0xFE7E617B, 0x5E61BAEF, 0x2FF5FF39, 0xCBFFCFCC,
    0xFB74CD2A, 0xCFCC7E13, 0xD38300FF, 0x484FB095, 0xA7FE7E6F, 0x5B4658B7,
    0x3F32BE9F, 0x50F137FF, 0x5783F2D5, 0xF57FE7E6, 0xFC4B0F2C, 0x9F985EC4,
    0x1E391BFF, 0x2BDBF39A, 0x3D3FF3F3, 0xFF8E1772, 0xF9F98F6B, 0xB44E497F,
    0x0BD89FA2, 0x993FF3F3, 0x7DE54254, 0xFCFCCAF8, 0xD2F837CF, 0xF27AB88B,
    0xBFF9F9A5, 0x1EB44053, 0x273490C2, 0xE9CFFCFC, 0xBD8D789F, 0x6926D09E,
    0x4EFFE7E7, 0x57C30981, 0xE72BCC00, 0x9041E072, 0x16AF409E, 0x4F8EFFC4,
    0x0CEFFC8B, 0xAC3904FC, 0x83795438, 0x81989329, 0xB07CD7BF, 0x72DCEE8A,
    0x8595FDF1, 0x4B4977FD, 0xEBFEF8B9, 0xCE5A0A40, 0xDF3DF173, 0xF41ED610,
    0xC1BFC5E0, 0x5582D0FA, 0x0A7F1713, 0xE3C14C3F, 0x7445D92E, 0xF2A0A60B,
    0x64C3B53C, 0xFF9547C6, 0x6032BCAD, 0x42B4A86D, 0x19727163, 0x5B8489FD,
    0x9EE81F0E, 0xDF24EE62, 0x6353EB5E, 0xBD60FDBE, 0x3F1DF267, 0xF286F4D0,
    0xB4A5BFF3, 0x31E0FC12, 0x9289EACD, 0x052D793F, 0x53BFF9F9, 0xC17EE260,
    0x9CDEBC11, 0xC9F75EDC, 0x33AF6F4F, 0x7DD7B727, 0x75EDE932, 0x3AF6E4E6,
    0xBDBD3F32, 0x783928CE, 0x4766DF53, 0x6F072513, 0xD49E07EA, 0x9BC1C942,
    0x9A3B37F2, 0x53783928, 0x16A4F1F1, 0x798ED774, 0x5764F7EA, 0x87D5D93D,
    0x4F31DAEE, 0xF57A5249, 0x9C8197A1, 0xEA156A9F, 0xCB35D580, 0x750EA3A9,
    0xDDD8C6A6, 0x1EFDC6FD, 0x293A8777, 0xEEA1D475, 0x6FD45629, 0x750EA3AB,
    0x07541D50, 0x50EA3AB6, 0x71F8B7D7, 0x50E1DF77, 0x71F8B7D7, 0xD775B737,
    0x50DD36FC, 0xE8502B5D, 0x2D45E839, 0xE1C8072C, 0x76B58285, 0x6EA86707,
    0x6A09C931, 0x56B03961, 0xCB695989, 0xBAB0DE98, 0x5D4531B6, 0x6B03C960,
    0x6256BB30, 0xB2A82C79, 0xE0B28783, 0x361EC04A, 0x015E2DC6, 0x1466072F,
    0xB1514F4C, 0x67688EA6, 0xF981CBC0, 0x357883B9, 0x8E2CC681, 0x92DBF2E5,
    0x41ED603B, 0x98D03279, 0x3791D63B, 0xC9605D54, 0xF54236F3, 0x55C3EC3D,
    0x7FF3F1B0, 0xF3EE5493, 0xFE7E6F19, 0x455C9357, 0xF302227C, 0xD0F2FFF3,
    0xF1D7E924, 0x3095D40E, 0x915E50AF, 0x20FFCFC3, 0xBF492565, 0xFF3F378E,
    0xEE98C603, 0x49603177, 0xFD17F2EA, 0xA32664AA, 0xFA2FE497, 0x2F307AA5,
    0xB557FE7E, 0xC57CE570, 0xD5FF9F9B, 0x9F29A1E3, 0xFCFCC088, 0x574E48DF,
    0xE6F0FEC2, 0x7721FFE7, 0xB7ABF8E1, 0xB17FF9F9, 0x89F39A1B, 0xFFCFCC08,
    0x7CF29883, 0xF9F938F0, 0xA92D34BF, 0xF9BC7FB0, 0x16A1FFF9, 0x0235F396,
    0xE4BFF3F3, 0x49F3C64C, 0xBFF3F302, 0xF39A1BAC, 0xFE7E6F3B, 0x214BA68F,
    0x98124F9F, 0xCDA3FF9F, 0xF1CFB0F2, 0x40FFE7E6, 0x1FAF309D, 0xFFE7E604,
    0xCD49CF90, 0x3F302227, 0x62FC87FF, 0xC0889F5E, 0x221FFCFC, 0x444FE179,
    0x47FE7E60, 0x5F6681A1, 0xFFCFCC08, 0xE8520138, 0xB3702227, 0xE8A5FAFE,
    0x4F35AB3F, 0x78F7DEAB, 0x0F602571, 0x9F53D23B, 0x323B4F13, 0x2FFF3F1A,
    0xC091800A, 0x3F1D35EC, 0xE00A77FF, 0x1EB2132B, 0x8394F752, 0xC935E49E,
    0x8F229688, 0xE0A5A526, 0x91878465, 0x754960D7, 0xFFF3F20F, 0x03D78011,
    0x2FDEBF02, 0x1BFF9F93, 0x61309E14, 0x30BFC046, 0x0A77FF3F, 0x330906EC,
    0xFFE7E392, 0x73092221, 0x7655EAF1, 0xFB9FF107, 0xAF141CC3, 0x6D57004F,
    0x6A506B06, 0xD57064AD, 0xA506B066, 0x032D3596, 0xEFF2FFBF, 0xC0C9A8BE,
    0xBBFCBFEF, 0x9DB86AE3, 0x1CC82988, 0xF8BFA893, 0xB5AAA0FE, 0xE2E52D4C,
    0x785CC3FB, 0xC5CF3830, 0x161E5FF7, 0xC5CA5AD0, 0x9B375FF7, 0x2E523BFF,
    0xB6A4BFBE, 0xB9E83AC1, 0xB1EF9EF8, 0x17817540, 0x3EA87DFF, 0xA61E04AA,
    0xDC2467AA, 0xC374F872, 0xF0E5B848, 0x183C4341, 0xC09E31B5, 0x6D5701EC,
    0xFDFC92C6, 0x706B1A21, 0x6A5466D5, 0xB61E530F, 0xFF3F286E, 0xDC4C0A77,
    0xF671382F, 0xD52FE75B, 0xDC9CC74D, 0x7A49F75E, 0xB9399D7B, 0xF4FC8EBD,
    0x72733AF6, 0xF4991D7B, 0xE4A33AF6, 0xECD94DE0, 0xE0E4A268, 0xD49E054D,
    0x31DAEE82, 0x5764F54F, 0x45FAD72C, 0xDC5039D7, 0x77415D93, 0x24A798ED,
    0x5E82BD29, 0xE7E67206, 0x2093A67F, 0x7EBD92FC, 0x3FFCFC3F, 0x88EAF518,
    0xE7E6E278, 0x888C467F, 0x8D7FAC24, 0xBF61EBF0, 0x3A873F71, 0xEA3AB16A,
    0xA854F750, 0x8DDC7A9B, 0x71EE4AD5, 0xB8F43B77, 0x6DD8EE99, 0x8FCA7543,
    0x3E6E1CDD, 0xEDF9AEA8, 0x0B2C617E, 0x455ACE54, 0x87417A0F, 0x9AF72E59,
    0x2E4A8664, 0xB6013CF0, 0xF40E5850, 0xC0E5C962, 0x16E17B84, 0x2983982F,
    0xF71BAF2A, 0x4724ADB0, 0x41C9605D, 0xDA323B55, 0x8C3DC09E, 0x319D1C65,
    0x29EE991E, 0x2F013D07, 0xC1CC2607, 0x39780894, 0x9605D530, 0x987B513C,
    0x57179187, 0x84FFCFC3, 0xD1605018, 0xE7E3B3D7, 0xCBA15EFF, 0x9F98F9F9,
    0x1EC657FF, 0xB7B6D5F6, 0x55FA2B44, 0xE7E30F2D, 0xCC63A07F, 0x3F3435F2,
    0xA59D03FF, 0xCC7B9F3D, 0x6640FFCF, 0x86DEFF9E, 0xC37FFCFC, 0x3DCF9E52,
    0xDD7FE7E6, 0xE0F94C0A, 0x37FF3F31, 0xF4F94D31, 0x37FF3F31, 0xCF9E30F2,
    0xFFE7E63D, 0xD84AE9C6, 0xFE7E6DBF, 0xE52D29EF, 0xFE7E6DB7, 0xF2D925EF,
    0x31FBB6EB, 0x7BD4FC94, 0xFE7E2F31, 0x91722BEF, 0xEEC7B6FF, 0x7724BA19,
    0xFE7E4BF6, 0xEA13A3DF, 0xFE7E682F, 0xE794C0AF, 0xF9F98F73, 0xA2B47A5F,
    0xE7E63C1F, 0xBC84797F, 0x7E63C1F6, 0x29768FFE, 0x7E68DFE4, 0x6AE10FFE,
    0xF31E0FB1, 0x94293FF3, 0xCC89E7E2, 0xA49FF9F8, 0xF2A27CF1, 0xFF3F1D2B,
    0xD8B57207, 0x8C7BC427, 0x16EC805B, 0x26C3E9F4, 0x512D2935, 0xE6C68C8A,
    0x512D2934, 0xCFC68C8A, 0xBB029DFF, 0x8A6BF613, 0xBD89FF9F, 0xF4398400,
    0xF9F9082B, 0x140053BF, 0x24130981, 0x0A77FF3F, 0x54C228FC, 0x77FF3F33,
    0x9017F80A, 0xE73032BD, 0xD581EB7E, 0x9EE3CF35, 0xB9C3D072, 0xC7807ADF,
    0x836D4963, 0x607A1075, 0x05A4648A, 0x6ED5582A, 0xC99E5428, 0x59E452D5,
    0x60F02F45, 0x52A8D3BC, 0x2E4CF2A0, 0x3D7FFE7E, 0xD7A11111, 0xF3880F5E,
    0x5FFF9F8B, 0x84A2657B, 0xCFCC084C, 0xFBC5E0FF, 0x7188AFF5, 0xFF9F8C29,
    0xF97A23B9, 0x4C4835F2, 0xEBFF3F05, 0x09EBD116, 0x6137A136, 0x9DFFCFC0,
    0xF1371302, 0xFF3F21D4, 0x21000A77, 0xF805680E, 0x0053BFF9, 0x59E9984D,
    0xA77FF3F1, 0x4C245EE0, 0x704F235E, 0x3D562E67, 0x6C33D86F, 0xAABF1BE2,
    0x3619EC9E, 0x5DFF8DF1, 0xBFBE2ED2, 0x05D502C7, 0x207F7C5E, 0xCF3826FB,
    0x7B07F7C5, 0xE79CF8AD, 0x0F43FBE2, 0x8BCC663B, 0x680E3FEF, 0xDF173CE1,
    0xD79E0A3F, 0x7F7C5E05, 0x2ED62954, 0x7E7BE2F0, 0x94C9BD0E, 0x73E2B5C8,
    0xC4657F25, 0x50330E5B, 0x5455805D, 0x4EFFCF55, 0x0A642910, 0xB719B55C,
    0x04D5E207, 0x434465E8, 0xD23073D5, 0x097F4378, 0xD5541CF5, 0x396E1233,
    0x2918347C, 0x849BF664, 0x0A610E62, 0x78D0771E, 0x5BC8F035, 0x3578CF26,
    0xBE829839, 0xFD9839E9, 0x9BAA59D6, 0xBDB9398E, 0xD7B7A48E, 0xF95AF499,
    0xDA0577D9, 0xD7DD6B01, 0xF414E60E, 0x2445CF42, 0x2C45A1A2, 0x6611DDFE,
    0x75D156B9, 0x4777140E, 0x588B43F8, 0xFEF46BDC, 0x77A3CE40, 0x813BD1AF,
    0x2D6F479C, 0x0B7F52C3, 0x4A4929B8, 0x5BF67EAF, 0xA6E02DE7, 0x296196BE,
    0xD27D40F2, 0xFCCF072B, 0x850AFFFC, 0x7846B088, 0xA8751D46, 0x2C8ECB1B,
    0xE2750BF7, 0x71BF5630, 0xF4EA84BF, 0x9E6EA139, 0xFD58750A, 0x76FDFA7C,
    0xAEC63773, 0x7EE6BB70, 0x4756EBBA, 0xE99AEA1D, 0xAB43B716, 0xDD750A93,
    0x73EB6D72, 0x7568CDD0, 0x99AEA1D4, 0xC630EDFA, 0xE61C8EEE, 0x17EE37EB,
    0x43B6B91E, 0x1CD7541D, 0x2EDDB76A, 0x876DDB8A, 0xD750EEBA, 0x71FA1DAB,
    0x50DBF377, 0x4A7A98DD, 0x6BA8751D, 0x754F765B, 0x71EEA1D4, 0xAA18D637,
    0x5BD8C66B, 0x30F0C16C, 0x1C30E628, 0xE31B88E1, 0xC5CC80D5, 0x7DAE6872,
    0x0E7A140C, 0x81CB0B52, 0xBA5AC32A, 0x59C3F025, 0xD3ED127A, 0x375E0E7A,
    0xDA8B0F4D, 0xC09EDAC3, 0x0F6BEF70, 0xA29E982D, 0x8C1D4D62, 0xA5A0A8DA,
    0x46DF8DD6, 0xAE0C3CA8, 0xFF9F8D82, 0xB5F61517, 0x7FE7E432, 0xBFEDC026,
    0xBFF9F9B7, 0xEFFA91E2, 0x17FE7E6D, 0x177F0B55, 0xBD164B47, 0xF224495A,
    0x2BA73FF3, 0xF9897F61, 0xBC523FF9, 0xF3F312FE, 0xE794C9BF, 0xFCFCDB3F,
    0x27C98E0F, 0xFCFC8636, 0xFC492E0F, 0xCFCC88AF, 0x3CCDDCFF, 0xE7E6D9FF,
    0xAF23AA7F, 0x3F36F7FD, 0x53D02BFF, 0x7E644F3E, 0x3F5A57FE, 0xF9913CF9,
    0xFA59BFF9, 0xBA6D9FF3, 0xE9A6648B, 0xA5E9B363, 0x8CBB9342, 0x5FFE7E63,
    0x15FF8065, 0x7FF9F991, 0x9AF8B0DD, 0x97FF9F98, 0x3CFBB4D2, 0x7FF9F991,
    0x21FAF309, 0x1EFFE7E6, 0xAFCBDFCF, 0xF7FF3F14, 0x15FF815D, 0x7F24A791,
    0xE649BFD1, 0x23FFCFC5, 0x89967FCF, 0x6FFE7E51, 0x6F7F1931, 0x2CBFF3F3,
    0x9B7BFB0F, 0x5A25FF9F, 0xEBB7BFD1, 0xB1FC9409, 0xF3F2498E, 0xE72D3CBF,
    0xFCFCDB93, 0xFCF61E1F, 0xFF9F9B67, 0x7FE1CDA3, 0xFFCFCC88, 0x23FC8E31,
    0x27F446EE, 0x919D3A2D, 0x3CC62E5D, 0x9F8E44BB, 0xCF3C51FF, 0xF9F9B67F,
    0x7C7AA51F, 0x123B36FD, 0xC2EE41D1, 0xE3FF3F31, 0x527CA413, 0xE4A0664C,
    0x924C758F, 0x7949FF9F, 0x8C4CB3FE, 0xA86CA5CE, 0x7BC057AA, 0x6E5319B2,
    0xCFCA16C0, 0x45069CFF, 0x67120847, 0xE9CFFCFC, 0x28484BE1, 0xFE7E425F,
    0x97B8287F, 0xE7E79DEE, 0x7A9387FF, 0x5C27AF71, 0xC6329837, 0xC75AF1AB,
    0xF16C4DE5, 0x1CB92CC0, 0x8C935E4C, 0x0CD24D08, 0x450DE224, 0x2A0B9931,
    0xD77AE4CF, 0x6B6894C2, 0xF9F853BF, 0x7A2505FF, 0x08E2DAF1, 0x3FF9F8E9,
    0x42192361, 0xFF9F8C42, 0x105E88F1, 0x5D1E89E2, 0x63C9FF10, 0x827D78CA,
    0xC793FE20, 0x2FFAF194, 0x5A6B1CF9, 0x925BF58D, 0x7E26C33D, 0x64C1DC71,
    0x2F89B0CF, 0x3D930BD9, 0xA47E26C3, 0xAC392990, 0x994C1BB8, 0x2BFC0CC4,
    0x1A9466BF, 0x2B9F9295, 0x2F24BDF9, 0x5ECB3FBE, 0xDF178C50, 0x9D1C659F,
    0xDFEF8B94, 0xCF3C1C77, 0x8297F7C5, 0xF172D02D, 0x2510DF3D, 0x0DFE2E23,
    0xCF5CF7D6, 0xF5837F8B, 0xC5C67BA9, 0x1F9E5327, 0xF0BC4CEF, 0x3E5B0557,
    0xEE38B1B3, 0x8F9AFE60, 0x358A032A, 0x61C7E52D, 0x4F15AE46, 0x33D5516D,
    0x58FCC334, 0xC510725F, 0x14D23BB9, 0xAA8FECB3, 0xC8523F9E, 0x96E36E14,
    0x4375BEEC, 0xEF92DFAD, 0xC1987104, 0xACF1D079, 0x2919DD34, 0x950F2664,
    0x1D9EE687, 0x894B4BDB, 0x5321489A, 0xB8EB7179, 0x205AE77C, 0x26BEA86F,
    0xAED772A1, 0xEF69D426, 0xA9437692, 0x815CD6D4, 0xCAD7A4FE, 0xF95AF487,
    0xA4D02B99, 0x5DF64AD7, 0x56BD2681, 0xA60577E6, 0xED3AD603, 0x8B414E60,
    0x611DDC58, 0xCFE39198, 0x4AE3AC95, 0x91987DD6, 0x4308EEE3, 0x6BDC588B,
    0x1E7206F4, 0xF3816BBD, 0x95DAECC7, 0x2DA96196, 0x2924A6E0, 0xEB7ECABD,
    0xABB5D98C, 0xB79C0B5F, 0x32D29B80, 0x281E452C, 0xCF072BD2, 0x184FFCFC,
    0xEBE5F95F, 0xE876C05F, 0xE2C05750, 0xD47EE6E6, 0x4DDD62CA, 0x3456BB64,
    0x6B1BB947, 0xE6EC6240, 0xD4C7B17E, 0xD52DB76F, 0xD7C7B18D, 0xDB8FDC6F,
    0x7371A9E2, 0x6F8F6318, 0x41D58CDC, 0x3750EC62, 0x630A6EA1, 0x754343AB,
    0x5CF1EFD5, 0x5EAA9BA8, 0x43A8EA98, 0xEA9EC61D, 0x6FD7EE37, 0x3750EDEA,
    0xEA86EA9E, 0xF734DD42, 0xDCD585A3, 0x71FA1DAF, 0x2C6EE3F7, 0xBF733374,
    0xB35DBF71, 0x9D42E7BB, 0xAC5B6EDF, 0x55D43A8E, 0x986B19B8, 0x3A871F81,
    0x3A9B2D8C, 0xA3AB75D4, 0xDFA7750E, 0xDD42E6BD, 0x1EEBA854, 0x05750EC7,
    0x8DD56E2C, 0xF75D43B1, 0xC66BA85C, 0x2A0F62D8, 0xD156AD29, 0x61D502C7,
    0x1692DC42, 0x719630F4, 0x6C982C74, 0x40D5E343, 0x189A5275, 0xE47841E2,
    0xD5E30BAD, 0x9D6F23C0, 0x393578DE, 0xB4AB81F0, 0x12B90764, 0x7B5117EC,
    0xFE8F1399, 0x6E5279A2, 0xC6281DAD, 0xE761B9AB, 0xE2EB56B1, 0x5BA79D86,
    0xE60DE25A, 0x6073475A, 0xEA5E82AE, 0xBE9E4B02, 0x39877723, 0x56F93298,
    0x93A85AEE, 0x852324D4, 0x5C8D5E34, 0xF279D4B1, 0x348BC2A4, 0x175E612B,
    0xF03C4E1E, 0xD0785602, 0x0E2C02C0, 0x95423347, 0xB5404F6F, 0xCAA02E32,
    0x5312D408, 0xB1A16C02, 0x284D6685, 0xA876F5AF, 0x0C358A1B, 0xB73FF3F2,
    0xDC4EBE4A, 0x59A05AA4, 0x5193D22E, 0xE687A18C, 0x464D8784, 0x9F872AE8,
    0xF9EC3DFF, 0x7FE7E627, 0x2B5F5E61, 0xA3BFF3F3, 0xFCC4FF3D, 0xF1931FFC,
    0xFF3F32B5, 0x973F8583, 0xD082B001, 0xF31C2EE4, 0xDD903FF3, 0xE7E6593F,
    0x7D57D07F, 0x7FE7E62A, 0x4FF3C8F6, 0x6CFFCFCC, 0xF98A9FC6, 0xF1939FF9,
    0xF9F9977F, 0x5FC7939F, 0x9FF9F989, 0x8A9F9613, 0x70B77B95, 0x232B40E9,
    0x8B5CBA72, 0xBFF3F179, 0x89FE794A, 0x155FF9F9, 0xFCC4FF58, 0xFC574FFC,
    0xFCFC865C, 0xFFD816DF, 0x81726E5D, 0x6B0F09E7, 0x89E78172, 0xFF9F8C3D,
    0x9FE796D7, 0x17FF9F98, 0xE62A7CE6, 0xEB9EFFE7, 0x765E27F9, 0xF67720CB,
    0x97FE7E4B, 0x63627F0B, 0x4097FE7E, 0xCFCC4E7F, 0xFCF662FF, 0xBFF3F313,
    0x313FC85C, 0x7B0BFF3F, 0xE031ABFE, 0x8A917FE7, 0xFCFCC54F, 0x2E7F0B1F,
    0x8FFE7E03, 0xC6C4FC65, 0x4D1FFCFC, 0xF9947ED7, 0xF2FA3FF9, 0xFE7E6257,
    0x297F098F, 0xD07FF3F3, 0xFCC54FC9, 0xFC7D1FFC, 0x3E4A38A9, 0x14D0F169,
    0xD90FFE7E, 0x3F3153FD, 0xE7AEA3FF, 0xFE7E6257, 0x77FF1947, 0x0E891D99,
    0xF31B1772, 0x16693FF3, 0xE7E6275F, 0xBEC2D27F, 0xA0664C4E, 0x1CC2C7E4,
    0xA927FE7E, 0xF99513E7, 0x295C9FF9, 0xCFCCA89F, 0x3EE4BDFF, 0x2B975851,
    0x8969FCE7, 0xEDEABD03, 0x40E5AEFF, 0xF7AAA18B, 0x7FE7E4C1, 0xF5CAF73D,
    0xAA6E17FA, 0x68C39AE7, 0x73D534F7, 0x9ED183CD, 0x392B5BD3, 0x33ABD2BD,
    0xCF13FF3F, 0x2BF08057, 0xFFCFC9C2, 0x7E42029D, 0xFF9F8E03, 0x7ADA053B,
    0xFE7E29C9, 0xEE340A2F, 0xF3F16E35, 0xB900A77F, 0xCFC5B8D7, 0x97829DFF,
    0x9AC0658C, 0xAF10D940, 0xBB8B6966, 0xD2F3C0F1, 0x6494B5DC, 0x50172550,
    0x3A84B2D5, 0x3894C82D, 0x50F652A8, 0xED7FFE7E, 0x5AAF1995, 0x6BFFF3F0,
    0x18A91CAF, 0xD7FFE7E0, 0xF57E579E, 0xE7E6E27A, 0x109B0A7F, 0xFC715EE7,
    0x3029DFFC, 0x3F180978, 0x900A77FF, 0x9F8C5338, 0x00237BFF, 0xC80BC5FB,
    0x0143FFCF, 0xE33D6624, 0x20A1FFE7, 0xF32BE509, 0x6C113FF3, 0x0C3AD026,
    0x7FF73FE2, 0x0827E067, 0xD3FC3FE2, 0x88209F81, 0x9DFF1DFF, 0x88209F81,
    0x9DFF1DFF, 0x3025FF81, 0xA4F2DA6C, 0x21B20D35, 0xC247F84C, 0xDD24C92D,
    0x84A60555, 0xFB0F03F1, 0xEE535DD0, 0x7EAECC5F, 0x1FDF1769, 0xE534A2AC,
    0x6343FBE2, 0xF7C5CA4A, 0xBC52075F, 0xE6BFBE2E, 0xF8B94C1B, 0x38319AFE,
    0x0FF7C5CF, 0x2F072CDC, 0xA1A63FBE, 0x9EF8B94A, 0xBC0BC16F, 0x8F0530F8,
    0xFF1764BB, 0x4B43EB06, 0xE5327C5C, 0xBADE49F9, 0xF3CA64F8, 0xF8BB1569,
    0xE7F3CA64, 0x8E6E0660, 0x787E2FFB, 0xCAA1A625, 0x6B514FF8, 0xA50BAC1B,
    0xF58FF149, 0x02F7F25B, 0x9156F2B7, 0xA4AD6B09, 0x86642919, 0xBBFA3A05,
    0x92805DA4, 0x2699AA1B, 0x4D683527, 0xB2A83CD3, 0x3FB30E26, 0xAB034AA1,
    0xA1E50B60, 0xA1BB1D74, 0xE39837DD, 0x0C59A981, 0xAA1BC6D5, 0xB1D74C59,
    0xA6264A1B, 0xF924F8DC, 0xC90DFFF9, 0xF192F978, 0xA482FFF3, 0xF8C97F10,
    0xA2769FF9, 0x1D5EC457, 0x7B17FF3F, 0x80E22265, 0x7C37FF9F, 0x5D85E7E5,
    0x56BD2681, 0x67D7A43E, 0xD26815DF, 0x0577E56B, 0xC95AF49A, 0xBD26815C,
    0x302BA656, 0xC3C232BD, 0x72330CE4, 0xE3AC95CC, 0x8CC1D64A, 0x6702D71C,
    0x615DAECC, 0x16AAED76, 0x3FF3F338, 0x578BF749, 0xFF3F212F, 0xE227AF73,
    0x3F371189, 0x7C0BEFFF, 0xF3F152F9, 0x5FB26F7F, 0xFE7E3B10, 0xBCA16D7F,
    0xE7E365FE, 0x85FD97FF, 0x3F258809, 0x497F13FF, 0x295FC46A, 0x717FFE7E,
    0xE1109848, 0x04FFCFC6, 0x1308288B, 0x27FE7E30, 0x20BDA826, 0x9FF9F904,
    0xBD5E2E98, 0xF9F8C620, 0x9E91153F, 0x9F87EBD8, 0x511609FF, 0xFC3E22BC,
    0x44444FFC, 0x9D040484, 0x88B5FF9F, 0xE2F89C4D, 0x20C1FFE7, 0xF94C2022,
    0x5F0E7FF9, 0xF8D624BE, 0xF7EF7FF9, 0xF99AF626, 0xF80F5FF9, 0x31892F57,
    0x45CFFE7E, 0x7AF04444, 0x2FFFCFC5, 0xFF5E090E, 0xFFE7E31A, 0x6BF090B6,
    0xFF3F1984, 0x22241313, 0xF3F1A2FE, 0x0CFC237F, 0xCFC96221, 0x404258FF,
    0xA194A09C, 0x746A293A, 0x36D56BA8, 0xCDC6BB54, 0x6DFA9B18, 0xE3F02634,
    0xB18CA750, 0x83AA0F9B, 0x836D34EA, 0xA8EAD8C4, 0xDBF35D43, 0x9D42FDCD,
    0x50B9A92A, 0x2D34AD57, 0x81C940A7, 0xA172D8C4, 0xBADB8E4E, 0xE7EE37EB,
    0x173775B7, 0x3DFAA6EA, 0xEA868756, 0xB1CDCDC6, 0x316F51FB, 0xB7631BBA,
    0xF4EA172D, 0x750BEDBB, 0xD750E158, 0xFB9BBF4F, 0x70EDBBB9, 0xA2BF71BF,
    0x6DDB8E7B, 0xBB8F7543, 0xBB7EF4A7, 0x439A7226, 0xB77ADBDD, 0xA1687B03,
    0x8DFB999B, 0x561F31FB, 0x8FC39B85, 0xAE9D43BB, 0x3E636FC6, 0xA8A6EA15,
    0x329FAAE5, 0xE13DD754, 0xC637EBE6, 0x5DCF371A, 0xAEA1DBF3, 0x3B6454D7,
    0xA9EEEB6E, 0x6FDCC750, 0x697BEFDC, 0x374B29A1, 0x95309CBC, 0x96E17B83,
    0xE8394F74, 0x2A05A0B1, 0x0FA2AD67, 0x54F44654, 0xAD12C351, 0x2C3578C4,
    0x2551CF57, 0x3436C981, 0x27178D5E, 0x2351DD99, 0xAB5ECD0F, 0x2A2F41E8,
    0x8ED6261E, 0x18A60DC5, 0xDBA991E2, 0xE596A1EC, 0xBFFCFC61, 0xF2D13E26,
    0xBF45F7CA, 0x31FA52B5, 0xC1E0F2E3, 0x2835A492, 0xF579A5BE, 0x8686E4D0,
    0x8A8B0AA6, 0xCB68F535, 0xDDB96893, 0x01CAAA03, 0xAA0267B2, 0x72CCB56A,
    0x4CB67AF0, 0xB59286ED, 0xC3DB4E5A, 0xD4CD4812, 0x27187B13, 0xA05AE4C9,
    0x49115919, 0x3F0E687A, 0xEBFC2FFF, 0xBFF9F90C, 0xCCB8FBAF, 0xF0BDFFCF,
    0x8B4832E3, 0x8ED56917, 0xB141FF9F, 0xAC0C72FF, 0x385DC9A0, 0x96B656E6,
    0xA984AE9C, 0xC5033D5A, 0x0D0D5AC3, 0x88A686F2, 0x26296B55, 0x87A57B75,
    0x5E6BBC9A, 0xF72A56B7, 0x8CBDD29E, 0xDFAD2EE4, 0x79FC9324, 0xD84A652D,
    0xC5E616F7, 0x3A39924C, 0x3094F50B, 0xAC3CBFC9, 0x163F2502, 0xFFF3F0E6,
    0x63F5F293, 0xC097FE7E, 0xCFCC6AFF, 0xEFF2C2FF, 0x9F92C0E5, 0x515E648B,
    0xF2FF24C3, 0x65932430, 0x3F1878A0, 0x3FF493FF, 0x656A0067, 0x612FBF2C,
    0xEB6A6FBC, 0x9A5A5E02, 0xD15CD0F2, 0x18F5CAA0, 0x55D344DC, 0xB5F966A8,
    0xF531C4DC, 0x914DA258, 0xA24E0715, 0x9AECCB91, 0xB93D66C9, 0xC0AC8ECC,
    0x0FFCFC6A, 0xF97EF2F5, 0x2B5BD01A, 0xABD2BD39, 0xDD7FE7E4, 0x8404DFEB,
    0xFE7E5388, 0xE8812F57, 0xFE7E4108, 0x474509A7, 0x7FF3F208, 0x23A20210,
    0xFFF9F904, 0x3A203105, 0xFF9F9042, 0xBFC8053B, 0xFFFCFC04, 0x4BD72BDA,
    0x7FF3F302, 0x4235FE3F, 0xFF3F1C04, 0xBD5FE3F7, 0xE7E392F6, 0x78828D7F,
    0xFF3F14C5, 0x621E4D37, 0xFF3F1984, 0x04DE4D37, 0xFF3F19C4, 0x5FC4F0CF,
    0xB086CD7B, 0x0307A0F6, 0x03F2E058, 0xC32C0C2D, 0x3F31C9C6, 0x606C1560,
    0x3900A607, 0x26B03346, 0xD37917A1, 0x1AC0DE56, 0x092C4314, 0xF70EC928,
    0xBD0E4D5C, 0x9A1B94C9, 0x5C9A2983, 0x6C557064, 0xED25DF12, 0x9EC0CC86,
    0xE452D183, 0x62B98551, 0xAA1283B9, 0x9617AE6E, 0x8CAE07C0, 0x543C7E5A,
    0xF2DA6B6A, 0x1ABC6813, 0x886D8A4D, 0x149A1357, 0x32388C95, 0x40EED925,
    0x51CB2D72, 0x3D554685, 0x16DD2551, 0xADF79E76, 0xD6EAEE75, 0x027FE7E2,
    0x1202F002, 0x4FFCFC67, 0x24CBDB00, 0x4FFCFC00, 0x7EF44440, 0xFCFCDC49,
    0xBE041C4F, 0xF9F9D57A, 0x178B389F, 0x7E53882F, 0x12F17FFE, 0xCC8464BE,
    0x88C4FFCF, 0xBC5FBD11, 0xFFFCFCA4, 0xAFF44E7A, 0xFCFCA4BD, 0xBE09A84F,
    0xFE7E657A, 0x04BDB087, 0xFF3F01C4, 0x9EBCBD43, 0xCFC00BD0, 0x50C08CFF,
    0xF3F01C47, 0xF3E4727F, 0x9F8A6BDA, 0x249033FF, 0xF3F28C4C, 0xC5F1073F,
    0x9F8D424B, 0x111D39FF, 0xCCAF97E1, 0x7ADCFFCF, 0x90462713, 0x5F4FFCFC,
    0xD78BFCF2, 0xD3FF3F20, 0x9048DC46, 0x78AFFCFC, 0x45E08D7C, 0x75FFF3F2,
    0x7C404621, 0x475FF9F8, 0x846BC10A, 0x37FF3F3A, 0x7826136D, 0xFFCFC73D,
    0x2F3D10F3, 0xFE7E6F5F, 0x221200D7, 0xF3F2184C, 0xDD21113F, 0x7E405E03,
    0x444517FE, 0xE53D7A12, 0x72297FE7, 0xE01AF6BF, 0x20C8FFE7, 0xE505EC46,
    0xFD7C7FE7, 0xF5EC402B, 0x727FE7E6, 0x7AF6BD13, 0xFFCFC002, 0x2F1217EF,
    0xFE7E2D5E, 0xB11115E7, 0x9F800497, 0x109CF5FF, 0x8805FEBC, 0xA96A2677,
    0x1E502969, 0x1FAA6B0D, 0x89B0CF64, 0xF651560F, 0x9CF89B0C, 0xD867B264,
    0x93D557C4, 0x7E26C33D, 0x0CF62DF7, 0xC1DAF89B, 0x89B0CF60, 0xEC76BEFF,
    0xDFF13619, 0x62240D25, 0x61E547CA, 0xFC983195, 0xFCF75205, 0xDCA64291,
    0x81F9547C, 0x7F7C5D87, 0x2E4B1056, 0x83DABFBE, 0xBFDF1729, 0x178551CD,
    0xFDF97FDF, 0x7F7C5CA4, 0xB949F96D, 0x3C51FEF8, 0xFEF8B9E7, 0x5E5D5098,
    0xC437CF7C, 0x41BF8B92, 0x8BC4CACA, 0x1F3CA64F, 0xFB0F2D98, 0x65787E2F,
    0xDC3580BF, 0x6B91648E, 0xFE4AE7C5, 0x38124EE6, 0x3EF69AD2, 0xDC6D4F54,
    0x551CDB20, 0x760DD5A8, 0x38AC1CD3, 0xF2B0684C, 0xD9D962F7, 0x6D4F5421,
    0xC8522D39, 0x96D7BB54, 0x5871CDC0, 0x1EF56692, 0x963C8A4D, 0x0F350B42,
    0xCFE9ACAA, 0xEDF24EE7, 0xC1ED40B5, 0x2D7B73E7, 0x8D02D176, 0x1413E357,
    0xE041DC73, 0x86E6AAB5, 0x252E1AC2, 0x89AC2607, 0xB083D0BD, 0x1BC2F626,
    0x314B25CA, 0x322D0D5E, 0xEA0E7A65, 0x5D78CB6A, 0xB5283F60, 0x931C2A8E,
    0x23578D47, 0x578D2509, 0x50258523, 0xFF3F21CC, 0xC4462313, 0xFCFC6313,
    0x84CAF57F, 0x8BFF9F8F, 0x9AA2F2BD, 0x0E7B9D65, 0xE77FF3F2, 0xF3A08891,
    0x44ED3FF3, 0xE7E6626F, 0xCAF73D7F, 0xFFCFCF24, 0x7F32BDBD, 0xE1BFFCFC,
    0x1C09232B, 0x4D1A0EB7, 0x0AE67D7A, 0xBEC5E934, 0xD7A4D02B, 0xA1A0574A,
    0x11C056BB, 0x90FFCFC5, 0xE8BC1078, 0x9AFFFCFC, 0xCD8BCA46, 0x91C9FFCF,
    0xF9F82843, 0x222101BF, 0xBFFCFC5C, 0x29C4F42F, 0x1EBFFF3F, 0xF9989BE0,
    0x25F5FFF9, 0xE7E14BFC, 0x7AF8517F, 0x7FE7E482, 0xB092F851, 0x99FF9F9E,
    0x8D179F0E, 0xC2DBFF9F, 0xCFCF1887, 0x4F216DFF, 0xDFFCFCC8, 0x19846A16,
    0x3CCBFF3F, 0x3B5409C4, 0xA8767B74, 0xD43A8EAD, 0x7541F16D, 0xD71EFD53,
    0xAB0E72DB, 0xEAB3371B, 0x50750B96, 0xE54A94DD, 0xB7EA3F71, 0x81FB8DFB,
    0x4B531A8A, 0xAA7EEE3E, 0xE03AA0F9, 0xF37630A7, 0x36FC7AB1, 0xAA1BB95A,
    0x4DD43B6B, 0x5FBBF4F9, 0x6FC6EB18, 0x66A93A87, 0xEA177EEA, 0x2B51DB22,
    0x53D4C78B, 0x7EE6E2CA, 0xA14F16DC, 0xDDFAC59B, 0xD50D0EAC, 0xB6DC3A15,
    0x50EDFA98, 0x77630BD7, 0x1537541F, 0x9279AED9, 0xBBAEDC3A, 0xEDDEB16D,
    0xA1FB8DFA, 0xFDD4C327, 0x4F73C594, 0xFB7EA2B1, 0x750EC631, 0x6AEA6352,
    0xA85D4F6E, 0xD76EEA9B, 0x71BF76FC, 0x5B8F7EBF, 0xDFAAE94D, 0x5DAF9FB8,
    0xEEBF71BF, 0xA7BB8F76, 0x36D75436, 0xB1853754, 0x7B8B6FD1, 0xA3F56161,
    0x73DB763B, 0xE872CEA1, 0x760D8C6E, 0x256AC3A8, 0xEADBF7A5, 0xF55D43A8,
    0xA15376AB, 0xBADB9BAE, 0xB8F7EA9B, 0xB294DDBB, 0x54DFB9B8, 0xE2CDDBF3,
    0x43BB8FD8, 0xDD8C2F5D, 0xA93CDD12, 0x631BDBF7, 0xDC7BF54F, 0x1D43B18D,
    0x1D8C66CD, 0x6D5B9AEA, 0xDD750EFD, 0xCD729EE3, 0x9BF7376F, 0xDDDDDC7A,
    0xDBF514B7, 0xCDC7BB8F, 0xBD482CAD, 0x8DE3CA56, 0x4C8F0BD5, 0x5B4A8270,
    0x8EBD0986, 0xB433992B, 0x6B124096, 0xC6AB05A0, 0xC2E55082, 0x6F0EE51C,
    0x0F18CDE0, 0xF1095AD6, 0x3969606A, 0x1D2734CA, 0x3A0E4E68, 0x24C39917,
    0xA40ECAD7, 0x393CA58E, 0xD156BD58, 0xE0757927, 0xDAB86AF0, 0xA3578CC3,
    0x9C7156BC, 0x3DDDAA7B, 0xABA19787, 0xD175E32D, 0x05D93B75, 0x12AD1954,
    0xB39328E4, 0x4EA1D03C, 0x68785572, 0xF9B58CAE, 0xD0B6A0EC, 0x032A81EE,
    0x59E5BA53, 0xAF604B6A, 0x56B983C1, 0x60188769, 0xF2DA550B, 0xB46AF1A0,
    0xA8EB5C12, 0xD02E3251, 0x837C3303, 0x9845F6AB, 0x75158CF4, 0x9ECAE224,
    0x8052A183, 0xCC0CB554, 0x8696E94B, 0x2AD4D509, 0x24AE60FA, 0xCF66AE2F,
    0xF8712991, 0x11E0F0EC, 0x25320CED, 0x90656B7C, 0x92961ECB, 0x455AAFA3,
    0xF3F17A0F, 0x527022BF, 0x65AB3DC5, 0xC80B0380, 0xF3187BEE, 0xAB974D0A,
    0xBC06BC99, 0x8C3C5032, 0xF5B9FF9F, 0xA1EA67F5, 0x959AEF26, 0x32E14F7B,
    0xED6A6DD0, 0xCBA5686A, 0x987973D5, 0x81504D32, 0xD0E2CD66, 0xDE6E6A95,
    0xAA6F2D58, 0x2950B149, 0x19BC8D66, 0x4CC66295, 0xCC771992, 0x4AE9C1DD,
    0x33B8CE58, 0xE363C8AF, 0x7A8AD11E, 0x79FC948A, 0x2C3C252D, 0x8B095D39,
    0x5D38B5B9, 0x20EEAB09, 0x4A38E177, 0xAF30B7BE, 0xB84E56BD, 0x72B5ECA5,
    0x6850F482, 0xAD763305, 0x39986F22, 0xF493095D, 0x026340CA, 0x25A7F383,
    0xEF55E706, 0x65C1BD4B, 0xECDEA1E8, 0x452E0569, 0x356CC0FF, 0xCB5DEAD1,
    0x5AB4ABDD, 0x52815CD1, 0x9A6AF7EF, 0xBD550526, 0x2FBC660F, 0x0DFD3141,
    0xE880A65A, 0x60653693, 0xF69A3229, 0x44968F18, 0x8E652A83, 0x52A838C4,
    0xA78C48A6, 0x5459149D, 0x038122CC, 0x4915AB4B, 0x5AB4B03A, 0x10FFFCFC,
    0xF1137132, 0x44773FF3, 0xF3F05AF1, 0x7A44773F, 0xFFCFC142, 0x01140A6F,
    0x427FE7E4, 0x90DC4CAF, 0x14DFFF9F, 0x9F9BD7AC, 0x7C388BFF, 0x2CD650BF,
    0x1C3073D8, 0x198CF051, 0x8112D1C0, 0x69A302D7, 0x500E0396, 0xA686E4A9,
    0x5E876B40, 0xD9250935, 0xB830B421, 0x2D726E2F, 0x2F2296E7, 0x147926AE,
    0x2A986687, 0x4B4150BD, 0x6E05EF5E, 0xDB0DCE5D, 0xDD197281, 0x073D9A63,
    0x706C61FB, 0x578C6EA1, 0x93963EF3, 0x796B556F, 0xEC8F24D8, 0x3CD62124,
    0xA58E25B5, 0xF1098526, 0x2CD9346A, 0x324BCF07, 0x183C5BD0, 0x6E393950,
    0x38FBC4A5, 0xA0A64584, 0x24B0BDD1, 0x35725730, 0xA05E4D07, 0xB241B935,
    0x69B78B56, 0x13FF3F0E, 0xF842257F, 0xE27FE7E1, 0x6B5FBF1A, 0x82FFFCFC,
    0x01011118, 0x17FFE7E4, 0x7E75C814, 0xFA8627FE, 0xF3F28C4E, 0x1CAF6BFF,
    0xFFCFCA6F, 0x7A201884, 0x27FE7E69, 0xE5EC4894, 0xF87FE7E6, 0xCA610812,
    0xBE90FFCF, 0xF9F8ED00, 0x5E25EA1F, 0x43FF3F21, 0x8C97ECBD, 0x23B9FF9F,
    0xC00BFD7A, 0xDB4DFFCF, 0xF9F8FC48, 0x5E788B5F, 0xDFFE7E6E, 0x8F17B5B3,
    0x304FDBD7, 0xCDAAE1A3, 0x3841A938, 0x7D504A7F, 0x0D6F9A82, 0x8904AC0F,
    0x9E2831BE, 0xFE26C33D, 0x4FD8013B, 0xC191DAA8, 0xC3F5F99E, 0x0F92B85B,
    0x4A853112, 0x2EA8F8B5, 0xFCF00154, 0xEF8BCC38, 0x2E73254F, 0xEE5AFFBE,
    0xB3FEF8BE, 0xF302F225, 0x36B66686, 0xAF438EF5, 0xF5E012B5, 0x3CAFD449,
    0x672343DC, 0x1E80CB5D, 0x547CD4F6, 0x2409DFF9, 0x5603FACD, 0xADAEB8D1,
    0xBBD65BFC, 0xF2A3F224, 0x8A099270, 0x8AB415FF, 0x4176B4AE, 0x584AE8AB,
    0x8A87DF2C, 0xCA95D156, 0x9ADFC5B1, 0x86E9F2D6, 0x05E126EA, 0x0DD24E2C,
    0x93495AD6, 0x89F730F3, 0x4D853214, 0xF69BB45C, 0xBD46CCD0, 0xF8933FCC,
    0xD0B74939, 0xA25F06EA, 0x07DA20BA, 0x21983C5B, 0x5541F669, 0x6F1BE20B,
    0x24865E1D, 0x3D88493B, 0xA24C8523, 0xA5A596ED, 0xF661CF78, 0xBE6353E7,
    0x3B87F4FD, 0x22D7B7C9, 0x5B1B8B4F, 0x5B0D02D3, 0x3E898668, 0x1367CF6E,
    0x3C60294E, 0x526294E8, 0x5EC1DD3D, 0x3BEE981E, 0xF660E7B2, 0x1F039A14,
    0xBEC13D55, 0xAE58BD85, 0x5E034375, 0xB4605E0E, 0x43791D87, 0xA60772A1,
    0x0FFCFC72, 0x7E1B488F, 0x6579C7FE, 0x0B03AABA, 0xCC5E933B, 0x39536815,
    0x7205839A, 0x82C1CC92, 0x52DE8F46, 0xD4DC549C, 0x2D0FF2E4, 0x84AD67F5,
    0x3364D4E5, 0x8DD750AD, 0xEBA876D5, 0x374DDC7E, 0x7BB8F754, 0xF9F8EA1C,
    0xF24685FF, 0x04FFCFC1, 0xCFC5DF10, 0x3890A2FF, 0xEA13750B, 0x85C0B0A4,
    0xA7AC6EBA, 0x735D4394, 0x6B9E56BF, 0x743B7687, 0x42A7B92F, 0x54E5B3DD,
    0xA194AE8D, 0x879529BA, 0xC7A63C7E, 0xA87031ED, 0xEB631BEB, 0x1C58F6FD,
    0x5D42A6EA, 0xA3876E2F, 0xF16F5258, 0x1BAEA863, 0x2B7776DD, 0xB18CD39A,
    0xA1A3771F, 0xD9EF8B3A, 0x3A872B6D, 0x0F037E9F, 0x7EEFD3CD, 0x0B9BB77A,
    0x7EFD3E75, 0xE5B18DDC, 0x18DDC39A, 0xEA1D19BB, 0xEC0EA1C6, 0x5D43B7E6,
    0xC63439AF, 0x54D4F76E, 0xD42E78A4, 0xF9AEAC39, 0x903A876D, 0x54955B18,
    0xEDEEF8F3, 0xDDBF7A7E, 0x8C4817AE, 0xF5D42ADD, 0xBAC2EFD3, 0x72DB4D49,
    0xD8C4836D, 0xC6DCD961, 0xBBAEA1D8, 0xEBA85DBB, 0xA876FCD5, 0x0E6ECF13,
    0xAA1B7275, 0xCD750CC3, 0xADDD58D4, 0xB7630FBA, 0x746F46A3, 0xBB9F1BA8,
    0x9AEDC3A9, 0x750B9EDF, 0xEDEEA173, 0x6A6EA176, 0xBADB8722, 0xF252750B,
    0xBB70EA6C, 0x198BD750, 0x8549D433, 0x543630B1, 0xC4EAC5B7, 0xD0FDDFA7,
    0xBB18DDCD, 0xC2F7631B, 0xC3A8EA82, 0x3189D4ED, 0xA85CF376, 0x85CF0AC3,
    0x7B71653A, 0x59063D0A, 0x6EF5BB8F, 0x7E8775B7, 0x3BB8FC5B, 0x31BB8DD4,
    0xDFB9B876, 0x3E45DFB8, 0xAA0F9AD5, 0x1752750B, 0x3F015AEA, 0xA4BD750E,
    0x5CF37630, 0x8629EBA8, 0xD556DAEA, 0xD3ECB376, 0x8C6EEDFB, 0x2F76FCDD,
    0xDBBF4EA8, 0xB15EBA85, 0x866346DF, 0x751631BA, 0xD42EA1DB, 0x9B8B0375,
    0xB8B29D43, 0xE98B6319, 0x075EBA85, 0xF77E9DD5, 0x561DBBD2, 0xA7543773,
    0xEBA867AE, 0xEA1C7E56, 0x8716DBBA, 0x66E876BA, 0x774750E5, 0xD7EE6BA8,
    0x587CCD0E, 0xAEA1CD58, 0x7775B71D, 0xDFA7C52C, 0x9F630AFD, 0x4F0BF77E,
    0xB7BA8735, 0xDD42EDC5, 0x18DDCCDB, 0x4BDC581B, 0x2EA86E8E, 0xC2F775D4,
    0xEC633742, 0x4EFDCD76, 0x0AB5FBBF, 0xFB8FD475, 0x52750E3D, 0xE6BA854F,
    0x9D42E7B7, 0x73743EF5, 0xEE56EBA8, 0xA7D8C6EE, 0xCF6D53DF, 0xA93DBF35,
    0xB631BA6A, 0x8DFAEDDE, 0xF77E9DFB, 0xEA86EB92, 0x335D42E6, 0x05A63C3A,
    0x50BA85D5, 0xA8B9F6D7, 0xAB775D43, 0xDD1EC1B6, 0x86873DB5, 0x870EFAEA,
    0x0EA2A9BA, 0x750E2DBF, 0xD1B7EA63, 0xDBF35D50, 0x1FBB6EDC, 0x58F6E6C6,
    0x8E59D439, 0xE56DFA99, 0xAB0BD750, 0x30D61FB9, 0x7AEA1DB7, 0xB13A8561,
    0xEA3AB772, 0x17393750, 0x2EDF9AEA, 0x6FDEB1E0, 0xBA313A87, 0x6EE66DB9,
    0xEE6E3D8C, 0x27D1D507, 0x8DD8286B, 0xC743593E, 0x85303DDD, 0x39267BB9,
    0x280B34F1, 0x82DDDC49, 0x1C530730, 0x1FD53528, 0x3AF140EF, 0x5EBC2F03,
    0x7302C092, 0x37A418D5, 0x5200C16F, 0x4081D066, 0x656B9F36, 0xC7207740,
    0xB0554268, 0xF5613196, 0x81F0E7BE, 0xD55201E2, 0x322C05D8, 0xC20749E5,
    0xE45E6072, 0x5449AB00, 0xC3E8AB53, 0x9A607A59, 0xB98CB771, 0xBE095CCE,
    0xE271504B, 0x4E48BE81, 0x82DB8D3C, 0xDC3996DC, 0x91733492, 0xAC5DB037,
    0x747BAE2C, 0x512971C9, 0xE1D94BA3, 0xEF975D95, 0x66C1650B, 0xD2DC66B9,
    0xB0A64C33, 0x519337EC, 0x2EB7C9E8, 0x7C99F225, 0xD60FE4F7, 0x6B343BE4,
    0x0653B329, 0x92D9D0A4, 0xCD50A41D, 0x8C94052C, 0x73196EA6, 0x6550523D,
    0xD0784A60, 0x6A3EB650, 0x60677AA3, 0x0A4065A0, 0x54D82C0D, 0x11B81EAD,
    0x3C5105A9, 0x0EE095A1, 0xC96E17B8, 0x4B02EA1D, 0x7206779E, 0x494F395E,
    0x5C92750B, 0xC0E096AD, 0xF77E79D2, 0xD12BA393, 0xD7587972, 0x9CAF30D5,
    0x78BEFF5E, 0xB954681C, 0xFFF3F256, 0xBD9C04FA, 0xA9BCAD02, 0xE99A5597,
    0x763987B6, 0xFFE7E2AD, 0xBD9C04F8, 0x1AF324D9, 0x6B24C0EF, 0x5140EF2D,
    0x2D781D79, 0x5E01CD0F, 0x184AE9C1, 0xC934A5D0, 0x7BB240EB, 0xFF3F0A68,
    0x1A8C4F83, 0x95D38318, 0x9A1E2630, 0xA68F2BCC, 0x2DC61EC4, 0xD0A687A3,
    0x79A32C5B, 0x687A3151, 0xA87B134E, 0x69BCA96A, 0x4AA61EC6, 0xA97986E6,
    0x340CAD67, 0x0F2CF553, 0x7FE7E44B, 0x6E725FF5, 0x0A403435, 0x064DE46D,
    0x61E46AF3, 0xA46B1E46, 0xA87343C7, 0xE385DC8F, 0x343CD795, 0xA709E565,
    0xD6EB612B, 0x75B0F0CA, 0x632632C3, 0x2B44E495, 0x61632DDA, 0x0C99E35E,
    0xF6129B34, 0x1299A939, 0x4D798BF6, 0xB0BC9309, 0x1E5E612A, 0xF28A6456,
    0xC24AD65A, 0x92B45343, 0xC467B2A0, 0x99A065AD, 0x0A419878, 0x729A1B95,
    0x8686E52D, 0x8FB84A5B, 0x4584A687, 0xA342500B, 0x9CAF3286, 0x20961ED0,
    0xF49A0685, 0xBCC094D0, 0xC094BA69, 0xC2574E12, 0x59ED69E2, 0x72EA0E64,
    0x50C3D8B1, 0xEBCA986A, 0xA84B5264, 0x4903323C, 0x24C87AD3, 0xE19A0573,
    0x69F02796, 0xE054B40E, 0x3D79C0BB, 0xC3C0D581, 0xEA1E8568, 0x56B4DAD9,
    0x055AB736, 0x02B49F44, 0x573656A5, 0x12FBD4A0, 0xBD5AB56A, 0xBD56A60F,
    0x26A5DA24, 0x44977CFA, 0xF7A98A8B, 0x017B7C25, 0xBD503FD1, 0x77E5C157,
    0xFD3177B6, 0x6F5BF2C5, 0x25EAB4A8, 0xCFA25A7A, 0xE281D095, 0xA1C03CA6,
    0xAA19C9DA, 0xB9D43A4D, 0x6C6543B9, 0x11CDCA6E, 0x529340E7, 0x5A342D5A,
    0x96183D02, 0xAC8678C3, 0xD98A8B45, 0x2658A963, 0x51806C97, 0x13583464,
    0x7655997B, 0xDCCDE3E0, 0x2CC531C4, 0x119D7458, 0xE694AA0F, 0x94AA0788,
    0x54245A39, 0x48EA7329, 0x8C1E66F2, 0x13FF3F33, 0x7E0BE57A, 0xBF024FFE,
    0xCFFCFC80, 0x7E38BC08, 0x86045FFE, 0x21FF9F90, 0xCFCA4981, 0x595E84FF,
    0xBFF9F8AF, 0x3F150C08, 0xDC08EBFF, 0xC1CC2195, 0x59C5E92D, 0x2D7967AA,
    0xF7A3C6EE, 0x30783D78, 0xB92DB44C, 0xD5558256, 0x4A850A41, 0x383BB02E,
    0x586FBC9F, 0x58192770, 0xE4649C93, 0x6A4E0EDC, 0xB7095590, 0x14A7C775,
    0xAD316B4F, 0x3156906E, 0x2EA161E5, 0xAB630FDC, 0x2B52C9EA, 0x5693D554,
    0x33D550B1, 0x4D552272, 0xEB5CEF3E, 0x6370F026, 0x4A8D5DB6, 0x01996D6D,
    0x3CB196A9, 0xCB2981D0, 0x94C8A4C3, 0x3E065C75, 0x25A5BB2B, 0x096ED0DE,
    0x43A2B5E5, 0xA2C5E356, 0x65B502E7, 0x8A941FB2, 0x20D7B0E2, 0x79A81E58,
    0x3507351C, 0x84E69847, 0x0729EE26, 0x8595072D, 0x2BA80BAD, 0xCA135135,
    0xA396E543, 0x89ABC6D6, 0x4F026340, 0x6726340B, 0xF1A1A4E9, 0xFF9F826A,
    0xF8F20539, 0xE0475FF9, 0x7FF9F8E4, 0x9F9E1028, 0x430235FF, 0x11FF9F8E,
    0xF3F277B6, 0x3688A93F, 0xE02B14F9, 0x7D6EE750, 0xAB01DF8D, 0x13F31B6B,
    0xC0E9F8EC, 0xC71FD04F, 0x6C812C0E, 0x11FE1308, 0x26C33D8B, 0x06AC69FE,
    0xF640BF93, 0x4F55518C, 0x9843350E, 0xBF3DD411, 0xD52A40AA, 0x554AA3E2,
    0xE6CDD73D, 0xB96BDDCF, 0x43FBE2FB, 0xF7C5DC95, 0xE2ED99A7, 0xBB2DD3FB,
    0x1DF16C1D, 0x7C65AEB1, 0x58A032ED, 0xA4686ED3, 0x93DD4990, 0x7C504C93,
    0xB6A94A85, 0xA52A69AD, 0x3D588EDA, 0x69AC4B31, 0x911761FD, 0xC9E9FD83,
    0x41AC1ACE, 0x2EE3EF95, 0x9904C852, 0x82642912, 0xC8523455, 0xA45A8854,
    0x8C1DA990, 0x98A072D2, 0xA97CFEC3, 0x8EA1298D, 0xB88764C3, 0xD6FDCE79,
    0x6B8294E3, 0x31409F03, 0x7298D087, 0x686D9343, 0xD6A6E92C, 0x90A464DF,
    0x38A23307, 0x29D25B7C, 0x14E095A5, 0x86E324FA, 0xD5A7971A, 0x82AE643C,
    0xBCE79AEE, 0x7B0B03AA, 0x6BD64BB4, 0x35ECBB50, 0x49616198, 0x376161C7,
    0xD6B99367, 0x61B9014D, 0xD74D0717, 0x255B8E59, 0x54A93039, 0x872D6244,
    0x3773FA96, 0xE4BA314C, 0x9DA53D02, 0x71DE8E61, 0x64C3B862, 0xC99CF00A,
    0x9D6B9814, 0xAC7CD6AA, 0x6FD4C79A, 0x0BDDDDB7, 0xBD63DFAB, 0xC3A98DDB,
    0x7E9D42ED, 0xCDDBF357, 0x771FBB8F, 0xDF9BA353, 0xAA7BB70E, 0x75377295,
    0x74392D37, 0x563772B3, 0xAC4F71AB, 0xE6DF9AA7, 0x58C2EEB6, 0x7EEA68CD,
    0xEDC2A4EA, 0x50BA96DA, 0x94F6D527, 0x94EA83CA, 0xD4DDCDC5, 0x517B9B8F,
    0x2C2EDDBF, 0x75B6EFD6, 0x34396DBB, 0x2C6EE3E6, 0xB0AA1535, 0xC6B185FA,
    0x50D19AFD, 0x1CFADB5D, 0x6FCD5275, 0xEE3F0BAB, 0x6EC631BE, 0xDBF1EFD7,
    0xBBF4FDCD, 0xE3DF5DBB, 0x99B8F466, 0x9870EDFA, 0x63C7B96E, 0x2DB9B7EA,
    0xF354D59B, 0xE6EEE3E4, 0xEDD1BBB7, 0x70E8CDD0, 0x63B7EA4F, 0x8DBF5337,
    0x1B7E6EEE, 0xDC5BA63D, 0xB716561C, 0xFBA35343, 0xEAF7354D, 0x7EE3DFA7,
    0xF45566E1, 0xBB8FCDD0, 0x50DA9EDF, 0x8702775D, 0xE6E37EBA, 0x29E6E37E,
    0xC39BA15D, 0x7DDDD0ED, 0x3776318B, 0xD42A7BAD, 0xDBB73355, 0x535DDC7E,
    0x50BAA0FD, 0xA1D50737, 0x0D8B2A5B, 0xC0E4EA1C, 0xB8E4B189, 0x36FD4CDD,
    0x138365B7, 0xC662B72B, 0x31203554, 0x29A92AB6, 0x9AEA1790, 0x35FB9AE5,
    0x2BDCDDBF, 0x83B2D7C7, 0x7BB5D50D, 0xF6D58C2A, 0x6EDA6A4C, 0x7771EE5B,
    0xCEEEC637, 0xC6241D5E, 0x43B915EE, 0x6B35DCDD, 0xAB4F16DA, 0xADCA1750,
    0x40EA13D0, 0x3750E542, 0xDBA36D58, 0x6E8DBF35, 0xEB13B537, 0x187EAC29,
    0x7EC6241B, 0x8F8F35BB, 0xDB876DDB, 0x7EA2B735, 0x2D1FB9BB, 0x71F870B9,
    0x4C39BA37, 0x3B6BAA0B, 0xEA1C6EF2, 0x527B8DDA, 0xCACDD1A3, 0xA75436F4,
    0xEB1E6E2C, 0xDBF376FD, 0xE6E3D0ED, 0xA9A9AC29, 0x5436EA83, 0xB6E66637,
    0x2B6FC2EE, 0xDDDBBB8F, 0xFDDFA7DB, 0xD42FBB9A, 0xF73743B5, 0xBBBF5B6B,
    0xEFD3F5DB, 0x29E8DBF0, 0x2C2B7465, 0xD96EE275, 0x15C73DD4, 0x5437BAEA,
    0x9F4FD537, 0xD775B183, 0xE418F6FC, 0x893D19B8, 0xBF4FDD96, 0x16DBBB9B,
    0xF9AA7BB7, 0x7EA9B9ED, 0x377DC38F, 0xAB54FDBF, 0xA6CFCDD8, 0x0EDC5B7E,
    0x2F76FD4D, 0xE3DDC7AC, 0xCFC5BEE6, 0xEE2CAD8E, 0xA346EE37, 0xB5C97B9B,
    0x7771EFDD, 0x81DD0A7B, 0xA1E853DB, 0x71F3DCD5, 0x70A8BB77, 0xEA192DBB,
    0xBB2DB8A6, 0xD96EEDF9, 0x5D42E4BD, 0xEE3F7751, 0xCCD585EE, 0xB6EDFA8A,
    0xCDFAB0E7, 0x09E37541, 0x0FD58375, 0x1B2CACDD, 0x89063CDD, 0x9DBBD66E,
    0xEC637669, 0xBB5F6876, 0x93D4DD56, 0x2774AEA1, 0xB7B18DD7, 0x74296DB8,
    0xEA48A9BB, 0x58CDD1B7, 0xD4758772, 0x6E2DF76F, 0xAED917EE, 0x87B06DF9,
    0xF7354D56, 0xF6D9D8C3, 0xC39DB85C, 0xCD75436D, 0xDAA6FDD4, 0x576A8381,
    0xEA86D624, 0xB751D42E, 0xEEA7BB6B, 0xA39EDBBA, 0x896E87EE, 0x31A9EFD5,
    0xC6A7ECB0, 0x8329CF74, 0x4EA5376B, 0xBB6E8CDC, 0xF26E4B1B, 0xE8DBF531,
    0x58750BE6, 0xB99B8D4F, 0x7EAB36DD, 0xEEE8DDCA, 0x26FD7EE6, 0xD195A1DB,
    0xBF5DD6DC, 0xEA2C6529, 0x8F58CAC7, 0x8C6DEFBB, 0x5FB9AEDD, 0x7639AB18,
    0xB7E6C833, 0x0EDDD775, 0xEDAB0BDD, 0xBDC7EA6E, 0x8F771EA4, 0xC6A4B1A9,
    0x0EDFA93D, 0xC66AE275, 0x76FD476A, 0xDDC7B92F, 0xEEE56A63, 0xB7EA2C29,
    0x7AEAC4B1, 0xC6153D62, 0xD5376E6A, 0xFD3EDAAE, 0x92DCD5EE, 0x6D76EDFA,
    0x173DBF53, 0xABBF4EEA, 0x576EF53B, 0xD8B6FD0A, 0xB75D42ED, 0xBA575432,
    0x2CA53753, 0xA870343E, 0x3F53448B, 0xDBA3750E, 0x37A6C76D, 0xB6FCD7EE,
    0xDFB9B8B2, 0xA4EA7541, 0x376EDFA8, 0x2B76FCD5, 0x6EDFA9BD, 0x6EE3D59B,
    0xD1A98F6E, 0xDDC7E6E3, 0x6FD496E1, 0xD1959BA3, 0x35765B18, 0x029EEE3F,
    0xDEA4D4F9, 0xFDB5636F, 0x71F95BB8, 0xD963DBF3, 0xC4E7B7E1, 0xE06876E1,
    0xA73BDDC7, 0xED50C594, 0xA83760A1, 0xA771D0F6, 0x7A50D64F, 0xC2DBA13E,
    0xB72DB44C, 0x2D1BA3BB, 0xBC091C08, 0x92B5C816, 0x5A5209DC, 0xEC807CAE,
    0xF6015C88, 0xA143762D, 0x06768999, 0xDBD6F23C, 0x0EED6B02, 0x3212C076,
    0x0D199311, 0x2A6EC91C, 0x54D585BC, 0xA3E939E0, 0xBB5279E1, 0xDC3C5A95,
    0xC1929DD1, 0x8305A4DD, 0x12961E5B, 0x2D81E49C, 0xB5039394, 0x987B7285,
    0x29DD15E1, 0x5CA8F913, 0x5D4ED371, 0x2AA49D60, 0x59F455A9, 0x605D78F5,
    0xD0255AF7, 0x135713DD, 0x3D7872DD, 0x7AF0E5BB, 0x3CB3CB75, 0x392F67AC,
    0x1D507EAF, 0x875BF4F5, 0xF4D7A796, 0x0D7AA8DA, 0x9DF57A4A, 0xDF4E5503,
    0x7D298139, 0x723B552F, 0x42D83BBC, 0x9A388127, 0x8E598735, 0x86E96535,
    0xCB82568F, 0x38C934C3, 0x25BE2576, 0x7A5E1665, 0x878685B0, 0x580AD25D,
    0x122C3CB8, 0xA044A571, 0x9044F017, 0x18A7D7A7, 0xF455AB4B, 0x2252C3D9,
    0x585A83BD, 0x6F42790E, 0x55AF6FCE, 0xC5BEF973, 0xBEF971D6, 0x7AD6FD61,
    0xA550B497, 0x0FD9153D, 0x602F4833, 0xCA926E61, 0xC4A6927D, 0xB5AAA61E,
    0x4D54C3D8, 0xCBA11572, 0xDBD79508, 0x68C9CB49, 0xD790A5A5, 0x69268796,
    0x343CD25A, 0x9A1E3D05, 0x92565202, 0xE5A4E0A6, 0x33330064, 0xCAE633A6,
    0xC253696E, 0x31E58796, 0xF2C2574E, 0x9A148058, 0xB5AC82C7, 0xF30A6872,
    0x11C7324A, 0x40B72DC7, 0x80656E33, 0x923DCA14, 0x2EA8BCC1, 0x54EEC985,
    0x46681297, 0x99A07AE5, 0x5304A02D, 0x5E648F65, 0xE641674A, 0x57A16AA5,
    0x43C7AA8E, 0x8E497453, 0x38B34A5B, 0xE91AD574, 0x23587B15, 0xD84AE9CD,
    0xE385DC98, 0x7343D265, 0x9A1E9256, 0xD0DD8AB2, 0x72D15E9C, 0xDE42C632,
    0x20778F35, 0x094B72F3, 0x68EC03B5, 0x464D9B29, 0x17339631, 0x0E6BCC91,
    0x94D79931, 0x9B4D66B0, 0x672C62C2, 0x9EA5310A, 0x16A4B4D2, 0xB0B50F56,
    0x3C24AD1C, 0xF30E4B74, 0xC99C91CA, 0x6EBC47A8, 0x79784E68, 0x81990E68,
    0xDE162D5C, 0xDA2CC52A, 0x46264869, 0xF590A5D3, 0x0F2CF344, 0x1E5C128B,
    0xCCC65B16, 0x273E4A2B, 0x8BF25135, 0xE4894579, 0x9286F185, 0x794A16B5,
    0xD14A0DD8, 0x827C3340, 0xAC3095D3, 0x49429009, 0x1CC8B3CF, 0x96326732,
    0x65EC4D5B, 0xB03BA6F4, 0x4BBF3ADE, 0x58CD53F4, 0xAEB983EF, 0x6EEDEA7B,
    0x9F43BD7D, 0x66CB6F53, 0xC72D8AD6, 0xF43B26A5, 0xB7E2DEAD, 0xD03EB77F,
    0xDE2C2D42, 0x43A0E6C7, 0x6F09F50F, 0x0FF50F42, 0xA12DBD4E, 0x1720DBF7,
    0xB606292D, 0x5433C63C, 0x333615BB, 0x34F40CD3, 0x73B4FEAF, 0x64529ECB,
    0xEA940AB5, 0xC8AC25EE, 0x3DD2DF73, 0xC0724AD1, 0xC1D71A16, 0xB5E8B449,
    0xD66DA272, 0x2F79E0B7, 0xC92CDFCF, 0x84FD7665, 0xBD49A92C, 0x578B7F6A,
    0x3D03B6B4, 0xC55371BE, 0x81B9359A, 0x72F025A7, 0x6AB522A8, 0xA8346452,
    0xE9E39A52, 0x23E5AB4F, 0x272D5AE7, 0xDA532989, 0xB457ADAD, 0x1D5E98A4,
    0xABD13F56, 0xC23FAB07, 0x2C53FFCF, 0x889FF9F9, 0x7FE7E777, 0xE7E46046,
    0x795ED7FF, 0x46BFF3F3, 0x4CD833E0, 0xB84F9C19, 0x2B5E9812, 0x2C4698D0,
    0x05807C99, 0x2C013F2E, 0xB02155C9, 0xA804DF50, 0x13B4478D, 0x2C065988,
    0xF6F66520, 0x96B33603, 0x62DF6081, 0xDC760129, 0x96B40464, 0x4681EF58,
    0x5420EB55, 0x814AC4F2, 0x0E79C9A7, 0x0C693E1E, 0x4373D2B8, 0xA239BAE1,
    0xAA15709D, 0x77AB0A1B, 0xD72C69E0, 0xCB0F2991, 0xEC988755, 0xB0586BDC,
    0x907B580B, 0x99567BD5, 0xA88C1CA5, 0x81E2D8C9, 0x65E17899, 0x7805324C,
    0x80C9971A, 0xE58EE361, 0x93B87C3A, 0xAB92BCCE, 0x38B5E042, 0xA14BC1A9,
    0x0B49EC55, 0x14D0DF15, 0x3C0838C5, 0x3762D54D, 0x9BB86E34, 0xC4ED3BC3,
    0x1E817D43, 0xEB4E97B0, 0x8EB3D425, 0x6BA1BC2A, 0x5B09030F, 0x6215C8B7,
    0xAF18A477, 0xF91376C3, 0x7AD814F4, 0xD4825EB0, 0x17917B34, 0x771BE968,
    0x220595AE, 0x2CD14C85, 0x1DA12938, 0xDA192DC4, 0x50DC1DDA, 0xC14B4A4D,
    0xD6059247, 0x0F3AE4A4, 0x7965B0CC, 0x5C07B858, 0x4D2A841B, 0xEAA1A1BB,
    0x8A33D78D, 0x8169E043, 0x2D6D4A90, 0xCBADA6B6, 0x307BA788, 0x784AE621,
    0xE6F8A0F8, 0x33586E86, 0xD0F49109, 0x0E64616D, 0x5320C96E, 0xBBCE8E2E,
    0xD4B1C58A, 0x5A0E5FAE, 0xA4AE465B, 0x0E345583, 0xFCB54813, 0xEBC26C87,
    0xAF19EC1C, 0x3F257073, 0x9EAAA7AA, 0xF8BF8E7B, 0xC5F350FE, 0xBB0F6AE7,
    0xD93261F8, 0xB0758FC5, 0xCCD3F85D, 0x6F2253D6, 0x2A9A3FB2, 0xFE3498AC,
    0xAD722B2D, 0x429187F8, 0x29110026, 0x85A87264, 0x88936C32, 0x494AB64A,
    0xED3FCCF6, 0x73248BE5, 0xEB7258A6, 0xF41B5199, 0x3571DB87, 0x5C371825,
    0xB4345581, 0x432C5842, 0x050E542B, 0xC6A5543C, 0xAB84D095, 0x4DA6B336,
    0x13198D6C, 0x60F1A2AC, 0x3ADC7102, 0x2E3927F7, 0x990A4621, 0xD40D4BDA,
    0x193D981E, 0x3437689B, 0x813CC852, 0xD7664291, 0x4ADDEB88, 0x8526A4F3,
    0xD8628935, 0x1E19F5BA, 0x4D618D06, 0x67F4EA83, 0xFA375B4D, 0xDB30CD0B,
    0xEB7EE721, 0xD4CF1161, 0x78A0FA2A, 0x6A7ACB62, 0x27D30E39, 0xA27D26EB,
    0x16542095, 0x07B5814C, 0x8F24E2DE, 0xB8E95C2A, 0x281A92A1, 0xDD98A0F6,
    0xC66F9BD0, 0xBD245804, 0x19A2ADB3, 0xB076488E, 0x93784B27, 0x29D07852,
    0x206CD785, 0x75AFAF5B, 0x6D79CB74, 0xC1C739E8, 0x80AC675B, 0xE80EE31E,
    0xB5AE4079, 0x750A40A7, 0xE8AB502F, 0x7BD2D418, 0x3C06480A, 0x1A0A4743,
    0x58673D1A, 0x9437A391, 0x528635EC, 0x8A5C9358, 0xE49DCC58, 0x9C9693E8,
    0x4B5D7CFE, 0xCCA45F39, 0xDF689979, 0x64B23AF2, 0x48B07BAA, 0xB1B88CF7,
    0x4BD295E6, 0xACF4D94B, 0xB58B4065, 0x56B3AC0B, 0x98B7A398, 0x578719CC,
    0xC23854CA, 0xE4C35172, 0x2C1E2D0A, 0x439E6B14, 0x50A2F249, 0x3C93032E,
    0x7937A398, 0xDB8A0298, 0x01F3576D, 0x1DCDDB8B, 0x8DDABA35, 0xBA1F0EDF,
    0x4F75D43B, 0xF4754162, 0x2E4B10B0, 0xA52569AC, 0x6E78DDB2, 0x37DBF7AC,
    0x45F771FB, 0x6F776BA8, 0x8E6E2DB7, 0x11737D4D, 0xF59AA6EA, 0xD0EA176E,
    0xDCA7AC62, 0x355FB9B2, 0xA93A854F, 0x6DAA0EC8, 0x85F1E275, 0xC6254A67,
    0xB18D96A6, 0xF5DBA365, 0x18DDD8C3, 0xA3F5559B, 0x89D43B7E, 0xE3F16D5B,
    0xBAA18FD8, 0x581BAEA7, 0x4F631BAE, 0xF7729DCD, 0xDD775B7E, 0x774F2A79,
    0xB4DB5D50, 0x75B6BAA0, 0x71F7ACC5, 0xDBA99ABB, 0x6DFA8F85, 0xB630A7AC,
    0xF76FCDC3, 0x73DD750B, 0xF5568EA1, 0xEA15A4C2, 0x5F42D17A, 0xE3C79BA8,
    0x668F6FD3, 0xD4394EA8, 0xEA83AB75, 0xF51C0EA2, 0x53DD50DB, 0x5DD6DCCC,
    0xB8645F35, 0x16DBA1DD, 0xD8C61DB7, 0x36D5E9E3, 0x4E6ABF56, 0x43BAEEB4,
    0x07D8B015, 0x19BB6312, 0x65ADD89C, 0xB0EA83A8, 0xC483B322, 0x96DAAAD8,
    0xF3775F67, 0xE356BB64, 0x49D43B6B, 0x79508DB5, 0xCB5D43BA, 0x33C4A5BE,
    0x0AA4AD1E, 0xC2A93A9C, 0x50CB76E2, 0xD4320CD7, 0x3A85D735, 0x48145D71,
    0x12058D8C, 0xB53D6363, 0xFCDC5BC5, 0xEE11DBF6, 0x6BA8569B, 0x53D8C687,
    0x73554F58, 0x637743F5, 0x3D81B6EC, 0xCADFA7EE, 0x6307876D, 0xB631A303,
    0xB2CD7A6C, 0x5C97AFBB, 0xC7B71735, 0xFD4C7E58, 0xE8D4F376, 0x630ACD0E,
    0xAA854D63, 0xF771FB56, 0xBB8B2A45, 0x31733631, 0x4F1E2DBF, 0x53E9B6AB,
    0x6BB5636D, 0x0EEBAA1B, 0x7B9AED75, 0xE9F77356, 0x3371ECB7, 0x6DF9AA7D,
    0x5A36F95A, 0xECF6F77C, 0x5B7EA2EE, 0xB7EA635C, 0x3A301D43, 0xB77735D4,
    0x14F16F43, 0x7EB66AC8, 0xEA829BF7, 0xB6BEEEDA, 0xA155CDC3, 0xEC71F9AE,
    0x74EA866A, 0x9585F6F7, 0xC3D1631F, 0x9B2CD7D8, 0xDBBA79BA, 0xE03A8735,
    0xC3E2DB70, 0x1FB7E69C, 0xFB2BEB77, 0x1896EC61, 0xAB67B81B, 0xB1895356,
    0x1CD7EEDB, 0x7BB6E6AE, 0x158C278E, 0xBD4DE8AA, 0x2C09CA3D, 0x774EDC7B,
    0xE97AEA13, 0xE87EA9EE, 0x6EFD3E69, 0x73573346, 0xAEDDE8F3, 0x5BB18C59,
    0xB76D556D, 0xB5E98B67, 0xABB153DA, 0xF2DBF525, 0xA7BF7354, 0xEEBF5D42,
    0xEC631603, 0x631EA7B7, 0xEB6E66EC, 0xDDB9992E, 0xC2D1D4B6, 0x07CAC0EC,
    0x719E6E2C, 0xCDD750BF, 0xF35D507C, 0x9EDCDBDD, 0xA2EA5B6C, 0x2B5D43BA,
    0x953D93B7, 0x56DFA8AC, 0xD574EA86, 0xADC4F98A, 0x1BAF27A8, 0xB6AE63AA,
    0x0EA1DDD1, 0xA158C7EC, 0xD615BBAE, 0xAB9BA316, 0xBBF58F79, 0x63A85D5D,
    0x9EDBB7BE, 0xBB7276E3, 0xB2EA731D, 0xBBE87A86, 0x543DBE86, 0xCAA06FB7,
    0x80D65D1A, 0x335974DD, 0xD96686EE, 0x77032F1F, 0x2C25905B, 0x81A0F2E3,
    0x07A57599, 0x81998AA6, 0xC1BC0A14, 0x9020B309, 0xB605AC0B, 0xB41C5550,
    0x0740A5C8, 0x0754064A, 0x1BAE0B4D, 0xD8B581AC, 0xC86B02DB, 0xB815841C,
    0x6E9CB27B, 0xEA512C69, 0x0F2E8730, 0x253D2CE3, 0x61E59BB8, 0x66392ADC,
    0x3E8AB59A, 0x99E84B34, 0x28E4465E, 0x2A85B077, 0x9D1A8B0F, 0x2E8D45FB,
    0xD1E4B9DF, 0x5E83E66D, 0x5E5AD5D6, 0x759A8896, 0xDACD6B03, 0x5BB26530,
    0x93DA16C0, 0x17EAF41D, 0xDF272B71, 0xBE4E095A, 0x2536929F, 0x8356AD5C,
    0x72D2AB96, 0x1E19A27C, 0x95535077, 0xA526BC73, 0x5BE2884B, 0xB0523F6F,
    0x683C3059, 0x77AA032E, 0x5AD23E9E, 0x9C81C609, 0xE8AB516B, 0xB78F2624,
    0x531A5512, 0x7CAD6A50, 0xE6607650, 0x267DB50E, 0x24D32D6F, 0x917B704F,
    0xBD73B827, 0xD50DD795, 0x4FA2AD57, 0x24F7DEAB, 0xD87B1897, 0x5AF213CA,
    0x4E55D0AF, 0x1EEE232C, 0x4C653268, 0x57864E59, 0xC9661EC6, 0x468E696E,
    0xB2DE5AD6, 0xC7580C3C, 0x2CE80598, 0x59B01EAD, 0x3C1B74EA, 0x13187974,
    0xC7939EF7, 0x45CD15A2, 0x939EECA6, 0x4E25ADC0, 0x12CE2F32, 0x2BB7187B,
    0xEBB715A2, 0xD6AE6DA2, 0x495C5E62, 0xB5271878, 0x077A8C3C, 0xECBAA2F3,
    0x19754193, 0xD2AE8BCC, 0x1E2A1CB4, 0x5BB946F2, 0x409651EA, 0x681903B3,
    0xEA52C376, 0x87973239, 0xA6056AE9, 0x7A8ACB34, 0x54A6989A, 0x9EA30F23,
    0xC2574E66, 0x8BD34996, 0x3C032095, 0xD7905B2B, 0x799433D6, 0x94B714F5,
    0xD96C965E, 0xD61EC58F, 0x74E5798B, 0x4E45C8AF, 0xF6782446, 0x53D42CE8,
    0x4A9798C2, 0x02AD2DD6, 0x9C91EA53, 0x86E5B049, 0x3D52D826, 0x47A9515A,
    0xB9716BC8, 0x21785B96, 0xBA5C8AF3, 0x52ED1612, 0x61D14748, 0x986D515E,
    0xCD1E6057, 0x5E612C09, 0x8E61E281, 0x82BCC33D, 0x8B5E45CC, 0xC316AE12,
    0xA4396892, 0xD22F305B, 0xB491A942, 0x3324C0B5, 0x902A3270, 0xB6B0C5AB,
    0xD190745C, 0x72E03D8E, 0x19786DF9, 0x3EA067FA, 0xCE9E9997, 0x968A7EA5,
    0xC54983AC, 0xB3577CBA, 0x66FA8668, 0x9A7FADC1, 0xD3C1BF43, 0x4CFF4512,
    0xADF4C55B, 0xE839D256, 0xA2EB7A95, 0xD2502F75, 0xBBD698BA, 0x9F1E856A,
    0x7EA0AD29, 0x98A502AA, 0x2BCA62B5, 0xFA25EAB5, 0xBE867D14, 0xEA0AD1DE,
    0xEDFB1DEB, 0xAB5DEED5, 0x0A5BCDFA, 0x1ECDBF2E, 0x3C818F9A, 0xB36C689E,
    0xB693E69B, 0x9E91DA31, 0x2AF4EB22, 0x92CD68C9, 0x4B4EBCEB, 0xCD4DD68C,
    0x3F72DD3C, 0x754178D7, 0x22C62C2D, 0x99455AC9, 0x678DB71F, 0x6C0E92CE,
    0x311C0F5B, 0xB5A2B725, 0x08095CEA, 0x02CF5617, 0xA50D1373, 0xCA99A30E,
    0x2E4B224D, 0xBF559227, 0x126AC839, 0x696535A3, 0x69653647, 0x12953645,
    0x4F536B35, 0x9A16AD34, 0x07337934, 0x5986A54D, 0x959A8A0C, 0x78F29BA9,
    0x87B0301D, 0xAA331D49, 0x886F6895, 0x0ECDE357, 0xAD0EF4AC, 0x079E4D02,
    0x93DC781A, 0x3BCADE07, 0x7CAE0E40, 0xFD820640, 0x4376AA80, 0x14AA1481,
    0x0F11A9B0, 0xA07A4C5A, 0x5A025325, 0xBAA052F0, 0x343C1F41, 0x06D705CB,
    0x55AC193D, 0x87561274, 0x35D5840E, 0x341AC24B, 0x07125844, 0x356B6B0D,
    0x644B6B01, 0x12D83940, 0x0C8BECA1, 0x8BD0F476, 0x644DF755, 0xE49A894F,
    0x9C648AB5, 0x970D5D43, 0x52E39622, 0x1BB8A524, 0x42EE4C0F, 0x70EE50DD,
    0x475B8232, 0x4AB70615, 0xF55B902E, 0x24AE094E, 0xA29392BC, 0xEEB6E09E,
    0xC1CD3630, 0x998B4A1B, 0xC14A87B1, 0x43EE8794, 0xAD0F284B, 0x31D6AA8D,
    0x6F02AA3F, 0x95CC2AA8, 0x6FBB0AA1, 0xF30F67A9, 0x884AE45D, 0x4EB7DD17,
    0x94B4E7B7, 0xCE550876, 0x5EF1F432, 0x973D581E, 0xE588CF87, 0x8CB95AF0,
    0xC2572052, 0xF9D70295, 0x3F5D66A2, 0x2D2DD64C, 0x3AE27A31, 0x604D7B2E,
    0x4F0224CA, 0x1D6E449B, 0x2D03B93F, 0x7C98D8B5, 0x84DE8E4A, 0x69F149E6,
    0xA169D6EA, 0x68A64D5D, 0x252F0EB5, 0x1244B0BD, 0x4921969E, 0x9243BE5E,
    0xEE154297, 0x540687B1, 0x540618FD, 0xD43E8B6F, 0x250E50B5, 0x4371EE27,
    0x97684657, 0xB5A05734, 0x51681195, 0xEB1A041B, 0x69896056, 0x12B4D6C6,
    0xE5342D8C, 0x6C8EECC1, 0x8928D2A8, 0xE0625B07, 0xC1E79C71, 0x6FC0750A,
    0xB7C16EAF, 0x6FDAD287, 0xEF195423, 0xBE86EC64, 0xD55BC555, 0x3BD586FB,
    0x129337DE, 0xF873773C, 0xF7E6EE3C, 0x41CA77E8, 0x5291D5A5, 0xA69A15A3,
    0x439387F4, 0xDB9E283D, 0x3B053091, 0xB36AB815, 0xE835B809, 0x55426C96,
    0x2930FECF, 0xC6C36C50, 0xCA2AC026, 0x75426026, 0x95826C92, 0xFC6558AE,
    0xD9D55643, 0x6BF25704, 0x51F2570B, 0xBFD52725, 0xBFD5271B, 0xBFD52717,
    0xDFEA9385, 0x7FAA4E7A, 0x7FAA4E68, 0xFF549C58, 0xFEA93910, 0xFAA4E419,
    0xF549C967, 0xAA4E2DCF, 0xAA4E6A7F, 0x549C757F, 0xAA4E67FF, 0x549C63FF,
    0xA938B7FF, 0xA9386FFE, 0x52705BFE, 0x9387B7FD, 0x93997FEA, 0x939BBFEA,
    0x4E33BFEA, 0x9C9EFFAA, 0x38FDFF54, 0x70FBFEA9, 0xE2F7FD52, 0xC1EFFAA4,
    0x91DFF549, 0x207FEA93, 0x30FFD527, 0x49FFAA4E, 0x51FFAA4E, 0xA3FF549C,
    0x9FFAA4E3, 0x3FF549CE, 0xFFD52724, 0xFF549C3C, 0xFEA938A5, 0xFD5271AB,
    0xFD527097, 0xFAA4E66B, 0xEA9384D7, 0xEA938E5F, 0xD527203F, 0xAA4E307F,
    0xAA4E1C7F, 0xA939E47F, 0x527237FE, 0xA4E693FD, 0x939127FA, 0x4E6DFFEA,
    0x71F7FFAA, 0x49BFFD52, 0xF7FFAA4E, 0x73FB1343, 0x7F8C4D1A, 0x9B27AAA8,
    0x26B4F8B8, 0xC4CAFE2F, 0xF02ABF8B, 0x68DE7B02, 0xC935F4C5, 0x0413619E,
    0x0AD0B4D6, 0x81550B87, 0x5AB4C293, 0x79C716B4, 0x2C1BD156, 0x8B106EAD,
    0x4C1F7BAE, 0x66D57051, 0xCDAAE02C, 0x1C67F458, 0x7B0F1560, 0x0CB73BBC,
    0xC30734C2, 0x9009551B, 0x6628296A, 0x44649A29, 0x34682C9A, 0x3A033B59,
    0xD4574A6E, 0xCB6C97A1, 0x2C1F4B1D, 0xE8EF5A37, 0xD7B2A816, 0xD36D48BA,
    0xB7838E75, 0x9C81DD9E, 0xF2C49CC9, 0x525B1AC0, 0x15E02FAF, 0x96B9701E,
    0xE3C4BAA1, 0xCD33D28A, 0x78CBD229, 0x714C6EE3, 0x5EA9E5BF, 0x6D63C72C,
    0x16914C65, 0x5A45666B, 0xAE58774C, 0x79149CDF, 0x8D64C2B4, 0xB0BDC531,
    0x7250A6E4, 0x464B48B0, 0x93073992, 0xABB1A94C, 0xC7BF5C97, 0x1EB4C6F4,
    0xECF27543, 0xEDC7B966, 0xAADD8A9E, 0x0DD15DBB, 0xC595A1D5, 0x624D4F58,
    0x8C7E853D, 0x22F98FD5, 0x7AAE9687, 0x6D5A6B2A, 0xAA7BA355, 0x5AA7BF59,
    0x9AE79B85, 0x0AD53D55, 0xCA94D693, 0xA7B7E17E, 0x4EAEEA54, 0x86EA191C,
    0xCCDBD616, 0xA078D550, 0xAA83C8AA, 0x11B71D42, 0xBBD2B763, 0x3C6A7B5D,
    0xF5C958FD, 0xA98F1602, 0x743963C5, 0x1DB76E8D, 0x161F62EA, 0x553B64F5,
    0xDB87776D, 0x561CDDBD, 0xE9DF466E, 0xEC737377, 0x8B6FCDC7, 0xB4E45E5B,
    0x5B6CC62D, 0xB9B8DE8A, 0x1D1A8A7B, 0x50EE86EA, 0x7D8C3E35, 0x33771EED,
    0x71F30F03, 0x3CAC0D1B, 0xD49D5B7E, 0xB31A1DD4, 0xFD7EB9ED, 0x063F6594,
    0xDBF35DBB, 0xC5617B3B, 0x1FAEEB46, 0xC7E6BF56, 0xE33DB185, 0x81B7E6E6,
    0xEBA37767, 0xDB5FBBF4, 0x550E53DD, 0xD8308E52, 0x0CDDB8E0, 0x8254954E,
    0x0E19D8C4, 0xA4A0CA75, 0xAB3731D4, 0xDEEB1B6A, 0x63F35F1E, 0xFDD0ED90,
    0x4D494FC6, 0x96152DF6, 0xC73746EA, 0xC396EAC6, 0x8B6ADC7A, 0x6DC7EC77,
    0xA0EA7AF7, 0x3B75173A, 0x756EB965, 0x9E17753D, 0x02F560F1, 0x72C72589,
    0x1FB6BA87, 0x15D62DBF, 0x4DCDDD28, 0x0FDD8CA9, 0xB81958FD, 0xE153D61F,
    0xA79AEDD9, 0xDF9AFB1E, 0xA7A6C636, 0xDCA53CCC, 0x22F9B26A, 0x7DB7630F,
    0xFAF22F34, 0x2B1AC296, 0x6EC615CB, 0x5EEDBB17, 0x1EEDC3B1, 0xC7EE66C7,
    0x7531C9ED, 0xF58F7EEC, 0x79E83C7B, 0x5B9BBF5B, 0xFB6A9AF5, 0xD8BF71ED,
    0x72C0C6F4, 0x19BBF5B1, 0x6FAEDDDD, 0x258C7A31, 0x126FD917, 0xB7ABAD4D,
    0x36FC7EDB, 0x73568E5A, 0x746EBF64, 0xE5603BA8, 0x89D581B6, 0xAEE9DF1F,
    0xF771EEFB, 0x5B8F7E9D, 0xF7EA92F5, 0x53DFB998, 0xA8BD31E8, 0x0EDFB6AA,
    0xB70BB737, 0xDEB62AAD, 0x7A66E8CD, 0x1F8B7458, 0xC3959B87, 0x5989D4FD,
    0xC2F9AF85, 0xD254A091, 0x71EFD72D, 0xBA3750CB, 0xEC6255D2, 0x23B7B966,
    0x6FA36A4F, 0x5D50587C, 0xEAD7563D, 0xADBF7AD9, 0xB746EE1C, 0xDEF9BB44,
    0xBB7B9EEE, 0xBA1DB85F, 0x3371EA7B, 0x7A537A4D, 0x0F8B13AB, 0x599A7BAB,
    0x81617B8E, 0x6377168D, 0x716DDB8D, 0xDDDDEA54, 0xD3C6794F, 0x9C8A9E8C,
    0xC62244F1, 0x0E4EEB46, 0x9A29A9EB, 0x6EDC7CD3, 0x9B1CAC7E, 0x4A78DFB9,
    0xB84F7A3C, 0x7A6C5599, 0xC18B6F58, 0xF5750E3D, 0xAA7D2B54, 0xDCA9356B,
    0x5DAEACCD, 0xCCD8EEBF, 0xD13B18DD, 0x1C7ECFDD, 0xDBF35E9B, 0x5BBB3DFA,
    0x4D4763BF, 0xEEEECF35, 0xD42F4985, 0x1BE6E3D5, 0xD63658CF, 0x676BBADB,
    0xEC0EA866, 0xF7294F69, 0xC537562D, 0x9153DDB2, 0xEA96E93D, 0x26AADFA7,
    0xF763BAE5, 0x0E17EE63, 0xA5A6353F, 0xDB71E52B, 0xD9E72052, 0xFD769CFA,
    0x2DB54AA6, 0xB1A3370E, 0xD43B7EF4, 0xEC1A0F1E, 0x69B156C8, 0xDB029BF6,
    0x88ECD1CB, 0xBC0EF38B, 0x0329DE01, 0xB80DD652, 0x02A05C05, 0xE7A1406B,
    0x1727B201, 0x81F2A1D8, 0x0743331E, 0xD93784AE, 0x0EE04F0D, 0x61F07B58,
    0xB6C1CB5E, 0x605CF728, 0x313E4D0B, 0x3BEDF945, 0x9A396B95, 0xA0CB98C5,
    0xCB0F2CB6, 0x66AC3558, 0xD72526D5, 0x374CA7D6, 0x533D6393, 0x4A4DFA32,
    0xDA1B9BF4, 0xAF4CA58B, 0x7BEEF580, 0x91DF65E0, 0xC1A97389, 0x593759AC,
    0x34C2573C, 0x3CD4C32F, 0x156ED6EE, 0x183CB686, 0x117A095A, 0x650904ED,
    0xAA039C47, 0xDB4415AA, 0x52BA8192, 0x3222FB13, 0xF13E48B6, 0x0F13964E,
    0x58767C9B, 0xDA0F4830, 0x7A1BB5E4, 0x4991124C, 0x7A8AB701, 0x16AAC4A4,
    0xE3C078A2, 0x0F2F3245, 0x291DB04B, 0xEA53265E, 0x2560EE01, 0x20DB0B48,
    0xC7C032CF, 0xE685202C, 0x05E61B80, 0x9263492E, 0x779C1939, 0xA66EE4B4,
    0x6750EE1E, 0x295E74E1, 0x7064C55C, 0xEEA68152, 0xBDEA35E4, 0xE457542C,
    0xB9166535, 0x51CB1794, 0x59453D06, 0x92CA27EB, 0xBC8394C7, 0x864FB2A6,
    0xB51CC12A, 0xD2297985, 0x7A59A52B, 0x5E42CB3D, 0x5C60655B, 0x75B5E439,
    0x86EB9329, 0xA6959639, 0x2933DADD, 0xACA6076B, 0xB2CE6867, 0xC295AF30,
    0x7917BABC, 0x630AEFAD, 0x6EAF30F7, 0x173D2969, 0xD4B9EAF3, 0x5E415E8E,
    0x72E4EA73, 0x2C62A3DC, 0x88C9B5E4, 0x19316AC4, 0xABCC69A5, 0x92AF31A4,
    0xD12561E5, 0xD22ECA8A, 0x4BCC3728, 0xA9532D6A, 0x8784E5A7, 0x994713D5,
    0x79D2DC57, 0x457984E2, 0x68CBA62B, 0x7298C39E, 0x8C8EC638, 0xA0587B5A,
    0xB5606687, 0xF317B196, 0x8D9C6962, 0xA507A9E2, 0xF54A147A, 0xB713CA30,
    0xC44899F0, 0x9F032627, 0xE31B2D20, 0xF30A64C4, 0x43C45322, 0xC8782066,
    0xA6923532, 0x073F4F51, 0x19F7AB5A, 0xF96ADF43, 0xDFB7EFAD, 0x26FE9920,
    0x74A65817, 0xF377AD15, 0x04AFD0BA, 0xFBD56D25, 0xBF5BBEA0, 0x2B97E9E5,
    0x535CBF61, 0xAAB612B5, 0xB5E876D5, 0xE47EFCBD, 0xD62D7301, 0x2DBDA2D6,
    0x2A4EFCFD, 0xAE5F7EF5, 0x16C1F93D, 0xF3F4A54A, 0xDD4DAF34, 0xDB68E72A,
    0x72DD3D42, 0xC7979A93, 0x09EF58F2, 0x0B638B77, 0xA0EE88DD, 0xCF767C48,
    0xB3631F21, 0xC06896FB, 0xD1E2BCD7, 0x3564878B, 0x72755AD1, 0x0E03CBF3,
    0xD893DB24, 0x2875606F, 0x32C5D3D7, 0x83AD5AC2, 0x2A0A59A9, 0x032A0B03,
    0x80068850, 0x81CD34BC, 0x0EC04F8F, 0xAF2E609F, 0x8578FCD3, 0x56057A61,
    0x8F6D10F7, 0xF0161DC5, 0xBD203293, 0x82CA01F1, 0x16079607, 0xD06BC0A8,
    0xF2A0A791, 0xAA4A82E4, 0xA05B5427, 0x25702782, 0x701EBE5C, 0xC5841CDD,
    0x7AB09971, 0xAC358424, 0x286F1982, 0x961EC633, 0xA92C295E, 0xF41CB264,
    0x69567B62, 0xC8356B6C, 0xF64F00B6, 0x5272D814, 0x0E6493E8, 0x360EB706,
    0x5A8236E1, 0x8D6D6BD4, 0x7A4D0966, 0xABA50DE4, 0xE3151780, 0x19E94A85,
    0x9A5534EA, 0x5C6554DA, 0xC4DE3777, 0x7DC1BC96, 0x16DD33A8, 0x542D815D,
    0x345693B7, 0xDDA72E6F, 0xC37694B0, 0x950AB656, 0xBCF03CB2, 0x92B5378C,
    0xB055B713, 0x6FCDACA5, 0x6E5BBA79, 0x57311BAD, 0xE9EB702F, 0x4BD50E35,
    0x845CCD7A, 0xCFC22E67, 0xD4CD6094, 0xC4BEB65B, 0x87896570, 0x3E9DC6A6,
    0x5C4F5345, 0xA89A6769, 0x3144C41D, 0x5E92A1BC, 0xE45E48F8, 0x913E6A48,
    0x0A504AD4, 0x9A2914AA, 0xF6ECF212, 0x7714F0EC, 0x195ED501, 0xA2EEB6AA,
    0x94094C20, 0xECDC0F74, 0xADA6B62A, 0xB77EB627, 0x2A11B78B, 0xE87969F4,
    0xD0B42E02, 0x15623444, 0x5E05CCE6, 0xBAEA330E, 0x375B1E79, 0x5839EFCF,
    0x32EB3C9D, 0x41CB5BC8, 0xB250DE16, 0x7724D31E, 0x17B78AAE, 0xDD2DBCA6,
    0xDD004EF3, 0xC3DB53F9, 0xC7E7296B, 0x1E3C6150, 0x9ADEBC96, 0xADACC156,
    0x9B0A464B, 0x21684AE0, 0xAA13642D, 0x1FD69E7A, 0x1722312D, 0x813BDA77,
    0xE0738D2A, 0xFFC0387A, 0xE587B68A, 0x8065C3D0, 0xABA35872, 0x29190727,
    0xC02FBDD0, 0xE7377A79, 0x9E716E19, 0x68F38B51, 0x73679CD4, 0x7134F390,
    0xFA56B7AB, 0xADA868F1, 0x9D68AB1D, 0x183C6816, 0x3282AB58, 0x9ECA344F,
    0xAD0B4339, 0x92A492C0, 0xD0BDB368, 0xC95C2C54, 0x41CDCBEE, 0xD65ACB1E,
    0xE7D2815F, 0x5C593DC0, 0x539A2F4A, 0xAE61095E, 0x86D6B084, 0x4A4BB3D0,
    0x2CD6DB33, 0xB3C99ADD, 0x4B92C626, 0x631CB8BC, 0xB96E1CCA, 0x5326ECD9,
    0xB76E4F5D, 0xB74F747D, 0xBDD68A7A, 0xAA0AD98D, 0x61614F6B, 0xE17CA7B5,
    0xCA96EC73, 0x973CDCC3, 0xCA53C6AD, 0xAF9AB1B2, 0xBD76F53D, 0xAD6E873D,
    0x8DD5AE0C, 0xCE6E17DE, 0xF22AE9F0, 0xCC96BA9E, 0x061DDC05, 0x39F5B04E,
    0xFAAE4B45, 0xF3254746, 0xAADCA76E, 0xAB43C6E4, 0xEAA1DDD0, 0xA3C9CC6D,
    0xECB41E37, 0x3B711E6B, 0x7BCF7679, 0x6D50DB9B, 0xF9AB4355, 0x096E85D0,
    0xEE72F80E, 0x35EB94ED, 0x1381671E, 0x42AC4B57, 0x902C2ECB, 0x76B12FA5,
    0xC125B69A, 0x4396509E, 0x30F0BB5F, 0xE028BA87, 0xB47CC561, 0xF62ADD0E,
    0xEDB95B71, 0xDB8B8F1B, 0xF6FCD7CC, 0x46D4CF75, 0x9EDBB7EB, 0xDAED5754,
    0xC767AB4D, 0x4C8E3F3E, 0xADDDE370, 0xA9EAA83B, 0xF22A7B70, 0x120C6F9A,
    0xB8276F7D, 0xEA6CF529, 0x73F561F0, 0x2C8EC0B8, 0x2DF55CB4, 0x7B753C8E,
    0xE4AD39F4, 0x558A7AA9, 0x8E616878, 0xE9C8AD1C, 0x53FB9AFB, 0x8F774AAD,
    0xA7ABA3C3, 0xD3520D0E, 0xEDDAF876, 0xE9C0EDD8, 0xDFAEE673, 0xFA7C7CA9,
    0x57478F1C, 0x96DFAF45, 0x2338FDDD, 0xF62A720D, 0x4A6795A1, 0xB27D9E79,
    0xEF4EE7BB, 0x461915A2, 0xCEE4A7CC, 0x10E4AA17, 0x8A5D9E4B, 0x33DEC616,
    0xDD1B7B9E, 0xAD737C2A, 0xE5DDD6D5, 0x7A1F43E3, 0x36E2AA0A, 0x637C23B7,
    0x13BAAD7A, 0x01E3587D, 0x44831EBB, 0x66DEF89F, 0x3DDD3E89, 0xF531E1DB,
    0x30A9E78D, 0xAB0E6275, 0x559B587E, 0x6A156BA8, 0xE61E1D83, 0xF6B23BA4,
    0xEE3C2BDA, 0x72380520, 0x700AA301, 0x407C2560, 0x6CBA7C0A, 0x46456B56,
    0x2E5DCF24, 0x68239746, 0xB956CD09, 0xF4941966, 0xA4C67C9A, 0xA8CEE4D7,
    0xD342E56E, 0xB4B2BCD2, 0x0DB5BD65, 0xB5CA856A, 0x4C4AD5A2, 0xCAF6F1DE,
    0x02A36A78, 0xAB724CF2, 0xBAED1CA4, 0x98E3D5A3, 0x0626EF0C, 0x6160465E,
    0x1D36E81B, 0xC095B4F0, 0xBEA83BB2, 0xC929158A, 0xD587A91E, 0xBA64B98C,
    0x398956E4, 0x789C3A29, 0xE63D49CC, 0x8BD2584A, 0x493C5496, 0xBDD286A5,
    0x58579472, 0x0EA3D4A5, 0x2D40AAC5, 0xEA7765B5, 0x352B6E15, 0xBD832DAD,
    0xA55E7432, 0xEA5B5E69, 0x7A7A8EE9, 0xB17A7AAE, 0x962D7BDD, 0xA58F0BE2,
    0x8B40929E, 0xDDE23D59, 0xB961172D, 0xD2879128, 0x48F56294, 0x33784549,
    0x23B02E47, 0x79A32E97, 0x89CBB44F, 0x5E8B73A6, 0x070E31CB, 0xE64133CA,
    0x8C9D1455, 0xD928E3EA, 0x13D5751D, 0x78A3516B, 0x91459A4C, 0x72645616,
    0x31B5E431, 0xB4998B59, 0x7A9A43D4, 0xF68E4BBA, 0xA95B471B, 0xEB5E85A1,
    0xD34D685A, 0x2D6F6B42, 0x7560F034, 0x5BC0CFA8, 0x4B475B7E, 0x6A9B52DC,
    0xE36D3735, 0xF7AEAAD4, 0xED66E0DA, 0x5B71EF56, 0x976FCB55, 0xACC52B56,
    0x9E6EA47A, 0xB4868E58, 0xD92DC1E4, 0xD9EA81F0, 0x537ACD81, 0x6F52DE8F,
    0x24B12D3D, 0x79720854, 0x59AFA17B, 0x781B69EF, 0x256896DA, 0x472D2D4F,
    0xED1EAC6F, 0xB9D2F771, 0x2F07F57B, 0x34CC54F4, 0xD9CADE0B, 0xC3AA0A34,
    0x636B392D, 0x961962B4, 0xC8A52723, 0x33D6B229, 0x89DA178F, 0xDDCE7763,
    0x69ADA0FD, 0x95D9BD2B, 0x1F005637, 0x018D20DB, 0x3281686E, 0x00C2A806,
    0x4F415015, 0x80B0B40D, 0xA55091CA, 0x2556A835, 0xD7083C3C, 0x50CB06C1,
    0x30F7A941, 0x03CC2D83, 0xB057A593, 0x8C56685C, 0x93239326, 0x964BE06D,
    0x0D45A9CD, 0x25C543E7, 0xF1BB9E4B, 0xA7924AE2, 0x71E8AB5E, 0x0CC8F418,
    0xAE92CCBA, 0x6FBB4502, 0xE92D3951, 0x3EE8F086, 0x5986AA96, 0xC7AA4495,
    0x78937788, 0x4C8EA172, 0x3D44BA58, 0x9594F72E, 0xBD495C8E, 0xD63BF256,
    0xD3ACF5AD, 0xDFC759E2, 0x5589E55A, 0xC42AC770, 0x6B58855C, 0xF0DD376B,
    0xD5A1EE89, 0x697AFDCF, 0xE5E45E96, 0xC93F2598, 0x356B98EF, 0x54F3A373,
    0x91BD4F3B, 0x9AD49EAC, 0xE0B34305, 0xD49AA9A3, 0x56B7AF4E, 0xF313452D,
    0xD4F5C9A7, 0xED117AA4, 0x0654940C, 0x1494B072, 0x9AAF0ACB, 0x542D1650,
    0xB47B4465, 0xA343758C, 0x65A8CADF, 0x89ECDC09, 0xFBC45B0D, 0x0324F022,
    0xAAC1F98B, 0x85E85815, 0x8770327B, 0x075264DA, 0xAC99AC59, 0x413BD645,
    0xD40F3BCA, 0xC7B164BB, 0x9A7F4AAA, 0x83305E56, 0xE2E67B25, 0x89B18783,
    0xAF90CF60, 0x9E0040E7, 0x0E34D653, 0xA54315F0, 0x42667B1A, 0x1FD58695,
    0x7FA9F82D, 0xD4387F5A, 0xD40E43FA, 0x28D2C35B, 0x5A3FB457, 0x2ED09A6A,
    0x8209B1A1, 0xD28B4D66, 0x9BE4A10A, 0xE092B9DB, 0x6D682FF5, 0x68695612,
    0xF455C8FE, 0xAF57ABE5, 0x7D0BAF62, 0xD102BAF2, 0xA3B7240A, 0x169BF594,
    0x3575BA2B, 0xB7DDACBE, 0x51574EAF, 0xADB76F51, 0xDDFA76BB, 0xBA76AB77,
    0x6CFCC9DA, 0xFCE9476E, 0x7D66CB76, 0x03F56301, 0x2EDE8A7B, 0x6EA5D6FD,
    0x3500BF9B, 0x160BCB03, 0x7F58A87B, 0x3EDD2262, 0x79F87BAE, 0x41E4D9E6,
    0x92DE75F7, 0x6A8158A0, 0x23676543, 0xBBA48FDD, 0x245A149E, 0x3BDF7BB6,
    0x7D7A6C9A, 0x22D6F56B, 0xFDF4F452, 0x1BEF53BE, 0xF780DDA0, 0xD90FBC55,
    0x4EBE977B, 0x68F6B2FA, 0x8A4D7A17, 0xAB49506B, 0xE245337E, 0x1A4DC65E,
    0x454E14C9, 0x76FA704B, 0x7A793649, 0xE45C8E7B, 0x03FBB191, 0x9A2D8A15,
    0xF5AF1B1B, 0x00078300, 0x825AE0D2, 0x671413B5, 0xD6C0C350, 0x849021EB,
    0x57066D4F, 0x158A1763, 0x6CCA560C, 0x94D2304F, 0xB7CE4D33, 0xEB704F38,
    0xD3D38284, 0x34DD140E, 0x514D2E55, 0x78005524, 0xA65D4010, 0x9A24D3A6,
    0x649369D6, 0x0A2D692B, 0xEB5B1D70, 0xB0E2AD7A, 0x9ECF6267, 0xD477673D,
    0x5ACB5CE0, 0xDF0834AB, 0xA445A95A, 0x498F88D5, 0x943F4A1E, 0x15961EAA,
    0x7F922D99, 0x031DF942, 0xA3B528B9, 0x1C2D89E6, 0x91E413D6, 0xB22C8F26,
    0x7AC2C930, 0x72FBC9E7, 0x3EBC5078, 0x06A640A5, 0xD3DC1A9F, 0xDC827F72,
    0x4F8EE5FF, 0x7CBFE3B0, 0x9D4FBD95, 0x2F727CB6, 0x0FE8BF89, 0x4F5ED38B,
    0x782518B4, 0xFDEB1449, 0x9782377E, 0x48C7891A, 0x6F67C16D, 0x7610D71D,
    0xD0106B6D, 0xFA097824, 0x6F61821B, 0x15C4419A, 0x41D2C9CF, 0xAE9A83A0,
    0x8C24446B, 0xCDEBBF7C, 0x27FD7A3F, 0x4497FFD0, 0x0000097E,
};

/**
 * PSL represented as a directed acyclic graph
 * There are 8212 labels in 8687 nodes
 */
static const union pnode pnodes[8687] = {
    /* root entry */
    { .label = { 0, 0, 1 } }, { .child = { 2, 1553 } },
    /* entries 2 to 1799 */
    { .label = {    189,  2, 1 } }, { .child = { 1800, 6 } }, /* ac */
    { .label = {    272,  2, 1 } }, { .child = { 1806, 1 } }, /* ad */
    { .label = {      6,  2, 1 } }, { .child = { 1807, 8 } }, /* ae */
    { .label = {  72000,  4, 1 } }, { .child = { 1815, 87 } }, /* aero */
    { .label = {     93,  2, 1 } }, { .child = { 1902, 5 } }, /* af */
    { .label = {    320,  2, 1 } }, { .child = { 1907, 5 } }, /* ag */
    { .label = {    118,  2, 1 } }, { .child = { 1912, 4 } }, /* ai */
    { .label = {     11,  2, 1 } }, { .child = { 1916, 7 } }, /* al */
    { .label = {    626,  2, 1 } }, { .child = { 1923, 1 } }, /* am */
    { .label = {     18,  2, 1 } }, { .child = { 1924, 6 } }, /* ao */
    { .label = {    438,  2, 0 } }, /* aq */
    { .label = {     47,  2, 1 } }, { .child = { 1930, 9 } }, /* ar */
    { .label = { 120635,  4, 1 } }, { .child = { 1941, 6 } }, /* arpa */
    { .label = {    130,  2, 1 } }, { .child = { 1947, 1 } }, /* as */
    { .label = {  64147,  4, 1 } }, { .child = { 1948, 1 } }, /* asia */
    { .label = {    145,  2, 1 } }, { .child = { 1949, 9 } }, /* at */
    { .label = {    397,  2, 1 } }, { .child = { 1967, 18 } }, /* au */
    { .label = {   3308,  2, 1 } }, { .child = { 2002, 1 } }, /* aw */
    { .label = {   1006,  2, 0 } }, /* ax */
    { .label = {   3288,  2, 1 } }, { .child = { 2003, 12 } }, /* az */
    { .label = {    267,  2, 1 } }, { .child = { 2015, 7 } }, /* ba */
    { .label = {   5292,  2, 1 } }, { .child = { 2022, 10 } }, /* bb */
    { .label = {   2741,  2, 1 } }, { .child = { 2032, 1 } }, /* bd */
    { .label = {    608,  2, 1 } }, { .child = { 2033, 3 } }, /* be */
    { .label = {   1327,  2, 1 } }, { .child = { 2038, 1 } }, /* bf */
    { .label = {   4210,  2, 1 } }, { .child = { 2039, 37 } }, /* bg */
    { .label = {    987,  2, 1 } }, { .child = { 2076, 5 } }, /* bh */
    { .label = {   1329,  2, 1 } }, { .child = { 2081, 5 } }, /* bi */
    { .label = { 147761,  3, 1 } }, { .child = { 2086, 12 } }, /* biz */
    { .label = {  14029,  2, 1 } }, { .child = { 2098, 4 } }, /* bj */
    { .label = {    134,  2, 1 } }, { .child = { 2102, 5 } }, /* bm */
    { .label = {    268,  2, 1 } }, { .child = { 2107, 1 } }, /* bn */
    { .label = {    988,  2, 1 } }, { .child = { 2108, 9 } }, /* bo */
    { .label = {    607,  2, 1 } }, { .child = { 2117, 70 } }, /* br */
    { .label = {   1053,  2, 1 } }, { .child = { 2219, 5 } }, /* bs */
    { .label = {    605,  2, 1 } }, { .child = { 2224, 5 } }, /* bt */
    { .label = {    606,  2, 0 } }, /* bv */
    { .label = {   3705,  2, 1 } }, { .child = { 2229, 2 } }, /* bw */
    { .label = {    932,  2, 1 } }, { .child = { 2231, 4 } }, /* by */
    { .label = {   4648,  2, 1 } }, { .child = { 2237, 6 } }, /* bz */
    { .label = {    135,  2, 1 } }, { .child = { 2243, 18 } }, /* ca */
    { .label = {    419,  3, 0 } }, /* cat */
    { .label = {    876,  2, 1 } }, { .child = { 2261, 6 } }, /* cc */
    { .label = {    183,  2, 1 } }, { .child = { 2267, 1 } }, /* cd */
    { .label = {   1900,  2, 1 } }, { .child = { 2268, 1 } }, /* cf */
    { .label = {    525,  2, 0 } }, /* cg */
    { .label = {    192,  2, 1 } }, { .child = { 2269, 2 } }, /* ch */
    { .label = {    257,  2, 1 } }, { .child = { 2271, 15 } }, /* ci */
    { .label = {   2744,  2, 1 } }, { .child = { 2286, 2 } }, /* ck */
    { .label = {   1197,  2, 1 } }, { .child = { 2290, 5 } }, /* cl */
    { .label = {    358,  2, 1 } }, { .child = { 2295, 4 } }, /* cm */
    { .label = {   1484,  2, 1 } }, { .child = { 2299, 44 } }, /* cn */
    { .label = {     44,  2, 1 } }, { .child = { 2352, 13 } }, /* co */
    { .label = {    108,  3, 1 } }, { .child = { 2367, 273 } }, /* com */
    { .label = { 155301,  4, 0 } }, /* coop */
    { .label = {   1019,  2, 1 } }, { .child = { 2709, 7 } }, /* cr */
    { .label = {   7312,  2, 1 } }, { .child = { 2716, 6 } }, /* cu */
    { .label = {   8860,  2, 1 } }, { .child = { 2722, 1 } }, /* cv */
    { .label = {  60449,  2, 1 } }, { .child = { 2723, 4 } }, /* cw */
    { .label = {    453,  2, 1 } }, { .child = { 2727, 2 } }, /* cx */
    { .label = {   6986,  2, 1 } }, { .child = { 2729, 13 } }, /* cy */
    { .label = {   6751,  2, 1 } }, { .child = { 2744, 4 } }, /* cz */
    { .label = {     46,  2, 1 } }, { .child = { 2748, 22 } }, /* de */
    { .label = {  12108,  2, 0 } }, /* dj */
    { .label = {    504,  2, 1 } }, { .child = { 2775, 6 } }, /* dk */
    { .label = {   2999,  2, 1 } }, { .child = { 2781, 5 } }, /* dm */
    { .label = {    110,  2, 1 } }, { .child = { 2786, 10 } }, /* do */
    { .label = {   2551,  2, 1 } }, { .child = { 2796, 8 } }, /* dz */
    { .label = {    104,  2, 1 } }, { .child = { 2804, 12 } }, /* ec */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {    574,  2, 1 } }, { .child = { 2816, 10 } }, /* ee */
    { .label = {    463,  2, 1 } }, { .child = { 2828, 9 } }, /* eg */
    { .label = {    519,  2, 1 } }, { .child = { 2839, 1 } }, /* er */
    { .label = {    143,  2, 1 } }, { .child = { 2840, 5 } }, /* es */
    { .label = {     51,  2, 1 } }, { .child = { 2847, 8 } }, /* et */
    { .label = {   1493,  2, 1 } }, { .child = { 2855, 5 } }, /* eu */
    { .label = {   2245,  2, 1 } }, { .child = { 2862, 4 } }, /* fi */
    { .label = {  12181,  2, 1 } }, { .child = { 2866, 1 } }, /* fj */
    { .label = {   1877,  2, 1 } }, { .child = { 2867, 1 } }, /* fk */
    { .label = {   3205,  2, 0 } }, /* fm */
    { .label = {     96,  2, 0 } }, /* fo */
    { .label = {    229,  2, 1 } }, { .child = { 2868, 29 } }, /* fr */
    { .label = {    323,  2, 0 } }, /* ga */
    { .label = {   1364,  2, 0 } }, /* gb */
    { .label = {   7094,  2, 0 } }, /* gd */
    { .label = {    591,  2, 1 } }, { .child = { 2897, 7 } }, /* ge */
    { .label = {   7512,  2, 0 } }, /* gf */
    { .label = {    579,  2, 1 } }, { .child = { 2904, 3 } }, /* gg */
    { .label = {    156,  2, 1 } }, { .child = { 2907, 5 } }, /* gh */
    { .label = {    219,  2, 1 } }, { .child = { 2912, 6 } }, /* gi */
    { .label = {   2230,  2, 1 } }, { .child = { 2918, 5 } }, /* gl */
    { .label = {   4118,  2, 0 } }, /* gm */
    { .label = {    137,  2, 1 } }, { .child = { 2923, 6 } }, /* gn */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   1312,  2, 1 } }, { .child = { 2929, 6 } }, /* gp */
    { .label = {   3385,  2, 0 } }, /* gq */
    { .label = {   1209,  2, 1 } }, { .child = { 2935, 6 } }, /* gr */
    { .label = {    421,  2, 0 } }, /* gs */
    { .label = {    614,  2, 1 } }, { .child = { 2941, 7 } }, /* gt */
    { .label = {   8694,  2, 1 } }, { .child = { 2948, 1 } }, /* gu */
    { .label = {   2920,  2, 0 } }, /* gw */
    { .label = {    695,  2, 1 } }, { .child = { 2949, 6 } }, /* gy */
    { .label = {   1313,  2, 1 } }, { .child = { 2955, 24 } }, /* hk */
    { .label = {    195,  2, 0 } }, /* hm */
    { .label = {    434,  2, 1 } }, { .child = { 2979, 6 } }, /* hn */
    { .label = {    101,  2, 1 } }, { .child = { 2985, 5 } }, /* hr */
    { .label = {    521,  2, 1 } }, { .child = { 2990, 17 } }, /* ht */
    { .label = {   1315,  2, 1 } }, { .child = { 3007, 32 } }, /* hu */
    { .label = {     88,  2, 1 } }, { .child = { 3039, 11 } }, /* id */
    { .label = {     19,  2, 1 } }, { .child = { 3052, 2 } }, /* ie */
    { .label = {   2118,  2, 1 } }, { .child = { 3054, 8 } }, /* il */
    { .label = {      1,  2, 1 } }, { .child = { 3064, 8 } }, /* im */
    { .label = {    654,  2, 1 } }, { .child = { 3075, 14 } }, /* in */
    { .label = { 107696,  4, 1 } }, { .child = { 3089, 15 } }, /* info */
    { .label = {   7316,  3, 1 } }, { .child = { 3104, 1 } }, /* int */
    { .label = {     65,  2, 1 } }, { .child = { 3105, 19 } }, /* io */
    { .label = {   1407,  2, 1 } }, { .child = { 3128, 6 } }, /* iq */
    { .label = {    202,  2, 1 } }, { .child = { 3134, 9 } }, /* ir */
    { .label = {    262,  2, 1 } }, { .child = { 3143, 8 } }, /* is */
    { .label = {     41,  2, 1 } }, { .child = { 3151, 369 } }, /* it */
    { .label = {     16,  2, 1 } }, { .child = { 3520, 3 } }, /* je */
    { .label = {   7979,  2, 1 } }, { .child = { 3523, 1 } }, /* jm */
    { .label = {   4814,  2, 1 } }, { .child = { 3524, 8 } }, /* jo */
    { .label = { 155432,  4, 0 } }, /* jobs */
    { .label = {    585,  2, 1 } }, { .child = { 3532, 111 } }, /* jp */
    { .label = {   1883,  2, 1 } }, { .child = { 5398, 2 } }, /* ke */
    { .label = {   1841,  2, 1 } }, { .child = { 5402, 6 } }, /* kg */
    { .label = {   1427,  2, 1 } }, { .child = { 5408, 1 } }, /* kh */
    { .label = {   1352,  2, 1 } }, { .child = { 5409, 7 } }, /* ki */
    { .label = {   2720,  2, 1 } }, { .child = { 5416, 17 } }, /* km */
    { .label = {   1318,  2, 1 } }, { .child = { 5433, 4 } }, /* kn */
    { .label = {   4297,  2, 1 } }, { .child = { 5437, 6 } }, /* kp */
    { .label = {    437,  2, 1 } }, { .child = { 5443, 30 } }, /* kr */
    { .label = {    648,  2, 1 } }, { .child = { 5473, 1 } }, /* kw */
    { .label = {   4120,  2, 1 } }, { .child = { 5474, 5 } }, /* ky */
    { .label = {    471,  2, 1 } }, { .child = { 5479, 6 } }, /* kz */
    { .label = {     20,  2, 1 } }, { .child = { 5485, 10 } }, /* la */
    { .label = {    263,  2, 1 } }, { .child = { 5495, 5 } }, /* lb */
    { .label = {    497,  2, 1 } }, { .child = { 5500, 7 } }, /* lc */
    { .label = {      2,  2, 1 } }, { .child = { 5507, 1 } }, /* li */
    { .label = {    432,  2, 1 } }, { .child = { 5508, 15 } }, /* lk */
    { .label = {     48,  2, 1 } }, { .child = { 5523, 5 } }, /* lr */
    { .label = {   1013,  2, 1 } }, { .child = { 5528, 2 } }, /* ls */
    { .label = {    213,  2, 1 } }, { .child = { 5530, 2 } }, /* lt */
    { .label = {    645,  2, 1 } }, { .child = { 5532, 1 } }, /* lu */
    { .label = {   2353,  2, 1 } }, { .child = { 5533, 9 } }, /* lv */
    { .label = {   5230,  2, 1 } }, { .child = { 5542, 9 } }, /* ly */
    { .label = {    731,  2, 1 } }, { .child = { 5551, 6 } }, /* ma */
    { .label = {   7969,  2, 1 } }, { .child = { 5557, 2 } }, /* mc */
    { .label = {    139,  2, 1 } }, { .child = { 5559, 1 } }, /* md */
    { .label = {    123,  2, 1 } }, { .child = { 5560, 21 } }, /* me */
    { .label = {    586,  2, 1 } }, { .child = { 5581, 9 } }, /* mg */
    { .label = {   4719,  2, 0 } }, /* mh */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {    651,  2, 1 } }, { .child = { 5590, 8 } }, /* mk */
    { .label = {   1263,  2, 1 } }, { .child = { 5598, 7 } }, /* ml */
    { .label = {    396,  2, 1 } }, { .child = { 5605, 1 } }, /* mm */
    { .label = {    363,  2, 1 } }, { .child = { 5606, 4 } }, /* mn */
    { .label = {    221,  2, 1 } }, { .child = { 5610, 5 } }, /* mo */
    { .label = {   7413,  4, 1 } }, { .child = { 5615, 1 } }, /* mobi */
    { .label = {   4534,  2, 0 } }, /* mp */
    { .label = {  11920,  2, 0 } }, /* mq */
    { .label = {     17,  2, 1 } }, { .child = { 5616, 2 } }, /* mr */
    { .label = {    352,  2, 1 } }, { .child = { 5618, 5 } }, /* ms */
    { .label = {   1355,  2, 1 } }, { .child = { 5623, 4 } }, /* mt */
    { .label = {    117,  2, 1 } }, { .child = { 5629, 7 } }, /* mu */
    { .label = {   2922,  6, 1 } }, { .child = { 5636, 548 } }, /* museum */
    { .label = {    200,  2, 1 } }, { .child = { 6184, 14 } }, /* mv */
    { .label = {   2064,  2, 1 } }, { .child = { 6198, 11 } }, /* mw */
    { .label = {      5,  2, 1 } }, { .child = { 6209, 6 } }, /* mx */
    { .label = {   1538,  2, 1 } }, { .child = { 6215, 8 } }, /* my */
    { .label = {  15422,  2, 1 } }, { .child = { 6223, 8 } }, /* mz */
    { .label = {     89,  2, 1 } }, { .child = { 6231, 17 } }, /* na */
    { .label = {  24880,  4, 1 } }, { .child = { 6248, 2 } }, /* name */
    { .label = {    313,  2, 1 } }, { .child = { 6254, 1 } }, /* nc */
    { .label = {    203,  2, 0 } }, /* ne */
    { .label = {  13352,  3, 1 } }, { .child = { 6255, 74 } }, /* net */
    { .label = {   1195,  2, 1 } }, { .child = { 6345, 10 } }, /* nf */
    { .label = {    190,  2, 1 } }, { .child = { 6355, 10 } }, /* ng */
    { .label = {     94,  2, 1 } }, { .child = { 6367, 14 } }, /* ni */
    { .label = {    243,  2, 1 } }, { .child = { 6381, 5 } }, /* nl */
    { .label = {    154,  2, 1 } }, { .child = { 6388, 726 } }, /* no */
    { .label = {   3345,  2, 1 } }, { .child = { 7186, 1 } }, /* np */
    { .label = {    676,  2, 1 } }, { .child = { 7187, 7 } }, /* nr */
    { .label = {   1347,  2, 1 } }, { .child = { 7194, 3 } }, /* nu */
    { .label = {   1299,  2, 1 } }, { .child = { 7197, 16 } }, /* nz */
    { .label = {    113,  2, 1 } }, { .child = { 7215, 9 } }, /* om */
    { .label = {  12740,  3, 1 } }, { .child = { 7224, 88 } }, /* org */
    { .label = {    592,  2, 1 } }, { .child = { 7378, 11 } }, /* pa */
    { .label = {   1882,  2, 1 } }, { .child = { 7389, 8 } }, /* pe */
    { .label = {   3217,  2, 1 } }, { .child = { 7397, 3 } }, /* pf */
    { .label = {   1840,  2, 1 } }, { .child = { 7400, 1 } }, /* pg */
    { .label = {   1426,  2, 1 } }, { .child = { 7401, 8 } }, /* ph */
    { .label = {   4710,  2, 1 } }, { .child = { 7409, 14 } }, /* pk */
    { .label = {  12277,  2, 1 } }, { .child = { 7423, 166 } }, /* pl */
    { .label = {   2719,  2, 0 } }, /* pm */
    { .label = {   1317,  2, 1 } }, { .child = { 7637, 5 } }, /* pn */
    { .label = {    326,  4, 0 } }, /* post */
    { .label = {    436,  2, 1 } }, { .child = { 7642, 13 } }, /* pr */
    { .label = {  18846,  3, 1 } }, { .child = { 7655, 12 } }, /* pro */
    { .label = {   2320,  2, 1 } }, { .child = { 7667, 7 } }, /* ps */
    { .label = {    545,  2, 1 } }, { .child = { 7674, 9 } }, /* pt */
    { .label = {    647,  2, 1 } }, { .child = { 7683, 7 } }, /* pw */
    { .label = {   4119,  2, 1 } }, { .child = { 7690, 7 } }, /* py */
    { .label = {    441,  2, 1 } }, { .child = { 7697, 9 } }, /* qa */
    { .label = {     57,  2, 1 } }, { .child = { 7706, 4 } }, /* re */
    { .label = {    465,  2, 1 } }, { .child = { 7710, 13 } }, /* ro */
    { .label = {     50,  2, 1 } }, { .child = { 7723, 7 } }, /* rs */
    { .label = {    206,  2, 1 } }, { .child = { 7730, 131 } }, /* ru */
    { .label = {   4252,  2, 1 } }, { .child = { 7861, 9 } }, /* rw */
    { .label = {     43,  2, 1 } }, { .child = { 7870, 8 } }, /* sa */
    { .label = {    604,  2, 1 } }, { .child = { 7878, 5 } }, /* sb */
    { .label = {   3965,  2, 1 } }, { .child = { 7883, 5 } }, /* sc */
    { .label = {    500,  2, 1 } }, { .child = { 7888, 8 } }, /* sd */
    { .label = {     54,  2, 1 } }, { .child = { 7896, 41 } }, /* se */
    { .label = {    133,  2, 1 } }, { .child = { 7937, 7 } }, /* sg */
    { .label = {    191,  2, 1 } }, { .child = { 7944, 8 } }, /* sh */
    { .label = {    623,  2, 1 } }, { .child = { 7954, 1 } }, /* si */
    { .label = {   2227,  2, 0 } }, /* sj */
    { .label = {   1742,  2, 1 } }, { .child = { 7955, 1 } }, /* sk */
    { .label = {    888,  2, 1 } }, { .child = { 7956, 5 } }, /* sl */
    { .label = {   1109,  2, 0 } }, /* sm */
    { .label = {     90,  2, 1 } }, { .child = { 7961, 8 } }, /* sn */
    { .label = {    940,  2, 1 } }, { .child = { 7969, 3 } }, /* so */
    { .label = {    182,  2, 0 } }, /* sr */
    { .label = {    266,  2, 1 } }, { .child = { 7972, 12 } }, /* st */
    { .label = {    741,  2, 1 } }, { .child = { 7984, 32 } }, /* su */
    { .label = {   5105,  2, 1 } }, { .child = { 8016, 5 } }, /* sv */
    { .label = {    164,  2, 1 } }, { .child = { 8021, 1 } }, /* sx */
    { .label = {    307,  2, 1 } }, { .child = { 8022, 6 } }, /* sy */
    { .label = {    216,  2, 1 } }, { .child = { 8028, 3 } }, /* sz */
    { .label = {    877,  2, 0 } }, /* tc */
    { .label = {    184,  2, 1 } }, { .child = { 8031, 1 } }, /* td */
    { .label = {     91,  3, 0 } }, /* tel */
    { .label = {    444,  2, 0 } }, /* tf */
    { .label = {    516,  2, 0 } }, /* tg */
    { .label = {    193,  2, 1 } }, { .child = { 8032, 7 } }, /* th */
    { .label = {    990,  2, 1 } }, { .child = { 8039, 15 } }, /* tj */
    { .label = {    742,  2, 0 } }, /* tk */
    { .label = {   1198,  2, 1 } }, { .child = { 8054, 1 } }, /* tl */
    { .label = {    359,  2, 1 } }, { .child = { 8055, 8 } }, /* tm */
    { .label = {   1485,  2, 1 } }, { .child = { 8063, 20 } }, /* tn */
    { .label = {     45,  2, 1 } }, { .child = { 8083, 6 } }, /* to */
    { .label = {   1020,  2, 1 } }, { .child = { 8089, 21 } }, /* tr */
    { .label = {   7132,  6, 0 } }, /* travel */
    { .label = {    860,  2, 1 } }, { .child = { 8114, 17 } }, /* tt */
    { .label = {     55,  2, 1 } }, { .child = { 8131, 4 } }, /* tv */
    { .label = {    345,  2, 1 } }, { .child = { 8135, 14 } }, /* tw */
    { .label = {   6752,  2, 1 } }, { .child = { 8149, 12 } }, /* tz */
    { .label = {   1351,  2, 1 } }, { .child = { 8161, 79 } }, /* ua */
    { .label = {   3316,  2, 1 } }, { .child = { 8240, 9 } }, /* ug */
    { .label = {   2425,  2, 1 } }, { .child = { 8249, 11 } }, /* uk */
    { .label = {   1354,  2, 1 } }, { .child = { 8268, 68 } }, /* us */
    { .label = {   6670,  2, 1 } }, { .child = { 8555, 6 } }, /* uy */
    { .label = {   7223,  2, 1 } }, { .child = { 8563, 4 } }, /* uz */
    { .label = {    527,  2, 0 } }, /* va */
    { .label = {    177,  2, 1 } }, { .child = { 8567, 6 } }, /* vc */
    { .label = {    572,  2, 1 } }, { .child = { 8573, 17 } }, /* ve */
    { .label = {   7018,  2, 0 } }, /* vg */
    { .label = {     59,  2, 1 } }, { .child = { 8590, 5 } }, /* vi */
    { .label = {    445,  2, 1 } }, { .child = { 8595, 13 } }, /* vn */
    { .label = {   1491,  2, 1 } }, { .child = { 8608, 4 } }, /* vu */
    { .label = {  14417,  2, 0 } }, /* wf */
    { .label = {   1439,  2, 1 } }, { .child = { 8612, 7 } }, /* ws */
    { .label = {   1049,  2, 0 } }, /* yt */
    { .label = {  24436, 14, 0 } }, /* xn--mgbaam7a8h */
    { .label = {  67360, 10, 0 } }, /* xn--y9a3aq */
    { .label = {  24509, 14, 0 } }, /* xn--54b7fta0cc */
    { .label = {  84582,  9, 0 } }, /* xn--90ais */
    { .label = {  67418, 10, 0 } }, /* xn--fiqs8s */
    { .label = {  67474, 10, 0 } }, /* xn--fiqz9s */
    { .label = {  18598, 15, 0 } }, /* xn--lgbbat1ad8j */
    { .label = {  67532, 10, 0 } }, /* xn--wgbh1c */
    { .label = {  84631,  9, 0 } }, /* xn--e1a4c */
    { .label = { 103932,  8, 0 } }, /* xn--node */
    { .label = { 103969,  8, 0 } }, /* xn--qxam */
    { .label = {  52739, 11, 0 } }, /* xn--j6w193g */
    { .label = {  52815, 11, 0 } }, /* xn--h2brj9c */
    { .label = {  24593, 14, 0 } }, /* xn--mgbbh1a71e */
    { .label = {  32468, 13, 0 } }, /* xn--fpcrj9c3d */
    { .label = {  52879, 11, 0 } }, /* xn--gecrj9c */
    { .label = {  52938, 11, 0 } }, /* xn--s9brj9c */
    { .label = {  53001, 11, 0 } }, /* xn--45brj9c */
    { .label = {   8993, 17, 0 } }, /* xn--xkc2dl3a5ee0h */
    { .label = {  14337, 15, 0 } }, /* xn--mgba3a4f16a */
    { .label = {  20494, 14, 0 } }, /* xn--mgba3a4fra */
    { .label = {  53069, 11, 0 } }, /* xn--mgbtx2b */
    { .label = {  24670, 14, 0 } }, /* xn--mgbayh7gpa */
    { .label = {  42238, 12, 0 } }, /* xn--3e0b707e */
    { .label = {  53128, 11, 0 } }, /* xn--80ao21a */
    { .label = {  32544, 13, 0 } }, /* xn--fzc2c9e2c */
    { .label = {  12784, 16, 0 } }, /* xn--xkc2al3hye2a */
    { .label = {  18678, 15, 0 } }, /* xn--mgbc0a9azcg */
    { .label = {  84680,  9, 0 } }, /* xn--d1alf */
    { .label = {  84727,  9, 0 } }, /* xn--l1acc */
    { .label = {  53194, 11, 0 } }, /* xn--mix891f */
    { .label = {  53262, 11, 0 } }, /* xn--mix082f */
    { .label = {  24742, 14, 0 } }, /* xn--mgbx4cd0ab */
    { .label = {  42316, 12, 0 } }, /* xn--mgb9awbf */
    { .label = {   9091, 17, 0 } }, /* xn--mgbai9azgqp6j */
    { .label = {   6954, 18, 0 } }, /* xn--mgbai9a5eva00b */
    { .label = {  32623, 13, 0 } }, /* xn--ygbi2ammx */
    { .label = {  67587, 10, 1 } }, { .child = { 8619, 6 } }, /* xn--90a3ac */
    { .label = { 104098,  8, 0 } }, /* xn--p1ai */
    { .label = {  67645, 10, 0 } }, /* xn--wgbl6a */
    { .label = {   9189, 17, 0 } }, /* xn--mgberp4a5d4ar */
    { .label = {   5076, 19, 0 } }, /* xn--mgberp4a5d4a87g */
    { .label = {   5187, 19, 0 } }, /* xn--mgbqly7c0a67fbc */
    { .label = {  12873, 16, 0 } }, /* xn--mgbqly7cvafr */
    { .label = {  42381, 12, 0 } }, /* xn--mgbpl2fh */
    { .label = {  32691, 13, 0 } }, /* xn--yfro4i67o */
    { .label = {   1177, 22, 0 } }, /* xn--clchc0ea0b2g2a9gcd */
    { .label = {  42447, 12, 0 } }, /* xn--ogbpf8fl */
    { .label = {  42514, 12, 0 } }, /* xn--mgbtf8fl */
    { .label = {  67701, 10, 0 } }, /* xn--o3cw4h */
    { .label = {  53331, 11, 0 } }, /* xn--pgbs0dh */
    { .label = {  53390, 11, 0 } }, /* xn--kpry57d */
    { .label = {  53454, 11, 0 } }, /* xn--kprw13d */
    { .label = {  53518, 11, 0 } }, /* xn--nnx388a */
    { .label = {  84918,  9, 0 } }, /* xn--j1amh */
    { .label = {  42580, 12, 0 } }, /* xn--mgb2ddes */
    { .label = {  32016,  3, 0 } }, /* xxx */
    { .label = {    460,  2, 1 } }, { .child = { 8625, 1 } }, /* ye */
    { .label = {    395,  2, 1 } }, { .child = { 8626, 17 } }, /* za */
    { .label = {    116,  2, 1 } }, { .child = { 8645, 11 } }, /* zm */
    { .label = {  31299,  2, 1 } }, { .child = { 8656, 1 } }, /* zw */
    { .label = {   1350,  3, 0 } }, /* aaa */
    { .label = { 156846,  4, 0 } }, /* aarp */
    { .label = { 141087,  6, 0 } }, /* abarth */
    { .label = {  39422,  3, 0 } }, /* abb */
    { .label = { 141111,  6, 0 } }, /* abbott */
    { .label = { 141136,  6, 0 } }, /* abbvie */
    { .label = {   1322,  3, 0 } }, /* abc */
    { .label = {   5452,  4, 0 } }, /* able */
    { .label = { 122241,  7, 0 } }, /* abogado */
    { .label = { 104139,  8, 0 } }, /* abudhabi */
    { .label = { 116040,  7, 0 } }, /* academy */
    { .label = {  84966,  9, 0 } }, /* accenture */
    { .label = {  13597, 10, 0 } }, /* accountant */
    { .label = {  53584, 11, 0 } }, /* accountants */
    { .label = {   2669,  3, 0 } }, /* aco */
    { .label = {  10379,  6, 0 } }, /* active */
    { .label = {  53895,  5, 0 } }, /* actor */
    { .label = { 130389,  4, 0 } }, /* adac */
    { .label = {  16269,  3, 0 } }, /* ads */
    { .label = { 145031,  5, 0 } }, /* adult */
    { .label = {   1527,  3, 0 } }, /* aeg */
    { .label = { 152213,  5, 0 } }, /* aetna */
    { .label = {  24819, 14, 0 } }, /* afamilycompany */
    { .label = {  51232,  3, 0 } }, /* afl */
    { .label = {  63876,  6, 0 } }, /* africa */
    { .label = { 122270,  7, 0 } }, /* agakhan */
    { .label = { 141163,  6, 0 } }, /* agency */
    { .label = {   3532,  3, 0 } }, /* aig */
    { .label = {  99070,  4, 0 } }, /* aigo */
    { .label = { 141190,  6, 0 } }, /* airbus */
    { .label = { 104174,  8, 0 } }, /* airforce */
    { .label = { 141215,  6, 0 } }, /* airtel */
    { .label = { 156862,  4, 0 } }, /* akdn */
    { .label = {  85004,  9, 0 } }, /* alfaromeo */
    { .label = { 122298,  7, 0 } }, /* alibaba */
    { .label = { 141239,  6, 0 } }, /* alipay */
    { .label = {  85042,  9, 0 } }, /* allfinanz */
    { .label = { 104208,  8, 0 } }, /* allstate */
    { .label = { 156879,  4, 0 } }, /* ally */
    { .label = { 141266,  6, 0 } }, /* alsace */
    { .label = { 141290,  6, 0 } }, /* alstom */
    { .label = {  18759, 15, 0 } }, /* americanexpress */
    { .label = {  24884, 14, 0 } }, /* americanfamily */
    { .label = {  79807,  4, 0 } }, /* amex */
    { .label = { 152231,  5, 0 } }, /* amfam */
    { .label = { 152253,  5, 0 } }, /* amica */
    { .label = {  78469,  9, 0 } }, /* amsterdam */
    { .label = {  85083,  9, 0 } }, /* analytics */
    { .label = { 122326,  7, 0 } }, /* android */
    { .label = { 141315,  6, 0 } }, /* anquan */
    { .label = {   1911,  3, 0 } }, /* anz */
    { .label = {   1878,  3, 0 } }, /* aol */
    { .label = {  67760, 10, 0 } }, /* apartments */
    { .label = {   4293,  3, 0 } }, /* app */
    { .label = { 152273,  5, 0 } }, /* apple */
    { .label = {  85121,  9, 0 } }, /* aquarelle */
    { .label = { 122234,  4, 0 } }, /* arab */
    { .label = { 141342,  6, 0 } }, /* aramco */
    { .label = {  20059,  5, 0 } }, /* archi */
    { .label = {  30738,  4, 0 } }, /* army */
    { .label = {   7810,  3, 0 } }, /* art */
    { .label = {  13791,  4, 0 } }, /* arte */
    { .label = {  27306,  4, 0 } }, /* asda */
    { .label = {  67801, 10, 0 } }, /* associates */
    { .label = { 122355,  7, 0 } }, /* athleta */
    { .label = { 104240,  8, 0 } }, /* attorney */
    { .label = { 122383,  7, 0 } }, /* auction */
    { .label = { 122412,  4, 0 } }, /* audi */
    { .label = { 122412,  7, 0 } }, /* audible */
    { .label = { 152297,  5, 0 } }, /* audio */
    { .label = { 122443,  7, 0 } }, /* auspost */
    { .label = { 128669,  6, 0 } }, /* author */
    { .label = {  63476,  4, 0 } }, /* auto */
    { .label = { 152318,  5, 0 } }, /* autos */
    { .label = { 122473,  7, 0 } }, /* avianca */
    { .label = {  63233,  3, 0 } }, /* aws */
    { .label = {  10561,  3, 0 } }, /* axa */
    { .label = {  33510,  5, 0 } }, /* azure */
    { .label = { 156898,  4, 0 } }, /* baby */
    { .label = { 152338,  5, 0 } }, /* baidu */
    { .label = { 122501,  7, 0 } }, /* banamex */
    { .label = {  24945, 14, 0 } }, /* bananarepublic */
    { .label = {  20139,  4, 0 } }, /* band */
    { .label = {  86482,  4, 0 } }, /* bank */
    { .label = {   1610,  3, 0 } }, /* bar */
    { .label = {  78728,  9, 0 } }, /* barcelona */
    { .label = {  53629, 11, 0 } }, /* barclaycard */
    { .label = { 104273,  8, 0 } }, /* barclays */
    { .label = { 104308,  8, 0 } }, /* barefoot */
    { .label = { 104342,  8, 0 } }, /* bargains */
    { .label = {  97604,  8, 0 } }, /* baseball */
    { .label = {  67840, 10, 0 } }, /* basketball */
    { .label = { 122531,  7, 0 } }, /* bauhaus */
    { .label = { 141366,  6, 0 } }, /* bayern */
    { .label = { 156915,  3, 0 } }, /* bbc */
    { .label = { 156916,  3, 0 } }, /* bbt */
    { .label = { 156917,  4, 0 } }, /* bbva */
    { .label = {  78800,  3, 0 } }, /* bcg */
    { .label = {  67837,  3, 0 } }, /* bcn */
    { .label = { 152360,  5, 0 } }, /* beats */
    { .label = { 141392,  6, 0 } }, /* beauty */
    { .label = {  42854,  4, 0 } }, /* beer */
    { .label = { 122561,  7, 0 } }, /* bentley */
    { .label = { 136028,  6, 0 } }, /* berlin */
    { .label = { 119019,  4, 0 } }, /* best */
    { .label = { 122593,  7, 0 } }, /* bestbuy */
    { .label = {  25582,  3, 0 } }, /* bet */
    { .label = { 141419,  6, 0 } }, /* bharti */
    { .label = { 148887,  5, 0 } }, /* bible */
    { .label = {  30340,  3, 0 } }, /* bid */
    { .label = { 156936,  4, 0 } }, /* bike */
    { .label = { 106125,  4, 0 } }, /* bing */
    { .label = { 152380,  5, 0 } }, /* bingo */
    { .label = {   1329,  3, 0 } }, /* bio */
    { .label = {  53677,  5, 0 } }, /* black */
    { .label = {  53677, 11, 0 } }, /* blackfriday */
    { .label = { 141444,  6, 0 } }, /* blanco */
    { .label = {  53728, 11, 0 } }, /* blockbuster */
    { .label = {  13399,  4, 0 } }, /* blog */
    { .label = {  85162,  9, 0 } }, /* bloomberg */
    { .label = { 156954,  4, 0 } }, /* blue */
    { .label = {  11367,  3, 0 } }, /* bms */
    { .label = { 158644,  3, 0 } }, /* bmw */
    { .label = {  32865,  3, 0 } }, /* bnl */
    { .label = {  67883, 10, 0 } }, /* bnpparibas */
    { .label = { 152402,  5, 0 } }, /* boats */
    { .label = {  67927, 10, 0 } }, /* boehringer */
    { .label = { 156973,  4, 0 } }, /* bofa */
    { .label = {   7063,  3, 0 } }, /* bom */
    { .label = { 156991,  4, 0 } }, /* bond */
    { .label = {   4212,  3, 0 } }, /* boo */
    { .label = {  19720,  4, 0 } }, /* book */
    { .label = { 122626,  7, 0 } }, /* booking */
    { .label = { 152422,  5, 0 } }, /* boots */
    { .label = { 152443,  5, 0 } }, /* bosch */
    { .label = { 141470,  6, 0 } }, /* bostik */
    { .label = { 136080,  6, 0 } }, /* boston */
    { .label = {  15599,  3, 0 } }, /* bot */
    { .label = { 104374,  8, 0 } }, /* boutique */
    { .label = {  19341,  3, 0 } }, /* box */
    { .label = { 104413,  8, 0 } }, /* bradesco */
    { .label = {  53778, 11, 0 } }, /* bridgestone */
    { .label = { 104447,  8, 0 } }, /* broadway */
    { .label = { 128694,  6, 0 } }, /* broker */
    { .label = { 122657,  7, 0 } }, /* brother */
    { .label = {  97713,  8, 0 } }, /* brussels */
    { .label = { 104484,  8, 0 } }, /* budapest */
    { .label = { 122687,  7, 0 } }, /* bugatti */
    { .label = {  97748,  5, 0 } }, /* build */
    { .label = { 104520,  8, 0 } }, /* builders */
    { .label = { 104556,  8, 0 } }, /* business */
    { .label = {  59264,  3, 0 } }, /* buy */
    { .label = { 157009,  4, 0 } }, /* buzz */
    { .label = {  13192,  3, 0 } }, /* bzh */
    { .label = {   5447,  3, 0 } }, /* cab */
    { .label = { 117527,  4, 0 } }, /* cafe */
    { .label = {    217,  3, 0 } }, /* cal */
    { .label = {  70578,  4, 0 } }, /* call */
    { .label = {  53825, 11, 0 } }, /* calvinklein */
    { .label = {   8692,  3, 0 } }, /* cam */
    { .label = {  14031,  6, 0 } }, /* camera */
    { .label = {  14878,  4, 0 } }, /* camp */
    { .label = {  25005, 14, 0 } }, /* cancerresearch */
    { .label = { 152466,  5, 0 } }, /* canon */
    { .label = { 104590,  8, 0 } }, /* capetown */
    { .label = {  67970,  7, 0 } }, /* capital */
    { .label = {  67970, 10, 0 } }, /* capitalone */
    { .label = {   7391,  3, 0 } }, /* car */
    { .label = { 122717,  7, 0 } }, /* caravan */
    { .label = { 152486,  5, 0 } }, /* cards */
    { .label = {  10325,  4, 0 } }, /* care */
    { .label = { 122745,  6, 0 } }, /* career */
    { .label = { 122745,  7, 0 } }, /* careers */
    { .label = {  44594,  4, 0 } }, /* cars */
    { .label = { 122773,  7, 0 } }, /* cartier */
    { .label = {  21842,  4, 0 } }, /* casa */
    { .label = { 109410,  4, 0 } }, /* case */
    { .label = { 141496,  6, 0 } }, /* caseih */
    { .label = {  36151,  4, 0 } }, /* cash */
    { .label = { 128821,  6, 0 } }, /* casino */
    { .label = {  88392,  8, 0 } }, /* catering */
    { .label = { 104627,  8, 0 } }, /* catholic */
    { .label = {   2279,  3, 0 } }, /* cba */
    { .label = { 158661,  3, 0 } }, /* cbn */
    { .label = { 157033,  4, 0 } }, /* cbre */
    { .label = {   9677,  3, 0 } }, /* cbs */
    { .label = {   7198,  3, 0 } }, /* ceb */
    { .label = {  22055,  6, 0 } }, /* center */
    { .label = {  21851,  3, 0 } }, /* ceo */
    { .label = {   7088,  4, 0 } }, /* cern */
    { .label = {   1900,  3, 0 } }, /* cfa */
    { .label = {  53780,  3, 0 } }, /* cfd */
    { .label = { 141521,  6, 0 } }, /* chanel */
    { .label = {  25094,  7, 0 } }, /* channel */
    { .label = { 152507,  5, 0 } }, /* chase */
    { .label = {  49822,  4, 0 } }, /* chat */
    { .label = { 152528,  5, 0 } }, /* cheap */
    { .label = { 122801,  7, 0 } }, /* chintai */
    { .label = { 152551,  5, 0 } }, /* chloe */
    { .label = {  85203,  9, 0 } }, /* christmas */
    { .label = { 141547,  6, 0 } }, /* chrome */
    { .label = { 104662,  8, 0 } }, /* chrysler */
    { .label = { 141574,  6, 0 } }, /* church */
    { .label = { 104699,  8, 0 } }, /* cipriani */
    { .label = { 141603,  6, 0 } }, /* circle */
    { .label = {  38616,  5, 0 } }, /* cisco */
    { .label = { 122830,  7, 0 } }, /* citadel */
    { .label = { 152574,  4, 0 } }, /* citi */
    { .label = { 152574,  5, 0 } }, /* citic */
    { .label = { 104733,  4, 0 } }, /* city */
    { .label = { 104733,  8, 0 } }, /* cityeats */
    { .label = { 141630,  6, 0 } }, /* claims */
    { .label = { 104767,  8, 0 } }, /* cleaning */
    { .label = { 152596,  5, 0 } }, /* click */
    { .label = { 141656,  6, 0 } }, /* clinic */
    { .label = { 104801,  8, 0 } }, /* clinique */
    { .label = { 104840,  8, 0 } }, /* clothing */
    { .label = {   1330,  5, 1 } }, { .child = { 8657, 2 } }, /* cloud */
    { .label = {  88339,  4, 1 } }, { .child = { 8661, 1 } }, /* club */
    { .label = { 122860,  7, 0 } }, /* clubmed */
    { .label = { 152620,  5, 0 } }, /* coach */
    { .label = { 107751,  5, 0 } }, /* codes */
    { .label = { 141683,  6, 0 } }, /* coffee */
    { .label = {  45028,  7, 0 } }, /* college */
    { .label = { 122894,  7, 0 } }, /* cologne */
    { .label = { 122925,  7, 0 } }, /* comcast */
    { .label = { 104876,  8, 0 } }, /* commbank */
    { .label = {  78961,  9, 0 } }, /* community */
    { .label = {  24851,  7, 0 } }, /* company */
    { .label = { 122955,  7, 0 } }, /* compare */
    { .label = {  15856,  8, 0 } }, /* computer */
    { .label = { 141712,  6, 0 } }, /* comsec */
    { .label = { 141739,  6, 0 } }, /* condos */
    { .label = {  42642, 12, 0 } }, /* construction */
    { .label = {  59096, 10, 0 } }, /* consulting */
    { .label = { 122986,  7, 0 } }, /* contact */
    { .label = {  53874, 11, 0 } }, /* contractors */
    { .label = {  25063,  7, 0 } }, /* cooking */
    { .label = {  25063, 14, 0 } }, /* cookingchannel */
    { .label = { 154386,  4, 0 } }, /* cool */
    { .label = { 123015,  7, 0 } }, /* corsica */
    { .label = {  16329,  7, 0 } }, /* country */
    { .label = { 123044,  6, 0 } }, /* coupon */
    { .label = { 123044,  7, 0 } }, /* coupons */
    { .label = { 123076,  7, 0 } }, /* courses */
    { .label = {  53919,  6, 0 } }, /* credit */
    { .label = {  68012, 10, 0 } }, /* creditcard */
    { .label = {  53919, 11, 0 } }, /* creditunion */
    { .label = { 123106,  7, 0 } }, /* cricket */
    { .label = { 152642,  5, 0 } }, /* crown */
    { .label = {  33132,  3, 0 } }, /* crs */
    { .label = { 123137,  6, 0 } }, /* cruise */
    { .label = { 123137,  7, 0 } }, /* cruises */
    { .label = {  25689,  3, 0 } }, /* csc */
    { .label = {  68055, 10, 0 } }, /* cuisinella */
    { .label = { 148934,  5, 0 } }, /* cymru */
    { .label = { 157051,  4, 0 } }, /* cyou */
    { .label = { 152666,  5, 0 } }, /* dabur */
    { .label = {  92903,  3, 0 } }, /* dad */
    { .label = { 152688,  5, 0 } }, /* dance */
    { .label = {  69914,  4, 0 } }, /* data */
    { .label = {  26407,  4, 0 } }, /* date */
    { .label = { 141765,  6, 0 } }, /* dating */
    { .label = { 141790,  6, 0 } }, /* datsun */
    { .label = {   2092,  3, 0 } }, /* day */
    { .label = { 157071,  4, 0 } }, /* dclk */
    { .label = {  75165,  3, 0 } }, /* dds */
    { .label = { 138321,  4, 0 } }, /* deal */
    { .label = { 141815,  6, 0 } }, /* dealer */
    { .label = { 152709,  5, 0 } }, /* deals */
    { .label = { 141840,  6, 0 } }, /* degree */
    { .label = { 104912,  8, 0 } }, /* delivery */
    { .label = {   1871,  4, 0 } }, /* dell */
    { .label = { 104950,  8, 0 } }, /* deloitte */
    { .label = { 152730,  5, 0 } }, /* delta */
    { .label = {  33902,  8, 0 } }, /* democrat */
    { .label = { 141866,  6, 0 } }, /* dental */
    { .label = {    245,  7, 0 } }, /* dentist */
    { .label = {  22237,  4, 0 } }, /* desi */
    { .label = {  22237,  6, 0 } }, /* design */
    { .label = {   7012,  3, 0 } }, /* dev */
    { .label = {    319,  3, 0 } }, /* dhl */
    { .label = { 104984,  8, 0 } }, /* diamonds */
    { .label = {  31966,  4, 0 } }, /* diet */
    { .label = { 123167,  7, 0 } }, /* digital */
    { .label = {  10405,  6, 0 } }, /* direct */
    { .label = {  10405,  9, 0 } }, /* directory */
    { .label = { 105018,  8, 0 } }, /* discount */
    { .label = {  79041,  8, 0 } }, /* discover */
    { .label = { 157091,  4, 0 } }, /* dish */
    { .label = {  23572,  3, 0 } }, /* diy */
    { .label = { 131388,  3, 0 } }, /* dnp */
    { .label = { 157109,  4, 0 } }, /* docs */
    { .label = {  57663,  6, 0 } }, /* doctor */
    { .label = { 152751,  5, 0 } }, /* dodge */
    { .label = {  15303,  3, 0 } }, /* dog */
    { .label = { 157127,  4, 0 } }, /* doha */
    { .label = { 123197,  7, 0 } }, /* domains */
    { .label = {  38631,  3, 0 } }, /* dot */
    { .label = { 105053,  8, 0 } }, /* download */
    { .label = { 152774,  5, 0 } }, /* drive */
    { .label = {  12932,  3, 0 } }, /* dtv */
    { .label = { 152797,  5, 0 } }, /* dubai */
    { .label = { 125992,  4, 0 } }, /* duck */
    { .label = { 141891,  6, 0 } }, /* dunlop */
    { .label = { 157144,  4, 0 } }, /* duns */
    { .label = { 141920,  6, 0 } }, /* dupont */
    { .label = { 141948,  6, 0 } }, /* durban */
    { .label = { 157162,  4, 0 } }, /* dvag */
    { .label = {  27089,  3, 0 } }, /* dvr */
    { .label = { 158675,  3, 0 } }, /* dwg */
    { .label = {  77554,  5, 0 } }, /* earth */
    { .label = {    529,  3, 0 } }, /* eat */
    { .label = {    104,  3, 0 } }, /* eco */
    { .label = { 152819,  5, 0 } }, /* edeka */
    { .label = {  37716,  9, 0 } }, /* education */
    { .label = {  34751,  5, 0 } }, /* email */
    { .label = { 141974,  6, 0 } }, /* emerck */
    { .label = { 123226,  7, 0 } }, /* emerson */
    { .label = { 142001,  6, 0 } }, /* energy */
    { .label = {  26622,  8, 0 } }, /* engineer */
    { .label = {  53966, 11, 0 } }, /* engineering */
    { .label = {  54012, 11, 0 } }, /* enterprises */
    { .label = {    322,  5, 0 } }, /* epost */
    { .label = { 152840,  5, 0 } }, /* epson */
    { .label = {  29510,  9, 0 } }, /* equipment */
    { .label = { 105090,  8, 0 } }, /* ericsson */
    { .label = {  67149,  4, 0 } }, /* erni */
    { .label = { 158692,  3, 0 } }, /* esq */
    { .label = {  16361,  6, 1 } }, { .child = { 8662, 1 } }, /* estate */
    { .label = { 105123,  8, 0 } }, /* esurance */
    { .label = { 105156,  8, 0 } }, /* etisalat */
    { .label = {  68098, 10, 0 } }, /* eurovision */
    { .label = {  16224,  3, 0 } }, /* eus */
    { .label = { 142028,  6, 0 } }, /* events */
    { .label = { 105187,  8, 0 } }, /* everbank */
    { .label = {  34922,  8, 0 } }, /* exchange */
    { .label = {   5391,  6, 0 } }, /* expert */
    { .label = { 123255,  7, 0 } }, /* exposed */
    { .label = {  18791,  7, 0 } }, /* express */
    { .label = {  68141, 10, 0 } }, /* extraspace */
    { .label = { 157181,  4, 0 } }, /* fage */
    { .label = { 157199,  4, 0 } }, /* fail */
    { .label = {  85241,  9, 0 } }, /* fairwinds */
    { .label = { 152862,  5, 0 } }, /* faith */
    { .label = {  24822,  6, 0 } }, /* family */
    { .label = {   1660,  3, 0 } }, /* fan */
    { .label = { 157217,  4, 0 } }, /* fans */
    { .label = {  29492,  4, 0 } }, /* farm */
    { .label = { 116643,  7, 0 } }, /* farmers */
    { .label = { 123288,  7, 0 } }, /* fashion */
    { .label = {  84030,  4, 0 } }, /* fast */
    { .label = { 152884,  5, 0 } }, /* fedex */
    { .label = { 105222,  8, 0 } }, /* feedback */
    { .label = { 123318,  7, 0 } }, /* ferrari */
    { .label = { 123347,  7, 0 } }, /* ferrero */
    { .label = { 149163,  4, 0 } }, /* fiat */
    { .label = { 105259,  8, 0 } }, /* fidelity */
    { .label = { 153506,  4, 0 } }, /* fido */
    { .label = {  78146,  4, 0 } }, /* film */
    { .label = { 152909,  5, 0 } }, /* final */
    { .label = { 123377,  7, 0 } }, /* finance */
    { .label = {   2422,  9, 0 } }, /* financial */
    { .label = {  11665,  4, 0 } }, /* fire */
    { .label = {  85282,  9, 0 } }, /* firestone */
    { .label = { 105297,  8, 0 } }, /* firmdale */
    { .label = { 123407,  4, 0 } }, /* fish */
    { .label = { 123407,  7, 0 } }, /* fishing */
    { .label = {  63723,  3, 1 } }, { .child = { 8665, 1 } }, /* fit */
    { .label = { 123439,  7, 0 } }, /* fitness */
    { .label = { 142054,  6, 0 } }, /* flickr */
    { .label = { 123469,  7, 0 } }, /* flights */
    { .label = { 157234,  4, 0 } }, /* flir */
    { .label = { 123502,  7, 0 } }, /* florist */
    { .label = { 123533,  7, 0 } }, /* flowers */
    { .label = { 107602,  3, 0 } }, /* fly */
    { .label = {  54058,  3, 0 } }, /* foo */
    { .label = {  54058,  4, 0 } }, /* food */
    { .label = {  54058, 11, 0 } }, /* foodnetwork */
    { .label = { 105333,  8, 0 } }, /* football */
    { .label = {     96,  4, 0 } }, /* ford */
    { .label = { 152931,  5, 0 } }, /* forex */
    { .label = { 123567,  7, 0 } }, /* forsale */
    { .label = { 145072,  5, 0 } }, /* forum */
    { .label = {  64081, 10, 0 } }, /* foundation */
    { .label = { 158708,  3, 0 } }, /* fox */
    { .label = {  50006,  4, 0 } }, /* free */
    { .label = {  85320,  9, 0 } }, /* fresenius */
    { .label = { 158724,  3, 0 } }, /* frl */
    { .label = { 123597,  7, 0 } }, /* frogans */
    { .label = {  85359,  9, 0 } }, /* frontdoor */
    { .label = { 105369,  8, 0 } }, /* frontier */
    { .label = { 107791,  3, 0 } }, /* ftr */
    { .label = { 123627,  7, 0 } }, /* fujitsu */
    { .label = {  85398,  9, 0 } }, /* fujixerox */
    { .label = {  26870,  3, 0 } }, /* fun */
    { .label = {  98282,  4, 0 } }, /* fund */
    { .label = {  79392,  9, 0 } }, /* furniture */
    { .label = { 142083,  6, 0 } }, /* futbol */
    { .label = {  53942,  3, 0 } }, /* fyi */
    { .label = {  21286,  3, 0 } }, /* gal */
    { .label = {  63444,  7, 0 } }, /* gallery */
    { .label = { 152955,  5, 0 } }, /* gallo */
    { .label = { 142112,  6, 0 } }, /* gallup */
    { .label = {  15283,  4, 0 } }, /* game */
    { .label = {  34241,  5, 0 } }, /* games */
    { .label = {  19415,  3, 0 } }, /* gap */
    { .label = {  15636,  6, 0 } }, /* garden */
    { .label = { 157253,  4, 0 } }, /* gbiz */
    { .label = {  20844,  3, 0 } }, /* gdn */
    { .label = {  11748,  3, 0 } }, /* gea */
    { .label = {  54007,  4, 0 } }, /* gent */
    { .label = { 123662,  7, 0 } }, /* genting */
    { .label = { 142141,  6, 0 } }, /* george */
    { .label = { 145335,  4, 0 } }, /* ggee */
    { .label = { 152977,  4, 0 } }, /* gift */
    { .label = { 152977,  5, 0 } }, /* gifts */
    { .label = { 153000,  5, 0 } }, /* gives */
    { .label = { 142167,  6, 0 } }, /* giving */
    { .label = { 153023,  5, 0 } }, /* glade */
    { .label = { 149028,  5, 0 } }, /* glass */
    { .label = {   4813,  3, 0 } }, /* gle */
    { .label = { 142195,  6, 0 } }, /* global */
    { .label = { 153045,  5, 0 } }, /* globo */
    { .label = { 153068,  5, 0 } }, /* gmail */
    { .label = { 157274,  4, 0 } }, /* gmbh */
    { .label = {   5118,  3, 0 } }, /* gmo */
    { .label = {  13049,  3, 0 } }, /* gmx */
    { .label = { 123692,  7, 0 } }, /* godaddy */
    { .label = {  85444,  4, 0 } }, /* gold */
    { .label = {  85444,  9, 0 } }, /* goldpoint */
    { .label = { 128352,  4, 0 } }, /* golf */
    { .label = {  18460,  3, 0 } }, /* goo */
    { .label = {  85485,  9, 0 } }, /* goodhands */
    { .label = { 105403,  8, 0 } }, /* goodyear */
    { .label = {  70960,  4, 0 } }, /* goog */
    { .label = {  70960,  6, 0 } }, /* google */
    { .label = {  52271,  3, 0 } }, /* gop */
    { .label = {  26457,  3, 0 } }, /* got */
    { .label = { 105438,  8, 0 } }, /* grainger */
    { .label = {  29691,  8, 0 } }, /* graphics */
    { .label = { 142222,  6, 0 } }, /* gratis */
    { .label = {  70404,  5, 0 } }, /* green */
    { .label = { 153090,  5, 0 } }, /* gripe */
    { .label = { 123725,  7, 0 } }, /* grocery */
    { .label = {  35225,  5, 0 } }, /* group */
    { .label = {  54606,  8, 0 } }, /* guardian */
    { .label = { 153113,  5, 0 } }, /* gucci */
    { .label = { 157294,  4, 0 } }, /* guge */
    { .label = { 153137,  5, 0 } }, /* guide */
    { .label = { 123757,  7, 0 } }, /* guitars */
    { .label = {  87530,  4, 0 } }, /* guru */
    { .label = {  17202,  4, 0 } }, /* hair */
    { .label = { 116826,  7, 0 } }, /* hamburg */
    { .label = { 123786,  7, 0 } }, /* hangout */
    { .label = { 122544,  4, 0 } }, /* haus */
    { .label = {  15594,  3, 0 } }, /* hbo */
    { .label = { 105471,  4, 0 } }, /* hdfc */
    { .label = { 105471,  8, 0 } }, /* hdfcbank */
    { .label = {    707,  6, 0 } }, /* health */
    { .label = {  68184, 10, 0 } }, /* healthcare */
    { .label = { 157313,  4, 0 } }, /* help */
    { .label = {  98354,  8, 0 } }, /* helsinki */
    { .label = {   7274,  4, 0 } }, /* here */
    { .label = { 142246,  6, 0 } }, /* hermes */
    { .label = { 157333,  4, 0 } }, /* hgtv */
    { .label = { 142272,  6, 0 } }, /* hiphop */
    { .label = {  85524,  9, 0 } }, /* hisamitsu */
    { .label = {  36642,  7, 0 } }, /* hitachi */
    { .label = {  30538,  3, 0 } }, /* hiv */
    { .label = { 136549,  3, 0 } }, /* hkt */
    { .label = {  34339,  6, 0 } }, /* hockey */
    { .label = { 105509,  8, 0 } }, /* holdings */
    { .label = { 123816,  7, 0 } }, /* holiday */
    { .label = {  85562,  9, 0 } }, /* homedepot */
    { .label = {  85603,  9, 0 } }, /* homegoods */
    { .label = {  20156,  5, 0 } }, /* homes */
    { .label = {  85643,  9, 0 } }, /* homesense */
    { .label = { 153160,  5, 0 } }, /* honda */
    { .label = {  85681,  9, 0 } }, /* honeywell */
    { .label = { 153181,  5, 0 } }, /* horse */
    { .label = {  43969,  4, 0 } }, /* host */
    { .label = { 123848,  7, 1 } }, { .child = { 8666, 1 } }, /* hosting */
    { .label = {  10104,  3, 0 } }, /* hot */
    { .label = { 123878,  7, 0 } }, /* hoteles */
    { .label = {  54179,  6, 0 } }, /* hotels */
    { .label = { 123908,  7, 0 } }, /* hotmail */
    { .label = {  22175,  5, 0 } }, /* house */
    { .label = {  41966,  3, 0 } }, /* how */
    { .label = { 157353,  4, 0 } }, /* hsbc */
    { .label = { 107742,  3, 0 } }, /* htc */
    { .label = { 142302,  6, 0 } }, /* hughes */
    { .label = { 153202,  5, 0 } }, /* hyatt */
    { .label = { 123938,  7, 0 } }, /* hyundai */
    { .label = {   4645,  3, 0 } }, /* ibm */
    { .label = { 157372,  4, 0 } }, /* icbc */
    { .label = {   1132,  3, 0 } }, /* ice */
    { .label = {  49695,  3, 0 } }, /* icu */
    { .label = { 120512,  4, 0 } }, /* ieee */
    { .label = {  61042,  3, 0 } }, /* ifm */
    { .label = { 153224,  5, 0 } }, /* iinet */
    { .label = { 132493,  5, 0 } }, /* ikano */
    { .label = { 142330,  6, 0 } }, /* imamat */
    { .label = {  78677,  4, 0 } }, /* imdb */
    { .label = {  68226,  4, 0 } }, /* immo */
    { .label = {  68226, 10, 0 } }, /* immobilien */
    { .label = {  68270, 10, 0 } }, /* industries */
    { .label = { 105545,  8, 0 } }, /* infiniti */
    { .label = {   7246,  3, 0 } }, /* ing */
    { .label = {  29560,  3, 0 } }, /* ink */
    { .label = {  85725,  9, 0 } }, /* institute */
    { .label = {    733,  9, 0 } }, /* insurance */
    { .label = { 142354,  6, 0 } }, /* insure */
    { .label = {  38222,  5, 0 } }, /* intel */
    { .label = {  32768, 13, 0 } }, /* international */
    { .label = { 142379,  6, 0 } }, /* intuit */
    { .label = {  54109, 11, 0 } }, /* investments */
    { .label = { 105579,  8, 0 } }, /* ipiranga */
    { .label = { 153244,  5, 0 } }, /* irish */
    { .label = { 123970,  7, 0 } }, /* iselect */
    { .label = { 124000,  7, 0 } }, /* ismaili */
    { .label = {    262,  3, 0 } }, /* ist */
    { .label = { 105612,  8, 0 } }, /* istanbul */
    { .label = {  26625,  4, 0 } }, /* itau */
    { .label = { 124783,  3, 0 } }, /* itv */
    { .label = { 153265,  5, 0 } }, /* iveco */
    { .label = {  93291,  3, 0 } }, /* iwc */
    { .label = { 142404,  6, 0 } }, /* jaguar */
    { .label = {  27419,  4, 0 } }, /* java */
    { .label = { 158739,  3, 0 } }, /* jcb */
    { .label = { 158756,  3, 0 } }, /* jcp */
    { .label = { 157391,  4, 0 } }, /* jeep */
    { .label = { 153288,  5, 0 } }, /* jetzt */
    { .label = { 116918,  7, 0 } }, /* jewelry */
    { .label = {  43959,  3, 0 } }, /* jio */
    { .label = {  13785,  3, 0 } }, /* jlc */
    { .label = {  51485,  3, 0 } }, /* jll */
    { .label = { 158774,  3, 0 } }, /* jmp */
    { .label = {  73652,  3, 0 } }, /* jnj */
    { .label = { 142431,  6, 0 } }, /* joburg */
    { .label = {  61787,  3, 0 } }, /* jot */
    { .label = { 134071,  3, 0 } }, /* joy */
    { .label = { 105646,  8, 0 } }, /* jpmorgan */
    { .label = { 157412,  4, 0 } }, /* jprs */
    { .label = { 142461,  6, 0 } }, /* juegos */
    { .label = { 124029,  7, 0 } }, /* juniper */
    { .label = { 142490,  6, 0 } }, /* kaufen */
    { .label = {   7990,  4, 0 } }, /* kddi */
    { .label = {  54156, 11, 0 } }, /* kerryhotels */
    { .label = {  25124, 14, 0 } }, /* kerrylogistics */
    { .label = {  18823, 15, 0 } }, /* kerryproperties */
    { .label = {   3218,  3, 0 } }, /* kfh */
    { .label = {  11401,  3, 0 } }, /* kia */
    { .label = {  31570,  3, 0 } }, /* kim */
    { .label = { 142517,  6, 0 } }, /* kinder */
    { .label = { 142543,  6, 0 } }, /* kindle */
    { .label = { 124063,  7, 0 } }, /* kitchen */
    { .label = { 156258,  4, 0 } }, /* kiwi */
    { .label = { 149071,  5, 0 } }, /* koeln */
    { .label = {  37451,  7, 0 } }, /* komatsu */
    { .label = { 142570,  6, 0 } }, /* kosher */
    { .label = { 157433,  4, 0 } }, /* kpmg */
    { .label = {   9355,  3, 0 } }, /* kpn */
    { .label = {   8511,  3, 1 } }, { .child = { 8667, 2 } }, /* krd */
    { .label = { 157454,  4, 0 } }, /* kred */
    { .label = {  85762,  9, 0 } }, /* kuokgroup */
    { .label = { 145667,  5, 0 } }, /* kyoto */
    { .label = { 124094,  7, 0 } }, /* lacaixa */
    { .label = {  85805,  9, 0 } }, /* ladbrokes */
    { .label = {  54205, 11, 0 } }, /* lamborghini */
    { .label = { 153314,  5, 0 } }, /* lamer */
    { .label = {  85844,  9, 0 } }, /* lancaster */
    { .label = { 142596,  6, 0 } }, /* lancia */
    { .label = { 124123,  7, 0 } }, /* lancome */
    { .label = {   2156,  4, 1 } }, { .child = { 8669, 1 } }, /* land */
    { .label = {  85880,  9, 0 } }, /* landrover */
    { .label = { 124153,  7, 0 } }, /* lanxess */
    { .label = { 124183,  7, 0 } }, /* lasalle */
    { .label = {   6631,  3, 0 } }, /* lat */
    { .label = { 142620,  6, 0 } }, /* latino */
    { .label = { 124212,  7, 0 } }, /* latrobe */
    { .label = {  16294,  3, 0 } }, /* law */
    { .label = {  57805,  6, 0 } }, /* lawyer */
    { .label = {  82941,  3, 0 } }, /* lds */
    { .label = { 153335,  5, 0 } }, /* lease */
    { .label = { 124241,  7, 0 } }, /* leclerc */
    { .label = { 142644,  6, 0 } }, /* lefrak */
    { .label = { 153355,  5, 0 } }, /* legal */
    { .label = { 157472,  4, 0 } }, /* lego */
    { .label = { 153377,  5, 0 } }, /* lexus */
    { .label = { 157490,  4, 0 } }, /* lgbt */
    { .label = { 124273,  7, 0 } }, /* liaison */
    { .label = { 157509,  4, 0 } }, /* lidl */
    { .label = {  32819,  4, 0 } }, /* life */
    { .label = {  32819, 13, 0 } }, /* lifeinsurance */
    { .label = {  85919,  9, 0 } }, /* lifestyle */
    { .label = { 105684,  8, 0 } }, /* lighting */
    { .label = {  70685,  4, 0 } }, /* like */
    { .label = { 153401,  5, 0 } }, /* lilly */
    { .label = { 124301,  7, 0 } }, /* limited */
    { .label = { 157528,  4, 0 } }, /* limo */
    { .label = { 117047,  7, 0 } }, /* lincoln */
    { .label = {  82039,  5, 0 } }, /* linde */
    { .label = {  29555,  4, 1 } }, { .child = { 8673, 2 } }, /* link */
    { .label = { 153426,  5, 0 } }, /* lipsy */
    { .label = {   2600,  4, 0 } }, /* live */
    { .label = {  16393,  6, 0 } }, /* living */
    { .label = { 153451,  5, 0 } }, /* lixil */
    { .label = { 153475,  4, 0 } }, /* loan */
    { .label = { 153475,  5, 0 } }, /* loans */
    { .label = { 142671,  6, 0 } }, /* locker */
    { .label = { 153495,  5, 0 } }, /* locus */
    { .label = { 157546,  4, 0 } }, /* loft */
    { .label = {  42962,  3, 0 } }, /* lol */
    { .label = { 136547,  6, 0 } }, /* london */
    { .label = { 153518,  5, 0 } }, /* lotte */
    { .label = { 153539,  5, 0 } }, /* lotto */
    { .label = {  45009,  4, 0 } }, /* love */
    { .label = {  42693,  3, 0 } }, /* lpl */
    { .label = {  42693, 12, 0 } }, /* lplfinancial */
    { .label = {   5935,  3, 0 } }, /* ltd */
    { .label = {   5935,  4, 0 } }, /* ltda */
    { .label = { 105720,  8, 0 } }, /* lundbeck */
    { .label = { 153560,  5, 0 } }, /* lupin */
    { .label = {  64431,  4, 0 } }, /* luxe */
    { .label = { 142698,  6, 0 } }, /* luxury */
    { .label = { 153584,  5, 0 } }, /* macys */
    { .label = { 136630,  6, 0 } }, /* madrid */
    { .label = {  51013,  4, 0 } }, /* maif */
    { .label = {  19547,  6, 0 } }, /* maison */
    { .label = { 142729,  6, 0 } }, /* makeup */
    { .label = {  11347,  3, 0 } }, /* man */
    { .label = {  68312, 10, 1 } }, { .child = { 8675, 1 } }, /* management */
    { .label = { 153607,  5, 0 } }, /* mango */
    { .label = {  51486,  3, 0 } }, /* map */
    { .label = {  38197,  6, 0 } }, /* market */
    { .label = {  85961,  9, 0 } }, /* marketing */
    { .label = { 124332,  7, 0 } }, /* markets */
    { .label = { 105758,  8, 0 } }, /* marriott */
    { .label = {  85999,  9, 0 } }, /* marshalls */
    { .label = { 105790,  8, 0 } }, /* maserati */
    { .label = { 142757,  6, 0 } }, /* mattel */
    { .label = {   9656,  3, 0 } }, /* mba */
    { .label = {  86037,  3, 0 } }, /* mcd */
    { .label = {  86037,  9, 0 } }, /* mcdonalds */
    { .label = { 105821,  8, 0 } }, /* mckinsey */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {  87923,  5, 0 } }, /* media */
    { .label = { 157565,  4, 0 } }, /* meet */
    { .label = {  86077,  9, 0 } }, /* melbourne */
    { .label = { 157582,  4, 0 } }, /* meme */
    { .label = {  98661,  8, 0 } }, /* memorial */
    { .label = {    123,  3, 0 } }, /* men */
    { .label = { 157600,  4, 0 } }, /* menu */
    { .label = {  12410,  3, 0 } }, /* meo */
    { .label = { 105858,  8, 0 } }, /* merckmsd */
    { .label = { 124361,  7, 0 } }, /* metlife */
    { .label = { 153628,  5, 0 } }, /* miami */
    { .label = {  86117,  9, 0 } }, /* microsoft */
    { .label = {  94289,  4, 0 } }, /* mini */
    { .label = { 120710,  4, 0 } }, /* mint */
    { .label = {   8944,  3, 0 } }, /* mit */
    { .label = {  68353, 10, 0 } }, /* mitsubishi */
    { .label = {  46507,  3, 0 } }, /* mlb */
    { .label = {  23523,  3, 0 } }, /* mls */
    { .label = {  27797,  3, 0 } }, /* mma */
    { .label = {  44978,  6, 0 } }, /* mobile */
    { .label = { 142782,  6, 0 } }, /* mobily */
    { .label = {  23481,  4, 0 } }, /* moda */
    { .label = {   3330,  3, 0 } }, /* moe */
    { .label = {   1501,  3, 0 } }, /* moi */
    { .label = {  15025,  3, 0 } }, /* mom */
    { .label = { 142811,  6, 0 } }, /* monash */
    { .label = { 149114,  5, 0 } }, /* money */
    { .label = { 124393,  7, 0 } }, /* monster */
    { .label = {  86157,  9, 0 } }, /* montblanc */
    { .label = { 153649,  5, 0 } }, /* mopar */
    { .label = { 142836,  6, 0 } }, /* mormon */
    { .label = { 105895,  8, 0 } }, /* mortgage */
    { .label = { 136758,  6, 0 } }, /* moscow */
    { .label = {   3727,  4, 0 } }, /* moto */
    { .label = {  54253, 11, 0 } }, /* motorcycles */
    { .label = {  25959,  3, 0 } }, /* mov */
    { .label = { 153671,  5, 0 } }, /* movie */
    { .label = { 105929,  8, 0 } }, /* movistar */
    { .label = {   1129,  3, 0 } }, /* msd */
    { .label = {  34018,  3, 0 } }, /* mtn */
    { .label = { 157618,  4, 0 } }, /* mtpc */
    { .label = { 119942,  3, 0 } }, /* mtr */
    { .label = {   7105,  6, 0 } }, /* mutual */
    { .label = { 105963,  8, 0 } }, /* mutuelle */
    { .label = {  29373,  3, 0 } }, /* nab */
    { .label = { 153694,  5, 0 } }, /* nadex */
    { .label = { 129769,  6, 0 } }, /* nagoya */
    { .label = {  68397, 10, 0 } }, /* nationwide */
    { .label = {   2863,  6, 0 } }, /* natura */
    { .label = {  30346,  4, 0 } }, /* navy */
    { .label = {   2738,  3, 0 } }, /* nba */
    { .label = {  27123,  3, 0 } }, /* nec */
    { .label = { 124422,  7, 0 } }, /* netbank */
    { .label = { 124451,  7, 0 } }, /* netflix */
    { .label = {  54077,  7, 1 } }, { .child = { 8676, 1 } }, /* network */
    { .label = { 124484,  7, 0 } }, /* neustar */
    { .label = {  14149,  3, 0 } }, /* new */
    { .label = {  68440, 10, 0 } }, /* newholland */
    { .label = {  14149,  4, 0 } }, /* news */
    { .label = {  68137,  4, 0 } }, /* next */
    { .label = {  68486, 10, 0 } }, /* nextdirect */
    { .label = { 153716,  5, 0 } }, /* nexus */
    { .label = {  79412,  3, 0 } }, /* nfl */
    { .label = {   7233,  3, 0 } }, /* ngo */
    { .label = { 122356,  3, 0 } }, /* nhk */
    { .label = {  58438,  4, 0 } }, /* nico */
    { .label = { 157638,  4, 0 } }, /* nike */
    { .label = { 153739,  5, 0 } }, /* nikon */
    { .label = { 153760,  5, 0 } }, /* ninja */
    { .label = { 142862,  6, 0 } }, /* nissan */
    { .label = { 142885,  6, 0 } }, /* nissay */
    { .label = { 153782,  5, 0 } }, /* nokia */
    { .label = {   7053, 18, 0 } }, /* northwesternmutual */
    { .label = { 142910,  6, 0 } }, /* norton */
    { .label = {   3319,  3, 0 } }, /* now */
    { .label = { 142934,  6, 0 } }, /* nowruz */
    { .label = { 153802,  5, 0 } }, /* nowtv */
    { .label = {   3192,  3, 0 } }, /* nra */
    { .label = {  16399,  3, 0 } }, /* nrw */
    { .label = {   1051,  3, 0 } }, /* ntt */
    { .label = { 106228,  3, 0 } }, /* nyc */
    { .label = {   7418,  3, 0 } }, /* obi */
    { .label = { 106000,  8, 0 } }, /* observer */
    { .label = {  33566,  3, 0 } }, /* off */
    { .label = {  33566,  6, 0 } }, /* office */
    { .label = { 110349,  7, 0 } }, /* okinawa */
    { .label = {  54303,  6, 0 } }, /* olayan */
    { .label = {  54303, 11, 0 } }, /* olayangroup */
    { .label = { 124512,  7, 0 } }, /* oldnavy */
    { .label = { 157655,  4, 0 } }, /* ollo */
    { .label = { 153827,  5, 0 } }, /* omega */
    { .label = {   3477,  3, 0 } }, /* one */
    { .label = {   4725,  3, 0 } }, /* ong */
    { .label = {  15120,  3, 0 } }, /* onl */
    { .label = { 136867,  6, 0 } }, /* online */
    { .label = {  68530, 10, 0 } }, /* onyourside */
    { .label = {  26101,  3, 0 } }, /* ooo */
    { .label = {  63822,  4, 0 } }, /* open */
    { .label = { 142965,  6, 0 } }, /* oracle */
    { .label = { 142990,  6, 0 } }, /* orange */
    { .label = {  26998,  7, 0 } }, /* organic */
    { .label = {  32875, 13, 0 } }, /* orientexpress */
    { .label = { 124545,  7, 0 } }, /* origins */
    { .label = {  37178,  5, 0 } }, /* osaka */
    { .label = {  61349,  6, 0 } }, /* otsuka */
    { .label = {  28120,  3, 0 } }, /* ott */
    { .label = {   6288,  3, 1 } }, { .child = { 8679, 1 } }, /* ovh */
    { .label = {   7372,  4, 0 } }, /* page */
    { .label = {  42747, 12, 0 } }, /* pamperedchef */
    { .label = {  86196,  9, 0 } }, /* panasonic */
    { .label = { 124574,  7, 0 } }, /* panerai */
    { .label = {  39028,  5, 0 } }, /* paris */
    { .label = { 116769,  4, 0 } }, /* pars */
    { .label = { 106035,  8, 0 } }, /* partners */
    { .label = { 153848,  5, 0 } }, /* parts */
    { .label = { 153869,  5, 0 } }, /* party */
    { .label = {  86233,  9, 0 } }, /* passagens */
    { .label = {   8405,  3, 0 } }, /* pay */
    { .label = { 157673,  4, 0 } }, /* pccw */
    { .label = {   7522,  3, 0 } }, /* pet */
    { .label = { 143014,  6, 0 } }, /* pfizer */
    { .label = {  99041,  8, 0 } }, /* pharmacy */
    { .label = {  34643,  3, 0 } }, /* phd */
    { .label = { 124602,  7, 0 } }, /* philips */
    { .label = { 153892,  5, 0 } }, /* phone */
    { .label = {  10098,  5, 0 } }, /* photo */
    { .label = {  50494, 11, 0 } }, /* photography */
    { .label = { 107280,  6, 0 } }, /* photos */
    { .label = { 143045,  6, 0 } }, /* physio */
    { .label = { 143074,  6, 0 } }, /* piaget */
    { .label = {  57328,  4, 0 } }, /* pics */
    { .label = { 143100,  6, 0 } }, /* pictet */
    { .label = { 106068,  8, 0 } }, /* pictures */
    { .label = {  14891,  3, 0 } }, /* pid */
    { .label = {  25075,  3, 0 } }, /* pin */
    { .label = {  25075,  4, 0 } }, /* ping */
    { .label = {  71337,  4, 0 } }, /* pink */
    { .label = { 124636,  7, 0 } }, /* pioneer */
    { .label = { 153915,  5, 0 } }, /* pizza */
    { .label = {  63541,  5, 0 } }, /* place */
    { .label = {  54352,  4, 0 } }, /* play */
    { .label = {  54352, 11, 0 } }, /* playstation */
    { .label = { 106104,  8, 0 } }, /* plumbing */
    { .label = { 144820,  4, 0 } }, /* plus */
    { .label = {  88346,  3, 0 } }, /* pnc */
    { .label = { 157696,  4, 0 } }, /* pohl */
    { .label = { 153942,  5, 0 } }, /* poker */
    { .label = { 124666,  7, 0 } }, /* politie */
    { .label = {  19423,  4, 0 } }, /* porn */
    { .label = {  86270,  9, 0 } }, /* pramerica */
    { .label = { 153965,  5, 0 } }, /* praxi */
    { .label = {  18801,  5, 0 } }, /* press */
    { .label = { 153988,  5, 0 } }, /* prime */
    { .label = {  54399,  4, 0 } }, /* prod */
    { .label = {  54399, 11, 0 } }, /* productions */
    { .label = { 156559,  4, 0 } }, /* prof */
    { .label = {  54448, 11, 0 } }, /* progressive */
    { .label = { 154011,  5, 0 } }, /* promo */
    { .label = {  18846, 10, 0 } }, /* properties */
    { .label = { 106143,  8, 0 } }, /* property */
    { .label = {  68574, 10, 0 } }, /* protection */
    { .label = {  68617,  3, 0 } }, /* pru */
    { .label = {  68617, 10, 0 } }, /* prudential */
    { .label = {  19990,  3, 0 } }, /* pub */
    { .label = { 122378,  3, 0 } }, /* pwc */
    { .label = { 157716,  4, 0 } }, /* qpon */
    { .label = { 137050,  6, 0 } }, /* quebec */
    { .label = { 154034,  5, 0 } }, /* quest */
    { .label = { 158792,  3, 0 } }, /* qvc */
    { .label = { 143127,  6, 0 } }, /* racing */
    { .label = {  44069,  5, 0 } }, /* radio */
    { .label = { 157738,  4, 0 } }, /* raid */
    { .label = {  32941,  4, 0 } }, /* read */
    { .label = {  66547, 10, 0 } }, /* realestate */
    { .label = { 124697,  7, 0 } }, /* realtor */
    { .label = { 143152,  6, 0 } }, /* realty */
    { .label = { 124725,  7, 0 } }, /* recipes */
    { .label = {   3487,  3, 0 } }, /* red */
    { .label = { 106181,  8, 0 } }, /* redstone */
    { .label = {  54497, 11, 0 } }, /* redumbrella */
    { .label = { 154059,  5, 0 } }, /* rehab */
    { .label = { 143178,  5, 0 } }, /* reise */
    { .label = { 143178,  6, 0 } }, /* reisen */
    { .label = { 157754,  4, 0 } }, /* reit */
    { .label = { 106214,  8, 0 } }, /* reliance */
    { .label = {   3695,  3, 0 } }, /* ren */
    { .label = {   3695,  4, 0 } }, /* rent */
    { .label = {   8046,  7, 0 } }, /* rentals */
    { .label = { 143202,  6, 0 } }, /* repair */
    { .label = { 143227,  6, 0 } }, /* report */
    { .label = {  19982, 10, 0 } }, /* republican */
    { .label = {  68661,  4, 0 } }, /* rest */
    { .label = {  68661, 10, 0 } }, /* restaurant */
    { .label = { 124756,  6, 0 } }, /* review */
    { .label = { 124756,  7, 0 } }, /* reviews */
    { .label = { 124789,  7, 0 } }, /* rexroth */
    { .label = {  22162,  4, 0 } }, /* rich */
    { .label = {  86308,  9, 0 } }, /* richardli */
    { .label = { 154080,  5, 0 } }, /* ricoh */
    { .label = {  54546, 11, 0 } }, /* rightathome */
    { .label = {  38069,  3, 0 } }, /* ril */
    { .label = {  10347,  3, 0 } }, /* rio */
    { .label = {  49064,  3, 0 } }, /* rip */
    { .label = { 157770,  4, 0 } }, /* rmit */
    { .label = { 143253,  6, 0 } }, /* rocher */
    { .label = {  34067,  5, 0 } }, /* rocks */
    { .label = { 154102,  5, 0 } }, /* rodeo */
    { .label = { 143279,  6, 0 } }, /* rogers */
    { .label = { 157787,  4, 0 } }, /* room */
    { .label = { 105901,  4, 0 } }, /* rsvp */
    { .label = { 157465,  4, 0 } }, /* ruhr */
    { .label = {  26118,  3, 0 } }, /* run */
    { .label = {   4252,  3, 0 } }, /* rwe */
    { .label = { 143304,  6, 0 } }, /* ryukyu */
    { .label = { 106247,  8, 0 } }, /* saarland */
    { .label = {   9960,  4, 0 } }, /* safe */
    { .label = {   9960,  6, 0 } }, /* safety */
    { .label = {  61805,  6, 0 } }, /* sakura */
    { .label = {  44822,  4, 0 } }, /* sale */
    { .label = { 154123,  5, 0 } }, /* salon */
    { .label = { 106278,  8, 0 } }, /* samsclub */
    { .label = { 124820,  7, 0 } }, /* samsung */
    { .label = {  18890,  7, 0 } }, /* sandvik */
    { .label = {  18890, 15, 0 } }, /* sandvikcoromant */
    { .label = { 143335,  6, 0 } }, /* sanofi */
    { .label = {   2671,  3, 0 } }, /* sap */
    { .label = {   2671,  4, 0 } }, /* sapo */
    { .label = { 157804,  4, 0 } }, /* sarl */
    { .label = {   4458,  3, 0 } }, /* sas */
    { .label = {  13841,  4, 0 } }, /* save */
    { .label = {  28756,  4, 0 } }, /* saxo */
    { .label = {  29925,  3, 0 } }, /* sbi */
    { .label = {  42278,  3, 0 } }, /* sbs */
    { .label = {   9484,  3, 0 } }, /* sca */
    { .label = {  19001,  3, 0 } }, /* scb */
    { .label = {  68700, 10, 0 } }, /* schaeffler */
    { .label = { 124850,  7, 0 } }, /* schmidt */
    { .label = {  42804, 12, 0 } }, /* scholarships */
    { .label = { 137105,  6, 0 } }, /* school */
    { .label = { 143360,  6, 0 } }, /* schule */
    { .label = { 124882,  7, 0 } }, /* schwarz */
    { .label = {   6005,  7, 0 } }, /* science */
    { .label = {  86347,  9, 0 } }, /* scjohnson */
    { .label = {  16941,  4, 0 } }, /* scor */
    { .label = {  99251,  4, 0 } }, /* scot */
    { .label = {  25038,  6, 0 } }, /* search */
    { .label = {    677,  4, 0 } }, /* seat */
    { .label = {  43922,  6, 0 } }, /* secure */
    { .label = {  13995,  8, 0 } }, /* security */
    { .label = { 157820,  4, 0 } }, /* seek */
    { .label = { 123974,  6, 0 } }, /* select */
    { .label = { 152129,  5, 0 } }, /* sener */
    { .label = {  88494,  8, 0 } }, /* services */
    { .label = {  18581,  3, 0 } }, /* ses */
    { .label = { 107563,  5, 0 } }, /* seven */
    { .label = { 158811,  3, 0 } }, /* sew */
    { .label = {     54,  3, 0 } }, /* sex */
    { .label = { 157837,  4, 0 } }, /* sexy */
    { .label = {  20549,  3, 0 } }, /* sfr */
    { .label = {  86388,  9, 0 } }, /* shangrila */
    { .label = { 154143,  5, 0 } }, /* sharp */
    { .label = { 157857,  4, 0 } }, /* shaw */
    { .label = { 149290,  5, 0 } }, /* shell */
    { .label = {  15155,  4, 0 } }, /* shia */
    { .label = { 124917,  7, 0 } }, /* shiksha */
    { .label = { 154165,  5, 0 } }, /* shoes */
    { .label = {  45280,  4, 0 } }, /* shop */
    { .label = { 106314,  8, 0 } }, /* shopping */
    { .label = { 143388,  6, 0 } }, /* shouji */
    { .label = { 106352,  4, 0 } }, /* show */
    { .label = { 106352,  8, 0 } }, /* showtime */
    { .label = { 124947,  7, 0 } }, /* shriram */
    { .label = {  62323,  4, 0 } }, /* silk */
    { .label = {  29291,  4, 0 } }, /* sina */
    { .label = { 124976,  7, 0 } }, /* singles */
    { .label = {  34482,  4, 1 } }, { .child = { 8680, 1 } }, /* site */
    { .label = {  11397,  3, 0 } }, /* ski */
    { .label = {  71334,  4, 0 } }, /* skin */
    { .label = {   4116,  3, 0 } }, /* sky */
    { .label = { 154186,  5, 0 } }, /* skype */
    { .label = { 154211,  5, 0 } }, /* sling */
    { .label = {  13782,  5, 0 } }, /* smart */
    { .label = { 154233,  5, 0 } }, /* smile */
    { .label = { 157876,  4, 0 } }, /* sncf */
    { .label = { 143417,  6, 0 } }, /* soccer */
    { .label = {  26501,  6, 0 } }, /* social */
    { .label = { 106389,  8, 0 } }, /* softbank */
    { .label = {  88529,  8, 0 } }, /* software */
    { .label = { 157895,  4, 0 } }, /* sohu */
    { .label = { 154255,  5, 0 } }, /* solar */
    { .label = {  86425,  9, 0 } }, /* solutions */
    { .label = {  82681,  4, 0 } }, /* song */
    { .label = { 157913,  4, 0 } }, /* sony */
    { .label = {  66131,  3, 0 } }, /* soy */
    { .label = {  34557,  5, 1 } }, { .child = { 8681, 1 } }, /* space */
    { .label = { 125006,  7, 0 } }, /* spiegel */
    { .label = { 107733,  4, 0 } }, /* spot */
    { .label = {  32931, 13, 0 } }, /* spreadbetting */
    { .label = {   9135,  3, 0 } }, /* srl */
    { .label = {  32518,  3, 0 } }, /* srt */
    { .label = { 100654,  5, 0 } }, /* stada */
    { .label = { 125038,  7, 0 } }, /* staples */
    { .label = {  34085,  4, 0 } }, /* star */
    { .label = { 125068,  7, 0 } }, /* starhub */
    { .label = {  86463,  9, 0 } }, /* statebank */
    { .label = {  86499,  9, 0 } }, /* statefarm */
    { .label = { 125098,  7, 0 } }, /* statoil */
    { .label = {   5951,  3, 0 } }, /* stc */
    { .label = { 106424,  8, 0 } }, /* stcgroup */
    { .label = {  80195,  9, 0 } }, /* stockholm */
    { .label = { 125126,  7, 0 } }, /* storage */
    { .label = { 144991,  5, 0 } }, /* store */
    { .label = { 143443,  6, 0 } }, /* stream */
    { .label = { 143467,  6, 0 } }, /* studio */
    { .label = { 154275,  5, 0 } }, /* study */
    { .label = {  85938,  5, 0 } }, /* style */
    { .label = { 154299,  5, 0 } }, /* sucks */
    { .label = { 106461,  8, 0 } }, /* supplies */
    { .label = { 143493,  6, 0 } }, /* supply */
    { .label = { 125154,  7, 0 } }, /* support */
    { .label = { 157931,  4, 0 } }, /* surf */
    { .label = { 125187,  7, 0 } }, /* surgery */
    { .label = { 143525,  6, 0 } }, /* suzuki */
    { .label = { 143555,  6, 0 } }, /* swatch */
    { .label = {  68746, 10, 0 } }, /* swiftcover */
    { .label = { 154322,  5, 0 } }, /* swiss */
    { .label = { 137268,  6, 0 } }, /* sydney */
    { .label = { 106499,  8, 0 } }, /* symantec */
    { .label = {  20301,  7, 1 } }, { .child = { 8682, 1 } }, /* systems */
    { .label = {   1743,  3, 0 } }, /* tab */
    { .label = { 143583,  6, 0 } }, /* taipei */
    { .label = {  13195,  4, 0 } }, /* talk */
    { .label = { 143608,  6, 0 } }, /* taobao */
    { .label = { 143631,  6, 0 } }, /* target */
    { .label = {  68794, 10, 0 } }, /* tatamotors */
    { .label = {  84079,  5, 0 } }, /* tatar */
    { .label = { 143655,  6, 0 } }, /* tattoo */
    { .label = {   3347,  3, 0 } }, /* tax */
    { .label = { 155320,  4, 0 } }, /* taxi */
    { .label = {    877,  3, 0 } }, /* tci */
    { .label = {  84148,  3, 0 } }, /* tdk */
    { .label = {  16912,  4, 0 } }, /* team */
    { .label = {  57952,  4, 0 } }, /* tech */
    { .label = {  64988, 10, 0 } }, /* technology */
    { .label = { 106534,  8, 0 } }, /* telecity */
    { .label = {  68833, 10, 0 } }, /* telefonica */
    { .label = { 125219,  7, 0 } }, /* temasek */
    { .label = { 143678,  6, 0 } }, /* tennis */
    { .label = {  66541,  4, 0 } }, /* teva */
    { .label = {  10120,  3, 0 } }, /* thd */
    { .label = { 117701,  7, 0 } }, /* theater */
    { .label = { 125248,  7, 0 } }, /* theatre */
    { .label = {  54593, 11, 0 } }, /* theguardian */
    { .label = {  70102,  4, 0 } }, /* tiaa */
    { .label = { 125276,  7, 0 } }, /* tickets */
    { .label = { 143702,  6, 0 } }, /* tienda */
    { .label = { 125306,  7, 0 } }, /* tiffany */
    { .label = {  86485,  4, 0 } }, /* tips */
    { .label = { 154345,  5, 0 } }, /* tires */
    { .label = {   3830,  5, 0 } }, /* tirol */
    { .label = { 143726,  6, 0 } }, /* tjmaxx */
    { .label = {  72934,  3, 0 } }, /* tjx */
    { .label = { 143757,  6, 0 } }, /* tkmaxx */
    { .label = {  98490,  5, 0 } }, /* tmall */
    { .label = { 154365,  5, 0 } }, /* today */
    { .label = { 145690,  5, 0 } }, /* tokyo */
    { .label = { 154387,  5, 0 } }, /* tools */
    { .label = {  63818,  3, 0 } }, /* top */
    { .label = {  12429,  5, 0 } }, /* toray */
    { .label = { 125339,  7, 0 } }, /* toshiba */
    { .label = { 154408,  5, 0 } }, /* total */
    { .label = { 123077,  5, 0 } }, /* tours */
    { .label = {  14130,  4, 0 } }, /* town */
    { .label = { 129978,  6, 0 } }, /* toyota */
    { .label = { 157950,  4, 0 } }, /* toys */
    { .label = { 128720,  5, 0 } }, /* trade */
    { .label = { 108842,  7, 0 } }, /* trading */
    { .label = { 106570,  8, 0 } }, /* training */
    { .label = {  32987, 13, 0 } }, /* travelchannel */
    { .label = {   7132,  9, 0 } }, /* travelers */
    { .label = {   7132, 18, 0 } }, /* travelersinsurance */
    { .label = { 117761,  5, 0 } }, /* trust */
    { .label = {   1286,  3, 0 } }, /* trv */
    { .label = {  58359,  4, 0 } }, /* tube */
    { .label = {  68056,  3, 0 } }, /* tui */
    { .label = { 154428,  5, 0 } }, /* tunes */
    { .label = { 154449,  5, 0 } }, /* tushu */
    { .label = {  25028,  3, 0 } }, /* tvs */
    { .label = { 103572,  5, 0 } }, /* ubank */
    { .label = { 106304,  3, 0 } }, /* ubs */
    { .label = { 106602,  8, 0 } }, /* uconnect */
    { .label = { 143786,  6, 0 } }, /* unicom */
    { .label = {  65077, 10, 0 } }, /* university */
    { .label = {  11254,  3, 0 } }, /* uno */
    { .label = {   5012,  3, 0 } }, /* uol */
    { .label = {  54678,  3, 0 } }, /* ups */
    { .label = {  86536,  9, 0 } }, /* vacations */
    { .label = {  81848,  4, 0 } }, /* vana */
    { .label = { 106637,  8, 0 } }, /* vanguard */
    { .label = { 154472,  5, 0 } }, /* vegas */
    { .label = { 106672,  8, 0 } }, /* ventures */
    { .label = { 106707,  8, 0 } }, /* verisign */
    { .label = {  42857, 12, 0 } }, /* versicherung */
    { .label = {   7001,  3, 0 } }, /* vet */
    { .label = { 143813,  6, 0 } }, /* viajes */
    { .label = { 145116,  5, 0 } }, /* video */
    { .label = {  18835,  3, 0 } }, /* vig */
    { .label = { 137344,  6, 0 } }, /* viking */
    { .label = { 143841,  6, 0 } }, /* villas */
    { .label = {  16402,  3, 0 } }, /* vin */
    { .label = {  71867,  3, 0 } }, /* vip */
    { .label = {  99494,  6, 0 } }, /* virgin */
    { .label = {  18206,  4, 0 } }, /* visa */
    { .label = {  22474,  6, 0 } }, /* vision */
    { .label = {  68876,  5, 0 } }, /* vista */
    { .label = {  68876, 10, 0 } }, /* vistaprint */
    { .label = { 157968,  4, 0 } }, /* viva */
    { .label = { 157987,  4, 0 } }, /* vivo */
    { .label = {  65210, 10, 0 } }, /* vlaanderen */
    { .label = { 154494,  5, 0 } }, /* vodka */
    { .label = {  68919, 10, 0 } }, /* volkswagen */
    { .label = { 154517,  5, 0 } }, /* volvo */
    { .label = { 158007,  4, 0 } }, /* vote */
    { .label = { 143868,  6, 0 } }, /* voting */
    { .label = { 158025,  4, 0 } }, /* voto */
    { .label = { 143895,  6, 0 } }, /* voyage */
    { .label = { 143923,  6, 0 } }, /* vuelos */
    { .label = { 149356,  5, 0 } }, /* wales */
    { .label = { 125368,  7, 0 } }, /* walmart */
    { .label = { 143951,  6, 0 } }, /* walter */
    { .label = { 115914,  4, 0 } }, /* wang */
    { .label = { 125399,  7, 0 } }, /* wanggou */
    { .label = { 143978,  6, 0 } }, /* warman */
    { .label = {  16452,  5, 0 } }, /* watch */
    { .label = { 125432,  7, 0 } }, /* watches */
    { .label = {  25186,  7, 0 } }, /* weather */
    { .label = {  25186, 14, 0 } }, /* weatherchannel */
    { .label = { 144004,  6, 0 } }, /* webcam */
    { .label = { 154542,  5, 0 } }, /* weber */
    { .label = {  34808,  7, 0 } }, /* website */
    { .label = {   5866,  3, 0 } }, /* wed */
    { .label = { 125464,  7, 0 } }, /* wedding */
    { .label = { 154566,  5, 0 } }, /* weibo */
    { .label = { 158043,  4, 0 } }, /* weir */
    { .label = { 125498,  7, 0 } }, /* whoswho */
    { .label = { 158062,  4, 0 } }, /* wien */
    { .label = {  57380,  4, 0 } }, /* wiki */
    { .label = {  54639, 11, 0 } }, /* williamhill */
    { .label = {  11443,  3, 0 } }, /* win */
    { .label = { 125534,  7, 0 } }, /* windows */
    { .label = {  11443,  4, 0 } }, /* wine */
    { .label = { 125569,  7, 0 } }, /* winners */
    { .label = {  79803,  3, 0 } }, /* wme */
    { .label = {  33043, 13, 0 } }, /* wolterskluwer */
    { .label = { 106742,  8, 0 } }, /* woodside */
    { .label = {  13479,  4, 0 } }, /* work */
    { .label = {  99643,  5, 0 } }, /* works */
    { .label = { 154590,  5, 0 } }, /* world */
    { .label = { 158826,  3, 0 } }, /* wow */
    { .label = {   3119,  3, 0 } }, /* wtc */
    { .label = {  12486,  3, 0 } }, /* wtf */
    { .label = { 158081,  4, 0 } }, /* xbox */
    { .label = {  85420,  5, 0 } }, /* xerox */
    { .label = { 125600,  7, 0 } }, /* xfinity */
    { .label = { 144033,  6, 0 } }, /* xihuan */
    { .label = {   3114,  3, 0 } }, /* xin */
    { .label = {  54691, 11, 0 } }, /* xn--11b4c3d */
    { .label = {  54760, 11, 0 } }, /* xn--1ck2e1b */
    { .label = {  54824, 11, 0 } }, /* xn--1qqw23a */
    { .label = {  68966, 10, 0 } }, /* xn--30rr7y */
    { .label = {  54896, 11, 0 } }, /* xn--3bst00m */
    { .label = {  54961, 11, 0 } }, /* xn--3ds443g */
    { .label = {   9280, 17, 0 } }, /* xn--3oq18vl8pn36a */
    { .label = {  69027, 10, 0 } }, /* xn--3pxu8k */
    { .label = {  55031, 11, 0 } }, /* xn--42c2d9a */
    { .label = {  69088, 10, 0 } }, /* xn--45q11c */
    { .label = {  69155, 10, 0 } }, /* xn--4gbrim */
    { .label = {  33105, 13, 0 } }, /* xn--4gq48lf9j */
    { .label = {  55100, 11, 0 } }, /* xn--55qw42g */
    { .label = {  59438, 10, 0 } }, /* xn--55qx5d */
    { .label = {   9393, 17, 0 } }, /* xn--5su34j936bgsg */
    { .label = {  69207, 10, 0 } }, /* xn--5tzm5g */
    { .label = {  55176, 11, 0 } }, /* xn--6frz82g */
    { .label = {  25247, 14, 0 } }, /* xn--6qq986b3xl */
    { .label = {  42911, 12, 0 } }, /* xn--80adxhks */
    { .label = {  25349, 14, 0 } }, /* xn--80aqecdr1a */
    { .label = {  42978, 12, 0 } }, /* xn--80asehdb */
    { .label = {  69266, 10, 0 } }, /* xn--80aswg */
    { .label = {  43043, 12, 0 } }, /* xn--8y0a063a */
    { .label = {  69324, 10, 0 } }, /* xn--9dbq2a */
    { .label = {  69383, 10, 0 } }, /* xn--9et52u */
    { .label = {  55248, 11, 0 } }, /* xn--9krt00a */
    { .label = {  25428, 14, 0 } }, /* xn--b4w605ferd */
    { .label = {   9504, 17, 0 } }, /* xn--bck1b9a5dre4c */
    { .label = {  84773,  9, 0 } }, /* xn--c1avg */
    { .label = {  69443, 10, 0 } }, /* xn--c2br7g */
    { .label = {  55311, 11, 0 } }, /* xn--cck2b3b */
    { .label = {  69500, 10, 0 } }, /* xn--cg4bki */
    { .label = {  55374, 11, 0 } }, /* xn--czr694b */
    { .label = {  69553, 10, 0 } }, /* xn--czrs0t */
    { .label = {  69606, 10, 0 } }, /* xn--czru2d */
    { .label = {  55444, 11, 0 } }, /* xn--d1acj3b */
    { .label = {  33193, 13, 0 } }, /* xn--eckvdtc9d */
    { .label = {  55506, 11, 0 } }, /* xn--efvy88h */
    { .label = {  55573, 11, 0 } }, /* xn--estv75g */
    { .label = {  55634, 11, 0 } }, /* xn--fct429k */
    { .label = {  86573,  9, 0 } }, /* xn--fhbei */
    { .label = {  25517, 14, 0 } }, /* xn--fiq228c5hs */
    { .label = {  69661, 10, 0 } }, /* xn--fiq64b */
    { .label = {  55701, 11, 0 } }, /* xn--fjq720a */
    { .label = {  55772, 11, 0 } }, /* xn--flw351e */
    { .label = {  12960, 16, 0 } }, /* xn--fzys8d69uvgm */
    { .label = {  55840, 11, 0 } }, /* xn--g2xx48c */
    { .label = {  43123, 12, 0 } }, /* xn--gckr3f0f */
    { .label = {  55910, 11, 0 } }, /* xn--gk3at1e */
    { .label = {  55968, 11, 0 } }, /* xn--hxt814e */
    { .label = {  18954, 15, 0 } }, /* xn--i1b6b1a6a2e */
    { .label = {  56034, 11, 0 } }, /* xn--imr513n */
    { .label = {  59504, 10, 0 } }, /* xn--io0a7i */
    { .label = {  86617,  9, 0 } }, /* xn--j1aef */
    { .label = {  25606, 14, 0 } }, /* xn--jlq61u9w7b */
    { .label = {  56097, 11, 0 } }, /* xn--jvr189m */
    { .label = {  19045, 15, 0 } }, /* xn--kcrx77d1x4a */
    { .label = {  56166, 11, 0 } }, /* xn--kpu716f */
    { .label = {  69724, 10, 0 } }, /* xn--kput3i */
    { .label = {  25700, 14, 0 } }, /* xn--mgba3a3ejt */
    { .label = {  13059, 16, 0 } }, /* xn--mgba7c0bbn0a */
    { .label = {  19134, 15, 0 } }, /* xn--mgbaakc7dvf */
    { .label = {  43192, 12, 0 } }, /* xn--mgbab2bd */
    { .label = {  25774, 14, 0 } }, /* xn--mgbb9fbpob */
    { .label = {  25849, 14, 0 } }, /* xn--mgbca7dzdo */
    { .label = {  25922, 14, 0 } }, /* xn--mgbi4ecexp */
    { .label = {  43254, 12, 0 } }, /* xn--mgbt3dhd */
    { .label = {  43317, 12, 0 } }, /* xn--mk1bu44c */
    { .label = {  59650, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  43388, 12, 0 } }, /* xn--ngbc5azd */
    { .label = {  43451, 12, 0 } }, /* xn--ngbe9e0a */
    { .label = {  86665,  9, 0 } }, /* xn--ngbrx */
    { .label = {  19211,  9, 0 } }, /* xn--nqv7f */
    { .label = {  19211, 15, 0 } }, /* xn--nqv7fs00ema */
    { .label = {  56236, 11, 0 } }, /* xn--nyqy26a */
    { .label = {  86709,  9, 0 } }, /* xn--p1acf */
    { .label = {  56303, 11, 0 } }, /* xn--pbt977c */
    { .label = {  69777, 10, 0 } }, /* xn--pssy2u */
    { .label = {  56370, 11, 0 } }, /* xn--q9jyb4c */
    { .label = {  43514, 12, 0 } }, /* xn--qcka1pmc */
    { .label = {  56439, 11, 0 } }, /* xn--rhqv96g */
    { .label = {  56507, 11, 0 } }, /* xn--rovu88b */
    { .label = {  56571, 11, 0 } }, /* xn--ses554g */
    { .label = {  56635, 11, 0 } }, /* xn--t60b56a */
    { .label = {  86757,  9, 0 } }, /* xn--tckwe */
    { .label = {  33261, 13, 0 } }, /* xn--tiq49xqyj */
    { .label = {  69831, 10, 0 } }, /* xn--unup4y */
    { .label = {    770, 23, 0 } }, /* xn--vermgensberater-ctb */
    { .label = {    552, 24, 0 } }, /* xn--vermgensberatung-pwb */
    { .label = {  86802,  9, 0 } }, /* xn--vhquv */
    { .label = {  56707, 11, 0 } }, /* xn--vuq861b */
    { .label = {   3145, 20, 0 } }, /* xn--w4r85el8fhu5dnra */
    { .label = {  56780, 11, 0 } }, /* xn--w4rs40l */
    { .label = {  56847, 11, 0 } }, /* xn--xhq521b */
    { .label = {  56917, 11, 0 } }, /* xn--zfr164b */
    { .label = { 144060,  6, 0 } }, /* xperia */
    { .label = { 158844,  3, 1 } }, { .child = { 8683, 1 } }, /* xyz */
    { .label = { 144087,  6, 0 } }, /* yachts */
    { .label = { 154615,  5, 0 } }, /* yahoo */
    { .label = { 125634,  7, 0 } }, /* yamaxun */
    { .label = { 144114,  6, 0 } }, /* yandex */
    { .label = {  86852,  9, 0 } }, /* yodobashi */
    { .label = {  44872,  4, 0 } }, /* yoga */
    { .label = {  89619,  8, 0 } }, /* yokohama */
    { .label = {  13826,  3, 0 } }, /* you */
    { .label = {  58344,  7, 0 } }, /* youtube */
    { .label = {  39611,  3, 0 } }, /* yun */
    { .label = { 144142,  6, 0 } }, /* zappos */
    { .label = {  12252,  4, 0 } }, /* zara */
    { .label = { 158102,  4, 0 } }, /* zero */
    { .label = { 103046,  3, 0 } }, /* zip */
    { .label = { 154637,  5, 0 } }, /* zippo */
    { .label = {  35118,  4, 1 } }, { .child = { 8684, 1 } }, /* zone */
    { .label = { 125666,  7, 0 } }, /* zuerich */

    /* entries 1800 to 1805 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entry 1806 */
    { .label = {  20962,  3, 0 } }, /* nom */

    /* entries 1807 to 1814 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   4209,  3, 0 } }, /* sch */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 1815 to 1901 */
    { .label = {    873, 22, 0 } }, /* accident-investigation */
    { .label = {   3439, 19, 0 } }, /* accident-prevention */
    { .label = {  72000,  9, 0 } }, /* aerobatic */
    { .label = {  88324,  8, 0 } }, /* aeroclub */
    { .label = {  72036,  9, 0 } }, /* aerodrome */
    { .label = { 128645,  6, 0 } }, /* agents */
    { .label = {  88359,  8, 0 } }, /* aircraft */
    { .label = { 108629,  7, 0 } }, /* airline */
    { .label = { 108657,  7, 0 } }, /* airport */
    { .label = {  10528, 16, 0 } }, /* air-surveillance */
    { .label = {  58924, 10, 0 } }, /* airtraffic */
    { .label = {   3522, 19, 0 } }, /* air-traffic-control */
    { .label = {  72073,  9, 0 } }, /* ambulance */
    { .label = {  72112,  9, 0 } }, /* amusement */
    { .label = {   1443, 11, 0 } }, /* association */
    { .label = { 128669,  6, 0 } }, /* author */
    { .label = {  58967, 10, 0 } }, /* ballooning */
    { .label = { 128694,  6, 0 } }, /* broker */
    { .label = {  13032,  3, 0 } }, /* caa */
    { .label = { 144970,  5, 0 } }, /* cargo */
    { .label = {  88392,  8, 0 } }, /* catering */
    { .label = {  27153, 13, 0 } }, /* certification */
    { .label = {  35137, 12, 0 } }, /* championship */
    { .label = { 108686,  7, 0 } }, /* charter */
    { .label = {  27208, 13, 0 } }, /* civilaviation */
    { .label = {  88339,  4, 0 } }, /* club */
    { .label = {  59010, 10, 0 } }, /* conference */
    { .label = {  59054, 10, 0 } }, /* consultant */
    { .label = {  59096, 10, 0 } }, /* consulting */
    { .label = {   3575,  7, 0 } }, /* control */
    { .label = { 108715,  7, 0 } }, /* council */
    { .label = { 155209,  4, 0 } }, /* crew */
    { .label = {  22237,  6, 0 } }, /* design */
    { .label = {  79733,  4, 0 } }, /* dgca */
    { .label = {  88425,  8, 0 } }, /* educator */
    { .label = {  72150,  9, 0 } }, /* emergency */
    { .label = {  26622,  6, 0 } }, /* engine */
    { .label = {  26622,  8, 0 } }, /* engineer */
    { .label = {  27264, 13, 0 } }, /* entertainment */
    { .label = {  29510,  9, 0 } }, /* equipment */
    { .label = {  34922,  8, 0 } }, /* exchange */
    { .label = {  18791,  7, 0 } }, /* express */
    { .label = {  59140, 10, 0 } }, /* federation */
    { .label = { 123469,  6, 0 } }, /* flight */
    { .label = { 108747,  7, 0 } }, /* freight */
    { .label = { 155229,  4, 0 } }, /* fuel */
    { .label = {  45344,  7, 0 } }, /* gliding */
    { .label = {  59182, 10, 0 } }, /* government */
    { .label = {  20432, 14, 0 } }, /* groundhandling */
    { .label = {  35225,  5, 0 } }, /* group */
    { .label = {  45327, 11, 0 } }, /* hanggliding */
    { .label = {  72191,  9, 0 } }, /* homebuilt */
    { .label = {    733,  9, 0 } }, /* insurance */
    { .label = {  59226,  7, 0 } }, /* journal */
    { .label = {  59226, 10, 0 } }, /* journalist */
    { .label = { 108779,  7, 0 } }, /* leasing */
    { .label = {  25147,  9, 0 } }, /* logistics */
    { .label = {  88459,  8, 0 } }, /* magazine */
    { .label = {  45376, 11, 0 } }, /* maintenance */
    { .label = {  87923,  5, 0 } }, /* media */
    { .label = {  59270, 10, 0 } }, /* microlight */
    { .label = {  72232,  9, 0 } }, /* modelling */
    { .label = {  59315, 10, 0 } }, /* navigation */
    { .label = {  45420, 11, 0 } }, /* parachuting */
    { .label = {  45468, 11, 0 } }, /* paragliding */
    { .label = {   1400, 21, 0 } }, /* passenger-association */
    { .label = { 136971,  5, 0 } }, /* pilot */
    { .label = {  18801,  5, 0 } }, /* press */
    { .label = {  54399, 10, 0 } }, /* production */
    { .label = {  59356, 10, 0 } }, /* recreation */
    { .label = { 108808,  7, 0 } }, /* repbody */
    { .label = {   3338,  3, 0 } }, /* res */
    { .label = {  25030,  8, 0 } }, /* research */
    { .label = {  59396, 10, 0 } }, /* rotorcraft */
    { .label = {   9960,  6, 0 } }, /* safety */
    { .label = {  72273,  9, 0 } }, /* scientist */
    { .label = {  88494,  8, 0 } }, /* services */
    { .label = { 106352,  4, 0 } }, /* show */
    { .label = {  72310,  9, 0 } }, /* skydiving */
    { .label = {  88529,  8, 0 } }, /* software */
    { .label = {  44379,  7, 0 } }, /* student */
    { .label = { 128720,  6, 0 } }, /* trader */
    { .label = { 108842,  7, 0 } }, /* trading */
    { .label = {   3412,  7, 0 } }, /* trainer */
    { .label = {  53945,  5, 0 } }, /* union */
    { .label = {  35192, 12, 0 } }, /* workinggroup */
    { .label = {  99643,  5, 0 } }, /* works */

    /* entries 1902 to 1906 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  37716,  3, 0 } }, /* edu */

    /* entries 1907 to 1911 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  20962,  3, 0 } }, /* nom */

    /* entries 1912 to 1915 */
    { .label = {  33566,  3, 0 } }, /* off */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 1916 to 1922 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entry 1923 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 1924 to 1929 */
    { .label = {    204,  2, 0 } }, /* ed */
    { .label = {   2981,  2, 0 } }, /* gv */
    { .label = {   1107,  2, 0 } }, /* og */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {   1745,  2, 0 } }, /* pb */
    { .label = {     41,  2, 0 } }, /* it */

    /* entries 1930 to 1939 */
    { .label = {    108,  3, 1 } }, { .child = { 1940, 1 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2870,  3, 0 } }, /* tur */

    /* entry 1940 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 1941 to 1946 */
    { .label = { 155249,  4, 0 } }, /* e164 */
    { .label = { 108871,  7, 0 } }, /* in-addr */
    { .label = { 158375,  3, 0 } }, /* ip6 */
    { .label = { 136144,  4, 0 } }, /* iris */
    { .label = {  13427,  3, 0 } }, /* uri */
    { .label = {  11775,  3, 0 } }, /* urn */

    /* entry 1947 */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entry 1948 */
    { .label = { 125863,  7, 0 } }, /* cloudns */

    /* entries 1949 to 1959 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 1 } }, { .child = { 1960, 1 } }, /* co */
    { .label = {   2981,  2, 0 } }, /* gv */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {  34727, 13, 0 } }, /* futuremailing */
    { .label = { 107680,  8, 1 } }, { .child = { 1961, 2 } }, /* ortsinfo */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {    665,  4, 0 } }, /* priv */

    /* entry 1960 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 1961 to 1964 */
    { .label = {     58,  2, 1 } }, { .child = { 1965, 1 } }, /* ex */
    { .label = { 144455,  6, 1 } }, { .child = { 1966, 1 } }, /* kunden */

    /* entry 1965 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 1966 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 1967 to 1987 */
    { .label = {    108,  3, 1 } }, { .child = { 1988, 1 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 1 } }, { .child = { 1989, 8 } }, /* edu */
    { .label = {   2349,  3, 1 } }, { .child = { 1997, 5 } }, /* gov */
    { .label = {   3005,  3, 0 } }, /* asn */
    { .label = {     88,  2, 0 } }, /* id */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  58187,  4, 0 } }, /* conf */
    { .label = {    710,  2, 0 } }, /* oz */
    { .label = {   9365,  3, 0 } }, /* act */
    { .label = { 137236,  3, 0 } }, /* nsw */
    { .label = {    132,  2, 0 } }, /* nt */
    { .label = { 158396,  3, 0 } }, /* qld */
    { .label = {     43,  2, 0 } }, /* sa */
    { .label = {   9447,  3, 0 } }, /* tas */
    { .label = {   8234,  3, 0 } }, /* vic */
    { .label = {   1560,  2, 0 } }, /* wa */

    /* entry 1988 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 1989 to 1996 */
    { .label = {   9365,  3, 0 } }, /* act */
    { .label = { 137236,  3, 0 } }, /* nsw */
    { .label = {    132,  2, 0 } }, /* nt */
    { .label = { 158396,  3, 0 } }, /* qld */
    { .label = {     43,  2, 0 } }, /* sa */
    { .label = {   9447,  3, 0 } }, /* tas */
    { .label = {   8234,  3, 0 } }, /* vic */
    { .label = {   1560,  2, 0 } }, /* wa */

    /* entries 1997 to 2001 */
    { .label = { 158396,  3, 0 } }, /* qld */
    { .label = {     43,  2, 0 } }, /* sa */
    { .label = {   9447,  3, 0 } }, /* tas */
    { .label = {   8234,  3, 0 } }, /* vic */
    { .label = {   1560,  2, 0 } }, /* wa */

    /* entry 2002 */
    { .label = {    108,  3, 0 } }, /* com */

    /* entries 2003 to 2014 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {   4296,  2, 0 } }, /* pp */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = { 147761,  3, 0 } }, /* biz */

    /* entries 2015 to 2021 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2022 to 2031 */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 144991,  5, 0 } }, /* store */
    { .label = {     55,  2, 0 } }, /* tv */

    /* entry 2032 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2033 to 2036 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = { 108562,  8, 1 } }, { .child = { 2037, 1 } }, /* transurl */

    /* entry 2037 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2038 */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entries 2039 to 2075 */
    { .label = {      6,  1, 0 } }, /* a */
    { .label = {    134,  1, 0 } }, /* b */
    { .label = {     44,  1, 0 } }, /* c */
    { .label = {     46,  1, 0 } }, /* d */
    { .label = {      9,  1, 0 } }, /* e */
    { .label = {     96,  1, 0 } }, /* f */
    { .label = {    137,  1, 0 } }, /* g */
    { .label = {     68,  1, 0 } }, /* h */
    { .label = {      1,  1, 0 } }, /* i */
    { .label = {      4,  1, 0 } }, /* j */
    { .label = {    211,  1, 0 } }, /* k */
    { .label = {      2,  1, 0 } }, /* l */
    { .label = {      5,  1, 0 } }, /* m */
    { .label = {      8,  1, 0 } }, /* n */
    { .label = {      3,  1, 0 } }, /* o */
    { .label = {    326,  1, 0 } }, /* p */
    { .label = {     52,  1, 0 } }, /* q */
    { .label = {     22,  1, 0 } }, /* r */
    { .label = {     43,  1, 0 } }, /* s */
    { .label = {     45,  1, 0 } }, /* t */
    { .label = {    122,  1, 0 } }, /* u */
    { .label = {     56,  1, 0 } }, /* v */
    { .label = {    120,  1, 0 } }, /* w */
    { .label = {     10,  1, 0 } }, /* x */
    { .label = {     28,  1, 0 } }, /* y */
    { .label = {    116,  1, 0 } }, /* z */
    { .label = {     64,  1, 0 } }, /* 0 */
    { .label = {    602,  1, 0 } }, /* 1 */
    { .label = {    171,  1, 0 } }, /* 2 */
    { .label = {    234,  1, 0 } }, /* 3 */
    { .label = {    261,  1, 0 } }, /* 4 */
    { .label = {    739,  1, 0 } }, /* 5 */
    { .label = {   1144,  1, 0 } }, /* 6 */
    { .label = {    105,  1, 0 } }, /* 7 */
    { .label = {    643,  1, 0 } }, /* 8 */
    { .label = {    180,  1, 0 } }, /* 9 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2076 to 2080 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entries 2081 to 2085 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 2086 to 2097 */
    { .label = { 125863,  7, 0 } }, /* cloudns */
    { .label = {  26057,  6, 0 } }, /* dyndns */
    { .label = {  70249, 10, 0 } }, /* for-better */
    { .label = {  33845,  8, 0 } }, /* for-more */
    { .label = { 106986,  8, 0 } }, /* for-some */
    { .label = { 126214,  7, 0 } }, /* for-the */
    { .label = { 144337,  6, 0 } }, /* selfip */
    { .label = { 144366,  6, 0 } }, /* webhop */
    { .label = { 144617,  6, 0 } }, /* mmafan */
    { .label = { 154982,  5, 0 } }, /* myftp */
    { .label = { 154959,  5, 0 } }, /* no-ip */
    { .label = { 128512,  7, 0 } }, /* dscloud */

    /* entries 2098 to 2101 */
    { .label = {   1443,  4, 0 } }, /* asso */
    { .label = { 108901,  7, 0 } }, /* barreau */
    { .label = { 155281,  4, 0 } }, /* gouv */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2102 to 2106 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entry 2107 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2108 to 2116 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {     55,  2, 0 } }, /* tv */

    /* entries 2117 to 2189 */
    { .label = {  18391,  3, 0 } }, /* adm */
    { .label = {   2460,  3, 0 } }, /* adv */
    { .label = {   5797,  3, 0 } }, /* agr */
    { .label = {    626,  2, 0 } }, /* am */
    { .label = { 137464,  3, 0 } }, /* arq */
    { .label = {   7810,  3, 0 } }, /* art */
    { .label = {  10490,  3, 0 } }, /* ato */
    { .label = {    134,  1, 0 } }, /* b */
    { .label = {   1329,  3, 0 } }, /* bio */
    { .label = {  13399,  4, 0 } }, /* blog */
    { .label = {    134,  3, 0 } }, /* bmd */
    { .label = {  14406,  3, 0 } }, /* cim */
    { .label = {  15473,  3, 0 } }, /* cng */
    { .label = {   2286,  3, 0 } }, /* cnt */
    { .label = {    108,  3, 1 } }, { .child = { 2190, 1 } }, /* com */
    { .label = { 155301,  4, 0 } }, /* coop */
    { .label = {   2484,  3, 0 } }, /* ecn */
    { .label = {    104,  3, 0 } }, /* eco */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  15941,  3, 0 } }, /* emp */
    { .label = {   1417,  3, 0 } }, /* eng */
    { .label = {   7386,  3, 0 } }, /* esp */
    { .label = {  69002,  3, 0 } }, /* etc */
    { .label = {    304,  3, 0 } }, /* eti */
    { .label = {  29492,  3, 0 } }, /* far */
    { .label = { 137414,  4, 0 } }, /* flog */
    { .label = {   3205,  2, 0 } }, /* fm */
    { .label = {  38121,  3, 0 } }, /* fnd */
    { .label = {  93268,  3, 0 } }, /* fot */
    { .label = {  21911,  3, 0 } }, /* fst */
    { .label = { 158414,  3, 0 } }, /* g12 */
    { .label = {  73179,  3, 0 } }, /* ggf */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13527,  3, 0 } }, /* imb */
    { .label = {   6047,  3, 0 } }, /* ind */
    { .label = { 105545,  3, 0 } }, /* inf */
    { .label = {  12187,  3, 0 } }, /* jor */
    { .label = {  10636,  3, 0 } }, /* jus */
    { .label = {  10352,  3, 1 } }, { .child = { 2191, 27 } }, /* leg */
    { .label = {  42030,  3, 0 } }, /* lel */
    { .label = {   2426,  3, 0 } }, /* mat */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {   4534,  2, 0 } }, /* mp */
    { .label = {   2922,  3, 0 } }, /* mus */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  20962,  3, 1 } }, { .child = { 2218, 1 } }, /* nom */
    { .label = {  13717,  3, 0 } }, /* not */
    { .label = {   3584,  3, 0 } }, /* ntr */
    { .label = {  15299,  3, 0 } }, /* odo */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 139798,  3, 0 } }, /* ppg */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = {   7819,  3, 0 } }, /* psc */
    { .label = {   3597,  3, 0 } }, /* psi */
    { .label = { 158436,  3, 0 } }, /* qsl */
    { .label = {  44069,  5, 0 } }, /* radio */
    { .label = {    175,  3, 0 } }, /* rec */
    { .label = {  76141,  3, 0 } }, /* slg */
    { .label = {  33236,  3, 0 } }, /* srv */
    { .label = { 155320,  4, 0 } }, /* taxi */
    { .label = {  15812,  3, 0 } }, /* teo */
    { .label = {   5009,  3, 0 } }, /* tmp */
    { .label = {  21953,  3, 0 } }, /* trd */
    { .label = {   2870,  3, 0 } }, /* tur */
    { .label = {     55,  2, 0 } }, /* tv */
    { .label = {   7001,  3, 0 } }, /* vet */
    { .label = { 155337,  4, 0 } }, /* vlog */
    { .label = {  57380,  4, 0 } }, /* wiki */
    { .label = {  21008,  3, 0 } }, /* zlg */

    /* entry 2190 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2191 to 2217 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     11,  2, 0 } }, /* al */
    { .label = {    626,  2, 0 } }, /* am */
    { .label = {    505,  2, 0 } }, /* ap */
    { .label = {    267,  2, 0 } }, /* ba */
    { .label = {    269,  2, 0 } }, /* ce */
    { .label = {    620,  2, 0 } }, /* df */
    { .label = {    143,  2, 0 } }, /* es */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {    731,  2, 0 } }, /* ma */
    { .label = {    586,  2, 0 } }, /* mg */
    { .label = {    352,  2, 0 } }, /* ms */
    { .label = {   1355,  2, 0 } }, /* mt */
    { .label = {    592,  2, 0 } }, /* pa */
    { .label = {   1745,  2, 0 } }, /* pb */
    { .label = {   1882,  2, 0 } }, /* pe */
    { .label = {   4715,  2, 0 } }, /* pi */
    { .label = {    436,  2, 0 } }, /* pr */
    { .label = {   3092,  2, 0 } }, /* rj */
    { .label = {    186,  2, 0 } }, /* rn */
    { .label = {    465,  2, 0 } }, /* ro */
    { .label = {     53,  2, 0 } }, /* rr */
    { .label = {     50,  2, 0 } }, /* rs */
    { .label = {   3965,  2, 0 } }, /* sc */
    { .label = {     54,  2, 0 } }, /* se */
    { .label = {   1422,  2, 0 } }, /* sp */
    { .label = {     45,  2, 0 } }, /* to */

    /* entry 2218 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2219 to 2223 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entries 2224 to 2228 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 2229 to 2230 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 2231 to 2235 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {    108,  3, 1 } }, { .child = { 2236, 1 } }, /* com */
    { .label = {   3299,  2, 0 } }, /* of */

    /* entry 2236 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2237 to 2242 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {    395,  2, 0 } }, /* za */

    /* entries 2243 to 2260 */
    { .label = {    657,  2, 0 } }, /* ab */
    { .label = {   1325,  2, 0 } }, /* bc */
    { .label = {   3034,  2, 0 } }, /* mb */
    { .label = {   1323,  2, 0 } }, /* nb */
    { .label = {   1195,  2, 0 } }, /* nf */
    { .label = {    243,  2, 0 } }, /* nl */
    { .label = {    232,  2, 0 } }, /* ns */
    { .label = {    132,  2, 0 } }, /* nt */
    { .label = {   1347,  2, 0 } }, /* nu */
    { .label = {    435,  2, 0 } }, /* on */
    { .label = {   1882,  2, 0 } }, /* pe */
    { .label = {   9317,  2, 0 } }, /* qc */
    { .label = {   1742,  2, 0 } }, /* sk */
    { .label = {   2345,  2, 0 } }, /* yk */
    { .label = {    520,  2, 0 } }, /* gc */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = { 154959,  5, 0 } }, /* no-ip */

    /* entries 2261 to 2266 */
    { .label = { 125863,  7, 0 } }, /* cloudns */
    { .label = {  87231,  9, 0 } }, /* ftpaccess */
    { .label = {  57546, 11, 0 } }, /* game-server */
    { .label = { 107269,  8, 0 } }, /* myphotos */
    { .label = {  87629,  9, 0 } }, /* scrapping */
    { .label = {  34844, 13, 0 } }, /* fantasyleague */

    /* entry 2267 */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entry 2268 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2269 to 2270 */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = { 144254,  6, 0 } }, /* gotdns */

    /* entries 2271 to 2285 */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {    204,  2, 0 } }, /* ed */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {   1443,  4, 0 } }, /* asso */
    { .label = {  14202, 15, 0 } }, /* xn--aroport-bya */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = { 128744,  6, 0 } }, /* presse */
    { .label = {    139,  2, 0 } }, /* md */
    { .label = { 155281,  4, 0 } }, /* gouv */

    /* entries 2286 to 2288 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 158453,  3, 1 } }, { .child = { 2289, 1 } }, /* www */

    /* entry 2289 */
    { .label = {     12,  1, 0 } }, /* ! */

    /* entries 2290 to 2294 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2295 to 2298 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */

    /* entries 2299 to 2343 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {    108,  3, 1 } }, { .child = { 2344, 1 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  59438, 10, 0 } }, /* xn--55qx5d */
    { .label = {  59504, 10, 0 } }, /* xn--io0a7i */
    { .label = {  59557, 10, 0 } }, /* xn--od0alg */
    { .label = {    111,  2, 0 } }, /* ah */
    { .label = {  14029,  2, 0 } }, /* bj */
    { .label = {  32958,  2, 0 } }, /* cq */
    { .label = {  12181,  2, 0 } }, /* fj */
    { .label = {   7094,  2, 0 } }, /* gd */
    { .label = {    421,  2, 0 } }, /* gs */
    { .label = {   1123,  2, 0 } }, /* gz */
    { .label = {    847,  2, 0 } }, /* gx */
    { .label = {    848,  2, 0 } }, /* ha */
    { .label = {    333,  2, 0 } }, /* hb */
    { .label = {    707,  2, 0 } }, /* he */
    { .label = {    197,  2, 0 } }, /* hi */
    { .label = {    324,  2, 0 } }, /* hl */
    { .label = {    434,  2, 0 } }, /* hn */
    { .label = {   8019,  2, 0 } }, /* jl */
    { .label = {   2893,  2, 0 } }, /* js */
    { .label = {   4881,  2, 0 } }, /* jx */
    { .label = {    506,  2, 0 } }, /* ln */
    { .label = {    473,  2, 0 } }, /* nm */
    { .label = {    548,  2, 0 } }, /* nx */
    { .label = {    513,  2, 0 } }, /* qh */
    { .label = {   3965,  2, 0 } }, /* sc */
    { .label = {    500,  2, 0 } }, /* sd */
    { .label = {    191,  2, 0 } }, /* sh */
    { .label = {     90,  2, 0 } }, /* sn */
    { .label = {    164,  2, 0 } }, /* sx */
    { .label = {    990,  2, 0 } }, /* tj */
    { .label = {     10,  2, 0 } }, /* xj */
    { .label = {   1142,  2, 0 } }, /* xz */
    { .label = {   1462,  2, 0 } }, /* yn */
    { .label = {   9175,  2, 0 } }, /* zj */
    { .label = {   1313,  2, 0 } }, /* hk */
    { .label = {    221,  2, 0 } }, /* mo */
    { .label = {    345,  2, 0 } }, /* tw */

    /* entries 2344 to 2345 */
    { .label = {  86892,  9, 1 } }, { .child = { 2346, 2 } }, /* amazonaws */

    /* entries 2346 to 2349 */
    { .label = {  15856,  7, 1 } }, { .child = { 2350, 1 } }, /* compute */
    { .label = {  69975, 10, 1 } }, { .child = { 2351, 1 } }, /* cn-north-1 */

    /* entry 2350 */
    { .label = {  69975, 10, 0 } }, /* cn-north-1 */

    /* entry 2351 */
    { .label = {   2292,  2, 0 } }, /* s3 */

    /* entries 2352 to 2365 */
    { .label = {  11884,  4, 0 } }, /* arts */
    { .label = {    108,  3, 1 } }, { .child = { 2366, 1 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = { 105297,  4, 0 } }, /* firm */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    175,  3, 0 } }, /* rec */
    { .label = {  26804,  3, 0 } }, /* web */

    /* entry 2366 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2367 to 2649 */
    { .label = {  86892,  9, 1 } }, { .child = { 2650, 20 } }, /* amazonaws */
    { .label = {  13146, 16, 0 } }, /* elasticbeanstalk */
    { .label = {  70023, 10, 0 } }, /* on-aptible */
    { .label = {  87020,  9, 0 } }, /* myasustor */
    { .label = {  70067, 10, 0 } }, /* betainabox */
    { .label = {     47,  2, 0 } }, /* ar */
    { .label = {    607,  2, 0 } }, /* br */
    { .label = {   1484,  2, 0 } }, /* cn */
    { .label = {     46,  2, 0 } }, /* de */
    { .label = {   1493,  2, 0 } }, /* eu */
    { .label = {   1364,  2, 0 } }, /* gb */
    { .label = {   1315,  2, 0 } }, /* hu */
    { .label = { 157443,  3, 0 } }, /* jpn */
    { .label = {    437,  2, 0 } }, /* kr */
    { .label = {  12849,  3, 0 } }, /* mex */
    { .label = {    154,  2, 0 } }, /* no */
    { .label = {   9317,  2, 0 } }, /* qc */
    { .label = {    206,  2, 0 } }, /* ru */
    { .label = {     43,  2, 0 } }, /* sa */
    { .label = {     54,  2, 0 } }, /* se */
    { .label = {   2425,  2, 0 } }, /* uk */
    { .label = {   1354,  2, 0 } }, /* us */
    { .label = {   6670,  2, 0 } }, /* uy */
    { .label = {    395,  2, 0 } }, /* za */
    { .label = {  63876,  6, 0 } }, /* africa */
    { .label = {   1209,  2, 0 } }, /* gr */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  33473, 13, 0 } }, /* xenapponazure */
    { .label = {  19372, 15, 0 } }, /* cloudcontrolled */
    { .label = {  19440, 15, 0 } }, /* cloudcontrolapp */
    { .label = {  43948, 12, 0 } }, /* dreamhosters */
    { .label = { 125959,  7, 0 } }, /* mydrobo */
    { .label = {  26057, 14, 0 } }, /* dyndns-at-home */
    { .label = {  26120, 14, 0 } }, /* dyndns-at-work */
    { .label = {  57091, 11, 0 } }, /* dyndns-blog */
    { .label = {  57143, 11, 0 } }, /* dyndns-free */
    { .label = {  57194, 11, 0 } }, /* dyndns-home */
    { .label = {  87109,  9, 0 } }, /* dyndns-ip */
    { .label = {  57245, 11, 0 } }, /* dyndns-mail */
    { .label = {  33533, 13, 0 } }, /* dyndns-office */
    { .label = {  57295, 11, 0 } }, /* dyndns-pics */
    { .label = {  33595, 13, 0 } }, /* dyndns-remote */
    { .label = {  33653, 13, 0 } }, /* dyndns-server */
    { .label = {  70109, 10, 0 } }, /* dyndns-web */
    { .label = {  57347, 11, 0 } }, /* dyndns-wiki */
    { .label = {  57400, 11, 0 } }, /* dyndns-work */
    { .label = { 126025,  7, 0 } }, /* blogdns */
    { .label = { 126057,  7, 0 } }, /* cechire */
    { .label = { 106920,  8, 0 } }, /* dnsalias */
    { .label = { 126088,  7, 0 } }, /* dnsdojo */
    { .label = {  57499, 11, 0 } }, /* doesntexist */
    { .label = {  87152,  9, 0 } }, /* dontexist */
    { .label = { 126151,  7, 0 } }, /* doomdns */
    { .label = {  70204, 10, 0 } }, /* dyn-o-saur */
    { .label = { 106952,  8, 0 } }, /* dynalias */
    { .label = {  19509, 15, 0 } }, /* est-a-la-maison */
    { .label = {  19571, 15, 0 } }, /* est-a-la-masion */
    { .label = {  33767, 13, 0 } }, /* est-le-patron */
    { .label = {  13364, 16, 0 } }, /* est-mon-blogueur */
    { .label = { 126246,  7, 0 } }, /* from-ak */
    { .label = { 126278,  7, 0 } }, /* from-al */
    { .label = { 126310,  7, 0 } }, /* from-ar */
    { .label = { 126375,  7, 0 } }, /* from-ca */
    { .label = { 126440,  7, 0 } }, /* from-ct */
    { .label = { 126473,  7, 0 } }, /* from-dc */
    { .label = { 126507,  7, 0 } }, /* from-de */
    { .label = { 126540,  7, 0 } }, /* from-fl */
    { .label = { 126575,  7, 0 } }, /* from-ga */
    { .label = { 126607,  7, 0 } }, /* from-hi */
    { .label = { 126640,  7, 0 } }, /* from-ia */
    { .label = { 126671,  7, 0 } }, /* from-id */
    { .label = { 126704,  7, 0 } }, /* from-il */
    { .label = { 126737,  7, 0 } }, /* from-in */
    { .label = { 126769,  7, 0 } }, /* from-ks */
    { .label = { 126802,  7, 0 } }, /* from-ky */
    { .label = { 126869,  7, 0 } }, /* from-ma */
    { .label = { 126901,  7, 0 } }, /* from-md */
    { .label = { 126968,  7, 0 } }, /* from-mi */
    { .label = { 127001,  7, 0 } }, /* from-mn */
    { .label = { 127034,  7, 0 } }, /* from-mo */
    { .label = { 127067,  7, 0 } }, /* from-ms */
    { .label = { 127100,  7, 0 } }, /* from-mt */
    { .label = { 127133,  7, 0 } }, /* from-nc */
    { .label = { 127166,  7, 0 } }, /* from-nd */
    { .label = { 127199,  7, 0 } }, /* from-ne */
    { .label = { 127231,  7, 0 } }, /* from-nh */
    { .label = { 127264,  7, 0 } }, /* from-nj */
    { .label = { 127299,  7, 0 } }, /* from-nm */
    { .label = { 127332,  7, 0 } }, /* from-nv */
    { .label = { 127400,  7, 0 } }, /* from-oh */
    { .label = { 127433,  7, 0 } }, /* from-ok */
    { .label = { 127466,  7, 0 } }, /* from-or */
    { .label = { 127498,  7, 0 } }, /* from-pa */
    { .label = { 127531,  7, 0 } }, /* from-pr */
    { .label = { 127565,  7, 0 } }, /* from-ri */
    { .label = { 127597,  7, 0 } }, /* from-sc */
    { .label = { 127630,  7, 0 } }, /* from-sd */
    { .label = { 127663,  7, 0 } }, /* from-tn */
    { .label = { 127695,  7, 0 } }, /* from-tx */
    { .label = { 127729,  7, 0 } }, /* from-ut */
    { .label = { 127762,  7, 0 } }, /* from-va */
    { .label = { 127795,  7, 0 } }, /* from-vt */
    { .label = { 127829,  7, 0 } }, /* from-wa */
    { .label = { 127863,  7, 0 } }, /* from-wi */
    { .label = { 127898,  7, 0 } }, /* from-wv */
    { .label = { 127935,  7, 0 } }, /* from-wy */
    { .label = { 127972,  7, 0 } }, /* getmyip */
    { .label = { 144254,  6, 0 } }, /* gotdns */
    { .label = {  70337, 10, 0 } }, /* hobby-site */
    { .label = {  87351,  9, 0 } }, /* homelinux */
    { .label = { 107022,  8, 0 } }, /* homeunix */
    { .label = {  87393,  9, 0 } }, /* iamallama */
    { .label = {  26185, 14, 0 } }, /* is-a-anarchist */
    { .label = {  44104, 12, 0 } }, /* is-a-blogger */
    { .label = {  19699, 15, 0 } }, /* is-a-bookkeeper */
    { .label = {  26302, 14, 0 } }, /* is-a-bulls-fan */
    { .label = {  44157, 12, 0 } }, /* is-a-caterer */
    { .label = {  87429,  9, 0 } }, /* is-a-chef */
    { .label = {  10004, 17, 0 } }, /* is-a-conservative */
    { .label = { 107059,  8, 0 } }, /* is-a-cpa */
    { .label = {   7291, 18, 0 } }, /* is-a-cubicle-slave */
    { .label = {  33881, 13, 0 } }, /* is-a-democrat */
    { .label = {  33936, 13, 0 } }, /* is-a-designer */
    { .label = {  57642, 11, 0 } }, /* is-a-doctor */
    { .label = {   2401, 21, 0 } }, /* is-a-financialadvisor */
    { .label = {  87470,  9, 0 } }, /* is-a-geek */
    { .label = {  70383, 10, 0 } }, /* is-a-green */
    { .label = {  87509,  9, 0 } }, /* is-a-guru */
    { .label = {  13436, 16, 0 } }, /* is-a-hard-worker */
    { .label = {  57689, 11, 0 } }, /* is-a-hunter */
    { .label = {  19830, 15, 0 } }, /* is-a-landscaper */
    { .label = {  57784, 11, 0 } }, /* is-a-lawyer */
    { .label = {  44206, 12, 0 } }, /* is-a-liberal */
    { .label = {  13507, 16, 0 } }, /* is-a-libertarian */
    { .label = {  70425, 10, 0 } }, /* is-a-llama */
    { .label = {  33991, 13, 0 } }, /* is-a-musician */
    { .label = {  26423, 14, 0 } }, /* is-a-nascarfan */
    { .label = {  70467, 10, 0 } }, /* is-a-nurse */
    { .label = {  44257, 12, 0 } }, /* is-a-painter */
    { .label = {   3357, 20, 0 } }, /* is-a-personaltrainer */
    { .label = {  10077, 17, 0 } }, /* is-a-photographer */
    { .label = {  57834, 11, 0 } }, /* is-a-player */
    { .label = {  19961, 15, 0 } }, /* is-a-republican */
    { .label = {  34046, 13, 0 } }, /* is-a-rockstar */
    { .label = {  26480, 14, 0 } }, /* is-a-socialist */
    { .label = {  44358, 12, 0 } }, /* is-a-student */
    { .label = {  44409, 12, 0 } }, /* is-a-teacher */
    { .label = {  57931, 11, 0 } }, /* is-a-techie */
    { .label = {  26538, 14, 0 } }, /* is-a-therapist */
    { .label = {  13572, 16, 0 } }, /* is-an-accountant */
    { .label = {  57978, 11, 0 } }, /* is-an-actor */
    { .label = {  34100, 13, 0 } }, /* is-an-actress */
    { .label = {  20027, 15, 0 } }, /* is-an-anarchist */
    { .label = {  44459, 12, 0 } }, /* is-an-artist */
    { .label = {  26597, 14, 0 } }, /* is-an-engineer */
    { .label = {  10152, 17, 0 } }, /* is-an-entertainer */
    { .label = {  44507, 12, 0 } }, /* is-certified */
    { .label = { 128067,  7, 0 } }, /* is-gone */
    { .label = {  34153, 13, 0 } }, /* is-into-anime */
    { .label = {  44560, 12, 0 } }, /* is-into-cars */
    { .label = {  13638, 16, 0 } }, /* is-into-cartoons */
    { .label = {  34207, 13, 0 } }, /* is-into-games */
    { .label = { 128097,  7, 0 } }, /* is-leet */
    { .label = {  13704, 16, 0 } }, /* is-not-certified */
    { .label = { 107166,  8, 0 } }, /* is-slick */
    { .label = {  58023, 11, 0 } }, /* is-uberleet */
    { .label = {  20088, 15, 0 } }, /* is-with-theband */
    { .label = { 107202,  8, 0 } }, /* isa-geek */
    { .label = {  34323, 13, 0 } }, /* isa-hockeynut */
    { .label = {  13774, 16, 0 } }, /* issmarterthanyou */
    { .label = {  87588,  9, 0 } }, /* likes-pie */
    { .label = {  70685, 10, 0 } }, /* likescandy */
    { .label = { 107307,  8, 0 } }, /* neat-url */
    { .label = {  13841, 16, 0 } }, /* saves-the-whales */
    { .label = { 144337,  6, 0 } }, /* selfip */
    { .label = {  26655, 14, 0 } }, /* sells-for-less */
    { .label = {  58224, 11, 0 } }, /* sells-for-u */
    { .label = { 107376,  8, 0 } }, /* servebbs */
    { .label = {  70823, 10, 0 } }, /* simple-url */
    { .label = {  34557, 13, 0 } }, /* space-to-rent */
    { .label = {  44838, 12, 0 } }, /* teaches-yoga */
    { .label = {  26718, 14, 0 } }, /* writesthisblog */
    { .label = { 107567,  8, 1 } }, { .child = { 2688, 4 } }, /* evennode */
    { .label = { 154787,  5, 1 } }, { .child = { 2692, 1 } }, /* fbsbx */
    { .label = {  58275, 11, 0 } }, /* firebaseapp */
    { .label = { 107602,  8, 0 } }, /* flynnhub */
    { .label = {  70914, 10, 0 } }, /* freebox-os */
    { .label = {  87709,  9, 0 } }, /* freeboxos */
    { .label = {  10220, 17, 0 } }, /* githubusercontent */
    { .label = {   1302, 11, 1 } }, { .child = { 2693, 3 } }, /* githubcloud */
    { .label = {   1302, 22, 1 } }, { .child = { 2700, 1 } }, /* githubcloudusercontent */
    { .label = {    465,  2, 0 } }, /* ro */
    { .label = { 158267,  4, 1 } }, { .child = { 2701, 1 } }, /* 0emm */
    { .label = { 128256,  7, 0 } }, /* appspot */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = { 107751,  8, 0 } }, /* codespot */
    { .label = {  70960, 10, 0 } }, /* googleapis */
    { .label = {  71004, 10, 0 } }, /* googlecode */
    { .label = {   7372, 18, 0 } }, /* pagespeedmobilizer */
    { .label = {  44890, 12, 0 } }, /* publishproxy */
    { .label = {  71049, 10, 0 } }, /* withgoogle */
    { .label = {  58324, 11, 0 } }, /* withyoutube */
    { .label = {  87750,  9, 0 } }, /* herokuapp */
    { .label = {  87792,  9, 0 } }, /* herokussl */
    { .label = { 144532,  6, 1 } }, { .child = { 2702, 1 } }, /* joyent */
    { .label = {  87832,  9, 1 } }, { .child = { 2705, 1 } }, /* meteorapp */
    { .label = {  17395,  2, 0 } }, /* 4u */
    { .label = { 128289,  7, 0 } }, /* nfshost */
    { .label = { 107933,  8, 0 } }, /* blogsyte */
    { .label = {  71185, 10, 0 } }, /* ciscofreak */
    { .label = {  71274, 10, 0 } }, /* damnserver */
    { .label = {  58521, 11, 0 } }, /* ditchyourip */
    { .label = {  71317, 10, 0 } }, /* dnsiskinky */
    { .label = { 154886,  5, 0 } }, /* dynns */
    { .label = {  71362, 10, 0 } }, /* geekgalaxy */
    { .label = {  10294, 17, 0 } }, /* health-carereform */
    { .label = {  20156, 15, 0 } }, /* homesecuritymac */
    { .label = {  27027, 14, 0 } }, /* homesecuritypc */
    { .label = {  10368, 17, 0 } }, /* myactivedirectory */
    { .label = {  13984, 16, 0 } }, /* mysecuritycamera */
    { .label = {  71408, 10, 0 } }, /* net-freaks */
    { .label = {  87955,  9, 0 } }, /* onthewifi */
    { .label = {  71451, 10, 0 } }, /* point2this */
    { .label = {  71499, 10, 0 } }, /* quicksytes */
    { .label = {  20223, 15, 0 } }, /* securitytactics */
    { .label = {  34900, 13, 0 } }, /* serveexchange */
    { .label = {  58573, 11, 0 } }, /* servehumour */
    { .label = { 108042,  8, 0 } }, /* servep2p */
    { .label = {  45060, 12, 0 } }, /* servesarcasm */
    { .label = {  58623, 11, 0 } }, /* stufftoread */
    { .label = {  34958, 13, 0 } }, /* unusualperson */
    { .label = {  45110, 12, 0 } }, /* workisboring */
    { .label = {  71591, 10, 0 } }, /* 3utilities */
    { .label = { 108121,  8, 0 } }, /* ddnsking */
    { .label = { 155009,  5, 0 } }, /* myvnc */
    { .label = {  87997,  9, 0 } }, /* servebeer */
    { .label = {   7455, 18, 0 } }, /* servecounterstrike */
    { .label = { 107412,  8, 0 } }, /* serveftp */
    { .label = {  87670,  9, 0 } }, /* servegame */
    { .label = {  35015, 13, 0 } }, /* servehalflife */
    { .label = {  88077,  9, 0 } }, /* servehttp */
    { .label = { 108157,  8, 0 } }, /* serveirc */
    { .label = { 108192,  8, 0 } }, /* servemp3 */
    { .label = {  88118,  9, 0 } }, /* servepics */
    { .label = {  71681, 10, 0 } }, /* servequake */
    { .label = {  71728, 10, 0 } }, /* operaunite */
    { .label = {  20288, 15, 0 } }, /* outsystemscloud */
    { .label = {  58672, 11, 0 } }, /* ownprovider */
    { .label = { 155059,  5, 0 } }, /* pgfog */
    { .label = {  45164, 12, 0 } }, /* pagefrontapp */
    { .label = {  58724, 11, 0 } }, /* gotpantheon */
    { .label = { 155112,  5, 1 } }, { .child = { 2706, 1 } }, /* prgmr */
    { .label = { 158904,  3, 0 } }, /* qa2 */
    { .label = {  20356, 15, 0 } }, /* dev-myqnapcloud */
    { .label = {  10445, 17, 0 } }, /* alpha-myqnapcloud */
    { .label = {  10472, 11, 0 } }, /* myqnapcloud */
    { .label = { 108304,  8, 0 } }, /* rackmaze */
    { .label = { 128479,  7, 0 } }, /* rhcloud */
    { .label = { 144840,  6, 0 } }, /* logoip */
    { .label = {  14055, 16, 0 } }, /* firewall-gateway */
    { .label = {  45269, 12, 0 } }, /* myshopblocks */
    { .label = { 155159,  5, 0 } }, /* 1kapp */
    { .label = { 108372,  8, 0 } }, /* appchizi */
    { .label = { 108412,  8, 0 } }, /* applinzi */
    { .label = {  71883,  7, 0 } }, /* sinaapp */
    { .label = {  71867, 10, 0 } }, /* vipsinaapp */
    { .label = {  58825, 11, 1 } }, { .child = { 2707, 2 } }, /* bounty-full */
    { .label = { 128545,  7, 0 } }, /* dsmynas */
    { .label = { 108486,  8, 0 } }, /* familyds */
    { .label = { 128576,  7, 0 } }, /* bloxcms */
    { .label = {  14130, 16, 0 } }, /* townnews-staging */
    { .label = {   1313,  2, 0 } }, /* hk */
    { .label = { 108595,  8, 0 } }, /* yolasite */

    /* entries 2650 to 2673 */
    { .label = {  15856,  7, 1 } }, { .child = { 2674, 10 } }, /* compute */
    { .label = {  86932,  9, 1 } }, { .child = { 2684, 2 } }, /* compute-1 */
    { .label = {  86978,  9, 0 } }, /* us-east-1 */
    { .label = {   4202,  3, 0 } }, /* elb */
    { .label = {   2292,  2, 0 } }, /* s3 */
    { .label = {   9600, 17, 0 } }, /* s3-ap-northeast-1 */
    { .label = {   9681, 17, 0 } }, /* s3-ap-northeast-2 */
    { .label = {   9763, 17, 0 } }, /* s3-ap-southeast-1 */
    { .label = {   9845, 17, 0 } }, /* s3-ap-southeast-2 */
    { .label = {  19298, 15, 0 } }, /* s3-eu-central-1 */
    { .label = {  43579, 12, 0 } }, /* s3-eu-west-1 */
    { .label = {  33342, 13, 0 } }, /* s3-external-1 */
    { .label = {  33407, 13, 0 } }, /* s3-external-2 */
    { .label = {   2292, 21, 0 } }, /* s3-fips-us-gov-west-1 */
    { .label = {  43643, 12, 0 } }, /* s3-sa-east-1 */
    { .label = {  13212, 16, 0 } }, /* s3-us-gov-west-1 */
    { .label = {  43701, 12, 0 } }, /* s3-us-west-1 */
    { .label = {  43765, 12, 0 } }, /* s3-us-west-2 */
    { .label = {   9699, 14, 1 } }, { .child = { 2686, 1 } }, /* ap-northeast-2 */
    { .label = {  19316, 12, 1 } }, { .child = { 2687, 1 } }, /* eu-central-1 */

    /* entries 2674 to 2683 */
    { .label = {   9618, 14, 0 } }, /* ap-northeast-1 */
    { .label = {   9699, 14, 0 } }, /* ap-northeast-2 */
    { .label = {   9781, 14, 0 } }, /* ap-southeast-1 */
    { .label = {   9863, 14, 0 } }, /* ap-southeast-2 */
    { .label = {  19316, 12, 0 } }, /* eu-central-1 */
    { .label = {  43597,  9, 0 } }, /* eu-west-1 */
    { .label = {  43661,  9, 0 } }, /* sa-east-1 */
    { .label = {   2335, 13, 0 } }, /* us-gov-west-1 */
    { .label = {  43719,  9, 0 } }, /* us-west-1 */
    { .label = {  43783,  9, 0 } }, /* us-west-2 */

    /* entries 2684 to 2685 */
    { .label = { 158863,  3, 0 } }, /* z-1 */
    { .label = { 158883,  3, 0 } }, /* z-2 */

    /* entry 2686 */
    { .label = {   2292,  2, 0 } }, /* s3 */

    /* entry 2687 */
    { .label = {   2292,  2, 0 } }, /* s3 */

    /* entries 2688 to 2691 */
    { .label = { 158177,  4, 0 } }, /* eu-1 */
    { .label = { 158199,  4, 0 } }, /* eu-2 */
    { .label = { 158222,  4, 0 } }, /* us-1 */
    { .label = { 158244,  4, 0 } }, /* us-2 */

    /* entry 2692 */
    { .label = {  71898,  4, 0 } }, /* apps */

    /* entries 2693 to 2697 */
    { .label = {   4712,  3, 1 } }, { .child = { 2698, 1 } }, /* api */
    { .label = {  10433,  3, 1 } }, { .child = { 2699, 1 } }, /* ext */
    { .label = {  25156,  4, 0 } }, /* gist */

    /* entry 2698 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2699 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2700 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2701 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2702 to 2703 */
    { .label = {  20551,  3, 1 } }, { .child = { 2704, 1 } }, /* cns */

    /* entry 2704 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2705 */
    { .label = {   1493,  2, 0 } }, /* eu */

    /* entry 2706 */
    { .label = {    293,  3, 0 } }, /* xen */

    /* entries 2707 to 2708 */
    { .label = {  10445,  5, 0 } }, /* alpha */
    { .label = {  70067,  4, 0 } }, /* beta */

    /* entries 2709 to 2715 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    204,  2, 0 } }, /* ed */
    { .label = {   2245,  2, 0 } }, /* fi */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {     43,  2, 0 } }, /* sa */

    /* entries 2716 to 2721 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 105545,  3, 0 } }, /* inf */

    /* entry 2722 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2723 to 2726 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 2727 to 2728 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   9805,  3, 0 } }, /* ath */

    /* entries 2729 to 2742 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {    108,  3, 1 } }, { .child = { 2743, 1 } }, /* com */
    { .label = { 108929,  7, 0 } }, /* ekloges */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   5935,  3, 0 } }, /* ltd */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  59608, 10, 0 } }, /* parliament */
    { .label = {  18801,  5, 0 } }, /* press */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = {    359,  2, 0 } }, /* tm */

    /* entry 2743 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2744 to 2747 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  98818,  5, 0 } }, /* realm */
    { .label = {   9582,  2, 0 } }, /* e4 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2748 to 2771 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 125928,  7, 0 } }, /* dnshome */
    { .label = {  19633, 15, 0 } }, /* fuettertdasnetz */
    { .label = {  70509, 10, 0 } }, /* isteingeek */
    { .label = { 128157,  7, 0 } }, /* istmein */
    { .label = {  70596, 10, 0 } }, /* lebtimnetz */
    { .label = {  70642, 10, 0 } }, /* leitungsen */
    { .label = {  34613, 13, 0 } }, /* traeumtgerade */
    { .label = { 154733,  5, 1 } }, { .child = { 2772, 2 } }, /* ddnss */
    { .label = { 128220,  7, 0 } }, /* dyndns1 */
    { .label = { 107519,  8, 0 } }, /* dyn-ip24 */
    { .label = {  26781, 14, 1 } }, { .child = { 2774, 1 } }, /* home-webserver */
    { .label = {  34667, 13, 0 } }, /* myhome-server */
    { .label = { 144849,  4, 0 } }, /* goip */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = {  71140, 10, 0 } }, /* keymachine */
    { .label = { 144840,  6, 0 } }, /* logoip */
    { .label = {  14055, 16, 0 } }, /* firewall-gateway */
    { .label = {  71770, 10, 0 } }, /* my-gateway */
    { .label = {  88199,  9, 0 } }, /* my-router */
    { .label = { 155136,  5, 0 } }, /* spdns */
    { .label = {  71956, 10, 0 } }, /* taifun-dns */

    /* entries 2772 to 2773 */
    { .label = {  26057,  3, 0 } }, /* dyn */
    { .label = {  26057,  6, 0 } }, /* dyndns */

    /* entry 2774 */
    { .label = {  26057,  3, 0 } }, /* dyn */

    /* entries 2775 to 2780 */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = { 105297,  4, 0 } }, /* firm */
    { .label = {   7016,  3, 0 } }, /* reg */
    { .label = { 144991,  5, 0 } }, /* store */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2781 to 2785 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entries 2786 to 2795 */
    { .label = {   7810,  3, 0 } }, /* art */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   9415,  3, 0 } }, /* sld */
    { .label = {  26804,  3, 0 } }, /* web */

    /* entries 2796 to 2803 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   1443,  4, 0 } }, /* asso */
    { .label = {  37575,  3, 0 } }, /* pol */
    { .label = {   7810,  3, 0 } }, /* art */

    /* entries 2804 to 2815 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2422,  3, 0 } }, /* fin */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {  20570,  3, 0 } }, /* mil */

    /* entries 2816 to 2826 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  35144,  4, 0 } }, /* riik */
    { .label = {   3031,  3, 0 } }, /* lib */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {    108,  3, 1 } }, { .child = { 2827, 1 } }, /* com */
    { .label = {    665,  3, 0 } }, /* pri */
    { .label = {   2343,  3, 0 } }, /* aip */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   6646,  3, 0 } }, /* fie */

    /* entry 2827 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2828 to 2837 */
    { .label = {    108,  3, 1 } }, { .child = { 2838, 1 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2729,  3, 0 } }, /* eun */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   6005,  3, 0 } }, /* sci */

    /* entry 2838 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entry 2839 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2840 to 2845 */
    { .label = {    108,  3, 1 } }, { .child = { 2846, 1 } }, /* com */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {  37716,  3, 0 } }, /* edu */

    /* entry 2846 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2847 to 2854 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  13352,  3, 0 } }, /* net */

    /* entries 2855 to 2860 */
    { .label = {  26254,  4, 0 } }, /* mycd */
    { .label = { 125863,  7, 0 } }, /* cloudns */
    { .label = {  35075, 13, 0 } }, /* wellbeingzone */
    { .label = { 155136,  5, 0 } }, /* spdns */
    { .label = { 108562,  8, 1 } }, { .child = { 2861, 1 } }, /* transurl */

    /* entry 2861 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2862 to 2865 */
    { .label = {  82320,  5, 0 } }, /* aland */
    { .label = {   1578,  2, 0 } }, /* dy */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = {  14888,  3, 0 } }, /* iki */

    /* entry 2866 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 2867 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2868 to 2896 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {   1443,  4, 0 } }, /* asso */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {  25887,  3, 0 } }, /* prd */
    { .label = { 128744,  6, 0 } }, /* presse */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = {  88565,  8, 0 } }, /* aeroport */
    { .label = { 108960,  7, 0 } }, /* assedic */
    { .label = { 128770,  6, 0 } }, /* avocat */
    { .label = { 128795,  6, 0 } }, /* avoues */
    { .label = {    876,  3, 0 } }, /* cci */
    { .label = {  72353,  9, 0 } }, /* chambagri */
    { .label = {    192, 21, 0 } }, /* chirurgiens-dentistes */
    { .label = {   5391, 18, 0 } }, /* experts-comptables */
    { .label = {  14270, 15, 0 } }, /* geometre-expert */
    { .label = { 155281,  4, 0 } }, /* gouv */
    { .label = { 145011,  5, 0 } }, /* greta */
    { .label = {  10597, 16, 0 } }, /* huissier-justice */
    { .label = { 108989,  7, 0 } }, /* medecin */
    { .label = {  88598,  8, 0 } }, /* notaires */
    { .label = {  49636, 10, 0 } }, /* pharmacien */
    { .label = {  14233,  4, 0 } }, /* port */
    { .label = {  45516, 11, 0 } }, /* veterinaire */
    { .label = { 144425,  6, 0 } }, /* fbx-os */
    { .label = { 154839,  5, 0 } }, /* fbxos */
    { .label = {  70914, 10, 0 } }, /* freebox-os */
    { .label = {  87709,  9, 0 } }, /* freeboxos */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = {    192, 31, 0 } }, /* chirurgiens-dentistes-en-france */

    /* entries 2897 to 2903 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = { 158496,  3, 0 } }, /* pvt */

    /* entries 2904 to 2906 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 2907 to 2911 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  20570,  3, 0 } }, /* mil */

    /* entries 2912 to 2917 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {   5935,  3, 0 } }, /* ltd */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  21978,  3, 0 } }, /* mod */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 2918 to 2922 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 2923 to 2928 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */

    /* entries 2929 to 2934 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   7413,  4, 0 } }, /* mobi */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   1443,  4, 0 } }, /* asso */

    /* entries 2935 to 2940 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2941 to 2947 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {   6047,  3, 0 } }, /* ind */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entry 2948 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 2949 to 2954 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 2955 to 2978 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 158512,  3, 0 } }, /* idv */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  59438, 10, 0 } }, /* xn--55qx5d */
    { .label = {  45561, 11, 0 } }, /* xn--wcvs22d */
    { .label = {  45626, 11, 0 } }, /* xn--lcvr32d */
    { .label = {  59650, 10, 0 } }, /* xn--mxtq1m */
    { .label = {  59706, 10, 0 } }, /* xn--gmqw5a */
    { .label = {  72392,  9, 0 } }, /* xn--ciqpn */
    { .label = {  45689, 11, 0 } }, /* xn--gmq050i */
    { .label = {  59763, 10, 0 } }, /* xn--zf0avx */
    { .label = {  59504, 10, 0 } }, /* xn--io0a7i */
    { .label = {  59820, 10, 0 } }, /* xn--mk0axi */
    { .label = {  59557, 10, 0 } }, /* xn--od0alg */
    { .label = {  45758, 11, 0 } }, /* xn--od0aq3b */
    { .label = {  72439,  9, 0 } }, /* xn--tn0ag */
    { .label = {  59872, 10, 0 } }, /* xn--uc0atv */
    { .label = {  45821, 11, 0 } }, /* xn--uc0ay4a */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = {   5935,  3, 0 } }, /* ltd */
    { .label = {    654,  3, 0 } }, /* inc */

    /* entries 2979 to 2984 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {   7818,  3, 0 } }, /* gob */

    /* entries 2985 to 2989 */
    { .label = {    692,  2, 0 } }, /* iz */
    { .label = { 126246,  4, 0 } }, /* from */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 2990 to 3006 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  45280,  4, 0 } }, /* shop */
    { .label = { 105297,  4, 0 } }, /* firm */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = { 145031,  5, 0 } }, /* adult */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {   7810,  3, 0 } }, /* art */
    { .label = { 155301,  4, 0 } }, /* coop */
    { .label = {  37575,  3, 0 } }, /* pol */
    { .label = {   1443,  4, 0 } }, /* asso */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   3276,  3, 0 } }, /* rel */
    { .label = { 155281,  4, 0 } }, /* gouv */
    { .label = {   3378,  5, 0 } }, /* perso */

    /* entries 3007 to 3038 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    665,  4, 0 } }, /* priv */
    { .label = {  80288,  5, 0 } }, /* sport */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = { 155357,  4, 0 } }, /* 2000 */
    { .label = { 145053,  5, 0 } }, /* agrar */
    { .label = {  15764,  4, 0 } }, /* bolt */
    { .label = { 128821,  6, 0 } }, /* casino */
    { .label = { 104733,  4, 0 } }, /* city */
    { .label = { 109020,  7, 0 } }, /* erotica */
    { .label = { 109048,  7, 0 } }, /* erotika */
    { .label = {  78146,  4, 0 } }, /* film */
    { .label = { 145072,  5, 0 } }, /* forum */
    { .label = {  34241,  5, 0 } }, /* games */
    { .label = {  54179,  5, 0 } }, /* hotel */
    { .label = {  88629,  8, 0 } }, /* ingatlan */
    { .label = { 128845,  6, 0 } }, /* jogasz */
    { .label = {  88661,  8, 0 } }, /* konyvelo */
    { .label = { 145096,  5, 0 } }, /* lakas */
    { .label = {  87923,  5, 0 } }, /* media */
    { .label = {  14149,  4, 0 } }, /* news */
    { .label = { 128875,  6, 0 } }, /* reklam */
    { .label = {     54,  3, 0 } }, /* sex */
    { .label = {  45280,  4, 0 } }, /* shop */
    { .label = { 155393,  4, 0 } }, /* suli */
    { .label = { 155411,  4, 0 } }, /* szex */
    { .label = { 128901,  6, 0 } }, /* tozsde */
    { .label = { 128929,  6, 0 } }, /* utazas */
    { .label = { 145116,  5, 0 } }, /* video */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 3039 to 3050 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {     44,  2, 1 } }, { .child = { 3051, 1 } }, /* co */
    { .label = {  53680,  4, 0 } }, /* desa */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {   1538,  2, 0 } }, /* my */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {   4209,  3, 0 } }, /* sch */
    { .label = {  26804,  3, 0 } }, /* web */

    /* entry 3051 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 3052 to 3053 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 3054 to 3062 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 1 } }, { .child = { 3063, 1 } }, /* co */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  24244,  3, 0 } }, /* idf */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    117,  4, 0 } }, /* muni */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entry 3063 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 3064 to 3072 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 1 } }, { .child = { 3073, 2 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    860,  2, 0 } }, /* tt */
    { .label = {     55,  2, 0 } }, /* tv */
    { .label = {    465,  2, 0 } }, /* ro */

    /* entries 3073 to 3074 */
    { .label = {   5935,  3, 0 } }, /* ltd */
    { .label = { 158527,  3, 0 } }, /* plc */

    /* entries 3075 to 3088 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = { 105297,  4, 0 } }, /* firm */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    591,  3, 0 } }, /* gen */
    { .label = {   6047,  3, 0 } }, /* ind */
    { .label = {    127,  3, 0 } }, /* nic */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   3338,  3, 0 } }, /* res */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = { 125863,  7, 0 } }, /* cloudns */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 3089 to 3103 */
    { .label = { 125863,  7, 0 } }, /* cloudns */
    { .label = {  26057,  6, 0 } }, /* dyndns */
    { .label = {   5303, 19, 0 } }, /* barrel-of-knowledge */
    { .label = {   3264, 20, 0 } }, /* barrell-of-knowledge */
    { .label = { 126182,  7, 0 } }, /* for-our */
    { .label = {  87311,  9, 0 } }, /* groks-the */
    { .label = {  70293, 10, 0 } }, /* groks-this */
    { .label = {  33823, 13, 0 } }, /* here-for-more */
    { .label = {  70551, 10, 0 } }, /* knowsitall */
    { .label = { 144337,  6, 0 } }, /* selfip */
    { .label = { 144366,  6, 0 } }, /* webhop */
    { .label = { 107898,  8, 0 } }, /* nsupdate */
    { .label = { 144561,  6, 0 } }, /* dvrcam */
    { .label = {  45005, 12, 0 } }, /* ilovecollege */
    { .label = { 154959,  5, 0 } }, /* no-ip */

    /* entry 3104 */
    { .label = {   1493,  2, 0 } }, /* eu */

    /* entries 3105 to 3125 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  43830, 12, 0 } }, /* backplaneapp */
    { .label = { 125798,  7, 0 } }, /* boxfuse */
    { .label = {   9928, 17, 0 } }, /* browsersafetymark */
    { .label = { 154685,  5, 0 } }, /* dedyn */
    { .label = {  52541,  4, 0 } }, /* drud */
    { .label = {   1302,  6, 0 } }, /* github */
    { .label = { 144482,  6, 0 } }, /* gitlab */
    { .label = {  71096, 10, 0 } }, /* hasura-app */
    { .label = { 154864,  5, 0 } }, /* ngrok */
    { .label = {  19670,  3, 0 } }, /* nid */
    { .label = {  45219, 12, 0 } }, /* pantheonsite */
    { .label = { 108270,  8, 0 } }, /* protonet */
    { .label = {  51439,  3, 0 } }, /* hzc */
    { .label = { 108340,  8, 0 } }, /* sandcats */
    { .label = {  88240,  9, 0 } }, /* shiftedit */
    { .label = { 158308,  4, 1 } }, { .child = { 3126, 1 } }, /* lair */
    { .label = { 144892,  6, 1 } }, { .child = { 3127, 1 } }, /* stolos */
    { .label = { 108451,  8, 0 } }, /* spacekit */

    /* entry 3126 */
    { .label = {  71898,  4, 0 } }, /* apps */

    /* entry 3127 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3128 to 3133 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */

    /* entries 3134 to 3142 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {     88,  2, 0 } }, /* id */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   4209,  3, 0 } }, /* sch */
    { .label = {  14337, 15, 0 } }, /* xn--mgba3a4f16a */
    { .label = {  20494, 14, 0 } }, /* xn--mgba3a4fra */

    /* entries 3143 to 3150 */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = { 125895,  7, 0 } }, /* cupcake */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 3151 to 3519 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   5896,  3, 0 } }, /* abr */
    { .label = { 109076,  7, 0 } }, /* abruzzo */
    { .label = {  35249, 12, 0 } }, /* aosta-valley */
    { .label = {  45881, 11, 0 } }, /* aostavalley */
    { .label = {   2284,  3, 0 } }, /* bas */
    { .label = {  59924, 10, 0 } }, /* basilicata */
    { .label = {    217,  3, 0 } }, /* cal */
    { .label = {  15041,  8, 0 } }, /* calabria */
    { .label = {   8692,  3, 0 } }, /* cam */
    { .label = {  88699,  8, 0 } }, /* campania */
    { .label = {  20566, 14, 0 } }, /* emilia-romagna */
    { .label = {  27316, 13, 0 } }, /* emiliaromagna */
    { .label = {  13768,  3, 0 } }, /* emr */
    { .label = {  14424, 15, 0 } }, /* friuli-v-giulia */
    { .label = {  10669, 16, 0 } }, /* friuli-ve-giulia */
    { .label = {  14494, 15, 0 } }, /* friuli-vegiulia */
    { .label = {   1486, 21, 0 } }, /* friuli-venezia-giulia */
    { .label = {   2490, 20, 0 } }, /* friuli-veneziagiulia */
    { .label = {  20624, 14, 0 } }, /* friuli-vgiulia */
    { .label = {  20689, 14, 0 } }, /* friuliv-giulia */
    { .label = {  14563, 15, 0 } }, /* friulive-giulia */
    { .label = {  20754, 14, 0 } }, /* friulivegiulia */
    { .label = {   2581, 20, 0 } }, /* friulivenezia-giulia */
    { .label = {   3605, 19, 0 } }, /* friuliveneziagiulia */
    { .label = {  27369, 13, 0 } }, /* friulivgiulia */
    { .label = { 143195,  3, 0 } }, /* fvg */
    { .label = {  70859,  3, 0 } }, /* laz */
    { .label = { 145139,  5, 0 } }, /* lazio */
    { .label = {  38243,  3, 0 } }, /* lig */
    { .label = { 109111,  7, 0 } }, /* liguria */
    { .label = {  72484,  3, 0 } }, /* lom */
    { .label = {  72484,  9, 0 } }, /* lombardia */
    { .label = {  88732,  8, 0 } }, /* lombardy */
    { .label = { 109141,  7, 0 } }, /* lucania */
    { .label = {   9987,  3, 0 } }, /* mar */
    { .label = { 128955,  6, 0 } }, /* marche */
    { .label = {  11467,  3, 0 } }, /* mol */
    { .label = { 128981,  6, 0 } }, /* molise */
    { .label = {  88769,  8, 0 } }, /* piedmont */
    { .label = {  88805,  8, 0 } }, /* piemonte */
    { .label = {  14085,  3, 0 } }, /* pmn */
    { .label = {  96375,  3, 0 } }, /* pug */
    { .label = { 129007,  6, 0 } }, /* puglia */
    { .label = {     43,  3, 0 } }, /* sar */
    { .label = {  88840,  8, 0 } }, /* sardegna */
    { .label = {  88872,  8, 0 } }, /* sardinia */
    { .label = {  34022,  3, 0 } }, /* sic */
    { .label = { 109170,  7, 0 } }, /* sicilia */
    { .label = { 129035,  6, 0 } }, /* sicily */
    { .label = {   4117,  3, 0 } }, /* taa */
    { .label = {   4585,  3, 0 } }, /* tos */
    { .label = { 109199,  7, 0 } }, /* toscana */
    { .label = {  10743, 16, 0 } }, /* trentino-a-adige */
    { .label = {  14632, 15, 0 } }, /* trentino-aadige */
    { .label = {   3691, 19, 0 } }, /* trentino-alto-adige */
    { .label = {   5473, 18, 0 } }, /* trentino-altoadige */
    { .label = {  10809, 16, 0 } }, /* trentino-s-tirol */
    { .label = {  14693, 15, 0 } }, /* trentino-stirol */
    { .label = {   5547, 18, 0 } }, /* trentino-sud-tirol */
    { .label = {   7532, 17, 0 } }, /* trentino-sudtirol */
    { .label = {   3770, 19, 0 } }, /* trentino-sued-tirol */
    { .label = {   5624, 18, 0 } }, /* trentino-suedtirol */
    { .label = {  14755, 15, 0 } }, /* trentinoa-adige */
    { .label = {  20818, 14, 0 } }, /* trentinoaadige */
    { .label = {   5700, 18, 0 } }, /* trentinoalto-adige */
    { .label = {   7604, 17, 0 } }, /* trentinoaltoadige */
    { .label = {  14816, 15, 0 } }, /* trentinos-tirol */
    { .label = {  20874, 14, 0 } }, /* trentinostirol */
    { .label = {   7673, 17, 0 } }, /* trentinosud-tirol */
    { .label = {  10876, 16, 0 } }, /* trentinosudtirol */
    { .label = {   5774, 18, 0 } }, /* trentinosued-tirol */
    { .label = {   7745, 17, 0 } }, /* trentinosuedtirol */
    { .label = { 109226,  7, 0 } }, /* tuscany */
    { .label = {  15705,  3, 0 } }, /* umb */
    { .label = { 129063,  6, 0 } }, /* umbria */
    { .label = {  45928, 11, 0 } }, /* val-d-aosta */
    { .label = {  59964, 10, 0 } }, /* val-daosta */
    { .label = {  60006, 10, 0 } }, /* vald-aosta */
    { .label = {  72522,  9, 0 } }, /* valdaosta */
    { .label = {  45975, 11, 0 } }, /* valle-aosta */
    { .label = {  27429, 13, 0 } }, /* valle-d-aosta */
    { .label = {  35301, 12, 0 } }, /* valle-daosta */
    { .label = {  60048, 10, 0 } }, /* valleaosta */
    { .label = {  35352, 12, 0 } }, /* valled-aosta */
    { .label = {  46021, 11, 0 } }, /* valledaosta */
    { .label = {  35403, 12, 0 } }, /* vallee-aoste */
    { .label = {  46067, 11, 0 } }, /* valleeaoste */
    { .label = { 153042,  3, 0 } }, /* vao */
    { .label = {   3489,  3, 0 } }, /* vda */
    { .label = {   1519,  3, 0 } }, /* ven */
    { .label = { 129089,  6, 0 } }, /* veneto */
    { .label = {    320,  2, 0 } }, /* ag */
    { .label = {  72559,  9, 0 } }, /* agrigento */
    { .label = {     11,  2, 0 } }, /* al */
    { .label = {  46113, 11, 0 } }, /* alessandria */
    { .label = {   3728, 10, 0 } }, /* alto-adige */
    { .label = {   5510,  9, 0 } }, /* altoadige */
    { .label = {    124,  2, 0 } }, /* an */
    { .label = { 129115,  6, 0 } }, /* ancona */
    { .label = {   1582, 21, 0 } }, /* andria-barletta-trani */
    { .label = {   1666, 21, 0 } }, /* andria-trani-barletta */
    { .label = {   3851, 19, 0 } }, /* andriabarlettatrani */
    { .label = {   3925, 19, 0 } }, /* andriatranibarletta */
    { .label = {     18,  2, 0 } }, /* ao */
    { .label = {  27467,  5, 0 } }, /* aosta */
    { .label = {  35435,  5, 0 } }, /* aoste */
    { .label = {    505,  2, 0 } }, /* ap */
    { .label = {    438,  2, 0 } }, /* aq */
    { .label = { 109706,  6, 0 } }, /* aquila */
    { .label = {     47,  2, 0 } }, /* ar */
    { .label = { 129138,  6, 0 } }, /* arezzo */
    { .label = {  27485, 13, 0 } }, /* ascoli-piceno */
    { .label = {  35454, 12, 0 } }, /* ascolipiceno */
    { .label = {  10645,  4, 0 } }, /* asti */
    { .label = {    145,  2, 0 } }, /* at */
    { .label = {    667,  2, 0 } }, /* av */
    { .label = {  88903,  8, 0 } }, /* avellino */
    { .label = {    267,  2, 0 } }, /* ba */
    { .label = { 129167,  6, 0 } }, /* balsan */
    { .label = { 111221,  4, 0 } }, /* bari */
    { .label = {   1750, 21, 0 } }, /* barletta-trani-andria */
    { .label = {   3874, 19, 0 } }, /* barlettatraniandria */
    { .label = { 109257,  7, 0 } }, /* belluno */
    { .label = {  72596,  9, 0 } }, /* benevento */
    { .label = { 109289,  7, 0 } }, /* bergamo */
    { .label = {   4210,  2, 0 } }, /* bg */
    { .label = {   1329,  2, 0 } }, /* bi */
    { .label = { 129191,  6, 0 } }, /* biella */
    { .label = {    501,  2, 0 } }, /* bl */
    { .label = {    268,  2, 0 } }, /* bn */
    { .label = {    988,  2, 0 } }, /* bo */
    { .label = { 109319,  7, 0 } }, /* bologna */
    { .label = { 109349,  7, 0 } }, /* bolzano */
    { .label = { 145162,  5, 0 } }, /* bozen */
    { .label = {    607,  2, 0 } }, /* br */
    { .label = { 109381,  7, 0 } }, /* brescia */
    { .label = {  88938,  8, 0 } }, /* brindisi */
    { .label = {   1053,  2, 0 } }, /* bs */
    { .label = {    605,  2, 0 } }, /* bt */
    { .label = {   4648,  2, 0 } }, /* bz */
    { .label = {    135,  2, 0 } }, /* ca */
    { .label = {  88972,  8, 0 } }, /* cagliari */
    { .label = {  27542, 13, 0 } }, /* caltanissetta */
    { .label = {  14878, 15, 0 } }, /* campidano-medio */
    { .label = {  20931, 14, 0 } }, /* campidanomedio */
    { .label = {  60089, 10, 0 } }, /* campobasso */
    { .label = {   7816, 17, 0 } }, /* carbonia-iglesias */
    { .label = {  10943, 16, 0 } }, /* carboniaiglesias */
    { .label = {  27593, 13, 0 } }, /* carrara-massa */
    { .label = {  35506, 12, 0 } }, /* carraramassa */
    { .label = { 109410,  7, 0 } }, /* caserta */
    { .label = { 109437,  7, 0 } }, /* catania */
    { .label = {  72635,  9, 0 } }, /* catanzaro */
    { .label = {   2279,  2, 0 } }, /* cb */
    { .label = {    269,  2, 0 } }, /* ce */
    { .label = {  35551, 12, 0 } }, /* cesena-forli */
    { .label = {  46156, 11, 0 } }, /* cesenaforli */
    { .label = {    192,  2, 0 } }, /* ch */
    { .label = { 129217,  6, 0 } }, /* chieti */
    { .label = {    257,  2, 0 } }, /* ci */
    { .label = {   1197,  2, 0 } }, /* cl */
    { .label = {   1484,  2, 0 } }, /* cn */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  63999,  4, 0 } }, /* como */
    { .label = { 109463,  7, 0 } }, /* cosenza */
    { .label = {   1019,  2, 0 } }, /* cr */
    { .label = { 109494,  7, 0 } }, /* cremona */
    { .label = { 109523,  7, 0 } }, /* crotone */
    { .label = {    339,  2, 0 } }, /* cs */
    { .label = {    859,  2, 0 } }, /* ct */
    { .label = { 145186,  5, 0 } }, /* cuneo */
    { .label = {   6751,  2, 0 } }, /* cz */
    { .label = {  20992, 14, 0 } }, /* dell-ogliastra */
    { .label = {  27643, 13, 0 } }, /* dellogliastra */
    { .label = {    128,  2, 0 } }, /* en */
    { .label = {  66054,  4, 0 } }, /* enna */
    { .label = {    129,  2, 0 } }, /* fc */
    { .label = {   4634,  2, 0 } }, /* fe */
    { .label = { 145208,  5, 0 } }, /* fermo */
    { .label = { 109552,  7, 0 } }, /* ferrara */
    { .label = {   6735,  2, 0 } }, /* fg */
    { .label = {   2245,  2, 0 } }, /* fi */
    { .label = { 109580,  7, 0 } }, /* firenze */
    { .label = {  89005,  8, 0 } }, /* florence */
    { .label = {   3205,  2, 0 } }, /* fm */
    { .label = { 129243,  6, 0 } }, /* foggia */
    { .label = {  35603, 12, 0 } }, /* forli-cesena */
    { .label = {  46203, 11, 0 } }, /* forlicesena */
    { .label = {    229,  2, 0 } }, /* fr */
    { .label = {  72672,  9, 0 } }, /* frosinone */
    { .label = {    591,  2, 0 } }, /* ge */
    { .label = { 145231,  5, 0 } }, /* genoa */
    { .label = { 129270,  6, 0 } }, /* genova */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = { 109613,  7, 0 } }, /* gorizia */
    { .label = {   1209,  2, 0 } }, /* gr */
    { .label = {  89041,  8, 0 } }, /* grosseto */
    { .label = {   7886, 17, 0 } }, /* iglesias-carbonia */
    { .label = {  11008, 16, 0 } }, /* iglesiascarbonia */
    { .label = {      1,  2, 0 } }, /* im */
    { .label = { 109644,  7, 0 } }, /* imperia */
    { .label = {    262,  2, 0 } }, /* is */
    { .label = { 109674,  7, 0 } }, /* isernia */
    { .label = {    437,  2, 0 } }, /* kr */
    { .label = {  72710,  9, 0 } }, /* la-spezia */
    { .label = { 109701,  7, 0 } }, /* laquila */
    { .label = {  89074,  8, 0 } }, /* laspezia */
    { .label = { 129296,  6, 0 } }, /* latina */
    { .label = {    497,  2, 0 } }, /* lc */
    { .label = {     99,  2, 0 } }, /* le */
    { .label = { 145251,  5, 0 } }, /* lecce */
    { .label = { 145274,  5, 0 } }, /* lecco */
    { .label = {      2,  2, 0 } }, /* li */
    { .label = { 109734,  7, 0 } }, /* livorno */
    { .label = {     66,  2, 0 } }, /* lo */
    { .label = {  44709,  4, 0 } }, /* lodi */
    { .label = {    213,  2, 0 } }, /* lt */
    { .label = {    645,  2, 0 } }, /* lu */
    { .label = { 145297,  5, 0 } }, /* lucca */
    { .label = {  89110,  8, 0 } }, /* macerata */
    { .label = { 109765,  7, 0 } }, /* mantova */
    { .label = {  27698, 13, 0 } }, /* massa-carrara */
    { .label = {  35655, 12, 0 } }, /* massacarrara */
    { .label = { 129319,  6, 0 } }, /* matera */
    { .label = {   3034,  2, 0 } }, /* mb */
    { .label = {   7969,  2, 0 } }, /* mc */
    { .label = {    123,  2, 0 } }, /* me */
    { .label = {  14944, 15, 0 } }, /* medio-campidano */
    { .label = {  21052, 14, 0 } }, /* mediocampidano */
    { .label = { 109794,  7, 0 } }, /* messina */
    { .label = {    639,  2, 0 } }, /* mi */
    { .label = { 129342,  5, 0 } }, /* milan */
    { .label = { 129342,  6, 0 } }, /* milano */
    { .label = {    363,  2, 0 } }, /* mn */
    { .label = {    221,  2, 0 } }, /* mo */
    { .label = { 129367,  6, 0 } }, /* modena */
    { .label = {  27748, 13, 0 } }, /* monza-brianza */
    { .label = {   1834, 21, 0 } }, /* monza-e-della-brianza */
    { .label = {   1834,  5, 0 } }, /* monza */
    { .label = {  35700, 12, 0 } }, /* monzabrianza */
    { .label = {  27806, 13, 0 } }, /* monzaebrianza */
    { .label = {   5850, 18, 0 } }, /* monzaedellabrianza */
    { .label = {    352,  2, 0 } }, /* ms */
    { .label = {   1355,  2, 0 } }, /* mt */
    { .label = {     89,  2, 0 } }, /* na */
    { .label = { 129392,  6, 0 } }, /* naples */
    { .label = {  38143,  6, 0 } }, /* napoli */
    { .label = {    154,  2, 0 } }, /* no */
    { .label = { 129418,  6, 0 } }, /* novara */
    { .label = {   1347,  2, 0 } }, /* nu */
    { .label = { 145320,  5, 0 } }, /* nuoro */
    { .label = {   1107,  2, 0 } }, /* og */
    { .label = {  21016,  9, 0 } }, /* ogliastra */
    { .label = {  35753, 12, 0 } }, /* olbia-tempio */
    { .label = {  46250, 11, 0 } }, /* olbiatempio */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {  89141,  8, 0 } }, /* oristano */
    { .label = {    214,  2, 0 } }, /* ot */
    { .label = {    592,  2, 0 } }, /* pa */
    { .label = { 129442,  6, 0 } }, /* padova */
    { .label = { 145341,  5, 0 } }, /* padua */
    { .label = { 109822,  7, 0 } }, /* palermo */
    { .label = { 145363,  5, 0 } }, /* parma */
    { .label = { 145384,  5, 0 } }, /* pavia */
    { .label = {   1377,  2, 0 } }, /* pc */
    { .label = {   2860,  2, 0 } }, /* pd */
    { .label = {   1882,  2, 0 } }, /* pe */
    { .label = { 109853,  7, 0 } }, /* perugia */
    { .label = {  27863, 13, 0 } }, /* pesaro-urbino */
    { .label = {  35806, 12, 0 } }, /* pesarourbino */
    { .label = { 109884,  7, 0 } }, /* pescara */
    { .label = {   1840,  2, 0 } }, /* pg */
    { .label = {   4715,  2, 0 } }, /* pi */
    { .label = {  89172,  8, 0 } }, /* piacenza */
    { .label = { 146757,  4, 0 } }, /* pisa */
    { .label = { 109913,  7, 0 } }, /* pistoia */
    { .label = {   1317,  2, 0 } }, /* pn */
    { .label = {    326,  2, 0 } }, /* po */
    { .label = {  72751,  9, 0 } }, /* pordenone */
    { .label = { 109942,  7, 0 } }, /* potenza */
    { .label = {    436,  2, 0 } }, /* pr */
    { .label = { 145406,  5, 0 } }, /* prato */
    { .label = {    545,  2, 0 } }, /* pt */
    { .label = {  15870,  2, 0 } }, /* pu */
    { .label = {   9333,  2, 0 } }, /* pv */
    { .label = {    470,  2, 0 } }, /* pz */
    { .label = {     72,  2, 0 } }, /* ra */
    { .label = { 129469,  6, 0 } }, /* ragusa */
    { .label = { 109974,  7, 0 } }, /* ravenna */
    { .label = {    265,  2, 0 } }, /* rc */
    { .label = {     57,  2, 0 } }, /* re */
    { .label = {  15010, 15, 0 } }, /* reggio-calabria */
    { .label = {  27919, 13, 0 } }, /* reggio-emilia */
    { .label = {  21113, 14, 0 } }, /* reggiocalabria */
    { .label = {  35857, 12, 0 } }, /* reggioemilia */
    { .label = {    215,  2, 0 } }, /* rg */
    { .label = {    227,  2, 0 } }, /* ri */
    { .label = { 145427,  5, 0 } }, /* rieti */
    { .label = { 129493,  6, 0 } }, /* rimini */
    { .label = {    582,  2, 0 } }, /* rm */
    { .label = {    186,  2, 0 } }, /* rn */
    { .label = {    465,  2, 0 } }, /* ro */
    { .label = {  18930,  4, 0 } }, /* roma */
    { .label = {  72056,  4, 0 } }, /* rome */
    { .label = { 129518,  6, 0 } }, /* rovigo */
    { .label = {     43,  2, 0 } }, /* sa */
    { .label = { 110002,  7, 0 } }, /* salerno */
    { .label = { 110030,  7, 0 } }, /* sassari */
    { .label = { 129545,  6, 0 } }, /* savona */
    { .label = {    623,  2, 0 } }, /* si */
    { .label = { 145447,  5, 0 } }, /* siena */
    { .label = {  89208,  8, 0 } }, /* siracusa */
    { .label = {    940,  2, 0 } }, /* so */
    { .label = { 110056,  7, 0 } }, /* sondrio */
    { .label = {   1422,  2, 0 } }, /* sp */
    { .label = {    182,  2, 0 } }, /* sr */
    { .label = {    863,  2, 0 } }, /* ss */
    { .label = {   5661,  9, 0 } }, /* suedtirol */
    { .label = {   5105,  2, 0 } }, /* sv */
    { .label = {    136,  2, 0 } }, /* ta */
    { .label = { 110085,  7, 0 } }, /* taranto */
    { .label = {     91,  2, 0 } }, /* te */
    { .label = {  35908, 12, 0 } }, /* tempio-olbia */
    { .label = {  46298, 11, 0 } }, /* tempioolbia */
    { .label = { 129569,  6, 0 } }, /* teramo */
    { .label = { 145466,  5, 0 } }, /* terni */
    { .label = {   1485,  2, 0 } }, /* tn */
    { .label = {     45,  2, 0 } }, /* to */
    { .label = { 129593,  6, 0 } }, /* torino */
    { .label = {    941,  2, 0 } }, /* tp */
    { .label = {   1020,  2, 0 } }, /* tr */
    { .label = {   1928, 21, 0 } }, /* trani-andria-barletta */
    { .label = {   2012, 21, 0 } }, /* trani-barletta-andria */
    { .label = {   3999, 19, 0 } }, /* traniandriabarletta */
    { .label = {   4073, 19, 0 } }, /* tranibarlettaandria */
    { .label = { 110111,  7, 0 } }, /* trapani */
    { .label = {   3691,  8, 0 } }, /* trentino */
    { .label = { 129617,  6, 0 } }, /* trento */
    { .label = { 110139,  7, 0 } }, /* treviso */
    { .label = { 110169,  7, 0 } }, /* trieste */
    { .label = {    340,  2, 0 } }, /* ts */
    { .label = { 145486,  5, 0 } }, /* turin */
    { .label = {     55,  2, 0 } }, /* tv */
    { .label = {   1344,  2, 0 } }, /* ud */
    { .label = { 145507,  5, 0 } }, /* udine */
    { .label = {  27975, 13, 0 } }, /* urbino-pesaro */
    { .label = {  35961, 12, 0 } }, /* urbinopesaro */
    { .label = {    527,  2, 0 } }, /* va */
    { .label = { 129641,  6, 0 } }, /* varese */
    { .label = {   8685,  2, 0 } }, /* vb */
    { .label = {    177,  2, 0 } }, /* vc */
    { .label = {    572,  2, 0 } }, /* ve */
    { .label = {   1519,  7, 0 } }, /* venezia */
    { .label = { 129666,  6, 0 } }, /* venice */
    { .label = {  89240,  8, 0 } }, /* verbania */
    { .label = {  89273,  8, 0 } }, /* vercelli */
    { .label = { 129693,  6, 0 } }, /* verona */
    { .label = {     59,  2, 0 } }, /* vi */
    { .label = {  28031, 13, 0 } }, /* vibo-valentia */
    { .label = {  36012, 12, 0 } }, /* vibovalentia */
    { .label = { 110197,  7, 0 } }, /* vicenza */
    { .label = { 110230,  7, 0 } }, /* viterbo */
    { .label = {    517,  2, 0 } }, /* vr */
    { .label = {    185,  2, 0 } }, /* vs */
    { .label = {  13354,  2, 0 } }, /* vt */
    { .label = {   3483,  2, 0 } }, /* vv */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 3520 to 3522 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entry 3523 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 3524 to 3531 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   4209,  3, 0 } }, /* sch */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  24880,  4, 0 } }, /* name */

    /* entries 3532 to 3696 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {    272,  2, 0 } }, /* ad */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    204,  2, 0 } }, /* ed */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {   1209,  2, 0 } }, /* gr */
    { .label = {   1106,  2, 0 } }, /* lg */
    { .label = {    203,  2, 0 } }, /* ne */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {  21720,  5, 1 } }, { .child = { 3697, 52 } }, /* aichi */
    { .label = {  21603,  5, 1 } }, { .child = { 3749, 28 } }, /* akita */
    { .label = { 129718,  6, 1 } }, { .child = { 3777, 22 } }, /* aomori */
    { .label = {  61321,  5, 1 } }, { .child = { 3799, 58 } }, /* chiba */
    { .label = { 145529,  5, 1 } }, { .child = { 3857, 22 } }, /* ehime */
    { .label = { 145551,  5, 1 } }, { .child = { 3879, 15 } }, /* fukui */
    { .label = { 110261,  7, 1 } }, { .child = { 3894, 63 } }, /* fukuoka */
    { .label = {  28901,  9, 1 } }, { .child = { 3957, 51 } }, /* fukushima */
    { .label = {  73427,  4, 1 } }, { .child = { 4008, 38 } }, /* gifu */
    { .label = { 145576,  5, 1 } }, { .child = { 4046, 36 } }, /* gunma */
    { .label = {  11171,  9, 1 } }, { .child = { 4082, 25 } }, /* hiroshima */
    { .label = {  89310,  8, 1 } }, { .child = { 4107, 142 } }, /* hokkaido */
    { .label = { 145598,  5, 1 } }, { .child = { 4249, 46 } }, /* hyogo */
    { .label = { 110294,  7, 1 } }, { .child = { 4295, 51 } }, /* ibaraki */
    { .label = {  78200,  8, 1 } }, { .child = { 4346, 19 } }, /* ishikawa */
    { .label = { 145622,  5, 1 } }, { .child = { 4365, 34 } }, /* iwate */
    { .label = {  28693,  6, 1 } }, { .child = { 4399, 15 } }, /* kagawa */
    { .label = {  72790,  9, 1 } }, { .child = { 4414, 20 } }, /* kagoshima */
    { .label = {  89345,  8, 1 } }, { .child = { 4434, 30 } }, /* kanagawa */
    { .label = { 145644,  5, 1 } }, { .child = { 4464, 31 } }, /* kochi */
    { .label = {  89378,  8, 1 } }, { .child = { 4495, 23 } }, /* kumamoto */
    { .label = { 145667,  5, 1 } }, { .child = { 4518, 31 } }, /* kyoto */
    { .label = {   1113,  3, 1 } }, { .child = { 4549, 30 } }, /* mie */
    { .label = { 129742,  6, 1 } }, { .child = { 4579, 32 } }, /* miyagi */
    { .label = {  89413,  8, 1 } }, { .child = { 4611, 27 } }, /* miyazaki */
    { .label = {  29030,  6, 1 } }, { .child = { 4638, 75 } }, /* nagano */
    { .label = {  89450,  8, 1 } }, { .child = { 4713, 22 } }, /* nagasaki */
    { .label = {  13952,  4, 1 } }, { .child = { 4735, 38 } }, /* nara */
    { .label = { 110322,  7, 1 } }, { .child = { 4773, 34 } }, /* niigata */
    { .label = {  36643,  4, 1 } }, { .child = { 4807, 19 } }, /* oita */
    { .label = {  97110,  7, 1 } }, { .child = { 4826, 26 } }, /* okayama */
    { .label = { 110349,  7, 1 } }, { .child = { 4852, 42 } }, /* okinawa */
    { .label = {  37178,  5, 1 } }, { .child = { 4894, 50 } }, /* osaka */
    { .label = {   8206,  4, 1 } }, { .child = { 4944, 26 } }, /* saga */
    { .label = { 110379,  7, 1 } }, { .child = { 4970, 69 } }, /* saitama */
    { .label = {  21458,  5, 1 } }, { .child = { 5039, 23 } }, /* shiga */
    { .label = { 110405,  7, 1 } }, { .child = { 5062, 23 } }, /* shimane */
    { .label = {  89481,  8, 1 } }, { .child = { 5085, 36 } }, /* shizuoka */
    { .label = { 110434,  7, 1 } }, { .child = { 5121, 31 } }, /* tochigi */
    { .label = {  72828,  9, 1 } }, { .child = { 5152, 17 } }, /* tokushima */
    { .label = { 145690,  5, 1 } }, { .child = { 5169, 57 } }, /* tokyo */
    { .label = { 110465,  7, 1 } }, { .child = { 5226, 13 } }, /* tottori */
    { .label = {  93727,  6, 1 } }, { .child = { 5239, 24 } }, /* toyama */
    { .label = {  89518,  8, 1 } }, { .child = { 5263, 29 } }, /* wakayama */
    { .label = {  89553,  8, 1 } }, { .child = { 5292, 34 } }, /* yamagata */
    { .label = {  72867,  9, 1 } }, { .child = { 5326, 16 } }, /* yamaguchi */
    { .label = {  72908,  9, 1 } }, { .child = { 5342, 28 } }, /* yamanashi */
    { .label = {  72945,  9, 0 } }, /* xn--4pvxs */
    { .label = {  46346, 11, 0 } }, /* xn--vgu402c */
    { .label = {  60132, 10, 0 } }, /* xn--c3s14m */
    { .label = {  46414, 11, 0 } }, /* xn--f6qx53a */
    { .label = {  60192, 10, 0 } }, /* xn--8pvr4u */
    { .label = {  46486, 11, 0 } }, /* xn--uist22h */
    { .label = {  21171, 14, 0 } }, /* xn--djrs72d6uy */
    { .label = {  46546, 11, 0 } }, /* xn--mkru45i */
    { .label = {  28088, 13, 0 } }, /* xn--0trq7p7nn */
    { .label = {  46607, 11, 0 } }, /* xn--8ltr62k */
    { .label = {  46675, 11, 0 } }, /* xn--2m4a15e */
    { .label = {  60252, 10, 0 } }, /* xn--efvn9s */
    { .label = {  46742, 11, 0 } }, /* xn--32vp30h */
    { .label = {  46815, 11, 0 } }, /* xn--4it797k */
    { .label = {  46884, 11, 0 } }, /* xn--1lqs71d */
    { .label = {  46951, 11, 0 } }, /* xn--5rtp49c */
    { .label = {  47017, 11, 0 } }, /* xn--5js045d */
    { .label = {  47089, 11, 0 } }, /* xn--ehqz56n */
    { .label = {  47157, 11, 0 } }, /* xn--1lqs03n */
    { .label = {  47224, 11, 0 } }, /* xn--qqqt11m */
    { .label = {  60305, 10, 0 } }, /* xn--kbrq7o */
    { .label = {  47293, 11, 0 } }, /* xn--pssu33l */
    { .label = {  47355, 11, 0 } }, /* xn--ntsq17g */
    { .label = {  60360, 10, 0 } }, /* xn--uisz3g */
    { .label = {  60414, 10, 0 } }, /* xn--6btw5a */
    { .label = {  72996,  9, 0 } }, /* xn--1ctwo */
    { .label = {  60473, 10, 0 } }, /* xn--6orx2r */
    { .label = {  60531, 10, 0 } }, /* xn--rht61e */
    { .label = {  60587, 10, 0 } }, /* xn--rht27z */
    { .label = {  60645, 10, 0 } }, /* xn--djty4k */
    { .label = {  47417, 11, 0 } }, /* xn--nit225k */
    { .label = {  73044,  9, 0 } }, /* xn--rht3d */
    { .label = {  60701, 10, 0 } }, /* xn--klty5x */
    { .label = {  60756, 10, 0 } }, /* xn--kltx9a */
    { .label = {  60808, 10, 0 } }, /* xn--kltp7d */
    { .label = {  47481, 11, 0 } }, /* xn--uuwu58a */
    { .label = {  47545, 11, 0 } }, /* xn--zbx025d */
    { .label = {  21256, 14, 0 } }, /* xn--ntso0iqx3a */
    { .label = {  47615, 11, 0 } }, /* xn--elqq16h */
    { .label = {  47684, 11, 0 } }, /* xn--4it168d */
    { .label = {  47755, 11, 0 } }, /* xn--klt787d */
    { .label = {  60862, 10, 0 } }, /* xn--rny31h */
    { .label = {  36064, 12, 0 } }, /* xn--7t0a264c */
    { .label = {  47822, 11, 0 } }, /* xn--5rtq34k */
    { .label = {  47890, 11, 0 } }, /* xn--k7yn95e */
    { .label = {  47956, 11, 0 } }, /* xn--tor131o */
    { .label = {  21331, 14, 0 } }, /* xn--d5qv7z876c */
    { .label = {  89585,  8, 1 } }, { .child = { 5370, 2 } }, /* kawasaki */
    { .label = {  60918, 10, 1 } }, { .child = { 5374, 2 } }, /* kitakyushu */
    { .label = { 155452,  4, 1 } }, { .child = { 5378, 2 } }, /* kobe */
    { .label = { 129769,  6, 1 } }, { .child = { 5382, 2 } }, /* nagoya */
    { .label = { 110493,  7, 1 } }, { .child = { 5386, 2 } }, /* sapporo */
    { .label = {  28747,  6, 1 } }, { .child = { 5390, 2 } }, /* sendai */
    { .label = {  89619,  8, 1 } }, { .child = { 5394, 2 } }, /* yokohama */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 3697 to 3748 */
    { .label = { 145713,  5, 0 } }, /* aisai */
    { .label = {   2423,  3, 0 } }, /* ama */
    { .label = { 147653,  4, 0 } }, /* anjo */
    { .label = { 145731,  5, 0 } }, /* asuke */
    { .label = { 129794,  6, 0 } }, /* chiryu */
    { .label = {  91436,  5, 0 } }, /* chita */
    { .label = { 155470,  4, 0 } }, /* fuso */
    { .label = {  89654,  8, 0 } }, /* gamagori */
    { .label = { 145752,  5, 0 } }, /* handa */
    { .label = { 155489,  4, 0 } }, /* hazu */
    { .label = { 110524,  7, 0 } }, /* hekinan */
    { .label = {  60964, 10, 0 } }, /* higashiura */
    { .label = {  61006, 10, 0 } }, /* ichinomiya */
    { .label = { 110553,  7, 0 } }, /* inazawa */
    { .label = { 110584,  7, 0 } }, /* inuyama */
    { .label = { 110614,  7, 0 } }, /* isshiki */
    { .label = { 110644,  7, 0 } }, /* iwakura */
    { .label = { 145772,  5, 0 } }, /* kanie */
    { .label = { 129823,  6, 0 } }, /* kariya */
    { .label = { 110675,  7, 0 } }, /* kasugai */
    { .label = {  92298,  4, 0 } }, /* kira */
    { .label = { 129848,  6, 0 } }, /* kiyosu */
    { .label = { 129876,  6, 0 } }, /* komaki */
    { .label = { 145792,  5, 0 } }, /* konan */
    { .label = {  13938,  4, 0 } }, /* kota */
    { .label = {  95511,  6, 0 } }, /* mihama */
    { .label = {  11248,  7, 0 } }, /* miyoshi */
    { .label = {  48399,  6, 0 } }, /* nishio */
    { .label = { 110704,  7, 0 } }, /* nisshin */
    { .label = {  19161,  3, 0 } }, /* obu */
    { .label = { 129902,  6, 0 } }, /* oguchi */
    { .label = { 145812,  5, 0 } }, /* oharu */
    { .label = { 110733,  7, 0 } }, /* okazaki */
    { .label = {  61050, 10, 0 } }, /* owariasahi */
    { .label = {  89058,  4, 0 } }, /* seto */
    { .label = {  37510,  8, 0 } }, /* shikatsu */
    { .label = {  73091,  9, 0 } }, /* shinshiro */
    { .label = { 110764,  7, 0 } }, /* shitara */
    { .label = { 129930,  6, 0 } }, /* tahara */
    { .label = {  89687,  8, 0 } }, /* takahama */
    { .label = {  73129,  9, 0 } }, /* tobishima */
    { .label = { 131183,  4, 0 } }, /* toei */
    { .label = {  82644,  4, 0 } }, /* togo */
    { .label = { 145833,  5, 0 } }, /* tokai */
    { .label = {  89718,  8, 0 } }, /* tokoname */
    { .label = { 110791,  7, 0 } }, /* toyoake */
    { .label = {  73167,  9, 0 } }, /* toyohashi */
    { .label = {  89751,  8, 0 } }, /* toyokawa */
    { .label = { 129952,  6, 0 } }, /* toyone */
    { .label = { 129978,  6, 0 } }, /* toyota */
    { .label = {   7994,  8, 0 } }, /* tsushima */
    { .label = { 130003,  6, 0 } }, /* yatomi */

    /* entries 3749 to 3776 */
    { .label = {  21603,  5, 0 } }, /* akita */
    { .label = { 130029,  6, 0 } }, /* daisen */
    { .label = {  89787,  8, 0 } }, /* fujisato */
    { .label = { 130053,  6, 0 } }, /* gojome */
    { .label = {  48017, 11, 0 } }, /* hachirogata */
    { .label = { 130082,  6, 0 } }, /* happou */
    { .label = {  28165, 13, 0 } }, /* higashinaruse */
    { .label = {  73337,  5, 0 } }, /* honjo */
    { .label = { 130111,  6, 0 } }, /* honjyo */
    { .label = {  15544,  5, 0 } }, /* ikawa */
    { .label = {  73206,  9, 0 } }, /* kamikoani */
    { .label = { 110821,  7, 0 } }, /* kamioka */
    { .label = {  89824,  8, 0 } }, /* katagami */
    { .label = { 130141,  6, 0 } }, /* kazuno */
    { .label = {  73243,  9, 0 } }, /* kitaakita */
    { .label = { 130169,  6, 0 } }, /* kosaka */
    { .label = { 145853,  5, 0 } }, /* kyowa */
    { .label = {  21759,  6, 0 } }, /* misato */
    { .label = {  62033,  6, 0 } }, /* mitane */
    { .label = {  73278,  9, 0 } }, /* moriyoshi */
    { .label = { 130193,  6, 0 } }, /* nikaho */
    { .label = { 110850,  7, 0 } }, /* noshiro */
    { .label = {  65959,  5, 0 } }, /* odate */
    { .label = {   8116,  3, 0 } }, /* oga */
    { .label = {  48043,  5, 0 } }, /* ogata */
    { .label = { 110879,  7, 0 } }, /* semboku */
    { .label = { 130218,  6, 0 } }, /* yokote */
    { .label = {  73318,  9, 0 } }, /* yurihonjo */

    /* entries 3777 to 3798 */
    { .label = { 129718,  6, 0 } }, /* aomori */
    { .label = { 130245,  6, 0 } }, /* gonohe */
    { .label = {  73361,  9, 0 } }, /* hachinohe */
    { .label = {  73185,  9, 0 } }, /* hashikami */
    { .label = { 110911,  7, 0 } }, /* hiranai */
    { .label = {  89856,  8, 0 } }, /* hirosaki */
    { .label = {  73400,  9, 0 } }, /* itayanagi */
    { .label = {  89889,  8, 0 } }, /* kuroishi */
    { .label = { 130271,  6, 0 } }, /* misawa */
    { .label = {  73475,  5, 0 } }, /* mutsu */
    { .label = {  61091, 10, 0 } }, /* nakadomari */
    { .label = { 130297,  6, 0 } }, /* noheji */
    { .label = { 130325,  6, 0 } }, /* oirase */
    { .label = { 145878,  5, 0 } }, /* owani */
    { .label = {  89924,  8, 0 } }, /* rokunohe */
    { .label = { 110938,  7, 0 } }, /* sannohe */
    { .label = {  61131, 10, 0 } }, /* shichinohe */
    { .label = { 130348,  6, 0 } }, /* shingo */
    { .label = { 145900,  5, 0 } }, /* takko */
    { .label = { 130374,  6, 0 } }, /* towada */
    { .label = { 110966,  7, 0 } }, /* tsugaru */
    { .label = { 110996,  7, 0 } }, /* tsuruta */

    /* entries 3799 to 3856 */
    { .label = { 145921,  5, 0 } }, /* abiko */
    { .label = {  61072,  5, 0 } }, /* asahi */
    { .label = { 130400,  6, 0 } }, /* chonan */
    { .label = { 130425,  6, 0 } }, /* chosei */
    { .label = { 130451,  6, 0 } }, /* choshi */
    { .label = {  48094,  4, 0 } }, /* chuo */
    { .label = {  73436,  9, 0 } }, /* funabashi */
    { .label = { 130478,  6, 0 } }, /* futtsu */
    { .label = {  61175, 10, 0 } }, /* hanamigawa */
    { .label = {  89959,  8, 0 } }, /* ichihara */
    { .label = {  21723,  8, 0 } }, /* ichikawa */
    { .label = {  61006, 10, 0 } }, /* ichinomiya */
    { .label = { 145942,  5, 0 } }, /* inzai */
    { .label = {  11235,  5, 0 } }, /* isumi */
    { .label = {  89992,  8, 0 } }, /* kamagaya */
    { .label = {  90025,  8, 0 } }, /* kamogawa */
    { .label = {  49073,  7, 0 } }, /* kashiwa */
    { .label = {  94704,  6, 0 } }, /* katori */
    { .label = {  29187,  8, 0 } }, /* katsuura */
    { .label = { 111025,  7, 0 } }, /* kimitsu */
    { .label = {  90060,  8, 0 } }, /* kisarazu */
    { .label = { 130506,  6, 0 } }, /* kozaki */
    { .label = {  90095,  8, 0 } }, /* kujukuri */
    { .label = { 130534,  6, 0 } }, /* kyonan */
    { .label = { 111056,  7, 0 } }, /* matsudo */
    { .label = { 130560,  6, 0 } }, /* midori */
    { .label = {  95511,  6, 0 } }, /* mihama */
    { .label = {  61217, 10, 0 } }, /* minamiboso */
    { .label = { 130586,  6, 0 } }, /* mobara */
    { .label = {  73475,  9, 0 } }, /* mutsuzawa */
    { .label = { 130610,  6, 0 } }, /* nagara */
    { .label = {  61259, 10, 0 } }, /* nagareyama */
    { .label = {  73518,  9, 0 } }, /* narashino */
    { .label = { 130632,  6, 0 } }, /* narita */
    { .label = {  14043,  4, 0 } }, /* noda */
    { .label = {  28219, 13, 0 } }, /* oamishirasato */
    { .label = { 111086,  7, 0 } }, /* omigawa */
    { .label = { 130654,  6, 0 } }, /* onjuku */
    { .label = {  94643,  5, 0 } }, /* otaki */
    { .label = { 145964,  5, 0 } }, /* sakae */
    { .label = {  61805,  6, 0 } }, /* sakura */
    { .label = {  73553,  9, 0 } }, /* shimofusa */
    { .label = { 111117,  7, 0 } }, /* shirako */
    { .label = {  75747,  6, 0 } }, /* shiroi */
    { .label = { 130684,  6, 0 } }, /* shisui */
    { .label = {  73593,  9, 0 } }, /* sodegaura */
    { .label = {  29860,  4, 0 } }, /* sosa */
    { .label = {  93191,  4, 0 } }, /* tako */
    { .label = {  90135,  8, 0 } }, /* tateyama */
    { .label = { 130710,  6, 0 } }, /* togane */
    { .label = {  90167,  8, 0 } }, /* tohnosho */
    { .label = {  90201,  8, 0 } }, /* tomisato */
    { .label = { 111146,  7, 0 } }, /* urayasu */
    { .label = {  73630,  9, 0 } }, /* yachimata */
    { .label = { 111176,  7, 0 } }, /* yachiyo */
    { .label = {  61299, 10, 0 } }, /* yokaichiba */
    { .label = {  15073, 15, 0 } }, /* yokoshibahikari */
    { .label = {  61343, 10, 0 } }, /* yotsukaido */

    /* entries 3857 to 3878 */
    { .label = { 135284,  5, 0 } }, /* ainan */
    { .label = { 131067,  5, 0 } }, /* honai */
    { .label = {  77522,  5, 0 } }, /* ikata */
    { .label = { 111209,  7, 0 } }, /* imabari */
    { .label = {  11253,  3, 0 } }, /* iyo */
    { .label = {  28463,  8, 0 } }, /* kamijima */
    { .label = { 130734,  6, 0 } }, /* kihoku */
    { .label = {  73668,  9, 0 } }, /* kumakogen */
    { .label = { 130762,  6, 0 } }, /* masaki */
    { .label = { 111237,  7, 0 } }, /* matsuno */
    { .label = {  11310,  9, 0 } }, /* matsuyama */
    { .label = {  90233,  8, 0 } }, /* namikata */
    { .label = { 111266,  7, 0 } }, /* niihama */
    { .label = { 155867,  3, 0 } }, /* ozu */
    { .label = { 145983,  5, 0 } }, /* saijo */
    { .label = { 146005,  5, 0 } }, /* seiyo */
    { .label = {  48062, 11, 0 } }, /* shikokuchuo */
    { .label = {  72588,  4, 0 } }, /* tobe */
    { .label = {  13684,  4, 0 } }, /* toon */
    { .label = {  15571,  6, 0 } }, /* uchiko */
    { .label = { 111294,  7, 0 } }, /* uwajima */
    { .label = {  61387, 10, 0 } }, /* yawatahama */

    /* entries 3879 to 3893 */
    { .label = {  28295,  7, 0 } }, /* echizen */
    { .label = { 111328,  7, 0 } }, /* eiheiji */
    { .label = { 145551,  5, 0 } }, /* fukui */
    { .label = { 146027,  5, 0 } }, /* ikeda */
    { .label = {  73708,  9, 0 } }, /* katsuyama */
    { .label = {  95511,  6, 0 } }, /* mihama */
    { .label = {  28270, 13, 0 } }, /* minamiechizen */
    { .label = { 146048,  5, 0 } }, /* obama */
    { .label = {   2887,  3, 0 } }, /* ohi */
    { .label = {   8934,  3, 0 } }, /* ono */
    { .label = { 146068,  5, 0 } }, /* sabae */
    { .label = {  21708,  5, 0 } }, /* sakai */
    { .label = {  89687,  8, 0 } }, /* takahama */
    { .label = {  37247,  7, 0 } }, /* tsuruga */
    { .label = { 130786,  6, 0 } }, /* wakasa */

    /* entries 3894 to 3956 */
    { .label = {  29125,  6, 0 } }, /* ashiya */
    { .label = { 146087,  5, 0 } }, /* buzen */
    { .label = { 111360,  7, 0 } }, /* chikugo */
    { .label = {  75899,  7, 0 } }, /* chikuho */
    { .label = { 111393,  7, 0 } }, /* chikujo */
    { .label = {  61429, 10, 0 } }, /* chikushino */
    { .label = {  90264,  8, 0 } }, /* chikuzen */
    { .label = {  48094,  4, 0 } }, /* chuo */
    { .label = { 111428,  7, 0 } }, /* dazaifu */
    { .label = {  48973,  7, 0 } }, /* fukuchi */
    { .label = { 130811,  6, 0 } }, /* hakata */
    { .label = {   7956,  7, 0 } }, /* higashi */
    { .label = {  90303,  8, 0 } }, /* hirokawa */
    { .label = {  90338,  8, 0 } }, /* hisayama */
    { .label = { 130834,  6, 0 } }, /* iizuka */
    { .label = {  90371,  8, 0 } }, /* inatsuki */
    { .label = {  91015,  4, 0 } }, /* kaho */
    { .label = { 110675,  6, 0 } }, /* kasuga */
    { .label = { 130862,  6, 0 } }, /* kasuya */
    { .label = { 130888,  6, 0 } }, /* kawara */
    { .label = { 130913,  6, 0 } }, /* keisen */
    { .label = {  66124,  4, 0 } }, /* koga */
    { .label = { 130938,  6, 0 } }, /* kurate */
    { .label = { 130963,  6, 0 } }, /* kurogi */
    { .label = {  29083,  6, 0 } }, /* kurume */
    { .label = {  15200,  6, 0 } }, /* minami */
    { .label = {  62311,  6, 0 } }, /* miyako */
    { .label = {  15216,  6, 0 } }, /* miyama */
    { .label = {  90404,  8, 0 } }, /* miyawaka */
    { .label = {  90440,  8, 0 } }, /* mizumaki */
    { .label = {  90478,  8, 0 } }, /* munakata */
    { .label = {  90510,  8, 0 } }, /* nakagawa */
    { .label = { 130990,  6, 0 } }, /* nakama */
    { .label = {  36694,  5, 0 } }, /* nishi */
    { .label = { 131013,  6, 0 } }, /* nogata */
    { .label = { 146112,  5, 0 } }, /* ogori */
    { .label = { 111461,  7, 0 } }, /* okagaki */
    { .label = {  62938,  5, 0 } }, /* okawa */
    { .label = {   6299,  3, 0 } }, /* oki */
    { .label = { 146133,  5, 0 } }, /* omuta */
    { .label = { 115869,  4, 0 } }, /* onga */
    { .label = {  62334,  5, 0 } }, /* onojo */
    { .label = {   3732,  3, 0 } }, /* oto */
    { .label = { 111490,  7, 0 } }, /* saigawa */
    { .label = {  90543,  8, 0 } }, /* sasaguri */
    { .label = { 131036,  6, 0 } }, /* shingu */
    { .label = {  28328, 13, 0 } }, /* shinyoshitomi */
    { .label = { 131063,  6, 0 } }, /* shonai */
    { .label = { 146154,  5, 0 } }, /* soeda */
    { .label = {   3807,  3, 0 } }, /* sue */
    { .label = {  73746,  9, 0 } }, /* tachiarai */
    { .label = {  93693,  6, 0 } }, /* tagawa */
    { .label = {  28641,  6, 0 } }, /* takata */
    { .label = { 153150,  4, 0 } }, /* toho */
    { .label = { 111519,  7, 0 } }, /* toyotsu */
    { .label = { 131087,  6, 0 } }, /* tsuiki */
    { .label = { 146174,  5, 0 } }, /* ukiha */
    { .label = {  11243,  3, 0 } }, /* umi */
    { .label = { 147093,  4, 0 } }, /* usui */
    { .label = { 131113,  6, 0 } }, /* yamada */
    { .label = {  24878,  4, 0 } }, /* yame */
    { .label = {  90575,  8, 0 } }, /* yanagawa */
    { .label = {  73781,  9, 0 } }, /* yukuhashi */

    /* entries 3957 to 4007 */
    { .label = {  73823,  9, 0 } }, /* aizubange */
    { .label = {  61474, 10, 0 } }, /* aizumisato */
    { .label = {  28385, 13, 0 } }, /* aizuwakamatsu */
    { .label = { 111550,  7, 0 } }, /* asakawa */
    { .label = { 131138,  6, 0 } }, /* bandai */
    { .label = {  26407,  4, 0 } }, /* date */
    { .label = {  28901,  9, 0 } }, /* fukushima */
    { .label = {  90609,  8, 0 } }, /* furudono */
    { .label = { 131162,  6, 0 } }, /* futaba */
    { .label = { 131188,  6, 0 } }, /* hanawa */
    { .label = {   7956,  7, 0 } }, /* higashi */
    { .label = {  78278,  6, 0 } }, /* hirata */
    { .label = { 131213,  6, 0 } }, /* hirono */
    { .label = { 131238,  6, 0 } }, /* iitate */
    { .label = {  61517, 10, 0 } }, /* inawashiro */
    { .label = {  78200,  8, 0 } }, /* ishikawa */
    { .label = {  74961,  5, 0 } }, /* iwaki */
    { .label = {  73863,  9, 0 } }, /* izumizaki */
    { .label = {  61559, 10, 0 } }, /* kagamiishi */
    { .label = {  90646,  8, 0 } }, /* kaneyama */
    { .label = {  90679,  8, 0 } }, /* kawamata */
    { .label = {  90712,  8, 0 } }, /* kitakata */
    { .label = {  36143, 12, 0 } }, /* kitashiobara */
    { .label = { 146196,  5, 0 } }, /* koori */
    { .label = {  21572,  8, 0 } }, /* koriyama */
    { .label = { 131261,  6, 0 } }, /* kunimi */
    { .label = { 131288,  6, 0 } }, /* miharu */
    { .label = { 111578,  7, 0 } }, /* mishima */
    { .label = {  28279,  5, 0 } }, /* namie */
    { .label = { 146217,  5, 0 } }, /* nango */
    { .label = {  73907,  9, 0 } }, /* nishiaizu */
    { .label = { 111608,  7, 0 } }, /* nishigo */
    { .label = {  95889,  5, 0 } }, /* okuma */
    { .label = { 111638,  7, 0 } }, /* omotego */
    { .label = {   8934,  3, 0 } }, /* ono */
    { .label = { 146237,  5, 0 } }, /* otama */
    { .label = {  90743,  8, 0 } }, /* samegawa */
    { .label = { 111668,  7, 0 } }, /* shimogo */
    { .label = {  11103,  9, 0 } }, /* shirakawa */
    { .label = { 146256,  5, 0 } }, /* showa */
    { .label = { 115353,  4, 0 } }, /* soma */
    { .label = {  90777,  8, 0 } }, /* sukagawa */
    { .label = { 111699,  7, 0 } }, /* taishin */
    { .label = {  90812,  8, 0 } }, /* tamakawa */
    { .label = {  90845,  8, 0 } }, /* tanagura */
    { .label = { 146279,  5, 0 } }, /* tenei */
    { .label = { 131314,  6, 0 } }, /* yabuki */
    { .label = {  21547,  6, 0 } }, /* yamato */
    { .label = {  73947,  9, 0 } }, /* yamatsuri */
    { .label = { 111727,  7, 0 } }, /* yanaizu */
    { .label = {  93648,  6, 0 } }, /* yugawa */

    /* entries 4008 to 4045 */
    { .label = { 111759,  7, 0 } }, /* anpachi */
    { .label = {   3138,  3, 0 } }, /* ena */
    { .label = {  73427,  4, 0 } }, /* gifu */
    { .label = { 146299,  5, 0 } }, /* ginan */
    { .label = { 155509,  4, 0 } }, /* godo */
    { .label = { 155527,  4, 0 } }, /* gujo */
    { .label = { 111789,  7, 0 } }, /* hashima */
    { .label = { 111818,  7, 0 } }, /* hichiso */
    { .label = {  49571,  4, 0 } }, /* hida */
    { .label = {  11073, 16, 0 } }, /* higashishirakawa */
    { .label = { 111849,  7, 0 } }, /* ibigawa */
    { .label = { 146027,  5, 0 } }, /* ikeda */
    { .label = {  36191, 12, 0 } }, /* kakamigahara */
    { .label = {  49450,  4, 0 } }, /* kani */
    { .label = {  90876,  8, 0 } }, /* kasahara */
    { .label = {  73985,  9, 0 } }, /* kasamatsu */
    { .label = { 131342,  6, 0 } }, /* kawaue */
    { .label = {  90906,  8, 0 } }, /* kitagata */
    { .label = {  36820,  4, 0 } }, /* mino */
    { .label = {  90937,  8, 0 } }, /* minokamo */
    { .label = {  95171,  6, 0 } }, /* mitake */
    { .label = {  90971,  8, 0 } }, /* mizunami */
    { .label = { 131369,  6, 0 } }, /* motosu */
    { .label = {  48113, 11, 0 } }, /* nakatsugawa */
    { .label = { 132138,  5, 0 } }, /* ogaki */
    { .label = {  91008,  8, 0 } }, /* sakahogi */
    { .label = {  36254,  4, 0 } }, /* seki */
    { .label = {  61601, 10, 0 } }, /* sekigahara */
    { .label = {  11103,  9, 0 } }, /* shirakawa */
    { .label = { 131395,  6, 0 } }, /* tajimi */
    { .label = {  91041,  8, 0 } }, /* takayama */
    { .label = { 146319,  5, 0 } }, /* tarui */
    { .label = {  96059,  4, 0 } }, /* toki */
    { .label = { 131422,  6, 0 } }, /* tomika */
    { .label = {  91073,  8, 0 } }, /* wanouchi */
    { .label = {  89553,  8, 0 } }, /* yamagata */
    { .label = { 131447,  6, 0 } }, /* yaotsu */
    { .label = { 131912,  4, 0 } }, /* yoro */

    /* entries 4046 to 4081 */
    { .label = { 131473,  6, 0 } }, /* annaka */
    { .label = { 111880,  7, 0 } }, /* chiyoda */
    { .label = { 111912,  7, 0 } }, /* fujioka */
    { .label = {  15138, 15, 0 } }, /* higashiagatsuma */
    { .label = { 111946,  7, 0 } }, /* isesaki */
    { .label = { 111974,  7, 0 } }, /* itakura */
    { .label = { 115211,  5, 0 } }, /* kanna */
    { .label = { 146339,  5, 0 } }, /* kanra */
    { .label = {  74021,  9, 0 } }, /* katashina */
    { .label = { 131495,  6, 0 } }, /* kawaba */
    { .label = { 146358,  5, 0 } }, /* kiryu */
    { .label = { 112002,  7, 0 } }, /* kusatsu */
    { .label = {  91110,  8, 0 } }, /* maebashi */
    { .label = { 146382,  5, 0 } }, /* meiwa */
    { .label = { 130560,  6, 0 } }, /* midori */
    { .label = {  91143,  8, 0 } }, /* minakami */
    { .label = {  61641, 10, 0 } }, /* naganohara */
    { .label = {  91176,  8, 0 } }, /* nakanojo */
    { .label = { 112032,  7, 0 } }, /* nanmoku */
    { .label = { 131521,  6, 0 } }, /* numata */
    { .label = { 131545,  6, 0 } }, /* oizumi */
    { .label = {   7161,  3, 0 } }, /* ora */
    { .label = {    214,  3, 0 } }, /* ota */
    { .label = {  74056,  9, 0 } }, /* shibukawa */
    { .label = {  74097,  9, 0 } }, /* shimonita */
    { .label = {  92207,  6, 0 } }, /* shinto */
    { .label = { 146256,  5, 0 } }, /* showa */
    { .label = {  91210,  8, 0 } }, /* takasaki */
    { .label = {  91041,  8, 0 } }, /* takayama */
    { .label = {  91241,  8, 0 } }, /* tamamura */
    { .label = {  48159, 11, 0 } }, /* tatebayashi */
    { .label = { 112062,  7, 0 } }, /* tomioka */
    { .label = {  74134,  9, 0 } }, /* tsukiyono */
    { .label = {  91273,  8, 0 } }, /* tsumagoi */
    { .label = {  97360,  4, 0 } }, /* ueno */
    { .label = {  91307,  8, 0 } }, /* yoshioka */

    /* entries 4082 to 4106 */
    { .label = {  48916,  9, 0 } }, /* asaminami */
    { .label = { 115771,  5, 0 } }, /* daiwa */
    { .label = { 112091,  7, 0 } }, /* etajima */
    { .label = { 146405,  5, 0 } }, /* fuchu */
    { .label = {  91342,  8, 0 } }, /* fukuyama */
    { .label = {  48204, 11, 0 } }, /* hatsukaichi */
    { .label = {  11141, 16, 0 } }, /* higashihiroshima */
    { .label = { 146431,  5, 0 } }, /* hongo */
    { .label = {  36239, 12, 0 } }, /* jinsekikogen */
    { .label = { 146453,  5, 0 } }, /* kaita */
    { .label = {  48805,  3, 0 } }, /* kui */
    { .label = { 131574,  6, 0 } }, /* kumano */
    { .label = {  85130,  4, 0 } }, /* kure */
    { .label = {  62072,  6, 0 } }, /* mihara */
    { .label = {  11248,  7, 0 } }, /* miyoshi */
    { .label = {  21622,  4, 0 } }, /* naka */
    { .label = {  91380,  8, 0 } }, /* onomichi */
    { .label = {  28443, 13, 0 } }, /* osakikamijima */
    { .label = { 146472,  5, 0 } }, /* otake */
    { .label = {  21708,  4, 0 } }, /* saka */
    { .label = {  30221,  4, 0 } }, /* sera */
    { .label = {  74174,  9, 0 } }, /* seranishi */
    { .label = {  91415,  8, 0 } }, /* shinichi */
    { .label = { 112121,  7, 0 } }, /* shobara */
    { .label = {  91450,  8, 0 } }, /* takehara */

    /* entries 4107 to 4248 */
    { .label = {  91481,  8, 0 } }, /* abashiri */
    { .label = {  91599,  5, 0 } }, /* abira */
    { .label = { 112149,  7, 0 } }, /* aibetsu */
    { .label = { 112178,  7, 0 } }, /* akabira */
    { .label = { 112205,  7, 0 } }, /* akkeshi */
    { .label = {  74210,  9, 0 } }, /* asahikawa */
    { .label = {  74247,  9, 0 } }, /* ashibetsu */
    { .label = { 131600,  6, 0 } }, /* ashoro */
    { .label = { 131624,  6, 0 } }, /* assabu */
    { .label = {  15176,  6, 0 } }, /* atsuma */
    { .label = { 146492,  5, 0 } }, /* bibai */
    { .label = {  99090,  4, 0 } }, /* biei */
    { .label = { 131648,  6, 0 } }, /* bifuka */
    { .label = { 131676,  6, 0 } }, /* bihoro */
    { .label = {  91513,  8, 0 } }, /* biratori */
    { .label = {  48251, 11, 0 } }, /* chippubetsu */
    { .label = { 112235,  7, 0 } }, /* chitose */
    { .label = {  26407,  4, 0 } }, /* date */
    { .label = { 131702,  6, 0 } }, /* ebetsu */
    { .label = { 112265,  7, 0 } }, /* embetsu */
    { .label = { 146513,  5, 0 } }, /* eniwa */
    { .label = { 146535,  5, 0 } }, /* erimo */
    { .label = {   5673,  4, 0 } }, /* esan */
    { .label = { 131728,  6, 0 } }, /* esashi */
    { .label = {  91545,  8, 0 } }, /* fukagawa */
    { .label = {  28901,  9, 0 } }, /* fukushima */
    { .label = {  36469,  6, 0 } }, /* furano */
    { .label = {  91582,  8, 0 } }, /* furubira */
    { .label = { 131752,  6, 0 } }, /* haboro */
    { .label = {  91618,  8, 0 } }, /* hakodate */
    { .label = {  36293, 12, 0 } }, /* hamatonbetsu */
    { .label = { 131777,  6, 0 } }, /* hidaka */
    { .label = {  28499, 13, 0 } }, /* higashikagura */
    { .label = {  48304, 11, 0 } }, /* higashikawa */
    { .label = { 112550,  5, 0 } }, /* hiroo */
    { .label = { 112296,  7, 0 } }, /* hokuryu */
    { .label = { 131802,  6, 0 } }, /* hokuto */
    { .label = {  91651,  8, 0 } }, /* honbetsu */
    { .label = {  74285,  9, 0 } }, /* horokanai */
    { .label = {  91686,  8, 0 } }, /* horonobe */
    { .label = { 146027,  5, 0 } }, /* ikeda */
    { .label = { 112330,  7, 0 } }, /* imakane */
    { .label = {  91720,  8, 0 } }, /* ishikari */
    { .label = {  74321,  9, 0 } }, /* iwamizawa */
    { .label = { 131829,  6, 0 } }, /* iwanai */
    { .label = {  61679, 10, 0 } }, /* kamifurano */
    { .label = {  91753,  8, 0 } }, /* kamikawa */
    { .label = {  48352, 11, 0 } }, /* kamishihoro */
    { .label = {  36343, 12, 0 } }, /* kamisunagawa */
    { .label = {  91788,  8, 0 } }, /* kamoenai */
    { .label = { 131854,  6, 0 } }, /* kayabe */
    { .label = {  91820,  8, 0 } }, /* kembuchi */
    { .label = { 112358,  7, 0 } }, /* kikonai */
    { .label = {  74364,  9, 0 } }, /* kimobetsu */
    { .label = {  28554, 13, 0 } }, /* kitahiroshima */
    { .label = { 131880,  6, 0 } }, /* kitami */
    { .label = {  91858,  8, 0 } }, /* kiyosato */
    { .label = {  74404,  9, 0 } }, /* koshimizu */
    { .label = {  91892,  8, 0 } }, /* kunneppu */
    { .label = {  91931,  8, 0 } }, /* kuriyama */
    { .label = {  36394, 12, 0 } }, /* kuromatsunai */
    { .label = { 112387,  7, 0 } }, /* kushiro */
    { .label = { 112418,  7, 0 } }, /* kutchan */
    { .label = { 145853,  5, 0 } }, /* kyowa */
    { .label = { 112449,  7, 0 } }, /* mashike */
    { .label = {  91966,  8, 0 } }, /* matsumae */
    { .label = { 114443,  6, 0 } }, /* mikasa */
    { .label = {  36444, 12, 0 } }, /* minamifurano */
    { .label = {  91999,  8, 0 } }, /* mombetsu */
    { .label = {  92035,  8, 0 } }, /* moseushi */
    { .label = {  93584,  6, 0 } }, /* mukawa */
    { .label = { 112479,  7, 0 } }, /* muroran */
    { .label = { 155548,  4, 0 } }, /* naie */
    { .label = {  90510,  8, 0 } }, /* nakagawa */
    { .label = {  36495, 12, 0 } }, /* nakasatsunai */
    { .label = {  36541, 12, 0 } }, /* nakatombetsu */
    { .label = { 146556,  5, 0 } }, /* nanae */
    { .label = { 112508,  7, 0 } }, /* nanporo */
    { .label = { 131905,  6, 0 } }, /* nayoro */
    { .label = { 131930,  6, 0 } }, /* nemuro */
    { .label = {  92070,  8, 0 } }, /* niikappu */
    { .label = {  73235,  4, 0 } }, /* niki */
    { .label = {  48399, 11, 0 } }, /* nishiokoppe */
    { .label = {  48449, 11, 0 } }, /* noboribetsu */
    { .label = { 131521,  6, 0 } }, /* numata */
    { .label = { 112537,  7, 0 } }, /* obihiro */
    { .label = { 146574,  5, 0 } }, /* obira */
    { .label = { 146594,  5, 0 } }, /* oketo */
    { .label = {  48420,  6, 0 } }, /* okoppe */
    { .label = { 146615,  5, 0 } }, /* otaru */
    { .label = { 146635,  5, 0 } }, /* otobe */
    { .label = { 112567,  7, 0 } }, /* otofuke */
    { .label = {  74447,  9, 0 } }, /* otoineppu */
    { .label = { 155563,  4, 0 } }, /* oumu */
    { .label = { 146656,  5, 0 } }, /* ozora */
    { .label = { 146678,  5, 0 } }, /* pippu */
    { .label = {  92107,  8, 0 } }, /* rankoshi */
    { .label = { 146705,  5, 0 } }, /* rebun */
    { .label = {  74488,  9, 0 } }, /* rikubetsu */
    { .label = {  48496,  7, 0 } }, /* rishiri */
    { .label = {  48496, 11, 0 } }, /* rishirifuji */
    { .label = { 131956,  6, 0 } }, /* saroma */
    { .label = {  74528,  9, 0 } }, /* sarufutsu */
    { .label = {  92140,  8, 0 } }, /* shakotan */
    { .label = { 146727,  5, 0 } }, /* shari */
    { .label = {  92172,  8, 0 } }, /* shibecha */
    { .label = {  74250,  8, 0 } }, /* shibetsu */
    { .label = { 112599,  7, 0 } }, /* shikabe */
    { .label = { 112629,  7, 0 } }, /* shikaoi */
    { .label = {  74568,  9, 0 } }, /* shimamaki */
    { .label = {  48847,  7, 0 } }, /* shimizu */
    { .label = {  74606,  9, 0 } }, /* shimokawa */
    { .label = {  36591, 12, 0 } }, /* shinshinotsu */
    { .label = {  92207,  8, 0 } }, /* shintoku */
    { .label = {  74646,  9, 0 } }, /* shiranuka */
    { .label = { 112658,  7, 0 } }, /* shiraoi */
    { .label = {  74683,  9, 0 } }, /* shiriuchi */
    { .label = { 112686,  7, 0 } }, /* sobetsu */
    { .label = {  36360,  8, 0 } }, /* sunagawa */
    { .label = { 146747,  5, 0 } }, /* taiki */
    { .label = { 131979,  6, 0 } }, /* takasu */
    { .label = {  92242,  8, 0 } }, /* takikawa */
    { .label = {  92276,  8, 0 } }, /* takinoue */
    { .label = {  74723,  9, 0 } }, /* teshikaga */
    { .label = { 112716,  7, 0 } }, /* tobetsu */
    { .label = { 131958,  5, 0 } }, /* tohma */
    { .label = {  74760,  9, 0 } }, /* tomakomai */
    { .label = { 132003,  6, 0 } }, /* tomari */
    { .label = {  93727,  4, 0 } }, /* toya */
    { .label = { 132027,  6, 0 } }, /* toyako */
    { .label = {  92309,  8, 0 } }, /* toyotomi */
    { .label = { 112746,  7, 0 } }, /* toyoura */
    { .label = {  92344,  8, 0 } }, /* tsubetsu */
    { .label = {  74797,  9, 0 } }, /* tsukigata */
    { .label = { 112776,  7, 0 } }, /* urakawa */
    { .label = { 132053,  6, 0 } }, /* urausu */
    { .label = { 112310,  4, 0 } }, /* uryu */
    { .label = {  74834,  9, 0 } }, /* utashinai */
    { .label = {  92379,  8, 0 } }, /* wakkanai */
    { .label = { 112806,  7, 0 } }, /* wassamu */
    { .label = { 132079,  6, 0 } }, /* yakumo */
    { .label = { 132107,  6, 0 } }, /* yoichi */

    /* entries 4249 to 4294 */
    { .label = { 155582,  4, 0 } }, /* aioi */
    { .label = {  74672,  6, 0 } }, /* akashi */
    { .label = {   8021,  3, 0 } }, /* ako */
    { .label = {  74870,  9, 0 } }, /* amagasaki */
    { .label = { 132135,  6, 0 } }, /* aogaki */
    { .label = {  92562,  5, 0 } }, /* asago */
    { .label = {  29125,  6, 0 } }, /* ashiya */
    { .label = {  48572,  5, 0 } }, /* awaji */
    { .label = {  92413,  8, 0 } }, /* fukusaki */
    { .label = { 112837,  7, 0 } }, /* goshiki */
    { .label = { 132159,  6, 0 } }, /* harima */
    { .label = { 132183,  6, 0 } }, /* himeji */
    { .label = {  21723,  8, 0 } }, /* ichikawa */
    { .label = {  77820,  7, 0 } }, /* inagawa */
    { .label = { 131885,  5, 0 } }, /* itami */
    { .label = {  92450,  8, 0 } }, /* kakogawa */
    { .label = {  92485,  8, 0 } }, /* kamigori */
    { .label = {  91753,  8, 0 } }, /* kamikawa */
    { .label = { 125614,  5, 0 } }, /* kasai */
    { .label = { 110675,  6, 0 } }, /* kasuga */
    { .label = {  74905,  9, 0 } }, /* kawanishi */
    { .label = {  36956,  4, 0 } }, /* miki */
    { .label = {  48547, 11, 0 } }, /* minamiawaji */
    { .label = {  48596, 11, 0 } }, /* nishinomiya */
    { .label = {  74944,  9, 0 } }, /* nishiwaki */
    { .label = {   8934,  3, 0 } }, /* ono */
    { .label = { 146767,  5, 0 } }, /* sanda */
    { .label = { 132212,  6, 0 } }, /* sannan */
    { .label = {  92519,  8, 0 } }, /* sasayama */
    { .label = { 135611,  4, 0 } }, /* sayo */
    { .label = { 131036,  6, 0 } }, /* shingu */
    { .label = {  74984,  9, 0 } }, /* shinonsen */
    { .label = { 146786,  5, 0 } }, /* shiso */
    { .label = {  75305,  6, 0 } }, /* sumoto */
    { .label = { 111699,  6, 0 } }, /* taishi */
    { .label = {  28641,  4, 0 } }, /* taka */
    { .label = {  61722, 10, 0 } }, /* takarazuka */
    { .label = {  92550,  8, 0 } }, /* takasago */
    { .label = {  92276,  6, 0 } }, /* takino */
    { .label = {  93933,  5, 0 } }, /* tamba */
    { .label = { 112868,  7, 0 } }, /* tatsuno */
    { .label = { 112896,  7, 0 } }, /* toyooka */
    { .label = { 131314,  4, 0 } }, /* yabu */
    { .label = {  77122,  7, 0 } }, /* yashiro */
    { .label = {  61299,  4, 0 } }, /* yoka */
    { .label = {  89759,  6, 0 } }, /* yokawa */

    /* entries 4295 to 4345 */
    { .label = {   3304,  3, 0 } }, /* ami */
    { .label = {  61072,  5, 0 } }, /* asahi */
    { .label = { 146807,  5, 0 } }, /* bando */
    { .label = {  92581,  8, 0 } }, /* chikusei */
    { .label = { 146828,  5, 0 } }, /* daigo */
    { .label = {  75021,  9, 0 } }, /* fujishiro */
    { .label = {  36642,  7, 0 } }, /* hitachi */
    { .label = {  48643, 11, 0 } }, /* hitachinaka */
    { .label = {  36642, 12, 0 } }, /* hitachiomiya */
    { .label = {  61764, 10, 0 } }, /* hitachiota */
    { .label = { 110294,  7, 0 } }, /* ibaraki */
    { .label = {   2428,  3, 0 } }, /* ina */
    { .label = {  92617,  8, 0 } }, /* inashiki */
    { .label = { 146849,  5, 0 } }, /* itako */
    { .label = { 134197,  5, 0 } }, /* iwama */
    { .label = { 155597,  4, 0 } }, /* joso */
    { .label = {  36343,  6, 0 } }, /* kamisu */
    { .label = {  73985,  6, 0 } }, /* kasama */
    { .label = {  77238,  7, 0 } }, /* kashima */
    { .label = {  48688, 11, 0 } }, /* kasumigaura */
    { .label = {  66124,  4, 0 } }, /* koga */
    { .label = { 120983,  4, 0 } }, /* miho */
    { .label = {  78053,  4, 0 } }, /* mito */
    { .label = {  96094,  6, 0 } }, /* moriya */
    { .label = {  21622,  4, 0 } }, /* naka */
    { .label = {  92650,  8, 0 } }, /* namegata */
    { .label = {  96597,  5, 0 } }, /* oarai */
    { .label = {  15308,  5, 0 } }, /* ogawa */
    { .label = { 112926,  7, 0 } }, /* omitama */
    { .label = {  75064,  9, 0 } }, /* ryugasaki */
    { .label = {  21708,  5, 0 } }, /* sakai */
    { .label = {  61805, 10, 0 } }, /* sakuragawa */
    { .label = {  75103,  9, 0 } }, /* shimodate */
    { .label = {  61847, 10, 0 } }, /* shimotsuma */
    { .label = {  75141,  9, 0 } }, /* shirosato */
    { .label = { 155616,  4, 0 } }, /* sowa */
    { .label = { 146869,  5, 0 } }, /* suifu */
    { .label = {  92681,  8, 0 } }, /* takahagi */
    { .label = {  48734, 11, 0 } }, /* tamatsukuri */
    { .label = { 145833,  5, 0 } }, /* tokai */
    { .label = { 132234,  6, 0 } }, /* tomobe */
    { .label = {  40245,  4, 0 } }, /* tone */
    { .label = { 132260,  6, 0 } }, /* toride */
    { .label = {  75177,  9, 0 } }, /* tsuchiura */
    { .label = { 112954,  7, 0 } }, /* tsukuba */
    { .label = {  92713,  8, 0 } }, /* uchihara */
    { .label = { 132285,  6, 0 } }, /* ushiku */
    { .label = { 111176,  7, 0 } }, /* yachiyo */
    { .label = {  89553,  8, 0 } }, /* yamagata */
    { .label = { 132313,  6, 0 } }, /* yawara */
    { .label = { 132477,  4, 0 } }, /* yuki */

    /* entries 4346 to 4364 */
    { .label = { 112985,  7, 0 } }, /* anamizu */
    { .label = { 146893,  5, 0 } }, /* hakui */
    { .label = { 113016,  7, 0 } }, /* hakusan */
    { .label = {  28693,  4, 0 } }, /* kaga */
    { .label = { 131794,  6, 0 } }, /* kahoku */
    { .label = {  92747,  8, 0 } }, /* kanazawa */
    { .label = {  92782,  8, 0 } }, /* kawakita */
    { .label = {  37451,  7, 0 } }, /* komatsu */
    { .label = {  92816,  8, 0 } }, /* nakanoto */
    { .label = { 146915,  5, 0 } }, /* nanao */
    { .label = {  36787,  4, 0 } }, /* nomi */
    { .label = {  92847,  8, 0 } }, /* nonoichi */
    { .label = {  79697,  4, 0 } }, /* noto */
    { .label = {  28516,  5, 0 } }, /* shika */
    { .label = { 133088,  4, 0 } }, /* suzu */
    { .label = { 113045,  7, 0 } }, /* tsubata */
    { .label = { 113073,  7, 0 } }, /* tsurugi */
    { .label = {  92881,  8, 0 } }, /* uchinada */
    { .label = {  95831,  6, 0 } }, /* wajima */

    /* entries 4365 to 4398 */
    { .label = { 146933,  5, 0 } }, /* fudai */
    { .label = {  92915,  8, 0 } }, /* fujisawa */
    { .label = {  92954,  8, 0 } }, /* hanamaki */
    { .label = {  75216,  9, 0 } }, /* hiraizumi */
    { .label = { 131213,  6, 0 } }, /* hirono */
    { .label = {  61140,  8, 0 } }, /* ichinohe */
    { .label = {  61890, 10, 0 } }, /* ichinoseki */
    { .label = {  92986,  8, 0 } }, /* iwaizumi */
    { .label = { 145622,  5, 0 } }, /* iwate */
    { .label = { 132339,  6, 0 } }, /* joboji */
    { .label = {  93025,  8, 0 } }, /* kamaishi */
    { .label = {  61933, 10, 0 } }, /* kanegasaki */
    { .label = { 113104,  7, 0 } }, /* karumai */
    { .label = { 146956,  5, 0 } }, /* kawai */
    { .label = {  93058,  8, 0 } }, /* kitakami */
    { .label = { 155634,  4, 0 } }, /* kuji */
    { .label = {  89932,  6, 0 } }, /* kunohe */
    { .label = {  93091,  8, 0 } }, /* kuzumaki */
    { .label = {  62311,  6, 0 } }, /* miyako */
    { .label = {  93130,  8, 0 } }, /* mizusawa */
    { .label = { 113133,  7, 0 } }, /* morioka */
    { .label = { 132370,  6, 0 } }, /* ninohe */
    { .label = {  14043,  4, 0 } }, /* noda */
    { .label = { 113162,  7, 0 } }, /* ofunato */
    { .label = { 148720,  4, 0 } }, /* oshu */
    { .label = {  75173,  7, 0 } }, /* otsuchi */
    { .label = {  28608, 13, 0 } }, /* rikuzentakata */
    { .label = {  49081,  5, 0 } }, /* shiwa */
    { .label = {  48780, 11, 0 } }, /* shizukuishi */
    { .label = { 132395,  6, 0 } }, /* sumita */
    { .label = {  93168,  8, 0 } }, /* tanohata */
    { .label = {  10128,  4, 0 } }, /* tono */
    { .label = { 132420,  6, 0 } }, /* yahaba */
    { .label = { 131113,  6, 0 } }, /* yamada */

    /* entries 4399 to 4413 */
    { .label = { 113192,  7, 0 } }, /* ayagawa */
    { .label = {  28663, 13, 0 } }, /* higashikagawa */
    { .label = { 113222,  7, 0 } }, /* kanonji */
    { .label = {  93198,  8, 0 } }, /* kotohira */
    { .label = { 146978,  5, 0 } }, /* manno */
    { .label = {  93231,  8, 0 } }, /* marugame */
    { .label = { 132445,  6, 0 } }, /* mitoyo */
    { .label = {  93265,  8, 0 } }, /* naoshima */
    { .label = { 132472,  6, 0 } }, /* sanuki */
    { .label = { 113253,  7, 0 } }, /* tadotsu */
    { .label = {  75257,  9, 0 } }, /* takamatsu */
    { .label = { 113282,  7, 0 } }, /* tonosho */
    { .label = {  93297,  8, 0 } }, /* uchinomi */
    { .label = { 146998,  5, 0 } }, /* utazu */
    { .label = {  93333,  8, 0 } }, /* zentsuji */

    /* entries 4414 to 4433 */
    { .label = { 147022,  5, 0 } }, /* akune */
    { .label = {  15189,  5, 0 } }, /* amami */
    { .label = { 147043,  5, 0 } }, /* hioki */
    { .label = {   3730,  3, 0 } }, /* isa */
    { .label = {  79122,  4, 0 } }, /* isen */
    { .label = {  61477,  5, 0 } }, /* izumi */
    { .label = {  72790,  9, 0 } }, /* kagoshima */
    { .label = { 132497,  6, 0 } }, /* kanoya */
    { .label = {  93372,  8, 0 } }, /* kawanabe */
    { .label = { 147065,  5, 0 } }, /* kinko */
    { .label = { 113311,  7, 0 } }, /* kouyama */
    { .label = {  61973, 10, 0 } }, /* makurazaki */
    { .label = {  75293,  9, 0 } }, /* matsumoto */
    { .label = {  62017, 10, 0 } }, /* minamitane */
    { .label = {  93406,  8, 0 } }, /* nakatane */
    { .label = {  36694, 12, 0 } }, /* nishinoomote */
    { .label = {  28719, 13, 0 } }, /* satsumasendai */
    { .label = {   9807,  3, 0 } }, /* soo */
    { .label = {  93436,  8, 0 } }, /* tarumizu */
    { .label = { 147087,  5, 0 } }, /* yusui */

    /* entries 4434 to 4463 */
    { .label = { 132522,  6, 0 } }, /* aikawa */
    { .label = { 132547,  6, 0 } }, /* atsugi */
    { .label = { 147111,  5, 0 } }, /* ayase */
    { .label = {  75331,  9, 0 } }, /* chigasaki */
    { .label = { 147131,  5, 0 } }, /* ebina */
    { .label = {  92915,  8, 0 } }, /* fujisawa */
    { .label = { 132572,  6, 0 } }, /* hadano */
    { .label = { 132596,  6, 0 } }, /* hakone */
    { .label = {  75369,  9, 0 } }, /* hiratsuka */
    { .label = { 113342,  7, 0 } }, /* isehara */
    { .label = { 132621,  6, 0 } }, /* kaisei */
    { .label = {  93473,  8, 0 } }, /* kamakura */
    { .label = {  93506,  8, 0 } }, /* kiyokawa */
    { .label = { 113369,  7, 0 } }, /* matsuda */
    { .label = {  21430, 14, 0 } }, /* minamiashigara */
    { .label = {  62532,  5, 0 } }, /* miura */
    { .label = { 135272,  5, 0 } }, /* nakai */
    { .label = {  93543,  8, 0 } }, /* ninomiya */
    { .label = { 113398,  7, 0 } }, /* odawara */
    { .label = {      3,  2, 0 } }, /* oi */
    { .label = { 111833,  4, 0 } }, /* oiso */
    { .label = {  62057, 10, 0 } }, /* sagamihara */
    { .label = {  93577,  8, 0 } }, /* samukawa */
    { .label = { 132645,  6, 0 } }, /* tsukui */
    { .label = {  21589,  8, 0 } }, /* yamakita */
    { .label = {  21547,  6, 0 } }, /* yamato */
    { .label = {  93612,  8, 0 } }, /* yokosuka */
    { .label = {  93648,  8, 0 } }, /* yugawara */
    { .label = { 134506,  4, 0 } }, /* zama */
    { .label = {  63231,  5, 0 } }, /* zushi */

    /* entries 4464 to 4494 */
    { .label = {  10638,  3, 0 } }, /* aki */
    { .label = { 132672,  6, 0 } }, /* geisei */
    { .label = { 131777,  6, 0 } }, /* hidaka */
    { .label = {  36744, 12, 0 } }, /* higashitsuno */
    { .label = {   3711,  3, 0 } }, /* ino */
    { .label = {  61559,  6, 0 } }, /* kagami */
    { .label = {  28463,  4, 0 } }, /* kami */
    { .label = {  93684,  8, 0 } }, /* kitagawa */
    { .label = { 145644,  5, 0 } }, /* kochi */
    { .label = {  62072,  6, 0 } }, /* mihara */
    { .label = {  93718,  8, 0 } }, /* motoyama */
    { .label = { 132697,  6, 0 } }, /* muroto */
    { .label = { 132723,  6, 0 } }, /* nahari */
    { .label = {  93752,  8, 0 } }, /* nakamura */
    { .label = { 113427,  7, 0 } }, /* nankoku */
    { .label = {  75406,  9, 0 } }, /* nishitosa */
    { .label = {  62096, 10, 0 } }, /* niyodogawa */
    { .label = {  75327,  4, 0 } }, /* ochi */
    { .label = {  62938,  5, 0 } }, /* okawa */
    { .label = { 112892,  5, 0 } }, /* otoyo */
    { .label = { 132746,  6, 0 } }, /* otsuki */
    { .label = { 111553,  6, 0 } }, /* sakawa */
    { .label = { 132772,  6, 0 } }, /* sukumo */
    { .label = { 132800,  6, 0 } }, /* susaki */
    { .label = {  38630,  4, 0 } }, /* tosa */
    { .label = {  48832, 11, 0 } }, /* tosashimizu */
    { .label = {  73167,  4, 0 } }, /* toyo */
    { .label = {  36774,  5, 0 } }, /* tsuno */
    { .label = { 147151,  5, 0 } }, /* umaji */
    { .label = { 132825,  6, 0 } }, /* yasuda */
    { .label = {  93784,  8, 0 } }, /* yusuhara */

    /* entries 4495 to 4517 */
    { .label = {  48898,  7, 0 } }, /* amakusa */
    { .label = {  79489,  4, 0 } }, /* arao */
    { .label = {   7960,  3, 0 } }, /* aso */
    { .label = { 147175,  5, 0 } }, /* choyo */
    { .label = { 113457,  7, 0 } }, /* gyokuto */
    { .label = {  48881, 11, 0 } }, /* kamiamakusa */
    { .label = { 113490,  7, 0 } }, /* kikuchi */
    { .label = {  89378,  8, 0 } }, /* kumamoto */
    { .label = { 113523,  7, 0 } }, /* mashiki */
    { .label = { 132851,  6, 0 } }, /* mifune */
    { .label = {  93819,  8, 0 } }, /* minamata */
    { .label = {  48926, 11, 0 } }, /* minamioguni */
    { .label = { 132879,  6, 0 } }, /* nagasu */
    { .label = {  75442,  9, 0 } }, /* nishihara */
    { .label = {  48951,  5, 0 } }, /* oguni */
    { .label = { 155867,  3, 0 } }, /* ozu */
    { .label = {  75305,  6, 0 } }, /* sumoto */
    { .label = {  93850,  8, 0 } }, /* takamori */
    { .label = {  11339,  3, 0 } }, /* uki */
    { .label = {  21559,  3, 0 } }, /* uto */
    { .label = {  89553,  6, 0 } }, /* yamaga */
    { .label = {  21547,  6, 0 } }, /* yamato */
    { .label = {  62141, 10, 0 } }, /* yatsushiro */

    /* entries 4518 to 4548 */
    { .label = { 131859,  5, 0 } }, /* ayabe */
    { .label = {  48973, 11, 0 } }, /* fukuchiyama */
    { .label = {  29111, 11, 0 } }, /* higashiyama */
    { .label = {    886,  3, 0 } }, /* ide */
    { .label = {   3423,  3, 0 } }, /* ine */
    { .label = { 134897,  4, 0 } }, /* joyo */
    { .label = { 113553,  7, 0 } }, /* kameoka */
    { .label = {  90025,  4, 0 } }, /* kamo */
    { .label = {  21606,  4, 0 } }, /* kita */
    { .label = { 155655,  4, 0 } }, /* kizu */
    { .label = {  93882,  8, 0 } }, /* kumiyama */
    { .label = {  93918,  8, 0 } }, /* kyotamba */
    { .label = {  75478,  9, 0 } }, /* kyotanabe */
    { .label = {  93953,  8, 0 } }, /* kyotango */
    { .label = { 113582,  7, 0 } }, /* maizuru */
    { .label = {  15200,  6, 0 } }, /* minami */
    { .label = {  15200, 15, 0 } }, /* minamiyamashiro */
    { .label = { 132903,  6, 0 } }, /* miyazu */
    { .label = { 155676,  4, 0 } }, /* muko */
    { .label = {  62184, 10, 0 } }, /* nagaokakyo */
    { .label = { 113615,  7, 0 } }, /* nakagyo */
    { .label = { 132933,  6, 0 } }, /* nantan */
    { .label = {  75516,  9, 0 } }, /* oyamazaki */
    { .label = { 147199,  5, 0 } }, /* sakyo */
    { .label = { 147221,  5, 0 } }, /* seika */
    { .label = {  75493,  6, 0 } }, /* tanabe */
    { .label = {  15532,  3, 0 } }, /* uji */
    { .label = {  75556,  9, 0 } }, /* ujitawara */
    { .label = { 132955,  6, 0 } }, /* wazuka */
    { .label = {  75596,  9, 0 } }, /* yamashina */
    { .label = {  61387,  6, 0 } }, /* yawata */

    /* entries 4549 to 4578 */
    { .label = {  61072,  5, 0 } }, /* asahi */
    { .label = { 147241,  5, 0 } }, /* inabe */
    { .label = {   6286,  3, 0 } }, /* ise */
    { .label = {  93988,  8, 0 } }, /* kameyama */
    { .label = { 113645,  7, 0 } }, /* kawagoe */
    { .label = { 130734,  4, 0 } }, /* kiho */
    { .label = {  94022,  8, 0 } }, /* kisosaki */
    { .label = { 130777,  4, 0 } }, /* kiwa */
    { .label = { 132985,  6, 0 } }, /* komono */
    { .label = { 131574,  6, 0 } }, /* kumano */
    { .label = { 133011,  6, 0 } }, /* kuwana */
    { .label = {  75633,  9, 0 } }, /* matsusaka */
    { .label = { 146382,  5, 0 } }, /* meiwa */
    { .label = {  95511,  6, 0 } }, /* mihama */
    { .label = {  75669,  9, 0 } }, /* minamiise */
    { .label = { 133038,  6, 0 } }, /* misugi */
    { .label = {  15216,  6, 0 } }, /* miyama */
    { .label = { 133065,  6, 0 } }, /* nabari */
    { .label = {   7973,  5, 0 } }, /* shima */
    { .label = { 133088,  6, 0 } }, /* suzuka */
    { .label = { 113253,  4, 0 } }, /* tado */
    { .label = { 146747,  5, 0 } }, /* taiki */
    { .label = {  90705,  4, 0 } }, /* taki */
    { .label = { 133117,  6, 0 } }, /* tamaki */
    { .label = { 128511,  4, 0 } }, /* toba */
    { .label = {   3242,  3, 0 } }, /* tsu */
    { .label = {  90624,  5, 0 } }, /* udono */
    { .label = {  94055,  8, 0 } }, /* ureshino */
    { .label = { 113676,  7, 0 } }, /* watarai */
    { .label = {  75706,  9, 0 } }, /* yokkaichi */

    /* entries 4579 to 4610 */
    { .label = {  94089,  8, 0 } }, /* furukawa */
    { .label = {   7956, 17, 0 } }, /* higashimatsushima */
    { .label = {  62226, 10, 0 } }, /* ishinomaki */
    { .label = { 113704,  7, 0 } }, /* iwanuma */
    { .label = {  78301,  6, 0 } }, /* kakuda */
    { .label = {  28463,  4, 0 } }, /* kami */
    { .label = {  89585,  8, 0 } }, /* kawasaki */
    { .label = {  94127,  8, 0 } }, /* marumori */
    { .label = {   7986, 10, 0 } }, /* matsushima */
    { .label = {  28771, 13, 0 } }, /* minamisanriku */
    { .label = {  21759,  6, 0 } }, /* misato */
    { .label = { 133141,  6, 0 } }, /* murata */
    { .label = { 133165,  6, 0 } }, /* natori */
    { .label = { 113735,  7, 0 } }, /* ogawara */
    { .label = {  93211,  5, 0 } }, /* ohira */
    { .label = { 113764,  7, 0 } }, /* onagawa */
    { .label = {  28443,  5, 0 } }, /* osaki */
    { .label = {  48517,  4, 0 } }, /* rifu */
    { .label = { 133188,  6, 0 } }, /* semine */
    { .label = { 113793,  7, 0 } }, /* shibata */
    { .label = {  28825, 13, 0 } }, /* shichikashuku */
    { .label = { 113821,  7, 0 } }, /* shikama */
    { .label = {  94161,  8, 0 } }, /* shiogama */
    { .label = {  75747,  9, 0 } }, /* shiroishi */
    { .label = { 133213,  6, 0 } }, /* tagajo */
    { .label = { 147261,  5, 0 } }, /* taiwa */
    { .label = {  87824,  4, 0 } }, /* tome */
    { .label = {  89405,  6, 0 } }, /* tomiya */
    { .label = { 133239,  6, 0 } }, /* wakuya */
    { .label = { 133268,  6, 0 } }, /* watari */
    { .label = {  94194,  8, 0 } }, /* yamamoto */
    { .label = {   4619,  3, 0 } }, /* zao */

    /* entries 4611 to 4637 */
    { .label = {     84,  3, 0 } }, /* aya */
    { .label = { 147282,  5, 0 } }, /* ebino */
    { .label = { 133293,  6, 0 } }, /* gokase */
    { .label = { 147303,  5, 0 } }, /* hyuga */
    { .label = {  94228,  8, 0 } }, /* kadogawa */
    { .label = {  62268, 10, 0 } }, /* kawaminami */
    { .label = { 155695,  4, 0 } }, /* kijo */
    { .label = {  93684,  8, 0 } }, /* kitagawa */
    { .label = {  90712,  8, 0 } }, /* kitakata */
    { .label = { 113850,  7, 0 } }, /* kitaura */
    { .label = {  75785,  9, 0 } }, /* kobayashi */
    { .label = {  94263,  8, 0 } }, /* kunitomi */
    { .label = {  28912,  7, 0 } }, /* kushima */
    { .label = { 133318,  6, 0 } }, /* mimata */
    { .label = {  62311, 10, 0 } }, /* miyakonojo */
    { .label = {  89413,  8, 0 } }, /* miyazaki */
    { .label = {  75824,  9, 0 } }, /* morotsuka */
    { .label = {  94298,  8, 0 } }, /* nichinan */
    { .label = {  75862,  9, 0 } }, /* nishimera */
    { .label = { 113878,  7, 0 } }, /* nobeoka */
    { .label = { 147327,  5, 0 } }, /* saito */
    { .label = { 133342,  6, 0 } }, /* shiiba */
    { .label = {  94331,  8, 0 } }, /* shintomi */
    { .label = {  94365,  8, 0 } }, /* takaharu */
    { .label = {  94397,  8, 0 } }, /* takanabe */
    { .label = {  94428,  8, 0 } }, /* takazaki */
    { .label = {  36774,  5, 0 } }, /* tsuno */

    /* entries 4638 to 4712 */
    { .label = {    189,  4, 0 } }, /* achi */
    { .label = {  94462,  8, 0 } }, /* agematsu */
    { .label = {  11373,  4, 0 } }, /* anan */
    { .label = { 110346,  4, 0 } }, /* aoki */
    { .label = {  61072,  5, 0 } }, /* asahi */
    { .label = { 113907,  7, 0 } }, /* azumino */
    { .label = {  75899,  9, 0 } }, /* chikuhoku */
    { .label = { 113939,  7, 0 } }, /* chikuma */
    { .label = {  61010,  5, 0 } }, /* chino */
    { .label = {  48525,  6, 0 } }, /* fujimi */
    { .label = { 133367,  6, 0 } }, /* hakuba */
    { .label = {  36224,  4, 0 } }, /* hara */
    { .label = { 133393,  6, 0 } }, /* hiraya */
    { .label = {  66000,  4, 0 } }, /* iida */
    { .label = { 133418,  6, 0 } }, /* iijima */
    { .label = { 133445,  6, 0 } }, /* iiyama */
    { .label = { 133470,  6, 0 } }, /* iizuna */
    { .label = { 146027,  5, 0 } }, /* ikeda */
    { .label = { 113971,  7, 0 } }, /* ikusaka */
    { .label = {   2428,  3, 0 } }, /* ina */
    { .label = {  75942,  9, 0 } }, /* karuizawa */
    { .label = {  48334,  8, 0 } }, /* kawakami */
    { .label = {  28884,  4, 0 } }, /* kiso */
    { .label = {  28884, 13, 0 } }, /* kisofukushima */
    { .label = {  94495,  8, 0 } }, /* kitaaiki */
    { .label = {  94527,  8, 0 } }, /* komagane */
    { .label = { 133497,  6, 0 } }, /* komoro */
    { .label = {  75983,  9, 0 } }, /* matsukawa */
    { .label = {  75293,  9, 0 } }, /* matsumoto */
    { .label = { 147346,  5, 0 } }, /* miasa */
    { .label = {  62357, 10, 0 } }, /* minamiaiki */
    { .label = {  62398, 10, 0 } }, /* minamimaki */
    { .label = {  36795, 12, 0 } }, /* minamiminowa */
    { .label = {  36820,  6, 0 } }, /* minowa */
    { .label = { 133523,  6, 0 } }, /* miyada */
    { .label = { 133549,  6, 0 } }, /* miyota */
    { .label = {  76022,  9, 0 } }, /* mochizuki */
    { .label = {  29030,  6, 0 } }, /* nagano */
    { .label = {  36369,  6, 0 } }, /* nagawa */
    { .label = { 133575,  6, 0 } }, /* nagiso */
    { .label = {  90510,  8, 0 } }, /* nakagawa */
    { .label = {  91176,  6, 0 } }, /* nakano */
    { .label = {  49025, 11, 0 } }, /* nozawaonsen */
    { .label = { 147365,  5, 0 } }, /* obuse */
    { .label = {  15308,  5, 0 } }, /* ogawa */
    { .label = {  97110,  5, 0 } }, /* okaya */
    { .label = {  36871,  6, 0 } }, /* omachi */
    { .label = {  27939,  3, 0 } }, /* omi */
    { .label = { 133599,  6, 0 } }, /* ookuwa */
    { .label = { 114000,  7, 0 } }, /* ooshika */
    { .label = {  94643,  5, 0 } }, /* otaki */
    { .label = { 147387,  5, 0 } }, /* otari */
    { .label = { 145964,  5, 0 } }, /* sakae */
    { .label = { 133627,  6, 0 } }, /* sakaki */
    { .label = {  61805,  4, 0 } }, /* saku */
    { .label = { 133651,  6, 0 } }, /* sakuho */
    { .label = {  76066,  9, 0 } }, /* shimosuwa */
    { .label = {  36847, 12, 0 } }, /* shinanomachi */
    { .label = {  94560,  8, 0 } }, /* shiojiri */
    { .label = {  76088,  4, 0 } }, /* suwa */
    { .label = { 133677,  6, 0 } }, /* suzaka */
    { .label = { 133704,  6, 0 } }, /* takagi */
    { .label = {  93850,  8, 0 } }, /* takamori */
    { .label = {  91041,  8, 0 } }, /* takayama */
    { .label = {  76107,  9, 0 } }, /* tateshina */
    { .label = { 112868,  7, 0 } }, /* tatsuno */
    { .label = {  76142,  9, 0 } }, /* togakushi */
    { .label = { 133728,  6, 0 } }, /* togura */
    { .label = {  28262,  4, 0 } }, /* tomi */
    { .label = { 155715,  4, 0 } }, /* ueda */
    { .label = {  76862,  4, 0 } }, /* wada */
    { .label = {  89553,  8, 0 } }, /* yamagata */
    { .label = {  62440, 10, 0 } }, /* yamanouchi */
    { .label = { 133753,  6, 0 } }, /* yasaka */
    { .label = { 114029,  7, 0 } }, /* yasuoka */

    /* entries 4713 to 4734 */
    { .label = { 114059,  7, 0 } }, /* chijiwa */
    { .label = {  74544,  5, 0 } }, /* futsu */
    { .label = {  36931,  4, 0 } }, /* goto */
    { .label = { 133777,  6, 0 } }, /* hasami */
    { .label = { 133801,  6, 0 } }, /* hirado */
    { .label = {  14888,  3, 0 } }, /* iki */
    { .label = { 114094,  7, 0 } }, /* isahaya */
    { .label = {  90827,  8, 0 } }, /* kawatana */
    { .label = {  62484, 10, 0 } }, /* kuchinotsu */
    { .label = {  94596,  8, 0 } }, /* matsuura */
    { .label = {  89450,  8, 0 } }, /* nagasaki */
    { .label = { 146048,  5, 0 } }, /* obama */
    { .label = { 147406,  5, 0 } }, /* omura */
    { .label = {  95034,  5, 0 } }, /* oseto */
    { .label = { 133826,  6, 0 } }, /* saikai */
    { .label = { 133849,  6, 0 } }, /* sasebo */
    { .label = { 147427,  5, 0 } }, /* seihi */
    { .label = {  76181,  9, 0 } }, /* shimabara */
    { .label = {  36897, 12, 0 } }, /* shinkamigoto */
    { .label = { 114122,  7, 0 } }, /* togitsu */
    { .label = {   7994,  8, 0 } }, /* tsushima */
    { .label = { 147448,  5, 0 } }, /* unzen */

    /* entries 4735 to 4772 */
    { .label = {  51761,  4, 0 } }, /* ando */
    { .label = { 122073,  4, 0 } }, /* gose */
    { .label = { 133873,  6, 0 } }, /* heguri */
    { .label = {  21486, 14, 0 } }, /* higashiyoshino */
    { .label = { 114152,  7, 0 } }, /* ikaruga */
    { .label = {  94523,  5, 0 } }, /* ikoma */
    { .label = {  36948, 12, 0 } }, /* kamikitayama */
    { .label = { 114181,  7, 0 } }, /* kanmaki */
    { .label = { 114210,  7, 0 } }, /* kashiba */
    { .label = {  76217,  9, 0 } }, /* kashihara */
    { .label = {  76253,  9, 0 } }, /* katsuragi */
    { .label = { 146956,  5, 0 } }, /* kawai */
    { .label = {  48334,  8, 0 } }, /* kawakami */
    { .label = {  74905,  9, 0 } }, /* kawanishi */
    { .label = { 147472,  5, 0 } }, /* koryo */
    { .label = {  94629,  8, 0 } }, /* kurotaki */
    { .label = {  94874,  6, 0 } }, /* mitsue */
    { .label = { 133900,  6, 0 } }, /* miyake */
    { .label = {  13952,  4, 0 } }, /* nara */
    { .label = {  94663,  8, 0 } }, /* nosegawa */
    { .label = {  94573,  3, 0 } }, /* oji */
    { .label = {  10514,  4, 0 } }, /* ouda */
    { .label = { 147495,  5, 0 } }, /* oyodo */
    { .label = { 114239,  7, 0 } }, /* sakurai */
    { .label = { 147518,  5, 0 } }, /* sango */
    { .label = {  76290,  9, 0 } }, /* shimoichi */
    { .label = {  28943, 13, 0 } }, /* shimokitayama */
    { .label = { 133927,  6, 0 } }, /* shinjo */
    { .label = {  86212,  4, 0 } }, /* soni */
    { .label = {  94697,  8, 0 } }, /* takatori */
    { .label = {  62529, 10, 0 } }, /* tawaramoto */
    { .label = { 114267,  7, 0 } }, /* tenkawa */
    { .label = { 147538,  5, 0 } }, /* tenri */
    { .label = {  10518,  3, 0 } }, /* uda */
    { .label = {  21547, 14, 0 } }, /* yamatokoriyama */
    { .label = {  36998, 12, 0 } }, /* yamatotakada */
    { .label = { 114297,  7, 0 } }, /* yamazoe */
    { .label = {  21516,  7, 0 } }, /* yoshino */

    /* entries 4773 to 4806 */
    { .label = {    320,  3, 0 } }, /* aga */
    { .label = {  29034,  5, 0 } }, /* agano */
    { .label = { 147558,  5, 0 } }, /* gosen */
    { .label = {  94728,  8, 0 } }, /* itoigawa */
    { .label = {  76330,  9, 0 } }, /* izumozaki */
    { .label = { 133955,  6, 0 } }, /* joetsu */
    { .label = {  90025,  4, 0 } }, /* kamo */
    { .label = { 133983,  6, 0 } }, /* kariwa */
    { .label = {  49073, 11, 0 } }, /* kashiwazaki */
    { .label = {  37046, 12, 0 } }, /* minamiuonuma */
    { .label = { 114329,  7, 0 } }, /* mitsuke */
    { .label = { 147579,  5, 0 } }, /* muika */
    { .label = {  94762,  8, 0 } }, /* murakami */
    { .label = { 147601,  5, 0 } }, /* myoko */
    { .label = {  62184,  7, 0 } }, /* nagaoka */
    { .label = { 110322,  7, 0 } }, /* niigata */
    { .label = { 147625,  5, 0 } }, /* ojiya */
    { .label = {  27939,  3, 0 } }, /* omi */
    { .label = { 153170,  4, 0 } }, /* sado */
    { .label = { 147649,  5, 0 } }, /* sanjo */
    { .label = { 134009,  5, 0 } }, /* seiro */
    { .label = { 134009,  6, 0 } }, /* seirou */
    { .label = {  94796,  8, 0 } }, /* sekikawa */
    { .label = { 113793,  7, 0 } }, /* shibata */
    { .label = {  89832,  6, 0 } }, /* tagami */
    { .label = { 134034,  6, 0 } }, /* tainai */
    { .label = { 134056,  6, 0 } }, /* tochio */
    { .label = {  76374,  9, 0 } }, /* tokamachi */
    { .label = { 114360,  7, 0 } }, /* tsubame */
    { .label = { 112019,  6, 0 } }, /* tsunan */
    { .label = {  37071,  6, 0 } }, /* uonuma */
    { .label = { 134082,  6, 0 } }, /* yahiko */
    { .label = { 147671,  5, 0 } }, /* yoita */
    { .label = { 134109,  6, 0 } }, /* yuzawa */

    /* entries 4807 to 4825 */
    { .label = { 147692,  5, 0 } }, /* beppu */
    { .label = {  94831,  8, 0 } }, /* bungoono */
    { .label = {  49123, 11, 0 } }, /* bungotakada */
    { .label = { 134140,  6, 0 } }, /* hasama */
    { .label = { 114064,  4, 0 } }, /* hiji */
    { .label = {  76412,  9, 0 } }, /* himeshima */
    { .label = {  36642,  4, 0 } }, /* hita */
    { .label = {  94866,  8, 0 } }, /* kamitsue */
    { .label = { 114390,  7, 0 } }, /* kokonoe */
    { .label = {  90095,  4, 0 } }, /* kuju */
    { .label = {  94900,  8, 0 } }, /* kunisaki */
    { .label = {  96704,  4, 0 } }, /* kusu */
    { .label = {  36643,  4, 0 } }, /* oita */
    { .label = { 147718,  5, 0 } }, /* saiki */
    { .label = { 134163,  6, 0 } }, /* taketa */
    { .label = { 114420,  7, 0 } }, /* tsukumi */
    { .label = {  13836,  3, 0 } }, /* usa */
    { .label = { 147738,  5, 0 } }, /* usuki */
    { .label = { 155732,  4, 0 } }, /* yufu */

    /* entries 4826 to 4851 */
    { .label = { 134186,  6, 0 } }, /* akaiwa */
    { .label = {  94934,  8, 0 } }, /* asakuchi */
    { .label = { 147761,  5, 0 } }, /* bizen */
    { .label = {  76451,  9, 0 } }, /* hayashima */
    { .label = { 110294,  5, 0 } }, /* ibara */
    { .label = {  94968,  8, 0 } }, /* kagamino */
    { .label = { 114452,  7, 0 } }, /* kasaoka */
    { .label = {  95001,  8, 0 } }, /* kibichuo */
    { .label = { 114479,  7, 0 } }, /* kumenan */
    { .label = {  76489,  9, 0 } }, /* kurashiki */
    { .label = { 134211,  6, 0 } }, /* maniwa */
    { .label = { 134237,  6, 0 } }, /* misaki */
    { .label = {  15838,  4, 0 } }, /* nagi */
    { .label = { 147785,  5, 0 } }, /* niimi */
    { .label = {  37097, 12, 0 } }, /* nishiawakura */
    { .label = {  97110,  7, 0 } }, /* okayama */
    { .label = { 114509,  7, 0 } }, /* satosho */
    { .label = {  95038,  8, 0 } }, /* setouchi */
    { .label = { 133927,  6, 0 } }, /* shinjo */
    { .label = {  32374,  4, 0 } }, /* shoo */
    { .label = { 155754,  4, 0 } }, /* soja */
    { .label = {  76528,  9, 0 } }, /* takahashi */
    { .label = { 134262,  6, 0 } }, /* tamano */
    { .label = {  11318,  7, 0 } }, /* tsuyama */
    { .label = { 155772,  4, 0 } }, /* wake */
    { .label = { 134285,  6, 0 } }, /* yakage */

    /* entries 4852 to 4893 */
    { .label = {  95261,  5, 0 } }, /* aguni */
    { .label = { 114537,  7, 0 } }, /* ginowan */
    { .label = { 134311,  6, 0 } }, /* ginoza */
    { .label = {  76564,  9, 0 } }, /* gushikami */
    { .label = { 114568,  7, 0 } }, /* haebaru */
    { .label = {   7956,  7, 0 } }, /* higashi */
    { .label = { 134338,  6, 0 } }, /* hirara */
    { .label = { 147806,  5, 0 } }, /* iheya */
    { .label = {  95073,  8, 0 } }, /* ishigaki */
    { .label = {  78200,  8, 0 } }, /* ishikawa */
    { .label = { 134361,  6, 0 } }, /* itoman */
    { .label = { 147828,  5, 0 } }, /* izena */
    { .label = { 134385,  6, 0 } }, /* kadena */
    { .label = {  25076,  3, 0 } }, /* kin */
    { .label = {  76604,  9, 0 } }, /* kitadaito */
    { .label = {  21606, 14, 0 } }, /* kitanakagusuku */
    { .label = {  95107,  8, 0 } }, /* kumejima */
    { .label = {  95145,  8, 0 } }, /* kunigami */
    { .label = {  49169, 11, 0 } }, /* minamidaito */
    { .label = { 134409,  6, 0 } }, /* motobu */
    { .label = {  77548,  4, 0 } }, /* nago */
    { .label = {  77942,  4, 0 } }, /* naha */
    { .label = {  21622, 10, 0 } }, /* nakagusuku */
    { .label = { 114597,  7, 0 } }, /* nakijin */
    { .label = { 147850,  5, 0 } }, /* nanjo */
    { .label = {  75442,  9, 0 } }, /* nishihara */
    { .label = { 147872,  5, 0 } }, /* ogimi */
    { .label = { 110349,  7, 0 } }, /* okinawa */
    { .label = {   8292,  4, 0 } }, /* onna */
    { .label = { 114628,  7, 0 } }, /* shimoji */
    { .label = {  95180,  8, 0 } }, /* taketomi */
    { .label = { 134436,  6, 0 } }, /* tarama */
    { .label = {  76640,  9, 0 } }, /* tokashiki */
    { .label = {  62570, 10, 0 } }, /* tomigusuku */
    { .label = { 134458,  6, 0 } }, /* tonaki */
    { .label = { 134482,  6, 0 } }, /* urasoe */
    { .label = { 147894,  5, 0 } }, /* uruma */
    { .label = { 147916,  5, 0 } }, /* yaese */
    { .label = { 114661,  7, 0 } }, /* yomitan */
    { .label = {  95213,  8, 0 } }, /* yonabaru */
    { .label = {  95247,  8, 0 } }, /* yonaguni */
    { .label = { 134506,  6, 0 } }, /* zamami */

    /* entries 4894 to 4943 */
    { .label = { 147937,  5, 0 } }, /* abeno */
    { .label = {  21666, 14, 0 } }, /* chihayaakasaka */
    { .label = {  48094,  4, 0 } }, /* chuo */
    { .label = {  49194,  5, 0 } }, /* daito */
    { .label = {  76678,  9, 0 } }, /* fujiidera */
    { .label = {  95282,  8, 0 } }, /* habikino */
    { .label = { 134533,  6, 0 } }, /* hannan */
    { .label = {  37148, 12, 0 } }, /* higashiosaka */
    { .label = {  11209, 16, 0 } }, /* higashisumiyoshi */
    { .label = {  15263, 15, 0 } }, /* higashiyodogawa */
    { .label = {  95316,  8, 0 } }, /* hirakata */
    { .label = { 110294,  7, 0 } }, /* ibaraki */
    { .label = { 146027,  5, 0 } }, /* ikeda */
    { .label = {  61477,  5, 0 } }, /* izumi */
    { .label = {  76720,  9, 0 } }, /* izumiotsu */
    { .label = {  76762,  9, 0 } }, /* izumisano */
    { .label = {  61098,  6, 0 } }, /* kadoma */
    { .label = { 114691,  7, 0 } }, /* kaizuka */
    { .label = { 111721,  5, 0 } }, /* kanan */
    { .label = {  76802,  9, 0 } }, /* kashiwara */
    { .label = { 134556,  6, 0 } }, /* katano */
    { .label = {  28998, 13, 0 } }, /* kawachinagano */
    { .label = {  76840,  9, 0 } }, /* kishiwada */
    { .label = {  21606,  4, 0 } }, /* kita */
    { .label = {  95347,  8, 0 } }, /* kumatori */
    { .label = {  76880,  9, 0 } }, /* matsubara */
    { .label = {  49419,  6, 0 } }, /* minato */
    { .label = {  95638,  5, 0 } }, /* minoh */
    { .label = { 134237,  6, 0 } }, /* misaki */
    { .label = {  76916,  9, 0 } }, /* moriguchi */
    { .label = {  95381,  8, 0 } }, /* neyagawa */
    { .label = {  36694,  5, 0 } }, /* nishi */
    { .label = {  49510,  4, 0 } }, /* nose */
    { .label = {  49214, 11, 0 } }, /* osakasayama */
    { .label = {  21708,  5, 0 } }, /* sakai */
    { .label = {  49233,  6, 0 } }, /* sayama */
    { .label = { 134579,  6, 0 } }, /* sennan */
    { .label = { 134602,  6, 0 } }, /* settsu */
    { .label = {  49257, 11, 0 } }, /* shijonawate */
    { .label = {  76957,  9, 0 } }, /* shimamoto */
    { .label = { 147957,  5, 0 } }, /* suita */
    { .label = { 114723,  7, 0 } }, /* tadaoka */
    { .label = { 111699,  6, 0 } }, /* taishi */
    { .label = { 134627,  6, 0 } }, /* tajiri */
    { .label = {  95416,  8, 0 } }, /* takaishi */
    { .label = {  76995,  9, 0 } }, /* takatsuki */
    { .label = {  37197, 12, 0 } }, /* tondabayashi */
    { .label = {  95448,  8, 0 } }, /* toyonaka */
    { .label = { 134653,  6, 0 } }, /* toyono */
    { .label = {  51020,  3, 0 } }, /* yao */

    /* entries 4944 to 4969 */
    { .label = {  68089,  6, 0 } }, /* ariake */
    { .label = {  29341,  5, 0 } }, /* arita */
    { .label = {  95481,  8, 0 } }, /* fukudomi */
    { .label = { 134679,  6, 0 } }, /* genkai */
    { .label = {  95520,  8, 0 } }, /* hamatama */
    { .label = {  28304,  5, 0 } }, /* hizen */
    { .label = {  28596,  5, 0 } }, /* imari */
    { .label = {  95551,  8, 0 } }, /* kamimine */
    { .label = { 114750,  7, 0 } }, /* kanzaki */
    { .label = { 114781,  7, 0 } }, /* karatsu */
    { .label = {  77238,  7, 0 } }, /* kashima */
    { .label = {  90906,  8, 0 } }, /* kitagata */
    { .label = {  95585,  8, 0 } }, /* kitahata */
    { .label = {  62431,  6, 0 } }, /* kiyama */
    { .label = { 114809,  7, 0 } }, /* kouhoku */
    { .label = { 114842,  7, 0 } }, /* kyuragi */
    { .label = {  62616, 10, 0 } }, /* nishiarita */
    { .label = {  21816,  3, 0 } }, /* ogi */
    { .label = {  36871,  6, 0 } }, /* omachi */
    { .label = {  62461,  5, 0 } }, /* ouchi */
    { .label = {   8206,  4, 0 } }, /* saga */
    { .label = {  75747,  9, 0 } }, /* shiroishi */
    { .label = {  73661,  4, 0 } }, /* taku */
    { .label = {  41947,  4, 0 } }, /* tara */
    { .label = { 131378,  4, 0 } }, /* tosu */
    { .label = {  49306, 11, 0 } }, /* yoshinogari */

    /* entries 4970 to 5038 */
    { .label = { 112778,  7, 0 } }, /* arakawa */
    { .label = {  21705,  5, 0 } }, /* asaka */
    { .label = {  15360,  8, 0 } }, /* chichibu */
    { .label = {  48525,  6, 0 } }, /* fujimi */
    { .label = {  95616,  8, 0 } }, /* fujimino */
    { .label = { 134704,  6, 0 } }, /* fukaya */
    { .label = { 147977,  5, 0 } }, /* hanno */
    { .label = { 147997,  5, 0 } }, /* hanyu */
    { .label = { 134732,  6, 0 } }, /* hasuda */
    { .label = {  95655,  8, 0 } }, /* hatogaya */
    { .label = {  95688,  8, 0 } }, /* hatoyama */
    { .label = { 131777,  6, 0 } }, /* hidaka */
    { .label = {  15330, 15, 0 } }, /* higashichichibu */
    { .label = {  11280, 16, 0 } }, /* higashimatsuyama */
    { .label = {  73337,  5, 0 } }, /* honjo */
    { .label = {   2428,  3, 0 } }, /* ina */
    { .label = { 148020,  5, 0 } }, /* iruma */
    { .label = {  95721,  8, 0 } }, /* iwatsuki */
    { .label = {  77032,  9, 0 } }, /* kamiizumi */
    { .label = {  91753,  8, 0 } }, /* kamikawa */
    { .label = {  95757,  8, 0 } }, /* kamisato */
    { .label = {  95789,  8, 0 } }, /* kasukabe */
    { .label = { 113645,  7, 0 } }, /* kawagoe */
    { .label = {  15548,  9, 0 } }, /* kawaguchi */
    { .label = {  95823,  8, 0 } }, /* kawajima */
    { .label = { 155791,  4, 0 } }, /* kazo */
    { .label = {  95860,  8, 0 } }, /* kitamoto */
    { .label = {  77074,  9, 0 } }, /* koshigaya */
    { .label = { 114874,  7, 0 } }, /* kounosu */
    { .label = {  28874,  4, 0 } }, /* kuki */
    { .label = {  95893,  8, 0 } }, /* kumagaya */
    { .label = {  62655, 10, 0 } }, /* matsubushi */
    { .label = { 134757,  6, 0 } }, /* minano */
    { .label = {  21759,  6, 0 } }, /* misato */
    { .label = {  77113,  9, 0 } }, /* miyashiro */
    { .label = {  11248,  7, 0 } }, /* miyoshi */
    { .label = {  95928,  8, 0 } }, /* moroyama */
    { .label = {  95962,  8, 0 } }, /* nagatoro */
    { .label = {  95993,  8, 0 } }, /* namegawa */
    { .label = { 148041,  5, 0 } }, /* niiza */
    { .label = {  66129,  5, 0 } }, /* ogano */
    { .label = {  15308,  5, 0 } }, /* ogawa */
    { .label = { 148063,  5, 0 } }, /* ogose */
    { .label = { 114905,  7, 0 } }, /* okegawa */
    { .label = {  36672,  5, 0 } }, /* omiya */
    { .label = {  94643,  5, 0 } }, /* otaki */
    { .label = { 134781,  6, 0 } }, /* ranzan */
    { .label = { 114936,  7, 0 } }, /* ryokami */
    { .label = { 110379,  7, 0 } }, /* saitama */
    { .label = { 134806,  6, 0 } }, /* sakado */
    { .label = { 148084,  5, 0 } }, /* satte */
    { .label = {  49233,  6, 0 } }, /* sayama */
    { .label = {  76506,  5, 0 } }, /* shiki */
    { .label = {  96027,  8, 0 } }, /* shiraoka */
    { .label = {  59601,  4, 0 } }, /* soka */
    { .label = { 134830,  6, 0 } }, /* sugito */
    { .label = {  66229,  4, 0 } }, /* toda */
    { .label = {  96059,  8, 0 } }, /* tokigawa */
    { .label = {  62699, 10, 0 } }, /* tokorozawa */
    { .label = {  37247, 12, 0 } }, /* tsurugashima */
    { .label = { 102667,  5, 0 } }, /* urawa */
    { .label = { 134856,  6, 0 } }, /* warabi */
    { .label = { 134882,  6, 0 } }, /* yashio */
    { .label = { 134908,  6, 0 } }, /* yokoze */
    { .label = {  74156,  4, 0 } }, /* yono */
    { .label = { 148103,  5, 0 } }, /* yorii */
    { .label = {  49557,  7, 0 } }, /* yoshida */
    { .label = {  77152,  9, 0 } }, /* yoshikawa */
    { .label = { 114967,  7, 0 } }, /* yoshimi */

    /* entries 5039 to 5061 */
    { .label = { 148125,  5, 0 } }, /* aisho */
    { .label = { 109302,  4, 0 } }, /* gamo */
    { .label = {  62744, 10, 0 } }, /* higashiomi */
    { .label = { 134938,  6, 0 } }, /* hikone */
    { .label = {   2679,  4, 0 } }, /* koka */
    { .label = { 145792,  5, 0 } }, /* konan */
    { .label = {  66488,  5, 0 } }, /* kosei */
    { .label = {  93198,  4, 0 } }, /* koto */
    { .label = { 112002,  7, 0 } }, /* kusatsu */
    { .label = { 114999,  7, 0 } }, /* maibara */
    { .label = {  96094,  8, 0 } }, /* moriyama */
    { .label = {  96128,  8, 0 } }, /* nagahama */
    { .label = {  77193,  9, 0 } }, /* nishiazai */
    { .label = {  96159,  8, 0 } }, /* notogawa */
    { .label = {  49353, 11, 0 } }, /* omihachiman */
    { .label = {  36625,  4, 0 } }, /* otsu */
    { .label = { 148145,  5, 0 } }, /* ritto */
    { .label = { 148165,  5, 0 } }, /* ryuoh */
    { .label = {  77231,  9, 0 } }, /* takashima */
    { .label = {  76995,  9, 0 } }, /* takatsuki */
    { .label = {  96193,  8, 0 } }, /* torahime */
    { .label = {  96226,  8, 0 } }, /* toyosato */
    { .label = {  37401,  4, 0 } }, /* yasu */

    /* entries 5062 to 5084 */
    { .label = { 133708,  5, 0 } }, /* akagi */
    { .label = {   2423,  3, 0 } }, /* ama */
    { .label = { 148189,  5, 0 } }, /* gotsu */
    { .label = { 134964,  6, 0 } }, /* hamada */
    { .label = {  37298, 12, 0 } }, /* higashiizumo */
    { .label = {  21732,  6, 0 } }, /* hikawa */
    { .label = { 134988,  6, 0 } }, /* hikimi */
    { .label = {  37328,  5, 0 } }, /* izumo */
    { .label = {  96259,  8, 0 } }, /* kakinoki */
    { .label = { 135015,  6, 0 } }, /* masuda */
    { .label = { 135040,  6, 0 } }, /* matsue */
    { .label = {  21759,  6, 0 } }, /* misato */
    { .label = {  37353, 12, 0 } }, /* nishinoshima */
    { .label = {   8532,  4, 0 } }, /* ohda */
    { .label = {  62787, 10, 0 } }, /* okinoshima */
    { .label = {  96293,  8, 0 } }, /* okuizumo */
    { .label = { 110405,  7, 0 } }, /* shimane */
    { .label = { 135065,  6, 0 } }, /* tamayu */
    { .label = { 115026,  7, 0 } }, /* tsuwano */
    { .label = { 148211,  5, 0 } }, /* unnan */
    { .label = { 132079,  6, 0 } }, /* yakumo */
    { .label = { 135091,  6, 0 } }, /* yasugi */
    { .label = { 115057,  7, 0 } }, /* yatsuka */

    /* entries 5085 to 5120 */
    { .label = {  30987,  4, 0 } }, /* arai */
    { .label = {  90927,  5, 0 } }, /* atami */
    { .label = {  15526,  4, 0 } }, /* fuji */
    { .label = { 115087,  7, 0 } }, /* fujieda */
    { .label = {  15526,  8, 0 } }, /* fujikawa */
    { .label = {  62829, 10, 0 } }, /* fujinomiya */
    { .label = { 115121,  7, 0 } }, /* fukuroi */
    { .label = { 115154,  7, 0 } }, /* gotemba */
    { .label = { 115184,  7, 0 } }, /* haibara */
    { .label = {  77267,  9, 0 } }, /* hamamatsu */
    { .label = {  37298, 10, 0 } }, /* higashiizu */
    { .label = {     41,  3, 0 } }, /* ito */
    { .label = { 148231,  5, 0 } }, /* iwata */
    { .label = {  28388,  3, 0 } }, /* izu */
    { .label = {  77304,  9, 0 } }, /* izunokuni */
    { .label = {  96332,  8, 0 } }, /* kakegawa */
    { .label = { 115211,  7, 0 } }, /* kannami */
    { .label = {  77346,  9, 0 } }, /* kawanehon */
    { .label = { 135118,  6, 0 } }, /* kawazu */
    { .label = {  96367,  8, 0 } }, /* kikugawa */
    { .label = { 148252,  5, 0 } }, /* kosai */
    { .label = {  62877, 10, 0 } }, /* makinohara */
    { .label = {  77385,  9, 0 } }, /* matsuzaki */
    { .label = {  77425,  9, 0 } }, /* minamiizu */
    { .label = { 111578,  7, 0 } }, /* mishima */
    { .label = {  77466,  9, 0 } }, /* morimachi */
    { .label = {  96404,  8, 0 } }, /* nishiizu */
    { .label = { 135148,  6, 0 } }, /* numazu */
    { .label = {  96441,  8, 0 } }, /* omaezaki */
    { .label = { 115239,  7, 0 } }, /* shimada */
    { .label = {  48847,  7, 0 } }, /* shimizu */
    { .label = {  75103,  7, 0 } }, /* shimoda */
    { .label = {  89481,  8, 0 } }, /* shizuoka */
    { .label = { 135177,  6, 0 } }, /* susono */
    { .label = { 111734,  5, 0 } }, /* yaizu */
    { .label = {  49557,  7, 0 } }, /* yoshida */

    /* entries 5121 to 5151 */
    { .label = {  28677,  8, 0 } }, /* ashikaga */
    { .label = { 155810,  4, 0 } }, /* bato */
    { .label = { 122265,  4, 0 } }, /* haga */
    { .label = { 115268,  7, 0 } }, /* ichikai */
    { .label = { 115298,  7, 0 } }, /* iwafune */
    { .label = {  62917, 10, 0 } }, /* kaminokawa */
    { .label = { 135202,  6, 0 } }, /* kanuma */
    { .label = {  62960, 10, 0 } }, /* karasuyama */
    { .label = { 115331,  7, 0 } }, /* kuroiso */
    { .label = { 115361,  7, 0 } }, /* mashiko */
    { .label = { 155826,  4, 0 } }, /* mibu */
    { .label = {  74619,  4, 0 } }, /* moka */
    { .label = { 135227,  6, 0 } }, /* motegi */
    { .label = {  37403,  4, 0 } }, /* nasu */
    { .label = {  37403, 12, 0 } }, /* nasushiobara */
    { .label = { 148272,  5, 0 } }, /* nikko */
    { .label = {  77505,  9, 0 } }, /* nishikata */
    { .label = { 155845,  4, 0 } }, /* nogi */
    { .label = {  93211,  5, 0 } }, /* ohira */
    { .label = {  96476,  8, 0 } }, /* ohtawara */
    { .label = {  21543,  5, 0 } }, /* oyama */
    { .label = {  61805,  6, 0 } }, /* sakura */
    { .label = {  76787,  4, 0 } }, /* sano */
    { .label = {  63001, 10, 0 } }, /* shimotsuke */
    { .label = { 135253,  6, 0 } }, /* shioya */
    { .label = {  63045, 10, 0 } }, /* takanezawa */
    { .label = { 110434,  7, 0 } }, /* tochigi */
    { .label = {  48128,  5, 0 } }, /* tsuga */
    { .label = { 148294,  5, 0 } }, /* ujiie */
    { .label = {  63088, 10, 0 } }, /* utsunomiya */
    { .label = { 148318,  5, 0 } }, /* yaita */

    /* entries 5152 to 5168 */
    { .label = {  61474,  6, 0 } }, /* aizumi */
    { .label = {  11373,  4, 0 } }, /* anan */
    { .label = {  61317,  6, 0 } }, /* ichiba */
    { .label = { 148338,  5, 0 } }, /* itano */
    { .label = { 135279,  6, 0 } }, /* kainan */
    { .label = {  37451, 12, 0 } }, /* komatsushima */
    { .label = {  63132, 10, 0 } }, /* matsushige */
    { .label = {  62414,  4, 0 } }, /* mima */
    { .label = {  15200,  6, 0 } }, /* minami */
    { .label = {  11248,  7, 0 } }, /* miyoshi */
    { .label = {  27287,  4, 0 } }, /* mugi */
    { .label = {  90510,  8, 0 } }, /* nakagawa */
    { .label = { 135302,  6, 0 } }, /* naruto */
    { .label = {  77541,  9, 0 } }, /* sanagochi */
    { .label = {  77578,  9, 0 } }, /* shishikui */
    { .label = {  72828,  9, 0 } }, /* tokushima */
    { .label = { 135326,  6, 0 } }, /* wajiki */

    /* entries 5169 to 5225 */
    { .label = { 135356,  6, 0 } }, /* adachi */
    { .label = { 115391,  7, 0 } }, /* akiruno */
    { .label = {  96509,  8, 0 } }, /* akishima */
    { .label = {  77618,  9, 0 } }, /* aogashima */
    { .label = { 112778,  7, 0 } }, /* arakawa */
    { .label = { 135381,  6, 0 } }, /* bunkyo */
    { .label = { 111880,  7, 0 } }, /* chiyoda */
    { .label = { 148357,  5, 0 } }, /* chofu */
    { .label = {  48094,  4, 0 } }, /* chuo */
    { .label = { 115420,  7, 0 } }, /* edogawa */
    { .label = { 146405,  5, 0 } }, /* fuchu */
    { .label = { 148382,  5, 0 } }, /* fussa */
    { .label = { 115451,  7, 0 } }, /* hachijo */
    { .label = {  96542,  8, 0 } }, /* hachioji */
    { .label = { 135410,  6, 0 } }, /* hamura */
    { .label = {  29053, 13, 0 } }, /* higashikurume */
    { .label = {  15398, 15, 0 } }, /* higashimurayama */
    { .label = {  29111, 13, 0 } }, /* higashiyamato */
    { .label = {  21530,  4, 0 } }, /* hino */
    { .label = { 135435,  6, 0 } }, /* hinode */
    { .label = {  96579,  8, 0 } }, /* hinohara */
    { .label = { 148404,  5, 0 } }, /* inagi */
    { .label = {  96611,  8, 0 } }, /* itabashi */
    { .label = {  63175, 10, 0 } }, /* katsushika */
    { .label = {  21606,  4, 0 } }, /* kita */
    { .label = { 135461,  6, 0 } }, /* kiyose */
    { .label = { 115484,  7, 0 } }, /* kodaira */
    { .label = { 115512,  7, 0 } }, /* koganei */
    { .label = {  77654,  9, 0 } }, /* kokubunji */
    { .label = { 148424,  5, 0 } }, /* komae */
    { .label = {  93198,  4, 0 } }, /* koto */
    { .label = {  63217, 10, 0 } }, /* kouzushima */
    { .label = {  77698,  9, 0 } }, /* kunitachi */
    { .label = { 115541,  7, 0 } }, /* machida */
    { .label = { 135488,  6, 0 } }, /* meguro */
    { .label = {  49419,  6, 0 } }, /* minato */
    { .label = {  75248,  6, 0 } }, /* mitaka */
    { .label = { 135515,  6, 0 } }, /* mizuho */
    { .label = {  15462, 15, 0 } }, /* musashimurayama */
    { .label = {  77737,  9, 0 } }, /* musashino */
    { .label = {  91176,  6, 0 } }, /* nakano */
    { .label = { 135545,  6, 0 } }, /* nerima */
    { .label = {  77775,  9, 0 } }, /* ogasawara */
    { .label = { 115571,  7, 0 } }, /* okutama */
    { .label = {  12406,  3, 0 } }, /* ome */
    { .label = {  11184,  6, 0 } }, /* oshima */
    { .label = {    214,  3, 0 } }, /* ota */
    { .label = {  96643,  8, 0 } }, /* setagaya */
    { .label = { 115600,  7, 0 } }, /* shibuya */
    { .label = {  77811,  9, 0 } }, /* shinagawa */
    { .label = {  96675,  8, 0 } }, /* shinjuku */
    { .label = {  96714,  8, 0 } }, /* suginami */
    { .label = { 135569,  6, 0 } }, /* sumida */
    { .label = {  77849,  9, 0 } }, /* tachikawa */
    { .label = { 148445,  5, 0 } }, /* taito */
    { .label = {  48734,  4, 0 } }, /* tama */
    { .label = { 115632,  7, 0 } }, /* toshima */

    /* entries 5226 to 5238 */
    { .label = {  76031,  5, 0 } }, /* chizu */
    { .label = {  21530,  4, 0 } }, /* hino */
    { .label = {  96748,  8, 0 } }, /* kawahara */
    { .label = {  36271,  4, 0 } }, /* koge */
    { .label = { 115661,  7, 0 } }, /* kotoura */
    { .label = { 135595,  6, 0 } }, /* misasa */
    { .label = { 148464,  5, 0 } }, /* nanbu */
    { .label = {  94298,  8, 0 } }, /* nichinan */
    { .label = {  49400, 11, 0 } }, /* sakaiminato */
    { .label = { 110465,  7, 0 } }, /* tottori */
    { .label = { 130786,  6, 0 } }, /* wakasa */
    { .label = {  44944,  4, 0 } }, /* yazu */
    { .label = { 135618,  6, 0 } }, /* yonago */

    /* entries 5239 to 5262 */
    { .label = {  61072,  5, 0 } }, /* asahi */
    { .label = { 146405,  5, 0 } }, /* fuchu */
    { .label = {  77888,  9, 0 } }, /* fukumitsu */
    { .label = {  77931,  9, 0 } }, /* funahashi */
    { .label = {  48851,  4, 0 } }, /* himi */
    { .label = {  48856,  5, 0 } }, /* imizu */
    { .label = {  15205,  5, 0 } }, /* inami */
    { .label = { 135644,  6, 0 } }, /* johana */
    { .label = {  96781,  8, 0 } }, /* kamiichi */
    { .label = { 135670,  6, 0 } }, /* kurobe */
    { .label = {  49443, 11, 0 } }, /* nakaniikawa */
    { .label = {  63264, 10, 0 } }, /* namerikawa */
    { .label = {  63763,  5, 0 } }, /* nanto */
    { .label = { 135697,  6, 0 } }, /* nyuzen */
    { .label = { 148485,  5, 0 } }, /* oyabe */
    { .label = { 148507,  5, 0 } }, /* taira */
    { .label = { 115690,  7, 0 } }, /* takaoka */
    { .label = {  90135,  8, 0 } }, /* tateyama */
    { .label = {  29581,  4, 0 } }, /* toga */
    { .label = {  90225,  6, 0 } }, /* tonami */
    { .label = {  93727,  6, 0 } }, /* toyama */
    { .label = { 115717,  7, 0 } }, /* unazuki */
    { .label = { 155862,  4, 0 } }, /* uozu */
    { .label = { 131113,  6, 0 } }, /* yamada */

    /* entries 5263 to 5291 */
    { .label = {  77970,  5, 0 } }, /* arida */
    { .label = {  77970,  9, 0 } }, /* aridagawa */
    { .label = {  25043,  4, 0 } }, /* gobo */
    { .label = {  78007,  9, 0 } }, /* hashimoto */
    { .label = { 131777,  6, 0 } }, /* hidaka */
    { .label = {  96816,  8, 0 } }, /* hirogawa */
    { .label = {  15205,  5, 0 } }, /* inami */
    { .label = { 148525,  5, 0 } }, /* iwade */
    { .label = { 135279,  6, 0 } }, /* kainan */
    { .label = {  78045,  9, 0 } }, /* kamitonda */
    { .label = {  76253,  9, 0 } }, /* katsuragi */
    { .label = { 135727,  6, 0 } }, /* kimino */
    { .label = {  96851,  8, 0 } }, /* kinokawa */
    { .label = {  28965,  8, 0 } }, /* kitayama */
    { .label = { 149477,  4, 0 } }, /* koya */
    { .label = {  96886,  4, 0 } }, /* koza */
    { .label = {  96886,  8, 0 } }, /* kozagawa */
    { .label = {  96923,  8, 0 } }, /* kudoyama */
    { .label = {  78082,  9, 0 } }, /* kushimoto */
    { .label = {  95511,  6, 0 } }, /* mihama */
    { .label = {  21759,  6, 0 } }, /* misato */
    { .label = {  29166, 13, 0 } }, /* nachikatsuura */
    { .label = { 131036,  6, 0 } }, /* shingu */
    { .label = {  78122,  9, 0 } }, /* shirahama */
    { .label = { 148548,  5, 0 } }, /* taiji */
    { .label = {  75493,  6, 0 } }, /* tanabe */
    { .label = {  89518,  8, 0 } }, /* wakayama */
    { .label = { 148570,  5, 0 } }, /* yuasa */
    { .label = { 114847,  4, 0 } }, /* yura */

    /* entries 5292 to 5325 */
    { .label = {  61072,  5, 0 } }, /* asahi */
    { .label = {  96959,  8, 0 } }, /* funagata */
    { .label = {  78158,  9, 0 } }, /* higashine */
    { .label = {  76696,  4, 0 } }, /* iide */
    { .label = { 131794,  6, 0 } }, /* kahoku */
    { .label = {  63306, 10, 0 } }, /* kaminoyama */
    { .label = {  90646,  8, 0 } }, /* kaneyama */
    { .label = {  74905,  9, 0 } }, /* kawanishi */
    { .label = {  63348, 10, 0 } }, /* mamurogawa */
    { .label = {  91761,  6, 0 } }, /* mikawa */
    { .label = {  15428,  8, 0 } }, /* murayama */
    { .label = { 148591,  5, 0 } }, /* nagai */
    { .label = {  96992,  8, 0 } }, /* nakayama */
    { .label = { 148610,  5, 0 } }, /* nanyo */
    { .label = {  78196,  9, 0 } }, /* nishikawa */
    { .label = {  78235,  9, 0 } }, /* obanazawa */
    { .label = {    100,  2, 0 } }, /* oe */
    { .label = {  48951,  5, 0 } }, /* oguni */
    { .label = { 135753,  6, 0 } }, /* ohkura */
    { .label = { 115750,  7, 0 } }, /* oishida */
    { .label = { 148631,  5, 0 } }, /* sagae */
    { .label = { 135779,  6, 0 } }, /* sakata */
    { .label = {  97024,  8, 0 } }, /* sakegawa */
    { .label = { 133927,  6, 0 } }, /* shinjo */
    { .label = {  78274,  9, 0 } }, /* shirataka */
    { .label = { 131063,  6, 0 } }, /* shonai */
    { .label = {  97058,  8, 0 } }, /* takahata */
    { .label = { 148650,  5, 0 } }, /* tendo */
    { .label = { 135801,  6, 0 } }, /* tozawa */
    { .label = {  97088,  8, 0 } }, /* tsuruoka */
    { .label = {  89553,  8, 0 } }, /* yamagata */
    { .label = {  97122,  8, 0 } }, /* yamanobe */
    { .label = {  97156,  8, 0 } }, /* yonezawa */
    { .label = { 134109,  4, 0 } }, /* yuza */

    /* entries 5326 to 5341 */
    { .label = {  10240,  3, 0 } }, /* abu */
    { .label = {  59199,  4, 0 } }, /* hagi */
    { .label = {  15113,  6, 0 } }, /* hikari */
    { .label = { 148362,  4, 0 } }, /* hofu */
    { .label = { 115779,  7, 0 } }, /* iwakuni */
    { .label = {  78309,  9, 0 } }, /* kudamatsu */
    { .label = { 148671,  5, 0 } }, /* mitou */
    { .label = {  95962,  6, 0 } }, /* nagato */
    { .label = {  11184,  6, 0 } }, /* oshima */
    { .label = {  49488, 11, 0 } }, /* shimonoseki */
    { .label = { 135829,  6, 0 } }, /* shunan */
    { .label = { 135854,  6, 0 } }, /* tabuse */
    { .label = {  97194,  8, 0 } }, /* tokuyama */
    { .label = { 129978,  6, 0 } }, /* toyota */
    { .label = {  19174,  3, 0 } }, /* ube */
    { .label = { 158543,  3, 0 } }, /* yuu */

    /* entries 5342 to 5369 */
    { .label = {  48094,  4, 0 } }, /* chuo */
    { .label = { 148693,  5, 0 } }, /* doshi */
    { .label = { 115811,  7, 0 } }, /* fuefuki */
    { .label = {  15526,  8, 0 } }, /* fujikawa */
    { .label = {  15526, 15, 0 } }, /* fujikawaguchiko */
    { .label = {  49535, 11, 0 } }, /* fujiyoshida */
    { .label = {  97229,  8, 0 } }, /* hayakawa */
    { .label = { 131802,  6, 0 } }, /* hokuto */
    { .label = {  21723, 14, 0 } }, /* ichikawamisato */
    { .label = {  13388,  3, 0 } }, /* kai */
    { .label = { 118661,  4, 0 } }, /* kofu */
    { .label = { 148715,  5, 0 } }, /* koshu */
    { .label = { 135879,  6, 0 } }, /* kosuge */
    { .label = {  49588, 11, 0 } }, /* minami-alps */
    { .label = { 135906,  6, 0 } }, /* minobu */
    { .label = {  78348,  9, 0 } }, /* nakamichi */
    { .label = { 148464,  5, 0 } }, /* nanbu */
    { .label = {  97264,  8, 0 } }, /* narusawa */
    { .label = {  97297,  8, 0 } }, /* nirasaki */
    { .label = {  37502, 12, 0 } }, /* nishikatsura */
    { .label = {  21522,  6, 0 } }, /* oshino */
    { .label = { 132746,  6, 0 } }, /* otsuki */
    { .label = { 146256,  5, 0 } }, /* showa */
    { .label = {  97328,  8, 0 } }, /* tabayama */
    { .label = {  37247,  5, 0 } }, /* tsuru */
    { .label = {  97360,  8, 0 } }, /* uenohara */
    { .label = {  63392, 10, 0 } }, /* yamanakako */
    { .label = {  72908,  9, 0 } }, /* yamanashi */

    /* entries 5370 to 5372 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 104733,  4, 1 } }, { .child = { 5373, 1 } }, /* city */

    /* entry 5373 */
    { .label = {     12,  1, 0 } }, /* ! */

    /* entries 5374 to 5376 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 104733,  4, 1 } }, { .child = { 5377, 1 } }, /* city */

    /* entry 5377 */
    { .label = {     12,  1, 0 } }, /* ! */

    /* entries 5378 to 5380 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 104733,  4, 1 } }, { .child = { 5381, 1 } }, /* city */

    /* entry 5381 */
    { .label = {     12,  1, 0 } }, /* ! */

    /* entries 5382 to 5384 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 104733,  4, 1 } }, { .child = { 5385, 1 } }, /* city */

    /* entry 5385 */
    { .label = {     12,  1, 0 } }, /* ! */

    /* entries 5386 to 5388 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 104733,  4, 1 } }, { .child = { 5389, 1 } }, /* city */

    /* entry 5389 */
    { .label = {     12,  1, 0 } }, /* ! */

    /* entries 5390 to 5392 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 104733,  4, 1 } }, { .child = { 5393, 1 } }, /* city */

    /* entry 5393 */
    { .label = {     12,  1, 0 } }, /* ! */

    /* entries 5394 to 5396 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = { 104733,  4, 1 } }, { .child = { 5397, 1 } }, /* city */

    /* entry 5397 */
    { .label = {     12,  1, 0 } }, /* ! */

    /* entries 5398 to 5400 */
    { .label = {      0,  1, 0 } }, /* * */
    { .label = {     44,  2, 1 } }, { .child = { 5401, 1 } }, /* co */

    /* entry 5401 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 5402 to 5407 */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */

    /* entry 5408 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 5409 to 5415 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {    108,  3, 0 } }, /* com */

    /* entries 5416 to 5432 */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  25887,  3, 0 } }, /* prd */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {   1406,  3, 0 } }, /* ass */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 155301,  4, 0 } }, /* coop */
    { .label = {   1443,  4, 0 } }, /* asso */
    { .label = { 128744,  6, 0 } }, /* presse */
    { .label = { 108989,  7, 0 } }, /* medecin */
    { .label = {  88598,  8, 0 } }, /* notaires */
    { .label = {  49636, 11, 0 } }, /* pharmaciens */
    { .label = {  45516, 11, 0 } }, /* veterinaire */
    { .label = { 155281,  4, 0 } }, /* gouv */

    /* entries 5433 to 5436 */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entries 5437 to 5442 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  19982,  3, 0 } }, /* rep */
    { .label = {   1647,  3, 0 } }, /* tra */

    /* entries 5443 to 5472 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    143,  2, 0 } }, /* es */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {     68,  2, 0 } }, /* hs */
    { .label = {   1841,  2, 0 } }, /* kg */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {    352,  2, 0 } }, /* ms */
    { .label = {    203,  2, 0 } }, /* ne */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {   1882,  2, 0 } }, /* pe */
    { .label = {     57,  2, 0 } }, /* re */
    { .label = {   3965,  2, 0 } }, /* sc */
    { .label = { 148738,  5, 0 } }, /* busan */
    { .label = {  97392,  8, 0 } }, /* chungbuk */
    { .label = {  97431,  8, 0 } }, /* chungnam */
    { .label = { 148759,  5, 0 } }, /* daegu */
    { .label = { 115846,  7, 0 } }, /* daejeon */
    { .label = { 115877,  7, 0 } }, /* gangwon */
    { .label = { 115909,  7, 0 } }, /* gwangju */
    { .label = {  78386,  9, 0 } }, /* gyeongbuk */
    { .label = {  97467,  8, 0 } }, /* gyeonggi */
    { .label = {  78429,  9, 0 } }, /* gyeongnam */
    { .label = { 115945,  7, 0 } }, /* incheon */
    { .label = { 155883,  4, 0 } }, /* jeju */
    { .label = { 115975,  7, 0 } }, /* jeonbuk */
    { .label = { 116009,  7, 0 } }, /* jeonnam */
    { .label = { 148781,  5, 0 } }, /* seoul */
    { .label = { 148803,  5, 0 } }, /* ulsan */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entry 5473 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 5474 to 5478 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */

    /* entries 5479 to 5484 */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {    108,  3, 0 } }, /* com */

    /* entries 5485 to 5494 */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   3378,  3, 0 } }, /* per */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  18634,  3, 0 } }, /* bnr */
    { .label = {     44,  1, 0 } }, /* c */

    /* entries 5495 to 5499 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 5500 to 5506 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   1127,  2, 0 } }, /* oy */

    /* entry 5507 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 5508 to 5522 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   4209,  3, 0 } }, /* sch */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7233,  3, 0 } }, /* ngo */
    { .label = {   1450,  3, 0 } }, /* soc */
    { .label = {  26804,  3, 0 } }, /* web */
    { .label = {   5935,  3, 0 } }, /* ltd */
    { .label = { 121745,  4, 0 } }, /* assn */
    { .label = {  71061,  3, 0 } }, /* grp */
    { .label = {  54179,  5, 0 } }, /* hotel */
    { .label = {    189,  2, 0 } }, /* ac */

    /* entries 5523 to 5527 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */

    /* entries 5528 to 5529 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 5530 to 5531 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entry 5532 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 5533 to 5541 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {     88,  2, 0 } }, /* id */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   3005,  3, 0 } }, /* asn */
    { .label = {  58187,  4, 0 } }, /* conf */

    /* entries 5542 to 5550 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 158527,  3, 0 } }, /* plc */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   4209,  3, 0 } }, /* sch */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {     88,  2, 0 } }, /* id */

    /* entries 5551 to 5556 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {  18801,  5, 0 } }, /* press */

    /* entries 5557 to 5558 */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = {   1443,  4, 0 } }, /* asso */

    /* entry 5559 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 5560 to 5580 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  18896,  3, 0 } }, /* its */
    { .label = {    665,  4, 0 } }, /* priv */
    { .label = { 144172,  6, 0 } }, /* daplie */
    { .label = { 107970,  8, 0 } }, /* brasilia */
    { .label = { 108121,  4, 0 } }, /* ddns */
    { .label = { 126169,  6, 0 } }, /* dnsfor */
    { .label = { 154909,  5, 0 } }, /* hopto */
    { .label = { 128385,  7, 0 } }, /* loginto */
    { .label = { 158290,  4, 0 } }, /* noip */
    { .label = { 144366,  6, 0 } }, /* webhop */
    { .label = {  58879, 11, 0 } }, /* diskstation */
    { .label = { 128512,  7, 0 } }, /* dscloud */
    { .label = { 158324,  4, 0 } }, /* i234 */
    { .label = { 158355,  4, 0 } }, /* myds */
    { .label = { 108524,  8, 0 } }, /* synology */

    /* entries 5581 to 5589 */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  25887,  3, 0 } }, /* prd */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {     44,  2, 0 } }, /* co */

    /* entries 5590 to 5597 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 105545,  3, 0 } }, /* inf */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 5598 to 5604 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = { 155281,  4, 0 } }, /* gouv */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 128744,  6, 0 } }, /* presse */

    /* entry 5605 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 5606 to 5609 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 106228,  3, 0 } }, /* nyc */

    /* entries 5610 to 5614 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entry 5615 */
    { .label = { 128512,  7, 0 } }, /* dscloud */

    /* entries 5616 to 5617 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 5618 to 5622 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 5623 to 5627 */
    { .label = {    108,  3, 1 } }, { .child = { 5628, 1 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entry 5628 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 5629 to 5635 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {     49,  2, 0 } }, /* or */

    /* entries 5636 to 6183 */
    { .label = { 116040,  7, 0 } }, /* academy */
    { .label = {  49683, 11, 0 } }, /* agriculture */
    { .label = {   1150,  3, 0 } }, /* air */
    { .label = {  97504,  8, 0 } }, /* airguard */
    { .label = { 116071,  7, 0 } }, /* alabama */
    { .label = { 135933,  6, 0 } }, /* alaska */
    { .label = { 148824,  5, 0 } }, /* amber */
    { .label = {  72073,  9, 0 } }, /* ambulance */
    { .label = {  11348,  8, 0 } }, /* american */
    { .label = {  11348,  9, 0 } }, /* americana */
    { .label = {  11348, 16, 0 } }, /* americanantiques */
    { .label = {  49731, 11, 0 } }, /* americanart */
    { .label = {  78469,  9, 0 } }, /* amsterdam */
    { .label = {    353,  3, 0 } }, /* and */
    { .label = {  78506,  9, 0 } }, /* annefrank */
    { .label = {  37551,  6, 0 } }, /* anthro */
    { .label = {  37551, 12, 0 } }, /* anthropology */
    { .label = {  11380,  8, 0 } }, /* antiques */
    { .label = {  97537,  8, 0 } }, /* aquarium */
    { .label = {  78543,  9, 0 } }, /* arboretum */
    { .label = {  21783, 14, 0 } }, /* archaeological */
    { .label = {  49774, 11, 0 } }, /* archaeology */
    { .label = {  37605, 12, 0 } }, /* architecture */
    { .label = {   7810,  3, 0 } }, /* art */
    { .label = {  37656, 12, 0 } }, /* artanddesign */
    { .label = {  78581,  9, 0 } }, /* artcenter */
    { .label = { 116098,  7, 0 } }, /* artdeco */
    { .label = {  37705, 12, 0 } }, /* arteducation */
    { .label = {  63433, 10, 0 } }, /* artgallery */
    { .label = {  11884,  4, 0 } }, /* arts */
    { .label = {  29220, 13, 0 } }, /* artsandcrafts */
    { .label = {  97574,  8, 0 } }, /* asmatart */
    { .label = {  29273, 13, 0 } }, /* assassination */
    { .label = { 135956,  6, 0 } }, /* assisi */
    { .label = {   1443, 11, 0 } }, /* association */
    { .label = {  78617,  9, 0 } }, /* astronomy */
    { .label = { 116127,  7, 0 } }, /* atlanta */
    { .label = { 135979,  6, 0 } }, /* austin */
    { .label = {  78655,  9, 0 } }, /* australia */
    { .label = {  63476, 10, 0 } }, /* automotive */
    { .label = {  27232,  8, 0 } }, /* aviation */
    { .label = { 155906,  4, 0 } }, /* axis */
    { .label = { 116153,  7, 0 } }, /* badajoz */
    { .label = { 116187,  7, 0 } }, /* baghdad */
    { .label = {  52600,  4, 0 } }, /* bahn */
    { .label = {  65492,  4, 0 } }, /* bale */
    { .label = {  78690,  9, 0 } }, /* baltimore */
    { .label = {  78728,  9, 0 } }, /* barcelona */
    { .label = {  97604,  8, 0 } }, /* baseball */
    { .label = { 148845,  5, 0 } }, /* basel */
    { .label = { 148866,  5, 0 } }, /* baths */
    { .label = { 136003,  6, 0 } }, /* bauern */
    { .label = {  78765,  9, 0 } }, /* beauxarts */
    { .label = {  29322, 13, 0 } }, /* beeldengeluid */
    { .label = {  97638,  8, 0 } }, /* bellevue */
    { .label = { 116218,  7, 0 } }, /* bergbau */
    { .label = {  97676,  8, 0 } }, /* berkeley */
    { .label = { 136028,  6, 0 } }, /* berlin */
    { .label = {  78804,  4, 0 } }, /* bern */
    { .label = { 148887,  5, 0 } }, /* bible */
    { .label = { 136054,  6, 0 } }, /* bilbao */
    { .label = { 118561,  4, 0 } }, /* bill */
    { .label = { 116249,  7, 0 } }, /* birdart */
    { .label = {  63519, 10, 0 } }, /* birthplace */
    { .label = { 155923,  4, 0 } }, /* bonn */
    { .label = { 136080,  6, 0 } }, /* boston */
    { .label = {  15599,  9, 0 } }, /* botanical */
    { .label = {  15599, 15, 0 } }, /* botanicalgarden */
    { .label = {  29381, 13, 0 } }, /* botanicgarden */
    { .label = { 136105,  6, 0 } }, /* botany */
    { .label = {  11416, 16, 0 } }, /* brandywinevalley */
    { .label = { 107970,  6, 0 } }, /* brasil */
    { .label = { 116278,  7, 0 } }, /* bristol */
    { .label = {  15661,  7, 0 } }, /* british */
    { .label = {  15661, 15, 0 } }, /* britishcolumbia */
    { .label = {  78803,  9, 0 } }, /* broadcast */
    { .label = { 136131,  6, 0 } }, /* brunel */
    { .label = {  97713,  7, 0 } }, /* brussel */
    { .label = {  97713,  8, 0 } }, /* brussels */
    { .label = {  78840,  9, 0 } }, /* bruxelles */
    { .label = {  97748,  8, 0 } }, /* building */
    { .label = { 116308,  7, 0 } }, /* burghof */
    { .label = {  10243,  3, 0 } }, /* bus */
    { .label = { 136158,  6, 0 } }, /* bushey */
    { .label = {  97785,  8, 0 } }, /* cadaques */
    { .label = {  63564, 10, 0 } }, /* california */
    { .label = {  78882,  9, 0 } }, /* cambridge */
    { .label = {  10218,  3, 0 } }, /* can */
    { .label = { 136187,  6, 0 } }, /* canada */
    { .label = {  63606, 10, 0 } }, /* capebreton */
    { .label = { 116342,  7, 0 } }, /* carrier */
    { .label = {  63649, 10, 0 } }, /* cartoonart */
    { .label = {  21842, 14, 0 } }, /* casadelamoneda */
    { .label = { 136210,  6, 0 } }, /* castle */
    { .label = { 116370,  7, 0 } }, /* castres */
    { .label = {  19786,  6, 0 } }, /* celtic */
    { .label = {  22055,  6, 0 } }, /* center */
    { .label = {  49822, 11, 0 } }, /* chattanooga */
    { .label = {  63688, 10, 0 } }, /* cheltenham */
    { .label = {  29435, 13, 0 } }, /* chesapeakebay */
    { .label = { 116398,  7, 0 } }, /* chicago */
    { .label = {  15727,  8, 0 } }, /* children */
    { .label = {  15727,  9, 0 } }, /* childrens */
    { .label = {  15727, 15, 0 } }, /* childrensgarden */
    { .label = {  37754, 12, 0 } }, /* chiropractic */
    { .label = {  78922,  9, 0 } }, /* chocolate */
    { .label = {  21899, 14, 0 } }, /* christiansburg */
    { .label = {  63732, 10, 0 } }, /* cincinnati */
    { .label = { 136235,  6, 0 } }, /* cinema */
    { .label = { 136260,  6, 0 } }, /* circus */
    { .label = {  37807, 12, 0 } }, /* civilisation */
    { .label = {  37858, 12, 0 } }, /* civilization */
    { .label = {  97822,  8, 0 } }, /* civilwar */
    { .label = { 116429,  7, 0 } }, /* clinton */
    { .label = {  16498,  5, 0 } }, /* clock */
    { .label = { 155940,  4, 0 } }, /* coal */
    { .label = {  21959, 14, 0 } }, /* coastaldefence */
    { .label = { 155957,  4, 0 } }, /* cody */
    { .label = { 116459,  7, 0 } }, /* coldwar */
    { .label = {  63773, 10, 0 } }, /* collection */
    { .label = {   2672, 20, 0 } }, /* colonialwilliamsburg */
    { .label = {  15792, 15, 0 } }, /* coloradoplateau */
    { .label = {  15691,  8, 0 } }, /* columbia */
    { .label = {  97860,  8, 0 } }, /* columbus */
    { .label = {    387, 13, 0 } }, /* communication */
    { .label = {    387, 14, 0 } }, /* communications */
    { .label = {  78961,  9, 0 } }, /* community */
    { .label = {  15856,  8, 0 } }, /* computer */
    { .label = {  15856, 15, 0 } }, /* computerhistory */
    { .label = {   2762, 20, 0 } }, /* xn--comunicaes-v6a2o */
    { .label = {  15924, 12, 0 } }, /* contemporary */
    { .label = {  15924, 15, 0 } }, /* contemporaryart */
    { .label = { 116492,  7, 0 } }, /* convent */
    { .label = {  63817, 10, 0 } }, /* copenhagen */
    { .label = {  49866, 11, 0 } }, /* corporation */
    { .label = {     24, 36, 0 } }, /* xn--correios-e-telecomunicaes-ghc29a */
    { .label = {  97898,  8, 0 } }, /* corvette */
    { .label = { 116523,  7, 0 } }, /* costume */
    { .label = {  16329, 13, 0 } }, /* countryestate */
    { .label = { 136287,  6, 0 } }, /* county */
    { .label = {  29247,  6, 0 } }, /* crafts */
    { .label = {  79003,  9, 0 } }, /* cranbrook */
    { .label = {  59364,  8, 0 } }, /* creation */
    { .label = {  22019,  8, 0 } }, /* cultural */
    { .label = {  22019, 14, 0 } }, /* culturalcenter */
    { .label = {  49699,  7, 0 } }, /* culture */
    { .label = { 148910,  5, 0 } }, /* cyber */
    { .label = { 148934,  5, 0 } }, /* cymru */
    { .label = {  38571,  4, 0 } }, /* dali */
    { .label = { 136315,  6, 0 } }, /* dallas */
    { .label = {  97933,  8, 0 } }, /* database */
    { .label = {   9568,  3, 0 } }, /* ddr */
    { .label = {  11841, 14, 0 } }, /* decorativearts */
    { .label = {  16285,  8, 0 } }, /* delaware */
    { .label = {  49912, 11, 0 } }, /* delmenhorst */
    { .label = { 116554,  7, 0 } }, /* denmark */
    { .label = {  85580,  5, 0 } }, /* depot */
    { .label = {  22237,  6, 0 } }, /* design */
    { .label = { 116584,  7, 0 } }, /* detroit */
    { .label = {  97964,  8, 0 } }, /* dinosaur */
    { .label = {  79041,  9, 0 } }, /* discovery */
    { .label = { 148959,  5, 0 } }, /* dolls */
    { .label = {  97997,  8, 0 } }, /* donostia */
    { .label = { 136340,  6, 0 } }, /* durham */
    { .label = {  63861, 10, 0 } }, /* eastafrica */
    { .label = {  79083,  9, 0 } }, /* eastcoast */
    { .label = {  37716,  9, 0 } }, /* education */
    { .label = {  49960, 11, 0 } }, /* educational */
    { .label = {  98029,  8, 0 } }, /* egyptian */
    { .label = {  79118,  9, 0 } }, /* eisenbahn */
    { .label = { 136367,  6, 0 } }, /* elburg */
    { .label = {  63901, 10, 0 } }, /* elvendrell */
    { .label = {  63947, 10, 0 } }, /* embroidery */
    { .label = {  37912, 12, 0 } }, /* encyclopedic */
    { .label = { 116613,  7, 0 } }, /* england */
    { .label = {  63992, 10, 0 } }, /* entomology */
    { .label = {    447, 11, 0 } }, /* environment */
    { .label = {    447, 25, 0 } }, /* environmentalconservation */
    { .label = {  98065,  8, 0 } }, /* epilepsy */
    { .label = { 148982,  5, 0 } }, /* essex */
    { .label = {  16361,  6, 0 } }, /* estate */
    { .label = {  79155,  9, 0 } }, /* ethnology */
    { .label = { 136395,  6, 0 } }, /* exeter */
    { .label = {  64037, 10, 0 } }, /* exhibition */
    { .label = {  24822,  6, 0 } }, /* family */
    { .label = {  29492,  4, 0 } }, /* farm */
    { .label = {  29492, 13, 0 } }, /* farmequipment */
    { .label = { 116643,  7, 0 } }, /* farmers */
    { .label = {  79196,  9, 0 } }, /* farmstead */
    { .label = { 149004,  5, 0 } }, /* field */
    { .label = {  98104,  8, 0 } }, /* figueres */
    { .label = {  79234,  9, 0 } }, /* filatelia */
    { .label = {  78146,  4, 0 } }, /* film */
    { .label = {  98140,  7, 0 } }, /* fineart */
    { .label = {  98140,  8, 0 } }, /* finearts */
    { .label = { 116673,  7, 0 } }, /* finland */
    { .label = {  98173,  8, 0 } }, /* flanders */
    { .label = { 116704,  7, 0 } }, /* florida */
    { .label = { 104185,  5, 0 } }, /* force */
    { .label = {  37969, 12, 0 } }, /* fortmissoula */
    { .label = {  79272,  9, 0 } }, /* fortworth */
    { .label = {  64081, 10, 0 } }, /* foundation */
    { .label = {  79314,  9, 0 } }, /* francaise */
    { .label = {  79351,  9, 0 } }, /* frankfurt */
    { .label = {  38021, 12, 0 } }, /* franziskaner */
    { .label = {  50006, 11, 0 } }, /* freemasonry */
    { .label = {  98208,  8, 0 } }, /* freiburg */
    { .label = {  98245,  8, 0 } }, /* fribourg */
    { .label = { 123597,  4, 0 } }, /* frog */
    { .label = {  98282,  8, 0 } }, /* fundacio */
    { .label = {  79392,  9, 0 } }, /* furniture */
    { .label = {  63444,  7, 0 } }, /* gallery */
    { .label = {  15636,  6, 0 } }, /* garden */
    { .label = {  14098,  7, 0 } }, /* gateway */
    { .label = {  79432,  9, 0 } }, /* geelvinck */
    { .label = {  50054, 11, 0 } }, /* gemological */
    { .label = { 116735,  7, 0 } }, /* geology */
    { .label = { 116768,  7, 0 } }, /* georgia */
    { .label = { 116797,  7, 0 } }, /* giessen */
    { .label = { 149028,  4, 0 } }, /* glas */
    { .label = { 149028,  5, 0 } }, /* glass */
    { .label = { 149049,  5, 0 } }, /* gorge */
    { .label = {  50103, 11, 0 } }, /* grandrapids */
    { .label = { 155977,  4, 0 } }, /* graz */
    { .label = {  98318,  8, 0 } }, /* guernsey */
    { .label = {  64124, 10, 0 } }, /* halloffame */
    { .label = { 116826,  7, 0 } }, /* hamburg */
    { .label = { 116858,  7, 0 } }, /* handson */
    { .label = {   5929, 18, 0 } }, /* harvestcelebration */
    { .label = { 136421,  6, 0 } }, /* hawaii */
    { .label = {    707,  6, 0 } }, /* health */
    { .label = {  22080, 14, 0 } }, /* heimatunduhren */
    { .label = { 136447,  6, 0 } }, /* hellas */
    { .label = {  98354,  8, 0 } }, /* helsinki */
    { .label = {  15988, 15, 0 } }, /* hembygdsforbund */
    { .label = {  11730,  8, 0 } }, /* heritage */
    { .label = {  98389,  8, 0 } }, /* histoire */
    { .label = {   8028, 10, 0 } }, /* historical */
    { .label = {   8028, 17, 0 } }, /* historicalsociety */
    { .label = {  22141, 14, 0 } }, /* historichouses */
    { .label = {   4180, 10, 0 } }, /* historisch */
    { .label = {   4180, 12, 0 } }, /* historisches */
    { .label = {   2891,  7, 0 } }, /* history */
    { .label = {  11491, 16, 0 } }, /* historyofscience */
    { .label = {  98422,  8, 0 } }, /* horology */
    { .label = {  22175,  5, 0 } }, /* house */
    { .label = {  64170, 10, 0 } }, /* humanities */
    { .label = {  38073, 12, 0 } }, /* illustration */
    { .label = {  29554, 13, 0 } }, /* imageandsound */
    { .label = {  38123,  6, 0 } }, /* indian */
    { .label = {  38123,  7, 0 } }, /* indiana */
    { .label = {  38123, 12, 0 } }, /* indianapolis */
    { .label = {  38173, 12, 0 } }, /* indianmarket */
    { .label = {  38222, 12, 0 } }, /* intelligence */
    { .label = {  50150, 11, 0 } }, /* interactive */
    { .label = { 155996,  4, 0 } }, /* iraq */
    { .label = {    461,  4, 0 } }, /* iron */
    { .label = {  79474,  9, 0 } }, /* isleofman */
    { .label = { 116887,  7, 0 } }, /* jamison */
    { .label = {  79513,  9, 0 } }, /* jefferson */
    { .label = {  79556,  9, 0 } }, /* jerusalem */
    { .label = { 116918,  7, 0 } }, /* jewelry */
    { .label = {  79597,  6, 0 } }, /* jewish */
    { .label = {  79597,  9, 0 } }, /* jewishart */
    { .label = { 158559,  3, 0 } }, /* jfk */
    { .label = {  64212, 10, 0 } }, /* journalism */
    { .label = { 116955,  7, 0 } }, /* judaica */
    { .label = {  50196, 11, 0 } }, /* judygarland */
    { .label = {  64257, 10, 0 } }, /* juedisches */
    { .label = { 156015,  4, 0 } }, /* juif */
    { .label = { 136473,  6, 0 } }, /* karate */
    { .label = {  79639,  9, 0 } }, /* karikatur */
    { .label = {  50132,  4, 0 } }, /* kids */
    { .label = {  64304, 10, 0 } }, /* koebenhavn */
    { .label = { 149071,  5, 0 } }, /* koeln */
    { .label = {  22201,  5, 0 } }, /* kunst */
    { .label = {  29609, 13, 0 } }, /* kunstsammlung */
    { .label = {  22201, 14, 0 } }, /* kunstunddesign */
    { .label = { 149093,  5, 0 } }, /* labor */
    { .label = { 136496,  6, 0 } }, /* labour */
    { .label = { 116987,  7, 0 } }, /* lajolla */
    { .label = {  64348, 10, 0 } }, /* lancashire */
    { .label = { 136522,  6, 0 } }, /* landes */
    { .label = {  83137,  4, 0 } }, /* lans */
    { .label = {  50248, 11, 0 } }, /* xn--lns-qla */
    { .label = { 117019,  7, 0 } }, /* larsson */
    { .label = {  50302, 11, 0 } }, /* lewismiller */
    { .label = { 117047,  7, 0 } }, /* lincoln */
    { .label = { 108427,  4, 0 } }, /* linz */
    { .label = {  16393,  6, 0 } }, /* living */
    { .label = {  16393, 13, 0 } }, /* livinghistory */
    { .label = {  38274, 12, 0 } }, /* localhistory */
    { .label = { 136547,  6, 0 } }, /* london */
    { .label = {  64389, 10, 0 } }, /* losangeles */
    { .label = { 136573,  6, 0 } }, /* louvre */
    { .label = {  98459,  8, 0 } }, /* loyalist */
    { .label = { 117078,  7, 0 } }, /* lucerne */
    { .label = {  64431, 10, 0 } }, /* luxembourg */
    { .label = { 136601,  6, 0 } }, /* luzern */
    { .label = {  19918,  3, 0 } }, /* mad */
    { .label = { 136630,  6, 0 } }, /* madrid */
    { .label = {  98494,  8, 0 } }, /* mallorca */
    { .label = {  64479, 10, 0 } }, /* manchester */
    { .label = {  98528,  7, 0 } }, /* mansion */
    { .label = {  98528,  8, 0 } }, /* mansions */
    { .label = { 156037,  4, 0 } }, /* manx */
    { .label = { 117109,  7, 0 } }, /* marburg */
    { .label = {  98560,  8, 0 } }, /* maritime */
    { .label = {  98593,  8, 0 } }, /* maritimo */
    { .label = {  98626,  8, 0 } }, /* maryland */
    { .label = {  64521, 10, 0 } }, /* marylhurst */
    { .label = {  87923,  5, 0 } }, /* media */
    { .label = { 117140,  7, 0 } }, /* medical */
    { .label = {   4147, 19, 0 } }, /* medizinhistorisches */
    { .label = { 136656,  6, 0 } }, /* meeres */
    { .label = {  98661,  8, 0 } }, /* memorial */
    { .label = {  79676,  9, 0 } }, /* mesaverde */
    { .label = {  98695,  8, 0 } }, /* michigan */
    { .label = {  50353, 11, 0 } }, /* midatlantic */
    { .label = {  98730,  8, 0 } }, /* military */
    { .label = {  50326,  4, 0 } }, /* mill */
    { .label = { 136681,  6, 0 } }, /* miners */
    { .label = { 136706,  6, 0 } }, /* mining */
    { .label = {  79715,  9, 0 } }, /* minnesota */
    { .label = { 117171,  7, 0 } }, /* missile */
    { .label = {  37987,  8, 0 } }, /* missoula */
    { .label = { 136732,  6, 0 } }, /* modern */
    { .label = {  98617,  4, 0 } }, /* moma */
    { .label = { 149114,  5, 0 } }, /* money */
    { .label = {  98765,  8, 0 } }, /* monmouth */
    { .label = {  64566, 10, 0 } }, /* monticello */
    { .label = {  98801,  8, 0 } }, /* montreal */
    { .label = { 136758,  6, 0 } }, /* moscow */
    { .label = {  54253, 10, 0 } }, /* motorcycle */
    { .label = {  98834,  8, 0 } }, /* muenchen */
    { .label = {  98870,  8, 0 } }, /* muenster */
    { .label = {  98904,  8, 0 } }, /* mulhouse */
    { .label = { 136787,  6, 0 } }, /* muncie */
    { .label = { 136814,  6, 0 } }, /* museet */
    { .label = {  38327, 12, 0 } }, /* museumcenter */
    { .label = {  11562, 16, 0 } }, /* museumvereniging */
    { .label = {  34012,  5, 0 } }, /* music */
    { .label = {  11634,  8, 0 } }, /* national */
    { .label = {  11634, 16, 0 } }, /* nationalfirearms */
    { .label = {  11699, 16, 0 } }, /* nationalheritage */
    { .label = {  22263, 14, 0 } }, /* nativeamerican */
    { .label = {   2863, 14, 0 } }, /* naturalhistory */
    { .label = {   2863, 20, 0 } }, /* naturalhistorymuseum */
    { .label = {  16060, 15, 0 } }, /* naturalsciences */
    { .label = {   6117,  6, 0 } }, /* nature */
    { .label = {   8101, 17, 0 } }, /* naturhistorisches */
    { .label = {   4231, 19, 0 } }, /* natuurwetenschappen */
    { .label = {  98941,  8, 0 } }, /* naumburg */
    { .label = { 149137,  5, 0 } }, /* naval */
    { .label = {  98977,  8, 0 } }, /* nebraska */
    { .label = { 149158,  5, 0 } }, /* neues */
    { .label = {  38380, 12, 0 } }, /* newhampshire */
    { .label = {  79751,  9, 0 } }, /* newjersey */
    { .label = {  79795,  9, 0 } }, /* newmexico */
    { .label = { 117201,  7, 0 } }, /* newport */
    { .label = {  79838,  9, 0 } }, /* newspaper */
    { .label = { 117234,  7, 0 } }, /* newyork */
    { .label = { 136840,  6, 0 } }, /* niepce */
    { .label = { 117268,  7, 0 } }, /* norfolk */
    { .label = {   7053,  5, 0 } }, /* north */
    { .label = {  16399,  3, 0 } }, /* nrw */
    { .label = {  79880,  9, 0 } }, /* nuernberg */
    { .label = {  79919,  9, 0 } }, /* nuremberg */
    { .label = { 106228,  3, 0 } }, /* nyc */
    { .label = { 156055,  4, 0 } }, /* nyny */
    { .label = {  29667, 13, 0 } }, /* oceanographic */
    { .label = {  16122, 15, 0 } }, /* oceanographique */
    { .label = { 149179,  5, 0 } }, /* omaha */
    { .label = { 136867,  6, 0 } }, /* online */
    { .label = { 117300,  7, 0 } }, /* ontario */
    { .label = { 117327,  7, 0 } }, /* openair */
    { .label = {  50399,  6, 0 } }, /* oregon */
    { .label = {  50399, 11, 0 } }, /* oregontrail */
    { .label = { 149199,  5, 0 } }, /* otago */
    { .label = { 136892,  6, 0 } }, /* oxford */
    { .label = { 117356,  7, 0 } }, /* pacific */
    { .label = {  79959,  9, 0 } }, /* paderborn */
    { .label = { 136921,  6, 0 } }, /* palace */
    { .label = { 149219,  5, 0 } }, /* paleo */
    { .label = {  50444, 11, 0 } }, /* palmsprings */
    { .label = { 136947,  6, 0 } }, /* panama */
    { .label = {  39028,  5, 0 } }, /* paris */
    { .label = {  99009,  8, 0 } }, /* pasadena */
    { .label = {  99041,  8, 0 } }, /* pharmacy */
    { .label = {  11763, 12, 0 } }, /* philadelphia */
    { .label = {  11763, 16, 0 } }, /* philadelphiaarea */
    { .label = {  79998,  9, 0 } }, /* philately */
    { .label = { 117389,  7, 0 } }, /* phoenix */
    { .label = {  50494, 11, 0 } }, /* photography */
    { .label = { 136971,  6, 0 } }, /* pilots */
    { .label = {  64610, 10, 0 } }, /* pittsburgh */
    { .label = {  50546, 11, 0 } }, /* planetarium */
    { .label = {  64656, 10, 0 } }, /* plantation */
    { .label = { 136998,  6, 0 } }, /* plants */
    { .label = { 149241,  5, 0 } }, /* plaza */
    { .label = { 137024,  6, 0 } }, /* portal */
    { .label = {  99078,  8, 0 } }, /* portland */
    { .label = {  64697, 10, 0 } }, /* portlligat */
    { .label = {    326, 28, 0 } }, /* posts-and-telecommunications */
    { .label = {  38435, 12, 0 } }, /* preservation */
    { .label = {  99113,  8, 0 } }, /* presidio */
    { .label = {  18801,  5, 0 } }, /* press */
    { .label = { 117422,  7, 0 } }, /* project */
    { .label = {  19990,  6, 0 } }, /* public */
    { .label = { 149265,  5, 0 } }, /* pubol */
    { .label = { 137050,  6, 0 } }, /* quebec */
    { .label = {  99148,  8, 0 } }, /* railroad */
    { .label = { 117456,  7, 0 } }, /* railway */
    { .label = {  25030,  8, 0 } }, /* research */
    { .label = {  64741, 10, 0 } }, /* resistance */
    { .label = {  38486, 12, 0 } }, /* riodejaneiro */
    { .label = {  80040,  9, 0 } }, /* rochester */
    { .label = { 117488,  7, 0 } }, /* rockart */
    { .label = {  18930,  4, 0 } }, /* roma */
    { .label = { 137081,  6, 0 } }, /* russia */
    { .label = {  64781, 10, 0 } }, /* saintlouis */
    { .label = {  58158,  5, 0 } }, /* salem */
    { .label = {  38537, 12, 0 } }, /* salvadordali */
    { .label = {  99180,  8, 0 } }, /* salzburg */
    { .label = {  99218,  8, 0 } }, /* sandiego */
    { .label = {  38588, 12, 0 } }, /* sanfrancisco */
    { .label = {  38638, 12, 0 } }, /* santabarbara */
    { .label = {  80078,  9, 0 } }, /* santacruz */
    { .label = { 117517,  7, 0 } }, /* santafe */
    { .label = {  38683, 12, 0 } }, /* saskatchewan */
    { .label = {  18898,  4, 0 } }, /* satx */
    { .label = {  64822, 10, 0 } }, /* savannahga */
    { .label = {  38734, 12, 0 } }, /* schlesisches */
    { .label = {  50593, 11, 0 } }, /* schoenbrunn */
    { .label = {  50641, 11, 0 } }, /* schokoladen */
    { .label = { 137105,  6, 0 } }, /* school */
    { .label = { 117545,  7, 0 } }, /* schweiz */
    { .label = {   6005,  7, 0 } }, /* science */
    { .label = {   8172, 17, 0 } }, /* scienceandhistory */
    { .label = {   6005, 18, 0 } }, /* scienceandindustry */
    { .label = {  22320, 13, 0 } }, /* sciencecenter */
    { .label = {  22320, 14, 0 } }, /* sciencecenters */
    { .label = {  16190, 15, 0 } }, /* science-fiction */
    { .label = {  22379, 14, 0 } }, /* sciencehistory */
    { .label = {   6083,  8, 0 } }, /* sciences */
    { .label = {   6083, 18, 0 } }, /* sciencesnaturelles */
    { .label = {  99251,  8, 0 } }, /* scotland */
    { .label = { 117581,  7, 0 } }, /* seaport */
    { .label = {  64862, 10, 0 } }, /* settlement */
    { .label = {  99285,  8, 0 } }, /* settlers */
    { .label = { 149290,  5, 0 } }, /* shell */
    { .label = {  64904, 10, 0 } }, /* sherbrooke */
    { .label = { 117610,  7, 0 } }, /* sibenik */
    { .label = {  62323,  4, 0 } }, /* silk */
    { .label = {  11397,  3, 0 } }, /* ski */
    { .label = { 149313,  5, 0 } }, /* skole */
    { .label = {   8070,  7, 0 } }, /* society */
    { .label = { 117640,  7, 0 } }, /* sologne */
    { .label = {  22440, 14, 0 } }, /* soundandvision */
    { .label = {  29723, 13, 0 } }, /* southcarolina */
    { .label = {  80117,  9, 0 } }, /* southwest */
    { .label = {  34557,  5, 0 } }, /* space */
    { .label = {  82719,  3, 0 } }, /* spy */
    { .label = { 137132,  6, 0 } }, /* square */
    { .label = {  83114,  5, 0 } }, /* stadt */
    { .label = {  99318,  8, 0 } }, /* stalbans */
    { .label = {  80158,  9, 0 } }, /* starnberg */
    { .label = {  16256,  5, 0 } }, /* state */
    { .label = {  16256, 15, 0 } }, /* stateofdelaware */
    { .label = {  54372,  7, 0 } }, /* station */
    { .label = {  72100,  5, 0 } }, /* steam */
    { .label = {  64947, 10, 0 } }, /* steiermark */
    { .label = { 137160,  6, 0 } }, /* stjohn */
    { .label = {  80195,  9, 0 } }, /* stockholm */
    { .label = {  38787, 12, 0 } }, /* stpetersburg */
    { .label = {  80236,  9, 0 } }, /* stuttgart */
    { .label = { 137188,  6, 0 } }, /* suisse */
    { .label = {  38840, 12, 0 } }, /* surgeonshall */
    { .label = { 137213,  6, 0 } }, /* surrey */
    { .label = {  99350,  8, 0 } }, /* svizzera */
    { .label = { 137240,  6, 0 } }, /* sweden */
    { .label = { 137268,  6, 0 } }, /* sydney */
    { .label = {  83806,  4, 0 } }, /* tank */
    { .label = { 158577,  3, 0 } }, /* tcm */
    { .label = {  64988, 10, 0 } }, /* technology */
    { .label = {   8245, 17, 0 } }, /* telekommunikation */
    { .label = {  65034, 10, 0 } }, /* television */
    { .label = { 149335,  5, 0 } }, /* texas */
    { .label = { 117670,  7, 0 } }, /* textile */
    { .label = { 117701,  7, 0 } }, /* theater */
    { .label = {  50689,  4, 0 } }, /* time */
    { .label = {  50689, 11, 0 } }, /* timekeeping */
    { .label = {  99389,  8, 0 } }, /* topology */
    { .label = { 129593,  6, 0 } }, /* torino */
    { .label = {  13914,  5, 0 } }, /* touch */
    { .label = {  14130,  4, 0 } }, /* town */
    { .label = {  80273,  9, 0 } }, /* transport */
    { .label = {  45510,  4, 0 } }, /* tree */
    { .label = { 117729,  7, 0 } }, /* trolley */
    { .label = { 117761,  5, 0 } }, /* trust */
    { .label = { 117761,  7, 0 } }, /* trustee */
    { .label = {  22119,  5, 0 } }, /* uhren */
    { .label = {  45742,  3, 0 } }, /* ulm */
    { .label = {  99427,  8, 0 } }, /* undersea */
    { .label = {  65077, 10, 0 } }, /* university */
    { .label = {  13836,  3, 0 } }, /* usa */
    { .label = {  65122, 10, 0 } }, /* usantiques */
    { .label = { 137297,  6, 0 } }, /* usarts */
    { .label = {  16320, 15, 0 } }, /* uscountryestate */
    { .label = {  80310,  9, 0 } }, /* usculture */
    { .label = {  11832, 16, 0 } }, /* usdecorativearts */
    { .label = {  99460,  8, 0 } }, /* usgarden */
    { .label = {  80351,  9, 0 } }, /* ushistory */
    { .label = { 117790,  7, 0 } }, /* ushuaia */
    { .label = {  16384, 15, 0 } }, /* uslivinghistory */
    { .label = {  61401,  4, 0 } }, /* utah */
    { .label = { 156075,  4, 0 } }, /* uvic */
    { .label = {  11462,  6, 0 } }, /* valley */
    { .label = { 137321,  6, 0 } }, /* vantaa */
    { .label = {  65167, 10, 0 } }, /* versailles */
    { .label = { 137344,  6, 0 } }, /* viking */
    { .label = { 117819,  7, 0 } }, /* village */
    { .label = {  99494,  8, 0 } }, /* virginia */
    { .label = { 117851,  7, 0 } }, /* virtual */
    { .label = { 117882,  7, 0 } }, /* virtuel */
    { .label = {  65210, 10, 0 } }, /* vlaanderen */
    { .label = {  50738, 11, 0 } }, /* volkenkunde */
    { .label = { 149356,  5, 0 } }, /* wales */
    { .label = {  99528,  8, 0 } }, /* wallonie */
    { .label = {  16302,  3, 0 } }, /* war */
    { .label = {  38892, 12, 0 } }, /* washingtondc */
    { .label = {  29777, 13, 0 } }, /* watchandclock */
    { .label = {  16452, 15, 0 } }, /* watch-and-clock */
    { .label = {   7074,  7, 0 } }, /* western */
    { .label = {  80391,  9, 0 } }, /* westfalen */
    { .label = { 117914,  7, 0 } }, /* whaling */
    { .label = {  99564,  8, 0 } }, /* wildlife */
    { .label = {   2706, 12, 0 } }, /* williamsburg */
    { .label = {  99604,  8, 0 } }, /* windmill */
    { .label = {  99643,  8, 0 } }, /* workshop */
    { .label = {  80432,  4, 0 } }, /* york */
    { .label = {  80432,  9, 0 } }, /* yorkshire */
    { .label = {  99682,  8, 0 } }, /* yosemite */
    { .label = { 149379,  5, 0 } }, /* youth */
    { .label = {  65252, 10, 0 } }, /* zoological */
    { .label = { 117947,  7, 0 } }, /* zoology */
    { .label = {  22500, 14, 0 } }, /* xn--9dbhblg6di */
    { .label = {  65298, 10, 0 } }, /* xn--h1aegh */

    /* entries 6184 to 6197 */
    { .label = {  72000,  4, 0 } }, /* aero */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 155301,  4, 0 } }, /* coop */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {   2922,  6, 0 } }, /* museum */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  18846,  3, 0 } }, /* pro */

    /* entries 6198 to 6208 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 155301,  4, 0 } }, /* coop */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {   2922,  6, 0 } }, /* museum */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 6209 to 6214 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 6215 to 6222 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 6223 to 6230 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {   2460,  3, 0 } }, /* adv */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 6231 to 6247 */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = { 137105,  6, 0 } }, /* school */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {    763,  2, 0 } }, /* dr */
    { .label = {   1354,  2, 0 } }, /* us */
    { .label = {      5,  2, 0 } }, /* mx */
    { .label = {    135,  2, 0 } }, /* ca */
    { .label = {    654,  2, 0 } }, /* in */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {     55,  2, 0 } }, /* tv */
    { .label = {   1439,  2, 0 } }, /* ws */
    { .label = {   7413,  4, 0 } }, /* mobi */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 6248 to 6251 */
    { .label = {   7274,  3, 1 } }, { .child = { 6252, 1 } }, /* her */
    { .label = {   2891,  3, 1 } }, { .child = { 6253, 1 } }, /* his */

    /* entry 6252 */
    { .label = { 144227,  6, 0 } }, /* forgot */

    /* entry 6253 */
    { .label = { 144227,  6, 0 } }, /* forgot */

    /* entry 6254 */
    { .label = {   1443,  4, 0 } }, /* asso */

    /* entries 6255 to 6332 */
    { .label = {  69886, 10, 1 } }, { .child = { 6333, 1 } }, /* alwaysdata */
    { .label = {  69929, 10, 0 } }, /* cloudfront */
    { .label = { 125762,  7, 0 } }, /* myfritz */
    { .label = {   1364,  2, 0 } }, /* gb */
    { .label = {   1315,  2, 0 } }, /* hu */
    { .label = {    585,  2, 0 } }, /* jp */
    { .label = {     54,  2, 0 } }, /* se */
    { .label = {   2425,  2, 0 } }, /* uk */
    { .label = {    654,  2, 0 } }, /* in */
    { .label = {  87059,  9, 0 } }, /* cdn77-ssl */
    { .label = {  43885,  5, 1 } }, { .child = { 6334, 1 } }, /* cdn77 */
    { .label = {  57040, 11, 1 } }, { .child = { 6335, 1 } }, /* cryptonomic */
    { .label = {  43998, 12, 0 } }, /* at-band-camp */
    { .label = { 126025,  7, 0 } }, /* blogdns */
    { .label = { 106885,  8, 0 } }, /* broke-it */
    { .label = {  70158, 10, 0 } }, /* buyshouses */
    { .label = { 106920,  8, 0 } }, /* dnsalias */
    { .label = { 126088,  7, 0 } }, /* dnsdojo */
    { .label = { 126121,  7, 0 } }, /* does-it */
    { .label = {  87152,  9, 0 } }, /* dontexist */
    { .label = { 106952,  8, 0 } }, /* dynalias */
    { .label = {  87191,  9, 0 } }, /* dynathome */
    { .label = {  33712, 13, 0 } }, /* endofinternet */
    { .label = { 126341,  7, 0 } }, /* from-az */
    { .label = { 126407,  7, 0 } }, /* from-co */
    { .label = { 126837,  7, 0 } }, /* from-la */
    { .label = { 127366,  7, 0 } }, /* from-ny */
    { .label = { 128006,  7, 0 } }, /* gets-it */
    { .label = {  44051, 12, 0 } }, /* ham-radio-op */
    { .label = {  87213,  7, 0 } }, /* homeftp */
    { .label = { 144280,  6, 0 } }, /* homeip */
    { .label = {  87351,  9, 0 } }, /* homelinux */
    { .label = { 107022,  8, 0 } }, /* homeunix */
    { .label = {  57594, 11, 0 } }, /* in-the-band */
    { .label = {  87429,  9, 0 } }, /* is-a-chef */
    { .label = {  87470,  9, 0 } }, /* is-a-geek */
    { .label = { 107202,  8, 0 } }, /* isa-geek */
    { .label = {  87549,  9, 0 } }, /* kicks-ass */
    { .label = {  34381, 13, 0 } }, /* office-on-the */
    { .label = { 128186,  7, 0 } }, /* podzone */
    { .label = {  34441, 13, 0 } }, /* scrapper-site */
    { .label = { 144337,  6, 0 } }, /* selfip */
    { .label = { 107341,  8, 0 } }, /* sells-it */
    { .label = { 107376,  8, 0 } }, /* servebbs */
    { .label = { 107412,  8, 0 } }, /* serveftp */
    { .label = { 107484,  8, 0 } }, /* thruhere */
    { .label = { 144366,  6, 0 } }, /* webhop */
    { .label = { 154755,  5, 0 } }, /* dynv6 */
    { .label = { 144397,  6, 1 } }, { .child = { 6336, 2 } }, /* fastly */
    { .label = {  26846, 14, 0 } }, /* cloudfunctions */
    { .label = {  34785, 13, 0 } }, /* azurewebsites */
    { .label = {  44950, 12, 0 } }, /* azure-mobile */
    { .label = { 107859,  8, 0 } }, /* cloudapp */
    { .label = {  26969, 14, 0 } }, /* eating-organic */
    { .label = {  87872,  9, 0 } }, /* mydissent */
    { .label = { 108002,  8, 0 } }, /* myeffect */
    { .label = {  87912,  9, 0 } }, /* mymediapc */
    { .label = { 154932,  5, 0 } }, /* mypsx */
    { .label = {  13984, 16, 0 } }, /* mysecuritycamera */
    { .label = { 144671,  6, 0 } }, /* nhlfan */
    { .label = { 154959,  5, 0 } }, /* no-ip */
    { .label = { 144698,  6, 0 } }, /* pgafan */
    { .label = {    665, 24, 0 } }, /* privatizehealthinsurance */
    { .label = { 108085,  8, 0 } }, /* bounceme */
    { .label = { 108121,  4, 0 } }, /* ddns */
    { .label = {  71638, 10, 0 } }, /* redirectme */
    { .label = {  88036,  9, 0 } }, /* serveblog */
    { .label = {  27092, 14, 0 } }, /* serveminecraft */
    { .label = {  71526,  5, 0 } }, /* sytes */
    { .label = { 108304,  8, 0 } }, /* rackmaze */
    { .label = {  14055, 16, 0 } }, /* firewall-gateway */
    { .label = { 128545,  7, 0 } }, /* dsmynas */
    { .label = { 108486,  8, 0 } }, /* familyds */
    { .label = {    395,  2, 0 } }, /* za */

    /* entry 6333 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 6334 */
    { .label = {     22,  1, 0 } }, /* r */

    /* entry 6335 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 6336 to 6339 */
    { .label = {   3193,  3, 1 } }, { .child = { 6340, 3 } }, /* ssl */
    { .label = {  54399,  4, 1 } }, { .child = { 6343, 2 } }, /* prod */

    /* entries 6340 to 6342 */
    { .label = {      6,  1, 0 } }, /* a */
    { .label = {    134,  1, 0 } }, /* b */
    { .label = { 142195,  6, 0 } }, /* global */

    /* entries 6343 to 6344 */
    { .label = {      6,  1, 0 } }, /* a */
    { .label = { 142195,  6, 0 } }, /* global */

    /* entries 6345 to 6354 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   3378,  3, 0 } }, /* per */
    { .label = {    175,  3, 0 } }, /* rec */
    { .label = {  26804,  3, 0 } }, /* web */
    { .label = {  11884,  4, 0 } }, /* arts */
    { .label = { 105297,  4, 0 } }, /* firm */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = { 122666,  5, 0 } }, /* other */
    { .label = { 144991,  5, 0 } }, /* store */

    /* entries 6355 to 6365 */
    { .label = {    108,  3, 1 } }, { .child = { 6366, 1 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {      1,  1, 0 } }, /* i */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {   7413,  4, 0 } }, /* mobi */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   4209,  3, 0 } }, /* sch */

    /* entry 6366 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 6367 to 6380 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {  26804,  3, 0 } }, /* web */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {    654,  2, 0 } }, /* in */
    { .label = { 107696,  4, 0 } }, /* info */

    /* entries 6381 to 6386 */
    { .label = {    606,  2, 0 } }, /* bv */
    { .label = {  25995, 14, 0 } }, /* virtueeldomein */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = { 108562,  8, 1 } }, { .child = { 6387, 1 } }, /* transurl */

    /* entry 6387 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 6388 to 7145 */
    { .label = { 147946,  3, 0 } }, /* fhs */
    { .label = {  24117,  3, 0 } }, /* vgs */
    { .label = {  65348, 10, 0 } }, /* fylkesbibl */
    { .label = {  80472,  9, 0 } }, /* folkebibl */
    { .label = {   2922,  6, 0 } }, /* museum */
    { .label = { 137372,  6, 0 } }, /* idrett */
    { .label = {    665,  4, 0 } }, /* priv */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  16256,  4, 0 } }, /* stat */
    { .label = {  35819,  3, 0 } }, /* dep */
    { .label = { 117982,  7, 0 } }, /* kommune */
    { .label = {   8529,  5, 0 } }, /* herad */
    { .label = {    209,  2, 1 } }, { .child = { 7146, 1 } }, /* aa */
    { .label = {    111,  2, 1 } }, { .child = { 7147, 1 } }, /* ah */
    { .label = {   2743,  2, 1 } }, { .child = { 7148, 1 } }, /* bu */
    { .label = {   3205,  2, 1 } }, { .child = { 7149, 1 } }, /* fm */
    { .label = {    324,  2, 1 } }, { .child = { 7150, 1 } }, /* hl */
    { .label = {    195,  2, 1 } }, { .child = { 7151, 1 } }, /* hm */
    { .label = {  80515,  9, 1 } }, { .child = { 7152, 1 } }, /* jan-mayen */
    { .label = {     17,  2, 1 } }, { .child = { 7153, 1 } }, /* mr */
    { .label = {    243,  2, 1 } }, { .child = { 7154, 1 } }, /* nl */
    { .label = {    132,  2, 1 } }, { .child = { 7155, 1 } }, /* nt */
    { .label = {   3299,  2, 1 } }, { .child = { 7156, 1 } }, /* of */
    { .label = {    325,  2, 1 } }, { .child = { 7157, 1 } }, /* ol */
    { .label = { 126115,  4, 1 } }, { .child = { 7158, 1 } }, /* oslo */
    { .label = {   1618,  2, 1 } }, { .child = { 7159, 1 } }, /* rl */
    { .label = {   2395,  2, 1 } }, { .child = { 7160, 1 } }, /* sf */
    { .label = {    266,  2, 1 } }, { .child = { 7161, 1 } }, /* st */
    { .label = {  99717,  8, 1 } }, { .child = { 7162, 1 } }, /* svalbard */
    { .label = {    359,  2, 1 } }, { .child = { 7163, 1 } }, /* tm */
    { .label = {   1020,  2, 1 } }, { .child = { 7164, 1 } }, /* tr */
    { .label = {    527,  2, 1 } }, { .child = { 7165, 1 } }, /* va */
    { .label = {   2239,  2, 1 } }, { .child = { 7166, 1 } }, /* vf */
    { .label = {  99752,  8, 0 } }, /* akrehamn */
    { .label = {  16522, 15, 0 } }, /* xn--krehamn-dxa */
    { .label = {  15628,  6, 0 } }, /* algard */
    { .label = {  29837, 13, 0 } }, /* xn--lgrd-poac */
    { .label = {  15831,  4, 0 } }, /* arna */
    { .label = {  65397, 10, 0 } }, /* brumunddal */
    { .label = { 149403,  5, 0 } }, /* bryne */
    { .label = {  50789, 11, 0 } }, /* bronnoysund */
    { .label = {   6159, 18, 0 } }, /* xn--brnnysund-m8ac */
    { .label = { 137397,  6, 0 } }, /* drobak */
    { .label = {  29899, 13, 0 } }, /* xn--drbak-wua */
    { .label = {  99785,  8, 0 } }, /* egersund */
    { .label = { 118014,  7, 0 } }, /* fetsund */
    { .label = { 149426,  5, 0 } }, /* floro */
    { .label = {  38946, 12, 0 } }, /* xn--flor-jra */
    { .label = {  50838, 11, 0 } }, /* fredrikstad */
    { .label = {  99820,  8, 0 } }, /* hokksund */
    { .label = {  99857,  8, 0 } }, /* honefoss */
    { .label = {  16591, 15, 0 } }, /* xn--hnefoss-q1a */
    { .label = {  99892,  8, 0 } }, /* jessheim */
    { .label = {  80556,  9, 0 } }, /* jorpeland */
    { .label = {  11899, 16, 0 } }, /* xn--jrpeland-54a */
    { .label = {  99929,  8, 0 } }, /* kirkenes */
    { .label = {  99963,  8, 0 } }, /* kopervik */
    { .label = {  39004, 12, 0 } }, /* krokstadelva */
    { .label = { 100001,  8, 0 } }, /* langevag */
    { .label = {  16666, 15, 0 } }, /* xn--langevg-jxa */
    { .label = { 118046,  7, 0 } }, /* leirvik */
    { .label = {  80598,  9, 0 } }, /* mjondalen */
    { .label = {  11983, 16, 0 } }, /* xn--mjndalen-64a */
    { .label = {  80639,  9, 0 } }, /* mo-i-rana */
    { .label = { 118078,  7, 0 } }, /* mosjoen */
    { .label = {  22579, 14, 0 } }, /* xn--mosjen-eya */
    { .label = {  39056, 12, 0 } }, /* nesoddtangen */
    { .label = { 100036,  8, 0 } }, /* orkanger */
    { .label = { 137423,  6, 0 } }, /* osoyro */
    { .label = {  29961, 13, 0 } }, /* xn--osyro-wua */
    { .label = { 137449,  6, 0 } }, /* raholt */
    { .label = {  30023, 13, 0 } }, /* xn--rholt-mra */
    { .label = {  39106, 12, 0 } }, /* sandnessjoen */
    { .label = {   4316, 19, 0 } }, /* xn--sandnessjen-ogb */
    { .label = {  30082, 13, 0 } }, /* skedsmokorset */
    { .label = { 118110,  7, 0 } }, /* slattum */
    { .label = {  65443, 10, 0 } }, /* spjelkavik */
    { .label = {  80676,  9, 0 } }, /* stathelle */
    { .label = { 118140,  7, 0 } }, /* stavern */
    { .label = {  16739, 15, 0 } }, /* stjordalshalsen */
    { .label = {    966, 22, 0 } }, /* xn--stjrdalshalsen-sqb */
    { .label = { 100069,  8, 0 } }, /* tananger */
    { .label = { 137474,  6, 0 } }, /* tranby */
    { .label = {  50886, 11, 0 } }, /* vossevangen */
    { .label = {  66518,  6, 0 } }, /* afjord */
    { .label = {  30138, 13, 0 } }, /* xn--fjord-lra */
    { .label = { 118169,  7, 0 } }, /* agdenes */
    { .label = {     11,  2, 0 } }, /* al */
    { .label = {  80714,  9, 0 } }, /* xn--l-1fa */
    { .label = { 118198,  7, 0 } }, /* alesund */
    { .label = {  22645, 14, 0 } }, /* xn--lesund-hua */
    { .label = {  80761,  9, 0 } }, /* alstahaug */
    { .label = {  27547,  4, 0 } }, /* alta */
    { .label = {  50934, 11, 0 } }, /* xn--lt-liac */
    { .label = {  80798,  9, 0 } }, /* alaheadju */
    { .label = {  12068, 16, 0 } }, /* xn--laheadju-7ya */
    { .label = { 137500,  6, 0 } }, /* alvdal */
    { .label = { 156095,  4, 0 } }, /* amli */
    { .label = {  50985, 11, 0 } }, /* xn--mli-tla */
    { .label = {  22022,  4, 0 } }, /* amot */
    { .label = {  51036, 11, 0 } }, /* xn--mot-tla */
    { .label = { 137527,  6, 0 } }, /* andebu */
    { .label = { 139158,  5, 0 } }, /* andoy */
    { .label = {  39157, 12, 0 } }, /* xn--andy-ira */
    { .label = {  80838,  9, 0 } }, /* andasuolo */
    { .label = {   8784,  5, 0 } }, /* ardal */
    { .label = {  39211, 12, 0 } }, /* xn--rdal-poa */
    { .label = { 118228,  7, 0 } }, /* aremark */
    { .label = { 101607,  7, 0 } }, /* arendal */
    { .label = {  80875,  9, 0 } }, /* xn--s-1fa */
    { .label = { 137553,  6, 0 } }, /* aseral */
    { .label = {  30201, 13, 0 } }, /* xn--seral-lra */
    { .label = { 101268,  5, 0 } }, /* asker */
    { .label = { 149449,  5, 0 } }, /* askim */
    { .label = { 118256,  7, 0 } }, /* askvoll */
    { .label = { 149470,  5, 0 } }, /* askoy */
    { .label = {  39266, 12, 0 } }, /* xn--asky-ira */
    { .label = { 149492,  5, 0 } }, /* asnes */
    { .label = {  39320, 12, 0 } }, /* xn--snes-poa */
    { .label = {  80921,  9, 0 } }, /* audnedaln */
    { .label = { 149511,  5, 0 } }, /* aukra */
    { .label = { 156112,  4, 0 } }, /* aure */
    { .label = { 118288,  7, 0 } }, /* aurland */
    { .label = {  22710, 14, 0 } }, /* aurskog-holand */
    { .label = {   2096, 21, 0 } }, /* xn--aurskog-hland-jnb */
    { .label = {  80959,  9, 0 } }, /* austevoll */
    { .label = {  80999,  9, 0 } }, /* austrheim */
    { .label = { 137576,  6, 0 } }, /* averoy */
    { .label = {  30258, 13, 0 } }, /* xn--avery-yua */
    { .label = {  65492, 10, 0 } }, /* balestrand */
    { .label = {  81037,  9, 0 } }, /* ballangen */
    { .label = { 149531,  5, 0 } }, /* balat */
    { .label = {  39374, 12, 0 } }, /* xn--blt-elab */
    { .label = {  81075,  9, 0 } }, /* balsfjord */
    { .label = {  39430, 12, 0 } }, /* bahccavuotna */
    { .label = {   4402, 19, 0 } }, /* xn--bhccavuotna-k7a */
    { .label = { 137603,  6, 0 } }, /* bamble */
    { .label = { 149551,  5, 0 } }, /* bardu */
    { .label = { 137630,  6, 0 } }, /* beardu */
    { .label = { 137656,  6, 0 } }, /* beiarn */
    { .label = { 118317,  7, 0 } }, /* bajddar */
    { .label = {  22771, 14, 0 } }, /* xn--bjddar-pta */
    { .label = { 137680,  6, 0 } }, /* baidar */
    { .label = {  30320, 13, 0 } }, /* xn--bidr-5nac */
    { .label = {  18348,  4, 0 } }, /* berg */
    { .label = { 137704,  6, 0 } }, /* bergen */
    { .label = { 100100,  8, 0 } }, /* berlevag */
    { .label = {  16804, 15, 0 } }, /* xn--berlevg-jxa */
    { .label = {  51086, 11, 0 } }, /* bearalvahki */
    { .label = {   6248, 18, 0 } }, /* xn--bearalvhki-y4a */
    { .label = { 137730,  6, 0 } }, /* bindal */
    { .label = { 100136,  8, 0 } }, /* birkenes */
    { .label = { 118349,  7, 0 } }, /* bjarkoy */
    { .label = {  22838, 14, 0 } }, /* xn--bjarky-fya */
    { .label = {  81118,  9, 0 } }, /* bjerkreim */
    { .label = { 149573,  5, 0 } }, /* bjugn */
    { .label = { 156128,  4, 0 } }, /* bodo */
    { .label = {  51133, 11, 0 } }, /* xn--bod-2na */
    { .label = { 100170,  8, 0 } }, /* badaddja */
    { .label = {  16878, 15, 0 } }, /* xn--bdddj-mrabd */
    { .label = { 118383,  7, 0 } }, /* budejju */
    { .label = { 156146,  4, 0 } }, /* bokn */
    { .label = {  81160,  9, 0 } }, /* bremanger */
    { .label = {  50789,  7, 0 } }, /* bronnoy */
    { .label = {  22908, 14, 0 } }, /* xn--brnny-wuac */
    { .label = { 118421,  7, 0 } }, /* bygland */
    { .label = { 149599,  5, 0 } }, /* bykle */
    { .label = { 149624,  5, 0 } }, /* barum */
    { .label = {  39482, 12, 0 } }, /* xn--brum-voa */
    { .label = { 100206,  8, 1 } }, { .child = { 7167, 2 } }, /* telemark */
    { .label = { 100240,  8, 1 } }, { .child = { 7169, 4 } }, /* nordland */
    { .label = { 137756,  6, 0 } }, /* bievat */
    { .label = {  30384, 13, 0 } }, /* xn--bievt-0qa */
    { .label = { 149646,  5, 0 } }, /* bomlo */
    { .label = {  39539, 12, 0 } }, /* xn--bmlo-gra */
    { .label = {  81245,  9, 0 } }, /* batsfjord */
    { .label = {  12148, 16, 0 } }, /* xn--btsfjord-9za */
    { .label = {  51188, 11, 0 } }, /* bahcavuotna */
    { .label = {   6335, 18, 0 } }, /* xn--bhcavuotna-s4a */
    { .label = { 149669,  5, 0 } }, /* dovre */
    { .label = { 118454,  7, 0 } }, /* drammen */
    { .label = {  81287,  9, 0 } }, /* drangedal */
    { .label = { 149692,  5, 0 } }, /* dyroy */
    { .label = {  39595, 12, 0 } }, /* xn--dyry-ira */
    { .label = { 149717,  5, 0 } }, /* donna */
    { .label = {  39652, 12, 0 } }, /* xn--dnna-gra */
    { .label = {  15968,  3, 0 } }, /* eid */
    { .label = { 100274,  8, 0 } }, /* eidfjord */
    { .label = { 100313,  8, 0 } }, /* eidsberg */
    { .label = { 118484,  7, 0 } }, /* eidskog */
    { .label = { 100348,  8, 0 } }, /* eidsvoll */
    { .label = {  81325,  9, 0 } }, /* eigersund */
    { .label = { 118515,  7, 0 } }, /* elverum */
    { .label = { 118548,  7, 0 } }, /* enebakk */
    { .label = { 100385,  8, 0 } }, /* engerdal */
    { .label = { 118578,  4, 0 } }, /* etne */
    { .label = { 118578,  7, 0 } }, /* etnedal */
    { .label = { 137782,  6, 0 } }, /* evenes */
    { .label = { 100419,  8, 0 } }, /* evenassi */
    { .label = {   8318, 17, 0 } }, /* xn--eveni-0qa01ga */
    { .label = {  16952, 15, 0 } }, /* evje-og-hornnes */
    { .label = { 118607,  7, 0 } }, /* farsund */
    { .label = { 137808,  6, 0 } }, /* fauske */
    { .label = { 118638,  7, 0 } }, /* fuossko */
    { .label = { 118670,  7, 0 } }, /* fuoisku */
    { .label = { 149737,  5, 0 } }, /* fedje */
    { .label = {   9967,  3, 0 } }, /* fet */
    { .label = { 137835,  6, 0 } }, /* finnoy */
    { .label = {  30452, 13, 0 } }, /* xn--finny-yua */
    { .label = { 137863,  6, 0 } }, /* fitjar */
    { .label = { 137891,  6, 0 } }, /* fjaler */
    { .label = {  39938,  5, 0 } }, /* fjell */
    { .label = { 100452,  8, 0 } }, /* flakstad */
    { .label = {  81364,  9, 0 } }, /* flatanger */
    { .label = {  51235, 11, 0 } }, /* flekkefjord */
    { .label = { 100487,  8, 0 } }, /* flesberg */
    { .label = { 149763,  5, 0 } }, /* flora */
    { .label = {  13424,  3, 0 } }, /* fla */
    { .label = {  65533, 10, 0 } }, /* xn--fl-zia */
    { .label = { 118703,  7, 0 } }, /* folldal */
    { .label = { 118736,  7, 0 } }, /* forsand */
    { .label = { 137920,  6, 0 } }, /* fosnes */
    { .label = {  98208,  4, 0 } }, /* frei */
    { .label = { 149785,  5, 0 } }, /* frogn */
    { .label = { 118766,  7, 0 } }, /* froland */
    { .label = { 137946,  6, 0 } }, /* frosta */
    { .label = { 149808,  5, 0 } }, /* frana */
    { .label = {  39705, 12, 0 } }, /* xn--frna-woa */
    { .label = { 149828,  5, 0 } }, /* froya */
    { .label = {  39761, 12, 0 } }, /* xn--frya-hra */
    { .label = {  73575,  4, 0 } }, /* fusa */
    { .label = { 100524,  8, 0 } }, /* fyresdal */
    { .label = { 149851,  5, 0 } }, /* forde */
    { .label = {  39817, 12, 0 } }, /* xn--frde-gra */
    { .label = { 137971,  6, 0 } }, /* gamvik */
    { .label = {  65583, 10, 0 } }, /* gangaviika */
    { .label = {   4493, 19, 0 } }, /* xn--ggaviika-8ya47h */
    { .label = { 137999,  6, 0 } }, /* gaular */
    { .label = { 118797,  7, 0 } }, /* gausdal */
    { .label = {  81402,  9, 0 } }, /* gildeskal */
    { .label = {  12231, 16, 0 } }, /* xn--gildeskl-g0a */
    { .label = { 149874,  5, 0 } }, /* giske */
    { .label = { 118827,  7, 0 } }, /* gjemnes */
    { .label = { 100561,  8, 0 } }, /* gjerdrum */
    { .label = { 100600,  8, 0 } }, /* gjerstad */
    { .label = { 118860,  7, 0 } }, /* gjesdal */
    { .label = { 138024,  6, 0 } }, /* gjovik */
    { .label = {  30515, 13, 0 } }, /* xn--gjvik-wua */
    { .label = { 118893,  7, 0 } }, /* gloppen */
    { .label = {  19874,  3, 0 } }, /* gol */
    { .label = {  50103,  4, 0 } }, /* gran */
    { .label = { 149896,  5, 0 } }, /* grane */
    { .label = { 118927,  7, 0 } }, /* granvin */
    { .label = {  81442,  9, 0 } }, /* gratangen */
    { .label = { 100636,  8, 0 } }, /* grimstad */
    { .label = { 149916,  5, 0 } }, /* grong */
    { .label = {  81478,  9, 0 } }, /* kraanghke */
    { .label = {  12310, 16, 0 } }, /* xn--kranghke-b0a */
    { .label = { 156164,  4, 0 } }, /* grue */
    { .label = { 149938,  5, 0 } }, /* gulen */
    { .label = { 138055,  6, 0 } }, /* hadsel */
    { .label = { 138081,  6, 0 } }, /* halden */
    { .label = { 149961,  5, 0 } }, /* halsa */
    { .label = { 118957,  5, 0 } }, /* hamar */
    { .label = { 118957,  7, 0 } }, /* hamaroy */
    { .label = { 138107,  6, 0 } }, /* habmer */
    { .label = {  30582, 13, 0 } }, /* xn--hbmer-xqa */
    { .label = { 138133,  6, 0 } }, /* hapmir */
    { .label = {  30647, 13, 0 } }, /* xn--hpmir-xqa */
    { .label = {  65625, 10, 0 } }, /* hammerfest */
    { .label = {  39873, 12, 0 } }, /* hammarfeasta */
    { .label = {   4595, 19, 0 } }, /* xn--hmmrfeasta-s4ac */
    { .label = {  93804,  5, 0 } }, /* haram */
    { .label = { 138160,  6, 0 } }, /* hareid */
    { .label = { 118987,  7, 0 } }, /* harstad */
    { .label = { 138185,  6, 0 } }, /* hasvik */
    { .label = {  65669, 10, 0 } }, /* aknoluokta */
    { .label = {   4684, 19, 0 } }, /* xn--koluokta-7ya57h */
    { .label = {  39922, 12, 0 } }, /* hattfjelldal */
    { .label = { 100670,  8, 0 } }, /* aarborte */
    { .label = {  81516,  9, 0 } }, /* haugesund */
    { .label = { 138212,  5, 0 } }, /* hemne */
    { .label = { 138212,  6, 0 } }, /* hemnes */
    { .label = { 100701,  8, 0 } }, /* hemsedal */
    { .label = {  17021, 15, 1 } }, { .child = { 7173, 2 } }, /* more-og-romsdal */
    { .label = {   1069, 22, 1 } }, { .child = { 7175, 2 } }, /* xn--mre-og-romsdal-qqb */
    { .label = { 150004,  5, 0 } }, /* hitra */
    { .label = { 100736,  8, 0 } }, /* hjartdal */
    { .label = {  65711, 10, 0 } }, /* hjelmeland */
    { .label = { 150024,  5, 0 } }, /* hobol */
    { .label = {  40033, 12, 0 } }, /* xn--hobl-ira */
    { .label = {  65339,  3, 0 } }, /* hof */
    { .label = {  12349,  3, 0 } }, /* hol */
    { .label = { 140187,  4, 0 } }, /* hole */
    { .label = {  51290, 11, 0 } }, /* holmestrand */
    { .label = { 100772,  8, 0 } }, /* holtalen */
    { .label = {  17087, 15, 0 } }, /* xn--holtlen-hxa */
    { .label = {  81556,  9, 0 } }, /* hornindal */
    { .label = { 138238,  6, 0 } }, /* horten */
    { .label = { 138263,  6, 0 } }, /* hurdal */
    { .label = { 150047,  5, 0 } }, /* hurum */
    { .label = { 138290,  6, 0 } }, /* hvaler */
    { .label = {  81594,  9, 0 } }, /* hyllestad */
    { .label = {  65758, 10, 0 } }, /* hagebostad */
    { .label = {   8410, 17, 0 } }, /* xn--hgebostad-g3a */
    { .label = { 100806,  8, 0 } }, /* hoyanger */
    { .label = {  17157, 15, 0 } }, /* xn--hyanger-q1a */
    { .label = {  81635,  9, 0 } }, /* hoylandet */
    { .label = {  12387, 16, 0 } }, /* xn--hylandet-54a */
    { .label = {    848,  2, 0 } }, /* ha */
    { .label = {  81675,  9, 0 } }, /* xn--h-2fa */
    { .label = { 119015,  7, 0 } }, /* ibestad */
    { .label = { 119044,  7, 0 } }, /* inderoy */
    { .label = {  22976, 14, 0 } }, /* xn--indery-fya */
    { .label = { 119075,  7, 0 } }, /* iveland */
    { .label = { 100841,  8, 0 } }, /* jevnaker */
    { .label = {  80603,  6, 0 } }, /* jondal */
    { .label = { 119106,  7, 0 } }, /* jolster */
    { .label = {  23043, 14, 0 } }, /* xn--jlster-bya */
    { .label = { 100878,  8, 0 } }, /* karasjok */
    { .label = {  65800, 10, 0 } }, /* karasjohka */
    { .label = {   4785, 19, 0 } }, /* xn--krjohka-hwab49j */
    { .label = { 119138,  7, 0 } }, /* karlsoy */
    { .label = { 150071,  5, 0 } }, /* galsa */
    { .label = {  40088, 12, 0 } }, /* xn--gls-elac */
    { .label = { 138317,  6, 0 } }, /* karmoy */
    { .label = {  30713, 13, 0 } }, /* xn--karmy-yua */
    { .label = {  65843, 10, 0 } }, /* kautokeino */
    { .label = {  30775, 13, 0 } }, /* guovdageaidnu */
    { .label = { 150091,  5, 0 } }, /* klepp */
    { .label = { 150117,  5, 0 } }, /* klabu */
    { .label = {  40144, 12, 0 } }, /* xn--klbu-woa */
    { .label = {  81723,  9, 0 } }, /* kongsberg */
    { .label = {  51337, 11, 0 } }, /* kongsvinger */
    { .label = { 119169,  7, 0 } }, /* kragero */
    { .label = {  23110, 14, 0 } }, /* xn--krager-gya */
    { .label = {  40203, 12, 0 } }, /* kristiansand */
    { .label = {  40251, 12, 0 } }, /* kristiansund */
    { .label = {  65885, 10, 0 } }, /* krodsherad */
    { .label = {   8491, 17, 0 } }, /* xn--krdsherad-m8a */
    { .label = { 100913,  8, 0 } }, /* kvalsund */
    { .label = {  51386, 11, 0 } }, /* rahkkeravju */
    { .label = {   6420, 18, 0 } }, /* xn--rhkkervju-01af */
    { .label = { 156182,  4, 0 } }, /* kvam */
    { .label = {  81763,  9, 0 } }, /* kvinesdal */
    { .label = {  65928, 10, 0 } }, /* kvinnherad */
    { .label = {  81803,  9, 0 } }, /* kviteseid */
    { .label = { 119198,  7, 0 } }, /* kvitsoy */
    { .label = {  23174, 14, 0 } }, /* xn--kvitsy-fya */
    { .label = { 100950,  8, 0 } }, /* kvafjord */
    { .label = {  17232, 15, 0 } }, /* xn--kvfjord-nxa */
    { .label = {  30833, 13, 0 } }, /* giehtavuoatna */
    { .label = {  81843,  9, 0 } }, /* kvanangen */
    { .label = {  12469, 16, 0 } }, /* xn--kvnangen-k0a */
    { .label = { 100990,  8, 0 } }, /* navuotna */
    { .label = {  17307, 15, 0 } }, /* xn--nvuotna-hwa */
    { .label = { 119231,  7, 0 } }, /* kafjord */
    { .label = {  23243, 14, 0 } }, /* xn--kfjord-iua */
    { .label = {  81881,  9, 0 } }, /* gaivuotna */
    { .label = {  12546, 16, 0 } }, /* xn--givuotna-8ya */
    { .label = { 138344,  6, 0 } }, /* larvik */
    { .label = { 101023,  8, 0 } }, /* lavangen */
    { .label = { 119265,  7, 0 } }, /* lavagis */
    { .label = { 138371,  6, 0 } }, /* loabat */
    { .label = {  30887, 13, 0 } }, /* xn--loabt-0qa */
    { .label = { 119295,  7, 0 } }, /* lebesby */
    { .label = {  65972, 10, 0 } }, /* davvesiida */
    { .label = {  81919,  9, 0 } }, /* leikanger */
    { .label = {  81957,  9, 0 } }, /* leirfjord */
    { .label = {  83321,  4, 0 } }, /* leka */
    { .label = { 119328,  7, 0 } }, /* leksvik */
    { .label = { 138395,  6, 0 } }, /* lenvik */
    { .label = {  51437, 11, 0 } }, /* leangaviika */
    { .label = {   6516, 18, 0 } }, /* xn--leagaviika-52b */
    { .label = { 150140,  5, 0 } }, /* lesja */
    { .label = { 101057,  8, 0 } }, /* levanger */
    { .label = {  79764,  4, 0 } }, /* lier */
    { .label = { 138423,  6, 0 } }, /* lierne */
    { .label = {  51483, 11, 0 } }, /* lillehammer */
    { .label = {  82000,  9, 0 } }, /* lillesand */
    { .label = {  82039,  9, 0 } }, /* lindesnes */
    { .label = { 138448,  6, 0 } }, /* lindas */
    { .label = {  30953, 13, 0 } }, /* xn--linds-pra */
    { .label = {  72484,  3, 0 } }, /* lom */
    { .label = { 150163,  5, 0 } }, /* loppa */
    { .label = { 138473,  6, 0 } }, /* lahppi */
    { .label = {  31013, 13, 0 } }, /* xn--lhppi-xqa */
    { .label = { 105720,  4, 0 } }, /* lund */
    { .label = { 138502,  6, 0 } }, /* lunner */
    { .label = { 150187,  5, 0 } }, /* luroy */
    { .label = {  40301, 12, 0 } }, /* xn--lury-ira */
    { .label = { 138528,  6, 0 } }, /* luster */
    { .label = { 119361,  7, 0 } }, /* lyngdal */
    { .label = { 138554,  6, 0 } }, /* lyngen */
    { .label = { 156201,  4, 0 } }, /* ivgu */
    { .label = { 138582,  6, 0 } }, /* lardal */
    { .label = { 138607,  6, 0 } }, /* lerdal */
    { .label = {  31081, 13, 0 } }, /* xn--lrdal-sra */
    { .label = { 101092,  8, 0 } }, /* lodingen */
    { .label = {  17377, 15, 0 } }, /* xn--ldingen-q1a */
    { .label = {  82077,  9, 0 } }, /* lorenskog */
    { .label = {  12625, 16, 0 } }, /* xn--lrenskog-54a */
    { .label = { 143669,  5, 0 } }, /* loten */
    { .label = {  40357, 12, 0 } }, /* xn--lten-gra */
    { .label = { 138633,  6, 0 } }, /* malvik */
    { .label = { 150211,  5, 0 } }, /* masoy */
    { .label = {  31139, 13, 0 } }, /* xn--msy-ula0h */
    { .label = { 138661,  6, 0 } }, /* muosat */
    { .label = {  31206, 13, 0 } }, /* xn--muost-0qa */
    { .label = { 138686,  6, 0 } }, /* mandal */
    { .label = { 138711,  6, 0 } }, /* marker */
    { .label = {  82116,  9, 0 } }, /* marnardal */
    { .label = {  66016, 10, 0 } }, /* masfjorden */
    { .label = {  65732,  6, 0 } }, /* meland */
    { .label = { 138736,  6, 0 } }, /* meldal */
    { .label = { 138763,  6, 0 } }, /* melhus */
    { .label = { 150233,  5, 0 } }, /* meloy */
    { .label = {  40411, 12, 0 } }, /* xn--mely-ira */
    { .label = { 119394,  7, 0 } }, /* meraker */
    { .label = {  23311, 14, 0 } }, /* xn--merker-kua */
    { .label = { 119423,  7, 0 } }, /* moareke */
    { .label = {  23375, 14, 0 } }, /* xn--moreke-jua */
    { .label = { 119452,  7, 0 } }, /* midsund */
    { .label = {  23441, 14, 0 } }, /* midtre-gauldal */
    { .label = { 119484,  7, 0 } }, /* modalen */
    { .label = { 150257,  5, 0 } }, /* modum */
    { .label = { 150281,  5, 0 } }, /* molde */
    { .label = { 101127,  8, 0 } }, /* moskenes */
    { .label = {  45725,  4, 0 } }, /* moss */
    { .label = { 138791,  6, 0 } }, /* mosvik */
    { .label = { 119514,  7, 0 } }, /* malselv */
    { .label = {  23503, 14, 0 } }, /* xn--mlselv-iua */
    { .label = {  51532, 11, 0 } }, /* malatvuopmi */
    { .label = {   6606, 18, 0 } }, /* xn--mlatvuopmi-s4a */
    { .label = {  66062, 10, 0 } }, /* namdalseid */
    { .label = { 138819,  6, 0 } }, /* aejrie */
    { .label = { 138845,  6, 0 } }, /* namsos */
    { .label = {  66104, 10, 0 } }, /* namsskogan */
    { .label = {  23569, 14, 0 } }, /* naamesjevuemie */
    { .label = {   2194, 21, 0 } }, /* xn--nmesjevuemie-tcba */
    { .label = {  40467, 12, 0 } }, /* laakesvuemie */
    { .label = {  82152,  9, 0 } }, /* nannestad */
    { .label = { 138869,  6, 0 } }, /* narvik */
    { .label = { 101161,  8, 0 } }, /* narviika */
    { .label = { 101194,  8, 0 } }, /* naustdal */
    { .label = {  51582, 11, 0 } }, /* nedre-eiker */
    { .label = { 101227,  8, 1 } }, { .child = { 7177, 1 } }, /* akershus */
    { .label = { 101261,  8, 1 } }, { .child = { 7178, 1 } }, /* buskerud */
    { .label = { 101149,  5, 0 } }, /* nesna */
    { .label = { 101298,  8, 0 } }, /* nesodden */
    { .label = { 119546,  7, 0 } }, /* nesseby */
    { .label = { 119577,  7, 0 } }, /* unjarga */
    { .label = {  23631, 14, 0 } }, /* xn--unjrga-rta */
    { .label = { 138895,  6, 0 } }, /* nesset */
    { .label = { 101332,  8, 0 } }, /* nissedal */
    { .label = { 101365,  8, 0 } }, /* nittedal */
    { .label = {  51629, 11, 0 } }, /* nord-aurdal */
    { .label = {  82187,  9, 0 } }, /* nord-fron */
    { .label = {  82227,  9, 0 } }, /* nord-odal */
    { .label = { 119608,  7, 0 } }, /* norddal */
    { .label = { 101398,  8, 0 } }, /* nordkapp */
    { .label = {  51676, 11, 0 } }, /* davvenjarga */
    { .label = {   6694, 18, 0 } }, /* xn--davvenjrga-y4a */
    { .label = {  51726, 11, 0 } }, /* nordre-land */
    { .label = {  82266,  9, 0 } }, /* nordreisa */
    { .label = { 150304,  5, 0 } }, /* raisa */
    { .label = {  40519, 12, 0 } }, /* xn--risa-5na */
    { .label = {  31273, 13, 0 } }, /* nore-og-uvdal */
    { .label = { 101435,  8, 0 } }, /* notodden */
    { .label = { 150322,  5, 0 } }, /* naroy */
    { .label = {  31332, 13, 0 } }, /* xn--nry-yla5g */
    { .label = { 101469,  8, 0 } }, /* notteroy */
    { .label = {  17452, 15, 0 } }, /* xn--nttery-byae */
    { .label = {  31947,  4, 0 } }, /* odda */
    { .label = { 138919,  6, 0 } }, /* oksnes */
    { .label = {  31399, 13, 0 } }, /* xn--ksnes-uua */
    { .label = { 138944,  6, 0 } }, /* oppdal */
    { .label = { 101503,  8, 0 } }, /* oppegard */
    { .label = {  17521, 15, 0 } }, /* xn--oppegrd-ixa */
    { .label = { 138973,  6, 0 } }, /* orkdal */
    { .label = { 138999,  6, 0 } }, /* orland */
    { .label = {  31458, 13, 0 } }, /* xn--rland-uua */
    { .label = { 139024,  6, 0 } }, /* orskog */
    { .label = {  31517, 13, 0 } }, /* xn--rskog-uua */
    { .label = { 150343,  5, 0 } }, /* orsta */
    { .label = {  40575, 12, 0 } }, /* xn--rsta-fra */
    { .label = { 119638,  7, 1 } }, { .child = { 7179, 3 } }, /* hedmark */
    { .label = {  82302,  9, 1 } }, { .child = { 7182, 1 } }, /* hordaland */
    { .label = {   1031,  4, 0 } }, /* osen */
    { .label = { 119669,  7, 0 } }, /* osteroy */
    { .label = {  23695, 14, 0 } }, /* xn--ostery-fya */
    { .label = {  51773, 11, 0 } }, /* ostre-toten */
    { .label = {   6784, 18, 0 } }, /* xn--stre-toten-zcb */
    { .label = {  82340,  9, 0 } }, /* overhalla */
    { .label = {  66145, 10, 0 } }, /* ovre-eiker */
    { .label = {   8573, 17, 0 } }, /* xn--vre-eiker-k8a */
    { .label = { 156221,  4, 0 } }, /* oyer */
    { .label = {  51818, 11, 0 } }, /* xn--yer-zna */
    { .label = { 101540,  8, 0 } }, /* oygarden */
    { .label = {  17593, 15, 0 } }, /* xn--ygarden-p1a */
    { .label = {  31577, 13, 0 } }, /* oystre-slidre */
    { .label = {   2950, 20, 0 } }, /* xn--ystre-slidre-ujb */
    { .label = {  82379,  9, 0 } }, /* porsanger */
    { .label = { 101575,  8, 0 } }, /* porsangu */
    { .label = {   8656, 17, 0 } }, /* xn--porsgu-sta26f */
    { .label = {  82417,  9, 0 } }, /* porsgrunn */
    { .label = { 150362,  5, 0 } }, /* radoy */
    { .label = {  40628, 12, 0 } }, /* xn--rady-ira */
    { .label = {  82457,  9, 0 } }, /* rakkestad */
    { .label = {  55990,  4, 0 } }, /* rana */
    { .label = { 139050,  6, 0 } }, /* ruovat */
    { .label = {  82494,  9, 0 } }, /* randaberg */
    { .label = { 150384,  5, 0 } }, /* rauma */
    { .label = { 101610,  8, 0 } }, /* rendalen */
    { .label = { 119699,  7, 0 } }, /* rennebu */
    { .label = { 101643,  8, 0 } }, /* rennesoy */
    { .label = {  17666, 15, 0 } }, /* xn--rennesy-v1a */
    { .label = { 139076,  6, 0 } }, /* rindal */
    { .label = { 119729,  7, 0 } }, /* ringebu */
    { .label = {  82531,  9, 0 } }, /* ringerike */
    { .label = {  82569,  9, 0 } }, /* ringsaker */
    { .label = { 150404,  5, 0 } }, /* rissa */
    { .label = { 150423,  5, 0 } }, /* risor */
    { .label = {  40682, 12, 0 } }, /* xn--risr-ira */
    { .label = {  23008,  4, 0 } }, /* roan */
    { .label = { 139101,  6, 0 } }, /* rollag */
    { .label = { 150443,  5, 0 } }, /* rygge */
    { .label = { 101677,  8, 0 } }, /* ralingen */
    { .label = {  17738, 15, 0 } }, /* xn--rlingen-mxa */
    { .label = { 150467,  5, 0 } }, /* rodoy */
    { .label = {  40734, 12, 0 } }, /* xn--rdy-0nab */
    { .label = { 119760,  7, 0 } }, /* romskog */
    { .label = {  23761, 14, 0 } }, /* xn--rmskog-bya */
    { .label = { 150490,  5, 0 } }, /* roros */
    { .label = {  40795, 12, 0 } }, /* xn--rros-gra */
    { .label = {  83182,  4, 0 } }, /* rost */
    { .label = {  51871, 11, 0 } }, /* xn--rst-0na */
    { .label = { 139127,  6, 0 } }, /* royken */
    { .label = {  31634, 13, 0 } }, /* xn--ryken-vua */
    { .label = { 119791,  7, 0 } }, /* royrvik */
    { .label = {  23827, 14, 0 } }, /* xn--ryrvik-bya */
    { .label = {  34651,  4, 0 } }, /* rade */
    { .label = {  51924, 11, 0 } }, /* xn--rde-ula */
    { .label = { 101710,  8, 0 } }, /* salangen */
    { .label = { 119824,  7, 0 } }, /* siellak */
    { .label = { 119854,  7, 0 } }, /* saltdal */
    { .label = { 105168,  5, 0 } }, /* salat */
    { .label = {  40848, 12, 0 } }, /* xn--slt-elab */
    { .label = {  40903, 12, 0 } }, /* xn--slat-5na */
    { .label = {  82606,  9, 0 } }, /* samnanger */
    { .label = { 101742,  8, 1 } }, { .child = { 7183, 1 } }, /* vestfold */
    { .label = {  66189, 10, 0 } }, /* sandefjord */
    { .label = {   4336,  7, 0 } }, /* sandnes */
    { .label = { 139154,  6, 0 } }, /* sandoy */
    { .label = {  31696, 13, 0 } }, /* xn--sandy-yua */
    { .label = {  82642,  9, 0 } }, /* sarpsborg */
    { .label = { 150510,  5, 0 } }, /* sauda */
    { .label = { 101780,  8, 0 } }, /* sauherad */
    { .label = {   9337,  3, 0 } }, /* sel */
    { .label = { 150530,  5, 0 } }, /* selbu */
    { .label = { 150553,  5, 0 } }, /* selje */
    { .label = { 119883,  7, 0 } }, /* seljord */
    { .label = { 139180,  6, 0 } }, /* sigdal */
    { .label = { 139206,  6, 0 } }, /* siljan */
    { .label = { 139233,  6, 0 } }, /* sirdal */
    { .label = { 150577,  5, 0 } }, /* skaun */
    { .label = {  30082,  7, 0 } }, /* skedsmo */
    { .label = {  11397,  3, 0 } }, /* ski */
    { .label = { 150598,  5, 0 } }, /* skien */
    { .label = { 101813,  8, 0 } }, /* skiptvet */
    { .label = { 101850,  8, 0 } }, /* skjervoy */
    { .label = {  17807, 15, 0 } }, /* xn--skjervy-v1a */
    { .label = { 119916,  7, 0 } }, /* skierva */
    { .label = {  23895, 14, 0 } }, /* xn--skierv-uta */
    { .label = { 150619,  5, 0 } }, /* skjak */
    { .label = {  40960, 12, 0 } }, /* xn--skjk-soa */
    { .label = { 139258,  6, 0 } }, /* skodje */
    { .label = { 101890,  8, 0 } }, /* skanland */
    { .label = {  17885, 15, 0 } }, /* xn--sknland-fxa */
    { .label = { 139287,  6, 0 } }, /* skanit */
    { .label = {  31757, 13, 0 } }, /* xn--sknit-yqa */
    { .label = { 150643,  5, 0 } }, /* smola */
    { .label = {  41017, 12, 0 } }, /* xn--smla-hra */
    { .label = {  66235, 10, 0 } }, /* snillfjord */
    { .label = { 150664,  5, 0 } }, /* snasa */
    { .label = {  41071, 12, 0 } }, /* xn--snsa-roa */
    { .label = { 139311,  6, 0 } }, /* snoasa */
    { .label = { 139333,  6, 0 } }, /* snaase */
    { .label = {  31820, 13, 0 } }, /* xn--snase-nra */
    { .label = { 119946,  7, 0 } }, /* sogndal */
    { .label = { 119976,  7, 0 } }, /* sokndal */
    { .label = {  49335,  4, 0 } }, /* sola */
    { .label = { 139355,  6, 0 } }, /* solund */
    { .label = {  82681,  9, 0 } }, /* songdalen */
    { .label = { 101923,  8, 0 } }, /* sortland */
    { .label = {  82719,  9, 0 } }, /* spydeberg */
    { .label = { 139382,  6, 0 } }, /* stange */
    { .label = {  82762,  9, 0 } }, /* stavanger */
    { .label = { 120006,  7, 0 } }, /* steigen */
    { .label = {  82799,  9, 0 } }, /* steinkjer */
    { .label = {  16739,  8, 0 } }, /* stjordal */
    { .label = {  17955, 15, 0 } }, /* xn--stjrdal-s1a */
    { .label = { 139406,  6, 0 } }, /* stokke */
    { .label = {  51975, 11, 0 } }, /* stor-elvdal */
    { .label = { 120035,  5, 0 } }, /* stord */
    { .label = { 120035,  7, 0 } }, /* stordal */
    { .label = {  82839,  9, 0 } }, /* storfjord */
    { .label = {  66283, 10, 0 } }, /* omasvuotna */
    { .label = {  51313,  6, 0 } }, /* strand */
    { .label = { 120064,  7, 0 } }, /* stranda */
    { .label = { 150682,  5, 0 } }, /* stryn */
    { .label = {  69422,  4, 0 } }, /* sula */
    { .label = { 139432,  6, 0 } }, /* suldal */
    { .label = {   6202,  4, 0 } }, /* sund */
    { .label = { 120091,  7, 0 } }, /* sunndal */
    { .label = { 101956,  8, 0 } }, /* surnadal */
    { .label = { 150704,  5, 0 } }, /* sveio */
    { .label = { 120121,  7, 0 } }, /* svelvik */
    { .label = {  82881,  9, 0 } }, /* sykkylven */
    { .label = { 150726,  5, 0 } }, /* sogne */
    { .label = {  41122, 12, 0 } }, /* xn--sgne-gra */
    { .label = { 150747,  5, 0 } }, /* somna */
    { .label = {  41176, 12, 0 } }, /* xn--smna-gra */
    { .label = {  52024, 11, 0 } }, /* sondre-land */
    { .label = {   6867, 18, 0 } }, /* xn--sndre-land-0cb */
    { .label = {  66325, 10, 0 } }, /* sor-aurdal */
    { .label = {   8746, 17, 0 } }, /* xn--sr-aurdal-l8a */
    { .label = { 101989,  8, 0 } }, /* sor-fron */
    { .label = {  18027, 15, 0 } }, /* xn--sr-fron-q1a */
    { .label = { 102024,  8, 0 } }, /* sor-odal */
    { .label = {  18102, 15, 0 } }, /* xn--sr-odal-q1a */
    { .label = {  41229, 12, 0 } }, /* sor-varanger */
    { .label = {   4888, 19, 0 } }, /* xn--sr-varanger-ggb */
    { .label = {  31875, 13, 0 } }, /* matta-varjjat */
    { .label = {   3045, 20, 0 } }, /* xn--mtta-vrjjat-k7af */
    { .label = { 120155,  7, 0 } }, /* sorfold */
    { .label = {  23959, 14, 0 } }, /* xn--srfold-bya */
    { .label = { 102058,  8, 0 } }, /* sorreisa */
    { .label = {  18176, 15, 0 } }, /* xn--srreisa-q1a */
    { .label = { 150767,  5, 0 } }, /* sorum */
    { .label = {  41279, 12, 0 } }, /* xn--srum-gra */
    { .label = {  11369,  4, 0 } }, /* tana */
    { .label = { 139459,  6, 0 } }, /* deatnu */
    { .label = {  50689,  4, 0 } }, /* time */
    { .label = { 102089,  8, 0 } }, /* tingvoll */
    { .label = {  63746,  4, 0 } }, /* tinn */
    { .label = {  82926,  9, 0 } }, /* tjeldsund */
    { .label = {  31933, 13, 0 } }, /* dielddanuorri */
    { .label = { 150789,  5, 0 } }, /* tjome */
    { .label = {  41334, 12, 0 } }, /* xn--tjme-hra */
    { .label = { 139410,  5, 0 } }, /* tokke */
    { .label = { 150813,  5, 0 } }, /* tolga */
    { .label = { 120187,  7, 0 } }, /* torsken */
    { .label = { 139484,  6, 0 } }, /* tranoy */
    { .label = {  31989, 13, 0 } }, /* xn--trany-yua */
    { .label = { 139509,  6, 0 } }, /* tromso */
    { .label = {  32049, 13, 0 } }, /* xn--troms-zua */
    { .label = { 139534,  6, 0 } }, /* tromsa */
    { .label = { 139538,  5, 0 } }, /* romsa */
    { .label = {  82969,  9, 0 } }, /* trondheim */
    { .label = { 102126,  8, 0 } }, /* troandin */
    { .label = { 139558,  6, 0 } }, /* trysil */
    { .label = { 150834,  5, 0 } }, /* trana */
    { .label = {  41391, 12, 0 } }, /* xn--trna-woa */
    { .label = { 102158,  8, 0 } }, /* trogstad */
    { .label = {  18247, 15, 0 } }, /* xn--trgstad-r1a */
    { .label = {  52071, 11, 0 } }, /* tvedestrand */
    { .label = { 136305,  5, 0 } }, /* tydal */
    { .label = { 139585,  6, 0 } }, /* tynset */
    { .label = { 102191,  8, 0 } }, /* tysfjord */
    { .label = {  41445, 12, 0 } }, /* divtasvuodna */
    { .label = {  32110, 13, 0 } }, /* divttasvuotna */
    { .label = { 139611,  6, 0 } }, /* tysnes */
    { .label = { 139637,  6, 0 } }, /* tysvar */
    { .label = {  32166, 13, 0 } }, /* xn--tysvr-vra */
    { .label = { 102231,  8, 0 } }, /* tonsberg */
    { .label = {  18316, 15, 0 } }, /* xn--tnsberg-q1a */
    { .label = {  66367, 10, 0 } }, /* ullensaker */
    { .label = {  66410, 10, 0 } }, /* ullensvang */
    { .label = { 138636,  5, 0 } }, /* ulvik */
    { .label = { 139664,  6, 0 } }, /* utsira */
    { .label = { 150852,  5, 0 } }, /* vadso */
    { .label = {  41498, 12, 0 } }, /* xn--vads-jra */
    { .label = {  66455, 10, 0 } }, /* cahcesuolo */
    { .label = {   4974, 19, 0 } }, /* xn--hcesuolo-7ya35b */
    { .label = { 120216,  7, 0 } }, /* vaksdal */
    { .label = {  11462,  5, 0 } }, /* valle */
    { .label = {  50908,  4, 0 } }, /* vang */
    { .label = { 102265,  8, 0 } }, /* vanylven */
    { .label = { 150874,  5, 0 } }, /* vardo */
    { .label = {  41555, 12, 0 } }, /* xn--vard-jra */
    { .label = { 120247,  7, 0 } }, /* varggat */
    { .label = {  24026, 14, 0 } }, /* xn--vrggt-xqad */
    { .label = { 150896,  5, 0 } }, /* vefsn */
    { .label = { 120277,  7, 0 } }, /* vaapste */
    { .label = {  83008,  4, 0 } }, /* vega */
    { .label = {  83008,  9, 0 } }, /* vegarshei */
    { .label = {  12706, 16, 0 } }, /* xn--vegrshei-c0a */
    { .label = { 102303,  8, 0 } }, /* vennesla */
    { .label = { 139688,  6, 0 } }, /* verdal */
    { .label = { 139715,  6, 0 } }, /* verran */
    { .label = { 139740,  6, 0 } }, /* vestby */
    { .label = { 120307,  7, 0 } }, /* vestnes */
    { .label = {  32228, 13, 0 } }, /* vestre-slidre */
    { .label = {  41612, 12, 0 } }, /* vestre-toten */
    { .label = {  83047,  9, 0 } }, /* vestvagoy */
    { .label = {   8827, 17, 0 } }, /* xn--vestvgy-ixa6o */
    { .label = {  83089,  9, 0 } }, /* vevelstad */
    { .label = {   3180,  3, 0 } }, /* vik */
    { .label = { 150920,  5, 0 } }, /* vikna */
    { .label = {  66499, 10, 0 } }, /* vindafjord */
    { .label = { 150942,  5, 0 } }, /* volda */
    { .label = {  50886,  4, 0 } }, /* voss */
    { .label = { 150965,  5, 0 } }, /* varoy */
    { .label = {  32285, 13, 0 } }, /* xn--vry-yla5g */
    { .label = { 150988,  5, 0 } }, /* vagan */
    { .label = {  41663, 12, 0 } }, /* xn--vgan-qoa */
    { .label = { 139769,  6, 0 } }, /* voagat */
    { .label = { 139794,  6, 0 } }, /* vagsoy */
    { .label = {  24097, 14, 0 } }, /* xn--vgsy-qoa0j */
    { .label = { 150988,  4, 0 } }, /* vaga */
    { .label = {  52118, 11, 0 } }, /* xn--vg-yiab */
    { .label = { 120337,  7, 1 } }, { .child = { 7184, 1 } }, /* ostfold */
    { .label = {  24174, 14, 1 } }, { .child = { 7185, 1 } }, /* xn--stfold-9xa */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entry 7146 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7147 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7148 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7149 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7150 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7151 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7152 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7153 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7154 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7155 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7156 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7157 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7158 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7159 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7160 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7161 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7162 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7163 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7164 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7165 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entry 7166 */
    { .label = {    421,  2, 0 } }, /* gs */

    /* entries 7167 to 7168 */
    { .label = {    988,  2, 0 } }, /* bo */
    { .label = {  81198,  9, 0 } }, /* xn--b-5ga */

    /* entries 7169 to 7172 */
    { .label = {    988,  2, 0 } }, /* bo */
    { .label = {  81198,  9, 0 } }, /* xn--b-5ga */
    { .label = { 149981,  5, 0 } }, /* heroy */
    { .label = {  39978, 12, 0 } }, /* xn--hery-ira */

    /* entries 7173 to 7174 */
    { .label = { 149981,  5, 0 } }, /* heroy */
    { .label = {  66189,  5, 0 } }, /* sande */

    /* entries 7175 to 7176 */
    { .label = {  39978, 12, 0 } }, /* xn--hery-ira */
    { .label = {  66189,  5, 0 } }, /* sande */

    /* entry 7177 */
    { .label = {   4352,  3, 0 } }, /* nes */

    /* entry 7178 */
    { .label = {   4352,  3, 0 } }, /* nes */

    /* entries 7179 to 7181 */
    { .label = {     69,  2, 0 } }, /* os */
    { .label = { 138295,  5, 0 } }, /* valer */
    { .label = {  41721, 12, 0 } }, /* xn--vler-qoa */

    /* entry 7182 */
    { .label = {     69,  2, 0 } }, /* os */

    /* entry 7183 */
    { .label = {  66189,  5, 0 } }, /* sande */

    /* entry 7184 */
    { .label = { 138295,  5, 0 } }, /* valer */

    /* entry 7185 */
    { .label = {  41721, 12, 0 } }, /* xn--vler-qoa */

    /* entry 7186 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 7187 to 7193 */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {    108,  3, 0 } }, /* com */

    /* entries 7194 to 7196 */
    { .label = { 107236,  8, 0 } }, /* merseine */
    { .label = {  27114,  4, 0 } }, /* mine */
    { .label = { 107450,  8, 0 } }, /* shacknet */

    /* entries 7197 to 7213 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 1 } }, { .child = { 7214, 1 } }, /* co */
    { .label = {   7510,  3, 0 } }, /* cri */
    { .label = {  70533,  4, 0 } }, /* geek */
    { .label = {    591,  3, 0 } }, /* gen */
    { .label = { 156239,  4, 0 } }, /* govt */
    { .label = {    707,  6, 0 } }, /* health */
    { .label = {  29636,  3, 0 } }, /* iwi */
    { .label = { 156258,  4, 0 } }, /* kiwi */
    { .label = { 151009,  5, 0 } }, /* maori */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  41780, 12, 0 } }, /* xn--mori-qsa */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  59608, 10, 0 } }, /* parliament */
    { .label = { 137105,  6, 0 } }, /* school */

    /* entry 7214 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7215 to 7223 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {   2922,  6, 0 } }, /* museum */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  18846,  3, 0 } }, /* pro */

    /* entries 7224 to 7315 */
    { .label = { 106779,  8, 0 } }, /* pimienta */
    { .label = { 125700,  7, 0 } }, /* poivron */
    { .label = { 125732,  7, 0 } }, /* potager */
    { .label = {  56987, 11, 0 } }, /* sweetpepper */
    { .label = {      6,  2, 0 } }, /* ae */
    { .label = {   1354,  2, 0 } }, /* us */
    { .label = { 125832,  7, 0 } }, /* certmgr */
    { .label = {  43885,  5, 1 } }, { .child = { 7316, 2 } }, /* cdn77 */
    { .label = {  43885, 12, 1 } }, { .child = { 7318, 1 } }, /* cdn77-secure */
    { .label = { 125863,  7, 0 } }, /* cloudns */
    { .label = { 125992,  7, 0 } }, /* duckdns */
    { .label = { 158159,  4, 0 } }, /* tunk */
    { .label = {  26057,  6, 1 } }, { .child = { 7321, 2 } }, /* dyndns */
    { .label = { 126025,  7, 0 } }, /* blogdns */
    { .label = { 106850,  8, 0 } }, /* blogsite */
    { .label = {   7207, 18, 0 } }, /* boldlygoingnowhere */
    { .label = { 106920,  8, 0 } }, /* dnsalias */
    { .label = { 126088,  7, 0 } }, /* dnsdojo */
    { .label = {  57499, 11, 0 } }, /* doesntexist */
    { .label = {  87152,  9, 0 } }, /* dontexist */
    { .label = { 126151,  7, 0 } }, /* doomdns */
    { .label = { 144199,  6, 0 } }, /* dvrdns */
    { .label = { 106952,  8, 0 } }, /* dynalias */
    { .label = {  33712, 13, 0 } }, /* endofinternet */
    { .label = {  13296, 16, 0 } }, /* endoftheinternet */
    { .label = { 126935,  7, 0 } }, /* from-me */
    { .label = {  87272,  9, 0 } }, /* game-host */
    { .label = { 144254,  6, 0 } }, /* gotdns */
    { .label = {  70337, 10, 0 } }, /* hobby-site */
    { .label = { 128036,  7, 0 } }, /* homedns */
    { .label = {  87213,  7, 0 } }, /* homeftp */
    { .label = {  87351,  9, 0 } }, /* homelinux */
    { .label = { 107022,  8, 0 } }, /* homeunix */
    { .label = {  26242, 14, 0 } }, /* is-a-bruinsfan */
    { .label = {  26365, 14, 0 } }, /* is-a-candidate */
    { .label = {  19765, 15, 0 } }, /* is-a-celticsfan */
    { .label = {  87429,  9, 0 } }, /* is-a-chef */
    { .label = {  87470,  9, 0 } }, /* is-a-geek */
    { .label = {  57736, 11, 0 } }, /* is-a-knight */
    { .label = {  19894, 15, 0 } }, /* is-a-linux-user */
    { .label = {  44307, 12, 0 } }, /* is-a-patsfan */
    { .label = {  57883, 11, 0 } }, /* is-a-soxfan */
    { .label = { 107094,  8, 0 } }, /* is-found */
    { .label = { 128127,  7, 0 } }, /* is-lost */
    { .label = { 107131,  8, 0 } }, /* is-saved */
    { .label = {  58071, 11, 0 } }, /* is-very-bad */
    { .label = {  44610, 12, 0 } }, /* is-very-evil */
    { .label = {  44667, 12, 0 } }, /* is-very-good */
    { .label = {  44723, 12, 0 } }, /* is-very-nice */
    { .label = {  34262, 13, 0 } }, /* is-very-sweet */
    { .label = { 107202,  8, 0 } }, /* isa-geek */
    { .label = {  87549,  9, 0 } }, /* kicks-ass */
    { .label = {  58174, 11, 0 } }, /* misconfused */
    { .label = { 128186,  7, 0 } }, /* podzone */
    { .label = {  70777, 10, 0 } }, /* readmyblog */
    { .label = { 144337,  6, 0 } }, /* selfip */
    { .label = {  34498, 13, 0 } }, /* sellsyourhome */
    { .label = { 107376,  8, 0 } }, /* servebbs */
    { .label = { 107412,  8, 0 } }, /* serveftp */
    { .label = {  87670,  9, 0 } }, /* servegame */
    { .label = {  44778, 12, 0 } }, /* stuff-4-sale */
    { .label = { 144366,  6, 0 } }, /* webhop */
    { .label = { 154733,  5, 0 } }, /* ddnss */
    { .label = {   1493,  2, 1 } }, { .child = { 7323, 55 } }, /* eu */
    { .label = { 107821,  8, 0 } }, /* hepforge */
    { .label = {   2893,  2, 0 } }, /* js */
    { .label = {  26910, 14, 0 } }, /* bmoattachments */
    { .label = {  58471, 11, 0 } }, /* cable-modem */
    { .label = {  71229, 10, 0 } }, /* collegefan */
    { .label = {  13913, 16, 0 } }, /* couchpotatofries */
    { .label = { 144589,  6, 0 } }, /* mlbfan */
    { .label = {  13984, 16, 0 } }, /* mysecuritycamera */
    { .label = { 144643,  6, 0 } }, /* nflfan */
    { .label = {  71548, 10, 0 } }, /* read-books */
    { .label = { 144725,  6, 0 } }, /* ufcfan */
    { .label = { 154909,  5, 0 } }, /* hopto */
    { .label = { 154982,  5, 0 } }, /* myftp */
    { .label = { 154959,  5, 0 } }, /* no-ip */
    { .label = { 155035,  5, 0 } }, /* zapto */
    { .label = {  58771, 11, 0 } }, /* my-firewall */
    { .label = {  71818, 10, 0 } }, /* myfirewall */
    { .label = { 155136,  5, 0 } }, /* spdns */
    { .label = { 128545,  7, 0 } }, /* dsmynas */
    { .label = { 108486,  8, 0 } }, /* familyds */
    { .label = {  88280,  9, 0 } }, /* tuxfamily */
    { .label = {   1313,  2, 0 } }, /* hk */
    { .label = { 128610,  7, 0 } }, /* wmflabs */
    { .label = {    395,  2, 0 } }, /* za */

    /* entries 7316 to 7317 */
    { .label = {     44,  1, 0 } }, /* c */
    { .label = {   6596,  3, 0 } }, /* rsc */

    /* entries 7318 to 7319 */
    { .label = { 124545,  6, 1 } }, { .child = { 7320, 1 } }, /* origin */

    /* entry 7320 */
    { .label = {   3193,  3, 0 } }, /* ssl */

    /* entries 7321 to 7322 */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {  20156,  4, 0 } }, /* home */

    /* entries 7323 to 7377 */
    { .label = {     11,  2, 0 } }, /* al */
    { .label = {   1443,  4, 0 } }, /* asso */
    { .label = {    145,  2, 0 } }, /* at */
    { .label = {    397,  2, 0 } }, /* au */
    { .label = {    608,  2, 0 } }, /* be */
    { .label = {   4210,  2, 0 } }, /* bg */
    { .label = {    135,  2, 0 } }, /* ca */
    { .label = {    183,  2, 0 } }, /* cd */
    { .label = {    192,  2, 0 } }, /* ch */
    { .label = {   1484,  2, 0 } }, /* cn */
    { .label = {   6986,  2, 0 } }, /* cy */
    { .label = {   6751,  2, 0 } }, /* cz */
    { .label = {     46,  2, 0 } }, /* de */
    { .label = {    504,  2, 0 } }, /* dk */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {    574,  2, 0 } }, /* ee */
    { .label = {    143,  2, 0 } }, /* es */
    { .label = {   2245,  2, 0 } }, /* fi */
    { .label = {    229,  2, 0 } }, /* fr */
    { .label = {   1209,  2, 0 } }, /* gr */
    { .label = {    101,  2, 0 } }, /* hr */
    { .label = {   1315,  2, 0 } }, /* hu */
    { .label = {     19,  2, 0 } }, /* ie */
    { .label = {   2118,  2, 0 } }, /* il */
    { .label = {    654,  2, 0 } }, /* in */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {    262,  2, 0 } }, /* is */
    { .label = {     41,  2, 0 } }, /* it */
    { .label = {    585,  2, 0 } }, /* jp */
    { .label = {    437,  2, 0 } }, /* kr */
    { .label = {    213,  2, 0 } }, /* lt */
    { .label = {    645,  2, 0 } }, /* lu */
    { .label = {   2353,  2, 0 } }, /* lv */
    { .label = {   7969,  2, 0 } }, /* mc */
    { .label = {    123,  2, 0 } }, /* me */
    { .label = {    651,  2, 0 } }, /* mk */
    { .label = {   1355,  2, 0 } }, /* mt */
    { .label = {   1538,  2, 0 } }, /* my */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {    190,  2, 0 } }, /* ng */
    { .label = {    243,  2, 0 } }, /* nl */
    { .label = {    154,  2, 0 } }, /* no */
    { .label = {   1299,  2, 0 } }, /* nz */
    { .label = {  39028,  5, 0 } }, /* paris */
    { .label = {  12277,  2, 0 } }, /* pl */
    { .label = {    545,  2, 0 } }, /* pt */
    { .label = {  70073,  3, 0 } }, /* q-a */
    { .label = {    465,  2, 0 } }, /* ro */
    { .label = {    206,  2, 0 } }, /* ru */
    { .label = {     54,  2, 0 } }, /* se */
    { .label = {    623,  2, 0 } }, /* si */
    { .label = {   1742,  2, 0 } }, /* sk */
    { .label = {   1020,  2, 0 } }, /* tr */
    { .label = {   2425,  2, 0 } }, /* uk */
    { .label = {   1354,  2, 0 } }, /* us */

    /* entries 7378 to 7388 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   9415,  3, 0 } }, /* sld */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   7246,  3, 0 } }, /* ing */
    { .label = {   3583,  3, 0 } }, /* abo */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {  20962,  3, 0 } }, /* nom */

    /* entries 7389 to 7396 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7397 to 7399 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */

    /* entry 7400 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 7401 to 7408 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7233,  3, 0 } }, /* ngo */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {      1,  1, 0 } }, /* i */

    /* entries 7409 to 7422 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   1825,  3, 0 } }, /* fam */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {  26804,  3, 0 } }, /* web */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {  33495,  3, 0 } }, /* gok */
    { .label = {  43867,  3, 0 } }, /* gon */
    { .label = {  52271,  3, 0 } }, /* gop */
    { .label = {   2130,  3, 0 } }, /* gos */
    { .label = { 107696,  4, 0 } }, /* info */

    /* entries 7423 to 7589 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    364,  3, 0 } }, /* aid */
    { .label = {  10135,  4, 0 } }, /* agro */
    { .label = {   5006,  3, 0 } }, /* atm */
    { .label = {  63476,  4, 0 } }, /* auto */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = { 151029,  5, 0 } }, /* gmina */
    { .label = {  68795,  3, 0 } }, /* gsm */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  34755,  4, 0 } }, /* mail */
    { .label = { 139822,  6, 0 } }, /* miasta */
    { .label = {  87923,  5, 0 } }, /* media */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  32354, 13, 0 } }, /* nieruchomosci */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {   1377,  2, 0 } }, /* pc */
    { .label = { 139845,  6, 0 } }, /* powiat */
    { .label = {    665,  4, 0 } }, /* priv */
    { .label = {  66547, 10, 0 } }, /* realestate */
    { .label = {   3276,  3, 0 } }, /* rel */
    { .label = {     54,  3, 0 } }, /* sex */
    { .label = {  45280,  4, 0 } }, /* shop */
    { .label = { 151050,  5, 0 } }, /* sklep */
    { .label = {  10119,  3, 0 } }, /* sos */
    { .label = { 139873,  6, 0 } }, /* szkola */
    { .label = { 151074,  5, 0 } }, /* targi */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = { 120369,  7, 0 } }, /* tourism */
    { .label = {   7132,  6, 0 } }, /* travel */
    { .label = {  83130,  9, 0 } }, /* turystyka */
    { .label = {   2349,  3, 1 } }, { .child = { 7590, 47 } }, /* gov */
    { .label = { 102371,  8, 0 } }, /* augustow */
    { .label = {  66586, 10, 0 } }, /* babia-gora */
    { .label = { 139936,  6, 0 } }, /* bedzin */
    { .label = { 120399,  7, 0 } }, /* beskidy */
    { .label = {  66627, 10, 0 } }, /* bialowieza */
    { .label = {  83209,  9, 0 } }, /* bialystok */
    { .label = { 120432,  7, 0 } }, /* bielawa */
    { .label = {  66673, 10, 0 } }, /* bieszczady */
    { .label = {  52172, 11, 0 } }, /* boleslawiec */
    { .label = {  83249,  9, 0 } }, /* bydgoszcz */
    { .label = { 151175,  5, 0 } }, /* bytom */
    { .label = { 120463,  7, 0 } }, /* cieszyn */
    { .label = { 120497,  7, 0 } }, /* czeladz */
    { .label = { 151199,  5, 0 } }, /* czest */
    { .label = {  83297,  9, 0 } }, /* dlugoleka */
    { .label = { 139965,  6, 0 } }, /* elblag */
    { .label = {  24201,  3, 0 } }, /* elk */
    { .label = { 139992,  6, 0 } }, /* glogow */
    { .label = { 120533,  7, 0 } }, /* gniezno */
    { .label = { 120565,  7, 0 } }, /* gorlice */
    { .label = { 120596,  7, 0 } }, /* grajewo */
    { .label = { 151223,  5, 0 } }, /* ilawa */
    { .label = { 102408,  8, 0 } }, /* jaworzno */
    { .label = {  41837, 12, 0 } }, /* jelenia-gora */
    { .label = { 151245,  5, 0 } }, /* jgora */
    { .label = { 140022,  6, 0 } }, /* kalisz */
    { .label = {  18390, 15, 0 } }, /* kazimierz-dolny */
    { .label = { 120630,  7, 0 } }, /* karpacz */
    { .label = { 120663,  7, 0 } }, /* kartuzy */
    { .label = { 120697,  7, 0 } }, /* kaszuby */
    { .label = { 102448,  8, 0 } }, /* katowice */
    { .label = { 151268,  5, 0 } }, /* kepno */
    { .label = { 120732,  7, 0 } }, /* ketrzyn */
    { .label = { 120766,  7, 0 } }, /* klodzko */
    { .label = {  66723, 10, 0 } }, /* kobierzyce */
    { .label = {  83338,  9, 0 } }, /* kolobrzeg */
    { .label = { 151291,  5, 0 } }, /* konin */
    { .label = {  66771, 10, 0 } }, /* konskowola */
    { .label = { 151312,  5, 0 } }, /* kutno */
    { .label = { 156518,  4, 0 } }, /* lapy */
    { .label = { 140050,  6, 0 } }, /* lebork */
    { .label = { 120801,  7, 0 } }, /* legnica */
    { .label = { 120831,  7, 0 } }, /* lezajsk */
    { .label = { 102484,  8, 0 } }, /* limanowa */
    { .label = { 151334,  5, 0 } }, /* lomza */
    { .label = { 140077,  6, 0 } }, /* lowicz */
    { .label = { 151358,  5, 0 } }, /* lubin */
    { .label = { 151381,  5, 0 } }, /* lukow */
    { .label = { 120866,  7, 0 } }, /* malbork */
    { .label = {  66816, 10, 0 } }, /* malopolska */
    { .label = { 102519,  8, 0 } }, /* mazowsze */
    { .label = { 140109,  6, 0 } }, /* mazury */
    { .label = { 140139,  6, 0 } }, /* mielec */
    { .label = { 140166,  6, 0 } }, /* mielno */
    { .label = { 120897,  7, 0 } }, /* mragowo */
    { .label = { 151407,  5, 0 } }, /* naklo */
    { .label = { 102560,  8, 0 } }, /* nowaruda */
    { .label = {  40225,  4, 0 } }, /* nysa */
    { .label = { 151428,  5, 0 } }, /* olawa */
    { .label = { 140192,  6, 0 } }, /* olecko */
    { .label = { 140219,  6, 0 } }, /* olkusz */
    { .label = { 120929,  7, 0 } }, /* olsztyn */
    { .label = { 120963,  7, 0 } }, /* opoczno */
    { .label = { 151450,  5, 0 } }, /* opole */
    { .label = { 120997,  7, 0 } }, /* ostroda */
    { .label = {  83381,  9, 0 } }, /* ostroleka */
    { .label = {  83418,  9, 0 } }, /* ostrowiec */
    { .label = {  66860, 10, 0 } }, /* ostrowwlkp */
    { .label = {  82112,  4, 0 } }, /* pila */
    { .label = { 156538,  4, 0 } }, /* pisz */
    { .label = { 121025,  7, 0 } }, /* podhale */
    { .label = { 102595,  8, 0 } }, /* podlasie */
    { .label = {  83458,  9, 0 } }, /* polkowice */
    { .label = { 121057,  7, 0 } }, /* pomorze */
    { .label = {  83502,  9, 0 } }, /* pomorskie */
    { .label = {  66910, 10, 0 } }, /* prochowice */
    { .label = { 102630,  8, 0 } }, /* pruszkow */
    { .label = {  83542,  9, 0 } }, /* przeworsk */
    { .label = { 140249,  6, 0 } }, /* pulawy */
    { .label = { 151473,  5, 0 } }, /* radom */
    { .label = { 102672,  8, 0 } }, /* rawa-maz */
    { .label = { 140281,  6, 0 } }, /* rybnik */
    { .label = { 121091,  7, 0 } }, /* rzeszow */
    { .label = {  76787,  5, 0 } }, /* sanok */
    { .label = { 151494,  5, 0 } }, /* sejny */
    { .label = { 151519,  5, 0 } }, /* slask */
    { .label = { 140309,  6, 0 } }, /* slupsk */
    { .label = {  83587,  9, 0 } }, /* sosnowiec */
    { .label = {  41889, 12, 0 } }, /* stalowa-wola */
    { .label = { 121128,  7, 0 } }, /* skoczow */
    { .label = {  41943, 12, 0 } }, /* starachowice */
    { .label = { 102709,  8, 0 } }, /* stargard */
    { .label = { 121164,  7, 0 } }, /* suwalki */
    { .label = { 102741,  8, 0 } }, /* swidnica */
    { .label = {  66958, 10, 0 } }, /* swiebodzin */
    { .label = {  52222, 11, 0 } }, /* swinoujscie */
    { .label = { 102777,  8, 0 } }, /* szczecin */
    { .label = { 102817,  8, 0 } }, /* szczytno */
    { .label = {  67006, 10, 0 } }, /* tarnobrzeg */
    { .label = { 151540,  5, 0 } }, /* tgory */
    { .label = { 151563,  5, 0 } }, /* turek */
    { .label = { 151585,  5, 0 } }, /* tychy */
    { .label = { 151611,  5, 0 } }, /* ustka */
    { .label = {  83627,  9, 0 } }, /* walbrzych */
    { .label = { 140338,  6, 0 } }, /* warmia */
    { .label = { 102858,  8, 0 } }, /* warszawa */
    { .label = { 112796,  3, 0 } }, /* waw */
    { .label = { 140364,  6, 0 } }, /* wegrow */
    { .label = { 140395,  6, 0 } }, /* wielun */
    { .label = {  83674,  5, 0 } }, /* wlocl */
    { .label = {  83674,  9, 0 } }, /* wloclawek */
    { .label = {  83719,  9, 0 } }, /* wodzislaw */
    { .label = { 121197,  7, 0 } }, /* wolomin */
    { .label = { 121230,  7, 0 } }, /* wroclaw */
    { .label = {  83765,  9, 0 } }, /* zachpomor */
    { .label = { 151632,  5, 0 } }, /* zagan */
    { .label = { 151654,  5, 0 } }, /* zarow */
    { .label = { 151679,  5, 0 } }, /* zgora */
    { .label = {  83808,  9, 0 } }, /* zgorzelec */
    { .label = { 158121,  4, 0 } }, /* beep */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {   7810,  3, 0 } }, /* art */
    { .label = { 128445,  7, 0 } }, /* gliwice */
    { .label = { 144754,  6, 0 } }, /* krakow */
    { .label = { 144782,  6, 0 } }, /* poznan */
    { .label = { 121230,  4, 0 } }, /* wroc */
    { .label = { 108234,  8, 0 } }, /* zakopane */
    { .label = {  41008,  3, 0 } }, /* gda */
    { .label = { 144917,  6, 0 } }, /* gdansk */
    { .label = { 144943,  6, 0 } }, /* gdynia */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = { 155187,  5, 0 } }, /* sopot */

    /* entries 7590 to 7636 */
    { .label = {    505,  2, 0 } }, /* ap */
    { .label = {    131,  2, 0 } }, /* ic */
    { .label = {    262,  2, 0 } }, /* is */
    { .label = {   1354,  2, 0 } }, /* us */
    { .label = { 151094,  5, 0 } }, /* kmpsp */
    { .label = { 151120,  5, 0 } }, /* kppsp */
    { .label = { 151147,  5, 0 } }, /* kwpsp */
    { .label = {  49626,  3, 0 } }, /* psp */
    { .label = { 156278,  4, 0 } }, /* wskr */
    { .label = { 151147,  3, 0 } }, /* kwp */
    { .label = {   2064,  2, 0 } }, /* mw */
    { .label = {   3316,  2, 0 } }, /* ug */
    { .label = {   2940,  2, 0 } }, /* um */
    { .label = {  48700,  4, 0 } }, /* umig */
    { .label = { 156298,  4, 0 } }, /* ugim */
    { .label = { 156317,  4, 0 } }, /* upow */
    { .label = {   3306,  2, 0 } }, /* uw */
    { .label = {  83171,  9, 0 } }, /* starostwo */
    { .label = {    592,  2, 0 } }, /* pa */
    { .label = {    326,  2, 0 } }, /* po */
    { .label = { 156339,  4, 0 } }, /* psse */
    { .label = { 158591,  3, 0 } }, /* pup */
    { .label = { 156357,  4, 0 } }, /* rzgw */
    { .label = {     43,  2, 0 } }, /* sa */
    { .label = {    940,  2, 0 } }, /* so */
    { .label = {    182,  2, 0 } }, /* sr */
    { .label = {  15465,  3, 0 } }, /* wsa */
    { .label = {   2128,  3, 0 } }, /* sko */
    { .label = {  80105,  3, 0 } }, /* uzs */
    { .label = { 156380,  4, 0 } }, /* wiih */
    { .label = { 156400,  4, 0 } }, /* winb */
    { .label = { 156420,  4, 0 } }, /* pinb */
    { .label = { 156439,  4, 0 } }, /* wios */
    { .label = { 156458,  4, 0 } }, /* witd */
    { .label = { 139901,  6, 0 } }, /* wzmiuw */
    { .label = { 121187,  3, 0 } }, /* piw */
    { .label = { 156267,  3, 0 } }, /* wiw */
    { .label = {  51503,  4, 0 } }, /* griw */
    { .label = {  68750,  3, 0 } }, /* wif */
    { .label = {   6301,  3, 0 } }, /* oum */
    { .label = {  16510,  3, 0 } }, /* sdn */
    { .label = {   3210,  2, 0 } }, /* zp */
    { .label = { 125158,  4, 0 } }, /* uppo */
    { .label = {   2709,  3, 0 } }, /* mup */
    { .label = { 156478,  4, 0 } }, /* wuoz */
    { .label = { 102337,  8, 0 } }, /* konsulat */
    { .label = { 156501,  4, 0 } }, /* oirm */

    /* entries 7637 to 7641 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */

    /* entries 7642 to 7654 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  29334,  4, 0 } }, /* isla */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {    926,  3, 0 } }, /* est */
    { .label = { 156559,  4, 0 } }, /* prof */
    { .label = {    189,  2, 0 } }, /* ac */

    /* entries 7655 to 7666 */
    { .label = {   1350,  3, 0 } }, /* aaa */
    { .label = {   2225,  3, 0 } }, /* aca */
    { .label = {  47929,  4, 0 } }, /* acct */
    { .label = { 128770,  6, 0 } }, /* avocat */
    { .label = {   1610,  3, 0 } }, /* bar */
    { .label = {   1395,  3, 0 } }, /* cpa */
    { .label = {   1417,  3, 0 } }, /* eng */
    { .label = {  54607,  3, 0 } }, /* jur */
    { .label = {  16294,  3, 0 } }, /* law */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = { 151702,  5, 0 } }, /* recht */
    { .label = { 125863,  7, 0 } }, /* cloudns */

    /* entries 7667 to 7673 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13995,  3, 0 } }, /* sec */
    { .label = { 114815,  3, 0 } }, /* plo */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */

    /* entries 7674 to 7682 */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  19990,  4, 0 } }, /* publ */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  20962,  4, 0 } }, /* nome */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7683 to 7689 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    203,  2, 0 } }, /* ne */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {    204,  2, 0 } }, /* ed */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = { 151724,  5, 0 } }, /* belau */
    { .label = { 125863,  7, 0 } }, /* cloudns */

    /* entries 7690 to 7696 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 155301,  4, 0 } }, /* coop */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 7697 to 7705 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   4209,  3, 0 } }, /* sch */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7706 to 7709 */
    { .label = {   1443,  4, 0 } }, /* asso */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7710 to 7722 */
    { .label = {  11884,  4, 0 } }, /* arts */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 105297,  4, 0 } }, /* firm */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {    132,  2, 0 } }, /* nt */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    175,  3, 0 } }, /* rec */
    { .label = { 144991,  5, 0 } }, /* store */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = { 158453,  3, 0 } }, /* www */
    { .label = {  45280,  4, 0 } }, /* shop */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7723 to 7729 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {    654,  2, 0 } }, /* in */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7730 to 7860 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   4296,  2, 0 } }, /* pp */
    { .label = { 121265,  7, 0 } }, /* adygeya */
    { .label = { 151746,  5, 0 } }, /* altai */
    { .label = {  57279,  4, 0 } }, /* amur */
    { .label = {  52274, 11, 0 } }, /* arkhangelsk */
    { .label = {  83853,  9, 0 } }, /* astrakhan */
    { .label = {  83888,  9, 0 } }, /* bashkiria */
    { .label = { 102896,  8, 0 } }, /* belgorod */
    { .label = {  20550,  3, 0 } }, /* bir */
    { .label = { 121297,  7, 0 } }, /* bryansk */
    { .label = { 102932,  8, 0 } }, /* buryatia */
    { .label = { 158608,  3, 0 } }, /* cbg */
    { .label = {  52321,  4, 0 } }, /* chel */
    { .label = {  52321, 11, 0 } }, /* chelyabinsk */
    { .label = {  91436,  5, 0 } }, /* chita */
    { .label = { 102966,  8, 0 } }, /* chukotka */
    { .label = {  83925,  9, 0 } }, /* chuvashia */
    { .label = { 103002,  8, 0 } }, /* dagestan */
    { .label = { 121328,  7, 0 } }, /* dudinka */
    { .label = { 140424,  6, 0 } }, /* e-burg */
    { .label = { 140452,  6, 0 } }, /* grozny */
    { .label = { 121359,  7, 0 } }, /* irkutsk */
    { .label = { 121390,  7, 0 } }, /* ivanovo */
    { .label = { 121421,  7, 0 } }, /* izhevsk */
    { .label = {  22863,  3, 0 } }, /* jar */
    { .label = {  52371, 11, 0 } }, /* joshkar-ola */
    { .label = { 103034,  8, 0 } }, /* kalmykia */
    { .label = { 140482,  6, 0 } }, /* kaluga */
    { .label = {  83965,  9, 0 } }, /* kamchatka */
    { .label = { 121456,  7, 0 } }, /* karelia */
    { .label = { 151765,  5, 0 } }, /* kazan */
    { .label = { 156579,  4, 0 } }, /* kchr */
    { .label = { 103070,  8, 0 } }, /* kemerovo */
    { .label = {  67050, 10, 0 } }, /* khabarovsk */
    { .label = {  84003,  9, 0 } }, /* khakassia */
    { .label = {  52464,  3, 0 } }, /* khv */
    { .label = {  67229,  5, 0 } }, /* kirov */
    { .label = { 140508,  6, 0 } }, /* koenig */
    { .label = { 156598,  4, 0 } }, /* komi */
    { .label = { 103106,  8, 0 } }, /* kostroma */
    { .label = {  52420, 11, 0 } }, /* krasnoyarsk */
    { .label = { 151787,  5, 0 } }, /* kuban */
    { .label = { 140534,  6, 0 } }, /* kurgan */
    { .label = { 151809,  5, 0 } }, /* kursk */
    { .label = { 121484,  7, 0 } }, /* lipetsk */
    { .label = { 121516,  7, 0 } }, /* magadan */
    { .label = {  28600,  4, 0 } }, /* mari */
    { .label = { 121544,  7, 0 } }, /* mari-el */
    { .label = { 140560,  6, 0 } }, /* marine */
    { .label = { 103139,  8, 0 } }, /* mordovia */
    { .label = {  23785,  3, 0 } }, /* msk */
    { .label = { 103174,  8, 0 } }, /* murmansk */
    { .label = { 121574,  7, 0 } }, /* nalchik */
    { .label = { 156616,  4, 0 } }, /* nnov */
    { .label = {  25021,  3, 0 } }, /* nov */
    { .label = {  52466, 11, 0 } }, /* novosibirsk */
    { .label = {   8980,  3, 0 } }, /* nsk */
    { .label = { 119764,  4, 0 } }, /* omsk */
    { .label = { 103209,  8, 0 } }, /* orenburg */
    { .label = { 151832,  5, 0 } }, /* oryol */
    { .label = { 140584,  6, 0 } }, /* palana */
    { .label = { 151855,  5, 0 } }, /* penza */
    { .label = { 138722,  4, 0 } }, /* perm */
    { .label = { 115870,  3, 0 } }, /* ptz */
    { .label = {  27868,  3, 0 } }, /* rnd */
    { .label = { 140608,  6, 0 } }, /* ryazan */
    { .label = {   8951,  8, 0 } }, /* sakhalin */
    { .label = { 140635,  6, 0 } }, /* samara */
    { .label = { 121605,  7, 0 } }, /* saratov */
    { .label = { 103244,  8, 0 } }, /* simbirsk */
    { .label = { 103279,  8, 0 } }, /* smolensk */
    { .label = {  18272,  3, 0 } }, /* spb */
    { .label = {  84039,  9, 0 } }, /* stavropol */
    { .label = {   8857,  3, 0 } }, /* stv */
    { .label = { 140657,  6, 0 } }, /* surgut */
    { .label = { 140684,  6, 0 } }, /* tambov */
    { .label = {  84079,  9, 0 } }, /* tatarstan */
    { .label = {    109,  3, 0 } }, /* tom */
    { .label = { 151879,  5, 0 } }, /* tomsk */
    { .label = {  84112,  9, 0 } }, /* tsaritsyn */
    { .label = {  42099,  3, 0 } }, /* tsk */
    { .label = { 156634,  4, 0 } }, /* tula */
    { .label = { 156651,  4, 0 } }, /* tuva */
    { .label = { 156669,  4, 0 } }, /* tver */
    { .label = { 140711,  6, 0 } }, /* tyumen */
    { .label = {  18389,  3, 0 } }, /* udm */
    { .label = { 103314,  8, 0 } }, /* udmurtia */
    { .label = { 103349,  8, 0 } }, /* ulan-ude */
    { .label = {  52514, 11, 0 } }, /* vladikavkaz */
    { .label = { 103385,  8, 0 } }, /* vladimir */
    { .label = {  52566, 11, 0 } }, /* vladivostok */
    { .label = {  84149,  9, 0 } }, /* volgograd */
    { .label = { 121633,  7, 0 } }, /* vologda */
    { .label = { 103421,  8, 0 } }, /* voronezh */
    { .label = {  78807,  3, 0 } }, /* vrn */
    { .label = { 140739,  6, 0 } }, /* vyatka */
    { .label = { 121665,  7, 0 } }, /* yakutia */
    { .label = { 151901,  5, 0 } }, /* yamal */
    { .label = {  84190,  9, 0 } }, /* yaroslavl */
    { .label = {  32411, 13, 0 } }, /* yekaterinburg */
    { .label = {   8915, 17, 0 } }, /* yuzhno-sakhalinsk */
    { .label = { 140766,  6, 0 } }, /* amursk */
    { .label = { 140792,  6, 0 } }, /* baikal */
    { .label = {  31492,  3, 0 } }, /* cmw */
    { .label = { 121695,  7, 0 } }, /* fareast */
    { .label = { 151923,  5, 0 } }, /* jamal */
    { .label = {   5228,  3, 0 } }, /* kms */
    { .label = { 103459,  8, 0 } }, /* k-uralsk */
    { .label = { 103495,  8, 0 } }, /* kustanai */
    { .label = { 121723,  7, 0 } }, /* kuzbass */
    { .label = { 151946,  5, 0 } }, /* mytis */
    { .label = { 103527,  8, 0 } }, /* nakhodka */
    { .label = {  29564,  3, 0 } }, /* nkz */
    { .label = { 121756,  7, 0 } }, /* norilsk */
    { .label = { 149309,  5, 0 } }, /* oskol */
    { .label = {  67094, 10, 0 } }, /* pyatigorsk */
    { .label = {  84230,  9, 0 } }, /* rubtsovsk */
    { .label = {  81448,  3, 0 } }, /* snz */
    { .label = { 140817,  6, 0 } }, /* syzran */
    { .label = { 140845,  6, 0 } }, /* vdonsk */
    { .label = { 151969,  5, 0 } }, /* zgrad */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13360,  4, 0 } }, /* test */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7861 to 7869 */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = { 155281,  4, 0 } }, /* gouv */

    /* entries 7870 to 7877 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {  19990,  3, 0 } }, /* pub */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   4209,  3, 0 } }, /* sch */

    /* entries 7878 to 7882 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 7883 to 7887 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */

    /* entries 7888 to 7895 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   4147,  3, 0 } }, /* med */
    { .label = {     55,  2, 0 } }, /* tv */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107696,  4, 0 } }, /* info */

    /* entries 7896 to 7936 */
    { .label = {      6,  1, 0 } }, /* a */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {    134,  1, 0 } }, /* b */
    { .label = {   2741,  2, 0 } }, /* bd */
    { .label = {  11416,  5, 0 } }, /* brand */
    { .label = {     44,  1, 0 } }, /* c */
    { .label = {     46,  1, 0 } }, /* d */
    { .label = {      9,  1, 0 } }, /* e */
    { .label = {     96,  1, 0 } }, /* f */
    { .label = {   3223,  2, 0 } }, /* fh */
    { .label = { 156687,  4, 0 } }, /* fhsk */
    { .label = { 129276,  3, 0 } }, /* fhv */
    { .label = {    137,  1, 0 } }, /* g */
    { .label = {     68,  1, 0 } }, /* h */
    { .label = {      1,  1, 0 } }, /* i */
    { .label = {    211,  1, 0 } }, /* k */
    { .label = { 121786,  7, 0 } }, /* komforb */
    { .label = {  18462, 15, 0 } }, /* kommunalforbund */
    { .label = { 140873,  6, 0 } }, /* komvux */
    { .label = {      2,  1, 0 } }, /* l */
    { .label = { 140904,  6, 0 } }, /* lanbib */
    { .label = {      5,  1, 0 } }, /* m */
    { .label = {      8,  1, 0 } }, /* n */
    { .label = {  24245, 14, 0 } }, /* naturbruksgymn */
    { .label = {      3,  1, 0 } }, /* o */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    326,  1, 0 } }, /* p */
    { .label = { 151993,  5, 0 } }, /* parti */
    { .label = {   4296,  2, 0 } }, /* pp */
    { .label = {  18801,  5, 0 } }, /* press */
    { .label = {     22,  1, 0 } }, /* r */
    { .label = {     43,  1, 0 } }, /* s */
    { .label = {     45,  1, 0 } }, /* t */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = {    122,  1, 0 } }, /* u */
    { .label = {    120,  1, 0 } }, /* w */
    { .label = {     10,  1, 0 } }, /* x */
    { .label = {     28,  1, 0 } }, /* y */
    { .label = {    116,  1, 0 } }, /* z */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7937 to 7943 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   3378,  3, 0 } }, /* per */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7944 to 7952 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = { 106813,  8, 1 } }, { .child = { 7953, 1 } }, /* platform */
    { .label = { 107787,  8, 0 } }, /* hashbang */
    { .label = {   3319,  3, 0 } }, /* now */

    /* entry 7953 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 7954 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entry 7955 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7956 to 7960 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 7961 to 7968 */
    { .label = {   7810,  3, 0 } }, /* art */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = { 155281,  4, 0 } }, /* gouv */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   3378,  5, 0 } }, /* perso */
    { .label = {  65077,  4, 0 } }, /* univ */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 7969 to 7971 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 7972 to 7983 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  84271,  9, 0 } }, /* consulado */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  84310,  9, 0 } }, /* embaixada */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 103561,  8, 0 } }, /* principe */
    { .label = { 121819,  7, 0 } }, /* saotome */
    { .label = { 144991,  5, 0 } }, /* store */

    /* entries 7984 to 8015 */
    { .label = { 121265,  7, 0 } }, /* adygeya */
    { .label = {  52274, 11, 0 } }, /* arkhangelsk */
    { .label = { 103598,  8, 0 } }, /* balashov */
    { .label = {  83888,  9, 0 } }, /* bashkiria */
    { .label = { 121297,  7, 0 } }, /* bryansk */
    { .label = { 103002,  8, 0 } }, /* dagestan */
    { .label = { 140452,  6, 0 } }, /* grozny */
    { .label = { 121390,  7, 0 } }, /* ivanovo */
    { .label = { 103034,  8, 0 } }, /* kalmykia */
    { .label = { 140482,  6, 0 } }, /* kaluga */
    { .label = { 121456,  7, 0 } }, /* karelia */
    { .label = {  84003,  9, 0 } }, /* khakassia */
    { .label = {  84348,  9, 0 } }, /* krasnodar */
    { .label = { 140534,  6, 0 } }, /* kurgan */
    { .label = { 152014,  5, 0 } }, /* lenug */
    { .label = { 103139,  8, 0 } }, /* mordovia */
    { .label = {  23785,  3, 0 } }, /* msk */
    { .label = { 103174,  8, 0 } }, /* murmansk */
    { .label = { 121574,  7, 0 } }, /* nalchik */
    { .label = {  25021,  3, 0 } }, /* nov */
    { .label = { 121847,  7, 0 } }, /* obninsk */
    { .label = { 151855,  5, 0 } }, /* penza */
    { .label = { 103633,  8, 0 } }, /* pokrovsk */
    { .label = { 152037,  5, 0 } }, /* sochi */
    { .label = {  18272,  3, 0 } }, /* spb */
    { .label = {  84384,  9, 0 } }, /* togliatti */
    { .label = { 121877,  7, 0 } }, /* troitsk */
    { .label = { 156634,  4, 0 } }, /* tula */
    { .label = { 156651,  4, 0 } }, /* tuva */
    { .label = {  52514, 11, 0 } }, /* vladikavkaz */
    { .label = { 103385,  8, 0 } }, /* vladimir */
    { .label = { 121633,  7, 0 } }, /* vologda */

    /* entries 8016 to 8020 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   3487,  3, 0 } }, /* red */

    /* entry 8021 */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entries 8022 to 8027 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 8028 to 8030 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entry 8031 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 8032 to 8038 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {    654,  2, 0 } }, /* in */
    { .label = {    639,  2, 0 } }, /* mi */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {     49,  2, 0 } }, /* or */

    /* entries 8039 to 8053 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {    127,  3, 0 } }, /* nic */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13360,  4, 0 } }, /* test */
    { .label = {  26804,  3, 0 } }, /* web */

    /* entry 8054 */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entries 8055 to 8062 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  37716,  3, 0 } }, /* edu */

    /* entries 8063 to 8082 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {    228,  3, 0 } }, /* ens */
    { .label = {   2422,  3, 0 } }, /* fin */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   6047,  3, 0 } }, /* ind */
    { .label = {  64788,  4, 0 } }, /* intl */
    { .label = {   2863,  3, 0 } }, /* nat */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {   3378,  5, 0 } }, /* perso */
    { .label = { 120369,  7, 0 } }, /* tourism */
    { .label = { 140930,  6, 0 } }, /* edunet */
    { .label = { 123456,  4, 0 } }, /* rnrt */
    { .label = {   7002,  3, 0 } }, /* rns */
    { .label = {   5523,  3, 0 } }, /* rnu */
    { .label = { 140956,  6, 0 } }, /* mincom */
    { .label = { 121906,  7, 0 } }, /* agrinet */
    { .label = { 121934,  7, 0 } }, /* defense */
    { .label = { 152059,  5, 0 } }, /* turen */

    /* entries 8083 to 8088 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  20570,  3, 0 } }, /* mil */

    /* entries 8089 to 8111 */
    { .label = {    108,  3, 1 } }, { .child = { 8112, 1 } }, /* com */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  26804,  3, 0 } }, /* web */
    { .label = {    591,  3, 0 } }, /* gen */
    { .label = {     55,  2, 0 } }, /* tv */
    { .label = {    667,  2, 0 } }, /* av */
    { .label = {    763,  2, 0 } }, /* dr */
    { .label = {   5292,  3, 0 } }, /* bbs */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {     91,  3, 0 } }, /* tel */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  24196,  3, 0 } }, /* bel */
    { .label = {  37575,  3, 0 } }, /* pol */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  29749,  3, 0 } }, /* kep */
    { .label = {    313,  2, 1 } }, { .child = { 8113, 1 } }, /* nc */

    /* entry 8112 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entry 8113 */
    { .label = {   2349,  3, 0 } }, /* gov */

    /* entries 8114 to 8130 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = { 155301,  4, 0 } }, /* coop */
    { .label = { 155432,  4, 0 } }, /* jobs */
    { .label = {   7413,  4, 0 } }, /* mobi */
    { .label = {   7132,  6, 0 } }, /* travel */
    { .label = {   2922,  6, 0 } }, /* museum */
    { .label = {  72000,  4, 0 } }, /* aero */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */

    /* entries 8131 to 8134 */
    { .label = {  26057,  6, 0 } }, /* dyndns */
    { .label = {  57453, 11, 0 } }, /* better-than */
    { .label = {  70730, 10, 0 } }, /* on-the-web */
    { .label = {  70870, 10, 0 } }, /* worse-than */

    /* entries 8135 to 8148 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 158512,  3, 0 } }, /* idv */
    { .label = {  15283,  4, 0 } }, /* game */
    { .label = { 156707,  4, 0 } }, /* ebiz */
    { .label = {  88339,  4, 0 } }, /* club */
    { .label = {  41995, 12, 0 } }, /* xn--zf0ao64a */
    { .label = {  59872, 10, 0 } }, /* xn--uc0atv */
    { .label = {  52616, 11, 0 } }, /* xn--czrw28b */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 8149 to 8160 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {  54179,  5, 0 } }, /* hotel */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {    123,  2, 0 } }, /* me */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {   7413,  4, 0 } }, /* mobi */
    { .label = {    203,  2, 0 } }, /* ne */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {   3965,  2, 0 } }, /* sc */
    { .label = {     55,  2, 0 } }, /* tv */

    /* entries 8161 to 8239 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {    654,  2, 0 } }, /* in */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  84421,  9, 0 } }, /* cherkassy */
    { .label = { 103671,  8, 0 } }, /* cherkasy */
    { .label = {  84461,  9, 0 } }, /* chernigov */
    { .label = {  84502,  9, 0 } }, /* chernihiv */
    { .label = {  67139, 10, 0 } }, /* chernivtsi */
    { .label = {  67183, 10, 0 } }, /* chernovtsy */
    { .label = {   2744,  2, 0 } }, /* ck */
    { .label = {   1484,  2, 0 } }, /* cn */
    { .label = {   1019,  2, 0 } }, /* cr */
    { .label = { 140983,  6, 0 } }, /* crimea */
    { .label = {   8860,  2, 0 } }, /* cv */
    { .label = {   3132,  2, 0 } }, /* dn */
    { .label = {  24308, 14, 0 } }, /* dnepropetrovsk */
    { .label = {  24372, 14, 0 } }, /* dnipropetrovsk */
    { .label = { 121965,  7, 0 } }, /* dominic */
    { .label = { 121996,  7, 0 } }, /* donetsk */
    { .label = {   7377,  2, 0 } }, /* dp */
    { .label = {   3551,  2, 0 } }, /* if */
    { .label = {  18531, 15, 0 } }, /* ivano-frankivsk */
    { .label = {   1427,  2, 0 } }, /* kh */
    { .label = { 122026,  7, 0 } }, /* kharkiv */
    { .label = { 122058,  7, 0 } }, /* kharkov */
    { .label = { 122090,  7, 0 } }, /* kherson */
    { .label = {  42067, 12, 0 } }, /* khmelnitskiy */
    { .label = {  42122, 12, 0 } }, /* khmelnytskyi */
    { .label = { 156727,  4, 0 } }, /* kiev */
    { .label = {  67229, 10, 0 } }, /* kirovograd */
    { .label = {   2720,  2, 0 } }, /* km */
    { .label = {    437,  2, 0 } }, /* kr */
    { .label = { 156746,  4, 0 } }, /* krym */
    { .label = {    211,  2, 0 } }, /* ks */
    { .label = {   9334,  2, 0 } }, /* kv */
    { .label = { 156766,  4, 0 } }, /* kyiv */
    { .label = {   1106,  2, 0 } }, /* lg */
    { .label = {    213,  2, 0 } }, /* lt */
    { .label = { 122120,  7, 0 } }, /* lugansk */
    { .label = { 152080,  5, 0 } }, /* lutsk */
    { .label = {   2353,  2, 0 } }, /* lv */
    { .label = { 156787,  4, 0 } }, /* lviv */
    { .label = {    651,  2, 0 } }, /* mk */
    { .label = { 103707,  8, 0 } }, /* mykolaiv */
    { .label = { 103745,  8, 0 } }, /* nikolaev */
    { .label = {    616,  2, 0 } }, /* od */
    { .label = { 152103,  5, 0 } }, /* odesa */
    { .label = { 141008,  6, 0 } }, /* odessa */
    { .label = {  12277,  2, 0 } }, /* pl */
    { .label = { 122151,  7, 0 } }, /* poltava */
    { .label = { 152123,  5, 0 } }, /* rivne */
    { .label = { 152145,  5, 0 } }, /* rovno */
    { .label = {    181,  2, 0 } }, /* rv */
    { .label = {    604,  2, 0 } }, /* sb */
    { .label = {  67273, 10, 0 } }, /* sebastopol */
    { .label = {  67316, 10, 0 } }, /* sevastopol */
    { .label = {   1109,  2, 0 } }, /* sm */
    { .label = { 156808,  4, 0 } }, /* sumy */
    { .label = {     91,  2, 0 } }, /* te */
    { .label = { 103780,  8, 0 } }, /* ternopil */
    { .label = {   7223,  2, 0 } }, /* uz */
    { .label = { 103815,  8, 0 } }, /* uzhgorod */
    { .label = { 122182,  7, 0 } }, /* vinnica */
    { .label = {  84543,  9, 0 } }, /* vinnytsia */
    { .label = {    445,  2, 0 } }, /* vn */
    { .label = { 152167,  5, 0 } }, /* volyn */
    { .label = { 152192,  5, 0 } }, /* yalta */
    { .label = {  52683, 11, 0 } }, /* zaporizhzhe */
    { .label = {  42179, 12, 0 } }, /* zaporizhzhia */
    { .label = { 103854,  8, 0 } }, /* zhitomir */
    { .label = { 103891,  8, 0 } }, /* zhytomyr */
    { .label = {   3210,  2, 0 } }, /* zp */
    { .label = {  11371,  2, 0 } }, /* zt */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {   4296,  2, 0 } }, /* pp */

    /* entries 8240 to 8248 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {     49,  2, 0 } }, /* or */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {   3965,  2, 0 } }, /* sc */
    { .label = {   2130,  2, 0 } }, /* go */
    { .label = {    203,  2, 0 } }, /* ne */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 8249 to 8262 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {     44,  2, 1 } }, { .child = { 8263, 3 } }, /* co */
    { .label = {   2349,  3, 1 } }, { .child = { 8266, 1 } }, /* gov */
    { .label = {   5935,  3, 0 } }, /* ltd */
    { .label = {    123,  2, 0 } }, /* me */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  29734,  3, 0 } }, /* nhs */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 158527,  3, 0 } }, /* plc */
    { .label = { 141032,  6, 0 } }, /* police */
    { .label = {   4209,  3, 1 } }, { .child = { 8267, 1 } }, /* sch */

    /* entries 8263 to 8265 */
    { .label = { 107714,  8, 0 } }, /* blogspot */
    { .label = { 154959,  5, 0 } }, /* no-ip */
    { .label = {  35075, 13, 0 } }, /* wellbeingzone */

    /* entry 8266 */
    { .label = {  88494,  7, 0 } }, /* service */

    /* entry 8267 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8268 to 8390 */
    { .label = {   3132,  3, 0 } }, /* dni */
    { .label = {  59140,  3, 0 } }, /* fed */
    { .label = {   3730,  3, 0 } }, /* isa */
    { .label = {  50132,  4, 0 } }, /* kids */
    { .label = {   3237,  3, 0 } }, /* nsn */
    { .label = {    732,  2, 1 } }, { .child = { 8391, 3 } }, /* ak */
    { .label = {     11,  2, 1 } }, { .child = { 8394, 3 } }, /* al */
    { .label = {     47,  2, 1 } }, { .child = { 8397, 3 } }, /* ar */
    { .label = {    130,  2, 1 } }, { .child = { 8400, 3 } }, /* as */
    { .label = {   3288,  2, 1 } }, { .child = { 8403, 3 } }, /* az */
    { .label = {    135,  2, 1 } }, { .child = { 8406, 3 } }, /* ca */
    { .label = {     44,  2, 1 } }, { .child = { 8409, 3 } }, /* co */
    { .label = {    859,  2, 1 } }, { .child = { 8412, 3 } }, /* ct */
    { .label = {   6152,  2, 1 } }, { .child = { 8415, 3 } }, /* dc */
    { .label = {     46,  2, 1 } }, { .child = { 8418, 3 } }, /* de */
    { .label = {   2871,  2, 1 } }, { .child = { 8421, 3 } }, /* fl */
    { .label = {    323,  2, 1 } }, { .child = { 8424, 3 } }, /* ga */
    { .label = {   8694,  2, 1 } }, { .child = { 8427, 3 } }, /* gu */
    { .label = {    197,  2, 1 } }, { .child = { 8430, 2 } }, /* hi */
    { .label = {      7,  2, 1 } }, { .child = { 8432, 3 } }, /* ia */
    { .label = {     88,  2, 1 } }, { .child = { 8435, 3 } }, /* id */
    { .label = {   2118,  2, 1 } }, { .child = { 8438, 3 } }, /* il */
    { .label = {    654,  2, 1 } }, { .child = { 8441, 3 } }, /* in */
    { .label = {    211,  2, 1 } }, { .child = { 8444, 3 } }, /* ks */
    { .label = {   4120,  2, 1 } }, { .child = { 8447, 3 } }, /* ky */
    { .label = {     20,  2, 1 } }, { .child = { 8450, 3 } }, /* la */
    { .label = {    731,  2, 1 } }, { .child = { 8453, 3 } }, /* ma */
    { .label = {    139,  2, 1 } }, { .child = { 8460, 3 } }, /* md */
    { .label = {    123,  2, 1 } }, { .child = { 8463, 3 } }, /* me */
    { .label = {    639,  2, 1 } }, { .child = { 8466, 3 } }, /* mi */
    { .label = {    363,  2, 1 } }, { .child = { 8469, 3 } }, /* mn */
    { .label = {    221,  2, 1 } }, { .child = { 8472, 3 } }, /* mo */
    { .label = {    352,  2, 1 } }, { .child = { 8475, 3 } }, /* ms */
    { .label = {   1355,  2, 1 } }, { .child = { 8478, 3 } }, /* mt */
    { .label = {    313,  2, 1 } }, { .child = { 8481, 3 } }, /* nc */
    { .label = {     42,  2, 1 } }, { .child = { 8484, 2 } }, /* nd */
    { .label = {    203,  2, 1 } }, { .child = { 8486, 3 } }, /* ne */
    { .label = {    939,  2, 1 } }, { .child = { 8489, 3 } }, /* nh */
    { .label = {   6738,  2, 1 } }, { .child = { 8492, 3 } }, /* nj */
    { .label = {    473,  2, 1 } }, { .child = { 8495, 3 } }, /* nm */
    { .label = {    451,  2, 1 } }, { .child = { 8498, 3 } }, /* nv */
    { .label = {   1663,  2, 1 } }, { .child = { 8501, 3 } }, /* ny */
    { .label = {   1120,  2, 1 } }, { .child = { 8504, 3 } }, /* oh */
    { .label = {    433,  2, 1 } }, { .child = { 8507, 3 } }, /* ok */
    { .label = {     49,  2, 1 } }, { .child = { 8510, 3 } }, /* or */
    { .label = {    592,  2, 1 } }, { .child = { 8513, 3 } }, /* pa */
    { .label = {    436,  2, 1 } }, { .child = { 8516, 3 } }, /* pr */
    { .label = {    227,  2, 1 } }, { .child = { 8519, 3 } }, /* ri */
    { .label = {   3965,  2, 1 } }, { .child = { 8522, 3 } }, /* sc */
    { .label = {    500,  2, 1 } }, { .child = { 8525, 2 } }, /* sd */
    { .label = {   1485,  2, 1 } }, { .child = { 8527, 3 } }, /* tn */
    { .label = {    454,  2, 1 } }, { .child = { 8530, 3 } }, /* tx */
    { .label = {   1923,  2, 1 } }, { .child = { 8533, 3 } }, /* ut */
    { .label = {     59,  2, 1 } }, { .child = { 8536, 3 } }, /* vi */
    { .label = {  13354,  2, 1 } }, { .child = { 8539, 3 } }, /* vt */
    { .label = {    527,  2, 1 } }, { .child = { 8542, 3 } }, /* va */
    { .label = {   1560,  2, 1 } }, { .child = { 8545, 3 } }, /* wa */
    { .label = {    398,  2, 1 } }, { .child = { 8548, 3 } }, /* wi */
    { .label = {   3422,  2, 1 } }, { .child = { 8551, 1 } }, /* wv */
    { .label = {   6668,  2, 1 } }, { .child = { 8552, 3 } }, /* wy */
    { .label = { 125863,  7, 0 } }, /* cloudns */
    { .label = {  52541,  4, 0 } }, /* drud */
    { .label = { 154709,  5, 0 } }, /* is-by */
    { .label = {  58122, 11, 0 } }, /* land-4-sale */
    { .label = {  44778, 12, 0 } }, /* stuff-4-sale */
    { .label = { 128352,  7, 0 } }, /* golffan */
    { .label = { 158290,  4, 0 } }, /* noip */
    { .label = { 128415,  7, 0 } }, /* pointto */

    /* entries 8391 to 8393 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8394 to 8396 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8397 to 8399 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8400 to 8402 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8403 to 8405 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8406 to 8408 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8409 to 8411 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8412 to 8414 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8415 to 8417 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8418 to 8420 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8421 to 8423 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8424 to 8426 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8427 to 8429 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8430 to 8431 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8432 to 8434 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8435 to 8437 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8438 to 8440 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8441 to 8443 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8444 to 8446 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8447 to 8449 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8450 to 8452 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8453 to 8456 */
    { .label = { 158474,  3, 1 } }, { .child = { 8457, 3 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8457 to 8459 */
    { .label = { 158496,  3, 0 } }, /* pvt */
    { .label = { 156828,  4, 0 } }, /* chtr */
    { .label = { 141060,  6, 0 } }, /* paroch */

    /* entries 8460 to 8462 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8463 to 8465 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8466 to 8468 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8469 to 8471 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8472 to 8474 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8475 to 8477 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8478 to 8480 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8481 to 8483 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8484 to 8485 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8486 to 8488 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8489 to 8491 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8492 to 8494 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8495 to 8497 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8498 to 8500 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8501 to 8503 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8504 to 8506 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8507 to 8509 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8510 to 8512 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8513 to 8515 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8516 to 8518 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8519 to 8521 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8522 to 8524 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8525 to 8526 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8527 to 8529 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8530 to 8532 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8533 to 8535 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8536 to 8538 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8539 to 8541 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8542 to 8544 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8545 to 8547 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8548 to 8550 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entry 8551 */
    { .label = {    876,  2, 0 } }, /* cc */

    /* entries 8552 to 8554 */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {    876,  2, 0 } }, /* cc */
    { .label = {   3031,  3, 0 } }, /* lib */

    /* entries 8555 to 8561 */
    { .label = {    108,  3, 1 } }, { .child = { 8562, 1 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  71218,  3, 0 } }, /* gub */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entry 8562 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 8563 to 8566 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 8567 to 8572 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  37716,  3, 0 } }, /* edu */

    /* entries 8573 to 8589 */
    { .label = {  11884,  4, 0 } }, /* arts */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 158623,  3, 0 } }, /* e12 */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = { 105297,  4, 0 } }, /* firm */
    { .label = {   7818,  3, 0 } }, /* gob */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {    175,  3, 0 } }, /* rec */
    { .label = { 144991,  5, 0 } }, /* store */
    { .label = {  13092,  3, 0 } }, /* tec */
    { .label = {  26804,  3, 0 } }, /* web */

    /* entries 8590 to 8594 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = { 158474,  3, 0 } }, /* k12 */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 8595 to 8607 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {   7316,  3, 0 } }, /* int */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  24880,  4, 0 } }, /* name */
    { .label = {  18846,  3, 0 } }, /* pro */
    { .label = {    707,  6, 0 } }, /* health */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 8608 to 8611 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */

    /* entries 8612 to 8618 */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {  26057,  6, 0 } }, /* dyndns */
    { .label = { 144308,  6, 0 } }, /* mypets */

    /* entries 8619 to 8624 */
    { .label = {  84873,  8, 0 } }, /* xn--o1ac */
    { .label = {  84773,  9, 0 } }, /* xn--c1avg */
    { .label = {  84820,  9, 0 } }, /* xn--90azh */
    { .label = { 104011,  8, 0 } }, /* xn--d1at */
    { .label = {  84873,  9, 0 } }, /* xn--o1ach */
    { .label = { 104051,  8, 0 } }, /* xn--80au */

    /* entry 8625 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8626 to 8643 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = {  49683,  5, 0 } }, /* agric */
    { .label = {    716,  3, 0 } }, /* alt */
    { .label = {     44,  2, 1 } }, { .child = { 8644, 1 } }, /* co */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 122212,  7, 0 } }, /* grondar */
    { .label = {  16294,  3, 0 } }, /* law */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {   7233,  3, 0 } }, /* ngo */
    { .label = {  13568,  3, 0 } }, /* nis */
    { .label = {  20962,  3, 0 } }, /* nom */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = { 137105,  6, 0 } }, /* school */
    { .label = {    359,  2, 0 } }, /* tm */
    { .label = {  26804,  3, 0 } }, /* web */

    /* entry 8644 */
    { .label = { 107714,  8, 0 } }, /* blogspot */

    /* entries 8645 to 8655 */
    { .label = {    189,  2, 0 } }, /* ac */
    { .label = { 147761,  3, 0 } }, /* biz */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {    108,  3, 0 } }, /* com */
    { .label = {  37716,  3, 0 } }, /* edu */
    { .label = {   2349,  3, 0 } }, /* gov */
    { .label = { 107696,  4, 0 } }, /* info */
    { .label = {  20570,  3, 0 } }, /* mil */
    { .label = {  13352,  3, 0 } }, /* net */
    { .label = {  12740,  3, 0 } }, /* org */
    { .label = {   4209,  3, 0 } }, /* sch */

    /* entry 8656 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entries 8657 to 8659 */
    { .label = { 107642,  8, 0 } }, /* myfusion */
    { .label = {  58426, 11, 1 } }, { .child = { 8660, 1 } }, /* magentosite */

    /* entry 8660 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8661 */
    { .label = { 125863,  7, 0 } }, /* cloudns */

    /* entries 8662 to 8663 */
    { .label = {  15856,  7, 1 } }, { .child = { 8664, 1 } }, /* compute */

    /* entry 8664 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8665 */
    { .label = { 144810,  6, 0 } }, /* ptplus */

    /* entry 8666 */
    { .label = {  88159,  9, 0 } }, /* opencraft */

    /* entries 8667 to 8668 */
    { .label = {     44,  2, 0 } }, /* co */
    { .label = {  37716,  3, 0 } }, /* edu */

    /* entries 8669 to 8670 */
    { .label = { 144868,  6, 1 } }, { .child = { 8671, 2 } }, /* static */

    /* entries 8671 to 8672 */
    { .label = {   7012,  3, 0 } }, /* dev */
    { .label = {  34482,  5, 0 } }, /* sites */

    /* entries 8673 to 8674 */
    { .label = { 158140,  4, 0 } }, /* cyon */
    { .label = { 155085,  5, 0 } }, /* mypep */

    /* entry 8675 */
    { .label = {  88215,  6, 0 } }, /* router */

    /* entries 8676 to 8677 */
    { .label = { 154664,  5, 1 } }, { .child = { 8678, 1 } }, /* alces */

    /* entry 8678 */
    { .label = {      0,  1, 0 } }, /* * */

    /* entry 8679 */
    { .label = { 128320,  7, 0 } }, /* nerdpol */

    /* entry 8680 */
    { .label = { 158140,  4, 0 } }, /* cyon */

    /* entry 8681 */
    { .label = {  71913, 10, 0 } }, /* stackspace */

    /* entry 8682 */
    { .label = {  58377, 11, 0 } }, /* knightpoint */

    /* entry 8683 */
    { .label = { 154813,  5, 0 } }, /* fhapp */

    /* entries 8684 to 8685 */
    { .label = { 144508,  6, 1 } }, { .child = { 8686, 1 } }, /* triton */

    /* entry 8686 */
    { .label = {      0,  1, 0 } }, /* * */

};

