/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File EditTransaction.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef EditTransaction_H
#define EditTransaction_H

// Headers
// #ifndef   machine_H
// #include <machine.h>
// #endif
#ifndef  Transaction_H
#include <Transaction.h>
#endif

#ifndef  EditorObserver_H
#include <EditorObserver.h>
#endif

#ifndef  TaskObserver_H
#include <TaskObserver.h>
#endif

#ifndef  IconObject_H
#include <IconObject.h>
#endif


// Forward declarations

// class ostream;
// typedef class _Pvts os_typespec; // Remove if not persistant

// 
class EditTransaction : 
	public Transaction, 
	public EditorObserver,
	public TaskObserver
{


	IconObjectH current_;

	// -- From MvTransaction

	virtual MvTransaction *cloneSelf();
	virtual void callback(MvRequest&);

	// -- From EditorObserver

	virtual void apply(IconObject*);
	virtual void close(IconObject*);


public:
        EditTransaction(); 
	EditTransaction(MvTransaction* t);
	~EditTransaction();
	
private:

// No copy allowed

	EditTransaction(const EditTransaction&);
	EditTransaction& operator=(const EditTransaction&);

	IconClass* subClass_;


	// -- From TaskObserver
	virtual void success(Task*,const Request&);
	virtual void failure(Task*);


};



inline void destroy(EditTransaction**) {}

// If persistent, uncomment, otherwise remove
//#ifdef _ODI_OSSG_
//OS_MARK_SCHEMA_TYPE(EditTransaction);
//#endif

#endif
