#!/bin/bash
# ************************************************************************************
#   Copyright (C) 2020 MariaDB Corporation AB
#   
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Library General Public
#   License as published by the Free Software Foundation; either
#   version 2.1 of the License, or (at your option) any later version.
#   
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Library General Public License for more details.
#   
#   You should have received a copy of the GNU Library General Public
#   License along with this library; if not see <http://www.gnu.org/licenses>
#   or write to the Free Software Foundation, Inc., 
#   51 Franklin St., Fifth Floor, Boston, MA 02110, USA
# *************************************************************************************/

set -x
echo $1
LinkedLibName=`otool -L $1 | grep -i iodbcinst | sed 's/	//' | sed 's/ [(].*$//'`
install_name_tool -change $LinkedLibName @rpath/libiodbcinst.dylib $1
LinkedLibName=`otool -L $1 | grep -i libgnutls | sed 's/	//' | sed 's/ [(].*$//'`
if [ $LinkedLibName ] ; then
  LinkedLibFileName=`echo $LinkedLibName | sed 's/.*[/]//'`
  install_name_tool -change $LinkedLibName @rpath/$LinkedLibFileName $1
fi

#LinkedLibName=`otool -L $1 | grep -i libcrypto | sed 's/	//' | sed 's/ [(].*$//'`
#install_name_tool -change $LinkedLibName @rpath/libcrypto.1.1.dylib $1

