/*
    VLDocking Framework 2.1
    Copyright VLSOLUTIONS, 2004-2006

    email : info@vlsolutions.com
------------------------------------------------------------------------
This software is distributed under the CeCILL license, a GNU GPL-compatible
license adapted to french law.
French and English license headers are provided at the begining of
the source files of this software application.
------------------------------------------------------------------------
LICENCE CeCILL (FRENCH VERSION).
------------------------------------------------------------------------
Ce logiciel est un programme informatique servant  amliorer les interfaces
homme-machine d'applications Java bases sur Swing, en leur apportant un
ensemble de fonctions relatives au dockage des composants.

Ce logiciel est rgi par la licence CeCILL soumise au droit franais et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL telle que diffuse par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilit au code source et des droits de copie,
de modification et de redistribution accords par cette licence, il n'est
offert aux utilisateurs qu'une garantie limite.  Pour les mmes raisons,
seule une responsabilit restreinte pse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concdants successifs.

A cet gard  l'attention de l'utilisateur est attire sur les risques
associs au chargement,   l'utilisation,   la modification et/ou au
dveloppement et  la reproduction du logiciel par l'utilisateur tant
donn sa spcificit de logiciel libre, qui peut le rendre complexe 
manipuler et qui le rserve donc  des dveloppeurs et des professionnels
avertis possdant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invits  charger  et  tester  l'adquation  du
logiciel  leurs besoins dans des conditions permettant d'assurer la
scurit de leurs systmes et ou de leurs donnes et, plus gnralement,
 l'utiliser et l'exploiter dans les mmes conditions de scurit.

Le fait que vous puissiez accder  cet en-tte signifie que vous avez
pris connaissance de la licence CeCILL, et que vous en avez accept les
termes.

------------------------------------------------------------------------
CeCILL License (ENGLISH VERSION)
------------------------------------------------------------------------

This software is a computer program whose purpose is to enhance Human-Computer
Interfaces written in Java with the Swing framework, providing them a set of
functions related to component docking.

This software is governed by the CeCILL  license under French law and
abiding by the rules of distribution of free software.  You can  use,
modify and/ or redistribute the software under the terms of the CeCILL
license as circulated by CEA, CNRS and INRIA at the following URL
"http://www.cecill.info".

As a counterpart to the access to the source code and  rights to copy,
modify and redistribute granted by the license, users are provided only
with a limited warranty  and the software's author,  the holder of the
economic rights,  and the successive licensors  have only  limited
liability.

In this respect, the user's attention is drawn to the risks associated
with loading,  using,  modifying and/or developing or reproducing the
software by the user in light of its specific status of free software,
that may mean  that it is complicated to manipulate,  and  that  also
therefore means  that it is reserved for developers  and  experienced
professionals having in-depth computer knowledge. Users are therefore
encouraged to load and test the software's suitability as regards their
requirements in conditions enabling the security of their systems and/or
data to be ensured and,  more generally, to use and operate it in the
same conditions as regards security.

The fact that you are presently reading this means that you have had
knowledge of the CeCILL license and that you accept its terms.

*/


package com.vlsolutions.swing.toolbars;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.ArrayList;

/** The layout for VLToolBar (supports horizontal and vertical orientation).
 *<p>
 * When used in horizontal orientation, this layout respects the preferred width of
 * the contained components, and forces the height to the maximum of all the preferred heights.
 * (so components are vertically streched to have the same height).
 *<p>
 * When used in vertical orientation, this layout respects the preferred height of
 * the contained components, and forces the width to the maximum of all the preferred widths.
 * (so components are horizontally streched to have the same width).
 *
 * @author Lilian Chamontin, VLSolutions
 * @update 2006/09/09 Support for LTR and RTL component orientation
 */
public class VLToolBarLayout implements LayoutManager2{
  
  private ArrayList components = new ArrayList();
  private boolean isHorizontal;
  private int gap; // gap in pixels between components
  
  public VLToolBarLayout() {
    this(true, 0);
  }
  
  
  /** Constructs a new Layout.
   *
   * @param isHorizontal  indicates if the layout will be horizontal or vertical.
   *
   * */
  public VLToolBarLayout(boolean isHorizontal) {
    this(isHorizontal, 0);
  }
  
  /** Constructs a new Layout.
   * @param isHorizontal  indicates if the layout will be horizontal or vertical.
   * @param gap gap in pixels between components
   * */
  public VLToolBarLayout(boolean isHorizontal, int gap) {
    this.isHorizontal = isHorizontal;
    this.gap = gap;
  }
  
  public float getLayoutAlignmentX(Container target) {
    return 0.5F;
  }
  
  public float getLayoutAlignmentY(Container target) {
    return 0.5F;
  }
  
  public void invalidateLayout(Container target) {
  }
  
  public Dimension maximumLayoutSize(Container target) {
    return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
  }
  
  public void addLayoutComponent(Component comp, Object constraints) {
    if (constraints == null){
      components.add(comp);
    } else {
      Integer i = (Integer) constraints;
      components.add(i.intValue(), comp);
    }
  }
  
  public void removeLayoutComponent(Component comp) {
    components.remove(comp);
  }
  
  public void addLayoutComponent(String name, Component comp) {
  }
  
  public Dimension minimumLayoutSize(Container parent) {
    synchronized (parent.getTreeLock()) {
      Dimension dim = new Dimension(0, 0);
      int visible = 0;
      for (int i = 0; i < components.size(); i++) {
        Component comp = (Component) components.get(i);
        Dimension d = comp.getPreferredSize();
        if (comp.isVisible()){
          visible ++;
          if (isHorizontal) {
            dim.width += d.width;
            dim.height = Math.max(dim.height, d.height);
          } else {
            dim.width = Math.max(dim.width, d.width);
            dim.height += d.height;
          }
        }
      }
      // add the gap between components
      if (isHorizontal) {
        dim.width += (visible - 1) * gap;
      } else {
        dim.height += (visible - 1) * gap;
      }
      
      Insets insets = parent.getInsets();
      dim.width += insets.left + insets.right;
      dim.height += insets.top + insets.bottom;
      return dim;
    }
  }
  
  public Dimension preferredLayoutSize(Container parent) {
    return minimumLayoutSize(parent);
  }
  
  /** overridden to adjust position (x(top) = width(left), y(left) = height(top)
   */
  public void layoutContainer(Container target) {
    synchronized (target.getTreeLock()) {
      Dimension toolbarDim = preferredLayoutSize(target);
      Insets insets = target.getInsets();
      if (isHorizontal){
        int left = insets.left;
        /*for (int i = 0; i < components.size(); i++) {
          Component comp = (Component) components.get(i);
          if (comp.isVisible()){
            Dimension d = comp.getPreferredSize();
            comp.setBounds(left, insets.top, d.width, toolbarDim.height - insets.top - insets.bottom);
            left += d.width + gap;
          }
        }*/
        if (target.getComponentOrientation().isLeftToRight()) {
          for (int i = 0; i < components.size(); i++) {
            left = layoutHorizComponent((Component)components.get(i), toolbarDim, insets, left);
          }
        } else {
          // Right to left
          Component firstComp = components.size() == 0 ? null : (Component)components.get(0);
          int endWith = 0 ;
          if (firstComp != null && firstComp instanceof ToolBarGripper) {
            left = layoutHorizComponent(firstComp, toolbarDim, insets, left);
            endWith = 1;
          }
          for (int i = components.size() - 1; i >= endWith; i--) {
            left = layoutHorizComponent((Component)components.get(i), toolbarDim, insets, left);
          }
        }
      } else { //vertical
        int centerX = insets.left + (toolbarDim.width - insets.left - insets.right)/2;
        int top = insets.top;
        for (int i = 0; i < components.size(); i++) {
          Component comp = (Component) components.get(i);
          if (comp.isVisible()){
            Dimension d = comp.getPreferredSize();
            comp.setBounds(insets.left, top, toolbarDim.width - insets.left - insets.right, d.height);
            top += d.height + gap;
          }
        }
      }
    }
  }
  
  
  /* 2006/09/09 */
  private int layoutHorizComponent(Component comp, Dimension toolbarDim, Insets insets, int left) {
    if (comp.isVisible()){
      Dimension d = comp.getPreferredSize();
      comp.setBounds(left, insets.top, d.width, toolbarDim.height - insets.top - insets.bottom);
      left += d.width + gap;
    }
    return left;
  }
  
  
}


