package org.jboss.cache.api.nodevalidity;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.CacheSPI;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.config.CacheLoaderConfig;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.loader.DummyInMemoryCacheLoader;
import org.jboss.cache.loader.DummySharedInMemoryCacheLoader;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/**
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.1.0
 */
@Test(groups = {"functional"})
public class InvalidatedPessNodeValidityTest extends NodeValidityTestBase
{
   protected DummyInMemoryCacheLoader loader;

   public InvalidatedPessNodeValidityTest()
   {
      invalidation = true;
   }

   protected Cache<String, String> createObserver()
   {
      return newCache();
   }

   protected Cache<String, String> createModifier()
   {
      return newCache();
   }

   @AfterMethod
   public void emptyCacheLoader()
   {
      if (loader != null) loader.wipe();
   }

   protected Cache<String, String> newCache()
   {
      CacheFactory<String, String> f = new DefaultCacheFactory();
      Cache<String, String> cache = f.createCache(false);
      cache.getConfiguration().setCacheMode(Configuration.CacheMode.INVALIDATION_SYNC);
      optimisticConfiguration(cache.getConfiguration());

      // need a cache loader as a shared data source between the 2 instances
      CacheLoaderConfig.IndividualCacheLoaderConfig iclc = new CacheLoaderConfig.IndividualCacheLoaderConfig();
      iclc.setClassName(DummySharedInMemoryCacheLoader.class.getName());
      CacheLoaderConfig clc = new CacheLoaderConfig();
      clc.addIndividualCacheLoaderConfig(iclc);
      cache.getConfiguration().setCacheLoaderConfig(clc);

      cache.start();

      CacheSPI spi = (CacheSPI) cache;

      loader = (DummyInMemoryCacheLoader) spi.getCacheLoaderManager().getCacheLoader();

      return cache;
   }
}
