package org.jboss.cache.loader;

import org.jboss.cache.config.CacheLoaderConfig.IndividualCacheLoaderConfig;
import org.jboss.cache.util.Util;

import java.util.Properties;

public class TcpDelegatingCacheLoaderConfig extends IndividualCacheLoaderConfig
{
   /**
    * The serialVersionUID
    */
   private static final long serialVersionUID = -3138555335000168505L;

   private String host = "localhost";
   private int port = 7500;
   private int timeout = 5000;
   private int reconnectWaitTime = 500;

   public TcpDelegatingCacheLoaderConfig()
   {
      setClassName(TcpDelegatingCacheLoader.class.getName());
   }

   /**
    * For use by {@link TcpDelegatingCacheLoader}.
    *
    * @param base generic config object created by XML parsing.
    */
   TcpDelegatingCacheLoaderConfig(IndividualCacheLoaderConfig base)
   {
      setClassName(TcpDelegatingCacheLoader.class.getName());
      populateFromBaseConfig(base);
   }

   /**
    * For use by {@link TcpDelegatingCacheLoader}.
    *
    * @param host    hostname of the delegate
    * @param port    port the delegate is listening on
    * @param timeout after which to throw an IOException
    */
   TcpDelegatingCacheLoaderConfig(String host, int port, int timeout)
   {
      setClassName(TcpDelegatingCacheLoader.class.getName());
      this.host = host;
      this.port = port;
      this.timeout = timeout;
   }

   public String getHost()
   {
      return host;
   }

   public void setHost(String host)
   {
      testImmutability("host");
      this.host = host;
   }

   public int getPort()
   {
      return port;
   }

   public void setPort(int port)
   {
      testImmutability("port");
      this.port = port;
   }

   public int getTimeout()
   {
      return timeout;
   }

   public void setTimeout(int timeout)
   {
      testImmutability("timeout");
      this.timeout = timeout;
   }

   public int getReconnectWaitTime()
   {
      return reconnectWaitTime;
   }

   public void setReconnectWaitTime(int reconnectWaitTime)
   {
      testImmutability("reconnectWaitTime");
      this.reconnectWaitTime = reconnectWaitTime;
   }

   @Override
   public void setProperties(Properties props)
   {
      super.setProperties(props);
      String s = props.getProperty("host");
      if (s != null && s.length() > 0)
      {
         this.host = s;
      }
      s = props.getProperty("port");
      if (s != null && s.length() > 0)
      {
         this.port = Integer.parseInt(s);
      }

      s = props.getProperty("timeout");
      if (s != null && s.length() > 0)
      {
         this.timeout = Integer.parseInt(s);
      }

      s = props.getProperty("reconnectWaitTime");
      if (s != null && s.length() > 0)
      {
         this.reconnectWaitTime = Integer.parseInt(s);
      }
   }

   @Override
   public boolean equals(Object obj)
   {
      if (obj instanceof TcpDelegatingCacheLoaderConfig && equalsExcludingProperties(obj))
      {
         TcpDelegatingCacheLoaderConfig other = (TcpDelegatingCacheLoaderConfig) obj;

         return Util.safeEquals(host, other.host)
               && (port == other.port) && (timeout == other.timeout) && (reconnectWaitTime == other.reconnectWaitTime);
      }
      return false;
   }

   @Override
   public int hashCode()
   {
      int result = hashCodeExcludingProperties();
      result = 31 * result + (host == null ? 0 : host.hashCode());
      result = 31 * result + port;
      result = 31 * result + timeout;
      result = 31 * result + reconnectWaitTime;

      return result;
   }

   @Override
   public TcpDelegatingCacheLoaderConfig clone() throws CloneNotSupportedException
   {
      return (TcpDelegatingCacheLoaderConfig) super.clone();
   }
}