/**
 * Copyright (c) Members of the EGEE Collaboration. 2004-2010. 
 * See http://www.eu-egee.org/partners/ for details on the copyright
 * holders.  
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); 
 * you may not use this file except in compliance with the License. 
 * You may obtain a copy of the License at 
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0 
 * 
 * Unless required by applicable law or agreed to in writing, software 
 * distributed under the License is distributed on an "AS IS" BASIS, 
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. 
 * See the License for the specific language governing permissions and 
 * limitations under the License.
 *
 *
 *  Authors:
 *  2009-
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     Mischa Sall\'e <msalle@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *     <grid-mw-security@nikhef.nl> 
 *
 *  2007-2009
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 *  2003-2007
 *     Martijn Steenbakkers <martijn@nikhef.nl>
 *     Gerben Venekamp <venekamp@nikhef.nl>
 *     Oscar Koeroo <okoeroo@nikhef.nl>
 *     David Groep <davidg@nikhef.nl>
 *     NIKHEF Amsterdam, the Netherlands
 *
 */


/* LCMAPS includes */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pwd.h>
#include <grp.h>
#include <ctype.h>
 
#include <lcmaps/lcmaps_log.h>
#include "../../src/pluginmanager/_lcmaps_log.h"
#include "lcmaps_plugins_basic_config.h"
#include <lcmaps/lcmaps_modules.h>
#include <lcmaps/lcmaps_arguments.h>
#include <lcmaps/lcmaps_cred_data.h>
#include "../../src/pluginmanager/_lcmaps_cred_data.h"
#include <lcmaps/lcmaps_types.h>
#include "plugin_test.h"


#define DO_USRLOG           ((unsigned short)0x0001) /*!< flag to indicate that
                                      user logging has to be done \internal */
#define DO_SYSLOG           ((unsigned short)0x0002) /*!< flag to indicate that
                                      syslogging has to be done \internal */


int main()
{
    int argc, i, j, k;
    lcmaps_argument_t *args      = NULL;
    char              *init_argv[] = {"ldap_enf",
                                      "-maxuid",  "1", 
                                      "-maxpgid", "1", 
                                      "-maxsgid", "32",
                                      "-hostname", "asen.nikhef.nl",
                                      "-port", "11389",
                                      "-require_all_groups","no",
                                      "-dn_manager", "cn=Manager,dc=root",
                                      "-ldap_pw", "./test_pw",
                                      "-sb_groups", "ou=LocalGroups, dc=foobar, dc=ough",
                                      "-sb_user", "ou=LocalUsers, dc=foobar, dc=ough",
	        "-timeout", "10"};

    if (lcmaps_log_open(NULL,stdout,DO_USRLOG)) return 1;

    lcmaps_log_debug(0,"\n");

    lcmaps_log(LOG_NOTICE,"Initialization LDAP Enforcement\n");
    if (plugin_initialize(23, init_argv) == LCMAPS_MOD_FAIL)
    {
        lcmaps_log(2, "Error on execution: plugin_initialize\n");
        return LCMAPS_MOD_FAIL;
    }

    lcmaps_log(LOG_NOTICE, "IntroSpect LDAP Enforcement:\n"); 
    if (plugin_introspect(&argc, &args) ==  LCMAPS_MOD_FAIL)
    {
        lcmaps_log(2, "Error on execution: plugin_introspect\n");
        return LCMAPS_MOD_FAIL;
    } 

    /*
     * Adding Test Credential Data
     */

    //i = 501; //gridtest
    //i = 500; //martijn
    i = 42; //wim
    addCredentialData(UID,     &i);
    //j = 200;
//    j = 503;
    j = 50003;
    addCredentialData(PRI_GID, &j);
    k = 50004; // tbadmin
    addCredentialData(SEC_GID, &k);
    k = 501; //gridtest
    addCredentialData(SEC_GID, &k);
   
    k = 501; 


    lcmaps_log(LOG_NOTICE, "Run LDAP Enforcement\n"); 
    if (plugin_run(argc,args) ==  LCMAPS_MOD_FAIL)
    {
        lcmaps_log(2, "Error on execution: plugin_run\n");
        return LCMAPS_MOD_FAIL;
    }


    if (cleanCredentialData()!=0)
    {
        lcmaps_log(0,"lcmaps.mod-stopPluginManager() error: could not clean credential data list\n");
        return LCMAPS_MOD_FAIL;
    }

    lcmaps_log(LOG_NOTICE, "Terminate LDAP Enforcement\n");
    if (plugin_terminate() ==  LCMAPS_MOD_FAIL)
    {
        lcmaps_log(2, "Error on execution: plugin_terminate\n");
        return LCMAPS_MOD_FAIL;
    } 
    return 0;
}
