/**************************************************************************
*   Copyright (C) 2007-2010 by Thomas Thelliez aka jblud                  *
*   Contact : <admin.kontrol@gmail.com>                                   *
*                                                                         *
* This program is free software; you can redistribute it and/or           *
* modify it either under the terms of the GNU Lesser General Public       *
* License version 3 as published by the Free Software Foundation          *
* (the "LGPL") or, at your option, any later version.                     *
* If you do not alter this notice, a recipient may use your version       *
* of this file under the LGPL.                                            *
*                                                                         *
* You should have received a copy of the LGPL along with this library     *
* in the file COPYING; if not, write to the Free Software                 *
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA *
*                                                                         *
* This software is distributed on an "AS IS" basis, WITHOUT WARRANTY      *
* OF ANY KIND, either express or implied. See the LGPL for                *
* the specific language governing rights and limitations.                 *
**************************************************************************/

#include "b64_utils.h"

char *base64(const unsigned char *input, int length)
{
    BIO *bmem, *b64;
    BUF_MEM *bptr;

    b64 = BIO_new(BIO_f_base64());
    bmem = BIO_new(BIO_s_mem());
    b64 = BIO_push(b64, bmem);
    BIO_write(b64, input, length);
    BIO_flush(b64);
    BIO_get_mem_ptr(b64, &bptr);

    char *buff = (char *)malloc(bptr->length);
    memcpy(buff, bptr->data, bptr->length-1);
    buff[bptr->length-1] = 0;

    BIO_free_all(b64);

    return buff;
}

char *unbase64(unsigned char *input, int length)
{
    BIO *b64, *bmem;

    char *buffer = (char *)malloc(length);
    memset(buffer, 0, length);

    b64 = BIO_new(BIO_f_base64());
    BIO_set_flags(b64, BIO_FLAGS_BASE64_NO_NL);
    bmem = BIO_new_mem_buf(input, length);
    bmem = BIO_push(b64, bmem);

    BIO_read(bmem, buffer, length);

    BIO_free_all(bmem);

    return buffer;
}


const char         fillchar = '=';
                       // 00000000001111111111222222
                       // 01234567890123456789012345
static std::string cvt = "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                       // 22223333333333444444444455
                       // 67890123456789012345678901
                         "abcdefghijklmnopqrstuvwxyz"
                       // 555555556666
                       // 234567890123
                         "0123456789+/";

string encode(string data)
{
    string::size_type  i;
    char               c;
    string::size_type  len = data.length();
    string             ret;
    for (i = 0; i < len; ++i)
    {
        c = (data[i] >> 2) & 0x3f;
        ret.append(1, cvt[c]);
        c = (data[i] << 4) & 0x3f;
        if (++i < len)
            c |= (data[i] >> 4) & 0x0f;
        ret.append(1, cvt[c]);
        if (i < len)
        {
            c = (data[i] << 2) & 0x3f;
            if (++i < len)
                c |= (data[i] >> 6) & 0x03;
            ret.append(1, cvt[c]);
        }
        else
        {
            ++i;
            ret.append(1, fillchar);
        }
        if (i < len)
        {
            c = data[i] & 0x3f;
            ret.append(1, cvt[c]);
        }
        else
        {
            ret.append(1, fillchar);
        }
    }
    return(ret);
}

string decode(string data)
{
    string::size_type  i;
    char               c;
    char               c1;
    string::size_type  len = data.length();
    string             ret;
    for (i = 0; i < len; ++i)
    {
        c = (char) cvt.find(data[i]);
        ++i;
        c1 = (char) cvt.find(data[i]);
        c = (c << 2) | ((c1 >> 4) & 0x3);
        ret.append(1, c);
        if (++i < len)
        {
            c = data[i];
            if (fillchar == c)
                break;
            c = (char) cvt.find(c);
            c1 = ((c1 << 4) & 0xf0) | ((c >> 2) & 0xf);
            ret.append(1, c1);
        }
        if (++i < len)
        {
            c1 = data[i];
            if (fillchar == c1)
                break;
            c1 = (char) cvt.find(c1);
            c = ((c << 6) & 0xc0) | c1;
            ret.append(1, c);
        }
    }
    return(ret);
}

