
/*

  KLayout Layout Viewer
  Copyright (C) 2006-2024 Matthias Koefferlein

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

/**
*  @file gsiDeclQPdfWriter.cc 
*
*  DO NOT EDIT THIS FILE. 
*  This file has been created automatically
*/

#include <QPdfWriter>
#include <QChildEvent>
#include <QEvent>
#include <QIODevice>
#include <QMarginsF>
#include <QMetaMethod>
#include <QObject>
#include <QPageLayout>
#include <QPaintDevice>
#include <QPaintEngine>
#include <QPainter>
#include <QPoint>
#include <QSizeF>
#include <QThread>
#include <QTimerEvent>
#include "gsiQt.h"
#include "gsiQtGuiCommon.h"
#include <memory>

// -----------------------------------------------------------------------
// class QPdfWriter

//  get static meta object

static void _init_smo (qt_gsi::GenericStaticMethod *decl)
{
  decl->set_return<const QMetaObject &> ();
}

static void _call_smo (const qt_gsi::GenericStaticMethod *, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QMetaObject &> (QPdfWriter::staticMetaObject);
}


// QString QPdfWriter::creator()


static void _init_f_creator_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_creator_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPdfWriter *)cls)->creator ());
}


// bool QPdfWriter::newPage()


static void _init_f_newPage_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_f_newPage_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPdfWriter *)cls)->newPage ());
}


// int QPdfWriter::resolution()


static void _init_f_resolution_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_f_resolution_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPdfWriter *)cls)->resolution ());
}


// void QPdfWriter::setCreator(const QString &creator)


static void _init_f_setCreator_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("creator");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setCreator_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setCreator (arg1);
}


// void QPdfWriter::setMargins(const QPagedPaintDevice::Margins &m)


static void _init_f_setMargins_3812 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const QPagedPaintDevice::Margins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setMargins_3812 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPagedPaintDevice::Margins &arg1 = gsi::arg_reader<const QPagedPaintDevice::Margins & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setMargins (arg1);
}


// void QPdfWriter::setPageSize(QPagedPaintDevice::PageSize size)


static void _init_f_setPageSize_3006 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageSize_3006 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & arg1 = gsi::arg_reader<const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setPageSize (qt_gsi::QtToCppAdaptor<QPagedPaintDevice::PageSize>(arg1).cref());
}


// void QPdfWriter::setPageSizeMM(const QSizeF &size)


static void _init_f_setPageSizeMM_1875 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setPageSizeMM_1875 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = gsi::arg_reader<const QSizeF & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setPageSizeMM (arg1);
}


// void QPdfWriter::setResolution(int resolution)


static void _init_f_setResolution_767 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("resolution");
  decl->add_arg<int > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setResolution_767 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  int arg1 = gsi::arg_reader<int >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setResolution (arg1);
}


// void QPdfWriter::setTitle(const QString &title)


static void _init_f_setTitle_2025 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("title");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_f_setTitle_2025 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter *)cls)->setTitle (arg1);
}


// QString QPdfWriter::title()


static void _init_f_title_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QString > ();
}

static void _call_f_title_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QString > ((QString)((QPdfWriter *)cls)->title ());
}


// static QString QPdfWriter::tr(const char *s, const char *c, int n)


static void _init_f_tr_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_tr_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPdfWriter::tr (arg1, arg2, arg3));
}


// static QString QPdfWriter::trUtf8(const char *s, const char *c, int n)


static void _init_f_trUtf8_4013 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("s");
  decl->add_arg<const char * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("c", true, "nullptr");
  decl->add_arg<const char * > (argspec_1);
  static gsi::ArgSpecBase argspec_2 ("n", true, "-1");
  decl->add_arg<int > (argspec_2);
  decl->set_return<QString > ();
}

static void _call_f_trUtf8_4013 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  const char *arg2 = args ? gsi::arg_reader<const char * >() (args, heap) : gsi::arg_maker<const char * >() (nullptr, heap);
  int arg3 = args ? gsi::arg_reader<int >() (args, heap) : gsi::arg_maker<int >() (-1, heap);
  ret.write<QString > ((QString)QPdfWriter::trUtf8 (arg1, arg2, arg3));
}


//  base class cast for QObject

static void _init_f_QPdfWriter_as_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject *> ();
}

static void _call_f_QPdfWriter_as_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QObject *> ((QObject *)(QPdfWriter *)cls);
}

static void _init_f_QPdfWriter_as_const_QObject (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QObject *> ();
}

static void _call_f_QPdfWriter_as_const_QObject (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QObject *> ((const QObject *)(const QPdfWriter *)cls);
}

//  base class cast for QPagedPaintDevice

static void _init_f_QPdfWriter_as_QPagedPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPagedPaintDevice *> ();
}

static void _call_f_QPdfWriter_as_QPagedPaintDevice (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<QPagedPaintDevice *> ((QPagedPaintDevice *)(QPdfWriter *)cls);
}

static void _init_f_QPdfWriter_as_const_QPagedPaintDevice (qt_gsi::GenericMethod *decl)
{
  decl->set_return<const QPagedPaintDevice *> ();
}

static void _call_f_QPdfWriter_as_const_QPagedPaintDevice (const qt_gsi::GenericMethod *, void *cls, gsi::SerialArgs &, gsi::SerialArgs &ret) 
{
  ret.write<const QPagedPaintDevice *> ((const QPagedPaintDevice *)(const QPdfWriter *)cls);
}


namespace gsi
{

static gsi::Methods methods_QPdfWriter () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("staticMetaObject", "@brief Obtains the static MetaObject for this class.", &_init_smo, &_call_smo);
  methods += new qt_gsi::GenericMethod (":creator", "@brief Method QString QPdfWriter::creator()\n", true, &_init_f_creator_c0, &_call_f_creator_c0);
  methods += new qt_gsi::GenericMethod ("newPage", "@brief Method bool QPdfWriter::newPage()\nThis is a reimplementation of QPagedPaintDevice::newPage", false, &_init_f_newPage_0, &_call_f_newPage_0);
  methods += new qt_gsi::GenericMethod (":resolution", "@brief Method int QPdfWriter::resolution()\n", true, &_init_f_resolution_c0, &_call_f_resolution_c0);
  methods += new qt_gsi::GenericMethod ("setCreator|creator=", "@brief Method void QPdfWriter::setCreator(const QString &creator)\n", false, &_init_f_setCreator_2025, &_call_f_setCreator_2025);
  methods += new qt_gsi::GenericMethod ("setMargins", "@brief Method void QPdfWriter::setMargins(const QPagedPaintDevice::Margins &m)\nThis is a reimplementation of QPagedPaintDevice::setMargins", false, &_init_f_setMargins_3812, &_call_f_setMargins_3812);
  methods += new qt_gsi::GenericMethod ("setPageSize|pageSize=", "@brief Method void QPdfWriter::setPageSize(QPagedPaintDevice::PageSize size)\nThis is a reimplementation of QPagedPaintDevice::setPageSize", false, &_init_f_setPageSize_3006, &_call_f_setPageSize_3006);
  methods += new qt_gsi::GenericMethod ("setPageSizeMM", "@brief Method void QPdfWriter::setPageSizeMM(const QSizeF &size)\nThis is a reimplementation of QPagedPaintDevice::setPageSizeMM", false, &_init_f_setPageSizeMM_1875, &_call_f_setPageSizeMM_1875);
  methods += new qt_gsi::GenericMethod ("setResolution|resolution=", "@brief Method void QPdfWriter::setResolution(int resolution)\n", false, &_init_f_setResolution_767, &_call_f_setResolution_767);
  methods += new qt_gsi::GenericMethod ("setTitle|title=", "@brief Method void QPdfWriter::setTitle(const QString &title)\n", false, &_init_f_setTitle_2025, &_call_f_setTitle_2025);
  methods += new qt_gsi::GenericMethod (":title", "@brief Method QString QPdfWriter::title()\n", true, &_init_f_title_c0, &_call_f_title_c0);
  methods += gsi::qt_signal<QObject * > ("destroyed(QObject *)", "destroyed", gsi::arg("arg1"), "@brief Signal declaration for QPdfWriter::destroyed(QObject *)\nYou can bind a procedure to this signal.");
  methods += gsi::qt_signal<const QString & > ("objectNameChanged(const QString &)", "objectNameChanged", gsi::arg("objectName"), "@brief Signal declaration for QPdfWriter::objectNameChanged(const QString &objectName)\nYou can bind a procedure to this signal.");
  methods += new qt_gsi::GenericStaticMethod ("tr", "@brief Static method QString QPdfWriter::tr(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_tr_4013, &_call_f_tr_4013);
  methods += new qt_gsi::GenericStaticMethod ("trUtf8", "@brief Static method QString QPdfWriter::trUtf8(const char *s, const char *c, int n)\nThis method is static and can be called without an instance.", &_init_f_trUtf8_4013, &_call_f_trUtf8_4013);
  methods += new qt_gsi::GenericMethod ("asQObject", "@brief Delivers the base class interface QObject of QPdfWriter\nClass QPdfWriter is derived from multiple base classes. This method delivers the QObject base class aspect.", false, &_init_f_QPdfWriter_as_QObject, &_call_f_QPdfWriter_as_QObject);
  methods += new qt_gsi::GenericMethod ("asConstQObject", "@brief Delivers the base class interface QObject of QPdfWriter\nClass QPdfWriter is derived from multiple base classes. This method delivers the QObject base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QPdfWriter_as_const_QObject, &_call_f_QPdfWriter_as_const_QObject);
  methods += new qt_gsi::GenericMethod ("asQPagedPaintDevice", "@brief Delivers the base class interface QPagedPaintDevice of QPdfWriter\nClass QPdfWriter is derived from multiple base classes. This method delivers the QPagedPaintDevice base class aspect.", false, &_init_f_QPdfWriter_as_QPagedPaintDevice, &_call_f_QPdfWriter_as_QPagedPaintDevice);
  methods += new qt_gsi::GenericMethod ("asConstQPagedPaintDevice", "@brief Delivers the base class interface QPagedPaintDevice of QPdfWriter\nClass QPdfWriter is derived from multiple base classes. This method delivers the QPagedPaintDevice base class aspect.\n\nUse this version if you have a const reference.", true, &_init_f_QPdfWriter_as_const_QPagedPaintDevice, &_call_f_QPdfWriter_as_const_QPagedPaintDevice);
  return methods;
}

gsi::Class<QObject> &qtdecl_QObject ();

qt_gsi::QtNativeClass<QPdfWriter> decl_QPdfWriter (qtdecl_QObject (), "QtGui", "QPdfWriter_Native",
  methods_QPdfWriter (),
  "@hide\n@alias QPdfWriter");

//  Additional base classes

gsi::Class<QPagedPaintDevice> &qtdecl_QPagedPaintDevice ();

gsi::ClassExt<QPdfWriter> base_class_QPagedPaintDevice_in_QPdfWriter (qtdecl_QPagedPaintDevice ());

GSI_QTGUI_PUBLIC gsi::Class<QPdfWriter> &qtdecl_QPdfWriter () { return decl_QPdfWriter; }

}


class QPdfWriter_Adaptor : public QPdfWriter, public qt_gsi::QtObjectBase
{
public:

  virtual ~QPdfWriter_Adaptor();

  //  [adaptor ctor] QPdfWriter::QPdfWriter(const QString &filename)
  QPdfWriter_Adaptor(const QString &filename) : QPdfWriter(filename)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [adaptor ctor] QPdfWriter::QPdfWriter(QIODevice *device)
  QPdfWriter_Adaptor(QIODevice *device) : QPdfWriter(device)
  {
    qt_gsi::QtObjectBase::init (this);
  }

  //  [expose] QPageLayout QPdfWriter::devicePageLayout()
  QPageLayout fp_QPdfWriter_devicePageLayout_c0 () const {
    return QPdfWriter::devicePageLayout();
  }

  //  [expose] QPageLayout &QPdfWriter::devicePageLayout()
  QPageLayout & fp_QPdfWriter_devicePageLayout_0 () {
    return QPdfWriter::devicePageLayout();
  }

  //  [expose] bool QPdfWriter::isSignalConnected(const QMetaMethod &signal)
  bool fp_QPdfWriter_isSignalConnected_c2394 (const QMetaMethod &signal) const {
    return QPdfWriter::isSignalConnected(signal);
  }

  //  [expose] int QPdfWriter::receivers(const char *signal)
  int fp_QPdfWriter_receivers_c1731 (const char *signal) const {
    return QPdfWriter::receivers(signal);
  }

  //  [expose] QObject *QPdfWriter::sender()
  QObject * fp_QPdfWriter_sender_c0 () const {
    return QPdfWriter::sender();
  }

  //  [expose] int QPdfWriter::senderSignalIndex()
  int fp_QPdfWriter_senderSignalIndex_c0 () const {
    return QPdfWriter::senderSignalIndex();
  }

  //  [emitter impl] void QPdfWriter::destroyed(QObject *)
  void emitter_QPdfWriter_destroyed_1302(QObject *arg1)
  {
    emit QPdfWriter::destroyed(arg1);
  }

  //  [adaptor impl] bool QPdfWriter::event(QEvent *)
  bool cbs_event_1217_0(QEvent *arg1)
  {
    return QPdfWriter::event(arg1);
  }

  virtual bool event(QEvent *arg1)
  {
    if (cb_event_1217_0.can_issue()) {
      return cb_event_1217_0.issue<QPdfWriter_Adaptor, bool, QEvent *>(&QPdfWriter_Adaptor::cbs_event_1217_0, arg1);
    } else {
      return QPdfWriter::event(arg1);
    }
  }

  //  [adaptor impl] bool QPdfWriter::eventFilter(QObject *, QEvent *)
  bool cbs_eventFilter_2411_0(QObject *arg1, QEvent *arg2)
  {
    return QPdfWriter::eventFilter(arg1, arg2);
  }

  virtual bool eventFilter(QObject *arg1, QEvent *arg2)
  {
    if (cb_eventFilter_2411_0.can_issue()) {
      return cb_eventFilter_2411_0.issue<QPdfWriter_Adaptor, bool, QObject *, QEvent *>(&QPdfWriter_Adaptor::cbs_eventFilter_2411_0, arg1, arg2);
    } else {
      return QPdfWriter::eventFilter(arg1, arg2);
    }
  }

  //  [adaptor impl] bool QPdfWriter::newPage()
  bool cbs_newPage_0_0()
  {
    return QPdfWriter::newPage();
  }

  virtual bool newPage()
  {
    if (cb_newPage_0_0.can_issue()) {
      return cb_newPage_0_0.issue<QPdfWriter_Adaptor, bool>(&QPdfWriter_Adaptor::cbs_newPage_0_0);
    } else {
      return QPdfWriter::newPage();
    }
  }

  //  [emitter impl] void QPdfWriter::objectNameChanged(const QString &objectName)
  void emitter_QPdfWriter_objectNameChanged_4567(const QString &objectName)
  {
    __SUPPRESS_UNUSED_WARNING (objectName);
    throw tl::Exception ("Can't emit private signal 'void QPdfWriter::objectNameChanged(const QString &objectName)'");
  }

  //  [adaptor impl] void QPdfWriter::setMargins(const QPagedPaintDevice::Margins &m)
  void cbs_setMargins_3812_0(const QPagedPaintDevice::Margins &m)
  {
    QPdfWriter::setMargins(m);
  }

  virtual void setMargins(const QPagedPaintDevice::Margins &m)
  {
    if (cb_setMargins_3812_0.can_issue()) {
      cb_setMargins_3812_0.issue<QPdfWriter_Adaptor, const QPagedPaintDevice::Margins &>(&QPdfWriter_Adaptor::cbs_setMargins_3812_0, m);
    } else {
      QPdfWriter::setMargins(m);
    }
  }

  //  [adaptor impl] void QPdfWriter::setPageSize(QPagedPaintDevice::PageSize size)
  void cbs_setPageSize_3006_0(const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & size)
  {
    QPdfWriter::setPageSize(qt_gsi::QtToCppAdaptor<QPagedPaintDevice::PageSize>(size).cref());
  }

  virtual void setPageSize(QPagedPaintDevice::PageSize size)
  {
    if (cb_setPageSize_3006_0.can_issue()) {
      cb_setPageSize_3006_0.issue<QPdfWriter_Adaptor, const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type &>(&QPdfWriter_Adaptor::cbs_setPageSize_3006_0, qt_gsi::CppToQtAdaptor<QPagedPaintDevice::PageSize>(size));
    } else {
      QPdfWriter::setPageSize(size);
    }
  }

  //  [adaptor impl] void QPdfWriter::setPageSizeMM(const QSizeF &size)
  void cbs_setPageSizeMM_1875_0(const QSizeF &size)
  {
    QPdfWriter::setPageSizeMM(size);
  }

  virtual void setPageSizeMM(const QSizeF &size)
  {
    if (cb_setPageSizeMM_1875_0.can_issue()) {
      cb_setPageSizeMM_1875_0.issue<QPdfWriter_Adaptor, const QSizeF &>(&QPdfWriter_Adaptor::cbs_setPageSizeMM_1875_0, size);
    } else {
      QPdfWriter::setPageSizeMM(size);
    }
  }

  //  [adaptor impl] void QPdfWriter::childEvent(QChildEvent *)
  void cbs_childEvent_1701_0(QChildEvent *arg1)
  {
    QPdfWriter::childEvent(arg1);
  }

  virtual void childEvent(QChildEvent *arg1)
  {
    if (cb_childEvent_1701_0.can_issue()) {
      cb_childEvent_1701_0.issue<QPdfWriter_Adaptor, QChildEvent *>(&QPdfWriter_Adaptor::cbs_childEvent_1701_0, arg1);
    } else {
      QPdfWriter::childEvent(arg1);
    }
  }

  //  [adaptor impl] void QPdfWriter::customEvent(QEvent *)
  void cbs_customEvent_1217_0(QEvent *arg1)
  {
    QPdfWriter::customEvent(arg1);
  }

  virtual void customEvent(QEvent *arg1)
  {
    if (cb_customEvent_1217_0.can_issue()) {
      cb_customEvent_1217_0.issue<QPdfWriter_Adaptor, QEvent *>(&QPdfWriter_Adaptor::cbs_customEvent_1217_0, arg1);
    } else {
      QPdfWriter::customEvent(arg1);
    }
  }

  //  [adaptor impl] void QPdfWriter::disconnectNotify(const QMetaMethod &signal)
  void cbs_disconnectNotify_2394_0(const QMetaMethod &signal)
  {
    QPdfWriter::disconnectNotify(signal);
  }

  virtual void disconnectNotify(const QMetaMethod &signal)
  {
    if (cb_disconnectNotify_2394_0.can_issue()) {
      cb_disconnectNotify_2394_0.issue<QPdfWriter_Adaptor, const QMetaMethod &>(&QPdfWriter_Adaptor::cbs_disconnectNotify_2394_0, signal);
    } else {
      QPdfWriter::disconnectNotify(signal);
    }
  }

  //  [adaptor impl] void QPdfWriter::initPainter(QPainter *painter)
  void cbs_initPainter_c1426_0(QPainter *painter) const
  {
    QPdfWriter::initPainter(painter);
  }

  virtual void initPainter(QPainter *painter) const
  {
    if (cb_initPainter_c1426_0.can_issue()) {
      cb_initPainter_c1426_0.issue<QPdfWriter_Adaptor, QPainter *>(&QPdfWriter_Adaptor::cbs_initPainter_c1426_0, painter);
    } else {
      QPdfWriter::initPainter(painter);
    }
  }

  //  [adaptor impl] int QPdfWriter::metric(QPaintDevice::PaintDeviceMetric id)
  int cbs_metric_c3445_0(const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & id) const
  {
    return QPdfWriter::metric(qt_gsi::QtToCppAdaptor<QPaintDevice::PaintDeviceMetric>(id).cref());
  }

  virtual int metric(QPaintDevice::PaintDeviceMetric id) const
  {
    if (cb_metric_c3445_0.can_issue()) {
      return cb_metric_c3445_0.issue<QPdfWriter_Adaptor, int, const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type &>(&QPdfWriter_Adaptor::cbs_metric_c3445_0, qt_gsi::CppToQtAdaptor<QPaintDevice::PaintDeviceMetric>(id));
    } else {
      return QPdfWriter::metric(id);
    }
  }

  //  [adaptor impl] QPaintEngine *QPdfWriter::paintEngine()
  QPaintEngine * cbs_paintEngine_c0_0() const
  {
    return QPdfWriter::paintEngine();
  }

  virtual QPaintEngine * paintEngine() const
  {
    if (cb_paintEngine_c0_0.can_issue()) {
      return cb_paintEngine_c0_0.issue<QPdfWriter_Adaptor, QPaintEngine *>(&QPdfWriter_Adaptor::cbs_paintEngine_c0_0);
    } else {
      return QPdfWriter::paintEngine();
    }
  }

  //  [adaptor impl] QPaintDevice *QPdfWriter::redirected(QPoint *offset)
  QPaintDevice * cbs_redirected_c1225_0(QPoint *offset) const
  {
    return QPdfWriter::redirected(offset);
  }

  virtual QPaintDevice * redirected(QPoint *offset) const
  {
    if (cb_redirected_c1225_0.can_issue()) {
      return cb_redirected_c1225_0.issue<QPdfWriter_Adaptor, QPaintDevice *, QPoint *>(&QPdfWriter_Adaptor::cbs_redirected_c1225_0, offset);
    } else {
      return QPdfWriter::redirected(offset);
    }
  }

  //  [adaptor impl] QPainter *QPdfWriter::sharedPainter()
  QPainter * cbs_sharedPainter_c0_0() const
  {
    return QPdfWriter::sharedPainter();
  }

  virtual QPainter * sharedPainter() const
  {
    if (cb_sharedPainter_c0_0.can_issue()) {
      return cb_sharedPainter_c0_0.issue<QPdfWriter_Adaptor, QPainter *>(&QPdfWriter_Adaptor::cbs_sharedPainter_c0_0);
    } else {
      return QPdfWriter::sharedPainter();
    }
  }

  //  [adaptor impl] void QPdfWriter::timerEvent(QTimerEvent *)
  void cbs_timerEvent_1730_0(QTimerEvent *arg1)
  {
    QPdfWriter::timerEvent(arg1);
  }

  virtual void timerEvent(QTimerEvent *arg1)
  {
    if (cb_timerEvent_1730_0.can_issue()) {
      cb_timerEvent_1730_0.issue<QPdfWriter_Adaptor, QTimerEvent *>(&QPdfWriter_Adaptor::cbs_timerEvent_1730_0, arg1);
    } else {
      QPdfWriter::timerEvent(arg1);
    }
  }

  gsi::Callback cb_event_1217_0;
  gsi::Callback cb_eventFilter_2411_0;
  gsi::Callback cb_newPage_0_0;
  gsi::Callback cb_setMargins_3812_0;
  gsi::Callback cb_setPageSize_3006_0;
  gsi::Callback cb_setPageSizeMM_1875_0;
  gsi::Callback cb_childEvent_1701_0;
  gsi::Callback cb_customEvent_1217_0;
  gsi::Callback cb_disconnectNotify_2394_0;
  gsi::Callback cb_initPainter_c1426_0;
  gsi::Callback cb_metric_c3445_0;
  gsi::Callback cb_paintEngine_c0_0;
  gsi::Callback cb_redirected_c1225_0;
  gsi::Callback cb_sharedPainter_c0_0;
  gsi::Callback cb_timerEvent_1730_0;
};

QPdfWriter_Adaptor::~QPdfWriter_Adaptor() { }

//  Constructor QPdfWriter::QPdfWriter(const QString &filename) (adaptor class)

static void _init_ctor_QPdfWriter_Adaptor_2025 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("filename");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return_new<QPdfWriter_Adaptor> ();
}

static void _call_ctor_QPdfWriter_Adaptor_2025 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ret.write<QPdfWriter_Adaptor *> (new QPdfWriter_Adaptor (arg1));
}


//  Constructor QPdfWriter::QPdfWriter(QIODevice *device) (adaptor class)

static void _init_ctor_QPdfWriter_Adaptor_1447 (qt_gsi::GenericStaticMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("device");
  decl->add_arg<QIODevice * > (argspec_0);
  decl->set_return_new<QPdfWriter_Adaptor> ();
}

static void _call_ctor_QPdfWriter_Adaptor_1447 (const qt_gsi::GenericStaticMethod * /*decl*/, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QIODevice *arg1 = gsi::arg_reader<QIODevice * >() (args, heap);
  ret.write<QPdfWriter_Adaptor *> (new QPdfWriter_Adaptor (arg1));
}


// void QPdfWriter::childEvent(QChildEvent *)

static void _init_cbs_childEvent_1701_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QChildEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_childEvent_1701_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QChildEvent *arg1 = args.read<QChildEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_childEvent_1701_0 (arg1);
}

static void _set_callback_cbs_childEvent_1701_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_childEvent_1701_0 = cb;
}


// void QPdfWriter::customEvent(QEvent *)

static void _init_cbs_customEvent_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_customEvent_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_customEvent_1217_0 (arg1);
}

static void _set_callback_cbs_customEvent_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_customEvent_1217_0 = cb;
}


// emitter void QPdfWriter::destroyed(QObject *)

static void _init_emitter_destroyed_1302 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1", true, "0");
  decl->add_arg<QObject * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_destroyed_1302 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args ? gsi::arg_reader<QObject * >() (args, heap) : gsi::arg_maker<QObject * >() (0, heap);
  ((QPdfWriter_Adaptor *)cls)->emitter_QPdfWriter_destroyed_1302 (arg1);
}


// exposed QPageLayout QPdfWriter::devicePageLayout()

static void _init_fp_devicePageLayout_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPageLayout > ();
}

static void _call_fp_devicePageLayout_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPageLayout > ((QPageLayout)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_devicePageLayout_c0 ());
}


// exposed QPageLayout &QPdfWriter::devicePageLayout()

static void _init_fp_devicePageLayout_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPageLayout & > ();
}

static void _call_fp_devicePageLayout_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPageLayout & > ((QPageLayout &)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_devicePageLayout_0 ());
}


// void QPdfWriter::disconnectNotify(const QMetaMethod &signal)

static void _init_cbs_disconnectNotify_2394_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_disconnectNotify_2394_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = args.read<const QMetaMethod & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_disconnectNotify_2394_0 (arg1);
}

static void _set_callback_cbs_disconnectNotify_2394_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_disconnectNotify_2394_0 = cb;
}


// bool QPdfWriter::event(QEvent *)

static void _init_cbs_event_1217_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QEvent * > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_cbs_event_1217_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QEvent *arg1 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_event_1217_0 (arg1));
}

static void _set_callback_cbs_event_1217_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_event_1217_0 = cb;
}


// bool QPdfWriter::eventFilter(QObject *, QEvent *)

static void _init_cbs_eventFilter_2411_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QObject * > (argspec_0);
  static gsi::ArgSpecBase argspec_1 ("arg2");
  decl->add_arg<QEvent * > (argspec_1);
  decl->set_return<bool > ();
}

static void _call_cbs_eventFilter_2411_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QObject *arg1 = args.read<QObject * > (heap);
  QEvent *arg2 = args.read<QEvent * > (heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_eventFilter_2411_0 (arg1, arg2));
}

static void _set_callback_cbs_eventFilter_2411_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_eventFilter_2411_0 = cb;
}


// void QPdfWriter::initPainter(QPainter *painter)

static void _init_cbs_initPainter_c1426_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("painter");
  decl->add_arg<QPainter * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_initPainter_c1426_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPainter *arg1 = args.read<QPainter * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_initPainter_c1426_0 (arg1);
}

static void _set_callback_cbs_initPainter_c1426_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_initPainter_c1426_0 = cb;
}


// exposed bool QPdfWriter::isSignalConnected(const QMetaMethod &signal)

static void _init_fp_isSignalConnected_c2394 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const QMetaMethod & > (argspec_0);
  decl->set_return<bool > ();
}

static void _call_fp_isSignalConnected_c2394 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QMetaMethod &arg1 = gsi::arg_reader<const QMetaMethod & >() (args, heap);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_isSignalConnected_c2394 (arg1));
}


// int QPdfWriter::metric(QPaintDevice::PaintDeviceMetric id)

static void _init_cbs_metric_c3445_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("id");
  decl->add_arg<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (argspec_0);
  decl->set_return<int > ();
}

static void _call_cbs_metric_c3445_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & arg1 = args.read<const qt_gsi::Converter<QPaintDevice::PaintDeviceMetric>::target_type & > (heap);
  ret.write<int > ((int)((QPdfWriter_Adaptor *)cls)->cbs_metric_c3445_0 (arg1));
}

static void _set_callback_cbs_metric_c3445_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_metric_c3445_0 = cb;
}


// bool QPdfWriter::newPage()

static void _init_cbs_newPage_0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<bool > ();
}

static void _call_cbs_newPage_0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<bool > ((bool)((QPdfWriter_Adaptor *)cls)->cbs_newPage_0_0 ());
}

static void _set_callback_cbs_newPage_0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_newPage_0_0 = cb;
}


// emitter void QPdfWriter::objectNameChanged(const QString &objectName)

static void _init_emitter_objectNameChanged_4567 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("objectName");
  decl->add_arg<const QString & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_emitter_objectNameChanged_4567 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs & /*ret*/) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QString &arg1 = gsi::arg_reader<const QString & >() (args, heap);
  ((QPdfWriter_Adaptor *)cls)->emitter_QPdfWriter_objectNameChanged_4567 (arg1);
}


// QPaintEngine *QPdfWriter::paintEngine()

static void _init_cbs_paintEngine_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPaintEngine * > ();
}

static void _call_cbs_paintEngine_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPaintEngine * > ((QPaintEngine *)((QPdfWriter_Adaptor *)cls)->cbs_paintEngine_c0_0 ());
}

static void _set_callback_cbs_paintEngine_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_paintEngine_c0_0 = cb;
}


// exposed int QPdfWriter::receivers(const char *signal)

static void _init_fp_receivers_c1731 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("signal");
  decl->add_arg<const char * > (argspec_0);
  decl->set_return<int > ();
}

static void _call_fp_receivers_c1731 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const char *arg1 = gsi::arg_reader<const char * >() (args, heap);
  ret.write<int > ((int)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_receivers_c1731 (arg1));
}


// QPaintDevice *QPdfWriter::redirected(QPoint *offset)

static void _init_cbs_redirected_c1225_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("offset");
  decl->add_arg<QPoint * > (argspec_0);
  decl->set_return<QPaintDevice * > ();
}

static void _call_cbs_redirected_c1225_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QPoint *arg1 = args.read<QPoint * > (heap);
  ret.write<QPaintDevice * > ((QPaintDevice *)((QPdfWriter_Adaptor *)cls)->cbs_redirected_c1225_0 (arg1));
}

static void _set_callback_cbs_redirected_c1225_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_redirected_c1225_0 = cb;
}


// exposed QObject *QPdfWriter::sender()

static void _init_fp_sender_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QObject * > ();
}

static void _call_fp_sender_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QObject * > ((QObject *)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_sender_c0 ());
}


// exposed int QPdfWriter::senderSignalIndex()

static void _init_fp_senderSignalIndex_c0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<int > ();
}

static void _call_fp_senderSignalIndex_c0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<int > ((int)((QPdfWriter_Adaptor *)cls)->fp_QPdfWriter_senderSignalIndex_c0 ());
}


// void QPdfWriter::setMargins(const QPagedPaintDevice::Margins &m)

static void _init_cbs_setMargins_3812_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("m");
  decl->add_arg<const QPagedPaintDevice::Margins & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setMargins_3812_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QPagedPaintDevice::Margins &arg1 = args.read<const QPagedPaintDevice::Margins & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_setMargins_3812_0 (arg1);
}

static void _set_callback_cbs_setMargins_3812_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_setMargins_3812_0 = cb;
}


// void QPdfWriter::setPageSize(QPagedPaintDevice::PageSize size)

static void _init_cbs_setPageSize_3006_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPageSize_3006_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & arg1 = args.read<const qt_gsi::Converter<QPagedPaintDevice::PageSize>::target_type & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_setPageSize_3006_0 (arg1);
}

static void _set_callback_cbs_setPageSize_3006_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_setPageSize_3006_0 = cb;
}


// void QPdfWriter::setPageSizeMM(const QSizeF &size)

static void _init_cbs_setPageSizeMM_1875_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("size");
  decl->add_arg<const QSizeF & > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_setPageSizeMM_1875_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  const QSizeF &arg1 = args.read<const QSizeF & > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_setPageSizeMM_1875_0 (arg1);
}

static void _set_callback_cbs_setPageSizeMM_1875_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_setPageSizeMM_1875_0 = cb;
}


// QPainter *QPdfWriter::sharedPainter()

static void _init_cbs_sharedPainter_c0_0 (qt_gsi::GenericMethod *decl)
{
  decl->set_return<QPainter * > ();
}

static void _call_cbs_sharedPainter_c0_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  ret.write<QPainter * > ((QPainter *)((QPdfWriter_Adaptor *)cls)->cbs_sharedPainter_c0_0 ());
}

static void _set_callback_cbs_sharedPainter_c0_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_sharedPainter_c0_0 = cb;
}


// void QPdfWriter::timerEvent(QTimerEvent *)

static void _init_cbs_timerEvent_1730_0 (qt_gsi::GenericMethod *decl)
{
  static gsi::ArgSpecBase argspec_0 ("arg1");
  decl->add_arg<QTimerEvent * > (argspec_0);
  decl->set_return<void > ();
}

static void _call_cbs_timerEvent_1730_0 (const qt_gsi::GenericMethod * /*decl*/, void *cls, gsi::SerialArgs &args, gsi::SerialArgs &ret) 
{
  __SUPPRESS_UNUSED_WARNING(args);
  tl::Heap heap;
  QTimerEvent *arg1 = args.read<QTimerEvent * > (heap);
  __SUPPRESS_UNUSED_WARNING(ret);
  ((QPdfWriter_Adaptor *)cls)->cbs_timerEvent_1730_0 (arg1);
}

static void _set_callback_cbs_timerEvent_1730_0 (void *cls, const gsi::Callback &cb)
{
  ((QPdfWriter_Adaptor *)cls)->cb_timerEvent_1730_0 = cb;
}


namespace gsi
{

gsi::Class<QPdfWriter> &qtdecl_QPdfWriter ();

static gsi::Methods methods_QPdfWriter_Adaptor () {
  gsi::Methods methods;
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPdfWriter::QPdfWriter(const QString &filename)\nThis method creates an object of class QPdfWriter.", &_init_ctor_QPdfWriter_Adaptor_2025, &_call_ctor_QPdfWriter_Adaptor_2025);
  methods += new qt_gsi::GenericStaticMethod ("new", "@brief Constructor QPdfWriter::QPdfWriter(QIODevice *device)\nThis method creates an object of class QPdfWriter.", &_init_ctor_QPdfWriter_Adaptor_1447, &_call_ctor_QPdfWriter_Adaptor_1447);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@brief Virtual method void QPdfWriter::childEvent(QChildEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*childEvent", "@hide", false, &_init_cbs_childEvent_1701_0, &_call_cbs_childEvent_1701_0, &_set_callback_cbs_childEvent_1701_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@brief Virtual method void QPdfWriter::customEvent(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("*customEvent", "@hide", false, &_init_cbs_customEvent_1217_0, &_call_cbs_customEvent_1217_0, &_set_callback_cbs_customEvent_1217_0);
  methods += new qt_gsi::GenericMethod ("emit_destroyed", "@brief Emitter for signal void QPdfWriter::destroyed(QObject *)\nCall this method to emit this signal.", false, &_init_emitter_destroyed_1302, &_call_emitter_destroyed_1302);
  methods += new qt_gsi::GenericMethod ("*devicePageLayout", "@brief Method QPageLayout QPdfWriter::devicePageLayout()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_devicePageLayout_c0, &_call_fp_devicePageLayout_c0);
  methods += new qt_gsi::GenericMethod ("*devicePageLayout", "@brief Method QPageLayout &QPdfWriter::devicePageLayout()\nThis method is protected and can only be called from inside a derived class.", false, &_init_fp_devicePageLayout_0, &_call_fp_devicePageLayout_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@brief Virtual method void QPdfWriter::disconnectNotify(const QMetaMethod &signal)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("*disconnectNotify", "@hide", false, &_init_cbs_disconnectNotify_2394_0, &_call_cbs_disconnectNotify_2394_0, &_set_callback_cbs_disconnectNotify_2394_0);
  methods += new qt_gsi::GenericMethod ("event", "@brief Virtual method bool QPdfWriter::event(QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("event", "@hide", false, &_init_cbs_event_1217_0, &_call_cbs_event_1217_0, &_set_callback_cbs_event_1217_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@brief Virtual method bool QPdfWriter::eventFilter(QObject *, QEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("eventFilter", "@hide", false, &_init_cbs_eventFilter_2411_0, &_call_cbs_eventFilter_2411_0, &_set_callback_cbs_eventFilter_2411_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@brief Virtual method void QPdfWriter::initPainter(QPainter *painter)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*initPainter", "@hide", true, &_init_cbs_initPainter_c1426_0, &_call_cbs_initPainter_c1426_0, &_set_callback_cbs_initPainter_c1426_0);
  methods += new qt_gsi::GenericMethod ("*isSignalConnected", "@brief Method bool QPdfWriter::isSignalConnected(const QMetaMethod &signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_isSignalConnected_c2394, &_call_fp_isSignalConnected_c2394);
  methods += new qt_gsi::GenericMethod ("*metric", "@brief Virtual method int QPdfWriter::metric(QPaintDevice::PaintDeviceMetric id)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("*metric", "@hide", true, &_init_cbs_metric_c3445_0, &_call_cbs_metric_c3445_0, &_set_callback_cbs_metric_c3445_0);
  methods += new qt_gsi::GenericMethod ("newPage", "@brief Virtual method bool QPdfWriter::newPage()\nThis method can be reimplemented in a derived class.", false, &_init_cbs_newPage_0_0, &_call_cbs_newPage_0_0);
  methods += new qt_gsi::GenericMethod ("newPage", "@hide", false, &_init_cbs_newPage_0_0, &_call_cbs_newPage_0_0, &_set_callback_cbs_newPage_0_0);
  methods += new qt_gsi::GenericMethod ("emit_objectNameChanged", "@brief Emitter for signal void QPdfWriter::objectNameChanged(const QString &objectName)\nCall this method to emit this signal.", false, &_init_emitter_objectNameChanged_4567, &_call_emitter_objectNameChanged_4567);
  methods += new qt_gsi::GenericMethod ("*paintEngine", "@brief Virtual method QPaintEngine *QPdfWriter::paintEngine()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*paintEngine", "@hide", true, &_init_cbs_paintEngine_c0_0, &_call_cbs_paintEngine_c0_0, &_set_callback_cbs_paintEngine_c0_0);
  methods += new qt_gsi::GenericMethod ("*receivers", "@brief Method int QPdfWriter::receivers(const char *signal)\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_receivers_c1731, &_call_fp_receivers_c1731);
  methods += new qt_gsi::GenericMethod ("*redirected", "@brief Virtual method QPaintDevice *QPdfWriter::redirected(QPoint *offset)\nThis method can be reimplemented in a derived class.", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*redirected", "@hide", true, &_init_cbs_redirected_c1225_0, &_call_cbs_redirected_c1225_0, &_set_callback_cbs_redirected_c1225_0);
  methods += new qt_gsi::GenericMethod ("*sender", "@brief Method QObject *QPdfWriter::sender()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_sender_c0, &_call_fp_sender_c0);
  methods += new qt_gsi::GenericMethod ("*senderSignalIndex", "@brief Method int QPdfWriter::senderSignalIndex()\nThis method is protected and can only be called from inside a derived class.", true, &_init_fp_senderSignalIndex_c0, &_call_fp_senderSignalIndex_c0);
  methods += new qt_gsi::GenericMethod ("setMargins", "@brief Virtual method void QPdfWriter::setMargins(const QPagedPaintDevice::Margins &m)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setMargins_3812_0, &_call_cbs_setMargins_3812_0);
  methods += new qt_gsi::GenericMethod ("setMargins", "@hide", false, &_init_cbs_setMargins_3812_0, &_call_cbs_setMargins_3812_0, &_set_callback_cbs_setMargins_3812_0);
  methods += new qt_gsi::GenericMethod ("setPageSize", "@brief Virtual method void QPdfWriter::setPageSize(QPagedPaintDevice::PageSize size)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageSize_3006_0, &_call_cbs_setPageSize_3006_0);
  methods += new qt_gsi::GenericMethod ("setPageSize", "@hide", false, &_init_cbs_setPageSize_3006_0, &_call_cbs_setPageSize_3006_0, &_set_callback_cbs_setPageSize_3006_0);
  methods += new qt_gsi::GenericMethod ("setPageSizeMM", "@brief Virtual method void QPdfWriter::setPageSizeMM(const QSizeF &size)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_setPageSizeMM_1875_0, &_call_cbs_setPageSizeMM_1875_0);
  methods += new qt_gsi::GenericMethod ("setPageSizeMM", "@hide", false, &_init_cbs_setPageSizeMM_1875_0, &_call_cbs_setPageSizeMM_1875_0, &_set_callback_cbs_setPageSizeMM_1875_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@brief Virtual method QPainter *QPdfWriter::sharedPainter()\nThis method can be reimplemented in a derived class.", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*sharedPainter", "@hide", true, &_init_cbs_sharedPainter_c0_0, &_call_cbs_sharedPainter_c0_0, &_set_callback_cbs_sharedPainter_c0_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@brief Virtual method void QPdfWriter::timerEvent(QTimerEvent *)\nThis method can be reimplemented in a derived class.", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0);
  methods += new qt_gsi::GenericMethod ("*timerEvent", "@hide", false, &_init_cbs_timerEvent_1730_0, &_call_cbs_timerEvent_1730_0, &_set_callback_cbs_timerEvent_1730_0);
  return methods;
}

gsi::Class<QPdfWriter_Adaptor> decl_QPdfWriter_Adaptor (qtdecl_QPdfWriter (), "QtGui", "QPdfWriter",
  methods_QPdfWriter_Adaptor (),
  "@qt\n@brief Binding of QPdfWriter");

}

