/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.tag;

import java.io.IOException;
import java.io.Writer;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesJspException;
import net.sourceforge.stripes.tag.FormTag;
import net.sourceforge.stripes.tag.HtmlTagSupport;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.validation.ValidationError;
import net.sourceforge.stripes.validation.ValidationErrors;

public class ErrorsTag
extends HtmlTagSupport
implements BodyTag {
    private static final Log log = Log.getInstance(ErrorsTag.class);
    public static final String DEFAULT_HEADER = "<div class=\"errorHeader\">Validation Errors</div><ul>";
    public static final String DEFAULT_FOOTER = "</ul>";
    private boolean display = false;
    private boolean nestedErrorTagPresent = false;
    private String action;
    private String field;
    private boolean globalErrorsOnly;
    private SortedSet<ValidationError> allErrors;
    private Iterator<ValidationError> errorIterator;
    private ValidationError currentError;
    private int index = 0;

    public ValidationError getCurrentError() {
        this.nestedErrorTagPresent = true;
        return this.currentError;
    }

    public boolean isFirst() {
        return this.allErrors.first() == this.currentError;
    }

    public boolean isLast() {
        return this.allErrors.last() == this.currentError;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public String getAction() {
        return this.action;
    }

    public void setBeanclass(Object beanclass) throws StripesJspException {
        String url = this.getActionBeanUrl(beanclass);
        if (url == null) {
            throw new StripesJspException("The 'beanclass' attribute provided could not be used to identify a valid and configured ActionBean. The value supplied was: " + beanclass);
        }
        this.action = url;
    }

    public void setField(String field) {
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public boolean isGlobalErrorsOnly() {
        return this.globalErrorsOnly;
    }

    public void setGlobalErrorsOnly(boolean globalErrorsOnly) {
        this.globalErrorsOnly = globalErrorsOnly;
    }

    public int doStartTag() throws JspException {
        HttpServletRequest request = (HttpServletRequest)this.getPageContext().getRequest();
        ActionBean mainBean = (ActionBean)request.getAttribute("actionBean");
        FormTag formTag = this.getParentTag(FormTag.class);
        ValidationErrors errors = null;
        if (this.getAction() != null) {
            if (mainBean != null) {
                String mainAction = StripesFilter.getConfiguration().getActionResolver().getUrlBinding(mainBean.getClass());
                if (this.getAction().equals(mainAction)) {
                    errors = mainBean.getContext().getValidationErrors();
                }
            }
        } else if (formTag != null) {
            ActionBean formBean = formTag.getActionBean();
            if (formBean != null) {
                errors = formBean.getContext().getValidationErrors();
            }
        } else if (mainBean != null) {
            errors = mainBean.getContext().getValidationErrors();
        }
        if (errors != null) {
            this.allErrors = new TreeSet<ValidationError>(new ErrorComparator());
            if (this.field != null) {
                List fieldErrors = (List)errors.get(this.field);
                if (fieldErrors != null) {
                    this.allErrors.addAll(fieldErrors);
                }
            } else if (this.globalErrorsOnly) {
                List globalErrors = (List)errors.get("__stripes_global_error");
                if (globalErrors != null) {
                    this.allErrors.addAll(globalErrors);
                }
            } else {
                for (List fieldErrors : errors.values()) {
                    if (fieldErrors == null) continue;
                    this.allErrors.addAll(fieldErrors);
                }
            }
        }
        if (this.allErrors != null && this.allErrors.size() > 0) {
            this.display = true;
            this.errorIterator = this.allErrors.iterator();
            this.currentError = this.errorIterator.next();
            return 2;
        }
        this.display = false;
        return 0;
    }

    public void doInitBody() throws JspException {
        this.getPageContext().setAttribute("index", (Object)this.index);
        this.getPageContext().setAttribute("error", (Object)this.currentError);
    }

    public int doAfterBody() throws JspException {
        if (this.display && this.nestedErrorTagPresent && this.errorIterator.hasNext()) {
            this.currentError = this.errorIterator.next();
            ++this.index;
            this.getPageContext().setAttribute("index", (Object)this.index);
            this.getPageContext().setAttribute("error", (Object)this.currentError);
            return 2;
        }
        return 0;
    }

    public int doEndTag() throws JspException {
        try {
            JspWriter writer = this.getPageContext().getOut();
            if (this.display && !this.nestedErrorTagPresent) {
                Locale locale = this.getPageContext().getRequest().getLocale();
                ResourceBundle bundle = null;
                try {
                    bundle = StripesFilter.getConfiguration().getLocalizationBundleFactory().getErrorMessageBundle(locale);
                }
                catch (MissingResourceException mre) {
                    log.warn("The errors tag could not find the error messages resource bundle. ", "As a result default headers/footers etc. will be used. Check that ", "you have a StripesResources.properties in your classpath (unless ", "of course you have configured a different bundle).");
                }
                String header = this.getResource(bundle, "header", DEFAULT_HEADER);
                String footer = this.getResource(bundle, "footer", DEFAULT_FOOTER);
                String openElement = this.getResource(bundle, "beforeError", "<li>");
                String closeElement = this.getResource(bundle, "afterError", "</li>");
                writer.write(header);
                for (ValidationError fieldError : this.allErrors) {
                    String message = fieldError.getMessage(locale);
                    if (message == null || message.length() <= 0) continue;
                    writer.write(openElement);
                    writer.write(message);
                    writer.write(closeElement);
                }
                writer.write(footer);
            } else if (this.display && this.nestedErrorTagPresent) {
                this.getBodyContent().writeOut((Writer)writer);
            }
            this.display = false;
            this.nestedErrorTagPresent = false;
            this.field = null;
            this.allErrors = null;
            this.errorIterator = null;
            this.currentError = null;
            this.index = 0;
            return 6;
        }
        catch (IOException e) {
            JspException jspe = new JspException("IOException encountered while writing errors tag to the JspWriter.", (Throwable)e);
            log.warn((Throwable)jspe, new Object[0]);
            throw jspe;
        }
    }

    protected String getResource(ResourceBundle bundle, String name, String fallback) {
        if (bundle == null) {
            return fallback;
        }
        String resource = null;
        if (this.field != null) {
            try {
                resource = bundle.getString("stripes.fieldErrors." + name);
            }
            catch (MissingResourceException mre) {
                // empty catch block
            }
        }
        if (resource == null) {
            try {
                resource = bundle.getString("stripes.errors." + name);
            }
            catch (MissingResourceException mre) {
                resource = fallback;
            }
        }
        return resource;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ErrorComparator
    implements Comparator<ValidationError> {
        private ErrorComparator() {
        }

        @Override
        public int compare(ValidationError e1, ValidationError e2) {
            boolean e2Global;
            if (e1.equals(e2)) {
                return 0;
            }
            String fn1 = e1.getFieldName();
            String fn2 = e2.getFieldName();
            boolean e1Global = fn1 == null || fn1.equals("__stripes_global_error");
            boolean bl = e2Global = fn2 == null || fn2.equals("__stripes_global_error");
            if (e1Global && !e2Global) {
                return -1;
            }
            if (e2Global && !e1Global) {
                return 1;
            }
            if (fn1 == null && fn2 == null) {
                return 0;
            }
            int result = e1.getFieldName().compareTo(e2.getFieldName());
            if (result == 0) {
                result = 1;
            }
            return result;
        }
    }
}

