# gozerbot/plughelp.py
#
#

"""
   help about plugins.

"""

__copyright__ = 'this file is in the public domain'

## IMPORT SECTION

# no imports

## END IMPORT

## LOCK SECTION

# no locks

## END LOCK

class PlugHelp(dict):

    """
        dict holding plugins help string.

    """ 

    def add(self, item, descr):

        """
            add plugin help string.

            :param item: the plugin to store description for
            :type item: string
            :param descr: the description of the plugin
            :type descr: string

            .. literalinclude ../../gozerbot/plughelp.py
                :pyobject: PlugHelp.add

        """

        item = item.lower()
        self[item] = descr

    def get(self, item):

        """
            get plugin help string.

            :param item: plugin to get description for
            :type item: string
            :rtype: string

            .. literalinclude:: ../../gozerbot/plughelp.py
                :pyobject: PlugHelp.get
        """

        item = item.lower()
        try:
            return self[item]
        except KeyError:
            return None

## INIT SECTION

# plughelp object
plughelp = PlugHelp()

# END INIT
