// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1/prediction_service.proto

package automl

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Request message for [PredictionService.Predict][google.cloud.automl.v1.PredictionService.Predict].
type PredictRequest struct {
	// Required. Name of the model requested to serve the prediction.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. Payload to perform a prediction on. The payload must match the
	// problem type that the model was trained to solve.
	Payload *ExamplePayload `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// Additional domain-specific parameters, any string must be up to 25000
	// characters long.
	//
	// <h4>AutoML Vision Classification</h4>
	//
	// `score_threshold`
	// : (float) A value from 0.0 to 1.0. When the model
	//   makes predictions for an image, it will only produce results that have
	//   at least this confidence score. The default is 0.5.
	//
	// <h4>AutoML Vision Object Detection</h4>
	//
	// `score_threshold`
	// : (float) When Model detects objects on the image,
	//   it will only produce bounding boxes which have at least this
	//   confidence score. Value in 0 to 1 range, default is 0.5.
	//
	// `max_bounding_box_count`
	// : (int64) The maximum number of bounding
	//   boxes returned. The default is 100. The
	//   number of returned bounding boxes might be limited by the server.
	//
	// <h4>AutoML Tables</h4>
	//
	// `feature_importance`
	// : (boolean) Whether
	//
	// [feature_importance][google.cloud.automl.v1.TablesModelColumnInfo.feature_importance]
	//   is populated in the returned list of
	//   [TablesAnnotation][google.cloud.automl.v1.TablesAnnotation]
	//   objects. The default is false.
	Params               map[string]string `protobuf:"bytes,3,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PredictRequest) Reset()         { *m = PredictRequest{} }
func (m *PredictRequest) String() string { return proto.CompactTextString(m) }
func (*PredictRequest) ProtoMessage()    {}
func (*PredictRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a60105ec759f54a4, []int{0}
}

func (m *PredictRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictRequest.Unmarshal(m, b)
}
func (m *PredictRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictRequest.Marshal(b, m, deterministic)
}
func (m *PredictRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictRequest.Merge(m, src)
}
func (m *PredictRequest) XXX_Size() int {
	return xxx_messageInfo_PredictRequest.Size(m)
}
func (m *PredictRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictRequest.DiscardUnknown(m)
}

var xxx_messageInfo_PredictRequest proto.InternalMessageInfo

func (m *PredictRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *PredictRequest) GetPayload() *ExamplePayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *PredictRequest) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

// Response message for [PredictionService.Predict][google.cloud.automl.v1.PredictionService.Predict].
type PredictResponse struct {
	// Prediction result.
	// AutoML Translation and AutoML Natural Language Sentiment Analysis
	// return precisely one payload.
	Payload []*AnnotationPayload `protobuf:"bytes,1,rep,name=payload,proto3" json:"payload,omitempty"`
	// The preprocessed example that AutoML actually makes prediction on.
	// Empty if AutoML does not preprocess the input example.
	//
	// For AutoML Natural Language (Classification, Entity Extraction, and
	// Sentiment Analysis), if the input is a document, the recognized text is
	// returned in the
	// [document_text][google.cloud.automl.v1.Document.document_text]
	// property.
	PreprocessedInput *ExamplePayload `protobuf:"bytes,3,opt,name=preprocessed_input,json=preprocessedInput,proto3" json:"preprocessed_input,omitempty"`
	// Additional domain-specific prediction response metadata.
	//
	// <h4>AutoML Vision Object Detection</h4>
	//
	// `max_bounding_box_count`
	// : (int64) The maximum number of bounding boxes to return per image.
	//
	// <h4>AutoML Natural Language Sentiment Analysis</h4>
	//
	// `sentiment_score`
	// : (float, deprecated) A value between -1 and 1,
	//   -1 maps to least positive sentiment, while 1 maps to the most positive
	//   one and the higher the score, the more positive the sentiment in the
	//   document is. Yet these values are relative to the training data, so
	//   e.g. if all data was positive then -1 is also positive (though
	//   the least).
	//   `sentiment_score` is not the same as "score" and "magnitude"
	//   from Sentiment Analysis in the Natural Language API.
	Metadata             map[string]string `protobuf:"bytes,2,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *PredictResponse) Reset()         { *m = PredictResponse{} }
func (m *PredictResponse) String() string { return proto.CompactTextString(m) }
func (*PredictResponse) ProtoMessage()    {}
func (*PredictResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_a60105ec759f54a4, []int{1}
}

func (m *PredictResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PredictResponse.Unmarshal(m, b)
}
func (m *PredictResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PredictResponse.Marshal(b, m, deterministic)
}
func (m *PredictResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PredictResponse.Merge(m, src)
}
func (m *PredictResponse) XXX_Size() int {
	return xxx_messageInfo_PredictResponse.Size(m)
}
func (m *PredictResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_PredictResponse.DiscardUnknown(m)
}

var xxx_messageInfo_PredictResponse proto.InternalMessageInfo

func (m *PredictResponse) GetPayload() []*AnnotationPayload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (m *PredictResponse) GetPreprocessedInput() *ExamplePayload {
	if m != nil {
		return m.PreprocessedInput
	}
	return nil
}

func (m *PredictResponse) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Request message for [PredictionService.BatchPredict][google.cloud.automl.v1.PredictionService.BatchPredict].
type BatchPredictRequest struct {
	// Required. Name of the model requested to serve the batch prediction.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The input configuration for batch prediction.
	InputConfig *BatchPredictInputConfig `protobuf:"bytes,3,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Required. The Configuration specifying where output predictions should
	// be written.
	OutputConfig *BatchPredictOutputConfig `protobuf:"bytes,4,opt,name=output_config,json=outputConfig,proto3" json:"output_config,omitempty"`
	// Additional domain-specific parameters for the predictions, any string must
	// be up to 25000 characters long.
	//
	// <h4>AutoML Natural Language Classification</h4>
	//
	// `score_threshold`
	// : (float) A value from 0.0 to 1.0. When the model
	//   makes predictions for a text snippet, it will only produce results
	//   that have at least this confidence score. The default is 0.5.
	//
	//
	// <h4>AutoML Vision Classification</h4>
	//
	// `score_threshold`
	// : (float) A value from 0.0 to 1.0. When the model
	//   makes predictions for an image, it will only produce results that
	//   have at least this confidence score. The default is 0.5.
	//
	// <h4>AutoML Vision Object Detection</h4>
	//
	// `score_threshold`
	// : (float) When Model detects objects on the image,
	//   it will only produce bounding boxes which have at least this
	//   confidence score. Value in 0 to 1 range, default is 0.5.
	//
	// `max_bounding_box_count`
	// : (int64) The maximum number of bounding
	//   boxes returned per image. The default is 100, the
	//   number of bounding boxes returned might be limited by the server.
	// <h4>AutoML Video Intelligence Classification</h4>
	//
	// `score_threshold`
	// : (float) A value from 0.0 to 1.0. When the model
	//   makes predictions for a video, it will only produce results that
	//   have at least this confidence score. The default is 0.5.
	//
	// `segment_classification`
	// : (boolean) Set to true to request
	//   segment-level classification. AutoML Video Intelligence returns
	//   labels and their confidence scores for the entire segment of the
	//   video that user specified in the request configuration.
	//   The default is true.
	//
	// `shot_classification`
	// : (boolean) Set to true to request shot-level
	//   classification. AutoML Video Intelligence determines the boundaries
	//   for each camera shot in the entire segment of the video that user
	//   specified in the request configuration. AutoML Video Intelligence
	//   then returns labels and their confidence scores for each detected
	//   shot, along with the start and end time of the shot.
	//   The default is false.
	//
	//   WARNING: Model evaluation is not done for this classification type,
	//   the quality of it depends on training data, but there are no metrics
	//   provided to describe that quality.
	//
	// `1s_interval_classification`
	// : (boolean) Set to true to request
	//   classification for a video at one-second intervals. AutoML Video
	//   Intelligence returns labels and their confidence scores for each
	//   second of the entire segment of the video that user specified in the
	//   request configuration. The default is false.
	//
	//   WARNING: Model evaluation is not done for this classification
	//   type, the quality of it depends on training data, but there are no
	//   metrics provided to describe that quality.
	//
	// <h4>AutoML Video Intelligence Object Tracking</h4>
	//
	// `score_threshold`
	// : (float) When Model detects objects on video frames,
	//   it will only produce bounding boxes which have at least this
	//   confidence score. Value in 0 to 1 range, default is 0.5.
	//
	// `max_bounding_box_count`
	// : (int64) The maximum number of bounding
	//   boxes returned per image. The default is 100, the
	//   number of bounding boxes returned might be limited by the server.
	//
	// `min_bounding_box_size`
	// : (float) Only bounding boxes with shortest edge
	//   at least that long as a relative value of video frame size are
	//   returned. Value in 0 to 1 range. Default is 0.
	//
	Params               map[string]string `protobuf:"bytes,5,rep,name=params,proto3" json:"params,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BatchPredictRequest) Reset()         { *m = BatchPredictRequest{} }
func (m *BatchPredictRequest) String() string { return proto.CompactTextString(m) }
func (*BatchPredictRequest) ProtoMessage()    {}
func (*BatchPredictRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_a60105ec759f54a4, []int{2}
}

func (m *BatchPredictRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchPredictRequest.Unmarshal(m, b)
}
func (m *BatchPredictRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchPredictRequest.Marshal(b, m, deterministic)
}
func (m *BatchPredictRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchPredictRequest.Merge(m, src)
}
func (m *BatchPredictRequest) XXX_Size() int {
	return xxx_messageInfo_BatchPredictRequest.Size(m)
}
func (m *BatchPredictRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchPredictRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchPredictRequest proto.InternalMessageInfo

func (m *BatchPredictRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *BatchPredictRequest) GetInputConfig() *BatchPredictInputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *BatchPredictRequest) GetOutputConfig() *BatchPredictOutputConfig {
	if m != nil {
		return m.OutputConfig
	}
	return nil
}

func (m *BatchPredictRequest) GetParams() map[string]string {
	if m != nil {
		return m.Params
	}
	return nil
}

// Result of the Batch Predict. This message is returned in
// [response][google.longrunning.Operation.response] of the operation returned
// by the [PredictionService.BatchPredict][google.cloud.automl.v1.PredictionService.BatchPredict].
type BatchPredictResult struct {
	// Additional domain-specific prediction response metadata.
	//
	// <h4>AutoML Vision Object Detection</h4>
	//
	// `max_bounding_box_count`
	// : (int64) The maximum number of bounding boxes returned per image.
	//
	// <h4>AutoML Video Intelligence Object Tracking</h4>
	//
	// `max_bounding_box_count`
	// : (int64) The maximum number of bounding boxes returned per frame.
	Metadata             map[string]string `protobuf:"bytes,1,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *BatchPredictResult) Reset()         { *m = BatchPredictResult{} }
func (m *BatchPredictResult) String() string { return proto.CompactTextString(m) }
func (*BatchPredictResult) ProtoMessage()    {}
func (*BatchPredictResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_a60105ec759f54a4, []int{3}
}

func (m *BatchPredictResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchPredictResult.Unmarshal(m, b)
}
func (m *BatchPredictResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchPredictResult.Marshal(b, m, deterministic)
}
func (m *BatchPredictResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchPredictResult.Merge(m, src)
}
func (m *BatchPredictResult) XXX_Size() int {
	return xxx_messageInfo_BatchPredictResult.Size(m)
}
func (m *BatchPredictResult) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchPredictResult.DiscardUnknown(m)
}

var xxx_messageInfo_BatchPredictResult proto.InternalMessageInfo

func (m *BatchPredictResult) GetMetadata() map[string]string {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func init() {
	proto.RegisterType((*PredictRequest)(nil), "google.cloud.automl.v1.PredictRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.PredictRequest.ParamsEntry")
	proto.RegisterType((*PredictResponse)(nil), "google.cloud.automl.v1.PredictResponse")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.PredictResponse.MetadataEntry")
	proto.RegisterType((*BatchPredictRequest)(nil), "google.cloud.automl.v1.BatchPredictRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.BatchPredictRequest.ParamsEntry")
	proto.RegisterType((*BatchPredictResult)(nil), "google.cloud.automl.v1.BatchPredictResult")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.automl.v1.BatchPredictResult.MetadataEntry")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1/prediction_service.proto", fileDescriptor_a60105ec759f54a4)
}

var fileDescriptor_a60105ec759f54a4 = []byte{
	// 846 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x55, 0xcf, 0x4f, 0xdb, 0x48,
	0x14, 0x96, 0x1d, 0x7e, 0x2c, 0x13, 0xd8, 0x5d, 0x86, 0x5d, 0x36, 0x78, 0x17, 0x2d, 0x0a, 0x12,
	0xb0, 0x59, 0xd6, 0xb3, 0xc9, 0x6a, 0x15, 0x6a, 0xe8, 0xc1, 0x41, 0xa8, 0xa2, 0x2a, 0x22, 0x0d,
	0x2d, 0x95, 0x10, 0x52, 0x34, 0x38, 0x83, 0xe3, 0xd6, 0xf6, 0xb8, 0xf6, 0x38, 0x14, 0x55, 0xbd,
	0x54, 0xea, 0xb9, 0x87, 0xaa, 0xea, 0x9f, 0x50, 0xa9, 0x97, 0xfe, 0x05, 0xbd, 0xf4, 0xc8, 0xb1,
	0xbd, 0x71, 0xe2, 0xd0, 0x53, 0x8f, 0x3d, 0xf6, 0x54, 0x79, 0xc6, 0x49, 0x9c, 0x40, 0x44, 0x22,
	0x95, 0x5b, 0xe2, 0xf7, 0xbe, 0xef, 0xbd, 0xf7, 0xcd, 0x37, 0xf3, 0x00, 0x32, 0x29, 0x35, 0x6d,
	0x82, 0x0c, 0x9b, 0x86, 0x35, 0x84, 0x43, 0x46, 0x1d, 0x1b, 0x35, 0xf2, 0xc8, 0xf3, 0x49, 0xcd,
	0x32, 0x98, 0x45, 0xdd, 0x6a, 0x40, 0xfc, 0x86, 0x65, 0x10, 0xd5, 0xf3, 0x29, 0xa3, 0x70, 0x5a,
	0x00, 0x54, 0x0e, 0x50, 0x05, 0x40, 0x6d, 0xe4, 0x95, 0x3f, 0x62, 0x22, 0xec, 0x59, 0x08, 0xbb,
	0x2e, 0x65, 0x38, 0x02, 0x07, 0x02, 0xa5, 0xfc, 0x96, 0x88, 0x1a, 0xb6, 0x45, 0x5c, 0x16, 0x07,
	0xfe, 0x4c, 0x04, 0x0e, 0x2d, 0x62, 0xd7, 0xaa, 0x07, 0xa4, 0x8e, 0x1b, 0x16, 0xf5, 0xe3, 0x84,
	0x99, 0x44, 0x82, 0x4f, 0x02, 0x1a, 0xfa, 0xcd, 0x56, 0x94, 0x5e, 0xbd, 0xb7, 0xcb, 0x57, 0x3d,
	0x7c, 0x6c, 0x53, 0x5c, 0x8b, 0x01, 0x8b, 0x3d, 0x00, 0x35, 0xcc, 0x70, 0xd5, 0x62, 0xc4, 0x09,
	0xba, 0xba, 0xea, 0x4e, 0xb4, 0xe8, 0x25, 0x4c, 0xd4, 0x23, 0x7e, 0xc7, 0xe0, 0xf3, 0x71, 0xa2,
	0x4d, 0x5d, 0xd3, 0x0f, 0x5d, 0xd7, 0x72, 0xcd, 0x73, 0x49, 0xd9, 0x57, 0x32, 0xf8, 0xb1, 0x2c,
	0x04, 0xaf, 0x90, 0x87, 0x21, 0x09, 0x18, 0x2c, 0x82, 0x21, 0x17, 0x3b, 0x24, 0x23, 0xcd, 0x49,
	0x4b, 0x63, 0xa5, 0xf9, 0x33, 0x5d, 0xfe, 0xaa, 0xcf, 0x82, 0xdf, 0x63, 0xbd, 0x05, 0x29, 0xf6,
	0xac, 0x40, 0x35, 0xa8, 0x83, 0xb6, 0x68, 0x8d, 0xd8, 0x15, 0x0e, 0x80, 0x1b, 0x60, 0x34, 0x1e,
	0x3a, 0x23, 0xcf, 0x49, 0x4b, 0xe9, 0xc2, 0x82, 0x7a, 0xf1, 0x89, 0xa9, 0x1b, 0x8f, 0xb0, 0xe3,
	0xd9, 0xa4, 0x2c, 0xb2, 0x4b, 0xa9, 0x33, 0x5d, 0xae, 0x34, 0xb1, 0xf0, 0x26, 0x18, 0xf1, 0xb0,
	0x8f, 0x9d, 0x20, 0x93, 0x9a, 0x4b, 0x2d, 0xa5, 0x0b, 0x85, 0x5e, 0x2c, 0x9d, 0x7d, 0xab, 0x65,
	0x0e, 0xda, 0x70, 0x99, 0x7f, 0x5c, 0x89, 0x19, 0x94, 0x6b, 0x20, 0x9d, 0xf8, 0x0c, 0x7f, 0x06,
	0xa9, 0x07, 0xe4, 0x58, 0x4c, 0x56, 0x89, 0x7e, 0xc2, 0x5f, 0xc0, 0x70, 0x03, 0xdb, 0x21, 0xe1,
	0x1d, 0x8f, 0x55, 0xc4, 0x1f, 0x4d, 0x5e, 0x91, 0xb2, 0xef, 0x64, 0xf0, 0x53, 0xab, 0x42, 0xe0,
	0x51, 0x37, 0x20, 0x70, 0xbd, 0x3d, 0xa1, 0xc4, 0x7b, 0xfb, 0xab, 0x57, 0x6f, 0x7a, 0xcb, 0x08,
	0xf1, 0x90, 0xed, 0xf9, 0xee, 0x02, 0xe8, 0xf9, 0xc4, 0xf3, 0xa9, 0x41, 0x82, 0x80, 0xd4, 0xaa,
	0x96, 0xeb, 0x85, 0x2c, 0x93, 0x1a, 0x44, 0xb1, 0xca, 0x64, 0x92, 0x61, 0x33, 0x22, 0x80, 0xb7,
	0xc1, 0x0f, 0x0e, 0x61, 0x38, 0x32, 0x54, 0x46, 0xe6, 0xcd, 0xfd, 0x7f, 0xa9, 0x70, 0x62, 0x2c,
	0x75, 0x2b, 0xc6, 0x09, 0xed, 0x5a, 0x34, 0xca, 0x2a, 0x98, 0xe8, 0x08, 0x0d, 0xa4, 0xdf, 0xf3,
	0x14, 0x98, 0x2a, 0x61, 0x66, 0xd4, 0xbf, 0x97, 0xbd, 0xee, 0x81, 0x71, 0x2e, 0x55, 0xd5, 0xa0,
	0xee, 0xa1, 0x65, 0xc6, 0x8a, 0xa1, 0x5e, 0x43, 0x26, 0x6b, 0x73, 0x85, 0xd6, 0x39, 0x4c, 0x98,
	0x2d, 0x6d, 0xb5, 0xbf, 0xc0, 0x3d, 0x30, 0x41, 0x43, 0x96, 0x60, 0x1e, 0xe2, 0xcc, 0xff, 0xf6,
	0xc3, 0xbc, 0xcd, 0x81, 0x49, 0xea, 0x71, 0x9a, 0xf8, 0x04, 0xb7, 0x5b, 0x66, 0x1e, 0xe6, 0x67,
	0x52, 0xec, 0x87, 0xf4, 0x8a, 0x1c, 0xfd, 0x5a, 0x02, 0xb0, 0xb3, 0x4c, 0x10, 0xda, 0x0c, 0xde,
	0x49, 0x18, 0x47, 0xb8, 0x7a, 0xa5, 0xbf, 0x26, 0x23, 0xf4, 0x95, 0x78, 0xa7, 0xf0, 0x6c, 0x08,
	0x4c, 0x96, 0x5b, 0x6b, 0x60, 0x47, 0x6c, 0x01, 0xf8, 0x56, 0x02, 0xa3, 0xf1, 0x57, 0xb8, 0xd0,
	0xdf, 0xa3, 0xa0, 0x2c, 0xf6, 0x79, 0x07, 0xb2, 0x3b, 0xa7, 0xfa, 0x54, 0x64, 0xb3, 0xe5, 0xf8,
	0x9a, 0x2e, 0x0b, 0xbd, 0x9f, 0x7e, 0xfc, 0xf4, 0x42, 0x2e, 0x66, 0x0b, 0xd1, 0x0b, 0xfb, 0x38,
	0x8a, 0x5f, 0xf7, 0x7c, 0x7a, 0x9f, 0x18, 0x2c, 0x40, 0x39, 0x64, 0x53, 0x43, 0x3c, 0xa6, 0x28,
	0x87, 0x9c, 0xc8, 0xa9, 0x01, 0xca, 0x3d, 0xd1, 0xe2, 0xfd, 0xa5, 0x49, 0x39, 0xf8, 0x45, 0x02,
	0xe3, 0x49, 0xcd, 0xe0, 0xdf, 0x03, 0x1c, 0xbf, 0x32, 0xdb, 0x4c, 0x4e, 0xbc, 0xe0, 0xea, 0x76,
	0xf3, 0x05, 0xcf, 0xbe, 0x94, 0x4e, 0xf4, 0xc5, 0x0b, 0x4f, 0x74, 0xb2, 0x95, 0xd4, 0x3c, 0x82,
	0x53, 0x7d, 0x81, 0x0f, 0x97, 0xbc, 0x40, 0xcb, 0x1d, 0xa6, 0x4f, 0xce, 0xbb, 0x96, 0x2d, 0x0e,
	0x30, 0xef, 0x41, 0xa2, 0x01, 0x4d, 0xca, 0x29, 0x9b, 0x27, 0xfa, 0xaf, 0x17, 0xde, 0xe6, 0x0f,
	0xba, 0x5a, 0x67, 0xcc, 0x0b, 0x34, 0x84, 0x8e, 0x8e, 0x8e, 0xba, 0xaf, 0x3a, 0x0e, 0x59, 0x5d,
	0x2c, 0xb5, 0x7f, 0x3c, 0x1b, 0xb3, 0x43, 0xea, 0x3b, 0xa5, 0xf7, 0x12, 0x50, 0x0c, 0xea, 0xf4,
	0x10, 0xad, 0x34, 0x7d, 0xce, 0x23, 0xe5, 0x68, 0xa9, 0x95, 0xa5, 0xbd, 0xb5, 0x18, 0x61, 0x52,
	0x1b, 0xbb, 0xa6, 0x4a, 0x7d, 0x13, 0x99, 0xc4, 0xe5, 0x2b, 0x0f, 0xb5, 0xeb, 0x76, 0xef, 0xd0,
	0x55, 0xf1, 0xeb, 0x8d, 0x3c, 0x7d, 0x43, 0xc0, 0xd7, 0x79, 0x41, 0x3d, 0x64, 0x74, 0xeb, 0x96,
	0xba, 0x9b, 0x3f, 0x69, 0x06, 0xf6, 0x79, 0x60, 0x9f, 0x07, 0xec, 0xfd, 0xdd, 0xfc, 0x67, 0x79,
	0x46, 0x04, 0x34, 0x8d, 0x47, 0x34, 0x4d, 0x60, 0x34, 0x6d, 0x37, 0x7f, 0x30, 0xc2, 0xcb, 0xfe,
	0xf7, 0x2d, 0x00, 0x00, 0xff, 0xff, 0xb4, 0xe8, 0xfe, 0x05, 0xf0, 0x08, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PredictionServiceClient is the client API for PredictionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PredictionServiceClient interface {
	// Perform an online prediction. The prediction result is directly
	// returned in the response.
	// Available for following ML scenarios, and their expected request payloads:
	//
	// <table>
	// <tr>
	// <td>AutoML Vision Classification</td>
	// <td>An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Vision Object Detection</td>
	// <td>An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Natural Language Classification</td>
	// <td>A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
	// .PDF, .TIF or .TIFF format with size upto 2MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Natural Language Entity Extraction</td>
	// <td>A TextSnippet up to 10,000 characters, UTF-8 NFC encoded or a document
	//  in .PDF, .TIF or .TIFF format with size upto 20MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Natural Language Sentiment Analysis</td>
	// <td>A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
	// .PDF, .TIF or .TIFF format with size upto 2MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Translation</td>
	// <td>A TextSnippet up to 25,000 characters, UTF-8 encoded.</td>
	// </tr>
	// <tr>
	// <td>AutoML Tables</td>
	// <td>A row with column values matching
	//   the columns of the model, up to 5MB. Not available for FORECASTING
	//   `prediction_type`.
	// </td>
	// </tr>
	// </table>
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error)
	// Perform a batch prediction. Unlike the online [Predict][google.cloud.automl.v1.PredictionService.Predict], batch
	// prediction result won't be immediately available in the response. Instead,
	// a long running operation object is returned. User can poll the operation
	// result via [GetOperation][google.longrunning.Operations.GetOperation]
	// method. Once the operation is done, [BatchPredictResult][google.cloud.automl.v1.BatchPredictResult] is returned in
	// the [response][google.longrunning.Operation.response] field.
	// Available for following ML scenarios:
	//
	// * AutoML Vision Classification
	// * AutoML Vision Object Detection
	// * AutoML Video Intelligence Classification
	// * AutoML Video Intelligence Object Tracking * AutoML Natural Language Classification
	// * AutoML Natural Language Entity Extraction
	// * AutoML Natural Language Sentiment Analysis
	// * AutoML Tables
	BatchPredict(ctx context.Context, in *BatchPredictRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type predictionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPredictionServiceClient(cc grpc.ClientConnInterface) PredictionServiceClient {
	return &predictionServiceClient{cc}
}

func (c *predictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error) {
	out := new(PredictResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.PredictionService/Predict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) BatchPredict(ctx context.Context, in *BatchPredictRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.automl.v1.PredictionService/BatchPredict", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PredictionServiceServer is the server API for PredictionService service.
type PredictionServiceServer interface {
	// Perform an online prediction. The prediction result is directly
	// returned in the response.
	// Available for following ML scenarios, and their expected request payloads:
	//
	// <table>
	// <tr>
	// <td>AutoML Vision Classification</td>
	// <td>An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Vision Object Detection</td>
	// <td>An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Natural Language Classification</td>
	// <td>A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
	// .PDF, .TIF or .TIFF format with size upto 2MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Natural Language Entity Extraction</td>
	// <td>A TextSnippet up to 10,000 characters, UTF-8 NFC encoded or a document
	//  in .PDF, .TIF or .TIFF format with size upto 20MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Natural Language Sentiment Analysis</td>
	// <td>A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
	// .PDF, .TIF or .TIFF format with size upto 2MB.</td>
	// </tr>
	// <tr>
	// <td>AutoML Translation</td>
	// <td>A TextSnippet up to 25,000 characters, UTF-8 encoded.</td>
	// </tr>
	// <tr>
	// <td>AutoML Tables</td>
	// <td>A row with column values matching
	//   the columns of the model, up to 5MB. Not available for FORECASTING
	//   `prediction_type`.
	// </td>
	// </tr>
	// </table>
	Predict(context.Context, *PredictRequest) (*PredictResponse, error)
	// Perform a batch prediction. Unlike the online [Predict][google.cloud.automl.v1.PredictionService.Predict], batch
	// prediction result won't be immediately available in the response. Instead,
	// a long running operation object is returned. User can poll the operation
	// result via [GetOperation][google.longrunning.Operations.GetOperation]
	// method. Once the operation is done, [BatchPredictResult][google.cloud.automl.v1.BatchPredictResult] is returned in
	// the [response][google.longrunning.Operation.response] field.
	// Available for following ML scenarios:
	//
	// * AutoML Vision Classification
	// * AutoML Vision Object Detection
	// * AutoML Video Intelligence Classification
	// * AutoML Video Intelligence Object Tracking * AutoML Natural Language Classification
	// * AutoML Natural Language Entity Extraction
	// * AutoML Natural Language Sentiment Analysis
	// * AutoML Tables
	BatchPredict(context.Context, *BatchPredictRequest) (*longrunning.Operation, error)
}

// UnimplementedPredictionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedPredictionServiceServer struct {
}

func (*UnimplementedPredictionServiceServer) Predict(ctx context.Context, req *PredictRequest) (*PredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Predict not implemented")
}
func (*UnimplementedPredictionServiceServer) BatchPredict(ctx context.Context, req *BatchPredictRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchPredict not implemented")
}

func RegisterPredictionServiceServer(s *grpc.Server, srv PredictionServiceServer) {
	s.RegisterService(&_PredictionService_serviceDesc, srv)
}

func _PredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.PredictionService/Predict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_BatchPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).BatchPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.automl.v1.PredictionService/BatchPredict",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).BatchPredict(ctx, req.(*BatchPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PredictionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.automl.v1.PredictionService",
	HandlerType: (*PredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _PredictionService_Predict_Handler,
		},
		{
			MethodName: "BatchPredict",
			Handler:    _PredictionService_BatchPredict_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/automl/v1/prediction_service.proto",
}
