// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/osconfig/v1beta/guest_policies.proto

package osconfig

import (
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// The desired state that the OS Config agent maintains on the VM instance.
type DesiredState int32

const (
	// The default is to ensure the package is installed.
	DesiredState_DESIRED_STATE_UNSPECIFIED DesiredState = 0
	// The agent ensures that the package is installed.
	DesiredState_INSTALLED DesiredState = 1
	// The agent ensures that the package is installed and
	// periodically checks for and install any updates.
	DesiredState_UPDATED DesiredState = 2
	// The agent ensures that the package is not installed and uninstall it
	// if detected.
	DesiredState_REMOVED DesiredState = 3
)

var DesiredState_name = map[int32]string{
	0: "DESIRED_STATE_UNSPECIFIED",
	1: "INSTALLED",
	2: "UPDATED",
	3: "REMOVED",
}

var DesiredState_value = map[string]int32{
	"DESIRED_STATE_UNSPECIFIED": 0,
	"INSTALLED":                 1,
	"UPDATED":                   2,
	"REMOVED":                   3,
}

func (x DesiredState) String() string {
	return proto.EnumName(DesiredState_name, int32(x))
}

func (DesiredState) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{0}
}

// Types of package managers that may be used to manage this package.
type Package_Manager int32

const (
	// The default behavior is ANY.
	Package_MANAGER_UNSPECIFIED Package_Manager = 0
	// Apply this package config using the default system package manager.
	Package_ANY Package_Manager = 1
	// Apply this package config only if Apt is available on the system.
	Package_APT Package_Manager = 2
	// Apply this package config only if Yum is available on the system.
	Package_YUM Package_Manager = 3
	// Apply this package config only if Zypper is available on the system.
	Package_ZYPPER Package_Manager = 4
	// Apply this package config only if GooGet is available on the system.
	Package_GOO Package_Manager = 5
)

var Package_Manager_name = map[int32]string{
	0: "MANAGER_UNSPECIFIED",
	1: "ANY",
	2: "APT",
	3: "YUM",
	4: "ZYPPER",
	5: "GOO",
}

var Package_Manager_value = map[string]int32{
	"MANAGER_UNSPECIFIED": 0,
	"ANY":                 1,
	"APT":                 2,
	"YUM":                 3,
	"ZYPPER":              4,
	"GOO":                 5,
}

func (x Package_Manager) String() string {
	return proto.EnumName(Package_Manager_name, int32(x))
}

func (Package_Manager) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{2, 0}
}

// Type of archive.
type AptRepository_ArchiveType int32

const (
	// Unspecified.
	AptRepository_ARCHIVE_TYPE_UNSPECIFIED AptRepository_ArchiveType = 0
	// DEB indicates that the archive contains binary files.
	AptRepository_DEB AptRepository_ArchiveType = 1
	// DEB_SRC indicates that the archive contains source files.
	AptRepository_DEB_SRC AptRepository_ArchiveType = 2
)

var AptRepository_ArchiveType_name = map[int32]string{
	0: "ARCHIVE_TYPE_UNSPECIFIED",
	1: "DEB",
	2: "DEB_SRC",
}

var AptRepository_ArchiveType_value = map[string]int32{
	"ARCHIVE_TYPE_UNSPECIFIED": 0,
	"DEB":                      1,
	"DEB_SRC":                  2,
}

func (x AptRepository_ArchiveType) String() string {
	return proto.EnumName(AptRepository_ArchiveType_name, int32(x))
}

func (AptRepository_ArchiveType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{3, 0}
}

// Specifying the type of archive.
type SoftwareRecipe_Step_ExtractArchive_ArchiveType int32

const (
	// Indicates that the archive type isn't specified.
	SoftwareRecipe_Step_ExtractArchive_ARCHIVE_TYPE_UNSPECIFIED SoftwareRecipe_Step_ExtractArchive_ArchiveType = 0
	// Indicates that the archive is a tar archive with no encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR SoftwareRecipe_Step_ExtractArchive_ArchiveType = 1
	// Indicates that the archive is a tar archive with gzip encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_GZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 2
	// Indicates that the archive is a tar archive with bzip encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_BZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 3
	// Indicates that the archive is a tar archive with lzma encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_LZMA SoftwareRecipe_Step_ExtractArchive_ArchiveType = 4
	// Indicates that the archive is a tar archive with xz encryption.
	SoftwareRecipe_Step_ExtractArchive_TAR_XZ SoftwareRecipe_Step_ExtractArchive_ArchiveType = 5
	// Indicates that the archive is a zip archive.
	SoftwareRecipe_Step_ExtractArchive_ZIP SoftwareRecipe_Step_ExtractArchive_ArchiveType = 11
)

var SoftwareRecipe_Step_ExtractArchive_ArchiveType_name = map[int32]string{
	0:  "ARCHIVE_TYPE_UNSPECIFIED",
	1:  "TAR",
	2:  "TAR_GZIP",
	3:  "TAR_BZIP",
	4:  "TAR_LZMA",
	5:  "TAR_XZ",
	11: "ZIP",
}

var SoftwareRecipe_Step_ExtractArchive_ArchiveType_value = map[string]int32{
	"ARCHIVE_TYPE_UNSPECIFIED": 0,
	"TAR":                      1,
	"TAR_GZIP":                 2,
	"TAR_BZIP":                 3,
	"TAR_LZMA":                 4,
	"TAR_XZ":                   5,
	"ZIP":                      11,
}

func (x SoftwareRecipe_Step_ExtractArchive_ArchiveType) String() string {
	return proto.EnumName(SoftwareRecipe_Step_ExtractArchive_ArchiveType_name, int32(x))
}

func (SoftwareRecipe_Step_ExtractArchive_ArchiveType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 1, 0}
}

// The interpreter used to execute a script.
type SoftwareRecipe_Step_RunScript_Interpreter int32

const (
	// Default value for ScriptType.
	SoftwareRecipe_Step_RunScript_INTERPRETER_UNSPECIFIED SoftwareRecipe_Step_RunScript_Interpreter = 0
	// Indicates that the script is run with `/bin/sh` on Linux and `cmd`
	// on windows.
	SoftwareRecipe_Step_RunScript_SHELL SoftwareRecipe_Step_RunScript_Interpreter = 1
	// Indicates that the script is run with powershell.
	SoftwareRecipe_Step_RunScript_POWERSHELL SoftwareRecipe_Step_RunScript_Interpreter = 3
)

var SoftwareRecipe_Step_RunScript_Interpreter_name = map[int32]string{
	0: "INTERPRETER_UNSPECIFIED",
	1: "SHELL",
	3: "POWERSHELL",
}

var SoftwareRecipe_Step_RunScript_Interpreter_value = map[string]int32{
	"INTERPRETER_UNSPECIFIED": 0,
	"SHELL":                   1,
	"POWERSHELL":              3,
}

func (x SoftwareRecipe_Step_RunScript_Interpreter) String() string {
	return proto.EnumName(SoftwareRecipe_Step_RunScript_Interpreter_name, int32(x))
}

func (SoftwareRecipe_Step_RunScript_Interpreter) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 6, 0}
}

// An OS Config resource representing a guest configuration policy. These
// policies represent the desired state for VM instance guest environments
// including packages to install or remove, package repository configurations,
// and software to install.
type GuestPolicy struct {
	// Required. Unique name of the resource in this project using one of the
	// following forms:
	// `projects/{project_number}/guestPolicies/{guest_policy_id}`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Description of the guest policy. Length of the description is limited
	// to 1024 characters.
	Description string `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Output only. Time this guest policy was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Last time this guest policy was updated.
	UpdateTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Specifies the VM instances that are assigned to this policy. This
	// allows you to target sets or groups of VM instances by different parameters
	// such as labels, names, OS, or zones.
	//
	// If left empty, all VM instances underneath this policy are targeted.
	//
	//
	// Conflict Management
	//
	// At the same level in the resource hierarchy (that is within a project), the
	// service prevents the creation of multiple policies that conflict with
	// each other. If there are multiple policies that specify the same config
	// (eg. package, software recipe, repository, etc.), the service ensures
	// that no VM instance could potentially receive instructions from both
	// policies. To create multiple policies that specify different versions of a
	// package or different configs for different operating systems, each policy
	// must be mutually exclusive in their targeting according to labels, OS, or
	// other criteria.
	//
	// Different configs are identified for conflicts in different ways. Packages
	// are identified by their name and the package manager(s) they target.
	// Package repositories are identified by their unique id where applicable.
	// Some package managers don't have a unique identifier for repositories and
	// where that's the case, no uniqueness is validated by the service.
	//
	// Note that if OS Inventory is disabled, a VM instance cannot assign a policy
	// that targets by OS because the service sees the OS as unknown.
	Assignment *Assignment `protobuf:"bytes,6,opt,name=assignment,proto3" json:"assignment,omitempty"`
	// The software packages to be managed by this policy.
	Packages []*Package `protobuf:"bytes,7,rep,name=packages,proto3" json:"packages,omitempty"`
	// A list of package repositories to configure on the VM instance. This is
	// done before any other configs are applied so they can use these repos.
	// Package repositories are only configured if the corresponding package
	// manager(s) are available.
	PackageRepositories []*PackageRepository `protobuf:"bytes,8,rep,name=package_repositories,json=packageRepositories,proto3" json:"package_repositories,omitempty"`
	// A list of Recipes to install on the VM instance.
	Recipes []*SoftwareRecipe `protobuf:"bytes,9,rep,name=recipes,proto3" json:"recipes,omitempty"`
	// The etag for this guest policy.
	// If this is provided on update, it must match the server's etag.
	Etag                 string   `protobuf:"bytes,10,opt,name=etag,proto3" json:"etag,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GuestPolicy) Reset()         { *m = GuestPolicy{} }
func (m *GuestPolicy) String() string { return proto.CompactTextString(m) }
func (*GuestPolicy) ProtoMessage()    {}
func (*GuestPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{0}
}

func (m *GuestPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GuestPolicy.Unmarshal(m, b)
}
func (m *GuestPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GuestPolicy.Marshal(b, m, deterministic)
}
func (m *GuestPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GuestPolicy.Merge(m, src)
}
func (m *GuestPolicy) XXX_Size() int {
	return xxx_messageInfo_GuestPolicy.Size(m)
}
func (m *GuestPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_GuestPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_GuestPolicy proto.InternalMessageInfo

func (m *GuestPolicy) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GuestPolicy) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *GuestPolicy) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *GuestPolicy) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

func (m *GuestPolicy) GetAssignment() *Assignment {
	if m != nil {
		return m.Assignment
	}
	return nil
}

func (m *GuestPolicy) GetPackages() []*Package {
	if m != nil {
		return m.Packages
	}
	return nil
}

func (m *GuestPolicy) GetPackageRepositories() []*PackageRepository {
	if m != nil {
		return m.PackageRepositories
	}
	return nil
}

func (m *GuestPolicy) GetRecipes() []*SoftwareRecipe {
	if m != nil {
		return m.Recipes
	}
	return nil
}

func (m *GuestPolicy) GetEtag() string {
	if m != nil {
		return m.Etag
	}
	return ""
}

// An assignment represents the group or groups of VM instances that the policy
// applies to.
//
// If an assignment is empty, it applies to all VM instances. Otherwise, the
// targeted VM instances must meet all the criteria specified. So if both
// labels and zones are specified, the policy applies to VM instances with those
// labels and in those zones.
type Assignment struct {
	// Targets instances matching at least one of these label sets. This allows
	// an assignment to target disparate groups, for example "env=prod or
	// env=staging".
	GroupLabels []*Assignment_GroupLabel `protobuf:"bytes,1,rep,name=group_labels,json=groupLabels,proto3" json:"group_labels,omitempty"`
	// Targets instances in any of these zones. Leave empty to target instances
	// in any zone.
	//
	// Zonal targeting is uncommon and is supported to facilitate the management
	// of changes by zone.
	Zones []string `protobuf:"bytes,2,rep,name=zones,proto3" json:"zones,omitempty"`
	// Targets any of the instances specified. Instances are specified by their
	// URI in the form `zones/[ZONE]/instances/[INSTANCE_NAME]`.
	//
	// Instance targeting is uncommon and is supported to facilitate the
	// management of changes by the instance or to target specific VM instances
	// for development and testing.
	//
	// Only supported for project-level policies and must reference instances
	// within this project.
	Instances []string `protobuf:"bytes,3,rep,name=instances,proto3" json:"instances,omitempty"`
	// Targets VM instances whose name starts with one of these prefixes.
	//
	// Like labels, this is another way to group VM instances when targeting
	// configs, for example prefix=”prod-”.
	//
	// Only supported for project-level policies.
	InstanceNamePrefixes []string `protobuf:"bytes,4,rep,name=instance_name_prefixes,json=instanceNamePrefixes,proto3" json:"instance_name_prefixes,omitempty"`
	// Targets VM instances matching at least one of the following OS types.
	//
	// VM instances must match all supplied criteria for a given OsType to be
	// included.
	OsTypes              []*Assignment_OsType `protobuf:"bytes,5,rep,name=os_types,json=osTypes,proto3" json:"os_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *Assignment) Reset()         { *m = Assignment{} }
func (m *Assignment) String() string { return proto.CompactTextString(m) }
func (*Assignment) ProtoMessage()    {}
func (*Assignment) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{1}
}

func (m *Assignment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Assignment.Unmarshal(m, b)
}
func (m *Assignment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Assignment.Marshal(b, m, deterministic)
}
func (m *Assignment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assignment.Merge(m, src)
}
func (m *Assignment) XXX_Size() int {
	return xxx_messageInfo_Assignment.Size(m)
}
func (m *Assignment) XXX_DiscardUnknown() {
	xxx_messageInfo_Assignment.DiscardUnknown(m)
}

var xxx_messageInfo_Assignment proto.InternalMessageInfo

func (m *Assignment) GetGroupLabels() []*Assignment_GroupLabel {
	if m != nil {
		return m.GroupLabels
	}
	return nil
}

func (m *Assignment) GetZones() []string {
	if m != nil {
		return m.Zones
	}
	return nil
}

func (m *Assignment) GetInstances() []string {
	if m != nil {
		return m.Instances
	}
	return nil
}

func (m *Assignment) GetInstanceNamePrefixes() []string {
	if m != nil {
		return m.InstanceNamePrefixes
	}
	return nil
}

func (m *Assignment) GetOsTypes() []*Assignment_OsType {
	if m != nil {
		return m.OsTypes
	}
	return nil
}

// Represents a group of VM intances that can be identified as having all
// these labels, for example "env=prod and app=web".
type Assignment_GroupLabel struct {
	// GCE instance labels that must be present for an instance to be included
	// in this assignment group.
	Labels               map[string]string `protobuf:"bytes,1,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *Assignment_GroupLabel) Reset()         { *m = Assignment_GroupLabel{} }
func (m *Assignment_GroupLabel) String() string { return proto.CompactTextString(m) }
func (*Assignment_GroupLabel) ProtoMessage()    {}
func (*Assignment_GroupLabel) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{1, 0}
}

func (m *Assignment_GroupLabel) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Assignment_GroupLabel.Unmarshal(m, b)
}
func (m *Assignment_GroupLabel) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Assignment_GroupLabel.Marshal(b, m, deterministic)
}
func (m *Assignment_GroupLabel) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assignment_GroupLabel.Merge(m, src)
}
func (m *Assignment_GroupLabel) XXX_Size() int {
	return xxx_messageInfo_Assignment_GroupLabel.Size(m)
}
func (m *Assignment_GroupLabel) XXX_DiscardUnknown() {
	xxx_messageInfo_Assignment_GroupLabel.DiscardUnknown(m)
}

var xxx_messageInfo_Assignment_GroupLabel proto.InternalMessageInfo

func (m *Assignment_GroupLabel) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

// Defines the criteria for selecting VM Instances by OS type.
type Assignment_OsType struct {
	// Targets VM instances with OS Inventory enabled and having the following
	// OS short name, for example "debian" or "windows".
	OsShortName string `protobuf:"bytes,1,opt,name=os_short_name,json=osShortName,proto3" json:"os_short_name,omitempty"`
	// Targets VM instances with OS Inventory enabled and having the following
	// following OS version.
	OsVersion string `protobuf:"bytes,2,opt,name=os_version,json=osVersion,proto3" json:"os_version,omitempty"`
	// Targets VM instances with OS Inventory enabled and having the following
	// OS architecture.
	OsArchitecture       string   `protobuf:"bytes,3,opt,name=os_architecture,json=osArchitecture,proto3" json:"os_architecture,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Assignment_OsType) Reset()         { *m = Assignment_OsType{} }
func (m *Assignment_OsType) String() string { return proto.CompactTextString(m) }
func (*Assignment_OsType) ProtoMessage()    {}
func (*Assignment_OsType) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{1, 1}
}

func (m *Assignment_OsType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Assignment_OsType.Unmarshal(m, b)
}
func (m *Assignment_OsType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Assignment_OsType.Marshal(b, m, deterministic)
}
func (m *Assignment_OsType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Assignment_OsType.Merge(m, src)
}
func (m *Assignment_OsType) XXX_Size() int {
	return xxx_messageInfo_Assignment_OsType.Size(m)
}
func (m *Assignment_OsType) XXX_DiscardUnknown() {
	xxx_messageInfo_Assignment_OsType.DiscardUnknown(m)
}

var xxx_messageInfo_Assignment_OsType proto.InternalMessageInfo

func (m *Assignment_OsType) GetOsShortName() string {
	if m != nil {
		return m.OsShortName
	}
	return ""
}

func (m *Assignment_OsType) GetOsVersion() string {
	if m != nil {
		return m.OsVersion
	}
	return ""
}

func (m *Assignment_OsType) GetOsArchitecture() string {
	if m != nil {
		return m.OsArchitecture
	}
	return ""
}

// Package is a reference to the software package to be installed or removed.
// The agent on the VM instance uses the system package manager to apply the
// config.
//
//
// These are the commands that the agent uses to install or remove
// packages.
//
// Apt
// install: `apt-get update && apt-get -y install package1 package2 package3`
// remove: `apt-get -y remove package1 package2 package3`
//
// Yum
// install: `yum -y install package1 package2 package3`
// remove: `yum -y remove package1 package2 package3`
//
// Zypper
// install: `zypper install package1 package2 package3`
// remove: `zypper rm package1 package2`
//
// Googet
// install: `googet -noconfirm install package1 package2 package3`
// remove: `googet -noconfirm remove package1 package2 package3`
type Package struct {
	// Required. The name of the package. A package is uniquely identified for
	// conflict validation by checking the package name and the manager(s) that
	// the package targets.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The desired_state the agent should maintain for this package. The
	// default is to ensure the package is installed.
	DesiredState DesiredState `protobuf:"varint,2,opt,name=desired_state,json=desiredState,proto3,enum=google.cloud.osconfig.v1beta.DesiredState" json:"desired_state,omitempty"`
	// Type of package manager that can be used to install this package.
	// If a system does not have the package manager, the package is not
	// installed or removed no error message is returned. By default,
	// or if you specify `ANY`,
	// the agent attempts to install and remove this package using the default
	// package manager. This is useful when creating a policy that applies to
	// different types of systems.
	//
	// The default behavior is ANY.
	Manager              Package_Manager `protobuf:"varint,3,opt,name=manager,proto3,enum=google.cloud.osconfig.v1beta.Package_Manager" json:"manager,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Package) Reset()         { *m = Package{} }
func (m *Package) String() string { return proto.CompactTextString(m) }
func (*Package) ProtoMessage()    {}
func (*Package) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{2}
}

func (m *Package) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Package.Unmarshal(m, b)
}
func (m *Package) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Package.Marshal(b, m, deterministic)
}
func (m *Package) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Package.Merge(m, src)
}
func (m *Package) XXX_Size() int {
	return xxx_messageInfo_Package.Size(m)
}
func (m *Package) XXX_DiscardUnknown() {
	xxx_messageInfo_Package.DiscardUnknown(m)
}

var xxx_messageInfo_Package proto.InternalMessageInfo

func (m *Package) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Package) GetDesiredState() DesiredState {
	if m != nil {
		return m.DesiredState
	}
	return DesiredState_DESIRED_STATE_UNSPECIFIED
}

func (m *Package) GetManager() Package_Manager {
	if m != nil {
		return m.Manager
	}
	return Package_MANAGER_UNSPECIFIED
}

// Represents a single Apt package repository. This repository is added to
// a repo file that is stored at
// `/etc/apt/sources.list.d/google_osconfig.list`.
type AptRepository struct {
	// Type of archive files in this repository. The default behavior is DEB.
	ArchiveType AptRepository_ArchiveType `protobuf:"varint,1,opt,name=archive_type,json=archiveType,proto3,enum=google.cloud.osconfig.v1beta.AptRepository_ArchiveType" json:"archive_type,omitempty"`
	// Required. URI for this repository.
	Uri string `protobuf:"bytes,2,opt,name=uri,proto3" json:"uri,omitempty"`
	// Required. Distribution of this repository.
	Distribution string `protobuf:"bytes,3,opt,name=distribution,proto3" json:"distribution,omitempty"`
	// Required. List of components for this repository. Must contain at least one
	// item.
	Components []string `protobuf:"bytes,4,rep,name=components,proto3" json:"components,omitempty"`
	// URI of the key file for this repository. The agent maintains
	// a keyring at `/etc/apt/trusted.gpg.d/osconfig_agent_managed.gpg` containing
	// all the keys in any applied guest policy.
	GpgKey               string   `protobuf:"bytes,5,opt,name=gpg_key,json=gpgKey,proto3" json:"gpg_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *AptRepository) Reset()         { *m = AptRepository{} }
func (m *AptRepository) String() string { return proto.CompactTextString(m) }
func (*AptRepository) ProtoMessage()    {}
func (*AptRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{3}
}

func (m *AptRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AptRepository.Unmarshal(m, b)
}
func (m *AptRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AptRepository.Marshal(b, m, deterministic)
}
func (m *AptRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AptRepository.Merge(m, src)
}
func (m *AptRepository) XXX_Size() int {
	return xxx_messageInfo_AptRepository.Size(m)
}
func (m *AptRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_AptRepository.DiscardUnknown(m)
}

var xxx_messageInfo_AptRepository proto.InternalMessageInfo

func (m *AptRepository) GetArchiveType() AptRepository_ArchiveType {
	if m != nil {
		return m.ArchiveType
	}
	return AptRepository_ARCHIVE_TYPE_UNSPECIFIED
}

func (m *AptRepository) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *AptRepository) GetDistribution() string {
	if m != nil {
		return m.Distribution
	}
	return ""
}

func (m *AptRepository) GetComponents() []string {
	if m != nil {
		return m.Components
	}
	return nil
}

func (m *AptRepository) GetGpgKey() string {
	if m != nil {
		return m.GpgKey
	}
	return ""
}

// Represents a single Yum package repository. This repository is added to a
// repo file that is stored at `/etc/yum.repos.d/google_osconfig.repo`.
type YumRepository struct {
	// Required. A one word, unique name for this repository. This is
	// the `repo id` in the Yum config file and also the `display_name` if
	// `display_name` is omitted. This id is also used as the unique identifier
	// when checking for guest policy conflicts.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the repository.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The location of the repository directory.
	BaseUrl string `protobuf:"bytes,3,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// URIs of GPG keys.
	GpgKeys              []string `protobuf:"bytes,4,rep,name=gpg_keys,json=gpgKeys,proto3" json:"gpg_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *YumRepository) Reset()         { *m = YumRepository{} }
func (m *YumRepository) String() string { return proto.CompactTextString(m) }
func (*YumRepository) ProtoMessage()    {}
func (*YumRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{4}
}

func (m *YumRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_YumRepository.Unmarshal(m, b)
}
func (m *YumRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_YumRepository.Marshal(b, m, deterministic)
}
func (m *YumRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_YumRepository.Merge(m, src)
}
func (m *YumRepository) XXX_Size() int {
	return xxx_messageInfo_YumRepository.Size(m)
}
func (m *YumRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_YumRepository.DiscardUnknown(m)
}

var xxx_messageInfo_YumRepository proto.InternalMessageInfo

func (m *YumRepository) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *YumRepository) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *YumRepository) GetBaseUrl() string {
	if m != nil {
		return m.BaseUrl
	}
	return ""
}

func (m *YumRepository) GetGpgKeys() []string {
	if m != nil {
		return m.GpgKeys
	}
	return nil
}

// Represents a single Zypper package repository. This repository is added to a
// repo file that is stored at `/etc/zypp/repos.d/google_osconfig.repo`.
type ZypperRepository struct {
	// Required. A one word, unique name for this repository. This is
	// the `repo id` in the zypper config file and also the `display_name` if
	// `display_name` is omitted. This id is also used as the unique identifier
	// when checking for guest policy conflicts.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The display name of the repository.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Required. The location of the repository directory.
	BaseUrl string `protobuf:"bytes,3,opt,name=base_url,json=baseUrl,proto3" json:"base_url,omitempty"`
	// URIs of GPG keys.
	GpgKeys              []string `protobuf:"bytes,4,rep,name=gpg_keys,json=gpgKeys,proto3" json:"gpg_keys,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ZypperRepository) Reset()         { *m = ZypperRepository{} }
func (m *ZypperRepository) String() string { return proto.CompactTextString(m) }
func (*ZypperRepository) ProtoMessage()    {}
func (*ZypperRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{5}
}

func (m *ZypperRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ZypperRepository.Unmarshal(m, b)
}
func (m *ZypperRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ZypperRepository.Marshal(b, m, deterministic)
}
func (m *ZypperRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ZypperRepository.Merge(m, src)
}
func (m *ZypperRepository) XXX_Size() int {
	return xxx_messageInfo_ZypperRepository.Size(m)
}
func (m *ZypperRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_ZypperRepository.DiscardUnknown(m)
}

var xxx_messageInfo_ZypperRepository proto.InternalMessageInfo

func (m *ZypperRepository) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *ZypperRepository) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *ZypperRepository) GetBaseUrl() string {
	if m != nil {
		return m.BaseUrl
	}
	return ""
}

func (m *ZypperRepository) GetGpgKeys() []string {
	if m != nil {
		return m.GpgKeys
	}
	return nil
}

// Represents a Goo package repository. These is added to a repo file
// that is stored at C:/ProgramData/GooGet/repos/google_osconfig.repo.
type GooRepository struct {
	// Required. The name of the repository.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The url of the repository.
	Url                  string   `protobuf:"bytes,2,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GooRepository) Reset()         { *m = GooRepository{} }
func (m *GooRepository) String() string { return proto.CompactTextString(m) }
func (*GooRepository) ProtoMessage()    {}
func (*GooRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{6}
}

func (m *GooRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GooRepository.Unmarshal(m, b)
}
func (m *GooRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GooRepository.Marshal(b, m, deterministic)
}
func (m *GooRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GooRepository.Merge(m, src)
}
func (m *GooRepository) XXX_Size() int {
	return xxx_messageInfo_GooRepository.Size(m)
}
func (m *GooRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_GooRepository.DiscardUnknown(m)
}

var xxx_messageInfo_GooRepository proto.InternalMessageInfo

func (m *GooRepository) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *GooRepository) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// A package repository.
type PackageRepository struct {
	// A specific type of repository.
	//
	// Types that are valid to be assigned to Repository:
	//	*PackageRepository_Apt
	//	*PackageRepository_Yum
	//	*PackageRepository_Zypper
	//	*PackageRepository_Goo
	Repository           isPackageRepository_Repository `protobuf_oneof:"repository"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *PackageRepository) Reset()         { *m = PackageRepository{} }
func (m *PackageRepository) String() string { return proto.CompactTextString(m) }
func (*PackageRepository) ProtoMessage()    {}
func (*PackageRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{7}
}

func (m *PackageRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PackageRepository.Unmarshal(m, b)
}
func (m *PackageRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PackageRepository.Marshal(b, m, deterministic)
}
func (m *PackageRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PackageRepository.Merge(m, src)
}
func (m *PackageRepository) XXX_Size() int {
	return xxx_messageInfo_PackageRepository.Size(m)
}
func (m *PackageRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_PackageRepository.DiscardUnknown(m)
}

var xxx_messageInfo_PackageRepository proto.InternalMessageInfo

type isPackageRepository_Repository interface {
	isPackageRepository_Repository()
}

type PackageRepository_Apt struct {
	Apt *AptRepository `protobuf:"bytes,1,opt,name=apt,proto3,oneof"`
}

type PackageRepository_Yum struct {
	Yum *YumRepository `protobuf:"bytes,2,opt,name=yum,proto3,oneof"`
}

type PackageRepository_Zypper struct {
	Zypper *ZypperRepository `protobuf:"bytes,3,opt,name=zypper,proto3,oneof"`
}

type PackageRepository_Goo struct {
	Goo *GooRepository `protobuf:"bytes,4,opt,name=goo,proto3,oneof"`
}

func (*PackageRepository_Apt) isPackageRepository_Repository() {}

func (*PackageRepository_Yum) isPackageRepository_Repository() {}

func (*PackageRepository_Zypper) isPackageRepository_Repository() {}

func (*PackageRepository_Goo) isPackageRepository_Repository() {}

func (m *PackageRepository) GetRepository() isPackageRepository_Repository {
	if m != nil {
		return m.Repository
	}
	return nil
}

func (m *PackageRepository) GetApt() *AptRepository {
	if x, ok := m.GetRepository().(*PackageRepository_Apt); ok {
		return x.Apt
	}
	return nil
}

func (m *PackageRepository) GetYum() *YumRepository {
	if x, ok := m.GetRepository().(*PackageRepository_Yum); ok {
		return x.Yum
	}
	return nil
}

func (m *PackageRepository) GetZypper() *ZypperRepository {
	if x, ok := m.GetRepository().(*PackageRepository_Zypper); ok {
		return x.Zypper
	}
	return nil
}

func (m *PackageRepository) GetGoo() *GooRepository {
	if x, ok := m.GetRepository().(*PackageRepository_Goo); ok {
		return x.Goo
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*PackageRepository) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*PackageRepository_Apt)(nil),
		(*PackageRepository_Yum)(nil),
		(*PackageRepository_Zypper)(nil),
		(*PackageRepository_Goo)(nil),
	}
}

// A software recipe is a set of instructions for installing and configuring a
// piece of software. It consists of a set of artifacts that are
// downloaded, and a set of steps that install, configure, and/or update the
// software.
//
// Recipes support installing and updating software from artifacts in the
// following formats:
// Zip archive, Tar archive, Windows MSI, Debian package, and RPM package.
//
// Additionally, recipes support executing a script (either defined in a file or
// directly in this api) in bash, sh, cmd, and powershell.
//
// Updating a software recipe
//
// If a recipe is assigned to an instance and there is a recipe with the same
// name but a lower version already installed and the assigned state
// of the recipe is `INSTALLED_KEEP_UPDATED`, then the recipe is updated to
// the new version.
//
// Script Working Directories
//
// Each script or execution step is run in its own temporary directory which
// is deleted after completing the step.
type SoftwareRecipe struct {
	// Required. Unique identifier for the recipe. Only one recipe with a given
	// name is installed on an instance.
	//
	// Names are also used to identify resources which helps to determine whether
	// guest policies have conflicts. This means that requests to create multiple
	// recipes with the same name and version are rejected since they
	// could potentially have conflicting assignments.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The version of this software recipe. Version can be up to 4 period
	// separated numbers (e.g. 12.34.56.78).
	Version string `protobuf:"bytes,2,opt,name=version,proto3" json:"version,omitempty"`
	// Resources available to be used in the steps in the recipe.
	Artifacts []*SoftwareRecipe_Artifact `protobuf:"bytes,3,rep,name=artifacts,proto3" json:"artifacts,omitempty"`
	// Actions to be taken for installing this recipe. On failure it stops
	// executing steps and does not attempt another installation. Any steps taken
	// (including partially completed steps) are not rolled back.
	InstallSteps []*SoftwareRecipe_Step `protobuf:"bytes,4,rep,name=install_steps,json=installSteps,proto3" json:"install_steps,omitempty"`
	// Actions to be taken for updating this recipe. On failure it stops
	// executing steps and  does not attempt another update for this recipe. Any
	// steps taken (including partially completed steps) are not rolled back.
	UpdateSteps []*SoftwareRecipe_Step `protobuf:"bytes,5,rep,name=update_steps,json=updateSteps,proto3" json:"update_steps,omitempty"`
	// Default is INSTALLED. The desired state the agent should maintain for this
	// recipe.
	//
	// INSTALLED: The software recipe is installed on the instance but
	//            won't be updated to new versions.
	// INSTALLED_KEEP_UPDATED: The software recipe is installed on the
	//                         instance. The recipe is updated to a higher
	//                         version, if a higher version of the recipe is
	//                         assigned to this instance.
	// REMOVE: Remove is unsupported for software recipes and attempts to
	//         create or update a recipe to the REMOVE state is rejected.
	DesiredState         DesiredState `protobuf:"varint,6,opt,name=desired_state,json=desiredState,proto3,enum=google.cloud.osconfig.v1beta.DesiredState" json:"desired_state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *SoftwareRecipe) Reset()         { *m = SoftwareRecipe{} }
func (m *SoftwareRecipe) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe) ProtoMessage()    {}
func (*SoftwareRecipe) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8}
}

func (m *SoftwareRecipe) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe.Unmarshal(m, b)
}
func (m *SoftwareRecipe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe.Merge(m, src)
}
func (m *SoftwareRecipe) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe.Size(m)
}
func (m *SoftwareRecipe) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe proto.InternalMessageInfo

func (m *SoftwareRecipe) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SoftwareRecipe) GetVersion() string {
	if m != nil {
		return m.Version
	}
	return ""
}

func (m *SoftwareRecipe) GetArtifacts() []*SoftwareRecipe_Artifact {
	if m != nil {
		return m.Artifacts
	}
	return nil
}

func (m *SoftwareRecipe) GetInstallSteps() []*SoftwareRecipe_Step {
	if m != nil {
		return m.InstallSteps
	}
	return nil
}

func (m *SoftwareRecipe) GetUpdateSteps() []*SoftwareRecipe_Step {
	if m != nil {
		return m.UpdateSteps
	}
	return nil
}

func (m *SoftwareRecipe) GetDesiredState() DesiredState {
	if m != nil {
		return m.DesiredState
	}
	return DesiredState_DESIRED_STATE_UNSPECIFIED
}

// Specifies a resource to be used in the recipe.
type SoftwareRecipe_Artifact struct {
	// Required. Id of the artifact, which the installation and update steps of
	// this recipe can reference. Artifacts in a recipe cannot have the same id.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// A specific type of artifact.
	//
	// Types that are valid to be assigned to Artifact:
	//	*SoftwareRecipe_Artifact_Remote_
	//	*SoftwareRecipe_Artifact_Gcs_
	Artifact isSoftwareRecipe_Artifact_Artifact `protobuf_oneof:"artifact"`
	// Defaults to false. When false, recipes are subject to validations
	// based on the artifact type:
	//
	// Remote: A checksum must be specified, and only protocols with
	//         transport-layer security are permitted.
	// GCS:    An object generation number must be specified.
	AllowInsecure        bool     `protobuf:"varint,4,opt,name=allow_insecure,json=allowInsecure,proto3" json:"allow_insecure,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Artifact) Reset()         { *m = SoftwareRecipe_Artifact{} }
func (m *SoftwareRecipe_Artifact) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Artifact) ProtoMessage()    {}
func (*SoftwareRecipe_Artifact) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 0}
}

func (m *SoftwareRecipe_Artifact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Artifact.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Artifact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Artifact.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Artifact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Artifact.Merge(m, src)
}
func (m *SoftwareRecipe_Artifact) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Artifact.Size(m)
}
func (m *SoftwareRecipe_Artifact) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Artifact.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Artifact proto.InternalMessageInfo

func (m *SoftwareRecipe_Artifact) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type isSoftwareRecipe_Artifact_Artifact interface {
	isSoftwareRecipe_Artifact_Artifact()
}

type SoftwareRecipe_Artifact_Remote_ struct {
	Remote *SoftwareRecipe_Artifact_Remote `protobuf:"bytes,2,opt,name=remote,proto3,oneof"`
}

type SoftwareRecipe_Artifact_Gcs_ struct {
	Gcs *SoftwareRecipe_Artifact_Gcs `protobuf:"bytes,3,opt,name=gcs,proto3,oneof"`
}

func (*SoftwareRecipe_Artifact_Remote_) isSoftwareRecipe_Artifact_Artifact() {}

func (*SoftwareRecipe_Artifact_Gcs_) isSoftwareRecipe_Artifact_Artifact() {}

func (m *SoftwareRecipe_Artifact) GetArtifact() isSoftwareRecipe_Artifact_Artifact {
	if m != nil {
		return m.Artifact
	}
	return nil
}

func (m *SoftwareRecipe_Artifact) GetRemote() *SoftwareRecipe_Artifact_Remote {
	if x, ok := m.GetArtifact().(*SoftwareRecipe_Artifact_Remote_); ok {
		return x.Remote
	}
	return nil
}

func (m *SoftwareRecipe_Artifact) GetGcs() *SoftwareRecipe_Artifact_Gcs {
	if x, ok := m.GetArtifact().(*SoftwareRecipe_Artifact_Gcs_); ok {
		return x.Gcs
	}
	return nil
}

func (m *SoftwareRecipe_Artifact) GetAllowInsecure() bool {
	if m != nil {
		return m.AllowInsecure
	}
	return false
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SoftwareRecipe_Artifact) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SoftwareRecipe_Artifact_Remote_)(nil),
		(*SoftwareRecipe_Artifact_Gcs_)(nil),
	}
}

// Specifies an artifact available via some URI.
type SoftwareRecipe_Artifact_Remote struct {
	// URI from which to fetch the object. It should contain both the protocol
	// and path following the format {protocol}://{location}.
	Uri string `protobuf:"bytes,1,opt,name=uri,proto3" json:"uri,omitempty"`
	// Must be provided if `allow_insecure` is `false`.
	// SHA256 checksum in hex format, to compare to the checksum of the
	// artifact. If the checksum is not empty and it doesn't match the
	// artifact then the recipe installation fails before running any of the
	// steps.
	Checksum             string   `protobuf:"bytes,2,opt,name=checksum,proto3" json:"checksum,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Artifact_Remote) Reset()         { *m = SoftwareRecipe_Artifact_Remote{} }
func (m *SoftwareRecipe_Artifact_Remote) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Artifact_Remote) ProtoMessage()    {}
func (*SoftwareRecipe_Artifact_Remote) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 0, 0}
}

func (m *SoftwareRecipe_Artifact_Remote) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Remote.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Artifact_Remote) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Remote.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Artifact_Remote) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Artifact_Remote.Merge(m, src)
}
func (m *SoftwareRecipe_Artifact_Remote) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Remote.Size(m)
}
func (m *SoftwareRecipe_Artifact_Remote) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Artifact_Remote.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Artifact_Remote proto.InternalMessageInfo

func (m *SoftwareRecipe_Artifact_Remote) GetUri() string {
	if m != nil {
		return m.Uri
	}
	return ""
}

func (m *SoftwareRecipe_Artifact_Remote) GetChecksum() string {
	if m != nil {
		return m.Checksum
	}
	return ""
}

// Specifies an artifact available as a Cloud Storage object.
type SoftwareRecipe_Artifact_Gcs struct {
	// Bucket of the Cloud Storage object.
	// Given an example URL:
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `my-bucket`.
	Bucket string `protobuf:"bytes,1,opt,name=bucket,proto3" json:"bucket,omitempty"`
	// Name of the Cloud Storage object.
	// As specified [here]
	// (https://cloud.google.com/storage/docs/naming#objectnames)
	// Given an example URL:
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `foo/bar`.
	Object string `protobuf:"bytes,2,opt,name=object,proto3" json:"object,omitempty"`
	// Must be provided if allow_insecure is false.
	// Generation number of the Cloud Storage object.
	// `https://storage.googleapis.com/my-bucket/foo/bar#1234567`
	// this value would be `1234567`.
	Generation           int64    `protobuf:"varint,3,opt,name=generation,proto3" json:"generation,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Artifact_Gcs) Reset()         { *m = SoftwareRecipe_Artifact_Gcs{} }
func (m *SoftwareRecipe_Artifact_Gcs) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Artifact_Gcs) ProtoMessage()    {}
func (*SoftwareRecipe_Artifact_Gcs) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 0, 1}
}

func (m *SoftwareRecipe_Artifact_Gcs) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Artifact_Gcs) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Artifact_Gcs) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.Merge(m, src)
}
func (m *SoftwareRecipe_Artifact_Gcs) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.Size(m)
}
func (m *SoftwareRecipe_Artifact_Gcs) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Artifact_Gcs.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Artifact_Gcs proto.InternalMessageInfo

func (m *SoftwareRecipe_Artifact_Gcs) GetBucket() string {
	if m != nil {
		return m.Bucket
	}
	return ""
}

func (m *SoftwareRecipe_Artifact_Gcs) GetObject() string {
	if m != nil {
		return m.Object
	}
	return ""
}

func (m *SoftwareRecipe_Artifact_Gcs) GetGeneration() int64 {
	if m != nil {
		return m.Generation
	}
	return 0
}

// An action that can be taken as part of installing or updating a recipe.
type SoftwareRecipe_Step struct {
	// A specific type of step.
	//
	// Types that are valid to be assigned to Step:
	//	*SoftwareRecipe_Step_FileCopy
	//	*SoftwareRecipe_Step_ArchiveExtraction
	//	*SoftwareRecipe_Step_MsiInstallation
	//	*SoftwareRecipe_Step_DpkgInstallation
	//	*SoftwareRecipe_Step_RpmInstallation
	//	*SoftwareRecipe_Step_FileExec
	//	*SoftwareRecipe_Step_ScriptRun
	Step                 isSoftwareRecipe_Step_Step `protobuf_oneof:"step"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *SoftwareRecipe_Step) Reset()         { *m = SoftwareRecipe_Step{} }
func (m *SoftwareRecipe_Step) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step) ProtoMessage()    {}
func (*SoftwareRecipe_Step) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1}
}

func (m *SoftwareRecipe_Step) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step.Merge(m, src)
}
func (m *SoftwareRecipe_Step) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step.Size(m)
}
func (m *SoftwareRecipe_Step) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step proto.InternalMessageInfo

type isSoftwareRecipe_Step_Step interface {
	isSoftwareRecipe_Step_Step()
}

type SoftwareRecipe_Step_FileCopy struct {
	FileCopy *SoftwareRecipe_Step_CopyFile `protobuf:"bytes,1,opt,name=file_copy,json=fileCopy,proto3,oneof"`
}

type SoftwareRecipe_Step_ArchiveExtraction struct {
	ArchiveExtraction *SoftwareRecipe_Step_ExtractArchive `protobuf:"bytes,2,opt,name=archive_extraction,json=archiveExtraction,proto3,oneof"`
}

type SoftwareRecipe_Step_MsiInstallation struct {
	MsiInstallation *SoftwareRecipe_Step_InstallMsi `protobuf:"bytes,3,opt,name=msi_installation,json=msiInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_DpkgInstallation struct {
	DpkgInstallation *SoftwareRecipe_Step_InstallDpkg `protobuf:"bytes,4,opt,name=dpkg_installation,json=dpkgInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_RpmInstallation struct {
	RpmInstallation *SoftwareRecipe_Step_InstallRpm `protobuf:"bytes,5,opt,name=rpm_installation,json=rpmInstallation,proto3,oneof"`
}

type SoftwareRecipe_Step_FileExec struct {
	FileExec *SoftwareRecipe_Step_ExecFile `protobuf:"bytes,6,opt,name=file_exec,json=fileExec,proto3,oneof"`
}

type SoftwareRecipe_Step_ScriptRun struct {
	ScriptRun *SoftwareRecipe_Step_RunScript `protobuf:"bytes,7,opt,name=script_run,json=scriptRun,proto3,oneof"`
}

func (*SoftwareRecipe_Step_FileCopy) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_ArchiveExtraction) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_MsiInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_DpkgInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_RpmInstallation) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_FileExec) isSoftwareRecipe_Step_Step() {}

func (*SoftwareRecipe_Step_ScriptRun) isSoftwareRecipe_Step_Step() {}

func (m *SoftwareRecipe_Step) GetStep() isSoftwareRecipe_Step_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetFileCopy() *SoftwareRecipe_Step_CopyFile {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_FileCopy); ok {
		return x.FileCopy
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetArchiveExtraction() *SoftwareRecipe_Step_ExtractArchive {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_ArchiveExtraction); ok {
		return x.ArchiveExtraction
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetMsiInstallation() *SoftwareRecipe_Step_InstallMsi {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_MsiInstallation); ok {
		return x.MsiInstallation
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetDpkgInstallation() *SoftwareRecipe_Step_InstallDpkg {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_DpkgInstallation); ok {
		return x.DpkgInstallation
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetRpmInstallation() *SoftwareRecipe_Step_InstallRpm {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_RpmInstallation); ok {
		return x.RpmInstallation
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetFileExec() *SoftwareRecipe_Step_ExecFile {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_FileExec); ok {
		return x.FileExec
	}
	return nil
}

func (m *SoftwareRecipe_Step) GetScriptRun() *SoftwareRecipe_Step_RunScript {
	if x, ok := m.GetStep().(*SoftwareRecipe_Step_ScriptRun); ok {
		return x.ScriptRun
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SoftwareRecipe_Step) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SoftwareRecipe_Step_FileCopy)(nil),
		(*SoftwareRecipe_Step_ArchiveExtraction)(nil),
		(*SoftwareRecipe_Step_MsiInstallation)(nil),
		(*SoftwareRecipe_Step_DpkgInstallation)(nil),
		(*SoftwareRecipe_Step_RpmInstallation)(nil),
		(*SoftwareRecipe_Step_FileExec)(nil),
		(*SoftwareRecipe_Step_ScriptRun)(nil),
	}
}

// Copies the artifact to the specified path on the instance.
type SoftwareRecipe_Step_CopyFile struct {
	// Required. The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// Required. The absolute path on the instance to put the file.
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Whether to allow this step to overwrite existing files. If this is
	// false and the file already exists the file is not overwritten
	// and the step is considered a success. Defaults to false.
	Overwrite bool `protobuf:"varint,3,opt,name=overwrite,proto3" json:"overwrite,omitempty"`
	// Consists of three octal digits which represent, in
	// order, the permissions of the owner, group, and other users for the
	// file (similarly to the numeric mode used in the linux chmod utility).
	// Each digit represents a three bit number with the 4 bit
	// corresponding to the read permissions, the 2 bit corresponds to the
	// write bit, and the one bit corresponds to the execute permission.
	// Default behavior is 755.
	//
	// Below are some examples of permissions and their associated values:
	// read, write, and execute: 7
	// read and execute: 5
	// read and write: 6
	// read only: 4
	Permissions          string   `protobuf:"bytes,4,opt,name=permissions,proto3" json:"permissions,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_CopyFile) Reset()         { *m = SoftwareRecipe_Step_CopyFile{} }
func (m *SoftwareRecipe_Step_CopyFile) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_CopyFile) ProtoMessage()    {}
func (*SoftwareRecipe_Step_CopyFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 0}
}

func (m *SoftwareRecipe_Step_CopyFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_CopyFile.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_CopyFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_CopyFile.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_CopyFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_CopyFile.Merge(m, src)
}
func (m *SoftwareRecipe_Step_CopyFile) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_CopyFile.Size(m)
}
func (m *SoftwareRecipe_Step_CopyFile) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_CopyFile.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_CopyFile proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_CopyFile) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

func (m *SoftwareRecipe_Step_CopyFile) GetDestination() string {
	if m != nil {
		return m.Destination
	}
	return ""
}

func (m *SoftwareRecipe_Step_CopyFile) GetOverwrite() bool {
	if m != nil {
		return m.Overwrite
	}
	return false
}

func (m *SoftwareRecipe_Step_CopyFile) GetPermissions() string {
	if m != nil {
		return m.Permissions
	}
	return ""
}

// Extracts an archive of the type specified in the specified directory.
type SoftwareRecipe_Step_ExtractArchive struct {
	// Required. The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// Directory to extract archive to.
	// Defaults to `/` on Linux or `C:\` on Windows.
	Destination string `protobuf:"bytes,2,opt,name=destination,proto3" json:"destination,omitempty"`
	// Required. The type of the archive to extract.
	Type                 SoftwareRecipe_Step_ExtractArchive_ArchiveType `protobuf:"varint,3,opt,name=type,proto3,enum=google.cloud.osconfig.v1beta.SoftwareRecipe_Step_ExtractArchive_ArchiveType" json:"type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                       `json:"-"`
	XXX_unrecognized     []byte                                         `json:"-"`
	XXX_sizecache        int32                                          `json:"-"`
}

func (m *SoftwareRecipe_Step_ExtractArchive) Reset()         { *m = SoftwareRecipe_Step_ExtractArchive{} }
func (m *SoftwareRecipe_Step_ExtractArchive) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_ExtractArchive) ProtoMessage()    {}
func (*SoftwareRecipe_Step_ExtractArchive) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 1}
}

func (m *SoftwareRecipe_Step_ExtractArchive) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_ExtractArchive) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_ExtractArchive) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.Merge(m, src)
}
func (m *SoftwareRecipe_Step_ExtractArchive) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.Size(m)
}
func (m *SoftwareRecipe_Step_ExtractArchive) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_ExtractArchive proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_ExtractArchive) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

func (m *SoftwareRecipe_Step_ExtractArchive) GetDestination() string {
	if m != nil {
		return m.Destination
	}
	return ""
}

func (m *SoftwareRecipe_Step_ExtractArchive) GetType() SoftwareRecipe_Step_ExtractArchive_ArchiveType {
	if m != nil {
		return m.Type
	}
	return SoftwareRecipe_Step_ExtractArchive_ARCHIVE_TYPE_UNSPECIFIED
}

// Installs an MSI file.
type SoftwareRecipe_Step_InstallMsi struct {
	// Required. The id of the relevant artifact in the recipe.
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	// The flags to use when installing the MSI
	// defaults to ["/i"] (i.e. the install flag).
	Flags []string `protobuf:"bytes,2,rep,name=flags,proto3" json:"flags,omitempty"`
	// Return codes that indicate that the software installed or updated
	// successfully. Behaviour defaults to [0]
	AllowedExitCodes     []int32  `protobuf:"varint,3,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_InstallMsi) Reset()         { *m = SoftwareRecipe_Step_InstallMsi{} }
func (m *SoftwareRecipe_Step_InstallMsi) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_InstallMsi) ProtoMessage()    {}
func (*SoftwareRecipe_Step_InstallMsi) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 2}
}

func (m *SoftwareRecipe_Step_InstallMsi) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_InstallMsi) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_InstallMsi) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.Merge(m, src)
}
func (m *SoftwareRecipe_Step_InstallMsi) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.Size(m)
}
func (m *SoftwareRecipe_Step_InstallMsi) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_InstallMsi.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_InstallMsi proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_InstallMsi) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

func (m *SoftwareRecipe_Step_InstallMsi) GetFlags() []string {
	if m != nil {
		return m.Flags
	}
	return nil
}

func (m *SoftwareRecipe_Step_InstallMsi) GetAllowedExitCodes() []int32 {
	if m != nil {
		return m.AllowedExitCodes
	}
	return nil
}

// Installs a deb via dpkg.
type SoftwareRecipe_Step_InstallDpkg struct {
	// Required. The id of the relevant artifact in the recipe.
	ArtifactId           string   `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_InstallDpkg) Reset()         { *m = SoftwareRecipe_Step_InstallDpkg{} }
func (m *SoftwareRecipe_Step_InstallDpkg) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_InstallDpkg) ProtoMessage()    {}
func (*SoftwareRecipe_Step_InstallDpkg) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 3}
}

func (m *SoftwareRecipe_Step_InstallDpkg) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_InstallDpkg) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_InstallDpkg) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.Merge(m, src)
}
func (m *SoftwareRecipe_Step_InstallDpkg) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.Size(m)
}
func (m *SoftwareRecipe_Step_InstallDpkg) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_InstallDpkg proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_InstallDpkg) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

// Installs an rpm file via the rpm utility.
type SoftwareRecipe_Step_InstallRpm struct {
	// Required. The id of the relevant artifact in the recipe.
	ArtifactId           string   `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3" json:"artifact_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_InstallRpm) Reset()         { *m = SoftwareRecipe_Step_InstallRpm{} }
func (m *SoftwareRecipe_Step_InstallRpm) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_InstallRpm) ProtoMessage()    {}
func (*SoftwareRecipe_Step_InstallRpm) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 4}
}

func (m *SoftwareRecipe_Step_InstallRpm) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_InstallRpm) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_InstallRpm) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.Merge(m, src)
}
func (m *SoftwareRecipe_Step_InstallRpm) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.Size(m)
}
func (m *SoftwareRecipe_Step_InstallRpm) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_InstallRpm.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_InstallRpm proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_InstallRpm) GetArtifactId() string {
	if m != nil {
		return m.ArtifactId
	}
	return ""
}

// Executes an artifact or local file.
type SoftwareRecipe_Step_ExecFile struct {
	// Location of the file to execute.
	//
	// Types that are valid to be assigned to LocationType:
	//	*SoftwareRecipe_Step_ExecFile_ArtifactId
	//	*SoftwareRecipe_Step_ExecFile_LocalPath
	LocationType isSoftwareRecipe_Step_ExecFile_LocationType `protobuf_oneof:"location_type"`
	// Arguments to be passed to the provided executable.
	Args []string `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	// Defaults to [0]. A list of possible return values that the program
	// can return to indicate a success.
	AllowedExitCodes     []int32  `protobuf:"varint,4,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SoftwareRecipe_Step_ExecFile) Reset()         { *m = SoftwareRecipe_Step_ExecFile{} }
func (m *SoftwareRecipe_Step_ExecFile) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_ExecFile) ProtoMessage()    {}
func (*SoftwareRecipe_Step_ExecFile) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 5}
}

func (m *SoftwareRecipe_Step_ExecFile) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_ExecFile.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_ExecFile) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_ExecFile.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_ExecFile) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_ExecFile.Merge(m, src)
}
func (m *SoftwareRecipe_Step_ExecFile) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_ExecFile.Size(m)
}
func (m *SoftwareRecipe_Step_ExecFile) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_ExecFile.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_ExecFile proto.InternalMessageInfo

type isSoftwareRecipe_Step_ExecFile_LocationType interface {
	isSoftwareRecipe_Step_ExecFile_LocationType()
}

type SoftwareRecipe_Step_ExecFile_ArtifactId struct {
	ArtifactId string `protobuf:"bytes,1,opt,name=artifact_id,json=artifactId,proto3,oneof"`
}

type SoftwareRecipe_Step_ExecFile_LocalPath struct {
	LocalPath string `protobuf:"bytes,2,opt,name=local_path,json=localPath,proto3,oneof"`
}

func (*SoftwareRecipe_Step_ExecFile_ArtifactId) isSoftwareRecipe_Step_ExecFile_LocationType() {}

func (*SoftwareRecipe_Step_ExecFile_LocalPath) isSoftwareRecipe_Step_ExecFile_LocationType() {}

func (m *SoftwareRecipe_Step_ExecFile) GetLocationType() isSoftwareRecipe_Step_ExecFile_LocationType {
	if m != nil {
		return m.LocationType
	}
	return nil
}

func (m *SoftwareRecipe_Step_ExecFile) GetArtifactId() string {
	if x, ok := m.GetLocationType().(*SoftwareRecipe_Step_ExecFile_ArtifactId); ok {
		return x.ArtifactId
	}
	return ""
}

func (m *SoftwareRecipe_Step_ExecFile) GetLocalPath() string {
	if x, ok := m.GetLocationType().(*SoftwareRecipe_Step_ExecFile_LocalPath); ok {
		return x.LocalPath
	}
	return ""
}

func (m *SoftwareRecipe_Step_ExecFile) GetArgs() []string {
	if m != nil {
		return m.Args
	}
	return nil
}

func (m *SoftwareRecipe_Step_ExecFile) GetAllowedExitCodes() []int32 {
	if m != nil {
		return m.AllowedExitCodes
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*SoftwareRecipe_Step_ExecFile) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*SoftwareRecipe_Step_ExecFile_ArtifactId)(nil),
		(*SoftwareRecipe_Step_ExecFile_LocalPath)(nil),
	}
}

// Runs a script through an interpreter.
type SoftwareRecipe_Step_RunScript struct {
	// Required. The shell script to be executed.
	Script string `protobuf:"bytes,1,opt,name=script,proto3" json:"script,omitempty"`
	// Return codes that indicate that the software installed or updated
	// successfully. Behaviour defaults to [0]
	AllowedExitCodes []int32 `protobuf:"varint,2,rep,packed,name=allowed_exit_codes,json=allowedExitCodes,proto3" json:"allowed_exit_codes,omitempty"`
	// The script interpreter to use to run the script. If no interpreter is
	// specified the script is executed directly, which likely
	// only succeed for scripts with
	// [shebang lines](https://en.wikipedia.org/wiki/Shebang_(Unix)).
	Interpreter          SoftwareRecipe_Step_RunScript_Interpreter `protobuf:"varint,3,opt,name=interpreter,proto3,enum=google.cloud.osconfig.v1beta.SoftwareRecipe_Step_RunScript_Interpreter" json:"interpreter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                  `json:"-"`
	XXX_unrecognized     []byte                                    `json:"-"`
	XXX_sizecache        int32                                     `json:"-"`
}

func (m *SoftwareRecipe_Step_RunScript) Reset()         { *m = SoftwareRecipe_Step_RunScript{} }
func (m *SoftwareRecipe_Step_RunScript) String() string { return proto.CompactTextString(m) }
func (*SoftwareRecipe_Step_RunScript) ProtoMessage()    {}
func (*SoftwareRecipe_Step_RunScript) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{8, 1, 6}
}

func (m *SoftwareRecipe_Step_RunScript) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SoftwareRecipe_Step_RunScript.Unmarshal(m, b)
}
func (m *SoftwareRecipe_Step_RunScript) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SoftwareRecipe_Step_RunScript.Marshal(b, m, deterministic)
}
func (m *SoftwareRecipe_Step_RunScript) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SoftwareRecipe_Step_RunScript.Merge(m, src)
}
func (m *SoftwareRecipe_Step_RunScript) XXX_Size() int {
	return xxx_messageInfo_SoftwareRecipe_Step_RunScript.Size(m)
}
func (m *SoftwareRecipe_Step_RunScript) XXX_DiscardUnknown() {
	xxx_messageInfo_SoftwareRecipe_Step_RunScript.DiscardUnknown(m)
}

var xxx_messageInfo_SoftwareRecipe_Step_RunScript proto.InternalMessageInfo

func (m *SoftwareRecipe_Step_RunScript) GetScript() string {
	if m != nil {
		return m.Script
	}
	return ""
}

func (m *SoftwareRecipe_Step_RunScript) GetAllowedExitCodes() []int32 {
	if m != nil {
		return m.AllowedExitCodes
	}
	return nil
}

func (m *SoftwareRecipe_Step_RunScript) GetInterpreter() SoftwareRecipe_Step_RunScript_Interpreter {
	if m != nil {
		return m.Interpreter
	}
	return SoftwareRecipe_Step_RunScript_INTERPRETER_UNSPECIFIED
}

// A request message for creating a guest policy.
type CreateGuestPolicyRequest struct {
	// Required. The resource name of the parent using one of the following forms:
	// `projects/{project_number}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The logical name of the guest policy in the project
	// with the following restrictions:
	//
	// * Must contain only lowercase letters, numbers, and hyphens.
	// * Must start with a letter.
	// * Must be between 1-63 characters.
	// * Must end with a number or a letter.
	// * Must be unique within the project.
	GuestPolicyId string `protobuf:"bytes,2,opt,name=guest_policy_id,json=guestPolicyId,proto3" json:"guest_policy_id,omitempty"`
	// Required. The GuestPolicy to create.
	GuestPolicy          *GuestPolicy `protobuf:"bytes,3,opt,name=guest_policy,json=guestPolicy,proto3" json:"guest_policy,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateGuestPolicyRequest) Reset()         { *m = CreateGuestPolicyRequest{} }
func (m *CreateGuestPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*CreateGuestPolicyRequest) ProtoMessage()    {}
func (*CreateGuestPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{9}
}

func (m *CreateGuestPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateGuestPolicyRequest.Unmarshal(m, b)
}
func (m *CreateGuestPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateGuestPolicyRequest.Marshal(b, m, deterministic)
}
func (m *CreateGuestPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateGuestPolicyRequest.Merge(m, src)
}
func (m *CreateGuestPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_CreateGuestPolicyRequest.Size(m)
}
func (m *CreateGuestPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateGuestPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateGuestPolicyRequest proto.InternalMessageInfo

func (m *CreateGuestPolicyRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateGuestPolicyRequest) GetGuestPolicyId() string {
	if m != nil {
		return m.GuestPolicyId
	}
	return ""
}

func (m *CreateGuestPolicyRequest) GetGuestPolicy() *GuestPolicy {
	if m != nil {
		return m.GuestPolicy
	}
	return nil
}

// A request message for retrieving a guest policy.
type GetGuestPolicyRequest struct {
	// Required. The resource name of the guest policy using one of the following
	// forms: `projects/{project_number}/guestPolicies/{guest_policy_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetGuestPolicyRequest) Reset()         { *m = GetGuestPolicyRequest{} }
func (m *GetGuestPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*GetGuestPolicyRequest) ProtoMessage()    {}
func (*GetGuestPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{10}
}

func (m *GetGuestPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetGuestPolicyRequest.Unmarshal(m, b)
}
func (m *GetGuestPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetGuestPolicyRequest.Marshal(b, m, deterministic)
}
func (m *GetGuestPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetGuestPolicyRequest.Merge(m, src)
}
func (m *GetGuestPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_GetGuestPolicyRequest.Size(m)
}
func (m *GetGuestPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetGuestPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetGuestPolicyRequest proto.InternalMessageInfo

func (m *GetGuestPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for listing guest policies.
type ListGuestPoliciesRequest struct {
	// Required. The resource name of the parent using one of the following forms:
	// `projects/{project_number}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of guest policies to return.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A pagination token returned from a previous call to `ListGuestPolicies`
	// that indicates where this listing should continue from.
	PageToken            string   `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGuestPoliciesRequest) Reset()         { *m = ListGuestPoliciesRequest{} }
func (m *ListGuestPoliciesRequest) String() string { return proto.CompactTextString(m) }
func (*ListGuestPoliciesRequest) ProtoMessage()    {}
func (*ListGuestPoliciesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{11}
}

func (m *ListGuestPoliciesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGuestPoliciesRequest.Unmarshal(m, b)
}
func (m *ListGuestPoliciesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGuestPoliciesRequest.Marshal(b, m, deterministic)
}
func (m *ListGuestPoliciesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGuestPoliciesRequest.Merge(m, src)
}
func (m *ListGuestPoliciesRequest) XXX_Size() int {
	return xxx_messageInfo_ListGuestPoliciesRequest.Size(m)
}
func (m *ListGuestPoliciesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGuestPoliciesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListGuestPoliciesRequest proto.InternalMessageInfo

func (m *ListGuestPoliciesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListGuestPoliciesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListGuestPoliciesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// A response message for listing guest policies.
type ListGuestPoliciesResponse struct {
	// The list of GuestPolicies.
	GuestPolicies []*GuestPolicy `protobuf:"bytes,1,rep,name=guest_policies,json=guestPolicies,proto3" json:"guest_policies,omitempty"`
	// A pagination token that can be used to get the next page
	// of guest policies.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListGuestPoliciesResponse) Reset()         { *m = ListGuestPoliciesResponse{} }
func (m *ListGuestPoliciesResponse) String() string { return proto.CompactTextString(m) }
func (*ListGuestPoliciesResponse) ProtoMessage()    {}
func (*ListGuestPoliciesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{12}
}

func (m *ListGuestPoliciesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListGuestPoliciesResponse.Unmarshal(m, b)
}
func (m *ListGuestPoliciesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListGuestPoliciesResponse.Marshal(b, m, deterministic)
}
func (m *ListGuestPoliciesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListGuestPoliciesResponse.Merge(m, src)
}
func (m *ListGuestPoliciesResponse) XXX_Size() int {
	return xxx_messageInfo_ListGuestPoliciesResponse.Size(m)
}
func (m *ListGuestPoliciesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListGuestPoliciesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListGuestPoliciesResponse proto.InternalMessageInfo

func (m *ListGuestPoliciesResponse) GetGuestPolicies() []*GuestPolicy {
	if m != nil {
		return m.GuestPolicies
	}
	return nil
}

func (m *ListGuestPoliciesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request message for updating a guest policy.
type UpdateGuestPolicyRequest struct {
	// Required. The updated GuestPolicy.
	GuestPolicy *GuestPolicy `protobuf:"bytes,1,opt,name=guest_policy,json=guestPolicy,proto3" json:"guest_policy,omitempty"`
	// Field mask that controls which fields of the guest policy should be
	// updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateGuestPolicyRequest) Reset()         { *m = UpdateGuestPolicyRequest{} }
func (m *UpdateGuestPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateGuestPolicyRequest) ProtoMessage()    {}
func (*UpdateGuestPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{13}
}

func (m *UpdateGuestPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateGuestPolicyRequest.Unmarshal(m, b)
}
func (m *UpdateGuestPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateGuestPolicyRequest.Marshal(b, m, deterministic)
}
func (m *UpdateGuestPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateGuestPolicyRequest.Merge(m, src)
}
func (m *UpdateGuestPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateGuestPolicyRequest.Size(m)
}
func (m *UpdateGuestPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateGuestPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateGuestPolicyRequest proto.InternalMessageInfo

func (m *UpdateGuestPolicyRequest) GetGuestPolicy() *GuestPolicy {
	if m != nil {
		return m.GuestPolicy
	}
	return nil
}

func (m *UpdateGuestPolicyRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// A request message for deleting a guest policy.
type DeleteGuestPolicyRequest struct {
	// Required. The resource name of the guest policy  using one of the following
	// forms: `projects/{project_number}/guestPolicies/{guest_policy_id}`.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteGuestPolicyRequest) Reset()         { *m = DeleteGuestPolicyRequest{} }
func (m *DeleteGuestPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteGuestPolicyRequest) ProtoMessage()    {}
func (*DeleteGuestPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{14}
}

func (m *DeleteGuestPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteGuestPolicyRequest.Unmarshal(m, b)
}
func (m *DeleteGuestPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteGuestPolicyRequest.Marshal(b, m, deterministic)
}
func (m *DeleteGuestPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteGuestPolicyRequest.Merge(m, src)
}
func (m *DeleteGuestPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteGuestPolicyRequest.Size(m)
}
func (m *DeleteGuestPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteGuestPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteGuestPolicyRequest proto.InternalMessageInfo

func (m *DeleteGuestPolicyRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request message for getting the effective guest policy assigned to the
// instance.
type LookupEffectiveGuestPolicyRequest struct {
	// Required. The VM instance whose policies are being looked up.
	Instance string `protobuf:"bytes,1,opt,name=instance,proto3" json:"instance,omitempty"`
	// Short name of the OS running on the instance. The OS Config agent only
	// provideS this field for targeting if OS Inventory is enabled for that
	// instance.
	OsShortName string `protobuf:"bytes,2,opt,name=os_short_name,json=osShortName,proto3" json:"os_short_name,omitempty"`
	// Version of the OS running on the instance. The OS Config agent only
	// provide this field for targeting if OS Inventory is enabled for that
	// VM instance.
	OsVersion string `protobuf:"bytes,3,opt,name=os_version,json=osVersion,proto3" json:"os_version,omitempty"`
	// Architecture of OS running on the instance. The OS Config agent only
	// provide this field for targeting if OS Inventory is enabled for that
	// instance.
	OsArchitecture       string   `protobuf:"bytes,4,opt,name=os_architecture,json=osArchitecture,proto3" json:"os_architecture,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *LookupEffectiveGuestPolicyRequest) Reset()         { *m = LookupEffectiveGuestPolicyRequest{} }
func (m *LookupEffectiveGuestPolicyRequest) String() string { return proto.CompactTextString(m) }
func (*LookupEffectiveGuestPolicyRequest) ProtoMessage()    {}
func (*LookupEffectiveGuestPolicyRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{15}
}

func (m *LookupEffectiveGuestPolicyRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LookupEffectiveGuestPolicyRequest.Unmarshal(m, b)
}
func (m *LookupEffectiveGuestPolicyRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LookupEffectiveGuestPolicyRequest.Marshal(b, m, deterministic)
}
func (m *LookupEffectiveGuestPolicyRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LookupEffectiveGuestPolicyRequest.Merge(m, src)
}
func (m *LookupEffectiveGuestPolicyRequest) XXX_Size() int {
	return xxx_messageInfo_LookupEffectiveGuestPolicyRequest.Size(m)
}
func (m *LookupEffectiveGuestPolicyRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_LookupEffectiveGuestPolicyRequest.DiscardUnknown(m)
}

var xxx_messageInfo_LookupEffectiveGuestPolicyRequest proto.InternalMessageInfo

func (m *LookupEffectiveGuestPolicyRequest) GetInstance() string {
	if m != nil {
		return m.Instance
	}
	return ""
}

func (m *LookupEffectiveGuestPolicyRequest) GetOsShortName() string {
	if m != nil {
		return m.OsShortName
	}
	return ""
}

func (m *LookupEffectiveGuestPolicyRequest) GetOsVersion() string {
	if m != nil {
		return m.OsVersion
	}
	return ""
}

func (m *LookupEffectiveGuestPolicyRequest) GetOsArchitecture() string {
	if m != nil {
		return m.OsArchitecture
	}
	return ""
}

// The effective guest policy that applies to a VM instance.
type EffectiveGuestPolicy struct {
	// List of package configurations assigned to the VM instance.
	Packages []*EffectiveGuestPolicy_SourcedPackage `protobuf:"bytes,1,rep,name=packages,proto3" json:"packages,omitempty"`
	// List of package repository configurations assigned to the VM instance.
	PackageRepositories []*EffectiveGuestPolicy_SourcedPackageRepository `protobuf:"bytes,2,rep,name=package_repositories,json=packageRepositories,proto3" json:"package_repositories,omitempty"`
	// List of recipes assigned to the VM instance.
	SoftwareRecipes      []*EffectiveGuestPolicy_SourcedSoftwareRecipe `protobuf:"bytes,3,rep,name=software_recipes,json=softwareRecipes,proto3" json:"software_recipes,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                      `json:"-"`
	XXX_unrecognized     []byte                                        `json:"-"`
	XXX_sizecache        int32                                         `json:"-"`
}

func (m *EffectiveGuestPolicy) Reset()         { *m = EffectiveGuestPolicy{} }
func (m *EffectiveGuestPolicy) String() string { return proto.CompactTextString(m) }
func (*EffectiveGuestPolicy) ProtoMessage()    {}
func (*EffectiveGuestPolicy) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{16}
}

func (m *EffectiveGuestPolicy) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EffectiveGuestPolicy.Unmarshal(m, b)
}
func (m *EffectiveGuestPolicy) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EffectiveGuestPolicy.Marshal(b, m, deterministic)
}
func (m *EffectiveGuestPolicy) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveGuestPolicy.Merge(m, src)
}
func (m *EffectiveGuestPolicy) XXX_Size() int {
	return xxx_messageInfo_EffectiveGuestPolicy.Size(m)
}
func (m *EffectiveGuestPolicy) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveGuestPolicy.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveGuestPolicy proto.InternalMessageInfo

func (m *EffectiveGuestPolicy) GetPackages() []*EffectiveGuestPolicy_SourcedPackage {
	if m != nil {
		return m.Packages
	}
	return nil
}

func (m *EffectiveGuestPolicy) GetPackageRepositories() []*EffectiveGuestPolicy_SourcedPackageRepository {
	if m != nil {
		return m.PackageRepositories
	}
	return nil
}

func (m *EffectiveGuestPolicy) GetSoftwareRecipes() []*EffectiveGuestPolicy_SourcedSoftwareRecipe {
	if m != nil {
		return m.SoftwareRecipes
	}
	return nil
}

// A guest policy package including its source.
type EffectiveGuestPolicy_SourcedPackage struct {
	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software package to configure on the VM instance.
	Package              *Package `protobuf:"bytes,2,opt,name=package,proto3" json:"package,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EffectiveGuestPolicy_SourcedPackage) Reset()         { *m = EffectiveGuestPolicy_SourcedPackage{} }
func (m *EffectiveGuestPolicy_SourcedPackage) String() string { return proto.CompactTextString(m) }
func (*EffectiveGuestPolicy_SourcedPackage) ProtoMessage()    {}
func (*EffectiveGuestPolicy_SourcedPackage) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{16, 0}
}

func (m *EffectiveGuestPolicy_SourcedPackage) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.Unmarshal(m, b)
}
func (m *EffectiveGuestPolicy_SourcedPackage) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.Marshal(b, m, deterministic)
}
func (m *EffectiveGuestPolicy_SourcedPackage) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.Merge(m, src)
}
func (m *EffectiveGuestPolicy_SourcedPackage) XXX_Size() int {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.Size(m)
}
func (m *EffectiveGuestPolicy_SourcedPackage) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveGuestPolicy_SourcedPackage proto.InternalMessageInfo

func (m *EffectiveGuestPolicy_SourcedPackage) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *EffectiveGuestPolicy_SourcedPackage) GetPackage() *Package {
	if m != nil {
		return m.Package
	}
	return nil
}

// A guest policy package repository including its source.
type EffectiveGuestPolicy_SourcedPackageRepository struct {
	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software package repository to configure on the VM instance.
	PackageRepository    *PackageRepository `protobuf:"bytes,2,opt,name=package_repository,json=packageRepository,proto3" json:"package_repository,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *EffectiveGuestPolicy_SourcedPackageRepository) Reset() {
	*m = EffectiveGuestPolicy_SourcedPackageRepository{}
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) String() string {
	return proto.CompactTextString(m)
}
func (*EffectiveGuestPolicy_SourcedPackageRepository) ProtoMessage() {}
func (*EffectiveGuestPolicy_SourcedPackageRepository) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{16, 1}
}

func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.Unmarshal(m, b)
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.Marshal(b, m, deterministic)
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.Merge(m, src)
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_Size() int {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.Size(m)
}
func (m *EffectiveGuestPolicy_SourcedPackageRepository) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveGuestPolicy_SourcedPackageRepository proto.InternalMessageInfo

func (m *EffectiveGuestPolicy_SourcedPackageRepository) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *EffectiveGuestPolicy_SourcedPackageRepository) GetPackageRepository() *PackageRepository {
	if m != nil {
		return m.PackageRepository
	}
	return nil
}

// A guest policy recipe including its source.
type EffectiveGuestPolicy_SourcedSoftwareRecipe struct {
	// Name of the guest policy providing this config.
	Source string `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// A software recipe to configure on the VM instance.
	SoftwareRecipe       *SoftwareRecipe `protobuf:"bytes,2,opt,name=software_recipe,json=softwareRecipe,proto3" json:"software_recipe,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) Reset() {
	*m = EffectiveGuestPolicy_SourcedSoftwareRecipe{}
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) String() string {
	return proto.CompactTextString(m)
}
func (*EffectiveGuestPolicy_SourcedSoftwareRecipe) ProtoMessage() {}
func (*EffectiveGuestPolicy_SourcedSoftwareRecipe) Descriptor() ([]byte, []int) {
	return fileDescriptor_54240e33d5980434, []int{16, 2}
}

func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.Unmarshal(m, b)
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.Marshal(b, m, deterministic)
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.Merge(m, src)
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_Size() int {
	return xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.Size(m)
}
func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) XXX_DiscardUnknown() {
	xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe.DiscardUnknown(m)
}

var xxx_messageInfo_EffectiveGuestPolicy_SourcedSoftwareRecipe proto.InternalMessageInfo

func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) GetSource() string {
	if m != nil {
		return m.Source
	}
	return ""
}

func (m *EffectiveGuestPolicy_SourcedSoftwareRecipe) GetSoftwareRecipe() *SoftwareRecipe {
	if m != nil {
		return m.SoftwareRecipe
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.osconfig.v1beta.DesiredState", DesiredState_name, DesiredState_value)
	proto.RegisterEnum("google.cloud.osconfig.v1beta.Package_Manager", Package_Manager_name, Package_Manager_value)
	proto.RegisterEnum("google.cloud.osconfig.v1beta.AptRepository_ArchiveType", AptRepository_ArchiveType_name, AptRepository_ArchiveType_value)
	proto.RegisterEnum("google.cloud.osconfig.v1beta.SoftwareRecipe_Step_ExtractArchive_ArchiveType", SoftwareRecipe_Step_ExtractArchive_ArchiveType_name, SoftwareRecipe_Step_ExtractArchive_ArchiveType_value)
	proto.RegisterEnum("google.cloud.osconfig.v1beta.SoftwareRecipe_Step_RunScript_Interpreter", SoftwareRecipe_Step_RunScript_Interpreter_name, SoftwareRecipe_Step_RunScript_Interpreter_value)
	proto.RegisterType((*GuestPolicy)(nil), "google.cloud.osconfig.v1beta.GuestPolicy")
	proto.RegisterType((*Assignment)(nil), "google.cloud.osconfig.v1beta.Assignment")
	proto.RegisterType((*Assignment_GroupLabel)(nil), "google.cloud.osconfig.v1beta.Assignment.GroupLabel")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.osconfig.v1beta.Assignment.GroupLabel.LabelsEntry")
	proto.RegisterType((*Assignment_OsType)(nil), "google.cloud.osconfig.v1beta.Assignment.OsType")
	proto.RegisterType((*Package)(nil), "google.cloud.osconfig.v1beta.Package")
	proto.RegisterType((*AptRepository)(nil), "google.cloud.osconfig.v1beta.AptRepository")
	proto.RegisterType((*YumRepository)(nil), "google.cloud.osconfig.v1beta.YumRepository")
	proto.RegisterType((*ZypperRepository)(nil), "google.cloud.osconfig.v1beta.ZypperRepository")
	proto.RegisterType((*GooRepository)(nil), "google.cloud.osconfig.v1beta.GooRepository")
	proto.RegisterType((*PackageRepository)(nil), "google.cloud.osconfig.v1beta.PackageRepository")
	proto.RegisterType((*SoftwareRecipe)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe")
	proto.RegisterType((*SoftwareRecipe_Artifact)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Artifact")
	proto.RegisterType((*SoftwareRecipe_Artifact_Remote)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Artifact.Remote")
	proto.RegisterType((*SoftwareRecipe_Artifact_Gcs)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Artifact.Gcs")
	proto.RegisterType((*SoftwareRecipe_Step)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Step")
	proto.RegisterType((*SoftwareRecipe_Step_CopyFile)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Step.CopyFile")
	proto.RegisterType((*SoftwareRecipe_Step_ExtractArchive)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Step.ExtractArchive")
	proto.RegisterType((*SoftwareRecipe_Step_InstallMsi)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Step.InstallMsi")
	proto.RegisterType((*SoftwareRecipe_Step_InstallDpkg)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Step.InstallDpkg")
	proto.RegisterType((*SoftwareRecipe_Step_InstallRpm)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Step.InstallRpm")
	proto.RegisterType((*SoftwareRecipe_Step_ExecFile)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Step.ExecFile")
	proto.RegisterType((*SoftwareRecipe_Step_RunScript)(nil), "google.cloud.osconfig.v1beta.SoftwareRecipe.Step.RunScript")
	proto.RegisterType((*CreateGuestPolicyRequest)(nil), "google.cloud.osconfig.v1beta.CreateGuestPolicyRequest")
	proto.RegisterType((*GetGuestPolicyRequest)(nil), "google.cloud.osconfig.v1beta.GetGuestPolicyRequest")
	proto.RegisterType((*ListGuestPoliciesRequest)(nil), "google.cloud.osconfig.v1beta.ListGuestPoliciesRequest")
	proto.RegisterType((*ListGuestPoliciesResponse)(nil), "google.cloud.osconfig.v1beta.ListGuestPoliciesResponse")
	proto.RegisterType((*UpdateGuestPolicyRequest)(nil), "google.cloud.osconfig.v1beta.UpdateGuestPolicyRequest")
	proto.RegisterType((*DeleteGuestPolicyRequest)(nil), "google.cloud.osconfig.v1beta.DeleteGuestPolicyRequest")
	proto.RegisterType((*LookupEffectiveGuestPolicyRequest)(nil), "google.cloud.osconfig.v1beta.LookupEffectiveGuestPolicyRequest")
	proto.RegisterType((*EffectiveGuestPolicy)(nil), "google.cloud.osconfig.v1beta.EffectiveGuestPolicy")
	proto.RegisterType((*EffectiveGuestPolicy_SourcedPackage)(nil), "google.cloud.osconfig.v1beta.EffectiveGuestPolicy.SourcedPackage")
	proto.RegisterType((*EffectiveGuestPolicy_SourcedPackageRepository)(nil), "google.cloud.osconfig.v1beta.EffectiveGuestPolicy.SourcedPackageRepository")
	proto.RegisterType((*EffectiveGuestPolicy_SourcedSoftwareRecipe)(nil), "google.cloud.osconfig.v1beta.EffectiveGuestPolicy.SourcedSoftwareRecipe")
}

func init() {
	proto.RegisterFile("google/cloud/osconfig/v1beta/guest_policies.proto", fileDescriptor_54240e33d5980434)
}

var fileDescriptor_54240e33d5980434 = []byte{
	// 2419 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x59, 0x4b, 0x73, 0x1b, 0xc7,
	0xf1, 0x27, 0xde, 0x40, 0x83, 0x04, 0xa1, 0xb1, 0x6c, 0x41, 0xf0, 0x43, 0x34, 0xfc, 0xd7, 0xdf,
	0x8a, 0xed, 0x80, 0x65, 0x3a, 0x2f, 0xcb, 0x49, 0xc9, 0x20, 0xb1, 0x22, 0x11, 0x93, 0x12, 0x32,
	0x00, 0x69, 0x8b, 0x79, 0x6c, 0x2d, 0x16, 0xc3, 0xd5, 0x84, 0x8b, 0x9d, 0xf5, 0xce, 0x82, 0x12,
	0xe4, 0x72, 0x0e, 0xa9, 0x72, 0xca, 0xc7, 0x54, 0xaa, 0x52, 0x39, 0xe4, 0x92, 0xdc, 0x53, 0xa9,
	0x54, 0x25, 0xa7, 0x7c, 0x8c, 0x7c, 0x01, 0xfb, 0x9c, 0x6b, 0x6e, 0x39, 0xa5, 0xe6, 0xb1, 0xc0,
	0x82, 0x04, 0x29, 0x80, 0x4c, 0x55, 0x4e, 0xd8, 0xee, 0x99, 0xfe, 0x4d, 0x4f, 0x77, 0x4f, 0x4f,
	0x4f, 0x03, 0xde, 0x75, 0x18, 0x73, 0x5c, 0xb2, 0x6e, 0xbb, 0x6c, 0xd8, 0x5f, 0x67, 0xdc, 0x66,
	0xde, 0x11, 0x75, 0xd6, 0x4f, 0xde, 0xed, 0x91, 0xd0, 0x5a, 0x77, 0x86, 0x84, 0x87, 0xa6, 0xcf,
	0x5c, 0x6a, 0x53, 0xc2, 0xeb, 0x7e, 0xc0, 0x42, 0x86, 0x5e, 0x51, 0x22, 0x75, 0x29, 0x52, 0x8f,
	0x44, 0xea, 0x4a, 0xa4, 0x7a, 0x4b, 0x03, 0x5a, 0x3e, 0x5d, 0x3f, 0xa2, 0xc4, 0xed, 0x9b, 0x3d,
	0xf2, 0xd8, 0x3a, 0xa1, 0x2c, 0x50, 0xe2, 0xd5, 0x9b, 0xb1, 0x09, 0x01, 0xe1, 0x6c, 0x18, 0xd8,
	0x44, 0x0f, 0xad, 0xe9, 0x21, 0x49, 0xf5, 0x86, 0x47, 0x1a, 0x60, 0x60, 0xf1, 0x63, 0x3d, 0xe3,
	0xd6, 0xe9, 0x19, 0x21, 0x1d, 0x10, 0x1e, 0x5a, 0x03, 0x5f, 0x4d, 0xa8, 0x7d, 0x91, 0x81, 0xe2,
	0xb6, 0xd0, 0xba, 0x2d, 0x94, 0x1e, 0xa1, 0x1b, 0x90, 0xf6, 0xac, 0x01, 0xa9, 0x24, 0xd6, 0x12,
	0x77, 0x0a, 0x9b, 0xa9, 0xaf, 0x1b, 0x49, 0x2c, 0x19, 0x68, 0x0d, 0x8a, 0x7d, 0xc2, 0xed, 0x80,
	0xfa, 0x21, 0x65, 0x5e, 0x25, 0x29, 0xc6, 0x71, 0x9c, 0x85, 0x3e, 0x84, 0xa2, 0x1d, 0x10, 0x2b,
	0x24, 0xa6, 0x58, 0xa4, 0x92, 0x5a, 0x4b, 0xdc, 0x29, 0x6e, 0x54, 0xeb, 0x7a, 0xf7, 0x91, 0x06,
	0xf5, 0x6e, 0xa4, 0x81, 0x40, 0x4f, 0x61, 0x50, 0x32, 0x82, 0x2b, 0x10, 0x86, 0x7e, 0x7f, 0x8c,
	0x90, 0x9e, 0x13, 0x41, 0xc9, 0x48, 0x84, 0x3d, 0x00, 0x8b, 0x73, 0xea, 0x78, 0x03, 0xe2, 0x85,
	0x95, 0xac, 0x04, 0xb8, 0x53, 0xbf, 0xc8, 0x01, 0xf5, 0xc6, 0x78, 0xbe, 0xda, 0x6e, 0x0c, 0x00,
	0x35, 0x20, 0xef, 0x5b, 0xf6, 0xb1, 0xe5, 0x10, 0x5e, 0xc9, 0xad, 0xa5, 0xee, 0x14, 0x37, 0x6e,
	0x5f, 0x0c, 0xd6, 0x56, 0xb3, 0xf1, 0x58, 0x0c, 0xf5, 0xe0, 0xba, 0xfe, 0x36, 0x03, 0xe2, 0x33,
	0x4e, 0x43, 0x16, 0x50, 0xc2, 0x2b, 0x79, 0x09, 0xb7, 0x3e, 0x1f, 0x5c, 0x24, 0x38, 0xc2, 0x2f,
	0xf8, 0xa7, 0x58, 0x94, 0x70, 0x74, 0x1f, 0x72, 0x01, 0xb1, 0xa9, 0x4f, 0x78, 0xa5, 0x20, 0x61,
	0xdf, 0xb9, 0x18, 0xb6, 0xc3, 0x8e, 0xc2, 0x27, 0x56, 0x40, 0xb0, 0x14, 0xc2, 0x91, 0x30, 0x42,
	0x90, 0x26, 0xa1, 0xe5, 0x54, 0x40, 0x3a, 0x57, 0x7e, 0xdf, 0x25, 0xff, 0x6c, 0xf4, 0xe0, 0x8d,
	0x31, 0x82, 0xc2, 0xb5, 0x7c, 0xca, 0xeb, 0x36, 0x1b, 0xac, 0xc7, 0x43, 0xe7, 0x7d, 0x3f, 0x60,
	0x3f, 0x27, 0x76, 0xc8, 0xd7, 0x3f, 0xd3, 0x5f, 0xa6, 0x37, 0x1c, 0xf4, 0x48, 0xf0, 0xb9, 0x3a,
	0x17, 0x6d, 0x7d, 0x2c, 0xd6, 0x3f, 0x8b, 0x1d, 0x93, 0x91, 0x49, 0xfb, 0x9f, 0xaf, 0x25, 0x6b,
	0x7f, 0x4d, 0x03, 0x4c, 0x3c, 0x81, 0x0e, 0x60, 0xd9, 0x09, 0xd8, 0xd0, 0x37, 0x5d, 0xab, 0x47,
	0x5c, 0x5e, 0x49, 0xc8, 0x6d, 0xbd, 0x37, 0xaf, 0x27, 0xeb, 0xdb, 0x42, 0x78, 0x57, 0xc8, 0xe2,
	0xa2, 0x33, 0xfe, 0xe6, 0xe8, 0x3a, 0x64, 0x9e, 0x31, 0x8f, 0xf0, 0x4a, 0x72, 0x2d, 0x75, 0xa7,
	0x80, 0x15, 0x81, 0x5e, 0x81, 0x02, 0xf5, 0x78, 0x68, 0x79, 0x36, 0xe1, 0x95, 0x94, 0x1c, 0x99,
	0x30, 0xd0, 0xb7, 0xe0, 0xa5, 0x88, 0x30, 0xc5, 0x51, 0x30, 0xfd, 0x80, 0x1c, 0xd1, 0xa7, 0x84,
	0x57, 0xd2, 0x72, 0xea, 0xf5, 0x68, 0xf4, 0x81, 0x35, 0x20, 0x6d, 0x3d, 0x86, 0x7e, 0x08, 0x79,
	0xc6, 0xcd, 0x70, 0x24, 0x9c, 0x92, 0x99, 0xc7, 0xd7, 0x31, 0xed, 0x1f, 0xf2, 0xee, 0x48, 0xf8,
	0x85, 0xc9, 0x5f, 0x5e, 0xfd, 0x43, 0x02, 0x60, 0xb2, 0x23, 0xf4, 0x31, 0x64, 0xa7, 0xcc, 0x72,
	0xef, 0x12, 0x66, 0xa9, 0x2b, 0x83, 0x18, 0x5e, 0x18, 0x8c, 0xb0, 0x86, 0xab, 0xbe, 0x0f, 0xc5,
	0x18, 0x1b, 0x95, 0x21, 0x75, 0x4c, 0x46, 0x2a, 0x15, 0x60, 0xf1, 0x29, 0xcc, 0x77, 0x62, 0xb9,
	0x43, 0xa2, 0x8f, 0xbf, 0x22, 0xee, 0x26, 0xbf, 0x97, 0xa8, 0x86, 0x90, 0x55, 0x5a, 0xa3, 0x1a,
	0xac, 0x30, 0x6e, 0xf2, 0xc7, 0x2c, 0x08, 0xcd, 0x49, 0x2a, 0xc1, 0x45, 0xc6, 0x3b, 0x82, 0x27,
	0x8c, 0x84, 0x5e, 0x05, 0x60, 0xdc, 0x3c, 0x21, 0x01, 0x9f, 0xe4, 0x92, 0x02, 0xe3, 0x07, 0x8a,
	0x81, 0xde, 0x84, 0x55, 0xc6, 0x4d, 0x2b, 0xb0, 0x1f, 0xd3, 0x90, 0xd8, 0xe1, 0x30, 0x50, 0xd9,
	0xa4, 0x80, 0x4b, 0x8c, 0x37, 0x62, 0xdc, 0xda, 0xaf, 0x93, 0x90, 0xd3, 0x67, 0xe4, 0xfc, 0xcc,
	0xf5, 0x10, 0x56, 0xfa, 0x84, 0xd3, 0x80, 0xf4, 0x4d, 0x1e, 0x5a, 0xa1, 0x52, 0xbe, 0xb4, 0xf1,
	0xd6, 0xc5, 0x56, 0x6b, 0x2a, 0x91, 0x8e, 0x90, 0xc0, 0xcb, 0xfd, 0x18, 0x85, 0xb6, 0x21, 0x37,
	0xb0, 0x3c, 0xcb, 0x21, 0x81, 0x54, 0xab, 0xb4, 0xf1, 0xcd, 0xb9, 0x4e, 0x71, 0x7d, 0x4f, 0x09,
	0xe1, 0x48, 0xba, 0x86, 0x21, 0xa7, 0x79, 0xe8, 0x06, 0xbc, 0xb0, 0xd7, 0x78, 0xd0, 0xd8, 0x36,
	0xb0, 0xb9, 0xff, 0xa0, 0xd3, 0x36, 0xb6, 0x5a, 0xf7, 0x5b, 0x46, 0xb3, 0xbc, 0x84, 0x72, 0x90,
	0x6a, 0x3c, 0x78, 0x54, 0x4e, 0xc8, 0x8f, 0x76, 0xb7, 0x9c, 0x14, 0x1f, 0x8f, 0xf6, 0xf7, 0xca,
	0x29, 0x04, 0x90, 0x3d, 0x7c, 0xd4, 0x6e, 0x1b, 0xb8, 0x9c, 0x16, 0xcc, 0xed, 0x87, 0x0f, 0xcb,
	0x99, 0xda, 0x9f, 0x92, 0xb0, 0xd2, 0xf0, 0xc3, 0x49, 0xca, 0x40, 0x87, 0xb0, 0x2c, 0x4d, 0x79,
	0x42, 0x64, 0x38, 0x4a, 0x03, 0x95, 0x36, 0xbe, 0xfb, 0x9c, 0xa0, 0x89, 0x43, 0xd4, 0x1b, 0x4a,
	0x5e, 0x46, 0x65, 0xd1, 0x9a, 0x10, 0xe8, 0x45, 0x48, 0x0d, 0x03, 0xaa, 0x3c, 0xa8, 0x6c, 0x2e,
	0x68, 0xf4, 0x26, 0x2c, 0xf7, 0x29, 0x0f, 0x03, 0xda, 0x1b, 0xca, 0xdb, 0x22, 0x35, 0x19, 0x9f,
	0x1a, 0x40, 0x6f, 0x00, 0xd8, 0x6c, 0xe0, 0x33, 0x8f, 0x78, 0xa1, 0x3e, 0x4f, 0x3a, 0x0b, 0x4f,
	0xd8, 0xe8, 0x06, 0xe4, 0x1c, 0xdf, 0x31, 0x45, 0x2c, 0x66, 0x64, 0x18, 0x64, 0x1d, 0xdf, 0xf9,
	0x88, 0x8c, 0x6a, 0x0d, 0x28, 0xc6, 0x34, 0x43, 0xaf, 0x40, 0xa5, 0x81, 0xb7, 0x76, 0x5a, 0x07,
	0x86, 0xd9, 0x7d, 0xd4, 0x36, 0xce, 0x1a, 0xb2, 0x69, 0x6c, 0x96, 0x13, 0xa8, 0x08, 0xb9, 0xa6,
	0xb1, 0x69, 0x76, 0xf0, 0x56, 0x39, 0x59, 0xfb, 0x65, 0x02, 0x56, 0x1e, 0x0d, 0x07, 0x31, 0x73,
	0xbd, 0x00, 0x49, 0xda, 0x8f, 0x47, 0x51, 0x92, 0xf6, 0xd1, 0xeb, 0x72, 0x43, 0xbe, 0x6b, 0x8d,
	0x54, 0x4c, 0x47, 0xd7, 0x9f, 0xe2, 0xc9, 0x98, 0x7e, 0x0d, 0xf2, 0x3d, 0x8b, 0x13, 0x73, 0x18,
	0xb8, 0xf1, 0xfd, 0xe6, 0x04, 0x73, 0x3f, 0x70, 0xd1, 0x4d, 0xc8, 0xeb, 0x5d, 0x44, 0x89, 0x23,
	0xa7, 0xb6, 0xc1, 0x6b, 0x5f, 0x24, 0xa0, 0x7c, 0x38, 0xf2, 0x7d, 0x12, 0xfc, 0x6f, 0xf5, 0xb8,
	0x07, 0x2b, 0xdb, 0x8c, 0xc5, 0x74, 0x38, 0xf7, 0x4c, 0x49, 0xbf, 0xbb, 0xa7, 0xfc, 0xee, 0xd6,
	0xfe, 0x9c, 0x84, 0x6b, 0x67, 0xee, 0x2c, 0x74, 0x0f, 0x52, 0x96, 0x1f, 0x4a, 0x90, 0xe2, 0xc6,
	0xdb, 0x0b, 0xc4, 0xdd, 0xce, 0x12, 0x16, 0x92, 0x02, 0x60, 0x34, 0x1c, 0xc8, 0xd5, 0x9e, 0x0b,
	0x30, 0xe5, 0x4c, 0x01, 0x30, 0x1a, 0x0e, 0xd0, 0x0e, 0x64, 0x9f, 0x49, 0xfb, 0xea, 0xaa, 0xa4,
	0x7e, 0x31, 0xc6, 0x69, 0x5f, 0xec, 0x2c, 0x61, 0x2d, 0x2f, 0x54, 0x71, 0x18, 0xd3, 0xa5, 0xc9,
	0x73, 0x54, 0x99, 0xb2, 0xa5, 0x50, 0xc5, 0x61, 0x6c, 0x73, 0x19, 0x60, 0x5c, 0x07, 0x8c, 0x6a,
	0x5f, 0x5d, 0x87, 0xd2, 0xf4, 0x6d, 0x7c, 0xbe, 0xcd, 0x2b, 0x90, 0x9b, 0xce, 0x98, 0x11, 0x89,
	0x3a, 0x50, 0xb0, 0x82, 0x90, 0x1e, 0x59, 0x76, 0xa8, 0xee, 0xaf, 0xe2, 0xc6, 0xb7, 0x17, 0xa9,
	0x00, 0xea, 0x0d, 0x2d, 0x8d, 0x27, 0x38, 0xe8, 0x00, 0x56, 0xe4, 0xc5, 0xe6, 0xba, 0x26, 0x0f,
	0x89, 0xaf, 0x82, 0xa5, 0xb8, 0xf1, 0xee, 0x42, 0xc0, 0x9d, 0x90, 0xf8, 0x78, 0x59, 0xe3, 0x08,
	0x82, 0xa3, 0x2e, 0x2c, 0xeb, 0x22, 0x4f, 0xc1, 0x66, 0x2e, 0x0b, 0xab, 0x6b, 0x45, 0x85, 0x7a,
	0x26, 0xc9, 0x67, 0xaf, 0x96, 0xe4, 0xab, 0x5f, 0xa6, 0x20, 0x1f, 0x99, 0x65, 0xf6, 0x59, 0x3c,
	0x80, 0x6c, 0x40, 0x06, 0x4c, 0x5f, 0x28, 0xc5, 0x8d, 0xef, 0x5f, 0xca, 0xe4, 0x75, 0x2c, 0x31,
	0x44, 0x88, 0x29, 0x34, 0xb4, 0x07, 0x29, 0xc7, 0xe6, 0x3a, 0x52, 0xdf, 0xbf, 0x1c, 0xe8, 0xb6,
	0xcd, 0x65, 0xc0, 0xd9, 0x1c, 0xdd, 0x86, 0x92, 0xe5, 0xba, 0xec, 0x89, 0x49, 0x3d, 0x4e, 0x6c,
	0x71, 0x97, 0x8a, 0xe0, 0xcd, 0xe3, 0x15, 0xc9, 0x6d, 0x69, 0x66, 0xf5, 0x3b, 0x90, 0x55, 0x9a,
	0x88, 0x6b, 0x5f, 0xe4, 0x74, 0x7d, 0xed, 0x8b, 0x74, 0x5e, 0x85, 0xbc, 0xfd, 0x98, 0xd8, 0xc7,
	0x5c, 0x1f, 0xc2, 0x02, 0x1e, 0xd3, 0xd5, 0x7d, 0x48, 0x6d, 0xdb, 0x1c, 0xbd, 0x04, 0xd9, 0xde,
	0xd0, 0x3e, 0x26, 0xa1, 0x96, 0xd3, 0x94, 0xe0, 0xb3, 0x9e, 0xa8, 0x05, 0xb5, 0xa0, 0xa6, 0xd0,
	0x6b, 0x00, 0x0e, 0xf1, 0x48, 0x60, 0x8d, 0xef, 0x87, 0x14, 0x8e, 0x71, 0x36, 0x01, 0xf2, 0x51,
	0x28, 0x56, 0xff, 0x5e, 0x82, 0xb4, 0xf0, 0x32, 0x7a, 0x04, 0x85, 0x23, 0xea, 0x12, 0xd3, 0x66,
	0xfe, 0x48, 0xa7, 0x93, 0xbb, 0x0b, 0xc7, 0x4d, 0x7d, 0x8b, 0xf9, 0xa3, 0xfb, 0xd4, 0x15, 0x26,
	0xcf, 0x0b, 0x38, 0x41, 0xa3, 0x4f, 0x01, 0x45, 0x97, 0x24, 0x79, 0x1a, 0x06, 0x96, 0x3d, 0x7e,
	0xe5, 0x14, 0x37, 0x3e, 0x5c, 0x7c, 0x0d, 0x43, 0x61, 0xe8, 0xdb, 0x69, 0x67, 0x09, 0x5f, 0xd3,
	0xe8, 0xc6, 0x18, 0x1c, 0x51, 0x28, 0x0f, 0x38, 0x35, 0xf5, 0xe1, 0x98, 0x18, 0x62, 0xd1, 0x48,
	0x92, 0x0b, 0xb6, 0x14, 0xca, 0x1e, 0xa7, 0x3b, 0x4b, 0x78, 0x75, 0xc0, 0x69, 0x2b, 0x06, 0x8b,
	0x5c, 0xb8, 0xd6, 0xf7, 0x8f, 0x9d, 0xe9, 0xb5, 0x54, 0x0e, 0xfb, 0xc1, 0xa5, 0xd7, 0x6a, 0xfa,
	0xc7, 0xce, 0xce, 0x12, 0x2e, 0x0b, 0xe4, 0xa9, 0xd5, 0x28, 0x94, 0x03, 0x7f, 0x30, 0xbd, 0x58,
	0xe6, 0x8a, 0x1b, 0xc3, 0xfe, 0x40, 0x6c, 0x2c, 0xf0, 0x07, 0x53, 0x4b, 0x45, 0x11, 0x41, 0x9e,
	0x12, 0x5b, 0x3f, 0xf7, 0xee, 0x5e, 0xc6, 0x5b, 0xc4, 0x8e, 0x47, 0x84, 0xa0, 0xd1, 0x4f, 0x00,
	0xd4, 0xdb, 0xd6, 0x0c, 0x86, 0x5e, 0x25, 0x27, 0xb1, 0x3f, 0x58, 0x1c, 0x1b, 0x0f, 0xbd, 0x8e,
	0x84, 0xd9, 0x59, 0xc2, 0x05, 0x05, 0x88, 0x87, 0x5e, 0xf5, 0x77, 0x09, 0xc8, 0x47, 0x81, 0x88,
	0xfe, 0x0f, 0x8a, 0x51, 0xb0, 0x9b, 0xd3, 0x79, 0x06, 0x22, 0x7e, 0xab, 0x8f, 0x6e, 0xcb, 0x17,
	0x78, 0x48, 0x3d, 0x6b, 0xf2, 0x02, 0x57, 0xb3, 0xe2, 0x7c, 0xf1, 0x98, 0x61, 0x27, 0x24, 0x78,
	0x12, 0xd0, 0x50, 0x95, 0xcd, 0x79, 0x3c, 0x61, 0x88, 0x67, 0xbc, 0x4f, 0x82, 0x01, 0xe5, 0xe2,
	0xe2, 0xe0, 0x32, 0x06, 0x0a, 0x38, 0xce, 0xaa, 0xfe, 0x2d, 0x09, 0xa5, 0xe9, 0xf0, 0x9d, 0x53,
	0xbf, 0xb5, 0x19, 0xfa, 0x4d, 0xab, 0x46, 0x20, 0x2d, 0x2b, 0x50, 0x55, 0x35, 0xef, 0x5e, 0xf5,
	0x58, 0xc5, 0xcb, 0x52, 0x7d, 0x51, 0x0a, 0xf8, 0x1a, 0x5f, 0xb0, 0x2c, 0xec, 0x36, 0x70, 0x39,
	0x81, 0x96, 0x21, 0xdf, 0x6d, 0x60, 0x73, 0xfb, 0xb0, 0xd5, 0x2e, 0x27, 0x23, 0x6a, 0x53, 0x50,
	0xa9, 0x88, 0xda, 0x3d, 0xdc, 0x6b, 0x94, 0xd3, 0xa2, 0xee, 0x16, 0xd4, 0x27, 0x87, 0xe5, 0x8c,
	0x10, 0x17, 0x53, 0x8a, 0xd5, 0x13, 0x80, 0xc9, 0x19, 0x9c, 0xd3, 0x62, 0xd7, 0x21, 0x73, 0xe4,
	0x5a, 0xce, 0xf8, 0x35, 0x2a, 0x09, 0xf4, 0x0e, 0x20, 0x99, 0x9a, 0x49, 0xdf, 0x24, 0x4f, 0x69,
	0x68, 0xda, 0xac, 0xaf, 0x9f, 0xa5, 0x19, 0x5c, 0xd6, 0x23, 0xc6, 0x53, 0x1a, 0x6e, 0x09, 0x7e,
	0xf5, 0x3d, 0x28, 0xc6, 0xce, 0xe3, 0x7c, 0x0b, 0x57, 0x37, 0xc6, 0xca, 0x62, 0x7f, 0x30, 0xa7,
	0xcc, 0x1f, 0x13, 0x90, 0x8f, 0x0e, 0x0a, 0x7a, 0x7d, 0x86, 0xc8, 0xce, 0xd2, 0xd4, 0xe6, 0x6e,
	0x01, 0xb8, 0xcc, 0xb6, 0x5c, 0xd3, 0xb7, 0xc2, 0xc7, 0x2a, 0x1a, 0xc4, 0x11, 0x90, 0xbc, 0xb6,
	0x15, 0x3e, 0x46, 0x08, 0xd2, 0x56, 0xe0, 0x44, 0x0f, 0x6e, 0xf9, 0x7d, 0xce, 0xde, 0xd3, 0xb3,
	0xf7, 0xbe, 0xb9, 0x0a, 0x2b, 0x02, 0x4e, 0xc4, 0x96, 0x7c, 0xda, 0x54, 0xbf, 0x4c, 0x42, 0x61,
	0x7c, 0xe0, 0xd0, 0xcb, 0x90, 0x55, 0x07, 0x2e, 0xbe, 0x25, 0xcd, 0x3a, 0x67, 0xa5, 0xe4, 0xec,
	0x95, 0x10, 0x85, 0x22, 0xf5, 0x42, 0x12, 0xf8, 0x01, 0x09, 0xc7, 0xcf, 0xbe, 0xed, 0x2b, 0x64,
	0x83, 0x7a, 0x6b, 0x02, 0x87, 0xe3, 0xd8, 0x35, 0x43, 0x38, 0x74, 0x4c, 0xa2, 0x97, 0xe1, 0x46,
	0xeb, 0x41, 0xd7, 0xc0, 0x6d, 0x6c, 0x74, 0xcf, 0x3c, 0x0e, 0x0b, 0x90, 0xe9, 0xec, 0x18, 0xbb,
	0xbb, 0xe5, 0x04, 0x2a, 0x01, 0xb4, 0x1f, 0x7e, 0x6c, 0x60, 0x45, 0xa7, 0x36, 0xb3, 0x90, 0x16,
	0xf5, 0x55, 0xed, 0xab, 0x04, 0x54, 0xb6, 0x64, 0x8b, 0x2d, 0xd6, 0xab, 0xc1, 0xe4, 0x53, 0x41,
	0xa0, 0x2d, 0xc8, 0xfa, 0x56, 0x40, 0xbc, 0xc8, 0x42, 0x6f, 0x7f, 0xdd, 0x48, 0xfe, 0xbb, 0x71,
	0x1b, 0xcd, 0xd3, 0xef, 0xc1, 0x5a, 0x14, 0xbd, 0x0d, 0xab, 0xa7, 0x1a, 0x3a, 0xf1, 0xdc, 0xb4,
	0x32, 0xe9, 0xfd, 0x8c, 0x5a, 0x7d, 0xf4, 0x23, 0x58, 0x8e, 0x4f, 0xd6, 0x17, 0xde, 0x37, 0x9e,
	0x53, 0x48, 0x4f, 0x20, 0x74, 0xc2, 0x8b, 0x81, 0xd6, 0x3e, 0x81, 0x17, 0xb7, 0x49, 0x38, 0x63,
	0x77, 0xf7, 0xa6, 0x2a, 0x69, 0xbd, 0xb7, 0xb9, 0x7a, 0x59, 0xaa, 0xe2, 0xae, 0xfd, 0x3e, 0x01,
	0x95, 0x5d, 0xca, 0x63, 0xd8, 0x94, 0xf0, 0xff, 0xaa, 0xed, 0x5e, 0x86, 0x82, 0x6f, 0x39, 0xc4,
	0xe4, 0xf4, 0x99, 0x2a, 0x23, 0x33, 0x38, 0x2f, 0x18, 0x1d, 0xfa, 0x4c, 0x76, 0x49, 0xe4, 0x60,
	0xc8, 0x8e, 0x89, 0x7e, 0x43, 0x63, 0x39, 0xbd, 0x2b, 0x18, 0xb5, 0xdf, 0x26, 0xe0, 0xe6, 0x0c,
	0xed, 0xb8, 0xcf, 0x3c, 0x4e, 0x50, 0x1b, 0x4a, 0xd3, 0xdd, 0x68, 0xdd, 0x2c, 0x9a, 0xdf, 0xd4,
	0x71, 0xd7, 0x51, 0xc2, 0xd1, 0xff, 0xc3, 0xaa, 0x47, 0x9e, 0x86, 0x66, 0x4c, 0x27, 0x95, 0xe3,
	0x57, 0x04, 0xbb, 0x3d, 0xd6, 0xeb, 0x1f, 0x09, 0xa8, 0xec, 0xcb, 0xd2, 0x7c, 0x86, 0x4f, 0x46,
	0xa7, 0xfc, 0x9f, 0x58, 0xd4, 0xff, 0x0b, 0xb9, 0x31, 0x1e, 0x27, 0xe8, 0x83, 0x71, 0x77, 0x79,
	0x60, 0xf1, 0x63, 0x5d, 0xdb, 0x9d, 0xed, 0x2e, 0xdf, 0xa7, 0xc4, 0xed, 0xef, 0x59, 0xfc, 0x38,
	0x6a, 0x2c, 0x8b, 0xef, 0xda, 0x8f, 0xa1, 0xd2, 0x24, 0x2e, 0x99, 0xb9, 0xa7, 0x2b, 0xc7, 0xd9,
	0x5f, 0x12, 0xf0, 0xfa, 0x2e, 0x63, 0xc7, 0x43, 0xdf, 0x38, 0x3a, 0x22, 0x76, 0x48, 0x4f, 0x66,
	0x2d, 0x73, 0x0b, 0xf2, 0x51, 0xa7, 0x31, 0x9e, 0xd0, 0xc6, 0xcc, 0xb3, 0x9d, 0xb7, 0xe4, 0xf3,
	0x3a, 0x6f, 0xa9, 0x39, 0x3a, 0x6f, 0xe9, 0x99, 0x9d, 0xb7, 0x7f, 0x65, 0xe0, 0xfa, 0x2c, 0x65,
	0xd1, 0x4f, 0x63, 0x2d, 0x73, 0x15, 0x71, 0x8d, 0x8b, 0x9d, 0x3b, 0x0b, 0xa5, 0xde, 0x91, 0x7f,
	0x73, 0xf4, 0xcf, 0xb6, 0xd3, 0x7f, 0x71, 0x4e, 0x3b, 0x3d, 0x29, 0x97, 0xfa, 0xe8, 0xea, 0x4b,
	0x3d, 0xa7, 0xd5, 0xce, 0xa1, 0xcc, 0x75, 0x5e, 0x37, 0xa3, 0x9e, 0xbb, 0x7a, 0x71, 0xef, 0x5c,
	0x7e, 0xed, 0x53, 0xfd, 0xf8, 0x55, 0x3e, 0x45, 0xf3, 0x2a, 0x85, 0xd2, 0xb4, 0x96, 0xe2, 0x59,
	0xa5, 0xfe, 0x09, 0x8a, 0x9e, 0x5b, 0x8a, 0x42, 0xf7, 0x20, 0xa7, 0xb5, 0xd6, 0xf1, 0x3d, 0xe7,
	0xff, 0x15, 0x91, 0x54, 0xf5, 0x37, 0x09, 0xa8, 0x9c, 0x67, 0x91, 0x73, 0x57, 0xfd, 0x19, 0xa0,
	0x33, 0x4e, 0x19, 0x69, 0x05, 0x16, 0xfe, 0x87, 0xe3, 0xda, 0x69, 0xb3, 0x8f, 0xaa, 0xbf, 0x4a,
	0xc0, 0x8b, 0x33, 0x4d, 0x75, 0xae, 0x46, 0xfb, 0xb0, 0x7a, 0xca, 0x4d, 0x5a, 0x9d, 0xc5, 0xfe,
	0x19, 0x29, 0x4d, 0x7b, 0xe2, 0xad, 0x03, 0x58, 0x8e, 0xb7, 0x0c, 0xd0, 0xab, 0x70, 0xb3, 0x69,
	0x74, 0x5a, 0xd8, 0x68, 0x9a, 0x9d, 0x6e, 0xa3, 0x7b, 0xba, 0xb6, 0x5c, 0x81, 0x42, 0xeb, 0x41,
	0xa7, 0xdb, 0xd8, 0xdd, 0x35, 0x9a, 0xaa, 0xf1, 0xb8, 0xdf, 0x6e, 0x36, 0xba, 0x46, 0xb3, 0x9c,
	0x14, 0x04, 0x36, 0xf6, 0x1e, 0x1e, 0x18, 0xcd, 0x72, 0x6a, 0xf3, 0x09, 0xac, 0xd9, 0x6c, 0x70,
	0xa1, 0x6a, 0x9b, 0x2b, 0x53, 0x79, 0xfe, 0xb0, 0xa9, 0x27, 0x3b, 0xcc, 0xb5, 0x3c, 0xa7, 0xce,
	0x02, 0x67, 0xdd, 0x21, 0x9e, 0xcc, 0x62, 0xeb, 0x93, 0x84, 0x33, 0xfb, 0x7f, 0xca, 0x0f, 0x22,
	0xba, 0x97, 0x95, 0x02, 0xef, 0xfd, 0x27, 0x00, 0x00, 0xff, 0xff, 0x37, 0x2b, 0xed, 0xcb, 0xd7,
	0x1c, 0x00, 0x00,
}
