// Code generated by protoc-gen-gogo.
// source: containerizer.proto
// DO NOT EDIT!

package mesosproto

import proto "github.com/gogo/protobuf/proto"
import fmt "fmt"
import math "math"

// discarding unused import gogoproto "github.com/gogo/protobuf/gogoproto"

import bytes "bytes"

import strings "strings"
import github_com_gogo_protobuf_proto "github.com/gogo/protobuf/proto"
import sort "sort"
import strconv "strconv"
import reflect "reflect"

import io "io"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// *
// Encodes the launch command sent to the external containerizer
// program.
type Launch struct {
	ContainerId      *ContainerID  `protobuf:"bytes,1,req,name=container_id" json:"container_id,omitempty"`
	TaskInfo         *TaskInfo     `protobuf:"bytes,2,opt,name=task_info" json:"task_info,omitempty"`
	ExecutorInfo     *ExecutorInfo `protobuf:"bytes,3,opt,name=executor_info" json:"executor_info,omitempty"`
	Directory        *string       `protobuf:"bytes,4,opt,name=directory" json:"directory,omitempty"`
	User             *string       `protobuf:"bytes,5,opt,name=user" json:"user,omitempty"`
	SlaveId          *SlaveID      `protobuf:"bytes,6,opt,name=slave_id" json:"slave_id,omitempty"`
	SlavePid         *string       `protobuf:"bytes,7,opt,name=slave_pid" json:"slave_pid,omitempty"`
	Checkpoint       *bool         `protobuf:"varint,8,opt,name=checkpoint" json:"checkpoint,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *Launch) Reset()      { *m = Launch{} }
func (*Launch) ProtoMessage() {}

func (m *Launch) GetContainerId() *ContainerID {
	if m != nil {
		return m.ContainerId
	}
	return nil
}

func (m *Launch) GetTaskInfo() *TaskInfo {
	if m != nil {
		return m.TaskInfo
	}
	return nil
}

func (m *Launch) GetExecutorInfo() *ExecutorInfo {
	if m != nil {
		return m.ExecutorInfo
	}
	return nil
}

func (m *Launch) GetDirectory() string {
	if m != nil && m.Directory != nil {
		return *m.Directory
	}
	return ""
}

func (m *Launch) GetUser() string {
	if m != nil && m.User != nil {
		return *m.User
	}
	return ""
}

func (m *Launch) GetSlaveId() *SlaveID {
	if m != nil {
		return m.SlaveId
	}
	return nil
}

func (m *Launch) GetSlavePid() string {
	if m != nil && m.SlavePid != nil {
		return *m.SlavePid
	}
	return ""
}

func (m *Launch) GetCheckpoint() bool {
	if m != nil && m.Checkpoint != nil {
		return *m.Checkpoint
	}
	return false
}

// *
// Encodes the update command sent to the external containerizer
// program.
type Update struct {
	ContainerId      *ContainerID `protobuf:"bytes,1,req,name=container_id" json:"container_id,omitempty"`
	Resources        []*Resource  `protobuf:"bytes,2,rep,name=resources" json:"resources,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Update) Reset()      { *m = Update{} }
func (*Update) ProtoMessage() {}

func (m *Update) GetContainerId() *ContainerID {
	if m != nil {
		return m.ContainerId
	}
	return nil
}

func (m *Update) GetResources() []*Resource {
	if m != nil {
		return m.Resources
	}
	return nil
}

// *
// Encodes the wait command sent to the external containerizer
// program.
type Wait struct {
	ContainerId      *ContainerID `protobuf:"bytes,1,req,name=container_id" json:"container_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Wait) Reset()      { *m = Wait{} }
func (*Wait) ProtoMessage() {}

func (m *Wait) GetContainerId() *ContainerID {
	if m != nil {
		return m.ContainerId
	}
	return nil
}

// *
// Encodes the destroy command sent to the external containerizer
// program.
type Destroy struct {
	ContainerId      *ContainerID `protobuf:"bytes,1,req,name=container_id" json:"container_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Destroy) Reset()      { *m = Destroy{} }
func (*Destroy) ProtoMessage() {}

func (m *Destroy) GetContainerId() *ContainerID {
	if m != nil {
		return m.ContainerId
	}
	return nil
}

// *
// Encodes the usage command sent to the external containerizer
// program.
type Usage struct {
	ContainerId      *ContainerID `protobuf:"bytes,1,req,name=container_id" json:"container_id,omitempty"`
	XXX_unrecognized []byte       `json:"-"`
}

func (m *Usage) Reset()      { *m = Usage{} }
func (*Usage) ProtoMessage() {}

func (m *Usage) GetContainerId() *ContainerID {
	if m != nil {
		return m.ContainerId
	}
	return nil
}

// *
// Information about a container termination, returned by the
// containerizer to the slave.
type Termination struct {
	// A container may be killed if it exceeds its resources; this will
	// be indicated by killed=true and described by the message string.
	// TODO(jaybuff): As part of MESOS-2035 we should remove killed and
	// replace it with a TaskStatus::Reason.
	Killed  *bool   `protobuf:"varint,1,req,name=killed" json:"killed,omitempty"`
	Message *string `protobuf:"bytes,2,req,name=message" json:"message,omitempty"`
	// Exit status of the process.
	Status           *int32 `protobuf:"varint,3,opt,name=status" json:"status,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *Termination) Reset()      { *m = Termination{} }
func (*Termination) ProtoMessage() {}

func (m *Termination) GetKilled() bool {
	if m != nil && m.Killed != nil {
		return *m.Killed
	}
	return false
}

func (m *Termination) GetMessage() string {
	if m != nil && m.Message != nil {
		return *m.Message
	}
	return ""
}

func (m *Termination) GetStatus() int32 {
	if m != nil && m.Status != nil {
		return *m.Status
	}
	return 0
}

// *
// Information on all active containers returned by the containerizer
// to the slave.
type Containers struct {
	Containers       []*ContainerID `protobuf:"bytes,1,rep,name=containers" json:"containers,omitempty"`
	XXX_unrecognized []byte         `json:"-"`
}

func (m *Containers) Reset()      { *m = Containers{} }
func (*Containers) ProtoMessage() {}

func (m *Containers) GetContainers() []*ContainerID {
	if m != nil {
		return m.Containers
	}
	return nil
}

func (this *Launch) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Launch)
	if !ok {
		return fmt.Errorf("that is not of type *Launch")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Launch but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Launchbut is not nil && this == nil")
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return fmt.Errorf("ContainerId this(%v) Not Equal that(%v)", this.ContainerId, that1.ContainerId)
	}
	if !this.TaskInfo.Equal(that1.TaskInfo) {
		return fmt.Errorf("TaskInfo this(%v) Not Equal that(%v)", this.TaskInfo, that1.TaskInfo)
	}
	if !this.ExecutorInfo.Equal(that1.ExecutorInfo) {
		return fmt.Errorf("ExecutorInfo this(%v) Not Equal that(%v)", this.ExecutorInfo, that1.ExecutorInfo)
	}
	if this.Directory != nil && that1.Directory != nil {
		if *this.Directory != *that1.Directory {
			return fmt.Errorf("Directory this(%v) Not Equal that(%v)", *this.Directory, *that1.Directory)
		}
	} else if this.Directory != nil {
		return fmt.Errorf("this.Directory == nil && that.Directory != nil")
	} else if that1.Directory != nil {
		return fmt.Errorf("Directory this(%v) Not Equal that(%v)", this.Directory, that1.Directory)
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return fmt.Errorf("User this(%v) Not Equal that(%v)", *this.User, *that1.User)
		}
	} else if this.User != nil {
		return fmt.Errorf("this.User == nil && that.User != nil")
	} else if that1.User != nil {
		return fmt.Errorf("User this(%v) Not Equal that(%v)", this.User, that1.User)
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return fmt.Errorf("SlaveId this(%v) Not Equal that(%v)", this.SlaveId, that1.SlaveId)
	}
	if this.SlavePid != nil && that1.SlavePid != nil {
		if *this.SlavePid != *that1.SlavePid {
			return fmt.Errorf("SlavePid this(%v) Not Equal that(%v)", *this.SlavePid, *that1.SlavePid)
		}
	} else if this.SlavePid != nil {
		return fmt.Errorf("this.SlavePid == nil && that.SlavePid != nil")
	} else if that1.SlavePid != nil {
		return fmt.Errorf("SlavePid this(%v) Not Equal that(%v)", this.SlavePid, that1.SlavePid)
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return fmt.Errorf("Checkpoint this(%v) Not Equal that(%v)", *this.Checkpoint, *that1.Checkpoint)
		}
	} else if this.Checkpoint != nil {
		return fmt.Errorf("this.Checkpoint == nil && that.Checkpoint != nil")
	} else if that1.Checkpoint != nil {
		return fmt.Errorf("Checkpoint this(%v) Not Equal that(%v)", this.Checkpoint, that1.Checkpoint)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Launch) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Launch)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return false
	}
	if !this.TaskInfo.Equal(that1.TaskInfo) {
		return false
	}
	if !this.ExecutorInfo.Equal(that1.ExecutorInfo) {
		return false
	}
	if this.Directory != nil && that1.Directory != nil {
		if *this.Directory != *that1.Directory {
			return false
		}
	} else if this.Directory != nil {
		return false
	} else if that1.Directory != nil {
		return false
	}
	if this.User != nil && that1.User != nil {
		if *this.User != *that1.User {
			return false
		}
	} else if this.User != nil {
		return false
	} else if that1.User != nil {
		return false
	}
	if !this.SlaveId.Equal(that1.SlaveId) {
		return false
	}
	if this.SlavePid != nil && that1.SlavePid != nil {
		if *this.SlavePid != *that1.SlavePid {
			return false
		}
	} else if this.SlavePid != nil {
		return false
	} else if that1.SlavePid != nil {
		return false
	}
	if this.Checkpoint != nil && that1.Checkpoint != nil {
		if *this.Checkpoint != *that1.Checkpoint {
			return false
		}
	} else if this.Checkpoint != nil {
		return false
	} else if that1.Checkpoint != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Update) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Update)
	if !ok {
		return fmt.Errorf("that is not of type *Update")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Update but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Updatebut is not nil && this == nil")
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return fmt.Errorf("ContainerId this(%v) Not Equal that(%v)", this.ContainerId, that1.ContainerId)
	}
	if len(this.Resources) != len(that1.Resources) {
		return fmt.Errorf("Resources this(%v) Not Equal that(%v)", len(this.Resources), len(that1.Resources))
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return fmt.Errorf("Resources this[%v](%v) Not Equal that[%v](%v)", i, this.Resources[i], i, that1.Resources[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Update) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Update)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return false
	}
	if len(this.Resources) != len(that1.Resources) {
		return false
	}
	for i := range this.Resources {
		if !this.Resources[i].Equal(that1.Resources[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Wait) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Wait)
	if !ok {
		return fmt.Errorf("that is not of type *Wait")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Wait but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Waitbut is not nil && this == nil")
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return fmt.Errorf("ContainerId this(%v) Not Equal that(%v)", this.ContainerId, that1.ContainerId)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Wait) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Wait)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Destroy) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Destroy)
	if !ok {
		return fmt.Errorf("that is not of type *Destroy")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Destroy but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Destroybut is not nil && this == nil")
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return fmt.Errorf("ContainerId this(%v) Not Equal that(%v)", this.ContainerId, that1.ContainerId)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Destroy) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Destroy)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Usage) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Usage)
	if !ok {
		return fmt.Errorf("that is not of type *Usage")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Usage but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Usagebut is not nil && this == nil")
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return fmt.Errorf("ContainerId this(%v) Not Equal that(%v)", this.ContainerId, that1.ContainerId)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Usage) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Usage)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if !this.ContainerId.Equal(that1.ContainerId) {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Termination) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Termination)
	if !ok {
		return fmt.Errorf("that is not of type *Termination")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Termination but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Terminationbut is not nil && this == nil")
	}
	if this.Killed != nil && that1.Killed != nil {
		if *this.Killed != *that1.Killed {
			return fmt.Errorf("Killed this(%v) Not Equal that(%v)", *this.Killed, *that1.Killed)
		}
	} else if this.Killed != nil {
		return fmt.Errorf("this.Killed == nil && that.Killed != nil")
	} else if that1.Killed != nil {
		return fmt.Errorf("Killed this(%v) Not Equal that(%v)", this.Killed, that1.Killed)
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return fmt.Errorf("Message this(%v) Not Equal that(%v)", *this.Message, *that1.Message)
		}
	} else if this.Message != nil {
		return fmt.Errorf("this.Message == nil && that.Message != nil")
	} else if that1.Message != nil {
		return fmt.Errorf("Message this(%v) Not Equal that(%v)", this.Message, that1.Message)
	}
	if this.Status != nil && that1.Status != nil {
		if *this.Status != *that1.Status {
			return fmt.Errorf("Status this(%v) Not Equal that(%v)", *this.Status, *that1.Status)
		}
	} else if this.Status != nil {
		return fmt.Errorf("this.Status == nil && that.Status != nil")
	} else if that1.Status != nil {
		return fmt.Errorf("Status this(%v) Not Equal that(%v)", this.Status, that1.Status)
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Termination) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Termination)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if this.Killed != nil && that1.Killed != nil {
		if *this.Killed != *that1.Killed {
			return false
		}
	} else if this.Killed != nil {
		return false
	} else if that1.Killed != nil {
		return false
	}
	if this.Message != nil && that1.Message != nil {
		if *this.Message != *that1.Message {
			return false
		}
	} else if this.Message != nil {
		return false
	} else if that1.Message != nil {
		return false
	}
	if this.Status != nil && that1.Status != nil {
		if *this.Status != *that1.Status {
			return false
		}
	} else if this.Status != nil {
		return false
	} else if that1.Status != nil {
		return false
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Containers) VerboseEqual(that interface{}) error {
	if that == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that == nil && this != nil")
	}

	that1, ok := that.(*Containers)
	if !ok {
		return fmt.Errorf("that is not of type *Containers")
	}
	if that1 == nil {
		if this == nil {
			return nil
		}
		return fmt.Errorf("that is type *Containers but is nil && this != nil")
	} else if this == nil {
		return fmt.Errorf("that is type *Containersbut is not nil && this == nil")
	}
	if len(this.Containers) != len(that1.Containers) {
		return fmt.Errorf("Containers this(%v) Not Equal that(%v)", len(this.Containers), len(that1.Containers))
	}
	for i := range this.Containers {
		if !this.Containers[i].Equal(that1.Containers[i]) {
			return fmt.Errorf("Containers this[%v](%v) Not Equal that[%v](%v)", i, this.Containers[i], i, that1.Containers[i])
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return fmt.Errorf("XXX_unrecognized this(%v) Not Equal that(%v)", this.XXX_unrecognized, that1.XXX_unrecognized)
	}
	return nil
}
func (this *Containers) Equal(that interface{}) bool {
	if that == nil {
		if this == nil {
			return true
		}
		return false
	}

	that1, ok := that.(*Containers)
	if !ok {
		return false
	}
	if that1 == nil {
		if this == nil {
			return true
		}
		return false
	} else if this == nil {
		return false
	}
	if len(this.Containers) != len(that1.Containers) {
		return false
	}
	for i := range this.Containers {
		if !this.Containers[i].Equal(that1.Containers[i]) {
			return false
		}
	}
	if !bytes.Equal(this.XXX_unrecognized, that1.XXX_unrecognized) {
		return false
	}
	return true
}
func (this *Launch) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 12)
	s = append(s, "&mesosproto.Launch{")
	if this.ContainerId != nil {
		s = append(s, "ContainerId: "+fmt.Sprintf("%#v", this.ContainerId)+",\n")
	}
	if this.TaskInfo != nil {
		s = append(s, "TaskInfo: "+fmt.Sprintf("%#v", this.TaskInfo)+",\n")
	}
	if this.ExecutorInfo != nil {
		s = append(s, "ExecutorInfo: "+fmt.Sprintf("%#v", this.ExecutorInfo)+",\n")
	}
	if this.Directory != nil {
		s = append(s, "Directory: "+valueToGoStringContainerizer(this.Directory, "string")+",\n")
	}
	if this.User != nil {
		s = append(s, "User: "+valueToGoStringContainerizer(this.User, "string")+",\n")
	}
	if this.SlaveId != nil {
		s = append(s, "SlaveId: "+fmt.Sprintf("%#v", this.SlaveId)+",\n")
	}
	if this.SlavePid != nil {
		s = append(s, "SlavePid: "+valueToGoStringContainerizer(this.SlavePid, "string")+",\n")
	}
	if this.Checkpoint != nil {
		s = append(s, "Checkpoint: "+valueToGoStringContainerizer(this.Checkpoint, "bool")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Update) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&mesosproto.Update{")
	if this.ContainerId != nil {
		s = append(s, "ContainerId: "+fmt.Sprintf("%#v", this.ContainerId)+",\n")
	}
	if this.Resources != nil {
		s = append(s, "Resources: "+fmt.Sprintf("%#v", this.Resources)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Wait) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Wait{")
	if this.ContainerId != nil {
		s = append(s, "ContainerId: "+fmt.Sprintf("%#v", this.ContainerId)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Destroy) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Destroy{")
	if this.ContainerId != nil {
		s = append(s, "ContainerId: "+fmt.Sprintf("%#v", this.ContainerId)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Usage) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Usage{")
	if this.ContainerId != nil {
		s = append(s, "ContainerId: "+fmt.Sprintf("%#v", this.ContainerId)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Termination) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&mesosproto.Termination{")
	if this.Killed != nil {
		s = append(s, "Killed: "+valueToGoStringContainerizer(this.Killed, "bool")+",\n")
	}
	if this.Message != nil {
		s = append(s, "Message: "+valueToGoStringContainerizer(this.Message, "string")+",\n")
	}
	if this.Status != nil {
		s = append(s, "Status: "+valueToGoStringContainerizer(this.Status, "int32")+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *Containers) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&mesosproto.Containers{")
	if this.Containers != nil {
		s = append(s, "Containers: "+fmt.Sprintf("%#v", this.Containers)+",\n")
	}
	if this.XXX_unrecognized != nil {
		s = append(s, "XXX_unrecognized:"+fmt.Sprintf("%#v", this.XXX_unrecognized)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringContainerizer(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}
func extensionToGoStringContainerizer(e map[int32]github_com_gogo_protobuf_proto.Extension) string {
	if e == nil {
		return "nil"
	}
	s := "map[int32]proto.Extension{"
	keys := make([]int, 0, len(e))
	for k := range e {
		keys = append(keys, int(k))
	}
	sort.Ints(keys)
	ss := []string{}
	for _, k := range keys {
		ss = append(ss, strconv.Itoa(k)+": "+e[int32(k)].GoString())
	}
	s += strings.Join(ss, ",") + "}"
	return s
}
func (m *Launch) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Launch) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ContainerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintContainerizer(data, i, uint64(m.ContainerId.Size()))
		n1, err := m.ContainerId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n1
	}
	if m.TaskInfo != nil {
		data[i] = 0x12
		i++
		i = encodeVarintContainerizer(data, i, uint64(m.TaskInfo.Size()))
		n2, err := m.TaskInfo.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n2
	}
	if m.ExecutorInfo != nil {
		data[i] = 0x1a
		i++
		i = encodeVarintContainerizer(data, i, uint64(m.ExecutorInfo.Size()))
		n3, err := m.ExecutorInfo.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n3
	}
	if m.Directory != nil {
		data[i] = 0x22
		i++
		i = encodeVarintContainerizer(data, i, uint64(len(*m.Directory)))
		i += copy(data[i:], *m.Directory)
	}
	if m.User != nil {
		data[i] = 0x2a
		i++
		i = encodeVarintContainerizer(data, i, uint64(len(*m.User)))
		i += copy(data[i:], *m.User)
	}
	if m.SlaveId != nil {
		data[i] = 0x32
		i++
		i = encodeVarintContainerizer(data, i, uint64(m.SlaveId.Size()))
		n4, err := m.SlaveId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n4
	}
	if m.SlavePid != nil {
		data[i] = 0x3a
		i++
		i = encodeVarintContainerizer(data, i, uint64(len(*m.SlavePid)))
		i += copy(data[i:], *m.SlavePid)
	}
	if m.Checkpoint != nil {
		data[i] = 0x40
		i++
		if *m.Checkpoint {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Update) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Update) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ContainerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintContainerizer(data, i, uint64(m.ContainerId.Size()))
		n5, err := m.ContainerId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n5
	}
	if len(m.Resources) > 0 {
		for _, msg := range m.Resources {
			data[i] = 0x12
			i++
			i = encodeVarintContainerizer(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Wait) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Wait) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ContainerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintContainerizer(data, i, uint64(m.ContainerId.Size()))
		n6, err := m.ContainerId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n6
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Destroy) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Destroy) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ContainerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintContainerizer(data, i, uint64(m.ContainerId.Size()))
		n7, err := m.ContainerId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n7
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Usage) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Usage) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.ContainerId == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	} else {
		data[i] = 0xa
		i++
		i = encodeVarintContainerizer(data, i, uint64(m.ContainerId.Size()))
		n8, err := m.ContainerId.MarshalTo(data[i:])
		if err != nil {
			return 0, err
		}
		i += n8
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Termination) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Termination) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if m.Killed == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("killed")
	} else {
		data[i] = 0x8
		i++
		if *m.Killed {
			data[i] = 1
		} else {
			data[i] = 0
		}
		i++
	}
	if m.Message == nil {
		return 0, github_com_gogo_protobuf_proto.NewRequiredNotSetError("message")
	} else {
		data[i] = 0x12
		i++
		i = encodeVarintContainerizer(data, i, uint64(len(*m.Message)))
		i += copy(data[i:], *m.Message)
	}
	if m.Status != nil {
		data[i] = 0x18
		i++
		i = encodeVarintContainerizer(data, i, uint64(*m.Status))
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func (m *Containers) Marshal() (data []byte, err error) {
	size := m.Size()
	data = make([]byte, size)
	n, err := m.MarshalTo(data)
	if err != nil {
		return nil, err
	}
	return data[:n], nil
}

func (m *Containers) MarshalTo(data []byte) (int, error) {
	var i int
	_ = i
	var l int
	_ = l
	if len(m.Containers) > 0 {
		for _, msg := range m.Containers {
			data[i] = 0xa
			i++
			i = encodeVarintContainerizer(data, i, uint64(msg.Size()))
			n, err := msg.MarshalTo(data[i:])
			if err != nil {
				return 0, err
			}
			i += n
		}
	}
	if m.XXX_unrecognized != nil {
		i += copy(data[i:], m.XXX_unrecognized)
	}
	return i, nil
}

func encodeFixed64Containerizer(data []byte, offset int, v uint64) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	data[offset+4] = uint8(v >> 32)
	data[offset+5] = uint8(v >> 40)
	data[offset+6] = uint8(v >> 48)
	data[offset+7] = uint8(v >> 56)
	return offset + 8
}
func encodeFixed32Containerizer(data []byte, offset int, v uint32) int {
	data[offset] = uint8(v)
	data[offset+1] = uint8(v >> 8)
	data[offset+2] = uint8(v >> 16)
	data[offset+3] = uint8(v >> 24)
	return offset + 4
}
func encodeVarintContainerizer(data []byte, offset int, v uint64) int {
	for v >= 1<<7 {
		data[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	data[offset] = uint8(v)
	return offset + 1
}
func NewPopulatedLaunch(r randyContainerizer, easy bool) *Launch {
	this := &Launch{}
	this.ContainerId = NewPopulatedContainerID(r, easy)
	if r.Intn(10) != 0 {
		this.TaskInfo = NewPopulatedTaskInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		this.ExecutorInfo = NewPopulatedExecutorInfo(r, easy)
	}
	if r.Intn(10) != 0 {
		v1 := randStringContainerizer(r)
		this.Directory = &v1
	}
	if r.Intn(10) != 0 {
		v2 := randStringContainerizer(r)
		this.User = &v2
	}
	if r.Intn(10) != 0 {
		this.SlaveId = NewPopulatedSlaveID(r, easy)
	}
	if r.Intn(10) != 0 {
		v3 := randStringContainerizer(r)
		this.SlavePid = &v3
	}
	if r.Intn(10) != 0 {
		v4 := bool(bool(r.Intn(2) == 0))
		this.Checkpoint = &v4
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedContainerizer(r, 9)
	}
	return this
}

func NewPopulatedUpdate(r randyContainerizer, easy bool) *Update {
	this := &Update{}
	this.ContainerId = NewPopulatedContainerID(r, easy)
	if r.Intn(10) != 0 {
		v5 := r.Intn(10)
		this.Resources = make([]*Resource, v5)
		for i := 0; i < v5; i++ {
			this.Resources[i] = NewPopulatedResource(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedContainerizer(r, 3)
	}
	return this
}

func NewPopulatedWait(r randyContainerizer, easy bool) *Wait {
	this := &Wait{}
	this.ContainerId = NewPopulatedContainerID(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedContainerizer(r, 2)
	}
	return this
}

func NewPopulatedDestroy(r randyContainerizer, easy bool) *Destroy {
	this := &Destroy{}
	this.ContainerId = NewPopulatedContainerID(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedContainerizer(r, 2)
	}
	return this
}

func NewPopulatedUsage(r randyContainerizer, easy bool) *Usage {
	this := &Usage{}
	this.ContainerId = NewPopulatedContainerID(r, easy)
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedContainerizer(r, 2)
	}
	return this
}

func NewPopulatedTermination(r randyContainerizer, easy bool) *Termination {
	this := &Termination{}
	v6 := bool(bool(r.Intn(2) == 0))
	this.Killed = &v6
	v7 := randStringContainerizer(r)
	this.Message = &v7
	if r.Intn(10) != 0 {
		v8 := int32(r.Int31())
		if r.Intn(2) == 0 {
			v8 *= -1
		}
		this.Status = &v8
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedContainerizer(r, 4)
	}
	return this
}

func NewPopulatedContainers(r randyContainerizer, easy bool) *Containers {
	this := &Containers{}
	if r.Intn(10) != 0 {
		v9 := r.Intn(10)
		this.Containers = make([]*ContainerID, v9)
		for i := 0; i < v9; i++ {
			this.Containers[i] = NewPopulatedContainerID(r, easy)
		}
	}
	if !easy && r.Intn(10) != 0 {
		this.XXX_unrecognized = randUnrecognizedContainerizer(r, 2)
	}
	return this
}

type randyContainerizer interface {
	Float32() float32
	Float64() float64
	Int63() int64
	Int31() int32
	Uint32() uint32
	Intn(n int) int
}

func randUTF8RuneContainerizer(r randyContainerizer) rune {
	ru := r.Intn(62)
	if ru < 10 {
		return rune(ru + 48)
	} else if ru < 36 {
		return rune(ru + 55)
	}
	return rune(ru + 61)
}
func randStringContainerizer(r randyContainerizer) string {
	v10 := r.Intn(100)
	tmps := make([]rune, v10)
	for i := 0; i < v10; i++ {
		tmps[i] = randUTF8RuneContainerizer(r)
	}
	return string(tmps)
}
func randUnrecognizedContainerizer(r randyContainerizer, maxFieldNumber int) (data []byte) {
	l := r.Intn(5)
	for i := 0; i < l; i++ {
		wire := r.Intn(4)
		if wire == 3 {
			wire = 5
		}
		fieldNumber := maxFieldNumber + r.Intn(100)
		data = randFieldContainerizer(data, r, fieldNumber, wire)
	}
	return data
}
func randFieldContainerizer(data []byte, r randyContainerizer, fieldNumber int, wire int) []byte {
	key := uint32(fieldNumber)<<3 | uint32(wire)
	switch wire {
	case 0:
		data = encodeVarintPopulateContainerizer(data, uint64(key))
		v11 := r.Int63()
		if r.Intn(2) == 0 {
			v11 *= -1
		}
		data = encodeVarintPopulateContainerizer(data, uint64(v11))
	case 1:
		data = encodeVarintPopulateContainerizer(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	case 2:
		data = encodeVarintPopulateContainerizer(data, uint64(key))
		ll := r.Intn(100)
		data = encodeVarintPopulateContainerizer(data, uint64(ll))
		for j := 0; j < ll; j++ {
			data = append(data, byte(r.Intn(256)))
		}
	default:
		data = encodeVarintPopulateContainerizer(data, uint64(key))
		data = append(data, byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)), byte(r.Intn(256)))
	}
	return data
}
func encodeVarintPopulateContainerizer(data []byte, v uint64) []byte {
	for v >= 1<<7 {
		data = append(data, uint8(uint64(v)&0x7f|0x80))
		v >>= 7
	}
	data = append(data, uint8(v))
	return data
}
func (m *Launch) Size() (n int) {
	var l int
	_ = l
	if m.ContainerId != nil {
		l = m.ContainerId.Size()
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.TaskInfo != nil {
		l = m.TaskInfo.Size()
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.ExecutorInfo != nil {
		l = m.ExecutorInfo.Size()
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.Directory != nil {
		l = len(*m.Directory)
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.User != nil {
		l = len(*m.User)
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.SlaveId != nil {
		l = m.SlaveId.Size()
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.SlavePid != nil {
		l = len(*m.SlavePid)
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.Checkpoint != nil {
		n += 2
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Update) Size() (n int) {
	var l int
	_ = l
	if m.ContainerId != nil {
		l = m.ContainerId.Size()
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if len(m.Resources) > 0 {
		for _, e := range m.Resources {
			l = e.Size()
			n += 1 + l + sovContainerizer(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Wait) Size() (n int) {
	var l int
	_ = l
	if m.ContainerId != nil {
		l = m.ContainerId.Size()
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Destroy) Size() (n int) {
	var l int
	_ = l
	if m.ContainerId != nil {
		l = m.ContainerId.Size()
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Usage) Size() (n int) {
	var l int
	_ = l
	if m.ContainerId != nil {
		l = m.ContainerId.Size()
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Termination) Size() (n int) {
	var l int
	_ = l
	if m.Killed != nil {
		n += 2
	}
	if m.Message != nil {
		l = len(*m.Message)
		n += 1 + l + sovContainerizer(uint64(l))
	}
	if m.Status != nil {
		n += 1 + sovContainerizer(uint64(*m.Status))
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func (m *Containers) Size() (n int) {
	var l int
	_ = l
	if len(m.Containers) > 0 {
		for _, e := range m.Containers {
			l = e.Size()
			n += 1 + l + sovContainerizer(uint64(l))
		}
	}
	if m.XXX_unrecognized != nil {
		n += len(m.XXX_unrecognized)
	}
	return n
}

func sovContainerizer(x uint64) (n int) {
	for {
		n++
		x >>= 7
		if x == 0 {
			break
		}
	}
	return n
}
func sozContainerizer(x uint64) (n int) {
	return sovContainerizer(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *Launch) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Launch{`,
		`ContainerId:` + strings.Replace(fmt.Sprintf("%v", this.ContainerId), "ContainerID", "ContainerID", 1) + `,`,
		`TaskInfo:` + strings.Replace(fmt.Sprintf("%v", this.TaskInfo), "TaskInfo", "TaskInfo", 1) + `,`,
		`ExecutorInfo:` + strings.Replace(fmt.Sprintf("%v", this.ExecutorInfo), "ExecutorInfo", "ExecutorInfo", 1) + `,`,
		`Directory:` + valueToStringContainerizer(this.Directory) + `,`,
		`User:` + valueToStringContainerizer(this.User) + `,`,
		`SlaveId:` + strings.Replace(fmt.Sprintf("%v", this.SlaveId), "SlaveID", "SlaveID", 1) + `,`,
		`SlavePid:` + valueToStringContainerizer(this.SlavePid) + `,`,
		`Checkpoint:` + valueToStringContainerizer(this.Checkpoint) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Update) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Update{`,
		`ContainerId:` + strings.Replace(fmt.Sprintf("%v", this.ContainerId), "ContainerID", "ContainerID", 1) + `,`,
		`Resources:` + strings.Replace(fmt.Sprintf("%v", this.Resources), "Resource", "Resource", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Wait) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Wait{`,
		`ContainerId:` + strings.Replace(fmt.Sprintf("%v", this.ContainerId), "ContainerID", "ContainerID", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Destroy) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Destroy{`,
		`ContainerId:` + strings.Replace(fmt.Sprintf("%v", this.ContainerId), "ContainerID", "ContainerID", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Usage) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Usage{`,
		`ContainerId:` + strings.Replace(fmt.Sprintf("%v", this.ContainerId), "ContainerID", "ContainerID", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Termination) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Termination{`,
		`Killed:` + valueToStringContainerizer(this.Killed) + `,`,
		`Message:` + valueToStringContainerizer(this.Message) + `,`,
		`Status:` + valueToStringContainerizer(this.Status) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func (this *Containers) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&Containers{`,
		`Containers:` + strings.Replace(fmt.Sprintf("%v", this.Containers), "ContainerID", "ContainerID", 1) + `,`,
		`XXX_unrecognized:` + fmt.Sprintf("%v", this.XXX_unrecognized) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringContainerizer(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *Launch) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerId == nil {
				m.ContainerId = &ContainerID{}
			}
			if err := m.ContainerId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field TaskInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.TaskInfo == nil {
				m.TaskInfo = &TaskInfo{}
			}
			if err := m.TaskInfo.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ExecutorInfo", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ExecutorInfo == nil {
				m.ExecutorInfo = &ExecutorInfo{}
			}
			if err := m.ExecutorInfo.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Directory", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Directory = &s
			iNdEx = postIndex
		case 5:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field User", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.User = &s
			iNdEx = postIndex
		case 6:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlaveId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.SlaveId == nil {
				m.SlaveId = &SlaveID{}
			}
			if err := m.SlaveId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		case 7:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field SlavePid", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.SlavePid = &s
			iNdEx = postIndex
		case 8:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Checkpoint", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Checkpoint = &b
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipContainerizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthContainerizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	return nil
}
func (m *Update) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerId == nil {
				m.ContainerId = &ContainerID{}
			}
			if err := m.ContainerId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Resources", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Resources = append(m.Resources, &Resource{})
			if err := m.Resources[len(m.Resources)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipContainerizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthContainerizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	return nil
}
func (m *Wait) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerId == nil {
				m.ContainerId = &ContainerID{}
			}
			if err := m.ContainerId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipContainerizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthContainerizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	return nil
}
func (m *Destroy) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerId == nil {
				m.ContainerId = &ContainerID{}
			}
			if err := m.ContainerId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipContainerizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthContainerizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	return nil
}
func (m *Usage) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field ContainerId", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			if m.ContainerId == nil {
				m.ContainerId = &ContainerID{}
			}
			if err := m.ContainerId.Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000001)
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipContainerizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthContainerizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("container_id")
	}

	return nil
}
func (m *Termination) Unmarshal(data []byte) error {
	var hasFields [1]uint64
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Killed", wireType)
			}
			var v int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			b := bool(v != 0)
			m.Killed = &b
			hasFields[0] |= uint64(0x00000001)
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				stringLen |= (uint64(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + intStringLen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			s := string(data[iNdEx:postIndex])
			m.Message = &s
			iNdEx = postIndex
			hasFields[0] |= uint64(0x00000002)
		case 3:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Status", wireType)
			}
			var v int32
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				v |= (int32(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			m.Status = &v
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipContainerizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthContainerizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}
	if hasFields[0]&uint64(0x00000001) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("killed")
	}
	if hasFields[0]&uint64(0x00000002) == 0 {
		return github_com_gogo_protobuf_proto.NewRequiredNotSetError("message")
	}

	return nil
}
func (m *Containers) Unmarshal(data []byte) error {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Containers", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				msglen |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthContainerizer
			}
			postIndex := iNdEx + msglen
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Containers = append(m.Containers, &ContainerID{})
			if err := m.Containers[len(m.Containers)-1].Unmarshal(data[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			var sizeOfWire int
			for {
				sizeOfWire++
				wire >>= 7
				if wire == 0 {
					break
				}
			}
			iNdEx -= sizeOfWire
			skippy, err := skipContainerizer(data[iNdEx:])
			if err != nil {
				return err
			}
			if skippy < 0 {
				return ErrInvalidLengthContainerizer
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			m.XXX_unrecognized = append(m.XXX_unrecognized, data[iNdEx:iNdEx+skippy]...)
			iNdEx += skippy
		}
	}

	return nil
}
func skipContainerizer(data []byte) (n int, err error) {
	l := len(data)
	iNdEx := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := data[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for {
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if data[iNdEx-1] < 0x80 {
					break
				}
			}
			return iNdEx, nil
		case 1:
			iNdEx += 8
			return iNdEx, nil
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := data[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			iNdEx += length
			if length < 0 {
				return 0, ErrInvalidLengthContainerizer
			}
			return iNdEx, nil
		case 3:
			for {
				var innerWire uint64
				var start int = iNdEx
				for shift := uint(0); ; shift += 7 {
					if iNdEx >= l {
						return 0, io.ErrUnexpectedEOF
					}
					b := data[iNdEx]
					iNdEx++
					innerWire |= (uint64(b) & 0x7F) << shift
					if b < 0x80 {
						break
					}
				}
				innerWireType := int(innerWire & 0x7)
				if innerWireType == 4 {
					break
				}
				next, err := skipContainerizer(data[start:])
				if err != nil {
					return 0, err
				}
				iNdEx = start + next
			}
			return iNdEx, nil
		case 4:
			return iNdEx, nil
		case 5:
			iNdEx += 4
			return iNdEx, nil
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
	}
	panic("unreachable")
}

var (
	ErrInvalidLengthContainerizer = fmt.Errorf("proto: negative length found during unmarshaling")
)
