/*
  Copyright (c) 2007-2014 Red Hat, Inc. <http://www.redhat.com>
  This file is part of GlusterFS.

  This file is licensed to you under your choice of the GNU Lesser
  General Public License, version 3 or any later version (LGPLv3 or
  later), or the GNU General Public License, version 2 (GPLv2), in all
  cases as published by the Free Software Foundation.
*/

#include "compat.h"
#include "xdr-common.h"
#include "xdr-nfs3.h"

#if defined(__GNUC__)
#if __GNUC__ >= 4
#if !defined(__clang__)
#if !defined(__NetBSD__)
#pragma GCC diagnostic ignored "-Wunused-but-set-variable"
#pragma GCC diagnostic ignored "-Wunused-variable"
#endif
#else
#pragma clang diagnostic ignored "-Wunused-variable"
#pragma clang diagnostic ignored "-Wunused-value"
#endif
#endif
#endif

/*
 * Please do not edit this file.
 * It was generated using rpcgen.
 */

#ifndef _NSM_XDR_H_RPCGEN
#define _NSM_XDR_H_RPCGEN

#include <rpc/rpc.h>


#ifdef __cplusplus
extern "C" {
#endif

#define SM_MAXSTRLEN 1024

struct sm_name {
	char *mon_name;
};
typedef struct sm_name sm_name;

enum res {
	STAT_SUCC = 0,
	STAT_FAIL = 1,
};
typedef enum res res;

struct sm_stat_res {
	res res_stat;
	int state;
};
typedef struct sm_stat_res sm_stat_res;

struct sm_stat {
	int state;
};
typedef struct sm_stat sm_stat;

struct my_id {
	char *my_name;
	int my_prog;
	int my_vers;
	int my_proc;
};
typedef struct my_id my_id;

struct mon_id {
	char *mon_name;
	struct my_id my_id;
};
typedef struct mon_id mon_id;

struct mon {
	struct mon_id mon_id;
	char priv[16];
};
typedef struct mon mon;

struct nsm_callback_status {
	char *mon_name;
	int state;
	char priv[16];
};
typedef struct nsm_callback_status nsm_callback_status;

/* the xdr functions */

#if defined(__STDC__) || defined(__cplusplus)
extern  bool_t xdr_sm_name (XDR *, sm_name*);
extern  bool_t xdr_res (XDR *, res*);
extern  bool_t xdr_sm_stat_res (XDR *, sm_stat_res*);
extern  bool_t xdr_sm_stat (XDR *, sm_stat*);
extern  bool_t xdr_my_id (XDR *, my_id*);
extern  bool_t xdr_mon_id (XDR *, mon_id*);
extern  bool_t xdr_mon (XDR *, mon*);
extern  bool_t xdr_nsm_callback_status (XDR *, nsm_callback_status*);

#else /* K&R C */
extern bool_t xdr_sm_name ();
extern bool_t xdr_res ();
extern bool_t xdr_sm_stat_res ();
extern bool_t xdr_sm_stat ();
extern bool_t xdr_my_id ();
extern bool_t xdr_mon_id ();
extern bool_t xdr_mon ();
extern bool_t xdr_nsm_callback_status ();

#endif /* K&R C */

#ifdef __cplusplus
}
#endif

#endif /* !_NSM_XDR_H_RPCGEN */
