/*
 * dsyslog - a dumb syslog (e.g. syslog for people who have a clue)
 * Copyright (c) 2008 William Pitcock <nenolod@sacredspiral.co.uk>
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice is present in all copies.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef __DSYSLOG_COND_INCLUDE_RECURSION_GUARD
#define __DSYSLOG_COND_INCLUDE_RECURSION_GUARD

#include "dsyslog_event.h"

/* Logging conditionals. */
typedef struct dsyslog_cond_ dsyslog_cond_t;
typedef gboolean (*dsyslog_cond_eval_t)(dsyslog_event_t *event, dsyslog_cond_t *cond);
typedef void (*dsyslog_cond_destructor_t)(dsyslog_cond_t *cond);

struct dsyslog_cond_ {
	gchar *type;
	gchar *cond;
	gchar *value;
	gpointer opaque;
	dsyslog_cond_eval_t evaluator;
	dsyslog_cond_destructor_t destructor;
};

extern void dsyslog_cond_type_register(gchar *type, dsyslog_cond_eval_t hdl);
extern void dsyslog_cond_type_unregister(gchar *type);
extern GList *dsyslog_cond_add(GList *conditions, dsyslog_cond_t *cond);
extern GList *dsyslog_cond_remove(GList *conditions, dsyslog_cond_t *cond);
extern gboolean dsyslog_cond_process(dsyslog_event_t *event, GList *conditions);

#endif
