//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
//
// copyright            : (C) 2013 by Eran Ifrah
// file name            : renamefiledlg.h
//
// -------------------------------------------------------------------------
// A
//              _____           _      _     _ _
//             /  __ \         | |    | |   (_) |
//             | /  \/ ___   __| | ___| |    _| |_ ___
//             | |    / _ \ / _  |/ _ \ |   | | __/ _ )
//             | \__/\ (_) | (_| |  __/ |___| | ||  __/
//              \____/\___/ \__,_|\___\_____/_|\__\___|
//
//                                                  F i l e
//
//    This program is free software; you can redistribute it and/or modify
//    it under the terms of the GNU General Public License as published by
//    the Free Software Foundation; either version 2 of the License, or
//    (at your option) any later version.
//
//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

#ifndef __renamefiledlg__
#define __renamefiledlg__

/**
@file
Subclass of RenameFileBaseDlg, which is generated by wxFormBuilder.
*/

#include "codelite_exports.h"
#include "include_finder.h"
#include "renamefilebasedlg.h"

#include <map>

/** Implementing RenameFileBaseDlg */
class WXDLLIMPEXP_SDK RenameFileDlg : public RenameFileBaseDlg
{
    std::map<int, IncludeStatement> m_entries;

protected:
    // Handlers for RenameFileBaseDlg events.
    void OnFileSelected(wxCommandEvent& event);
    void DoSelectItem(int idx);

public:
    /** Constructor */
    RenameFileDlg(wxWindow* parent, const wxString& replaceWith, std::vector<IncludeStatement>& matches);
    virtual ~RenameFileDlg();
    std::vector<IncludeStatement> GetMatches() const;
    wxString GetReplaceWith() const;
};

#endif // __renamefiledlg__
