<?php
/*
 +--------------------------------------------------------------------+
 | Copyright CiviCRM LLC. All rights reserved.                        |
 |                                                                    |
 | This work is published under the GNU AGPLv3 license with some      |
 | permitted exceptions and without any warranty. For full license    |
 | and copyright information, see https://civicrm.org/licensing       |
 +--------------------------------------------------------------------+
 */

/**
 *
 * @package CRM
 * @copyright CiviCRM LLC https://civicrm.org/licensing
 */
interface CRM_Report_Interface {

  /**
   * The constructor gets the submitted form values.
   *
   * @param array $formValues
   */
  public function __construct(&$formValues);

  /**
   * Builds the quickform for this search.
   *
   * @param CRM_Core_Form $form
   */
  public function buildForm(&$form);

  /**
   * Builds the search query for various cases. We break it down into finer cases
   * since you can optimize each query independently. All the functions below return
   * a sql clause with only SELECT, FROM, WHERE sub-parts. The ORDER BY and LIMIT is
   * added at a later stage
   */

  /**
   * Count of records that match the current input parameters Used by pager.
   */
  public function count();

  /**
   * Summary information for the query that can be displayed in the template.
   *
   * This is useful to pass total / sub total information if needed
   */
  public function summary();

  /**
   * Get contact IDs.
   *
   * List of contact ids that match the current input parameters
   * Used by different tasks. Will be also used to optimize the
   * 'all' query below to avoid excessive LEFT JOIN blowup
   *
   * @param int $offset
   * @param int $rowcount
   * @param string $sort
   */
  public function contactIDs($offset = 0, $rowcount = 0, $sort = NULL);

  /**
   * Retrieve all the values that match the current input parameters used by the selector.
   *
   * @param int $offset
   * @param int $rowcount
   * @param string $sort
   * @param bool $includeContactIDs
   */
  public function all(
    $offset = 0, $rowcount = 0, $sort = NULL,
    $includeContactIDs = FALSE
  );

  /**
   * The below two functions (from and where) are ONLY used if you want to
   * expose a custom group as a smart group and be able to send a mailing
   * to them via CiviMail. civicrm_email should be part of the from clause
   * The from clause should be a valid sql from clause including the word FROM
   * CiviMail will pick up the contacts where the email is primary and
   * is not on hold / opt out / do not email
   */

  /**
   * The from clause for the query.
   */
  public function from();

  /**
   * The where clause for the query.
   *
   * @param bool $includeContactIDs
   */
  public function where($includeContactIDs = FALSE);

  /**
   * The template FileName to use to display the results.
   */
  public function templateFile();

  /**
   * Returns an array of column headers and field names and sort options.
   */
  public function &columns();

}
