//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Tests/Functional/GUIProjectCompatibility/GUIprojects.cpp
//! @brief     Defines functions to test projects compatibility.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2023
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#include "BATesting.h"
#include "GUI/View/Project/ProjectManager.h"
#include "Tests/GTestWrapper/google_test.h"
#include <filesystem>

namespace fs = std::filesystem;

namespace {

// The test consists in just opening the old project file. There is no explicit test case. We just
// check whether the function executes without throwing an exception.
void openProject(const std::string& project_name)
{
    const auto path = fs::path(BATesting::GuiProjectsDir) / fs::path(project_name)
                      / fs::path(project_name + ".ba");
    ProjectManager pm(nullptr);
    EXPECT_NO_THROW(pm.openProject(QString::fromStdString(path.string())));
}

} // namespace

//  ************************************************************************************************
//  tests
//  ************************************************************************************************

TEST(GUIProjectCompatibility, v20_0)
{
    openProject("v20_0");
}

TEST(GUIProjectCompatibility, v20_2)
{
    openProject("v20_2");
}

TEST(GUIProjectCompatibility, v21_0)
{
    openProject("v21_0");
}
